@name Pipe Not Found
@category runtime
@videoUrl https://www.youtube.com/embed/maI2u6Sxk9M
@videoCaption Note: The video predates standalone pipes, please refer to additional instructions below if you use standalone pipes.
@shortDescription Pipe not found!

@description
Angular can't find a pipe with this name.

The pipe referenced in the template has not been named or declared properly.

In order for a [pipe](guide/pipes) to be used:
 - it must be declared as a part of an `NgModule` (added to the `declarations` array) or marked as standalone (by adding the `standalone: true` flag to the Pipe decorator).
 - it must be imported in an `NgModule` or a standalone component where it is used.
 - the name used in a template must match the name defined in the Pipe decorator.

@debugging
Use the pipe name to trace where the pipe is declared and used.

To resolve this error, ensure that:
 - If the pipe is local to the `NgModule`, it is uniquely named in the pipe's decorator and declared in the `NgModule`.
 - If the pipe is standalone or from another `NgModule`, it is added to the `imports` field of the current `NgModule` or standalone component.

If you recently added an import or declaration, you may need to restart your server to see these changes.

<!-- links -->

<!-- external links -->

<!-- end links -->

@reviewed 2022-05-22
