@name Argument Not Literal
@category compiler
@shortDescription Decorator argument is not an object literal

@description
To make the metadata extraction in the Angular compiler faster, the decorators `@NgModule`, `@Pipe`, `@Component`, `@Directive`, and `@Injectable` accept only object literals as arguments.

This is an [intentional change in Ivy](https://github.com/angular/angular/issues/30840#issuecomment-498869540), which enforces stricter argument requirements for decorators than View Engine.
Ivy requires this approach because it compiles decorators by moving the expressions into other locations in the class output.

@debugging
Move all declarations:

<code-example format="typescript" language="typescript">

const moduleDefinition = {&hellip;}

&commat;NgModule(moduleDefinition)
export class AppModule {
    constructor() {}
}

</code-example>

into the decorator:

<code-example format="typescript" language="typescript">

&commat;NgModule({&hellip;})
export class AppModule {
    constructor() {}
}

</code-example>

<!-- links -->

<!-- external links -->

<!-- end links -->

@reviewed 2022-02-28
