@name Missing control flow directive

@description

This diagnostics ensures that a standalone component which uses known control flow directives
(such as `*ngIf`, `*ngFor`, `*ngSwitch`) in a template, also imports those directives either
individually or by importing the `CommonModule`.

<code-example format="typescript" language="typescript">

import {Component} from '&commat;angular/core';

&commat;Component({
  standalone: true,
  // Template uses `*ngIf`, but no corresponding directive imported.
  template: `&lt;div *ngIf="visible"&gt;Hi&lt;/div&gt;`,
  // &hellip;
})
class MyComponent {}

</code-example>

## How to fix the problem

Make sure that a corresponding control flow directive is imported.

A directive can be imported individually:

<code-example format="typescript" language="typescript">

import {Component} from '&commat;angular/core';
import {NgIf} from '&commat;angular/common';

&commat;Component({
  standalone: true,
  imports: [NgIf],
  template: `&lt;div *ngIf="visible"&gt;Hi&lt;/div&gt;`,
  // &hellip;
})
class MyComponent {}

</code-example>

or you could import the entire `CommonModule`, which contains all control flow directives:

<code-example format="typescript" language="typescript">

import {Component} from '&commat;angular/core';
import {CommonModule} from '&commat;angular/common';

&commat;Component({
  standalone: true,
  imports: [CommonModule],
  template: `&lt;div *ngIf="visible"&gt;Hi&lt;/div&gt;`,
  // &hellip;
})
class MyComponent {}

</code-example>


<!-- links -->

<!-- external links -->

<!-- end links -->

@reviewed 2022-02-28
