@name Text attribute not binding

@description

This diagnostic ensures that attributes which have the "special" Angular binding prefix (`attr.`, `style.`, and
`class.`) are interpreted as bindings. For example, `<div attr.id="my-id"></div>` will not
interpret this as an attribute binding to `id` but rather just a regular attribute and will appear
as-is in the final HTML (`<div attr.id="my-id"></div>`). This is likely not the intent of the developer.
Instead, the intent is likely to have the `id` be set to 'my-id' (`<div id="my-id"></div>`).

## What should I do instead?

When binding to `attr.`, `class.`, or `style.`, ensure you use the Angular template binding syntax.

<pre>
  &lt;div [attr.id]="my-id">&lt;/div>
  &lt;div [style.color]="red">&lt;/div>
  &lt;div [class.blue]="true">&lt;/div>
</pre>


## What if I can't avoid this?

This diagnostic can be disabled by editing the project's `tsconfig.json` file:

<code-example format="json" language="json">

{
  "angularCompilerOptions": {
    "extendedDiagnostics": {
      "checks": {
        "textAttributeNotBinding": "suppress"
      }
    }
  }
}

</code-example>

See [extended diagnostic configuration](extended-diagnostics#configuration) for more info.

<!-- links -->

<!-- external links -->

<!-- end links -->

@reviewed 2022-11-30
