@name Missing `let` keyword in an *ngFor expression

@description

This diagnostic is emitted when an expression used in `*ngFor` is missing the `let` keyword.

<code-example format="typescript" language="typescript">

import {Component} from '&commat;angular/core';

&commat;Component({
  // The `let` keyword is missing in the `*ngFor` expression.
  template: `&lt;div *ngFor="item of items"&gt;{{ item }}&lt;/div&gt;`,
  // &hellip;
})
class MyComponent {
  items = [1, 2, 3];
}

</code-example>

## How to resolve the problem

Add the missing `let` keyword.

<code-example format="typescript" language="typescript">

import {Component} from '&commat;angular/core';

&commat;Component({
  // The `let` keyword is now present in the `*ngFor` expression,
  // no diagnostic messages are emitted in this case.
  template: `&lt;div *ngFor="let item of items"&gt;{{ item }}&lt;/div&gt;`,
  // &hellip;
})
class MyComponent {
  items = [1, 2, 3];
}

</code-example>

<!-- links -->

<!-- external links -->

<!-- end links -->

@reviewed 2022-12-01
