@name Suffix not supported

@description

This diagnostic detects when the `.px`, `.%`, and `.em` suffixes are used with an attribute
binding. These suffixes are only available for style bindings.

<code-example format="html" language="html">

&lt;div [attr.width.px]="5"&gt;&lt;/div&gt;

</code-example>

## What should I do instead?

Rather than using the `.px`, `.%`, or `.em` suffixes that are only supported in style bindings,
move this to the value assignment of the binding.

<code-example format="html" language="html">
  
&lt;div [attr.width]="'5px'"&gt;&lt;/div&gt;

</code-example>

## What if I can't avoid this?

This diagnostic can be disabled by editing the project's `tsconfig.json` file:

<code-example format="json" language="json">

{
  "angularCompilerOptions": {
    "extendedDiagnostics": {
      "checks": {
        "suffixNotSupported": "suppress"
      }
    }
  }
}

</code-example>

See [extended diagnostic configuration](extended-diagnostics#configuration) for more info.

<!-- links -->

<!-- external links -->

<!-- end links -->

@reviewed 2022-02-28
