# Angular developer guides

As an application framework, Angular includes a collection of well-integrated libraries that cover a wide variety of features.

The Angular libraries include routing, forms management, client-server communication, and more.

This topic lists the various developer guides for you to learn more about these Angular features and to help you determine the correct use of each in your application.

## Prerequisites

To get the most out of these developer guides, you should review the following topics:

*   [What is Angular][AioGuideWhatIsAngular]
*   [Getting started tutorial][AioStart]
*   [Understanding Angular][AioGuideUnderstandingAngularOverview]

## Learn about Angular's features

<div class="card-container">
  <a href="guide/routing-overview" class="docs-card" title="Routing and navigation developer guide">
    <section>Routing and Navigation</section>
    <p>Learn how to use the Angular router to handle page navigation and other tasks.</p>
    <p class="card-footer">Router</p>
  </a>
  <a href="guide/forms-overview" class="docs-card" title="Angular forms developer guide">
    <section>Forms</section>
    <p>Learn about the two approaches to forms in Angular: template-driven and reactive.</p>
    <p class="card-footer">Forms</p>
  </a>
  <a href="guide/http" class="docs-card" title="Angular HTTP client developer guide">
    <section>HTTP</section>
    <p>Learn how to connect to a server using the HTTP client service in Angular.</p>
    <p class="card-footer">HTTP client</p>
  </a>
  <a href="guide/testing" class="docs-card" title="Angular testing developer guide">
    <section>Testing</section>
    <p>Learn about tips and techniques for testing Angular applications.</p>
    <p class="card-footer">Testing</p>
  </a>
  <a href="guide/i18n-overview" class="docs-card" title="Angular internationalization developer guide">
    <section>Internationalization</section>
    <p>Learn how to localize your Angular application.</p>
    <p class="card-footer">i18n and &dollar;localize</p>
  </a>
  <a href="guide/animations" class="docs-card" title="Angular animations developer guide">
    <section>Animations</section>
    <p>Learn about how to add an animation to your Angular application.</p>
    <p class="card-footer">Animations</p>
  </a>
  <a href="guide/service-worker-intro" class="docs-card" title="Angular service worker developer guide">
    <section>Service Workers and PWA</section>
    <p>Learn about how to use a service worker to create a progressive web application.</p>
    <p class="card-footer">Service workers and PWA</p>
  </a>
  <a href="guide/web-worker" class="docs-card" title="Web Workers">
    <section>Web Workers</section>
    <p>Learn more about how to use a web worker to run a CPU-intensive computation in a background thread.</p>
    <p class="card-footer">Web Workers</p>
  </a>
  <a href="guide/universal" class="docs-card" title="Server-side rendering">
    <section>Server-side rendering</section>
    <p>Learn more about how to use Angular Universal to create a static application page.</p>
    <p class="card-footer">Server-side rendering</p>
  </a>
  <a href="guide/prerendering" class="docs-card" title="Pre-rendering">
    <section>Pre-rendering</section>
    <p>Learn about how to use pre-rendering to process a dynamic page at build time.</p>
    <p class="card-footer">Pre-rendering</p>
  </a>
</div>

<!-- links -->

[AioGuideUnderstandingAngularOverview]: guide/understanding-angular-overview "Understanding Angular | Angular"

[AioGuideWhatIsAngular]: guide/what-is-angular "What is Angular\? | Angular"

[AioStart]: start "Getting started with Angular | Angular"

<!-- external links -->

<!-- end links -->

@reviewed 2021-11-05
