# Select a documentation issue

This topic describes how to select an Angular documentation issue to fix.

Angular documentation issues are stored in the **Issues** tab of the [angular/angular](https://github.com/angular/angular) repo.
Documentation issues can be identified by the `area: docs` label and they are labeled by priority.

You are welcome to work on [any issue](#links-to-documentation-issues) that someone else isn't already working on.
If you know of a problem in the documentation that hasn't been reported, you can also [create a new documentation issue](https://github.com/angular/angular/issues/new?assignees=&labels=&template=3-docs-bug.yaml).

Some things to consider when choosing an issue to fix include:

*   Fixing higher priority issues is more valuable to the community.
*   If you're new to open source software, a lower priority issue or a `good first issue` would be a good place to start.
*   Every contribution helps improve the documentation.

After you select an issue to resolve:

1.  In the issue page, add `working on fix` as a comment to let others know that you are working on it.
1.  Continue to [Starting to edit a documentation topic](guide/doc-update-start).

<a id="links-to-documentation-issues"/>

| Links to documentation issues |
|:---                           |
| [All open documentation issues](https://github.com/angular/angular/issues?q=is%3Aissue+is%3Aopen+label%3A%22area%3A+docs%22)                                  |
| [All open and unassigned documentation issues](https://github.com/angular/angular/issues?q=is%3Aissue+is%3Aopen+label%3A%22area%3A+docs%22+no%3Aassignee+-label%3A"state%3A+has+PR")                                  |
| [Unassigned good first documentation issues](https://github.com/angular/angular/issues?q=is%3Aissue+is%3Aopen+label%3A%22area%3A+docs%22+label%3A%22good+first+issue%22+no%3Aassignee+-label%3A"state%3A+has+PR") |
| [Unassigned priority 1 documentation issues](https://github.com/angular/angular/issues?q=is%3Aissue+is%3Aopen+label%3A%22area%3A+docs%22+label%3Ap1+no%3Aassignee+-label%3A"state%3A+has+PR")                     |
| [Unassigned priority 2 documentation issues](https://github.com/angular/angular/issues?q=is%3Aissue+is%3Aopen+label%3A%22area%3A+docs%22+label%3Ap2+no%3Aassignee+-label%3A"state%3A+has+PR")                     |
| [Unassigned priority 3 documentation issues](https://github.com/angular/angular/issues?q=is%3Aissue+is%3Aopen+label%3A%22area%3A+docs%22+label%3Ap3+no%3Aassignee+-label%3A"state%3A+has+PR")                     |
| [Unassigned priority 4 documentation issues](https://github.com/angular/angular/issues?q=is%3Aissue+is%3Aopen+label%3A%22area%3A+docs%22+label%3Ap4+no%3Aassignee+-label%3A"state%3A+has+PR")                     |
| [Unassigned priority 5 documentation issues](https://github.com/angular/angular/issues?q=is%3Aissue+is%3Aopen+label%3A%22area%3A+docs%22+label%3Ap5+no%3Aassignee+-label%3A"state%3A+has+PR")                     |

<!-- links -->

<!-- external links -->

<!-- end links -->

@reviewed 2022-10-12
