# Overview of documentation maintenance tasks

The Angular documentation needs routine maintenance to keep it up-to-date.
The topics in this section describe routine maintenance tasks that you can perform to help keep the Angular documentation in good condition.

Documentation maintenance tasks fall into these two categories:

*   Minor changes
*   Major changes

Minor changes can be made in the GitHub site without the need to load any software or tools on your system.
For information about making a minor change to the documentation, see [Make a minor change](guide/contributors-guide-overview#make-a-minor-change).

Major changes require that you build and test your changes to the documentation on your local computer before you send them to the Angular documentation.
For information about preparing your system to make major changes to the documentation, see [Make a major change](guide/contributors-guide-overview#make-a-major-change).

## Routine documentation maintenance tasks

| Task                                                     | Scope |
|:---                                                      |:---   |
| [Review current documentation](guide/reviewing-content)  | Minor \(See note\) |
| [Update search keywords](guide/updating-search-keywords) | Minor       |
| [Resolve linter errors](guide/docs-lint-errors)          | Major       |
| [Resolve documentation issues](guide/doc-select-issue)   | Major       |

<div class="alert is-helpful">

**NOTE**: <br />
Reviewing current documentation requires a minor change if all you need to do is update the `@reviewed`   date.
If you find a minor problem with a documentation topic, such as a typo, fixing it during your review is also a minor change.

If you find an issue that you don't feel comfortable fixing, [open a docs issue](https://github.com/angular/angular/issues/new?assignees=&labels=&template=3-docs-bug.yaml) in GitHub so someone else can fix it.

</div>

<!-- links -->

<!-- external links -->

<!-- end links -->

@reviewed 2022-10-12
