# Frequently-used modules

An Angular application needs at least one module that serves as the root module.
As you add features to your app, you can add them in modules.
The following are frequently used Angular modules with examples of some of the things they contain:

| NgModule              | Import it from              | Why you use it |
|:---                   |:---                         |:---            |
| `BrowserModule`       | `@angular/platform-browser` | To run your application in a browser.                  |
| `CommonModule`        | `@angular/common`           | To use `NgIf` and `NgFor`.                             |
| `FormsModule`         | `@angular/forms`            | To build template driven forms \(includes `NgModel`\). |
| `ReactiveFormsModule` | `@angular/forms`            | To build reactive forms.                               |
| `RouterModule`        | `@angular/router`           | To use `RouterLink`, `.forRoot()`, and `.forChild()`.  |
| `HttpClientModule`    | `@angular/common/http`      | To communicate with a server using the HTTP protocol.  |

## Importing modules

When you use these Angular modules, import them in `AppModule`, or your feature module as appropriate, and list them in the `@NgModule` `imports` array.
For example, in the basic application generated by the [Angular CLI](cli), `BrowserModule` is the first import at the top of the `AppModule`, `app.module.ts`.

<code-example format="typescript" language="typescript">

/* import modules so that AppModule can access them */
import { BrowserModule } from '&commat;angular/platform-browser';
import { NgModule } from '&commat;angular/core';

import { AppComponent } from './app.component';

&commat;NgModule({
  declarations: [
    AppComponent
  ],
  imports: [ /* add modules here so Angular knows to use them */
    BrowserModule,
  ],
  providers: [],
  bootstrap: [AppComponent]
})
export class AppModule { }

</code-example>

The imports at the top of the array are JavaScript import statements while the `imports` array within `@NgModule` is Angular specific.
For more information on the difference, see [JavaScript Modules vs. NgModules](guide/ngmodule-vs-jsmodule).

## `BrowserModule` and `CommonModule`

`BrowserModule` imports `CommonModule`, which contributes many common directives such as `ngIf` and `ngFor`.
Additionally, `BrowserModule` re-exports `CommonModule` making all of its directives available to any module that imports `BrowserModule`.

For applications that run in the browser, import `BrowserModule` in the root `AppModule` because it provides services that are essential to launch and run a browser application.
`BrowserModule`'s providers are for the whole application so it should only be in the root module, not in feature modules.
Feature modules only need the common directives in `CommonModule`; they don't need to re-install app-wide providers.

If you do import `BrowserModule` into a lazy loaded feature module, Angular returns an error telling you to use `CommonModule` instead.

<div class="lightbox">

<img alt="BrowserModule error" src="generated/images/guide/frequent-ngmodules/browser-module-error.gif" width=750>

</div>

## More on NgModules

You may also be interested in the following:

*   [Bootstrapping](guide/bootstrapping)
*   [NgModules](guide/ngmodules)
*   [JavaScript Modules vs. NgModules](guide/ngmodule-vs-jsmodule)

<!-- links -->

<!-- external links -->

<!-- end links -->

@reviewed 2022-02-28
