# Optional Internationalization practices

The following optional topics help you manually configure the internationalization settings of your application.
The optional practices are meant for advanced or custom Angular applications.

## Prerequisites

To prepare your project for translations, you should have a basic understanding of the following subjects.

*   [Templates][AioGuideGlossaryTemplate]
*   [Components][AioGuideGlossaryComponent]
*   [Angular CLI][AioCliMain] [command-line][AioGuideGlossaryCommandLineInterfaceCli] tool for managing the Angular development cycle
*   [Extensible Markup Language (XML)][W3Xml] used for translation files

## Learn about optional Angular internationalization practices

<div class="card-container">
    <a href="guide/i18n-optional-manual-runtime-locale" class="docs-card" title="Set the runtime locale manually">
        <section>Set the runtime locale manually</section>
        <p>Learn how to change the runtime locale for your project</p>
        <p class="card-footer">Set the runtime locale manually</p>
    </a>
    <a href="guide/i18n-optional-import-global-variants" class="docs-card" title="Import global variants of the locale data">
        <section>Import global variants of the locale data</section>
        <p>Learn how to import locale data for language variants</p>
        <p class="card-footer">Import global variants of the locale data</p>
    </a>
    <a href="guide/i18n-optional-manage-marked-text" class="docs-card" title="Manage marked text with custom IDs">
        <section>Manage marked text with custom IDs</section>
        <p>Learn how to implement custom IDs to help you manage your marked text</p>
        <p class="card-footer">Manage marked text with custom IDs</p>
    </a>
</div>

<!-- links -->

[AioCliMain]: cli "CLI Overview and Command Reference | Angular"

[AioGuideGlossaryCommandLineInterfaceCli]: guide/glossary#command-line-interface-cli "command-line interface (CLI) - Glossary | Angular"
[AioGuideGlossaryComponent]: guide/glossary#component "component - Glossary | Angular"
[AioGuideGlossaryTemplate]: guide/glossary#template "template - Glossary | Angular"

[AioGuideI18nOptionalManageMarkedText]: guide/i18n-optional-manage-marked-text "Manage marked text with custom IDs | Angular"
[AioGuideI18nOptionalImportGlobalVariants]: guide/i18n-optional-import-global-variants "Import global variants of the locale data | Angular"
[AioGuideI18nOptionalManualRuntimeLocale]: guide/i18n-optional-runtime-source-locale "Set the runtime locale manually | Angular"

<!-- external links -->

[W3Xml]: https://www.w3.org/XML "Extensible Markup Language (XML) | W3C"

<!-- end links -->

@reviewed 2021-10-28
