# Angular Internationalization

{@searchKeywords i18n}

*Internationalization*, sometimes referenced as i18n, is the process of designing and preparing your project for use in different locales around the world.
*Localization* is the process of building versions of your project for different locales.
The localization process includes the following actions.

*   Extract text for translation into different languages
*   Format data for a specific locale

A *locale* identifies a region in which people speak a particular language or language variant.
Possible regions includes countries and geographical regions.
A locale determines the formatting and parsing of the following details.

*   Measurement units including date and time, numbers, and currencies
*   Translated names including time zones, languages, and countries

For a quick introduction to localization and internationalization watch this video:

<div class="video-container">

<iframe allow="accelerometer; encrypted-media; gyroscope; picture-in-picture" allowfullscreen frameborder="0" src="https://www.youtube.com/embed/KNTN-nsbV7M"></iframe>

</div>

## Learn about Angular internationalization

<div class="card-container">
    <a href="guide/i18n-common-overview" class="docs-card" title="Common internationalization tasks">
        <section>Common tasks</section>
        <p>Learn how to implement many of the common tasks associated with Angular internationalization.</p>
        <p class="card-footer">Common internationalization tasks</p>
    </a>
    <a href="guide/i18n-optional-overview" class="docs-card" title="Optional internationalization tasks">
        <section>Optional practices</section>
        <p>Learn how to implement optional practices associated with Angular internationalization.</p>
        <p class="card-footer">Optional internationalization practices</p>
    </a>
    <a href="guide/i18n-example" class="docs-card" title="Internationalization example">
        <section>Internationalization example</section>
        <p>Review an example of Angular internationalization.</p>
        <p class="card-footer">Example Angular Internationalization application</p>
    </a>
</div>

<!-- links -->

<!-- external links -->

<!-- end links -->

@reviewed 2022-06-06
