# Angular documentation localization guidelines

One way to contribute to Angular's documentation is to localize it into another language.
This topic describes what you need to know to localize Angular and have it listed on our [Localized documentation](guide/localized-documentation) page.

## Before you begin

Before you start localizing the Angular documentation, first check to see if a localized version already exists.
See [Localized documentation](guide/localized-documentation) for a current list of localized versions of Angular documentation.

## Getting started

To have a localized version of Angular documentation listed on [angular.io](https://angular.io), you must either:

*   Be an Angular [Google Developer Expert (GDE)](https://developers.google.com/community/experts)
*   Have an Angular GDE nominate you for localizing the content

Nomination, in this instance, means that the GDE knows who you are and can vouch for your capabilities.
An Angular GDE can nominate someone by contacting the Angular team, providing your name, contact information, and the language to which you are localizing.

## What to localize

To localize Angular documentation, you must include, at a minimum, the following topics:

*   [Introduction to the Angular docs](docs)
*   [What is Angular?](guide/what-is-angular)
*   [Getting started with Angular](start)
    *   [Adding navigation](start/start-routing)
    *   [Managing data](start/start-data)
    *   [Using forms for user input](start/start-forms)
    *   [Deploying an application](start/start-deployment)
    *   [Setting up the local environment and workspace](guide/setup-local)
*   [Tour of Heroes app and tutorial](tutorial/tour-of-heroes)
    *   [Create a new project](tutorial/tour-of-heroes/toh-pt0)
    *   [The hero editor](tutorial/tour-of-heroes/toh-pt1)
    *   [Display a selection list](tutorial/tour-of-heroes/toh-pt2)
    *   [Create a feature component](tutorial/tour-of-heroes/toh-pt3)
    *   [Add services](tutorial/tour-of-heroes/toh-pt4)
    *   [Add navigation with routing](tutorial/tour-of-heroes/toh-pt5)
    *   [Get data from a server](tutorial/tour-of-heroes/toh-pt6)

Because these topics reflect the minimum documentation set for localization, the Angular documentation team takes special precautions when making any changes to these topics.
Specifically:

*   The Angular team carefully assesses any incoming pull requests or issues to determine their impact on localized content.
*   If the Angular team incorporates changes into these topics, the Angular team will communicate those changes to members of the localization community.
    See the section, [Communications](#communications), for more information.

## Hosting

Individuals and teams that localize Angular documentation assume responsibility for hosting their localized site.
The Angular team does not host localized content.
The Angular team is also not responsible for providing domain names.

## Awareness

As part of the localization effort, the Angular documentation team adds localized documentation to the [Localized documentation](guide/localized-documentation) page.
This topic lists:

*   The language of the localized documentation
*   The URL for the localized documentation

The Angular team can remove a link on this page for any reason, including but not limited to:

*   Inability to contact the individual or team
*   Issues or complaints about the documentation that go unaddressed

## Communications

The Angular documentation team uses a Slack channel to communicate with members of the community focused on localization efforts.
After receiving a nomination to localize content, an individual or team can contact the Angular team to get access to this Slack channel.

The Angular documentation team may also conduct meetings to discuss localization efforts.
For example:

*   To discuss additional topics that should be part of the minimum documentation set
*   To discuss issues with content language that is difficult to translate/localize

<!-- links -->

<!-- external links -->

<!-- end links -->

@reviewed 2022-02-28
