# Angular Routing

In a single-page app, you change what the user sees by showing or hiding portions of the display that correspond to particular components, rather than going out to the server to get a new page.
As users perform application tasks, they need to move between the different [views](guide/glossary#view "Definition of view") that you have defined.

To handle the navigation from one [view](guide/glossary#view) to the next, you use the Angular **`Router`**.
The **`Router`** enables navigation by interpreting a browser URL as an instruction to change the view.

To explore a sample app featuring the router's primary features, see the <live-example name="router"></live-example>.

## Prerequisites

Before creating a route, you should be familiar with the following:

*   [Basics of components](guide/architecture-components)
*   [Basics of templates](guide/glossary#template)
*   An Angular app &mdash;you can generate a basic Angular application using the [Angular CLI](cli).

## Learn about Angular routing

<div class="card-container">
  <a href="guide/router" class="docs-card" title="Common routing tasks">
    <section>Common routing tasks</section>
    <p>Learn how to implement many of the common tasks associated with Angular routing.</p>
    <p class="card-footer">Common routing tasks</p>
  </a>
  <a href="guide/router-tutorial" class="docs-card" title="Routing SPA tutorial">
    <section>Single-page applications (SPAs) routing tutorial</section>
    <p>A tutorial that covers patterns associated with Angular routing.</p>
    <p class="card-footer">Routing SPA tutorial</p>
  </a>
  <a href="guide/router-tutorial-toh" class="docs-card" title="Routing Tour of Heroes">
    <section>Tour of Heroes expanded routing tutorial</section>
    <p>Add more routing features to the Tour of Heroes tutorial.</p>
    <p class="card-footer">Routing Tour of Heroes</p>
  </a>
  <a href="guide/routing-with-urlmatcher" class="docs-card" title="Creating custom route matches tutorial">
    <section>Creating custom route matches tutorial</section>
    <p>A tutorial that covers how to use custom matching strategy patterns with Angular routing.</p>
    <p class="card-footer">Custom route matches tutorial</p>
  </a>
  <a href="guide/router-reference" class="docs-card" title="Router reference">
    <section>Router reference</section>
    <p>Describes some core router API concepts.</p>
    <p class="card-footer">Router reference</p>
  </a>
</div>

<!-- links -->

<!-- external links -->

<!-- end links -->

@reviewed 2022-02-28
