# Understanding Angular

To understand the capabilities of the Angular framework, you need to learn about the following:

*   Components
*   Templates
*   Directives
*   Dependency injection

The topics in this section explain these features and concepts, and how you can use them.

## Prerequisites

To get the most out of these developer guides, you should review the following topics:

*   [What is Angular][AioGuideWhatIsAngular]
*   [Getting started tutorial][AioStart]

## Learn about Angular basics

<div class="card-container">
  <a href="guide/component-overview" class="docs-card" title="Components">
    <section>Components</section>
    <p>Learn about Angular components. A component is a key building block of Angular development.</p>
    <p class="card-footer">Components</p>
  </a>
  <a href="guide/template-syntax" class="docs-card" title="Templates">
    <section>Templates</section>
    <p>Learn about how to build an Angular template.</p>
    <p class="card-footer">Templates</p>
  </a>
  <a href="guide/built-in-directives" class="docs-card" title="Directives">
    <section>Directives</section>
    <p>Learn about Angular directives. A directive is a class that adds additional behavior to elements in your Angular applications.</p>
    <p class="card-footer">Directives</p>
  </a>
  <a href="guide/dependency-injection" class="docs-card" title="Dependency injection">
    <section>Dependency injection</section>
    <p>Learn about dependency injection. Dependency injection refers to services or objects that a class needs to perform a specific function.</p>
    <p class="card-footer">Dependency injection</p>
  </a>
  <!-- <a href="guide/rendering-overview" class="docs-card" title="Angular service worker developer guide">
    <section>Rendering</section>
    <p>Learn how about server-side rendering and pre-rendering using Angular Universal.</p>
    <p class="card-footer">Angular Universal</p>
  </a> -->
</div>

<!-- links -->

[AioGuideWhatIsAngular]: guide/what-is-angular "What is Angular\? | Angular"

[AioStart]: start "Getting started with Angular | Angular"

<!-- external links -->

<!-- end links -->

@reviewed 2022-02-28
