<h1 class="no-toc">Introduction to the Angular docs</h1>

Angular is an application-design framework and development platform for creating efficient and sophisticated single-page apps.

These Angular docs help you learn and use the Angular framework and development platform, from your first application to optimizing complex single-page applications for enterprises.
Tutorials and guides include downloadable examples to help you start your projects.

<div class="card-container">
  <a href="guide/what-is-angular" class="docs-card" title="Angular Platform Overview">
    <section>What is Angular</section>
    <p>Get a high-level overview of the Angular platform.</p>
    <p class="card-footer">Platform overview</p>
  </a>
  <a href="start" class="docs-card" title="Getting started">
    <section>Getting started</section>
    <p>Examine and work with a small ready-made Angular application, without any setup.</p>
    <p class="card-footer">Try it now</p>
  </a>
  <a href="guide/architecture" class="docs-card" title="Angular Concepts">
    <section>Learn and Explore</section>
    <p>Learn about the fundamental design concepts and architecture of Angular applications.</p>
    <p class="card-footer">Introduction to Angular concepts</p>
  </a>
  <a href="guide/setup-local" class="docs-card" title="Angular Local Environment Setup">
    <section>Set up your environment</section>
    <p>Set up your local environment for development with the Angular CLI.</p>
    <p class="card-footer">Local setup</p>
  </a>
  <a href="tutorial" class="docs-card" title="Work through a full tutorial">
    <section>Hello World</section>
    <p>Work through a full tutorial to create your first application.</p>
    <p class="card-footer">Tour of Heroes tutorial</p>
  </a>
</div>

## Assumptions

These docs assume that you are already familiar with [HTML](https://developer.mozilla.org/docs/Learn/HTML/Introduction_to_HTML "Learn HTML"), [CSS](https://developer.mozilla.org/docs/Learn/CSS/First_steps "Learn CSS"), [JavaScript](https://developer.mozilla.org/docs/Web/JavaScript/A_re-introduction_to_JavaScript "Learn JavaScript"),
and some of the tools from the [latest standards](https://developer.mozilla.org/docs/Web/JavaScript/Language_Resources "Latest JavaScript standards"), such as [classes](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Classes "ES2015 Classes") and [modules](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Statements/import "ES2015 Modules").
The code samples are written using [TypeScript](https://www.typescriptlang.org/ "TypeScript").
Most Angular code can be written with just the latest JavaScript, using [types](https://www.typescriptlang.org/docs/handbook/classes.html "TypeScript Types") for dependency injection, and using [decorators](https://www.typescriptlang.org/docs/handbook/decorators.html "Decorators") for metadata.

## Feedback

<!-- vale Angular.Google_We = NO -->

We want to hear from you. [Report problems or submit suggestions for future docs](https://github.com/angular/angular/issues/new/choose "Angular GitHub repository new issue form").

Contribute to Angular docs by creating
[pull requests](https://github.com/angular/angular/pulls "Angular Github pull requests")
on the Angular GitHub repository.
See [Contributing to Angular](https://github.com/angular/angular/blob/main/CONTRIBUTING.md "Contributing guide")
for information about submission guidelines.

Our community values respectful, supportive communication.
Please consult and adhere to the [Code of Conduct](https://github.com/angular/code-of-conduct/blob/main/CODE_OF_CONDUCT.md "Contributor code of conduct").

<!-- vale Angular.Google_We = YES -->
