# Angular applications for everyone

Angular helps you build your application for everyone.
Angular includes native framework and tooling extensions that support accessibility.
Angular's built-in internationalization support helps you reach your users in different languages.

## Accessibility (a11y)

People with a range of abilities use web applications.
Some of your users might use assistive technologies to help them use your applications.
Angular supports accessible design and the attributes that these technologies use to make your applications available to them.

Designing an application to be more accessible generally improves the user experience for all users.

[Learn more about accessibility in Angular][angular-accy]

## Internationalization (i18n) and localization (l10n)

Angular's syntax supports localizing your app and its internationalization tools make your app easier to localize by:

*  Extracting the tagged text for translation into different languages
*  Supporting International Components for Unicode (ICU) expressions for complex translation cases such as genders and plurals
*  Supporting multiple translations
*  Supporting locale-specific display formats for data

Learn more about Angular's internationalization tools in our [documentation][internationalization-doc], which contains a short video.

<!-- links -->

[internationalization-doc]: guide/i18n-overview "Angular internationalization"
[angular-accy]: guide/accessibility "Accessibility in Angular"

<!-- external links -->

<!-- end links -->
