# Scaling Angular apps

Angular works with apps of any size and Angular tools support apps as they grow.

## How Angular helps you scale your app

These are some of Angular's features that support scaling your Angular app.

### TypeScript support

Angular apps are written in [TypeScript][typescript-home]. TypeScript adds syntax to JavaScript to provide strong type checking. Your integrated development environment (IDE) can apply static type checking to [help catch errors earlier][type-checking-doc] and help you when refactoring later.

TypeScript's strong type checking gives your app a solid foundation on which to grow with confidence.

### Powerful command-line interface

The Angular CLI provides a powerful [command-line interface][ng-command-list] to perform common Angular app development tasks.
The Angular CLI implements the Angular style guide to support consistency across components.
The [`ng generate`][ng-generate] command and [Angular schematics][schematic-overview] keep your app's source code consistent and organized, while generating boilerplate code to help you start your app.

### Component libraries

The Angular team maintains the [component development kit][material-cdk] and [material design components][material-home], which are used by thousands of apps inside of Google. Use at this scale results in stability across releases and integrations.

The Angular community maintains dozens of others component libraries, which allows you to fit your app to your brand.

### Built-in support for forms and routing

Angular includes support for [forms][forms-overview] and [routes][routes-overview]. These features prove themselves daily in thousands of apps inside of Google.

Your app can also use these features with confidence.

<!--
## How others have scaled their apps

-> Links to case studies go here. <-

 -->

<!-- links -->

[ng-command-list]: cli#command-overview "Command overview"
[schematic-overview]: guide/schematics "Using schematics"
[ng-generate]: cli/generate "ng generate"
[forms-overview]: guide/forms-overview "Introduction to forms in Angular"
[routes-overview]: guide/routing-overview "Angular routing"

<!-- external links -->

[typescript-home]: https://www.typescriptlang.org/ "TypeScript: JavaScript with syntax for types"
[type-checking-doc]: https://dl.acm.org/doi/10.1109/ICSE.2017.75 "To type or not to type: quantifying detectable bugs in JavaScript"
[material-home]: https://material.angular.io/ "Angular Material"
[material-cdk]: https://material.angular.io/cdk "Angular Material CDK"

<!-- end links -->
