# Angular tutorials

This section contains tutorials to help you get started developing applications with Angular.

## Tour of heroes

[Tour of Heroes](tutorial/tour-of-heroes) helps you gain confidence that Angular can do whatever you need it to do by showing you how to:

*   Use Angular [directives](guide/glossary#directive "Directives definition") to show and hide elements and display lists of hero data.
*   Create Angular [components](guide/glossary#component "Components definition") to display hero details and show an array of heroes.
*   Use one-way [data binding](guide/glossary#data-binding "Data binding definition") for read-only data.
*   Add editable fields to update a model with two-way data binding.
*   Bind component methods to user events, like keystrokes and clicks.
*   Enable users to select a hero from a list and edit that hero in the details view.
*   Format data with [pipes](guide/glossary#pipe "Pipe definition").
*   Create a shared [service](guide/glossary#service "Service definition") to assemble the heroes.
*   Use [routing](guide/glossary#router "Router definition") to navigate among different views and their components.

## Building a template-driven form

[Building a template-driven form](guide/forms) shows you how to create a template-driven form.

The control elements in the form are bound to data properties that have input validation. The input validation helps maintain data integrity and styling to improve the user experience.
Template-driven forms use two-way data binding to update the data model in the component as changes are made in the template and vice versa.