#!/bin/bash
set -e -x

rm -rf node_modules/lib1_built node_modules/lib2_built dist/

ngc -p tsconfig-lib1.json
cp src/package-lib1.json node_modules/lib1_built/package.json

ngc -p tsconfig-lib2.json
cp src/package-lib2.json node_modules/lib2_built/package.json

ngc -p tsconfig-app.json

# Note: The src `package.json` needs to be moved to `dist` so that the main file can
# be loaded as ESM. TypeScript does not yet support emitting `.mjs` files. Also we do
# not want to set the module type at the top-level `package.json` of this test as this
# breaks the JS files generated by `rules_nodejs` for actually running the integration test runner.
cp src/package.json dist/

node ./dist/src/main.js
