/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
// Protractor configuration file, see link for more information
// https://github.com/angular/protractor/blob/master/lib/config.ts
exports.config = {
  specs: ['../built/e2e/*-spec.js'],
  chromeDriver: process.env.CHROMEDRIVER_BIN,
  capabilities: {
    browserName: 'chrome',
    chromeOptions: {
      binary: process.env.CHROME_BIN,
      // See /integration/README.md#browser-tests for more info on these args
      args: ['--no-sandbox', '--headless', '--disable-gpu', '--disable-dev-shm-usage', '--hide-scrollbars', '--mute-audio']
    }
  },
  directConnect: true,
  // Port comes from express config `/src/server.ts` `app.listen(4206,...`
  baseUrl: 'http://localhost:4206/',
  framework: 'jasmine',
  useAllAngular2AppRoots: true
};
