# What you can expect from Maintainers

The .NET maintainer team aims to support a productive and safe working environment for everyone participating in .NET repositories. You can expect maintainers to do three things to that end: respect your contributions, make engagement efficient, and report potential .NET Foundation Code of Conduct violations.

The following two lists summarize how maintainers will act. A more detailed description follows this summary.

**Maintainers will**
- Encourage your contributions and participation and provide clear and direct feedback, including when your contributions are not accepted.
- Close issues and PRs as a means of making repos more efficient to use for everyone. They can be re-opened, as needed.
- Edit comments for formatting [if and only if (iff)](https://en.wikipedia.org/wiki/If_and_only_if) the edit adds substantially to the readability or usability of the comment. No changes will be made to spelling, wording, meaning, or emphasis.
- Report abusive behavior to the [Code of Conduct review group](mailto:conduct@dotnetfoundation.org).

**Maintainers won't**
- Edit contributor comments as a general rule. GitHub provides [edit history](https://blog.github.com/changelog/2018-05-24-comment-edit-history/) which makes editing more acceptable as there is a way to see an audit log. However, contributors might still be surprised when they see statements or phrases under their name that they don't recall making. Transparency is a cornerstone of effective discourse and its absence undermines trust. And a change log doesn't fully eliminate these concerns.

## Respect your Contributions

Maintainers understand the work that goes into submitting a pull request (PR) or an issue. They will encourage you to contribute and provide feedback to help you land PRs or adequately define an issue to make it actionable. They will also provide direct and clear feedback if they have decided not to accept your contribution.

Maintainers won't as a general rule edit your comments.

Maintainers may sometimes create a new PR based on an existing PR created by you, including your commits. In that case, maintainers will aim to merge instead of squash the final result when landing the PR to preserve your contribution.

## Make Engagement Efficient

Maintainers will take actions to make repo engagement more efficient for everyone. They may close issues and PRs that are stale or because the initial creator is no longer engaged. As appropriate, maintainers will link between related issues and PRs to preserve continuity. This approach helps to make accountability clear and to make it easier for everyone to identify which issues and PRs have active engagement/progress.

Maintainers may edit PR and issue titles to improve readability and/or accuracy. GitHub provides history for title changes.

Maintainers may edit your comments if and only if the edit adds substantially to the readability or usability of the comment and doesn't change the content. The maintainer will add a short descriptive note with their @handle to explain their change at the end of your comment (for example: "_Edited by @richlander -- added call-stack formatting_"). 

Maintainers may make the following changes to contributor comments:

- Improving markdown formatting - Changes limited to [single/triple-ticks](https://github.com/adam-p/markdown-here/wiki/Markdown-Cheatsheet#code) for code and call-stacks, broken markdown links, and broken formatting (but not adding formatting or altering spelling or grammar).
- Adding "fixes link" - GitHub automatically closes issues from a PR if a [fixes link](https://help.github.com/articles/closing-issues-via-commit-messages/) is part of a commit message or initial PR comment. The addition of the link makes it easier to understand the relationship between issues and PRs.
- Adding links to latest or related content - The addition of a link to another issue or PR or another comment significantly improves readability (for example: "_Edited by @richlander -- latest version of proposal at URL_"). The link can be placed at the top and/or bottom the existing comment.

## Reporting Code of Conduct Violations

All .NET Foundation repositories have adopted the [.NET Foundation Code of Conduct](https://dotnetfoundation.org/code-of-conduct). Maintainers will report potential code of conduct violations they observe to the [.NET Foundation Code of Conduct Review Group](mailto:conduct@dotnetfoundation.org).

The Code of Conduct team will delete comments that are considered code of conduct violations. Maintainers will unilaterally delete comments that are objectively severe violations of the code of conduct and submit the original comment to the Code of Conduct team after-the-fact for review.
