# .NET repositories

.NET consists of many repositories. To file an issue, make a PR, or engage on specific topics, it's best to engage with developers working in the correct repo. A largely complete set of .NET and related repositories follows.

## Platform

|Repository                                                          |Issues                                                |Discussions                                               | Description |
|--------------------------------------------------------------------|:----------------------------------------------------:|:--------------------------------------------------------:|-------------|
|[dotnet/core](https://github.com/dotnet/core)                       |[🔗](https://github.com/dotnet/core/issues)           |[🔗](https://github.com/dotnet/core/discussions)         |Home for .NET News, Release Notes, and Announcements|
|[dotnet/runtime](https://github.com/dotnet/runtime)                 |[🔗](https://github.com/dotnet/runtime/issues)        |[🔗](https://github.com/dotnet/runtime/discussions)      |.NET runtime, runtime installers, application model, & Base Class Library (BCL)|
|[dotnet/sdk](https://github.com/dotnet/sdk)                         |[🔗](https://github.com/dotnet/sdk/issues)            |                                                          |.NET SDK (used by Visual Studio & .NET CLI)|


## Compilers & Languages
|Repository                                                          |Issues                                                |Discussions                                               | Description |
|--------------------------------------------------------------------|:----------------------------------------------------:|:--------------------------------------------------------:|-------------|
|[dotnet/csharplang](https://github.com/dotnet/csharplang)                |[🔗](https://github.com/dotnet/csharplang/issues)         |[🔗](https://github.com/dotnet/csharplang/discussions)         |C# suggestions, specification, ongoing language design |
|[dotnet/fsharp](https://github.com/dotnet/fsharp)                        |[🔗](https://github.com/dotnet/fsharp/issues)             |[🔗](https://github.com/dotnet/fsharp/discussions)             |The F# compiler, FSharp.Core library, and tools for F# |
|[dotnet/razor](https://github.com/dotnet/razor)                    |[🔗](https://github.com/dotnet/razor/issues)           |                                                             |Compiler and tooling experience for Razor    |
|[dotnet/roslyn](https://github.com/dotnet/roslyn)                        |[🔗](https://github.com/dotnet/roslyn/issues)             |[🔗](https://github.com/dotnet/roslyn/discussions)             |Roslyn (C# / VB compiler)                              |
|[dotnet/vblang](https://github.com/dotnet/vblang)                        |[🔗](https://github.com/dotnet/vblang/issues)             |                                                                |VB suggestions, specification, ongoing language design |

## Libraries

|Repository                                            |Issues                                           |Discussions                                          | Description |
|------------------------------------------------------|:-----------------------------------------------:|:---------------------------------------------------:|-------------|
|[dotnet/efcore](https://github.com/dotnet/efcore)                            |[🔗](https://github.com/dotnet/efcore/issues)               |                                                       |EF Core                               |
|[dotnet/ef6](https://github.com/dotnet/ef6)                                  |[🔗](https://github.com/dotnet/ef6/issues)                  |                                                       |EF 6                                  |
|[dotnet/extensions](https://github.com/dotnet/extensions)           |[🔗](https://github.com/dotnet/extensions/issues)     |[🔗](https://github.com/dotnet/extensions/discussions)   |.NET extension APIs (DI, logging, configuration, etc.)|
|[dotnet/machinelearning](https://github.com/dotnet/machinelearning)                           |[🔗](https://github.com/dotnet/machinelearning/issues)              |                                                   |ML.NET                   |
|[dotnet/spark](https://github.com/dotnet/spark)                                               |[🔗](https://github.com/dotnet/spark/issues)                        |[🔗](https://github.com/dotnet/spark/discussions) |.NET for Apache® Spark™  |
|[dotnet/sqlclient](https://github.com/dotnet/sqlclient)                      |[🔗](https://github.com/dotnet/sqlclient/issues)            |[🔗](https://github.com/dotnet/sqlclient/discussions) |SqlClient data provider for SQL Server|
|[dotnet/wcf](https://github.com/dotnet/wcf)           |[🔗](https://github.com/dotnet/wcf/issues)      |                                                      |WCF client libraries|
|[CoreWCF/CoreWCF](https://github.com/CoreWCF/CoreWCF) |[🔗](https://github.com/CoreWCF/CoreWCF/issues) |[🔗](https://github.com/CoreWCF/CoreWCF/discussions) | Core WCF client libraries|

## App Workloads

|Repository                                                         |Issues                                                  |Discussions                                                 | Description |
|-------------------------------------------------------------------|:------------------------------------------------------:|:----------------------------------------------------------:|-------------|
|[dotnet/aspire](https://github.com/dotnet/aspire)                  |[🔗](https://github.com/dotnet/aspire/issues)          |[🔗](https://github.com/dotnet/aspire/discussions)          |.NET Aspire                                  |
|[dotnet/aspnetcore](https://github.com/dotnet/aspnetcore)          |[🔗](https://github.com/dotnet/aspnetcore/issues)      |[🔗](https://github.com/dotnet/aspnetcore/discussions)      |ASP.NET Core framework                       |
|[dotnet/maui](https://github.com/dotnet/maui)                       |[🔗](https://github.com/dotnet/maui/issues)     |[🔗](https://github.com/dotnet/maui/discussions)     |.NET Multi-platform App UI (MAUI)|
|[dotnet/winforms](https://github.com/dotnet/winforms)               |[🔗](https://github.com/dotnet/winforms/issues) |[🔗](https://github.com/dotnet/winforms/discussions) |Windows Forms|
|[dotnet/wpf](https://github.com/dotnet/wpf)                         |[🔗](https://github.com/dotnet/wpf/issues)      |[🔗](https://github.com/dotnet/wpf/discussions)      |Windows Presentation Foundation (WPF)|

## Tools

|Repository                                                          |Issues                                           |Discussions                                          | Description |
|--------------------------------------------------------------------|:-----------------------------------------------:|:---------------------------------------------------:|------------|
|[dotnet/dotnet-docker](https://github.com/dotnet/dotnet-docker)     |[🔗](https://github.com/dotnet/dotnet-docker/issues)  |[🔗](https://github.com/dotnet/dotnet-docker/discussions)|.NET Docker images|
|[dotnet/installer](https://github.com/dotnet/installer)             |[🔗](https://github.com/dotnet/installer/issues)      |                                                          |.NET installer (produces zips, tarballs, and installers for the .NET SDK)
|[dotnet/machinelearning-modelbuilder](https://github.com/dotnet/machinelearning-modelbuilder) |[🔗](https://github.com/dotnet/machinelearning-modelbuilder/issues) |                                                   |ML.NET Tooling           |
|[dotnet/msbuild](https://github.com/dotnet/msbuild)      |[🔗](https://github.com/dotnet/msbuild/issues)|[🔗](https://github.com/dotnet/msbuild/discussions)|Build platform for .NET & Visual Studio|
|[dotnet/Scaffolding](https://github.com/dotnet/Scaffolding)        |[🔗](https://github.com/dotnet/Scaffolding/issues)     |                                                             |ASP.NET Core code generators                 |
|[dotnet/websdk](https://github.com/dotnet/websdk)                  |[🔗](https://github.com/dotnet/websdk/issues)          |                                                             |MSBuild tasks & targets for ASP.NET Core apps|
|[dotnet/project-system](https://github.com/dotnet/project-system)   |[🔗](https://github.com/dotnet/project-system/issues) |                                                          |Visual Studio project system for C#, F#, & VB|
|[dotnet/templating](https://github.com/dotnet/templating)           |[🔗](https://github.com/dotnet/templating/issues)     |[🔗](https://github.com/dotnet/templating/discussions)   |Templating engine used by `dotnet new`|
|[dotnet/test-templates](https://github.com/dotnet/test-templates)   |[🔗](https://github.com/dotnet/test-templates/issues) |                                                          |.NET unit testing project templates|
|[dotnet/vscode-csharp](https://github.com/dotnet/vscode-csharp)     |[🔗](https://github.com/dotnet/vscode-csharp/issues)     |[🔗](https://github.com/dotnet/vscode-csharp/discussions)   |C# support for VS Code|


## NuGet

|Repository                                                  |Issues                                     |Discussions                                    | Description |
|------------------------------------------------------------|:-----------------------------------------:|:---------------------------------------------:|-------------|
|[nuget/home](https://github.com/nuget/home)                 |[🔗](https://github.com/nuget/home/issues)|[🔗](https://github.com/nuget/home/discussions)|NuGet client|

## Documentation

|Repository                                                          |Issues                                                |Discussions                                               | Description |
|--------------------------------------------------------------------|:----------------------------------------------------:|:--------------------------------------------------------:|-------------|
|[dotnet/docs](https://github.com/dotnet/docs)                       |[🔗](https://github.com/dotnet/docs/issues)           |                                                          |.NET documentation|
|[dotnet/dotnet-api-docs](https://github.com/dotnet/dotnet-api-docs) |[🔗](https://github.com/dotnet/dotnet-api-docs/issues)|                                                          |.NET API documentation|
|[dotnet/AspNetCore.Docs](https://github.com/dotnet/AspNetCore.Docs)|[🔗](https://github.com/dotnet/AspNetCore.Docs/issues) |[🔗](https://github.com/dotnet/AspNetCore.Docs/discussions) |ASP.NET Core documentation                   |
|[dotnet/AspNetDocs](https://github.com/dotnet/AspNetDocs)          |[🔗](https://github.com/dotnet/AspNetDocs/issues)      |                                                             |ASP.NET 4.x documentation                    |
|[dotnet/EntityFramework.Docs](https://github.com/dotnet/EntityFramework.Docs)|[🔗](https://github.com/dotnet/EntityFramework.Docs/issues) |                                                       |EF Core & EF 6 documentation          |
|[dotnet/ml-api-docs](https://github.com/dotnet/ml-api-docs)                                   |[🔗](https://github.com/dotnet/ml-api-docs/issues)                  |                                                   |ML.NET API documentation |

## .NET Framework

|Repository                                                                                |Description |
|------------------------------------------------------------------------------------------|------------|
|[Dev Community](https://developercommunity.visualstudio.com/spaces/61/index.html)         |Report issues to .NET Framework Developer Community|
|[microsoft/dotnet-framework-docker](https://github.com/microsoft/dotnet-framework-docker) |.NET Framework Docker images|
