# .NET Daily Builds -- Servicing and future releases

The .NET team builds many branches of the product daily. You can install these builds to try out functionality prior to release.

Daily builds, for both future and servicing branches, are available as Docker container images from the [Microsoft Container Registry](https://hub.docker.com/_/microsoft-dotnet-nightly/).

## Future Releases

Preview branches are for new versions of .NET that have not yet been released and are not yet supported.

|Component|*.NET 8.0*
|:------:|:------:|
|SDK|[.NET SDK 8.0.xxx](https://github.com/dotnet/installer/blob/main/README.md#installers-and-binaries)
|ASP.NET Core|[ASP.NET Core 8.0](https://github.com/dotnet/aspnetcore/blob/main/docs/DailyBuilds.md)
|Runtime|[.NET Runtime 8.0](https://github.com/dotnet/runtime/blob/main/docs/project/dogfooding.md)

## Servicing Releases

Servicing branches are for new patch versions of .NET that have not yet been released and are not yet supported.

|Component|*.NET 7.0*|*.NET 6.0*|
|:------:|:------:|:------:
|SDK|[.NET SDK 7.0.xxx](https://github.com/dotnet/installer/blob/main/README.md#installers-and-binaries)|[.NET SDK 6.0.xxx](https://github.com/dotnet/installer/blob/main/README.md#installers-and-binaries)|
|ASP.NET Core|[ASP.NET Core 7.0](https://github.com/dotnet/aspnetcore/blob/main/docs/DailyBuilds.md)|[ASP.NET Core 6.0](https://github.com/dotnet/aspnetcore/blob/main/docs/DailyBuilds.md)|
|Runtime|[.NET Runtime 7.0](https://github.com/dotnet/runtime/blob/main/docs/project/dogfooding.md)|[.NET Core Runtime 6.0](https://github.com/dotnet/runtime/blob/main/docs/project/dogfooding.md)|
