# System.Data.SqlTypes

``` diff
+namespace System.Data.SqlTypes {
+    public interface INullable {
+        bool IsNull { get; }
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct SqlBinary : IComparable, INullable {
+        public static readonly SqlBinary Null;
+        public SqlBinary(byte[] value);
+        public bool IsNull { get; }
+        public int Length { get; }
+        public byte this[int index] { get; }
+        public byte[] Value { get; }
+        public static SqlBinary Add(SqlBinary x, SqlBinary y);
+        public int CompareTo(SqlBinary value);
+        public int CompareTo(object value);
+        public static SqlBinary Concat(SqlBinary x, SqlBinary y);
+        public static SqlBoolean Equals(SqlBinary x, SqlBinary y);
+        public override bool Equals(object value);
+        public override int GetHashCode();
+        public static SqlBoolean GreaterThan(SqlBinary x, SqlBinary y);
+        public static SqlBoolean GreaterThanOrEqual(SqlBinary x, SqlBinary y);
+        public static SqlBoolean LessThan(SqlBinary x, SqlBinary y);
+        public static SqlBoolean LessThanOrEqual(SqlBinary x, SqlBinary y);
+        public static SqlBoolean NotEquals(SqlBinary x, SqlBinary y);
+        public static SqlBinary operator +(SqlBinary x, SqlBinary y);
+        public static SqlBoolean operator ==(SqlBinary x, SqlBinary y);
+        public static explicit operator byte[] (SqlBinary x);
+        public static explicit operator SqlBinary (SqlGuid x);
+        public static SqlBoolean operator >(SqlBinary x, SqlBinary y);
+        public static SqlBoolean operator >=(SqlBinary x, SqlBinary y);
+        public static implicit operator SqlBinary (byte[] x);
+        public static SqlBoolean operator !=(SqlBinary x, SqlBinary y);
+        public static SqlBoolean operator <(SqlBinary x, SqlBinary y);
+        public static SqlBoolean operator <=(SqlBinary x, SqlBinary y);
+        public SqlGuid ToSqlGuid();
+        public override string ToString();
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct SqlBoolean : IComparable, INullable {
+        public static readonly SqlBoolean False;
+        public static readonly SqlBoolean Null;
+        public static readonly SqlBoolean One;
+        public static readonly SqlBoolean True;
+        public static readonly SqlBoolean Zero;
+        public SqlBoolean(bool value);
+        public SqlBoolean(int value);
+        public byte ByteValue { get; }
+        public bool IsFalse { get; }
+        public bool IsNull { get; }
+        public bool IsTrue { get; }
+        public bool Value { get; }
+        public static SqlBoolean And(SqlBoolean x, SqlBoolean y);
+        public int CompareTo(SqlBoolean value);
+        public int CompareTo(object value);
+        public static SqlBoolean Equals(SqlBoolean x, SqlBoolean y);
+        public override bool Equals(object value);
+        public override int GetHashCode();
+        public static SqlBoolean GreaterThan(SqlBoolean x, SqlBoolean y);
+        public static SqlBoolean GreaterThanOrEquals(SqlBoolean x, SqlBoolean y);
+        public static SqlBoolean LessThan(SqlBoolean x, SqlBoolean y);
+        public static SqlBoolean LessThanOrEquals(SqlBoolean x, SqlBoolean y);
+        public static SqlBoolean NotEquals(SqlBoolean x, SqlBoolean y);
+        public static SqlBoolean OnesComplement(SqlBoolean x);
+        public static SqlBoolean operator &(SqlBoolean x, SqlBoolean y);
+        public static SqlBoolean operator |(SqlBoolean x, SqlBoolean y);
+        public static SqlBoolean operator ==(SqlBoolean x, SqlBoolean y);
+        public static SqlBoolean operator ^(SqlBoolean x, SqlBoolean y);
+        public static explicit operator bool (SqlBoolean x);
+        public static explicit operator SqlBoolean (SqlByte x);
+        public static explicit operator SqlBoolean (SqlDecimal x);
+        public static explicit operator SqlBoolean (SqlDouble x);
+        public static explicit operator SqlBoolean (SqlInt16 x);
+        public static explicit operator SqlBoolean (SqlInt32 x);
+        public static explicit operator SqlBoolean (SqlInt64 x);
+        public static explicit operator SqlBoolean (SqlMoney x);
+        public static explicit operator SqlBoolean (SqlSingle x);
+        public static explicit operator SqlBoolean (SqlString x);
+        public static bool operator false(SqlBoolean x);
+        public static SqlBoolean operator >(SqlBoolean x, SqlBoolean y);
+        public static SqlBoolean operator >=(SqlBoolean x, SqlBoolean y);
+        public static implicit operator SqlBoolean (bool x);
+        public static SqlBoolean operator !=(SqlBoolean x, SqlBoolean y);
+        public static SqlBoolean operator <(SqlBoolean x, SqlBoolean y);
+        public static SqlBoolean operator <=(SqlBoolean x, SqlBoolean y);
+        public static SqlBoolean operator !(SqlBoolean x);
+        public static SqlBoolean operator ~(SqlBoolean x);
+        public static bool operator true(SqlBoolean x);
+        public static SqlBoolean Or(SqlBoolean x, SqlBoolean y);
+        public static SqlBoolean Parse(string s);
+        public SqlByte ToSqlByte();
+        public SqlDecimal ToSqlDecimal();
+        public SqlDouble ToSqlDouble();
+        public SqlInt16 ToSqlInt16();
+        public SqlInt32 ToSqlInt32();
+        public SqlInt64 ToSqlInt64();
+        public SqlMoney ToSqlMoney();
+        public SqlSingle ToSqlSingle();
+        public SqlString ToSqlString();
+        public override string ToString();
+        public static SqlBoolean Xor(SqlBoolean x, SqlBoolean y);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct SqlByte : IComparable, INullable {
+        public static readonly SqlByte MaxValue;
+        public static readonly SqlByte MinValue;
+        public static readonly SqlByte Null;
+        public static readonly SqlByte Zero;
+        public SqlByte(byte value);
+        public bool IsNull { get; }
+        public byte Value { get; }
+        public static SqlByte Add(SqlByte x, SqlByte y);
+        public static SqlByte BitwiseAnd(SqlByte x, SqlByte y);
+        public static SqlByte BitwiseOr(SqlByte x, SqlByte y);
+        public int CompareTo(SqlByte value);
+        public int CompareTo(object value);
+        public static SqlByte Divide(SqlByte x, SqlByte y);
+        public static SqlBoolean Equals(SqlByte x, SqlByte y);
+        public override bool Equals(object value);
+        public override int GetHashCode();
+        public static SqlBoolean GreaterThan(SqlByte x, SqlByte y);
+        public static SqlBoolean GreaterThanOrEqual(SqlByte x, SqlByte y);
+        public static SqlBoolean LessThan(SqlByte x, SqlByte y);
+        public static SqlBoolean LessThanOrEqual(SqlByte x, SqlByte y);
+        public static SqlByte Mod(SqlByte x, SqlByte y);
+        public static SqlByte Modulus(SqlByte x, SqlByte y);
+        public static SqlByte Multiply(SqlByte x, SqlByte y);
+        public static SqlBoolean NotEquals(SqlByte x, SqlByte y);
+        public static SqlByte OnesComplement(SqlByte x);
+        public static SqlByte operator +(SqlByte x, SqlByte y);
+        public static SqlByte operator &(SqlByte x, SqlByte y);
+        public static SqlByte operator |(SqlByte x, SqlByte y);
+        public static SqlByte operator /(SqlByte x, SqlByte y);
+        public static SqlBoolean operator ==(SqlByte x, SqlByte y);
+        public static SqlByte operator ^(SqlByte x, SqlByte y);
+        public static explicit operator SqlByte (SqlBoolean x);
+        public static explicit operator byte (SqlByte x);
+        public static explicit operator SqlByte (SqlDecimal x);
+        public static explicit operator SqlByte (SqlDouble x);
+        public static explicit operator SqlByte (SqlInt16 x);
+        public static explicit operator SqlByte (SqlInt32 x);
+        public static explicit operator SqlByte (SqlInt64 x);
+        public static explicit operator SqlByte (SqlMoney x);
+        public static explicit operator SqlByte (SqlSingle x);
+        public static explicit operator SqlByte (SqlString x);
+        public static SqlBoolean operator >(SqlByte x, SqlByte y);
+        public static SqlBoolean operator >=(SqlByte x, SqlByte y);
+        public static implicit operator SqlByte (byte x);
+        public static SqlBoolean operator !=(SqlByte x, SqlByte y);
+        public static SqlBoolean operator <(SqlByte x, SqlByte y);
+        public static SqlBoolean operator <=(SqlByte x, SqlByte y);
+        public static SqlByte operator %(SqlByte x, SqlByte y);
+        public static SqlByte operator *(SqlByte x, SqlByte y);
+        public static SqlByte operator ~(SqlByte x);
+        public static SqlByte operator -(SqlByte x, SqlByte y);
+        public static SqlByte Parse(string s);
+        public static SqlByte Subtract(SqlByte x, SqlByte y);
+        public SqlBoolean ToSqlBoolean();
+        public SqlDecimal ToSqlDecimal();
+        public SqlDouble ToSqlDouble();
+        public SqlInt16 ToSqlInt16();
+        public SqlInt32 ToSqlInt32();
+        public SqlInt64 ToSqlInt64();
+        public SqlMoney ToSqlMoney();
+        public SqlSingle ToSqlSingle();
+        public SqlString ToSqlString();
+        public override string ToString();
+        public static SqlByte Xor(SqlByte x, SqlByte y);
+    }
+    public sealed class SqlBytes : INullable {
+        public SqlBytes();
+        public SqlBytes(byte[] buffer);
+        public SqlBytes(SqlBinary value);
+        public SqlBytes(Stream s);
+        public byte[] Buffer { get; }
+        public bool IsNull { get; }
+        public long Length { get; }
+        public long MaxLength { get; }
+        public static SqlBytes Null { get; }
+        public Stream Stream { get; set; }
+        public byte this[long offset] { get; set; }
+        public byte[] Value { get; }
+        public static explicit operator SqlBytes (SqlBinary value);
+        public static explicit operator SqlBinary (SqlBytes value);
+        public long Read(long offset, byte[] buffer, int offsetInBuffer, int count);
+        public void SetLength(long value);
+        public void SetNull();
+        public SqlBinary ToSqlBinary();
+        public void Write(long offset, byte[] buffer, int offsetInBuffer, int count);
+    }
+    public sealed class SqlChars : INullable {
+        public SqlChars();
+        public SqlChars(char[] buffer);
+        public SqlChars(SqlString value);
+        public char[] Buffer { get; }
+        public bool IsNull { get; }
+        public long Length { get; }
+        public long MaxLength { get; }
+        public static SqlChars Null { get; }
+        public char this[long offset] { get; set; }
+        public char[] Value { get; }
+        public static explicit operator SqlString (SqlChars value);
+        public static explicit operator SqlChars (SqlString value);
+        public long Read(long offset, char[] buffer, int offsetInBuffer, int count);
+        public void SetLength(long value);
+        public void SetNull();
+        public SqlString ToSqlString();
+        public void Write(long offset, char[] buffer, int offsetInBuffer, int count);
+    }
+    public enum SqlCompareOptions {
+        BinarySort = 32768,
+        BinarySort2 = 16384,
+        IgnoreCase = 1,
+        IgnoreKanaType = 8,
+        IgnoreNonSpace = 2,
+        IgnoreWidth = 16,
+        None = 0,
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct SqlDateTime : IComparable, INullable {
+        public static readonly SqlDateTime MaxValue;
+        public static readonly SqlDateTime MinValue;
+        public static readonly SqlDateTime Null;
+        public static readonly int SQLTicksPerHour;
+        public static readonly int SQLTicksPerMinute;
+        public static readonly int SQLTicksPerSecond;
+        public SqlDateTime(DateTime value);
+        public SqlDateTime(int dayTicks, int timeTicks);
+        public SqlDateTime(int year, int month, int day);
+        public SqlDateTime(int year, int month, int day, int hour, int minute, int second);
+        public SqlDateTime(int year, int month, int day, int hour, int minute, int second, double millisecond);
+        public SqlDateTime(int year, int month, int day, int hour, int minute, int second, int bilisecond);
+        public int DayTicks { get; }
+        public bool IsNull { get; }
+        public int TimeTicks { get; }
+        public DateTime Value { get; }
+        public static SqlDateTime Add(SqlDateTime x, TimeSpan t);
+        public int CompareTo(SqlDateTime value);
+        public int CompareTo(object value);
+        public static SqlBoolean Equals(SqlDateTime x, SqlDateTime y);
+        public override bool Equals(object value);
+        public override int GetHashCode();
+        public static SqlBoolean GreaterThan(SqlDateTime x, SqlDateTime y);
+        public static SqlBoolean GreaterThanOrEqual(SqlDateTime x, SqlDateTime y);
+        public static SqlBoolean LessThan(SqlDateTime x, SqlDateTime y);
+        public static SqlBoolean LessThanOrEqual(SqlDateTime x, SqlDateTime y);
+        public static SqlBoolean NotEquals(SqlDateTime x, SqlDateTime y);
+        public static SqlDateTime operator +(SqlDateTime x, TimeSpan t);
+        public static SqlBoolean operator ==(SqlDateTime x, SqlDateTime y);
+        public static explicit operator DateTime (SqlDateTime x);
+        public static explicit operator SqlDateTime (SqlString x);
+        public static SqlBoolean operator >(SqlDateTime x, SqlDateTime y);
+        public static SqlBoolean operator >=(SqlDateTime x, SqlDateTime y);
+        public static implicit operator SqlDateTime (DateTime value);
+        public static SqlBoolean operator !=(SqlDateTime x, SqlDateTime y);
+        public static SqlBoolean operator <(SqlDateTime x, SqlDateTime y);
+        public static SqlBoolean operator <=(SqlDateTime x, SqlDateTime y);
+        public static SqlDateTime operator -(SqlDateTime x, TimeSpan t);
+        public static SqlDateTime Parse(string s);
+        public static SqlDateTime Subtract(SqlDateTime x, TimeSpan t);
+        public SqlString ToSqlString();
+        public override string ToString();
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct SqlDecimal : IComparable, INullable {
+        public static readonly byte MaxPrecision;
+        public static readonly byte MaxScale;
+        public static readonly SqlDecimal MaxValue;
+        public static readonly SqlDecimal MinValue;
+        public static readonly SqlDecimal Null;
+        public SqlDecimal(byte bPrecision, byte bScale, bool fPositive, int data1, int data2, int data3, int data4);
+        public SqlDecimal(byte bPrecision, byte bScale, bool fPositive, int[] bits);
+        public SqlDecimal(Decimal value);
+        public SqlDecimal(double dVal);
+        public SqlDecimal(int value);
+        public SqlDecimal(long value);
+        public byte[] BinData { get; }
+        public int[] Data { get; }
+        public bool IsNull { get; }
+        public bool IsPositive { get; }
+        public byte Precision { get; }
+        public byte Scale { get; }
+        public Decimal Value { get; }
+        public static SqlDecimal Abs(SqlDecimal n);
+        public static SqlDecimal Add(SqlDecimal x, SqlDecimal y);
+        public static SqlDecimal AdjustScale(SqlDecimal n, int digits, bool fRound);
+        public static SqlDecimal Ceiling(SqlDecimal n);
+        public int CompareTo(SqlDecimal value);
+        public int CompareTo(object value);
+        public static SqlDecimal ConvertToPrecScale(SqlDecimal n, int precision, int scale);
+        public static SqlDecimal Divide(SqlDecimal x, SqlDecimal y);
+        public static SqlBoolean Equals(SqlDecimal x, SqlDecimal y);
+        public override bool Equals(object value);
+        public static SqlDecimal Floor(SqlDecimal n);
+        public override int GetHashCode();
+        public static SqlBoolean GreaterThan(SqlDecimal x, SqlDecimal y);
+        public static SqlBoolean GreaterThanOrEqual(SqlDecimal x, SqlDecimal y);
+        public static SqlBoolean LessThan(SqlDecimal x, SqlDecimal y);
+        public static SqlBoolean LessThanOrEqual(SqlDecimal x, SqlDecimal y);
+        public static SqlDecimal Multiply(SqlDecimal x, SqlDecimal y);
+        public static SqlBoolean NotEquals(SqlDecimal x, SqlDecimal y);
+        public static SqlDecimal operator +(SqlDecimal x, SqlDecimal y);
+        public static SqlDecimal operator /(SqlDecimal x, SqlDecimal y);
+        public static SqlBoolean operator ==(SqlDecimal x, SqlDecimal y);
+        public static explicit operator SqlDecimal (SqlBoolean x);
+        public static explicit operator Decimal (SqlDecimal x);
+        public static explicit operator SqlDecimal (SqlDouble x);
+        public static explicit operator SqlDecimal (SqlSingle x);
+        public static explicit operator SqlDecimal (SqlString x);
+        public static explicit operator SqlDecimal (double x);
+        public static SqlBoolean operator >(SqlDecimal x, SqlDecimal y);
+        public static SqlBoolean operator >=(SqlDecimal x, SqlDecimal y);
+        public static implicit operator SqlDecimal (SqlByte x);
+        public static implicit operator SqlDecimal (SqlInt16 x);
+        public static implicit operator SqlDecimal (SqlInt32 x);
+        public static implicit operator SqlDecimal (SqlInt64 x);
+        public static implicit operator SqlDecimal (SqlMoney x);
+        public static implicit operator SqlDecimal (Decimal x);
+        public static implicit operator SqlDecimal (long x);
+        public static SqlBoolean operator !=(SqlDecimal x, SqlDecimal y);
+        public static SqlBoolean operator <(SqlDecimal x, SqlDecimal y);
+        public static SqlBoolean operator <=(SqlDecimal x, SqlDecimal y);
+        public static SqlDecimal operator *(SqlDecimal x, SqlDecimal y);
+        public static SqlDecimal operator -(SqlDecimal x, SqlDecimal y);
+        public static SqlDecimal operator -(SqlDecimal x);
+        public static SqlDecimal Parse(string s);
+        public static SqlDecimal Power(SqlDecimal n, double exp);
+        public static SqlDecimal Round(SqlDecimal n, int position);
+        public static SqlInt32 Sign(SqlDecimal n);
+        public static SqlDecimal Subtract(SqlDecimal x, SqlDecimal y);
+        public double ToDouble();
+        public SqlBoolean ToSqlBoolean();
+        public SqlByte ToSqlByte();
+        public SqlDouble ToSqlDouble();
+        public SqlInt16 ToSqlInt16();
+        public SqlInt32 ToSqlInt32();
+        public SqlInt64 ToSqlInt64();
+        public SqlMoney ToSqlMoney();
+        public SqlSingle ToSqlSingle();
+        public SqlString ToSqlString();
+        public override string ToString();
+        public static SqlDecimal Truncate(SqlDecimal n, int position);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct SqlDouble : IComparable, INullable {
+        public static readonly SqlDouble MaxValue;
+        public static readonly SqlDouble MinValue;
+        public static readonly SqlDouble Null;
+        public static readonly SqlDouble Zero;
+        public SqlDouble(double value);
+        public bool IsNull { get; }
+        public double Value { get; }
+        public static SqlDouble Add(SqlDouble x, SqlDouble y);
+        public int CompareTo(SqlDouble value);
+        public int CompareTo(object value);
+        public static SqlDouble Divide(SqlDouble x, SqlDouble y);
+        public static SqlBoolean Equals(SqlDouble x, SqlDouble y);
+        public override bool Equals(object value);
+        public override int GetHashCode();
+        public static SqlBoolean GreaterThan(SqlDouble x, SqlDouble y);
+        public static SqlBoolean GreaterThanOrEqual(SqlDouble x, SqlDouble y);
+        public static SqlBoolean LessThan(SqlDouble x, SqlDouble y);
+        public static SqlBoolean LessThanOrEqual(SqlDouble x, SqlDouble y);
+        public static SqlDouble Multiply(SqlDouble x, SqlDouble y);
+        public static SqlBoolean NotEquals(SqlDouble x, SqlDouble y);
+        public static SqlDouble operator +(SqlDouble x, SqlDouble y);
+        public static SqlDouble operator /(SqlDouble x, SqlDouble y);
+        public static SqlBoolean operator ==(SqlDouble x, SqlDouble y);
+        public static explicit operator SqlDouble (SqlBoolean x);
+        public static explicit operator double (SqlDouble x);
+        public static explicit operator SqlDouble (SqlString x);
+        public static SqlBoolean operator >(SqlDouble x, SqlDouble y);
+        public static SqlBoolean operator >=(SqlDouble x, SqlDouble y);
+        public static implicit operator SqlDouble (SqlByte x);
+        public static implicit operator SqlDouble (SqlDecimal x);
+        public static implicit operator SqlDouble (SqlInt16 x);
+        public static implicit operator SqlDouble (SqlInt32 x);
+        public static implicit operator SqlDouble (SqlInt64 x);
+        public static implicit operator SqlDouble (SqlMoney x);
+        public static implicit operator SqlDouble (SqlSingle x);
+        public static implicit operator SqlDouble (double x);
+        public static SqlBoolean operator !=(SqlDouble x, SqlDouble y);
+        public static SqlBoolean operator <(SqlDouble x, SqlDouble y);
+        public static SqlBoolean operator <=(SqlDouble x, SqlDouble y);
+        public static SqlDouble operator *(SqlDouble x, SqlDouble y);
+        public static SqlDouble operator -(SqlDouble x, SqlDouble y);
+        public static SqlDouble operator -(SqlDouble x);
+        public static SqlDouble Parse(string s);
+        public static SqlDouble Subtract(SqlDouble x, SqlDouble y);
+        public SqlBoolean ToSqlBoolean();
+        public SqlByte ToSqlByte();
+        public SqlDecimal ToSqlDecimal();
+        public SqlInt16 ToSqlInt16();
+        public SqlInt32 ToSqlInt32();
+        public SqlInt64 ToSqlInt64();
+        public SqlMoney ToSqlMoney();
+        public SqlSingle ToSqlSingle();
+        public SqlString ToSqlString();
+        public override string ToString();
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct SqlGuid : IComparable, INullable {
+        public static readonly SqlGuid Null;
+        public SqlGuid(byte[] value);
+        public SqlGuid(Guid g);
+        public SqlGuid(int a, short b, short c, byte d, byte e, byte f, byte g, byte h, byte i, byte j, byte k);
+        public SqlGuid(string s);
+        public bool IsNull { get; }
+        public Guid Value { get; }
+        public int CompareTo(SqlGuid value);
+        public int CompareTo(object value);
+        public static SqlBoolean Equals(SqlGuid x, SqlGuid y);
+        public override bool Equals(object value);
+        public override int GetHashCode();
+        public static SqlBoolean GreaterThan(SqlGuid x, SqlGuid y);
+        public static SqlBoolean GreaterThanOrEqual(SqlGuid x, SqlGuid y);
+        public static SqlBoolean LessThan(SqlGuid x, SqlGuid y);
+        public static SqlBoolean LessThanOrEqual(SqlGuid x, SqlGuid y);
+        public static SqlBoolean NotEquals(SqlGuid x, SqlGuid y);
+        public static SqlBoolean operator ==(SqlGuid x, SqlGuid y);
+        public static explicit operator SqlGuid (SqlBinary x);
+        public static explicit operator Guid (SqlGuid x);
+        public static explicit operator SqlGuid (SqlString x);
+        public static SqlBoolean operator >(SqlGuid x, SqlGuid y);
+        public static SqlBoolean operator >=(SqlGuid x, SqlGuid y);
+        public static implicit operator SqlGuid (Guid x);
+        public static SqlBoolean operator !=(SqlGuid x, SqlGuid y);
+        public static SqlBoolean operator <(SqlGuid x, SqlGuid y);
+        public static SqlBoolean operator <=(SqlGuid x, SqlGuid y);
+        public static SqlGuid Parse(string s);
+        public byte[] ToByteArray();
+        public SqlBinary ToSqlBinary();
+        public SqlString ToSqlString();
+        public override string ToString();
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct SqlInt16 : IComparable, INullable {
+        public static readonly SqlInt16 MaxValue;
+        public static readonly SqlInt16 MinValue;
+        public static readonly SqlInt16 Null;
+        public static readonly SqlInt16 Zero;
+        public SqlInt16(short value);
+        public bool IsNull { get; }
+        public short Value { get; }
+        public static SqlInt16 Add(SqlInt16 x, SqlInt16 y);
+        public static SqlInt16 BitwiseAnd(SqlInt16 x, SqlInt16 y);
+        public static SqlInt16 BitwiseOr(SqlInt16 x, SqlInt16 y);
+        public int CompareTo(SqlInt16 value);
+        public int CompareTo(object value);
+        public static SqlInt16 Divide(SqlInt16 x, SqlInt16 y);
+        public static SqlBoolean Equals(SqlInt16 x, SqlInt16 y);
+        public override bool Equals(object value);
+        public override int GetHashCode();
+        public static SqlBoolean GreaterThan(SqlInt16 x, SqlInt16 y);
+        public static SqlBoolean GreaterThanOrEqual(SqlInt16 x, SqlInt16 y);
+        public static SqlBoolean LessThan(SqlInt16 x, SqlInt16 y);
+        public static SqlBoolean LessThanOrEqual(SqlInt16 x, SqlInt16 y);
+        public static SqlInt16 Mod(SqlInt16 x, SqlInt16 y);
+        public static SqlInt16 Modulus(SqlInt16 x, SqlInt16 y);
+        public static SqlInt16 Multiply(SqlInt16 x, SqlInt16 y);
+        public static SqlBoolean NotEquals(SqlInt16 x, SqlInt16 y);
+        public static SqlInt16 OnesComplement(SqlInt16 x);
+        public static SqlInt16 operator +(SqlInt16 x, SqlInt16 y);
+        public static SqlInt16 operator &(SqlInt16 x, SqlInt16 y);
+        public static SqlInt16 operator |(SqlInt16 x, SqlInt16 y);
+        public static SqlInt16 operator /(SqlInt16 x, SqlInt16 y);
+        public static SqlBoolean operator ==(SqlInt16 x, SqlInt16 y);
+        public static SqlInt16 operator ^(SqlInt16 x, SqlInt16 y);
+        public static explicit operator SqlInt16 (SqlBoolean x);
+        public static explicit operator SqlInt16 (SqlDecimal x);
+        public static explicit operator SqlInt16 (SqlDouble x);
+        public static explicit operator short (SqlInt16 x);
+        public static explicit operator SqlInt16 (SqlInt32 x);
+        public static explicit operator SqlInt16 (SqlInt64 x);
+        public static explicit operator SqlInt16 (SqlMoney x);
+        public static explicit operator SqlInt16 (SqlSingle x);
+        public static explicit operator SqlInt16 (SqlString x);
+        public static SqlBoolean operator >(SqlInt16 x, SqlInt16 y);
+        public static SqlBoolean operator >=(SqlInt16 x, SqlInt16 y);
+        public static implicit operator SqlInt16 (SqlByte x);
+        public static implicit operator SqlInt16 (short x);
+        public static SqlBoolean operator !=(SqlInt16 x, SqlInt16 y);
+        public static SqlBoolean operator <(SqlInt16 x, SqlInt16 y);
+        public static SqlBoolean operator <=(SqlInt16 x, SqlInt16 y);
+        public static SqlInt16 operator %(SqlInt16 x, SqlInt16 y);
+        public static SqlInt16 operator *(SqlInt16 x, SqlInt16 y);
+        public static SqlInt16 operator ~(SqlInt16 x);
+        public static SqlInt16 operator -(SqlInt16 x, SqlInt16 y);
+        public static SqlInt16 operator -(SqlInt16 x);
+        public static SqlInt16 Parse(string s);
+        public static SqlInt16 Subtract(SqlInt16 x, SqlInt16 y);
+        public SqlBoolean ToSqlBoolean();
+        public SqlByte ToSqlByte();
+        public SqlDecimal ToSqlDecimal();
+        public SqlDouble ToSqlDouble();
+        public SqlInt32 ToSqlInt32();
+        public SqlInt64 ToSqlInt64();
+        public SqlMoney ToSqlMoney();
+        public SqlSingle ToSqlSingle();
+        public SqlString ToSqlString();
+        public override string ToString();
+        public static SqlInt16 Xor(SqlInt16 x, SqlInt16 y);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct SqlInt32 : IComparable, INullable {
+        public static readonly SqlInt32 MaxValue;
+        public static readonly SqlInt32 MinValue;
+        public static readonly SqlInt32 Null;
+        public static readonly SqlInt32 Zero;
+        public SqlInt32(int value);
+        public bool IsNull { get; }
+        public int Value { get; }
+        public static SqlInt32 Add(SqlInt32 x, SqlInt32 y);
+        public static SqlInt32 BitwiseAnd(SqlInt32 x, SqlInt32 y);
+        public static SqlInt32 BitwiseOr(SqlInt32 x, SqlInt32 y);
+        public int CompareTo(SqlInt32 value);
+        public int CompareTo(object value);
+        public static SqlInt32 Divide(SqlInt32 x, SqlInt32 y);
+        public static SqlBoolean Equals(SqlInt32 x, SqlInt32 y);
+        public override bool Equals(object value);
+        public override int GetHashCode();
+        public static SqlBoolean GreaterThan(SqlInt32 x, SqlInt32 y);
+        public static SqlBoolean GreaterThanOrEqual(SqlInt32 x, SqlInt32 y);
+        public static SqlBoolean LessThan(SqlInt32 x, SqlInt32 y);
+        public static SqlBoolean LessThanOrEqual(SqlInt32 x, SqlInt32 y);
+        public static SqlInt32 Mod(SqlInt32 x, SqlInt32 y);
+        public static SqlInt32 Modulus(SqlInt32 x, SqlInt32 y);
+        public static SqlInt32 Multiply(SqlInt32 x, SqlInt32 y);
+        public static SqlBoolean NotEquals(SqlInt32 x, SqlInt32 y);
+        public static SqlInt32 OnesComplement(SqlInt32 x);
+        public static SqlInt32 operator +(SqlInt32 x, SqlInt32 y);
+        public static SqlInt32 operator &(SqlInt32 x, SqlInt32 y);
+        public static SqlInt32 operator |(SqlInt32 x, SqlInt32 y);
+        public static SqlInt32 operator /(SqlInt32 x, SqlInt32 y);
+        public static SqlBoolean operator ==(SqlInt32 x, SqlInt32 y);
+        public static SqlInt32 operator ^(SqlInt32 x, SqlInt32 y);
+        public static explicit operator SqlInt32 (SqlBoolean x);
+        public static explicit operator SqlInt32 (SqlDecimal x);
+        public static explicit operator SqlInt32 (SqlDouble x);
+        public static explicit operator int (SqlInt32 x);
+        public static explicit operator SqlInt32 (SqlInt64 x);
+        public static explicit operator SqlInt32 (SqlMoney x);
+        public static explicit operator SqlInt32 (SqlSingle x);
+        public static explicit operator SqlInt32 (SqlString x);
+        public static SqlBoolean operator >(SqlInt32 x, SqlInt32 y);
+        public static SqlBoolean operator >=(SqlInt32 x, SqlInt32 y);
+        public static implicit operator SqlInt32 (SqlByte x);
+        public static implicit operator SqlInt32 (SqlInt16 x);
+        public static implicit operator SqlInt32 (int x);
+        public static SqlBoolean operator !=(SqlInt32 x, SqlInt32 y);
+        public static SqlBoolean operator <(SqlInt32 x, SqlInt32 y);
+        public static SqlBoolean operator <=(SqlInt32 x, SqlInt32 y);
+        public static SqlInt32 operator %(SqlInt32 x, SqlInt32 y);
+        public static SqlInt32 operator *(SqlInt32 x, SqlInt32 y);
+        public static SqlInt32 operator ~(SqlInt32 x);
+        public static SqlInt32 operator -(SqlInt32 x, SqlInt32 y);
+        public static SqlInt32 operator -(SqlInt32 x);
+        public static SqlInt32 Parse(string s);
+        public static SqlInt32 Subtract(SqlInt32 x, SqlInt32 y);
+        public SqlBoolean ToSqlBoolean();
+        public SqlByte ToSqlByte();
+        public SqlDecimal ToSqlDecimal();
+        public SqlDouble ToSqlDouble();
+        public SqlInt16 ToSqlInt16();
+        public SqlInt64 ToSqlInt64();
+        public SqlMoney ToSqlMoney();
+        public SqlSingle ToSqlSingle();
+        public SqlString ToSqlString();
+        public override string ToString();
+        public static SqlInt32 Xor(SqlInt32 x, SqlInt32 y);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct SqlInt64 : IComparable, INullable {
+        public static readonly SqlInt64 MaxValue;
+        public static readonly SqlInt64 MinValue;
+        public static readonly SqlInt64 Null;
+        public static readonly SqlInt64 Zero;
+        public SqlInt64(long value);
+        public bool IsNull { get; }
+        public long Value { get; }
+        public static SqlInt64 Add(SqlInt64 x, SqlInt64 y);
+        public static SqlInt64 BitwiseAnd(SqlInt64 x, SqlInt64 y);
+        public static SqlInt64 BitwiseOr(SqlInt64 x, SqlInt64 y);
+        public int CompareTo(SqlInt64 value);
+        public int CompareTo(object value);
+        public static SqlInt64 Divide(SqlInt64 x, SqlInt64 y);
+        public static SqlBoolean Equals(SqlInt64 x, SqlInt64 y);
+        public override bool Equals(object value);
+        public override int GetHashCode();
+        public static SqlBoolean GreaterThan(SqlInt64 x, SqlInt64 y);
+        public static SqlBoolean GreaterThanOrEqual(SqlInt64 x, SqlInt64 y);
+        public static SqlBoolean LessThan(SqlInt64 x, SqlInt64 y);
+        public static SqlBoolean LessThanOrEqual(SqlInt64 x, SqlInt64 y);
+        public static SqlInt64 Mod(SqlInt64 x, SqlInt64 y);
+        public static SqlInt64 Modulus(SqlInt64 x, SqlInt64 y);
+        public static SqlInt64 Multiply(SqlInt64 x, SqlInt64 y);
+        public static SqlBoolean NotEquals(SqlInt64 x, SqlInt64 y);
+        public static SqlInt64 OnesComplement(SqlInt64 x);
+        public static SqlInt64 operator +(SqlInt64 x, SqlInt64 y);
+        public static SqlInt64 operator &(SqlInt64 x, SqlInt64 y);
+        public static SqlInt64 operator |(SqlInt64 x, SqlInt64 y);
+        public static SqlInt64 operator /(SqlInt64 x, SqlInt64 y);
+        public static SqlBoolean operator ==(SqlInt64 x, SqlInt64 y);
+        public static SqlInt64 operator ^(SqlInt64 x, SqlInt64 y);
+        public static explicit operator SqlInt64 (SqlBoolean x);
+        public static explicit operator SqlInt64 (SqlDecimal x);
+        public static explicit operator SqlInt64 (SqlDouble x);
+        public static explicit operator long (SqlInt64 x);
+        public static explicit operator SqlInt64 (SqlMoney x);
+        public static explicit operator SqlInt64 (SqlSingle x);
+        public static explicit operator SqlInt64 (SqlString x);
+        public static SqlBoolean operator >(SqlInt64 x, SqlInt64 y);
+        public static SqlBoolean operator >=(SqlInt64 x, SqlInt64 y);
+        public static implicit operator SqlInt64 (SqlByte x);
+        public static implicit operator SqlInt64 (SqlInt16 x);
+        public static implicit operator SqlInt64 (SqlInt32 x);
+        public static implicit operator SqlInt64 (long x);
+        public static SqlBoolean operator !=(SqlInt64 x, SqlInt64 y);
+        public static SqlBoolean operator <(SqlInt64 x, SqlInt64 y);
+        public static SqlBoolean operator <=(SqlInt64 x, SqlInt64 y);
+        public static SqlInt64 operator %(SqlInt64 x, SqlInt64 y);
+        public static SqlInt64 operator *(SqlInt64 x, SqlInt64 y);
+        public static SqlInt64 operator ~(SqlInt64 x);
+        public static SqlInt64 operator -(SqlInt64 x, SqlInt64 y);
+        public static SqlInt64 operator -(SqlInt64 x);
+        public static SqlInt64 Parse(string s);
+        public static SqlInt64 Subtract(SqlInt64 x, SqlInt64 y);
+        public SqlBoolean ToSqlBoolean();
+        public SqlByte ToSqlByte();
+        public SqlDecimal ToSqlDecimal();
+        public SqlDouble ToSqlDouble();
+        public SqlInt16 ToSqlInt16();
+        public SqlInt32 ToSqlInt32();
+        public SqlMoney ToSqlMoney();
+        public SqlSingle ToSqlSingle();
+        public SqlString ToSqlString();
+        public override string ToString();
+        public static SqlInt64 Xor(SqlInt64 x, SqlInt64 y);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct SqlMoney : IComparable, INullable {
+        public static readonly SqlMoney MaxValue;
+        public static readonly SqlMoney MinValue;
+        public static readonly SqlMoney Null;
+        public static readonly SqlMoney Zero;
+        public SqlMoney(Decimal value);
+        public SqlMoney(double value);
+        public SqlMoney(int value);
+        public SqlMoney(long value);
+        public bool IsNull { get; }
+        public Decimal Value { get; }
+        public static SqlMoney Add(SqlMoney x, SqlMoney y);
+        public int CompareTo(SqlMoney value);
+        public int CompareTo(object value);
+        public static SqlMoney Divide(SqlMoney x, SqlMoney y);
+        public static SqlBoolean Equals(SqlMoney x, SqlMoney y);
+        public override bool Equals(object value);
+        public override int GetHashCode();
+        public static SqlBoolean GreaterThan(SqlMoney x, SqlMoney y);
+        public static SqlBoolean GreaterThanOrEqual(SqlMoney x, SqlMoney y);
+        public static SqlBoolean LessThan(SqlMoney x, SqlMoney y);
+        public static SqlBoolean LessThanOrEqual(SqlMoney x, SqlMoney y);
+        public static SqlMoney Multiply(SqlMoney x, SqlMoney y);
+        public static SqlBoolean NotEquals(SqlMoney x, SqlMoney y);
+        public static SqlMoney operator +(SqlMoney x, SqlMoney y);
+        public static SqlMoney operator /(SqlMoney x, SqlMoney y);
+        public static SqlBoolean operator ==(SqlMoney x, SqlMoney y);
+        public static explicit operator SqlMoney (SqlBoolean x);
+        public static explicit operator SqlMoney (SqlDecimal x);
+        public static explicit operator SqlMoney (SqlDouble x);
+        public static explicit operator Decimal (SqlMoney x);
+        public static explicit operator SqlMoney (SqlSingle x);
+        public static explicit operator SqlMoney (SqlString x);
+        public static explicit operator SqlMoney (double x);
+        public static SqlBoolean operator >(SqlMoney x, SqlMoney y);
+        public static SqlBoolean operator >=(SqlMoney x, SqlMoney y);
+        public static implicit operator SqlMoney (SqlByte x);
+        public static implicit operator SqlMoney (SqlInt16 x);
+        public static implicit operator SqlMoney (SqlInt32 x);
+        public static implicit operator SqlMoney (SqlInt64 x);
+        public static implicit operator SqlMoney (Decimal x);
+        public static implicit operator SqlMoney (long x);
+        public static SqlBoolean operator !=(SqlMoney x, SqlMoney y);
+        public static SqlBoolean operator <(SqlMoney x, SqlMoney y);
+        public static SqlBoolean operator <=(SqlMoney x, SqlMoney y);
+        public static SqlMoney operator *(SqlMoney x, SqlMoney y);
+        public static SqlMoney operator -(SqlMoney x, SqlMoney y);
+        public static SqlMoney operator -(SqlMoney x);
+        public static SqlMoney Parse(string s);
+        public static SqlMoney Subtract(SqlMoney x, SqlMoney y);
+        public Decimal ToDecimal();
+        public double ToDouble();
+        public int ToInt32();
+        public long ToInt64();
+        public SqlBoolean ToSqlBoolean();
+        public SqlByte ToSqlByte();
+        public SqlDecimal ToSqlDecimal();
+        public SqlDouble ToSqlDouble();
+        public SqlInt16 ToSqlInt16();
+        public SqlInt32 ToSqlInt32();
+        public SqlInt64 ToSqlInt64();
+        public SqlSingle ToSqlSingle();
+        public SqlString ToSqlString();
+        public override string ToString();
+    }
+    public sealed class SqlNullValueException : SqlTypeException {
+        public SqlNullValueException();
+        public SqlNullValueException(string message);
+        public SqlNullValueException(string message, Exception e);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct SqlSingle : IComparable, INullable {
+        public static readonly SqlSingle MaxValue;
+        public static readonly SqlSingle MinValue;
+        public static readonly SqlSingle Null;
+        public static readonly SqlSingle Zero;
+        public SqlSingle(double value);
+        public SqlSingle(float value);
+        public bool IsNull { get; }
+        public float Value { get; }
+        public static SqlSingle Add(SqlSingle x, SqlSingle y);
+        public int CompareTo(SqlSingle value);
+        public int CompareTo(object value);
+        public static SqlSingle Divide(SqlSingle x, SqlSingle y);
+        public static SqlBoolean Equals(SqlSingle x, SqlSingle y);
+        public override bool Equals(object value);
+        public override int GetHashCode();
+        public static SqlBoolean GreaterThan(SqlSingle x, SqlSingle y);
+        public static SqlBoolean GreaterThanOrEqual(SqlSingle x, SqlSingle y);
+        public static SqlBoolean LessThan(SqlSingle x, SqlSingle y);
+        public static SqlBoolean LessThanOrEqual(SqlSingle x, SqlSingle y);
+        public static SqlSingle Multiply(SqlSingle x, SqlSingle y);
+        public static SqlBoolean NotEquals(SqlSingle x, SqlSingle y);
+        public static SqlSingle operator +(SqlSingle x, SqlSingle y);
+        public static SqlSingle operator /(SqlSingle x, SqlSingle y);
+        public static SqlBoolean operator ==(SqlSingle x, SqlSingle y);
+        public static explicit operator SqlSingle (SqlBoolean x);
+        public static explicit operator SqlSingle (SqlDouble x);
+        public static explicit operator float (SqlSingle x);
+        public static explicit operator SqlSingle (SqlString x);
+        public static SqlBoolean operator >(SqlSingle x, SqlSingle y);
+        public static SqlBoolean operator >=(SqlSingle x, SqlSingle y);
+        public static implicit operator SqlSingle (SqlByte x);
+        public static implicit operator SqlSingle (SqlDecimal x);
+        public static implicit operator SqlSingle (SqlInt16 x);
+        public static implicit operator SqlSingle (SqlInt32 x);
+        public static implicit operator SqlSingle (SqlInt64 x);
+        public static implicit operator SqlSingle (SqlMoney x);
+        public static implicit operator SqlSingle (float x);
+        public static SqlBoolean operator !=(SqlSingle x, SqlSingle y);
+        public static SqlBoolean operator <(SqlSingle x, SqlSingle y);
+        public static SqlBoolean operator <=(SqlSingle x, SqlSingle y);
+        public static SqlSingle operator *(SqlSingle x, SqlSingle y);
+        public static SqlSingle operator -(SqlSingle x, SqlSingle y);
+        public static SqlSingle operator -(SqlSingle x);
+        public static SqlSingle Parse(string s);
+        public static SqlSingle Subtract(SqlSingle x, SqlSingle y);
+        public SqlBoolean ToSqlBoolean();
+        public SqlByte ToSqlByte();
+        public SqlDecimal ToSqlDecimal();
+        public SqlDouble ToSqlDouble();
+        public SqlInt16 ToSqlInt16();
+        public SqlInt32 ToSqlInt32();
+        public SqlInt64 ToSqlInt64();
+        public SqlMoney ToSqlMoney();
+        public SqlString ToSqlString();
+        public override string ToString();
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct SqlString : IComparable, INullable {
+        public static readonly SqlString Null;
+        public static readonly int BinarySort;
+        public static readonly int BinarySort2;
+        public static readonly int IgnoreCase;
+        public static readonly int IgnoreKanaType;
+        public static readonly int IgnoreNonSpace;
+        public static readonly int IgnoreWidth;
+        public SqlString(int lcid, SqlCompareOptions compareOptions, byte[] data);
+        public SqlString(int lcid, SqlCompareOptions compareOptions, byte[] data, bool fUnicode);
+        public SqlString(int lcid, SqlCompareOptions compareOptions, byte[] data, int index, int count);
+        public SqlString(int lcid, SqlCompareOptions compareOptions, byte[] data, int index, int count, bool fUnicode);
+        public SqlString(string data);
+        public SqlString(string data, int lcid);
+        public SqlString(string data, int lcid, SqlCompareOptions compareOptions);
+        public CompareInfo CompareInfo { get; }
+        public CultureInfo CultureInfo { get; }
+        public bool IsNull { get; }
+        public int LCID { get; }
+        public SqlCompareOptions SqlCompareOptions { get; }
+        public string Value { get; }
+        public static SqlString Add(SqlString x, SqlString y);
+        public SqlString Clone();
+        public static CompareOptions CompareOptionsFromSqlCompareOptions(SqlCompareOptions compareOptions);
+        public int CompareTo(SqlString value);
+        public int CompareTo(object value);
+        public static SqlString Concat(SqlString x, SqlString y);
+        public static SqlBoolean Equals(SqlString x, SqlString y);
+        public override bool Equals(object value);
+        public override int GetHashCode();
+        public byte[] GetNonUnicodeBytes();
+        public byte[] GetUnicodeBytes();
+        public static SqlBoolean GreaterThan(SqlString x, SqlString y);
+        public static SqlBoolean GreaterThanOrEqual(SqlString x, SqlString y);
+        public static SqlBoolean LessThan(SqlString x, SqlString y);
+        public static SqlBoolean LessThanOrEqual(SqlString x, SqlString y);
+        public static SqlBoolean NotEquals(SqlString x, SqlString y);
+        public static SqlString operator +(SqlString x, SqlString y);
+        public static SqlBoolean operator ==(SqlString x, SqlString y);
+        public static explicit operator SqlString (SqlBoolean x);
+        public static explicit operator SqlString (SqlByte x);
+        public static explicit operator SqlString (SqlDateTime x);
+        public static explicit operator SqlString (SqlDecimal x);
+        public static explicit operator SqlString (SqlDouble x);
+        public static explicit operator SqlString (SqlGuid x);
+        public static explicit operator SqlString (SqlInt16 x);
+        public static explicit operator SqlString (SqlInt32 x);
+        public static explicit operator SqlString (SqlInt64 x);
+        public static explicit operator SqlString (SqlMoney x);
+        public static explicit operator SqlString (SqlSingle x);
+        public static explicit operator string (SqlString x);
+        public static SqlBoolean operator >(SqlString x, SqlString y);
+        public static SqlBoolean operator >=(SqlString x, SqlString y);
+        public static implicit operator SqlString (string x);
+        public static SqlBoolean operator !=(SqlString x, SqlString y);
+        public static SqlBoolean operator <(SqlString x, SqlString y);
+        public static SqlBoolean operator <=(SqlString x, SqlString y);
+        public SqlBoolean ToSqlBoolean();
+        public SqlByte ToSqlByte();
+        public SqlDateTime ToSqlDateTime();
+        public SqlDecimal ToSqlDecimal();
+        public SqlDouble ToSqlDouble();
+        public SqlGuid ToSqlGuid();
+        public SqlInt16 ToSqlInt16();
+        public SqlInt32 ToSqlInt32();
+        public SqlInt64 ToSqlInt64();
+        public SqlMoney ToSqlMoney();
+        public SqlSingle ToSqlSingle();
+        public override string ToString();
+    }
+    public sealed class SqlTruncateException : SqlTypeException {
+        public SqlTruncateException();
+        public SqlTruncateException(string message);
+        public SqlTruncateException(string message, Exception e);
+    }
+    public class SqlTypeException : Exception {
+        public SqlTypeException();
+        public SqlTypeException(string message);
+        public SqlTypeException(string message, Exception e);
+    }
+    public sealed class SqlXml : INullable {
+        public SqlXml();
+        public SqlXml(Stream value);
+        public SqlXml(XmlReader value);
+        public bool IsNull { get; }
+        public static SqlXml Null { get; }
+        public string Value { get; }
+        public XmlReader CreateReader();
+    }
+}
```

