# System.IO.Pipes

``` diff
+namespace System.IO.Pipes {
+    public sealed class AnonymousPipeClientStream : PipeStream {
+        public AnonymousPipeClientStream(PipeDirection direction, SafePipeHandle safePipeHandle);
+        public AnonymousPipeClientStream(PipeDirection direction, string pipeHandleAsString);
+        public AnonymousPipeClientStream(string pipeHandleAsString);
+        public override PipeTransmissionMode ReadMode { set; }
+        public override PipeTransmissionMode TransmissionMode { get; }
+        ~AnonymousPipeClientStream();
+    }
+    public sealed class AnonymousPipeServerStream : PipeStream {
+        public AnonymousPipeServerStream();
+        public AnonymousPipeServerStream(PipeDirection direction);
+        public AnonymousPipeServerStream(PipeDirection direction, SafePipeHandle serverSafePipeHandle, SafePipeHandle clientSafePipeHandle);
+        public AnonymousPipeServerStream(PipeDirection direction, HandleInheritability inheritability);
+        public AnonymousPipeServerStream(PipeDirection direction, HandleInheritability inheritability, int bufferSize);
+        public SafePipeHandle ClientSafePipeHandle { get; }
+        public override PipeTransmissionMode ReadMode { set; }
+        public override PipeTransmissionMode TransmissionMode { get; }
+        protected override void Dispose(bool disposing);
+        public void DisposeLocalCopyOfClientHandle();
+        ~AnonymousPipeServerStream();
+        public string GetClientHandleAsString();
+    }
+    public sealed class NamedPipeClientStream : PipeStream {
+        public NamedPipeClientStream(PipeDirection direction, bool isAsync, bool isConnected, SafePipeHandle safePipeHandle);
+        public NamedPipeClientStream(string pipeName);
+        public NamedPipeClientStream(string serverName, string pipeName);
+        public NamedPipeClientStream(string serverName, string pipeName, PipeDirection direction);
+        public NamedPipeClientStream(string serverName, string pipeName, PipeDirection direction, PipeOptions options);
+        public NamedPipeClientStream(string serverName, string pipeName, PipeDirection direction, PipeOptions options, TokenImpersonationLevel impersonationLevel);
+        public int NumberOfServerInstances { get; }
+        public void Connect();
+        public void Connect(int timeout);
+        public Task ConnectAsync();
+        public Task ConnectAsync(int timeout);
+        public Task ConnectAsync(int timeout, CancellationToken cancellationToken);
+        public Task ConnectAsync(CancellationToken cancellationToken);
+        ~NamedPipeClientStream();
+    }
+    public sealed class NamedPipeServerStream : PipeStream {
+        public NamedPipeServerStream(PipeDirection direction, bool isAsync, bool isConnected, SafePipeHandle safePipeHandle);
+        public NamedPipeServerStream(string pipeName);
+        public NamedPipeServerStream(string pipeName, PipeDirection direction);
+        public NamedPipeServerStream(string pipeName, PipeDirection direction, int maxNumberOfServerInstances);
+        public NamedPipeServerStream(string pipeName, PipeDirection direction, int maxNumberOfServerInstances, PipeTransmissionMode transmissionMode);
+        public NamedPipeServerStream(string pipeName, PipeDirection direction, int maxNumberOfServerInstances, PipeTransmissionMode transmissionMode, PipeOptions options);
+        public NamedPipeServerStream(string pipeName, PipeDirection direction, int maxNumberOfServerInstances, PipeTransmissionMode transmissionMode, PipeOptions options, int inBufferSize, int outBufferSize);
+        public void Disconnect();
+        ~NamedPipeServerStream();
+        public string GetImpersonationUserName();
+        public void WaitForConnection();
+        public Task WaitForConnectionAsync();
+        public Task WaitForConnectionAsync(CancellationToken cancellationToken);
+    }
+    public enum PipeDirection {
+        In = 1,
+        InOut = 3,
+        Out = 2,
+    }
+    public enum PipeOptions {
+        Asynchronous = 1073741824,
+        None = 0,
+        WriteThrough = -2147483648,
+    }
+    public abstract class PipeStream : Stream {
+        protected PipeStream(PipeDirection direction, int bufferSize);
+        protected PipeStream(PipeDirection direction, PipeTransmissionMode transmissionMode, int outBufferSize);
+        public override bool CanRead { get; }
+        public override bool CanSeek { get; }
+        public override bool CanWrite { get; }
+        public virtual int InBufferSize { get; }
+        public bool IsAsync { get; }
+        public bool IsConnected { get; protected set; }
+        public bool IsMessageComplete { get; }
+        public override long Length { get; }
+        public virtual int OutBufferSize { get; }
+        public override long Position { get; set; }
+        public virtual PipeTransmissionMode ReadMode { get; set; }
+        public SafePipeHandle SafePipeHandle { get; }
+        public virtual PipeTransmissionMode TransmissionMode { get; }
+        protected override void Dispose(bool disposing);
+        public override void Flush();
+        public override int Read(byte[] buffer, int offset, int count);
+        public override Task<int> ReadAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken);
+        public override int ReadByte();
+        public override long Seek(long offset, SeekOrigin origin);
+        public override void SetLength(long value);
+        public void WaitForPipeDrain();
+        public override void Write(byte[] buffer, int offset, int count);
+        public override Task WriteAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken);
+        public override void WriteByte(byte value);
+    }
+    public enum PipeTransmissionMode {
+        Byte = 0,
+        Message = 1,
+    }
+}
```

