# System.Linq

``` diff
+namespace System.Linq {
+    public static class Enumerable {
+        public static TResult Aggregate<TSource, TAccumulate, TResult>(this IEnumerable<TSource> source, TAccumulate seed, Func<TAccumulate, TSource, TAccumulate> func, Func<TAccumulate, TResult> resultSelector);
+        public static TAccumulate Aggregate<TSource, TAccumulate>(this IEnumerable<TSource> source, TAccumulate seed, Func<TAccumulate, TSource, TAccumulate> func);
+        public static TSource Aggregate<TSource>(this IEnumerable<TSource> source, Func<TSource, TSource, TSource> func);
+        public static bool All<TSource>(this IEnumerable<TSource> source, Func<TSource, bool> predicate);
+        public static bool Any<TSource>(this IEnumerable<TSource> source);
+        public static bool Any<TSource>(this IEnumerable<TSource> source, Func<TSource, bool> predicate);
+        public static IEnumerable<TSource> Append<TSource>(this IEnumerable<TSource> source, TSource element);
+        public static IEnumerable<TSource> AsEnumerable<TSource>(this IEnumerable<TSource> source);
+        public static Decimal Average(this IEnumerable<Decimal> source);
+        public static double Average(this IEnumerable<double> source);
+        public static double Average(this IEnumerable<int> source);
+        public static double Average(this IEnumerable<long> source);
+        public static Nullable<Decimal> Average(this IEnumerable<Nullable<Decimal>> source);
+        public static Nullable<double> Average(this IEnumerable<Nullable<double>> source);
+        public static Nullable<double> Average(this IEnumerable<Nullable<int>> source);
+        public static Nullable<double> Average(this IEnumerable<Nullable<long>> source);
+        public static Nullable<float> Average(this IEnumerable<Nullable<float>> source);
+        public static float Average(this IEnumerable<float> source);
+        public static Decimal Average<TSource>(this IEnumerable<TSource> source, Func<TSource, Decimal> selector);
+        public static double Average<TSource>(this IEnumerable<TSource> source, Func<TSource, double> selector);
+        public static double Average<TSource>(this IEnumerable<TSource> source, Func<TSource, int> selector);
+        public static double Average<TSource>(this IEnumerable<TSource> source, Func<TSource, long> selector);
+        public static Nullable<Decimal> Average<TSource>(this IEnumerable<TSource> source, Func<TSource, Nullable<Decimal>> selector);
+        public static Nullable<double> Average<TSource>(this IEnumerable<TSource> source, Func<TSource, Nullable<double>> selector);
+        public static Nullable<double> Average<TSource>(this IEnumerable<TSource> source, Func<TSource, Nullable<int>> selector);
+        public static Nullable<double> Average<TSource>(this IEnumerable<TSource> source, Func<TSource, Nullable<long>> selector);
+        public static Nullable<float> Average<TSource>(this IEnumerable<TSource> source, Func<TSource, Nullable<float>> selector);
+        public static float Average<TSource>(this IEnumerable<TSource> source, Func<TSource, float> selector);
+        public static IEnumerable<TResult> Cast<TResult>(this IEnumerable source);
+        public static IEnumerable<TSource> Concat<TSource>(this IEnumerable<TSource> first, IEnumerable<TSource> second);
+        public static bool Contains<TSource>(this IEnumerable<TSource> source, TSource value);
+        public static bool Contains<TSource>(this IEnumerable<TSource> source, TSource value, IEqualityComparer<TSource> comparer);
+        public static int Count<TSource>(this IEnumerable<TSource> source);
+        public static int Count<TSource>(this IEnumerable<TSource> source, Func<TSource, bool> predicate);
+        public static IEnumerable<TSource> DefaultIfEmpty<TSource>(this IEnumerable<TSource> source);
+        public static IEnumerable<TSource> DefaultIfEmpty<TSource>(this IEnumerable<TSource> source, TSource defaultValue);
+        public static IEnumerable<TSource> Distinct<TSource>(this IEnumerable<TSource> source);
+        public static IEnumerable<TSource> Distinct<TSource>(this IEnumerable<TSource> source, IEqualityComparer<TSource> comparer);
+        public static TSource ElementAt<TSource>(this IEnumerable<TSource> source, int index);
+        public static TSource ElementAtOrDefault<TSource>(this IEnumerable<TSource> source, int index);
+        public static IEnumerable<TResult> Empty<TResult>();
+        public static IEnumerable<TSource> Except<TSource>(this IEnumerable<TSource> first, IEnumerable<TSource> second);
+        public static IEnumerable<TSource> Except<TSource>(this IEnumerable<TSource> first, IEnumerable<TSource> second, IEqualityComparer<TSource> comparer);
+        public static TSource First<TSource>(this IEnumerable<TSource> source);
+        public static TSource First<TSource>(this IEnumerable<TSource> source, Func<TSource, bool> predicate);
+        public static TSource FirstOrDefault<TSource>(this IEnumerable<TSource> source);
+        public static TSource FirstOrDefault<TSource>(this IEnumerable<TSource> source, Func<TSource, bool> predicate);
+        public static IEnumerable<TResult> GroupBy<TSource, TKey, TElement, TResult>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TElement> elementSelector, Func<TKey, IEnumerable<TElement>, TResult> resultSelector);
+        public static IEnumerable<TResult> GroupBy<TSource, TKey, TElement, TResult>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TElement> elementSelector, Func<TKey, IEnumerable<TElement>, TResult> resultSelector, IEqualityComparer<TKey> comparer);
+        public static IEnumerable<IGrouping<TKey, TElement>> GroupBy<TSource, TKey, TElement>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TElement> elementSelector);
+        public static IEnumerable<IGrouping<TKey, TElement>> GroupBy<TSource, TKey, TElement>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TElement> elementSelector, IEqualityComparer<TKey> comparer);
+        public static IEnumerable<TResult> GroupBy<TSource, TKey, TResult>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector, Func<TKey, IEnumerable<TSource>, TResult> resultSelector);
+        public static IEnumerable<TResult> GroupBy<TSource, TKey, TResult>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector, Func<TKey, IEnumerable<TSource>, TResult> resultSelector, IEqualityComparer<TKey> comparer);
+        public static IEnumerable<IGrouping<TKey, TSource>> GroupBy<TSource, TKey>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector);
+        public static IEnumerable<IGrouping<TKey, TSource>> GroupBy<TSource, TKey>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector, IEqualityComparer<TKey> comparer);
+        public static IEnumerable<TResult> GroupJoin<TOuter, TInner, TKey, TResult>(this IEnumerable<TOuter> outer, IEnumerable<TInner> inner, Func<TOuter, TKey> outerKeySelector, Func<TInner, TKey> innerKeySelector, Func<TOuter, IEnumerable<TInner>, TResult> resultSelector);
+        public static IEnumerable<TResult> GroupJoin<TOuter, TInner, TKey, TResult>(this IEnumerable<TOuter> outer, IEnumerable<TInner> inner, Func<TOuter, TKey> outerKeySelector, Func<TInner, TKey> innerKeySelector, Func<TOuter, IEnumerable<TInner>, TResult> resultSelector, IEqualityComparer<TKey> comparer);
+        public static IEnumerable<TSource> Intersect<TSource>(this IEnumerable<TSource> first, IEnumerable<TSource> second);
+        public static IEnumerable<TSource> Intersect<TSource>(this IEnumerable<TSource> first, IEnumerable<TSource> second, IEqualityComparer<TSource> comparer);
+        public static IEnumerable<TResult> Join<TOuter, TInner, TKey, TResult>(this IEnumerable<TOuter> outer, IEnumerable<TInner> inner, Func<TOuter, TKey> outerKeySelector, Func<TInner, TKey> innerKeySelector, Func<TOuter, TInner, TResult> resultSelector);
+        public static IEnumerable<TResult> Join<TOuter, TInner, TKey, TResult>(this IEnumerable<TOuter> outer, IEnumerable<TInner> inner, Func<TOuter, TKey> outerKeySelector, Func<TInner, TKey> innerKeySelector, Func<TOuter, TInner, TResult> resultSelector, IEqualityComparer<TKey> comparer);
+        public static TSource Last<TSource>(this IEnumerable<TSource> source);
+        public static TSource Last<TSource>(this IEnumerable<TSource> source, Func<TSource, bool> predicate);
+        public static TSource LastOrDefault<TSource>(this IEnumerable<TSource> source);
+        public static TSource LastOrDefault<TSource>(this IEnumerable<TSource> source, Func<TSource, bool> predicate);
+        public static long LongCount<TSource>(this IEnumerable<TSource> source);
+        public static long LongCount<TSource>(this IEnumerable<TSource> source, Func<TSource, bool> predicate);
+        public static Decimal Max(this IEnumerable<Decimal> source);
+        public static double Max(this IEnumerable<double> source);
+        public static int Max(this IEnumerable<int> source);
+        public static long Max(this IEnumerable<long> source);
+        public static Nullable<Decimal> Max(this IEnumerable<Nullable<Decimal>> source);
+        public static Nullable<double> Max(this IEnumerable<Nullable<double>> source);
+        public static Nullable<int> Max(this IEnumerable<Nullable<int>> source);
+        public static Nullable<long> Max(this IEnumerable<Nullable<long>> source);
+        public static Nullable<float> Max(this IEnumerable<Nullable<float>> source);
+        public static float Max(this IEnumerable<float> source);
+        public static TResult Max<TSource, TResult>(this IEnumerable<TSource> source, Func<TSource, TResult> selector);
+        public static TSource Max<TSource>(this IEnumerable<TSource> source);
+        public static Decimal Max<TSource>(this IEnumerable<TSource> source, Func<TSource, Decimal> selector);
+        public static double Max<TSource>(this IEnumerable<TSource> source, Func<TSource, double> selector);
+        public static int Max<TSource>(this IEnumerable<TSource> source, Func<TSource, int> selector);
+        public static long Max<TSource>(this IEnumerable<TSource> source, Func<TSource, long> selector);
+        public static Nullable<Decimal> Max<TSource>(this IEnumerable<TSource> source, Func<TSource, Nullable<Decimal>> selector);
+        public static Nullable<double> Max<TSource>(this IEnumerable<TSource> source, Func<TSource, Nullable<double>> selector);
+        public static Nullable<int> Max<TSource>(this IEnumerable<TSource> source, Func<TSource, Nullable<int>> selector);
+        public static Nullable<long> Max<TSource>(this IEnumerable<TSource> source, Func<TSource, Nullable<long>> selector);
+        public static Nullable<float> Max<TSource>(this IEnumerable<TSource> source, Func<TSource, Nullable<float>> selector);
+        public static float Max<TSource>(this IEnumerable<TSource> source, Func<TSource, float> selector);
+        public static Decimal Min(this IEnumerable<Decimal> source);
+        public static double Min(this IEnumerable<double> source);
+        public static int Min(this IEnumerable<int> source);
+        public static long Min(this IEnumerable<long> source);
+        public static Nullable<Decimal> Min(this IEnumerable<Nullable<Decimal>> source);
+        public static Nullable<double> Min(this IEnumerable<Nullable<double>> source);
+        public static Nullable<int> Min(this IEnumerable<Nullable<int>> source);
+        public static Nullable<long> Min(this IEnumerable<Nullable<long>> source);
+        public static Nullable<float> Min(this IEnumerable<Nullable<float>> source);
+        public static float Min(this IEnumerable<float> source);
+        public static TResult Min<TSource, TResult>(this IEnumerable<TSource> source, Func<TSource, TResult> selector);
+        public static TSource Min<TSource>(this IEnumerable<TSource> source);
+        public static Decimal Min<TSource>(this IEnumerable<TSource> source, Func<TSource, Decimal> selector);
+        public static double Min<TSource>(this IEnumerable<TSource> source, Func<TSource, double> selector);
+        public static int Min<TSource>(this IEnumerable<TSource> source, Func<TSource, int> selector);
+        public static long Min<TSource>(this IEnumerable<TSource> source, Func<TSource, long> selector);
+        public static Nullable<Decimal> Min<TSource>(this IEnumerable<TSource> source, Func<TSource, Nullable<Decimal>> selector);
+        public static Nullable<double> Min<TSource>(this IEnumerable<TSource> source, Func<TSource, Nullable<double>> selector);
+        public static Nullable<int> Min<TSource>(this IEnumerable<TSource> source, Func<TSource, Nullable<int>> selector);
+        public static Nullable<long> Min<TSource>(this IEnumerable<TSource> source, Func<TSource, Nullable<long>> selector);
+        public static Nullable<float> Min<TSource>(this IEnumerable<TSource> source, Func<TSource, Nullable<float>> selector);
+        public static float Min<TSource>(this IEnumerable<TSource> source, Func<TSource, float> selector);
+        public static IEnumerable<TResult> OfType<TResult>(this IEnumerable source);
+        public static IOrderedEnumerable<TSource> OrderBy<TSource, TKey>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector);
+        public static IOrderedEnumerable<TSource> OrderBy<TSource, TKey>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector, IComparer<TKey> comparer);
+        public static IOrderedEnumerable<TSource> OrderByDescending<TSource, TKey>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector);
+        public static IOrderedEnumerable<TSource> OrderByDescending<TSource, TKey>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector, IComparer<TKey> comparer);
+        public static IEnumerable<TSource> Prepend<TSource>(this IEnumerable<TSource> source, TSource element);
+        public static IEnumerable<int> Range(int start, int count);
+        public static IEnumerable<TResult> Repeat<TResult>(TResult element, int count);
+        public static IEnumerable<TSource> Reverse<TSource>(this IEnumerable<TSource> source);
+        public static IEnumerable<TResult> Select<TSource, TResult>(this IEnumerable<TSource> source, Func<TSource, int, TResult> selector);
+        public static IEnumerable<TResult> Select<TSource, TResult>(this IEnumerable<TSource> source, Func<TSource, TResult> selector);
+        public static IEnumerable<TResult> SelectMany<TSource, TCollection, TResult>(this IEnumerable<TSource> source, Func<TSource, IEnumerable<TCollection>> collectionSelector, Func<TSource, TCollection, TResult> resultSelector);
+        public static IEnumerable<TResult> SelectMany<TSource, TCollection, TResult>(this IEnumerable<TSource> source, Func<TSource, int, IEnumerable<TCollection>> collectionSelector, Func<TSource, TCollection, TResult> resultSelector);
+        public static IEnumerable<TResult> SelectMany<TSource, TResult>(this IEnumerable<TSource> source, Func<TSource, IEnumerable<TResult>> selector);
+        public static IEnumerable<TResult> SelectMany<TSource, TResult>(this IEnumerable<TSource> source, Func<TSource, int, IEnumerable<TResult>> selector);
+        public static bool SequenceEqual<TSource>(this IEnumerable<TSource> first, IEnumerable<TSource> second);
+        public static bool SequenceEqual<TSource>(this IEnumerable<TSource> first, IEnumerable<TSource> second, IEqualityComparer<TSource> comparer);
+        public static TSource Single<TSource>(this IEnumerable<TSource> source);
+        public static TSource Single<TSource>(this IEnumerable<TSource> source, Func<TSource, bool> predicate);
+        public static TSource SingleOrDefault<TSource>(this IEnumerable<TSource> source);
+        public static TSource SingleOrDefault<TSource>(this IEnumerable<TSource> source, Func<TSource, bool> predicate);
+        public static IEnumerable<TSource> Skip<TSource>(this IEnumerable<TSource> source, int count);
+        public static IEnumerable<TSource> SkipWhile<TSource>(this IEnumerable<TSource> source, Func<TSource, bool> predicate);
+        public static IEnumerable<TSource> SkipWhile<TSource>(this IEnumerable<TSource> source, Func<TSource, int, bool> predicate);
+        public static Decimal Sum(this IEnumerable<Decimal> source);
+        public static double Sum(this IEnumerable<double> source);
+        public static int Sum(this IEnumerable<int> source);
+        public static long Sum(this IEnumerable<long> source);
+        public static Nullable<Decimal> Sum(this IEnumerable<Nullable<Decimal>> source);
+        public static Nullable<double> Sum(this IEnumerable<Nullable<double>> source);
+        public static Nullable<int> Sum(this IEnumerable<Nullable<int>> source);
+        public static Nullable<long> Sum(this IEnumerable<Nullable<long>> source);
+        public static Nullable<float> Sum(this IEnumerable<Nullable<float>> source);
+        public static float Sum(this IEnumerable<float> source);
+        public static Decimal Sum<TSource>(this IEnumerable<TSource> source, Func<TSource, Decimal> selector);
+        public static double Sum<TSource>(this IEnumerable<TSource> source, Func<TSource, double> selector);
+        public static int Sum<TSource>(this IEnumerable<TSource> source, Func<TSource, int> selector);
+        public static long Sum<TSource>(this IEnumerable<TSource> source, Func<TSource, long> selector);
+        public static Nullable<Decimal> Sum<TSource>(this IEnumerable<TSource> source, Func<TSource, Nullable<Decimal>> selector);
+        public static Nullable<double> Sum<TSource>(this IEnumerable<TSource> source, Func<TSource, Nullable<double>> selector);
+        public static Nullable<int> Sum<TSource>(this IEnumerable<TSource> source, Func<TSource, Nullable<int>> selector);
+        public static Nullable<long> Sum<TSource>(this IEnumerable<TSource> source, Func<TSource, Nullable<long>> selector);
+        public static Nullable<float> Sum<TSource>(this IEnumerable<TSource> source, Func<TSource, Nullable<float>> selector);
+        public static float Sum<TSource>(this IEnumerable<TSource> source, Func<TSource, float> selector);
+        public static IEnumerable<TSource> Take<TSource>(this IEnumerable<TSource> source, int count);
+        public static IEnumerable<TSource> TakeWhile<TSource>(this IEnumerable<TSource> source, Func<TSource, bool> predicate);
+        public static IEnumerable<TSource> TakeWhile<TSource>(this IEnumerable<TSource> source, Func<TSource, int, bool> predicate);
+        public static IOrderedEnumerable<TSource> ThenBy<TSource, TKey>(this IOrderedEnumerable<TSource> source, Func<TSource, TKey> keySelector);
+        public static IOrderedEnumerable<TSource> ThenBy<TSource, TKey>(this IOrderedEnumerable<TSource> source, Func<TSource, TKey> keySelector, IComparer<TKey> comparer);
+        public static IOrderedEnumerable<TSource> ThenByDescending<TSource, TKey>(this IOrderedEnumerable<TSource> source, Func<TSource, TKey> keySelector);
+        public static IOrderedEnumerable<TSource> ThenByDescending<TSource, TKey>(this IOrderedEnumerable<TSource> source, Func<TSource, TKey> keySelector, IComparer<TKey> comparer);
+        public static TSource[] ToArray<TSource>(this IEnumerable<TSource> source);
+        public static Dictionary<TKey, TElement> ToDictionary<TSource, TKey, TElement>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TElement> elementSelector);
+        public static Dictionary<TKey, TElement> ToDictionary<TSource, TKey, TElement>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TElement> elementSelector, IEqualityComparer<TKey> comparer);
+        public static Dictionary<TKey, TSource> ToDictionary<TSource, TKey>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector);
+        public static Dictionary<TKey, TSource> ToDictionary<TSource, TKey>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector, IEqualityComparer<TKey> comparer);
+        public static List<TSource> ToList<TSource>(this IEnumerable<TSource> source);
+        public static ILookup<TKey, TElement> ToLookup<TSource, TKey, TElement>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TElement> elementSelector);
+        public static ILookup<TKey, TElement> ToLookup<TSource, TKey, TElement>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TElement> elementSelector, IEqualityComparer<TKey> comparer);
+        public static ILookup<TKey, TSource> ToLookup<TSource, TKey>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector);
+        public static ILookup<TKey, TSource> ToLookup<TSource, TKey>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector, IEqualityComparer<TKey> comparer);
+        public static IEnumerable<TSource> Union<TSource>(this IEnumerable<TSource> first, IEnumerable<TSource> second);
+        public static IEnumerable<TSource> Union<TSource>(this IEnumerable<TSource> first, IEnumerable<TSource> second, IEqualityComparer<TSource> comparer);
+        public static IEnumerable<TSource> Where<TSource>(this IEnumerable<TSource> source, Func<TSource, bool> predicate);
+        public static IEnumerable<TSource> Where<TSource>(this IEnumerable<TSource> source, Func<TSource, int, bool> predicate);
+        public static IEnumerable<TResult> Zip<TFirst, TSecond, TResult>(this IEnumerable<TFirst> first, IEnumerable<TSecond> second, Func<TFirst, TSecond, TResult> resultSelector);
+    }
+    public abstract class EnumerableExecutor {
+        protected EnumerableExecutor();
+    }
+    public class EnumerableExecutor<T> : EnumerableExecutor {
+        public EnumerableExecutor(Expression expression);
+    }
+    public abstract class EnumerableQuery {
+        protected EnumerableQuery();
+    }
+    public class EnumerableQuery<T> : EnumerableQuery, IEnumerable, IEnumerable<T>, IOrderedQueryable, IOrderedQueryable<T>, IQueryable, IQueryable<T>, IQueryProvider {
+        public EnumerableQuery(IEnumerable<T> enumerable);
+        public EnumerableQuery(Expression expression);
+        Type System.Linq.IQueryable.ElementType { get; }
+        Expression System.Linq.IQueryable.Expression { get; }
+        IQueryProvider System.Linq.IQueryable.Provider { get; }
+        IEnumerator<T> System.Collections.Generic.IEnumerable<T>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        IQueryable System.Linq.IQueryProvider.CreateQuery(Expression expression);
+        IQueryable<S> System.Linq.IQueryProvider.CreateQuery<S>(Expression expression);
+        object System.Linq.IQueryProvider.Execute(Expression expression);
+        S System.Linq.IQueryProvider.Execute<S>(Expression expression);
+        public override string ToString();
+    }
+    public interface IGrouping<out TKey, out TElement> : IEnumerable, IEnumerable<TElement> {
+        TKey Key { get; }
+    }
+    public interface ILookup<TKey, TElement> : IEnumerable, IEnumerable<IGrouping<TKey, TElement>> {
+        int Count { get; }
+        IEnumerable<TElement> this[TKey key] { get; }
+        bool Contains(TKey key);
+    }
+    public static class ImmutableArrayExtensions {
+        public static T Aggregate<T>(this ImmutableArray<T> immutableArray, Func<T, T, T> func);
+        public static TAccumulate Aggregate<TAccumulate, T>(this ImmutableArray<T> immutableArray, TAccumulate seed, Func<TAccumulate, T, TAccumulate> func);
+        public static TResult Aggregate<TAccumulate, TResult, T>(this ImmutableArray<T> immutableArray, TAccumulate seed, Func<TAccumulate, T, TAccumulate> func, Func<TAccumulate, TResult> resultSelector);
+        public static bool All<T>(this ImmutableArray<T> immutableArray, Func<T, bool> predicate);
+        public static bool Any<T>(this ImmutableArray<T>.Builder builder);
+        public static bool Any<T>(this ImmutableArray<T> immutableArray);
+        public static bool Any<T>(this ImmutableArray<T> immutableArray, Func<T, bool> predicate);
+        public static T ElementAt<T>(this ImmutableArray<T> immutableArray, int index);
+        public static T ElementAtOrDefault<T>(this ImmutableArray<T> immutableArray, int index);
+        public static T First<T>(this ImmutableArray<T>.Builder builder);
+        public static T First<T>(this ImmutableArray<T> immutableArray);
+        public static T First<T>(this ImmutableArray<T> immutableArray, Func<T, bool> predicate);
+        public static T FirstOrDefault<T>(this ImmutableArray<T>.Builder builder);
+        public static T FirstOrDefault<T>(this ImmutableArray<T> immutableArray);
+        public static T FirstOrDefault<T>(this ImmutableArray<T> immutableArray, Func<T, bool> predicate);
+        public static T Last<T>(this ImmutableArray<T>.Builder builder);
+        public static T Last<T>(this ImmutableArray<T> immutableArray);
+        public static T Last<T>(this ImmutableArray<T> immutableArray, Func<T, bool> predicate);
+        public static T LastOrDefault<T>(this ImmutableArray<T>.Builder builder);
+        public static T LastOrDefault<T>(this ImmutableArray<T> immutableArray);
+        public static T LastOrDefault<T>(this ImmutableArray<T> immutableArray, Func<T, bool> predicate);
+        public static IEnumerable<TResult> Select<T, TResult>(this ImmutableArray<T> immutableArray, Func<T, TResult> selector);
+        public static IEnumerable<TResult> SelectMany<TSource, TCollection, TResult>(this ImmutableArray<TSource> immutableArray, Func<TSource, IEnumerable<TCollection>> collectionSelector, Func<TSource, TCollection, TResult> resultSelector);
+        public static bool SequenceEqual<TDerived, TBase>(this ImmutableArray<TBase> immutableArray, IEnumerable<TDerived> items, IEqualityComparer<TBase> comparer=null) where TDerived : TBase;
+        public static bool SequenceEqual<TDerived, TBase>(this ImmutableArray<TBase> immutableArray, ImmutableArray<TDerived> items, IEqualityComparer<TBase> comparer=null) where TDerived : TBase;
+        public static bool SequenceEqual<TDerived, TBase>(this ImmutableArray<TBase> immutableArray, ImmutableArray<TDerived> items, Func<TBase, TBase, bool> predicate) where TDerived : TBase;
+        public static T Single<T>(this ImmutableArray<T> immutableArray);
+        public static T Single<T>(this ImmutableArray<T> immutableArray, Func<T, bool> predicate);
+        public static T SingleOrDefault<T>(this ImmutableArray<T> immutableArray);
+        public static T SingleOrDefault<T>(this ImmutableArray<T> immutableArray, Func<T, bool> predicate);
+        public static T[] ToArray<T>(this ImmutableArray<T> immutableArray);
+        public static Dictionary<TKey, T> ToDictionary<TKey, T>(this ImmutableArray<T> immutableArray, Func<T, TKey> keySelector);
+        public static Dictionary<TKey, T> ToDictionary<TKey, T>(this ImmutableArray<T> immutableArray, Func<T, TKey> keySelector, IEqualityComparer<TKey> comparer);
+        public static Dictionary<TKey, TElement> ToDictionary<TKey, TElement, T>(this ImmutableArray<T> immutableArray, Func<T, TKey> keySelector, Func<T, TElement> elementSelector);
+        public static Dictionary<TKey, TElement> ToDictionary<TKey, TElement, T>(this ImmutableArray<T> immutableArray, Func<T, TKey> keySelector, Func<T, TElement> elementSelector, IEqualityComparer<TKey> comparer);
+        public static IEnumerable<T> Where<T>(this ImmutableArray<T> immutableArray, Func<T, bool> predicate);
+    }
+    public interface IOrderedEnumerable<TElement> : IEnumerable, IEnumerable<TElement> {
+        IOrderedEnumerable<TElement> CreateOrderedEnumerable<TKey>(Func<TElement, TKey> keySelector, IComparer<TKey> comparer, bool descending);
+    }
+    public interface IOrderedQueryable : IEnumerable, IQueryable
+    public interface IOrderedQueryable<out T> : IEnumerable, IEnumerable<T>, IOrderedQueryable, IQueryable, IQueryable<T>
+    public interface IQueryable : IEnumerable {
+        Type ElementType { get; }
+        Expression Expression { get; }
+        IQueryProvider Provider { get; }
+    }
+    public interface IQueryable<out T> : IEnumerable, IEnumerable<T>, IQueryable
+    public interface IQueryProvider {
+        IQueryable CreateQuery(Expression expression);
+        IQueryable<TElement> CreateQuery<TElement>(Expression expression);
+        object Execute(Expression expression);
+        TResult Execute<TResult>(Expression expression);
+    }
+    public class Lookup<TKey, TElement> : IEnumerable, IEnumerable<IGrouping<TKey, TElement>>, ILookup<TKey, TElement> {
+        public int Count { get; }
+        public IEnumerable<TElement> this[TKey key] { get; }
+        public IEnumerable<TResult> ApplyResultSelector<TResult>(Func<TKey, IEnumerable<TElement>, TResult> resultSelector);
+        public bool Contains(TKey key);
+        public IEnumerator<IGrouping<TKey, TElement>> GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+    }
+    public class OrderedParallelQuery<TSource> : ParallelQuery<TSource> {
+        public override IEnumerator<TSource> GetEnumerator();
+    }
+    public static class ParallelEnumerable {
+        public static TResult Aggregate<TSource, TAccumulate, TResult>(this ParallelQuery<TSource> source, Func<TAccumulate> seedFactory, Func<TAccumulate, TSource, TAccumulate> updateAccumulatorFunc, Func<TAccumulate, TAccumulate, TAccumulate> combineAccumulatorsFunc, Func<TAccumulate, TResult> resultSelector);
+        public static TResult Aggregate<TSource, TAccumulate, TResult>(this ParallelQuery<TSource> source, TAccumulate seed, Func<TAccumulate, TSource, TAccumulate> updateAccumulatorFunc, Func<TAccumulate, TAccumulate, TAccumulate> combineAccumulatorsFunc, Func<TAccumulate, TResult> resultSelector);
+        public static TResult Aggregate<TSource, TAccumulate, TResult>(this ParallelQuery<TSource> source, TAccumulate seed, Func<TAccumulate, TSource, TAccumulate> func, Func<TAccumulate, TResult> resultSelector);
+        public static TAccumulate Aggregate<TSource, TAccumulate>(this ParallelQuery<TSource> source, TAccumulate seed, Func<TAccumulate, TSource, TAccumulate> func);
+        public static TSource Aggregate<TSource>(this ParallelQuery<TSource> source, Func<TSource, TSource, TSource> func);
+        public static bool All<TSource>(this ParallelQuery<TSource> source, Func<TSource, bool> predicate);
+        public static bool Any<TSource>(this ParallelQuery<TSource> source);
+        public static bool Any<TSource>(this ParallelQuery<TSource> source, Func<TSource, bool> predicate);
+        public static IEnumerable<TSource> AsEnumerable<TSource>(this ParallelQuery<TSource> source);
+        public static ParallelQuery AsOrdered(this ParallelQuery source);
+        public static ParallelQuery<TSource> AsOrdered<TSource>(this ParallelQuery<TSource> source);
+        public static ParallelQuery AsParallel(this IEnumerable source);
+        public static ParallelQuery<TSource> AsParallel<TSource>(this Partitioner<TSource> source);
+        public static ParallelQuery<TSource> AsParallel<TSource>(this IEnumerable<TSource> source);
+        public static IEnumerable<TSource> AsSequential<TSource>(this ParallelQuery<TSource> source);
+        public static ParallelQuery<TSource> AsUnordered<TSource>(this ParallelQuery<TSource> source);
+        public static Decimal Average(this ParallelQuery<Decimal> source);
+        public static double Average(this ParallelQuery<double> source);
+        public static double Average(this ParallelQuery<int> source);
+        public static double Average(this ParallelQuery<long> source);
+        public static Nullable<Decimal> Average(this ParallelQuery<Nullable<Decimal>> source);
+        public static Nullable<double> Average(this ParallelQuery<Nullable<double>> source);
+        public static Nullable<double> Average(this ParallelQuery<Nullable<int>> source);
+        public static Nullable<double> Average(this ParallelQuery<Nullable<long>> source);
+        public static Nullable<float> Average(this ParallelQuery<Nullable<float>> source);
+        public static float Average(this ParallelQuery<float> source);
+        public static Decimal Average<TSource>(this ParallelQuery<TSource> source, Func<TSource, Decimal> selector);
+        public static double Average<TSource>(this ParallelQuery<TSource> source, Func<TSource, double> selector);
+        public static double Average<TSource>(this ParallelQuery<TSource> source, Func<TSource, int> selector);
+        public static double Average<TSource>(this ParallelQuery<TSource> source, Func<TSource, long> selector);
+        public static Nullable<Decimal> Average<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<Decimal>> selector);
+        public static Nullable<double> Average<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<double>> selector);
+        public static Nullable<double> Average<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<int>> selector);
+        public static Nullable<double> Average<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<long>> selector);
+        public static Nullable<float> Average<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<float>> selector);
+        public static float Average<TSource>(this ParallelQuery<TSource> source, Func<TSource, float> selector);
+        public static ParallelQuery<TResult> Cast<TResult>(this ParallelQuery source);
+        public static ParallelQuery<TSource> Concat<TSource>(this ParallelQuery<TSource> first, IEnumerable<TSource> second);
+        public static ParallelQuery<TSource> Concat<TSource>(this ParallelQuery<TSource> first, ParallelQuery<TSource> second);
+        public static bool Contains<TSource>(this ParallelQuery<TSource> source, TSource value);
+        public static bool Contains<TSource>(this ParallelQuery<TSource> source, TSource value, IEqualityComparer<TSource> comparer);
+        public static int Count<TSource>(this ParallelQuery<TSource> source);
+        public static int Count<TSource>(this ParallelQuery<TSource> source, Func<TSource, bool> predicate);
+        public static ParallelQuery<TSource> DefaultIfEmpty<TSource>(this ParallelQuery<TSource> source);
+        public static ParallelQuery<TSource> DefaultIfEmpty<TSource>(this ParallelQuery<TSource> source, TSource defaultValue);
+        public static ParallelQuery<TSource> Distinct<TSource>(this ParallelQuery<TSource> source);
+        public static ParallelQuery<TSource> Distinct<TSource>(this ParallelQuery<TSource> source, IEqualityComparer<TSource> comparer);
+        public static TSource ElementAt<TSource>(this ParallelQuery<TSource> source, int index);
+        public static TSource ElementAtOrDefault<TSource>(this ParallelQuery<TSource> source, int index);
+        public static ParallelQuery<TResult> Empty<TResult>();
+        public static ParallelQuery<TSource> Except<TSource>(this ParallelQuery<TSource> first, IEnumerable<TSource> second);
+        public static ParallelQuery<TSource> Except<TSource>(this ParallelQuery<TSource> first, IEnumerable<TSource> second, IEqualityComparer<TSource> comparer);
+        public static ParallelQuery<TSource> Except<TSource>(this ParallelQuery<TSource> first, ParallelQuery<TSource> second);
+        public static ParallelQuery<TSource> Except<TSource>(this ParallelQuery<TSource> first, ParallelQuery<TSource> second, IEqualityComparer<TSource> comparer);
+        public static TSource First<TSource>(this ParallelQuery<TSource> source);
+        public static TSource First<TSource>(this ParallelQuery<TSource> source, Func<TSource, bool> predicate);
+        public static TSource FirstOrDefault<TSource>(this ParallelQuery<TSource> source);
+        public static TSource FirstOrDefault<TSource>(this ParallelQuery<TSource> source, Func<TSource, bool> predicate);
+        public static void ForAll<TSource>(this ParallelQuery<TSource> source, Action<TSource> action);
+        public static ParallelQuery<TResult> GroupBy<TSource, TKey, TElement, TResult>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TElement> elementSelector, Func<TKey, IEnumerable<TElement>, TResult> resultSelector);
+        public static ParallelQuery<TResult> GroupBy<TSource, TKey, TElement, TResult>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TElement> elementSelector, Func<TKey, IEnumerable<TElement>, TResult> resultSelector, IEqualityComparer<TKey> comparer);
+        public static ParallelQuery<IGrouping<TKey, TElement>> GroupBy<TSource, TKey, TElement>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TElement> elementSelector);
+        public static ParallelQuery<IGrouping<TKey, TElement>> GroupBy<TSource, TKey, TElement>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TElement> elementSelector, IEqualityComparer<TKey> comparer);
+        public static ParallelQuery<TResult> GroupBy<TSource, TKey, TResult>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector, Func<TKey, IEnumerable<TSource>, TResult> resultSelector);
+        public static ParallelQuery<TResult> GroupBy<TSource, TKey, TResult>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector, Func<TKey, IEnumerable<TSource>, TResult> resultSelector, IEqualityComparer<TKey> comparer);
+        public static ParallelQuery<IGrouping<TKey, TSource>> GroupBy<TSource, TKey>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector);
+        public static ParallelQuery<IGrouping<TKey, TSource>> GroupBy<TSource, TKey>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector, IEqualityComparer<TKey> comparer);
+        public static ParallelQuery<TResult> GroupJoin<TOuter, TInner, TKey, TResult>(this ParallelQuery<TOuter> outer, IEnumerable<TInner> inner, Func<TOuter, TKey> outerKeySelector, Func<TInner, TKey> innerKeySelector, Func<TOuter, IEnumerable<TInner>, TResult> resultSelector);
+        public static ParallelQuery<TResult> GroupJoin<TOuter, TInner, TKey, TResult>(this ParallelQuery<TOuter> outer, IEnumerable<TInner> inner, Func<TOuter, TKey> outerKeySelector, Func<TInner, TKey> innerKeySelector, Func<TOuter, IEnumerable<TInner>, TResult> resultSelector, IEqualityComparer<TKey> comparer);
+        public static ParallelQuery<TResult> GroupJoin<TOuter, TInner, TKey, TResult>(this ParallelQuery<TOuter> outer, ParallelQuery<TInner> inner, Func<TOuter, TKey> outerKeySelector, Func<TInner, TKey> innerKeySelector, Func<TOuter, IEnumerable<TInner>, TResult> resultSelector);
+        public static ParallelQuery<TResult> GroupJoin<TOuter, TInner, TKey, TResult>(this ParallelQuery<TOuter> outer, ParallelQuery<TInner> inner, Func<TOuter, TKey> outerKeySelector, Func<TInner, TKey> innerKeySelector, Func<TOuter, IEnumerable<TInner>, TResult> resultSelector, IEqualityComparer<TKey> comparer);
+        public static ParallelQuery<TSource> Intersect<TSource>(this ParallelQuery<TSource> first, IEnumerable<TSource> second);
+        public static ParallelQuery<TSource> Intersect<TSource>(this ParallelQuery<TSource> first, IEnumerable<TSource> second, IEqualityComparer<TSource> comparer);
+        public static ParallelQuery<TSource> Intersect<TSource>(this ParallelQuery<TSource> first, ParallelQuery<TSource> second);
+        public static ParallelQuery<TSource> Intersect<TSource>(this ParallelQuery<TSource> first, ParallelQuery<TSource> second, IEqualityComparer<TSource> comparer);
+        public static ParallelQuery<TResult> Join<TOuter, TInner, TKey, TResult>(this ParallelQuery<TOuter> outer, IEnumerable<TInner> inner, Func<TOuter, TKey> outerKeySelector, Func<TInner, TKey> innerKeySelector, Func<TOuter, TInner, TResult> resultSelector);
+        public static ParallelQuery<TResult> Join<TOuter, TInner, TKey, TResult>(this ParallelQuery<TOuter> outer, IEnumerable<TInner> inner, Func<TOuter, TKey> outerKeySelector, Func<TInner, TKey> innerKeySelector, Func<TOuter, TInner, TResult> resultSelector, IEqualityComparer<TKey> comparer);
+        public static ParallelQuery<TResult> Join<TOuter, TInner, TKey, TResult>(this ParallelQuery<TOuter> outer, ParallelQuery<TInner> inner, Func<TOuter, TKey> outerKeySelector, Func<TInner, TKey> innerKeySelector, Func<TOuter, TInner, TResult> resultSelector);
+        public static ParallelQuery<TResult> Join<TOuter, TInner, TKey, TResult>(this ParallelQuery<TOuter> outer, ParallelQuery<TInner> inner, Func<TOuter, TKey> outerKeySelector, Func<TInner, TKey> innerKeySelector, Func<TOuter, TInner, TResult> resultSelector, IEqualityComparer<TKey> comparer);
+        public static TSource Last<TSource>(this ParallelQuery<TSource> source);
+        public static TSource Last<TSource>(this ParallelQuery<TSource> source, Func<TSource, bool> predicate);
+        public static TSource LastOrDefault<TSource>(this ParallelQuery<TSource> source);
+        public static TSource LastOrDefault<TSource>(this ParallelQuery<TSource> source, Func<TSource, bool> predicate);
+        public static long LongCount<TSource>(this ParallelQuery<TSource> source);
+        public static long LongCount<TSource>(this ParallelQuery<TSource> source, Func<TSource, bool> predicate);
+        public static Decimal Max(this ParallelQuery<Decimal> source);
+        public static double Max(this ParallelQuery<double> source);
+        public static int Max(this ParallelQuery<int> source);
+        public static long Max(this ParallelQuery<long> source);
+        public static Nullable<Decimal> Max(this ParallelQuery<Nullable<Decimal>> source);
+        public static Nullable<double> Max(this ParallelQuery<Nullable<double>> source);
+        public static Nullable<int> Max(this ParallelQuery<Nullable<int>> source);
+        public static Nullable<long> Max(this ParallelQuery<Nullable<long>> source);
+        public static Nullable<float> Max(this ParallelQuery<Nullable<float>> source);
+        public static float Max(this ParallelQuery<float> source);
+        public static TResult Max<TSource, TResult>(this ParallelQuery<TSource> source, Func<TSource, TResult> selector);
+        public static TSource Max<TSource>(this ParallelQuery<TSource> source);
+        public static Decimal Max<TSource>(this ParallelQuery<TSource> source, Func<TSource, Decimal> selector);
+        public static double Max<TSource>(this ParallelQuery<TSource> source, Func<TSource, double> selector);
+        public static int Max<TSource>(this ParallelQuery<TSource> source, Func<TSource, int> selector);
+        public static long Max<TSource>(this ParallelQuery<TSource> source, Func<TSource, long> selector);
+        public static Nullable<Decimal> Max<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<Decimal>> selector);
+        public static Nullable<double> Max<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<double>> selector);
+        public static Nullable<int> Max<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<int>> selector);
+        public static Nullable<long> Max<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<long>> selector);
+        public static Nullable<float> Max<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<float>> selector);
+        public static float Max<TSource>(this ParallelQuery<TSource> source, Func<TSource, float> selector);
+        public static Decimal Min(this ParallelQuery<Decimal> source);
+        public static double Min(this ParallelQuery<double> source);
+        public static int Min(this ParallelQuery<int> source);
+        public static long Min(this ParallelQuery<long> source);
+        public static Nullable<Decimal> Min(this ParallelQuery<Nullable<Decimal>> source);
+        public static Nullable<double> Min(this ParallelQuery<Nullable<double>> source);
+        public static Nullable<int> Min(this ParallelQuery<Nullable<int>> source);
+        public static Nullable<long> Min(this ParallelQuery<Nullable<long>> source);
+        public static Nullable<float> Min(this ParallelQuery<Nullable<float>> source);
+        public static float Min(this ParallelQuery<float> source);
+        public static TResult Min<TSource, TResult>(this ParallelQuery<TSource> source, Func<TSource, TResult> selector);
+        public static TSource Min<TSource>(this ParallelQuery<TSource> source);
+        public static Decimal Min<TSource>(this ParallelQuery<TSource> source, Func<TSource, Decimal> selector);
+        public static double Min<TSource>(this ParallelQuery<TSource> source, Func<TSource, double> selector);
+        public static int Min<TSource>(this ParallelQuery<TSource> source, Func<TSource, int> selector);
+        public static long Min<TSource>(this ParallelQuery<TSource> source, Func<TSource, long> selector);
+        public static Nullable<Decimal> Min<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<Decimal>> selector);
+        public static Nullable<double> Min<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<double>> selector);
+        public static Nullable<int> Min<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<int>> selector);
+        public static Nullable<long> Min<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<long>> selector);
+        public static Nullable<float> Min<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<float>> selector);
+        public static float Min<TSource>(this ParallelQuery<TSource> source, Func<TSource, float> selector);
+        public static ParallelQuery<TResult> OfType<TResult>(this ParallelQuery source);
+        public static OrderedParallelQuery<TSource> OrderBy<TSource, TKey>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector);
+        public static OrderedParallelQuery<TSource> OrderBy<TSource, TKey>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector, IComparer<TKey> comparer);
+        public static OrderedParallelQuery<TSource> OrderByDescending<TSource, TKey>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector);
+        public static OrderedParallelQuery<TSource> OrderByDescending<TSource, TKey>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector, IComparer<TKey> comparer);
+        public static ParallelQuery<int> Range(int start, int count);
+        public static ParallelQuery<TResult> Repeat<TResult>(TResult element, int count);
+        public static ParallelQuery<TSource> Reverse<TSource>(this ParallelQuery<TSource> source);
+        public static ParallelQuery<TResult> Select<TSource, TResult>(this ParallelQuery<TSource> source, Func<TSource, int, TResult> selector);
+        public static ParallelQuery<TResult> Select<TSource, TResult>(this ParallelQuery<TSource> source, Func<TSource, TResult> selector);
+        public static ParallelQuery<TResult> SelectMany<TSource, TCollection, TResult>(this ParallelQuery<TSource> source, Func<TSource, IEnumerable<TCollection>> collectionSelector, Func<TSource, TCollection, TResult> resultSelector);
+        public static ParallelQuery<TResult> SelectMany<TSource, TCollection, TResult>(this ParallelQuery<TSource> source, Func<TSource, int, IEnumerable<TCollection>> collectionSelector, Func<TSource, TCollection, TResult> resultSelector);
+        public static ParallelQuery<TResult> SelectMany<TSource, TResult>(this ParallelQuery<TSource> source, Func<TSource, IEnumerable<TResult>> selector);
+        public static ParallelQuery<TResult> SelectMany<TSource, TResult>(this ParallelQuery<TSource> source, Func<TSource, int, IEnumerable<TResult>> selector);
+        public static bool SequenceEqual<TSource>(this ParallelQuery<TSource> first, IEnumerable<TSource> second);
+        public static bool SequenceEqual<TSource>(this ParallelQuery<TSource> first, IEnumerable<TSource> second, IEqualityComparer<TSource> comparer);
+        public static bool SequenceEqual<TSource>(this ParallelQuery<TSource> first, ParallelQuery<TSource> second);
+        public static bool SequenceEqual<TSource>(this ParallelQuery<TSource> first, ParallelQuery<TSource> second, IEqualityComparer<TSource> comparer);
+        public static TSource Single<TSource>(this ParallelQuery<TSource> source);
+        public static TSource Single<TSource>(this ParallelQuery<TSource> source, Func<TSource, bool> predicate);
+        public static TSource SingleOrDefault<TSource>(this ParallelQuery<TSource> source);
+        public static TSource SingleOrDefault<TSource>(this ParallelQuery<TSource> source, Func<TSource, bool> predicate);
+        public static ParallelQuery<TSource> Skip<TSource>(this ParallelQuery<TSource> source, int count);
+        public static ParallelQuery<TSource> SkipWhile<TSource>(this ParallelQuery<TSource> source, Func<TSource, bool> predicate);
+        public static ParallelQuery<TSource> SkipWhile<TSource>(this ParallelQuery<TSource> source, Func<TSource, int, bool> predicate);
+        public static Decimal Sum(this ParallelQuery<Decimal> source);
+        public static double Sum(this ParallelQuery<double> source);
+        public static int Sum(this ParallelQuery<int> source);
+        public static long Sum(this ParallelQuery<long> source);
+        public static Nullable<Decimal> Sum(this ParallelQuery<Nullable<Decimal>> source);
+        public static Nullable<double> Sum(this ParallelQuery<Nullable<double>> source);
+        public static Nullable<int> Sum(this ParallelQuery<Nullable<int>> source);
+        public static Nullable<long> Sum(this ParallelQuery<Nullable<long>> source);
+        public static Nullable<float> Sum(this ParallelQuery<Nullable<float>> source);
+        public static float Sum(this ParallelQuery<float> source);
+        public static Decimal Sum<TSource>(this ParallelQuery<TSource> source, Func<TSource, Decimal> selector);
+        public static double Sum<TSource>(this ParallelQuery<TSource> source, Func<TSource, double> selector);
+        public static int Sum<TSource>(this ParallelQuery<TSource> source, Func<TSource, int> selector);
+        public static long Sum<TSource>(this ParallelQuery<TSource> source, Func<TSource, long> selector);
+        public static Nullable<Decimal> Sum<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<Decimal>> selector);
+        public static Nullable<double> Sum<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<double>> selector);
+        public static Nullable<int> Sum<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<int>> selector);
+        public static Nullable<long> Sum<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<long>> selector);
+        public static Nullable<float> Sum<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<float>> selector);
+        public static float Sum<TSource>(this ParallelQuery<TSource> source, Func<TSource, float> selector);
+        public static ParallelQuery<TSource> Take<TSource>(this ParallelQuery<TSource> source, int count);
+        public static ParallelQuery<TSource> TakeWhile<TSource>(this ParallelQuery<TSource> source, Func<TSource, bool> predicate);
+        public static ParallelQuery<TSource> TakeWhile<TSource>(this ParallelQuery<TSource> source, Func<TSource, int, bool> predicate);
+        public static OrderedParallelQuery<TSource> ThenBy<TSource, TKey>(this OrderedParallelQuery<TSource> source, Func<TSource, TKey> keySelector);
+        public static OrderedParallelQuery<TSource> ThenBy<TSource, TKey>(this OrderedParallelQuery<TSource> source, Func<TSource, TKey> keySelector, IComparer<TKey> comparer);
+        public static OrderedParallelQuery<TSource> ThenByDescending<TSource, TKey>(this OrderedParallelQuery<TSource> source, Func<TSource, TKey> keySelector);
+        public static OrderedParallelQuery<TSource> ThenByDescending<TSource, TKey>(this OrderedParallelQuery<TSource> source, Func<TSource, TKey> keySelector, IComparer<TKey> comparer);
+        public static TSource[] ToArray<TSource>(this ParallelQuery<TSource> source);
+        public static Dictionary<TKey, TElement> ToDictionary<TSource, TKey, TElement>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TElement> elementSelector);
+        public static Dictionary<TKey, TElement> ToDictionary<TSource, TKey, TElement>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TElement> elementSelector, IEqualityComparer<TKey> comparer);
+        public static Dictionary<TKey, TSource> ToDictionary<TSource, TKey>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector);
+        public static Dictionary<TKey, TSource> ToDictionary<TSource, TKey>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector, IEqualityComparer<TKey> comparer);
+        public static List<TSource> ToList<TSource>(this ParallelQuery<TSource> source);
+        public static ILookup<TKey, TElement> ToLookup<TSource, TKey, TElement>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TElement> elementSelector);
+        public static ILookup<TKey, TElement> ToLookup<TSource, TKey, TElement>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TElement> elementSelector, IEqualityComparer<TKey> comparer);
+        public static ILookup<TKey, TSource> ToLookup<TSource, TKey>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector);
+        public static ILookup<TKey, TSource> ToLookup<TSource, TKey>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector, IEqualityComparer<TKey> comparer);
+        public static ParallelQuery<TSource> Union<TSource>(this ParallelQuery<TSource> first, IEnumerable<TSource> second);
+        public static ParallelQuery<TSource> Union<TSource>(this ParallelQuery<TSource> first, IEnumerable<TSource> second, IEqualityComparer<TSource> comparer);
+        public static ParallelQuery<TSource> Union<TSource>(this ParallelQuery<TSource> first, ParallelQuery<TSource> second);
+        public static ParallelQuery<TSource> Union<TSource>(this ParallelQuery<TSource> first, ParallelQuery<TSource> second, IEqualityComparer<TSource> comparer);
+        public static ParallelQuery<TSource> Where<TSource>(this ParallelQuery<TSource> source, Func<TSource, bool> predicate);
+        public static ParallelQuery<TSource> Where<TSource>(this ParallelQuery<TSource> source, Func<TSource, int, bool> predicate);
+        public static ParallelQuery<TSource> WithCancellation<TSource>(this ParallelQuery<TSource> source, CancellationToken cancellationToken);
+        public static ParallelQuery<TSource> WithDegreeOfParallelism<TSource>(this ParallelQuery<TSource> source, int degreeOfParallelism);
+        public static ParallelQuery<TSource> WithExecutionMode<TSource>(this ParallelQuery<TSource> source, ParallelExecutionMode executionMode);
+        public static ParallelQuery<TSource> WithMergeOptions<TSource>(this ParallelQuery<TSource> source, ParallelMergeOptions mergeOptions);
+        public static ParallelQuery<TResult> Zip<TFirst, TSecond, TResult>(this ParallelQuery<TFirst> first, IEnumerable<TSecond> second, Func<TFirst, TSecond, TResult> resultSelector);
+        public static ParallelQuery<TResult> Zip<TFirst, TSecond, TResult>(this ParallelQuery<TFirst> first, ParallelQuery<TSecond> second, Func<TFirst, TSecond, TResult> resultSelector);
+    }
+    public enum ParallelExecutionMode {
+        Default = 0,
+        ForceParallelism = 1,
+    }
+    public enum ParallelMergeOptions {
+        AutoBuffered = 2,
+        Default = 0,
+        FullyBuffered = 3,
+        NotBuffered = 1,
+    }
+    public class ParallelQuery : IEnumerable {
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+    }
+    public class ParallelQuery<TSource> : ParallelQuery, IEnumerable, IEnumerable<TSource> {
+        public virtual IEnumerator<TSource> GetEnumerator();
+    }
+    public static class Queryable {
+        public static TResult Aggregate<TSource, TAccumulate, TResult>(this IQueryable<TSource> source, TAccumulate seed, Expression<Func<TAccumulate, TSource, TAccumulate>> func, Expression<Func<TAccumulate, TResult>> selector);
+        public static TAccumulate Aggregate<TSource, TAccumulate>(this IQueryable<TSource> source, TAccumulate seed, Expression<Func<TAccumulate, TSource, TAccumulate>> func);
+        public static TSource Aggregate<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, TSource, TSource>> func);
+        public static bool All<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, bool>> predicate);
+        public static bool Any<TSource>(this IQueryable<TSource> source);
+        public static bool Any<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, bool>> predicate);
+        public static IQueryable AsQueryable(this IEnumerable source);
+        public static IQueryable<TElement> AsQueryable<TElement>(this IEnumerable<TElement> source);
+        public static Decimal Average(this IQueryable<Decimal> source);
+        public static double Average(this IQueryable<double> source);
+        public static double Average(this IQueryable<int> source);
+        public static double Average(this IQueryable<long> source);
+        public static Nullable<Decimal> Average(this IQueryable<Nullable<Decimal>> source);
+        public static Nullable<double> Average(this IQueryable<Nullable<double>> source);
+        public static Nullable<double> Average(this IQueryable<Nullable<int>> source);
+        public static Nullable<double> Average(this IQueryable<Nullable<long>> source);
+        public static Nullable<float> Average(this IQueryable<Nullable<float>> source);
+        public static float Average(this IQueryable<float> source);
+        public static Decimal Average<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, Decimal>> selector);
+        public static double Average<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, double>> selector);
+        public static double Average<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, int>> selector);
+        public static double Average<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, long>> selector);
+        public static Nullable<Decimal> Average<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, Nullable<Decimal>>> selector);
+        public static Nullable<double> Average<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, Nullable<double>>> selector);
+        public static Nullable<double> Average<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, Nullable<int>>> selector);
+        public static Nullable<double> Average<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, Nullable<long>>> selector);
+        public static Nullable<float> Average<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, Nullable<float>>> selector);
+        public static float Average<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, float>> selector);
+        public static IQueryable<TResult> Cast<TResult>(this IQueryable source);
+        public static IQueryable<TSource> Concat<TSource>(this IQueryable<TSource> source1, IEnumerable<TSource> source2);
+        public static bool Contains<TSource>(this IQueryable<TSource> source, TSource item);
+        public static bool Contains<TSource>(this IQueryable<TSource> source, TSource item, IEqualityComparer<TSource> comparer);
+        public static int Count<TSource>(this IQueryable<TSource> source);
+        public static int Count<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, bool>> predicate);
+        public static IQueryable<TSource> DefaultIfEmpty<TSource>(this IQueryable<TSource> source);
+        public static IQueryable<TSource> DefaultIfEmpty<TSource>(this IQueryable<TSource> source, TSource defaultValue);
+        public static IQueryable<TSource> Distinct<TSource>(this IQueryable<TSource> source);
+        public static IQueryable<TSource> Distinct<TSource>(this IQueryable<TSource> source, IEqualityComparer<TSource> comparer);
+        public static TSource ElementAt<TSource>(this IQueryable<TSource> source, int index);
+        public static TSource ElementAtOrDefault<TSource>(this IQueryable<TSource> source, int index);
+        public static IQueryable<TSource> Except<TSource>(this IQueryable<TSource> source1, IEnumerable<TSource> source2);
+        public static IQueryable<TSource> Except<TSource>(this IQueryable<TSource> source1, IEnumerable<TSource> source2, IEqualityComparer<TSource> comparer);
+        public static TSource First<TSource>(this IQueryable<TSource> source);
+        public static TSource First<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, bool>> predicate);
+        public static TSource FirstOrDefault<TSource>(this IQueryable<TSource> source);
+        public static TSource FirstOrDefault<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, bool>> predicate);
+        public static IQueryable<TResult> GroupBy<TSource, TKey, TElement, TResult>(this IQueryable<TSource> source, Expression<Func<TSource, TKey>> keySelector, Expression<Func<TSource, TElement>> elementSelector, Expression<Func<TKey, IEnumerable<TElement>, TResult>> resultSelector);
+        public static IQueryable<TResult> GroupBy<TSource, TKey, TElement, TResult>(this IQueryable<TSource> source, Expression<Func<TSource, TKey>> keySelector, Expression<Func<TSource, TElement>> elementSelector, Expression<Func<TKey, IEnumerable<TElement>, TResult>> resultSelector, IEqualityComparer<TKey> comparer);
+        public static IQueryable<IGrouping<TKey, TElement>> GroupBy<TSource, TKey, TElement>(this IQueryable<TSource> source, Expression<Func<TSource, TKey>> keySelector, Expression<Func<TSource, TElement>> elementSelector);
+        public static IQueryable<IGrouping<TKey, TElement>> GroupBy<TSource, TKey, TElement>(this IQueryable<TSource> source, Expression<Func<TSource, TKey>> keySelector, Expression<Func<TSource, TElement>> elementSelector, IEqualityComparer<TKey> comparer);
+        public static IQueryable<TResult> GroupBy<TSource, TKey, TResult>(this IQueryable<TSource> source, Expression<Func<TSource, TKey>> keySelector, Expression<Func<TKey, IEnumerable<TSource>, TResult>> resultSelector);
+        public static IQueryable<TResult> GroupBy<TSource, TKey, TResult>(this IQueryable<TSource> source, Expression<Func<TSource, TKey>> keySelector, Expression<Func<TKey, IEnumerable<TSource>, TResult>> resultSelector, IEqualityComparer<TKey> comparer);
+        public static IQueryable<IGrouping<TKey, TSource>> GroupBy<TSource, TKey>(this IQueryable<TSource> source, Expression<Func<TSource, TKey>> keySelector);
+        public static IQueryable<IGrouping<TKey, TSource>> GroupBy<TSource, TKey>(this IQueryable<TSource> source, Expression<Func<TSource, TKey>> keySelector, IEqualityComparer<TKey> comparer);
+        public static IQueryable<TResult> GroupJoin<TOuter, TInner, TKey, TResult>(this IQueryable<TOuter> outer, IEnumerable<TInner> inner, Expression<Func<TOuter, TKey>> outerKeySelector, Expression<Func<TInner, TKey>> innerKeySelector, Expression<Func<TOuter, IEnumerable<TInner>, TResult>> resultSelector);
+        public static IQueryable<TResult> GroupJoin<TOuter, TInner, TKey, TResult>(this IQueryable<TOuter> outer, IEnumerable<TInner> inner, Expression<Func<TOuter, TKey>> outerKeySelector, Expression<Func<TInner, TKey>> innerKeySelector, Expression<Func<TOuter, IEnumerable<TInner>, TResult>> resultSelector, IEqualityComparer<TKey> comparer);
+        public static IQueryable<TSource> Intersect<TSource>(this IQueryable<TSource> source1, IEnumerable<TSource> source2);
+        public static IQueryable<TSource> Intersect<TSource>(this IQueryable<TSource> source1, IEnumerable<TSource> source2, IEqualityComparer<TSource> comparer);
+        public static IQueryable<TResult> Join<TOuter, TInner, TKey, TResult>(this IQueryable<TOuter> outer, IEnumerable<TInner> inner, Expression<Func<TOuter, TKey>> outerKeySelector, Expression<Func<TInner, TKey>> innerKeySelector, Expression<Func<TOuter, TInner, TResult>> resultSelector);
+        public static IQueryable<TResult> Join<TOuter, TInner, TKey, TResult>(this IQueryable<TOuter> outer, IEnumerable<TInner> inner, Expression<Func<TOuter, TKey>> outerKeySelector, Expression<Func<TInner, TKey>> innerKeySelector, Expression<Func<TOuter, TInner, TResult>> resultSelector, IEqualityComparer<TKey> comparer);
+        public static TSource Last<TSource>(this IQueryable<TSource> source);
+        public static TSource Last<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, bool>> predicate);
+        public static TSource LastOrDefault<TSource>(this IQueryable<TSource> source);
+        public static TSource LastOrDefault<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, bool>> predicate);
+        public static long LongCount<TSource>(this IQueryable<TSource> source);
+        public static long LongCount<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, bool>> predicate);
+        public static TResult Max<TSource, TResult>(this IQueryable<TSource> source, Expression<Func<TSource, TResult>> selector);
+        public static TSource Max<TSource>(this IQueryable<TSource> source);
+        public static TResult Min<TSource, TResult>(this IQueryable<TSource> source, Expression<Func<TSource, TResult>> selector);
+        public static TSource Min<TSource>(this IQueryable<TSource> source);
+        public static IQueryable<TResult> OfType<TResult>(this IQueryable source);
+        public static IOrderedQueryable<TSource> OrderBy<TSource, TKey>(this IQueryable<TSource> source, Expression<Func<TSource, TKey>> keySelector);
+        public static IOrderedQueryable<TSource> OrderBy<TSource, TKey>(this IQueryable<TSource> source, Expression<Func<TSource, TKey>> keySelector, IComparer<TKey> comparer);
+        public static IOrderedQueryable<TSource> OrderByDescending<TSource, TKey>(this IQueryable<TSource> source, Expression<Func<TSource, TKey>> keySelector);
+        public static IOrderedQueryable<TSource> OrderByDescending<TSource, TKey>(this IQueryable<TSource> source, Expression<Func<TSource, TKey>> keySelector, IComparer<TKey> comparer);
+        public static IQueryable<TSource> Reverse<TSource>(this IQueryable<TSource> source);
+        public static IQueryable<TResult> Select<TSource, TResult>(this IQueryable<TSource> source, Expression<Func<TSource, int, TResult>> selector);
+        public static IQueryable<TResult> Select<TSource, TResult>(this IQueryable<TSource> source, Expression<Func<TSource, TResult>> selector);
+        public static IQueryable<TResult> SelectMany<TSource, TCollection, TResult>(this IQueryable<TSource> source, Expression<Func<TSource, IEnumerable<TCollection>>> collectionSelector, Expression<Func<TSource, TCollection, TResult>> resultSelector);
+        public static IQueryable<TResult> SelectMany<TSource, TCollection, TResult>(this IQueryable<TSource> source, Expression<Func<TSource, int, IEnumerable<TCollection>>> collectionSelector, Expression<Func<TSource, TCollection, TResult>> resultSelector);
+        public static IQueryable<TResult> SelectMany<TSource, TResult>(this IQueryable<TSource> source, Expression<Func<TSource, IEnumerable<TResult>>> selector);
+        public static IQueryable<TResult> SelectMany<TSource, TResult>(this IQueryable<TSource> source, Expression<Func<TSource, int, IEnumerable<TResult>>> selector);
+        public static bool SequenceEqual<TSource>(this IQueryable<TSource> source1, IEnumerable<TSource> source2);
+        public static bool SequenceEqual<TSource>(this IQueryable<TSource> source1, IEnumerable<TSource> source2, IEqualityComparer<TSource> comparer);
+        public static TSource Single<TSource>(this IQueryable<TSource> source);
+        public static TSource Single<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, bool>> predicate);
+        public static TSource SingleOrDefault<TSource>(this IQueryable<TSource> source);
+        public static TSource SingleOrDefault<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, bool>> predicate);
+        public static IQueryable<TSource> Skip<TSource>(this IQueryable<TSource> source, int count);
+        public static IQueryable<TSource> SkipWhile<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, bool>> predicate);
+        public static IQueryable<TSource> SkipWhile<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, int, bool>> predicate);
+        public static Decimal Sum(this IQueryable<Decimal> source);
+        public static double Sum(this IQueryable<double> source);
+        public static int Sum(this IQueryable<int> source);
+        public static long Sum(this IQueryable<long> source);
+        public static Nullable<Decimal> Sum(this IQueryable<Nullable<Decimal>> source);
+        public static Nullable<double> Sum(this IQueryable<Nullable<double>> source);
+        public static Nullable<int> Sum(this IQueryable<Nullable<int>> source);
+        public static Nullable<long> Sum(this IQueryable<Nullable<long>> source);
+        public static Nullable<float> Sum(this IQueryable<Nullable<float>> source);
+        public static float Sum(this IQueryable<float> source);
+        public static Decimal Sum<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, Decimal>> selector);
+        public static double Sum<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, double>> selector);
+        public static int Sum<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, int>> selector);
+        public static long Sum<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, long>> selector);
+        public static Nullable<Decimal> Sum<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, Nullable<Decimal>>> selector);
+        public static Nullable<double> Sum<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, Nullable<double>>> selector);
+        public static Nullable<int> Sum<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, Nullable<int>>> selector);
+        public static Nullable<long> Sum<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, Nullable<long>>> selector);
+        public static Nullable<float> Sum<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, Nullable<float>>> selector);
+        public static float Sum<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, float>> selector);
+        public static IQueryable<TSource> Take<TSource>(this IQueryable<TSource> source, int count);
+        public static IQueryable<TSource> TakeWhile<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, bool>> predicate);
+        public static IQueryable<TSource> TakeWhile<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, int, bool>> predicate);
+        public static IOrderedQueryable<TSource> ThenBy<TSource, TKey>(this IOrderedQueryable<TSource> source, Expression<Func<TSource, TKey>> keySelector);
+        public static IOrderedQueryable<TSource> ThenBy<TSource, TKey>(this IOrderedQueryable<TSource> source, Expression<Func<TSource, TKey>> keySelector, IComparer<TKey> comparer);
+        public static IOrderedQueryable<TSource> ThenByDescending<TSource, TKey>(this IOrderedQueryable<TSource> source, Expression<Func<TSource, TKey>> keySelector);
+        public static IOrderedQueryable<TSource> ThenByDescending<TSource, TKey>(this IOrderedQueryable<TSource> source, Expression<Func<TSource, TKey>> keySelector, IComparer<TKey> comparer);
+        public static IQueryable<TSource> Union<TSource>(this IQueryable<TSource> source1, IEnumerable<TSource> source2);
+        public static IQueryable<TSource> Union<TSource>(this IQueryable<TSource> source1, IEnumerable<TSource> source2, IEqualityComparer<TSource> comparer);
+        public static IQueryable<TSource> Where<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, bool>> predicate);
+        public static IQueryable<TSource> Where<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, int, bool>> predicate);
+        public static IQueryable<TResult> Zip<TFirst, TSecond, TResult>(this IQueryable<TFirst> source1, IEnumerable<TSecond> source2, Expression<Func<TFirst, TSecond, TResult>> resultSelector);
+    }
+}
```

