# System.Runtime.CompilerServices

``` diff
+namespace System.Runtime.CompilerServices {
+    public sealed class AccessedThroughPropertyAttribute : Attribute {
+        public AccessedThroughPropertyAttribute(string propertyName);
+        public string PropertyName { get; }
+    }
+    public sealed class AsyncStateMachineAttribute : StateMachineAttribute {
+        public AsyncStateMachineAttribute(Type stateMachineType);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct AsyncTaskMethodBuilder {
+        public Task Task { get; }
+        public void AwaitOnCompleted<TAwaiter, TStateMachine>(ref TAwaiter awaiter, ref TStateMachine stateMachine) where TAwaiter : INotifyCompletion where TStateMachine : IAsyncStateMachine;
+        public void AwaitUnsafeOnCompleted<TAwaiter, TStateMachine>(ref TAwaiter awaiter, ref TStateMachine stateMachine) where TAwaiter : ICriticalNotifyCompletion where TStateMachine : IAsyncStateMachine;
+        public static AsyncTaskMethodBuilder Create();
+        public void SetException(Exception exception);
+        public void SetResult();
+        public void SetStateMachine(IAsyncStateMachine stateMachine);
+        public void Start<TStateMachine>(ref TStateMachine stateMachine) where TStateMachine : IAsyncStateMachine;
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct AsyncTaskMethodBuilder<TResult> {
+        public Task<TResult> Task { get; }
+        public void AwaitOnCompleted<TAwaiter, TStateMachine>(ref TAwaiter awaiter, ref TStateMachine stateMachine) where TAwaiter : INotifyCompletion where TStateMachine : IAsyncStateMachine;
+        public void AwaitUnsafeOnCompleted<TAwaiter, TStateMachine>(ref TAwaiter awaiter, ref TStateMachine stateMachine) where TAwaiter : ICriticalNotifyCompletion where TStateMachine : IAsyncStateMachine;
+        public static AsyncTaskMethodBuilder<TResult> Create();
+        public void SetException(Exception exception);
+        public void SetResult(TResult result);
+        public void SetStateMachine(IAsyncStateMachine stateMachine);
+        public void Start<TStateMachine>(ref TStateMachine stateMachine) where TStateMachine : IAsyncStateMachine;
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct AsyncVoidMethodBuilder {
+        public void AwaitOnCompleted<TAwaiter, TStateMachine>(ref TAwaiter awaiter, ref TStateMachine stateMachine) where TAwaiter : INotifyCompletion where TStateMachine : IAsyncStateMachine;
+        public void AwaitUnsafeOnCompleted<TAwaiter, TStateMachine>(ref TAwaiter awaiter, ref TStateMachine stateMachine) where TAwaiter : ICriticalNotifyCompletion where TStateMachine : IAsyncStateMachine;
+        public static AsyncVoidMethodBuilder Create();
+        public void SetException(Exception exception);
+        public void SetResult();
+        public void SetStateMachine(IAsyncStateMachine stateMachine);
+        public void Start<TStateMachine>(ref TStateMachine stateMachine) where TStateMachine : IAsyncStateMachine;
+    }
+    public class CallConvCdecl
+    public class CallConvFastcall
+    public class CallConvStdcall
+    public class CallConvThiscall
+    public sealed class CallerFilePathAttribute : Attribute {
+        public CallerFilePathAttribute();
+    }
+    public sealed class CallerLineNumberAttribute : Attribute {
+        public CallerLineNumberAttribute();
+    }
+    public sealed class CallerMemberNameAttribute : Attribute {
+        public CallerMemberNameAttribute();
+    }
+    public class CallSite {
+        public CallSiteBinder Binder { get; }
+        public static CallSite Create(Type delegateType, CallSiteBinder binder);
+    }
+    public class CallSite<T> : CallSite where T : class {
+        public T Target;
+        public T Update { get; }
+        public static CallSite<T> Create(CallSiteBinder binder);
+    }
+    public abstract class CallSiteBinder {
+        protected CallSiteBinder();
+        public static LabelTarget UpdateLabel { get; }
+        public abstract Expression Bind(object[] args, ReadOnlyCollection<ParameterExpression> parameters, LabelTarget returnLabel);
+        public virtual T BindDelegate<T>(CallSite<T> site, object[] args) where T : class;
+        protected void CacheTarget<T>(T target) where T : class;
+    }
+    public static class CallSiteHelpers {
+        public static bool IsInternalFrame(MethodBase mb);
+    }
+    public enum CompilationRelaxations {
+        NoStringInterning = 8,
+    }
+    public class CompilationRelaxationsAttribute : Attribute {
+        public CompilationRelaxationsAttribute(int relaxations);
+        public CompilationRelaxationsAttribute(CompilationRelaxations relaxations);
+        public int CompilationRelaxations { get; }
+    }
+    public sealed class CompilerGeneratedAttribute : Attribute {
+        public CompilerGeneratedAttribute();
+    }
+    public static class CompilerMarshalOverride
+    public sealed class ConditionalWeakTable<TKey, TValue> where TKey : class where TValue : class {
+        public ConditionalWeakTable();
+        public void Add(TKey key, TValue value);
+        ~ConditionalWeakTable();
+        public TValue GetOrCreateValue(TKey key);
+        public TValue GetValue(TKey key, ConditionalWeakTable<TKey, TValue>.CreateValueCallback createValueCallback);
+        public bool Remove(TKey key);
+        public bool TryGetValue(TKey key, out TValue value);
+        public delegate TValue CreateValueCallback(TKey key);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct ConfiguredTaskAwaitable {
+        public ConfiguredTaskAwaitable.ConfiguredTaskAwaiter GetAwaiter();
+        [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+        public struct ConfiguredTaskAwaiter : ICriticalNotifyCompletion, INotifyCompletion {
+            public bool IsCompleted { get; }
+            public void GetResult();
+            public void OnCompleted(Action continuation);
+            public void UnsafeOnCompleted(Action continuation);
+        }
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct ConfiguredTaskAwaitable<TResult> {
+        public ConfiguredTaskAwaitable<TResult>.ConfiguredTaskAwaiter GetAwaiter();
+        [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+        public struct ConfiguredTaskAwaiter : ICriticalNotifyCompletion, INotifyCompletion {
+            public bool IsCompleted { get; }
+            public TResult GetResult();
+            public void OnCompleted(Action continuation);
+            public void UnsafeOnCompleted(Action continuation);
+        }
+    }
+    public struct ConfiguredValueTaskAwaitable<TResult> {
+        public ConfiguredValueTaskAwaitable<TResult>.ConfiguredValueTaskAwaiter GetAwaiter();
+        public struct ConfiguredValueTaskAwaiter : ICriticalNotifyCompletion, INotifyCompletion {
+            public bool IsCompleted { get; }
+            public TResult GetResult();
+            public void OnCompleted(Action continuation);
+            public void UnsafeOnCompleted(Action continuation);
+        }
+    }
+    public static class ContractHelper {
+        public static string RaiseContractFailedEvent(ContractFailureKind failureKind, string userMessage, string conditionText, Exception innerException);
+        public static void TriggerFailure(ContractFailureKind kind, string displayMessage, string userMessage, string conditionText, Exception innerException);
+    }
+    public abstract class CustomConstantAttribute : Attribute {
+        protected CustomConstantAttribute();
+        public abstract object Value { get; }
+    }
+    public sealed class DateTimeConstantAttribute : CustomConstantAttribute {
+        public DateTimeConstantAttribute(long ticks);
+        public override object Value { get; }
+    }
+    public sealed class DecimalConstantAttribute : Attribute {
+        public DecimalConstantAttribute(byte scale, byte sign, int hi, int mid, int low);
+        public DecimalConstantAttribute(byte scale, byte sign, uint hi, uint mid, uint low);
+        public Decimal Value { get; }
+    }
+    public sealed class DisablePrivateReflectionAttribute : Attribute {
+        public DisablePrivateReflectionAttribute();
+    }
+    public sealed class DynamicAttribute : Attribute {
+        public DynamicAttribute();
+        public DynamicAttribute(bool[] transformFlags);
+        public IList<bool> TransformFlags { get; }
+    }
+    public sealed class ExtensionAttribute : Attribute {
+        public ExtensionAttribute();
+    }
+    public sealed class FixedAddressValueTypeAttribute : Attribute {
+        public FixedAddressValueTypeAttribute();
+    }
+    public sealed class FixedBufferAttribute : Attribute {
+        public FixedBufferAttribute(Type elementType, int length);
+        public Type ElementType { get; }
+        public int Length { get; }
+    }
+    public static class FormattableStringFactory {
+        public static FormattableString Create(string format, params object[] arguments);
+    }
+    public interface IAsyncStateMachine {
+        void MoveNext();
+        void SetStateMachine(IAsyncStateMachine stateMachine);
+    }
+    public interface ICastable {
+        RuntimeTypeHandle GetImplType(RuntimeTypeHandle interfaceType);
+        bool IsInstanceOfInterface(RuntimeTypeHandle interfaceType, out Exception castError);
+    }
+    public interface ICriticalNotifyCompletion : INotifyCompletion {
+        void UnsafeOnCompleted(Action continuation);
+    }
+    public sealed class IndexerNameAttribute : Attribute {
+        public IndexerNameAttribute(string indexerName);
+    }
+    public interface INotifyCompletion {
+        void OnCompleted(Action continuation);
+    }
+    public sealed class InternalsVisibleToAttribute : Attribute {
+        public InternalsVisibleToAttribute(string assemblyName);
+        public bool AllInternalsVisible { get; set; }
+        public string AssemblyName { get; }
+    }
+    public static class IsBoxed
+    public static class IsByValue
+    public static class IsConst
+    public static class IsCopyConstructed
+    public static class IsExplicitlyDereferenced
+    public static class IsImplicitlyDereferenced
+    public static class IsJitIntrinsic
+    public static class IsLong
+    public static class IsSignUnspecifiedByte
+    public interface IStrongBox {
+        object Value { get; set; }
+    }
+    public static class IsUdtReturn
+    public static class IsVolatile
+    public sealed class IteratorStateMachineAttribute : StateMachineAttribute {
+        public IteratorStateMachineAttribute(Type stateMachineType);
+    }
+    public enum MethodCodeType {
+        IL = 0,
+        Native = 1,
+        OPTIL = 2,
+        Runtime = 3,
+    }
+    public sealed class MethodImplAttribute : Attribute {
+        public MethodCodeType MethodCodeType;
+        public MethodImplAttribute();
+        public MethodImplAttribute(short value);
+        public MethodImplAttribute(MethodImplOptions methodImplOptions);
+        public MethodImplOptions Value { get; }
+    }
+    public enum MethodImplOptions {
+        AggressiveInlining = 256,
+        ForwardRef = 16,
+        InternalCall = 4096,
+        NoInlining = 8,
+        NoOptimization = 64,
+        PreserveSig = 128,
+        Synchronized = 32,
+        Unmanaged = 4,
+    }
+    public sealed class NativeCppClassAttribute : Attribute {
+        public NativeCppClassAttribute();
+    }
+    public sealed class ReferenceAssemblyAttribute : Attribute {
+        public ReferenceAssemblyAttribute();
+        public ReferenceAssemblyAttribute(string description);
+        public string Description { get; }
+    }
+    public sealed class RequiredAttributeAttribute : Attribute {
+        public RequiredAttributeAttribute(Type requiredContract);
+        public Type RequiredContract { get; }
+    }
+    public sealed class RuntimeCompatibilityAttribute : Attribute {
+        public RuntimeCompatibilityAttribute();
+        public bool WrapNonExceptionThrows { get; set; }
+    }
+    public static class RuntimeHelpers {
+        public static int OffsetToStringData { get; }
+        public static void EnsureSufficientExecutionStack();
+        public static int GetHashCode(object o);
+        public static object GetObjectValue(object obj);
+        public static object GetUninitializedObject(Type type);
+        public static void InitializeArray(Array array, RuntimeFieldHandle fldHandle);
+        public static void RunClassConstructor(RuntimeTypeHandle type);
+    }
+    public sealed class SpecialNameAttribute : Attribute {
+        public SpecialNameAttribute();
+    }
+    public class StateMachineAttribute : Attribute {
+        public StateMachineAttribute(Type stateMachineType);
+        public Type StateMachineType { get; }
+    }
+    public class StrongBox<T> : IStrongBox {
+        public T Value;
+        public StrongBox();
+        public StrongBox(T value);
+        object System.Runtime.CompilerServices.IStrongBox.Value { get; set; }
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct TaskAwaiter : ICriticalNotifyCompletion, INotifyCompletion {
+        public bool IsCompleted { get; }
+        public void GetResult();
+        public void OnCompleted(Action continuation);
+        public void UnsafeOnCompleted(Action continuation);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct TaskAwaiter<TResult> : ICriticalNotifyCompletion, INotifyCompletion {
+        public bool IsCompleted { get; }
+        public TResult GetResult();
+        public void OnCompleted(Action continuation);
+        public void UnsafeOnCompleted(Action continuation);
+    }
+    public sealed class TypeForwardedFromAttribute : Attribute {
+        public TypeForwardedFromAttribute(string assemblyFullName);
+        public string AssemblyFullName { get; }
+    }
+    public sealed class TypeForwardedToAttribute : Attribute {
+        public TypeForwardedToAttribute(Type destination);
+        public Type Destination { get; }
+    }
+    public static class Unsafe {
+        [MethodImpl(AggressiveInlining)]public static T As<T>(object o) where T : class;
+        [MethodImpl(AggressiveInlining)]public unsafe static void* AsPointer<T>(ref T value);
+        [MethodImpl(AggressiveInlining)]public unsafe static T AsRef<T>(void* source);
+        [MethodImpl(AggressiveInlining)]public unsafe static void Copy<T>(void* destination, ref T source);
+        [MethodImpl(AggressiveInlining)]public unsafe static void Copy<T>(ref T destination, void* source);
+        [MethodImpl(AggressiveInlining)]public unsafe static void CopyBlock(void* destination, void* source, uint byteCount);
+        [MethodImpl(AggressiveInlining)]public unsafe static void InitBlock(void* startAddress, byte value, uint byteCount);
+        [MethodImpl(AggressiveInlining)]public unsafe static T Read<T>(void* source);
+        [MethodImpl(AggressiveInlining)]public static int SizeOf<T>();
+        [MethodImpl(AggressiveInlining)]public unsafe static void Write<T>(void* destination, T value);
+    }
+    public sealed class UnsafeValueTypeAttribute : Attribute {
+        public UnsafeValueTypeAttribute();
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct ValueTaskAwaiter<TResult> : ICriticalNotifyCompletion, INotifyCompletion {
+        public bool IsCompleted { get; }
+        public TResult GetResult();
+        public void OnCompleted(Action continuation);
+        public void UnsafeOnCompleted(Action continuation);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential, Size=1)]
+    public struct YieldAwaitable {
+        public YieldAwaitable.YieldAwaiter GetAwaiter();
+        [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential, Size=1)]
+        public struct YieldAwaiter : ICriticalNotifyCompletion, INotifyCompletion {
+            public bool IsCompleted { get; }
+            public void GetResult();
+            public void OnCompleted(Action continuation);
+            public void UnsafeOnCompleted(Action continuation);
+        }
+    }
+}
```

