# System.Runtime.Serialization

``` diff
+namespace System.Runtime.Serialization {
+    public sealed class CollectionDataContractAttribute : Attribute {
+        public CollectionDataContractAttribute();
+        public bool IsItemNameSetExplicitly { get; }
+        public bool IsKeyNameSetExplicitly { get; }
+        public bool IsNameSetExplicitly { get; }
+        public bool IsNamespaceSetExplicitly { get; }
+        public bool IsReference { get; set; }
+        public bool IsReferenceSetExplicitly { get; }
+        public bool IsValueNameSetExplicitly { get; }
+        public string ItemName { get; set; }
+        public string KeyName { get; set; }
+        public string Name { get; set; }
+        public string Namespace { get; set; }
+        public string ValueName { get; set; }
+    }
+    public sealed class ContractNamespaceAttribute : Attribute {
+        public ContractNamespaceAttribute(string contractNamespace);
+        public string ClrNamespace { get; set; }
+        public string ContractNamespace { get; }
+    }
+    public sealed class DataContractAttribute : Attribute {
+        public DataContractAttribute();
+        public bool IsNameSetExplicitly { get; }
+        public bool IsNamespaceSetExplicitly { get; }
+        public bool IsReference { get; set; }
+        public bool IsReferenceSetExplicitly { get; }
+        public string Name { get; set; }
+        public string Namespace { get; set; }
+    }
+    public abstract class DataContractResolver {
+        protected DataContractResolver();
+        public abstract Type ResolveName(string typeName, string typeNamespace, Type declaredType, DataContractResolver knownTypeResolver);
+        public abstract bool TryResolveType(Type type, Type declaredType, DataContractResolver knownTypeResolver, out XmlDictionaryString typeName, out XmlDictionaryString typeNamespace);
+    }
+    public sealed class DataContractSerializer : XmlObjectSerializer {
+        public DataContractSerializer(Type type);
+        public DataContractSerializer(Type type, IEnumerable<Type> knownTypes);
+        public DataContractSerializer(Type type, DataContractSerializerSettings settings);
+        public DataContractSerializer(Type type, string rootName, string rootNamespace);
+        public DataContractSerializer(Type type, string rootName, string rootNamespace, IEnumerable<Type> knownTypes);
+        public DataContractSerializer(Type type, XmlDictionaryString rootName, XmlDictionaryString rootNamespace);
+        public DataContractSerializer(Type type, XmlDictionaryString rootName, XmlDictionaryString rootNamespace, IEnumerable<Type> knownTypes);
+        public DataContractSerializer(Type type, XmlDictionaryString rootName, XmlDictionaryString rootNamespace, IEnumerable<Type> knownTypes, int maxItemsInObjectGraph, bool ignoreExtensionDataObject, bool preserveObjectReferences, DataContractResolver dataContractResolver);
+        public DataContractResolver DataContractResolver { get; }
+        public bool IgnoreExtensionDataObject { get; }
+        public ReadOnlyCollection<Type> KnownTypes { get; }
+        public int MaxItemsInObjectGraph { get; }
+        public bool PreserveObjectReferences { get; }
+        public bool SerializeReadOnlyTypes { get; }
+        public override bool IsStartObject(XmlDictionaryReader reader);
+        public override bool IsStartObject(XmlReader reader);
+        public override object ReadObject(XmlDictionaryReader reader, bool verifyObjectName);
+        public override object ReadObject(XmlReader reader);
+        public override object ReadObject(XmlReader reader, bool verifyObjectName);
+        public override void WriteEndObject(XmlDictionaryWriter writer);
+        public override void WriteEndObject(XmlWriter writer);
+        public override void WriteObject(XmlWriter writer, object graph);
+        public override void WriteObjectContent(XmlDictionaryWriter writer, object graph);
+        public override void WriteObjectContent(XmlWriter writer, object graph);
+        public override void WriteStartObject(XmlDictionaryWriter writer, object graph);
+        public override void WriteStartObject(XmlWriter writer, object graph);
+    }
+    public static class DataContractSerializerExtensions {
+        public static ISerializationSurrogateProvider GetSerializationSurrogateProvider(this DataContractSerializer serializer);
+        public static void SetSerializationSurrogateProvider(this DataContractSerializer serializer, ISerializationSurrogateProvider provider);
+    }
+    public class DataContractSerializerSettings {
+        public DataContractSerializerSettings();
+        public DataContractResolver DataContractResolver { get; set; }
+        public IEnumerable<Type> KnownTypes { get; set; }
+        public int MaxItemsInObjectGraph { get; set; }
+        public bool PreserveObjectReferences { get; set; }
+        public XmlDictionaryString RootName { get; set; }
+        public XmlDictionaryString RootNamespace { get; set; }
+        public bool SerializeReadOnlyTypes { get; set; }
+    }
+    public sealed class DataMemberAttribute : Attribute {
+        public DataMemberAttribute();
+        public bool EmitDefaultValue { get; set; }
+        public bool IsNameSetExplicitly { get; }
+        public bool IsRequired { get; set; }
+        public string Name { get; set; }
+        public int Order { get; set; }
+    }
+    public class DateTimeFormat {
+        public DateTimeFormat(string formatString);
+        public DateTimeFormat(string formatString, IFormatProvider formatProvider);
+        public DateTimeStyles DateTimeStyles { get; set; }
+        public IFormatProvider FormatProvider { get; }
+        public string FormatString { get; }
+    }
+    public enum EmitTypeInformation {
+        Always = 1,
+        AsNeeded = 0,
+        Never = 2,
+    }
+    public sealed class EnumMemberAttribute : Attribute {
+        public EnumMemberAttribute();
+        public bool IsValueSetExplicitly { get; }
+        public string Value { get; set; }
+    }
+    public static class FormatterServices {
+        public static object GetUninitializedObject(Type type);
+    }
+    public class GeneratedXmlSerializers {
+        public GeneratedXmlSerializers();
+        public static bool IsInitialized { get; }
+        public static Dictionary<string, Type> GetGeneratedSerializers();
+    }
+    public sealed class IgnoreDataMemberAttribute : Attribute {
+        public IgnoreDataMemberAttribute();
+    }
+    public class InvalidDataContractException : Exception {
+        public InvalidDataContractException();
+        public InvalidDataContractException(string message);
+        public InvalidDataContractException(string message, Exception innerException);
+    }
+    public interface ISerializationSurrogateProvider {
+        object GetDeserializedObject(object obj, Type targetType);
+        object GetObjectToSerialize(object obj, Type targetType);
+        Type GetSurrogateType(Type type);
+    }
+    public static class JsonFormatGeneratorStatics {
+        public static PropertyInfo CollectionItemNameProperty { get; }
+        public static MethodInfo GetCurrentMethod { get; }
+        public static MethodInfo GetItemContractMethod { get; }
+        public static MethodInfo GetJsonDataContractMethod { get; }
+        public static MethodInfo GetJsonMemberIndexMethod { get; }
+        public static MethodInfo GetJsonMemberNameMethod { get; }
+        public static MethodInfo GetRevisedItemContractMethod { get; }
+        public static MethodInfo GetUninitializedObjectMethod { get; }
+        public static MethodInfo IsStartElementMethod0 { get; }
+        public static MethodInfo IsStartElementMethod2 { get; }
+        public static PropertyInfo LocalNameProperty { get; }
+        public static MethodInfo MoveNextMethod { get; }
+        public static MethodInfo MoveToContentMethod { get; }
+        public static PropertyInfo NamespaceProperty { get; }
+        public static PropertyInfo NodeTypeProperty { get; }
+        public static MethodInfo ParseEnumMethod { get; }
+        public static MethodInfo ReadJsonValueMethod { get; }
+        public static ConstructorInfo SerializationExceptionCtor { get; }
+        public static MethodInfo ThrowDuplicateMemberExceptionMethod { get; }
+        public static MethodInfo ThrowMissingRequiredMembersMethod { get; }
+        public static PropertyInfo TypeHandleProperty { get; }
+        public static PropertyInfo UseSimpleDictionaryFormatReadProperty { get; }
+        public static PropertyInfo UseSimpleDictionaryFormatWriteProperty { get; }
+        public static MethodInfo WriteAttributeStringMethod { get; }
+        public static MethodInfo WriteEndElementMethod { get; }
+        public static MethodInfo WriteJsonISerializableMethod { get; }
+        public static MethodInfo WriteJsonNameWithMappingMethod { get; }
+        public static MethodInfo WriteJsonValueMethod { get; }
+        public static MethodInfo WriteStartElementMethod { get; }
+        public static MethodInfo WriteStartElementStringMethod { get; }
+    }
+    public sealed class KnownTypeAttribute : Attribute {
+        public KnownTypeAttribute(string methodName);
+        public KnownTypeAttribute(Type type);
+        public string MethodName { get; }
+        public Type Type { get; }
+    }
+    public sealed class OnDeserializedAttribute : Attribute {
+        public OnDeserializedAttribute();
+    }
+    public sealed class OnDeserializingAttribute : Attribute {
+        public OnDeserializingAttribute();
+    }
+    public sealed class OnSerializedAttribute : Attribute {
+        public OnSerializedAttribute();
+    }
+    public sealed class OnSerializingAttribute : Attribute {
+        public OnSerializingAttribute();
+    }
+    public class SerializationException : Exception {
+        public SerializationException();
+        public SerializationException(string message);
+        public SerializationException(string message, Exception innerException);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct StreamingContext {
+        public StreamingContext(StreamingContextStates state);
+        public StreamingContext(StreamingContextStates state, object additional);
+        public object Context { get; }
+        public StreamingContextStates State { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+    }
+    public enum StreamingContextStates {
+        All = 255,
+        Clone = 64,
+        CrossAppDomain = 128,
+        CrossMachine = 2,
+        CrossProcess = 1,
+        File = 4,
+        Other = 32,
+        Persistence = 8,
+        Remoting = 16,
+    }
+    public abstract class XmlObjectSerializer {
+        protected XmlObjectSerializer();
+        public abstract bool IsStartObject(XmlDictionaryReader reader);
+        public virtual bool IsStartObject(XmlReader reader);
+        public virtual object ReadObject(Stream stream);
+        public virtual object ReadObject(XmlDictionaryReader reader);
+        public abstract object ReadObject(XmlDictionaryReader reader, bool verifyObjectName);
+        public virtual object ReadObject(XmlReader reader);
+        public virtual object ReadObject(XmlReader reader, bool verifyObjectName);
+        public abstract void WriteEndObject(XmlDictionaryWriter writer);
+        public virtual void WriteEndObject(XmlWriter writer);
+        public virtual void WriteObject(Stream stream, object graph);
+        public virtual void WriteObject(XmlDictionaryWriter writer, object graph);
+        public virtual void WriteObject(XmlWriter writer, object graph);
+        public abstract void WriteObjectContent(XmlDictionaryWriter writer, object graph);
+        public virtual void WriteObjectContent(XmlWriter writer, object graph);
+        public abstract void WriteStartObject(XmlDictionaryWriter writer, object graph);
+        public virtual void WriteStartObject(XmlWriter writer, object graph);
+    }
+    public static class XmlSerializableServices {
+        public static XmlNode[] ReadNodes(XmlReader xmlReader);
+        public static void WriteNodes(XmlWriter xmlWriter, XmlNode[] nodes);
+    }
+}
```

