# System.Security.Authentication

``` diff
+namespace System.Security.Authentication {
+    public class AuthenticationException : Exception {
+        public AuthenticationException();
+        public AuthenticationException(string message);
+        public AuthenticationException(string message, Exception innerException);
+    }
+    public enum CipherAlgorithmType {
+        Aes = 26129,
+        Aes128 = 26126,
+        Aes192 = 26127,
+        Aes256 = 26128,
+        Des = 26113,
+        None = 0,
+        Null = 24576,
+        Rc2 = 26114,
+        Rc4 = 26625,
+        TripleDes = 26115,
+    }
+    public enum ExchangeAlgorithmType {
+        DiffieHellman = 43522,
+        None = 0,
+        RsaKeyX = 41984,
+        RsaSign = 9216,
+    }
+    public enum HashAlgorithmType {
+        Md5 = 32771,
+        None = 0,
+        Sha1 = 32772,
+    }
+    public class InvalidCredentialException : AuthenticationException {
+        public InvalidCredentialException();
+        public InvalidCredentialException(string message);
+        public InvalidCredentialException(string message, Exception innerException);
+    }
+    public enum SslProtocols {
+        None = 0,
+        Ssl2 = 12,
+        Ssl3 = 48,
+        Tls = 192,
+        Tls11 = 768,
+        Tls12 = 3072,
+    }
+}
```

