# System.ServiceModel.Description

``` diff
+namespace System.ServiceModel.Description {
+    public class ClientCredentials : IEndpointBehavior {
+        public ClientCredentials();
+        protected ClientCredentials(ClientCredentials other);
+        public X509CertificateInitiatorClientCredential ClientCertificate { get; }
+        public HttpDigestClientCredential HttpDigest { get; }
+        public X509CertificateRecipientClientCredential ServiceCertificate { get; }
+        public UserNamePasswordClientCredential UserName { get; }
+        public WindowsClientCredential Windows { get; }
+        public virtual void ApplyClientBehavior(ServiceEndpoint serviceEndpoint, ClientRuntime behavior);
+        public ClientCredentials Clone();
+        protected virtual ClientCredentials CloneCore();
+        public override SecurityTokenManager CreateSecurityTokenManager();
+        void System.ServiceModel.Description.IEndpointBehavior.AddBindingParameters(ServiceEndpoint serviceEndpoint, BindingParameterCollection bindingParameters);
+        void System.ServiceModel.Description.IEndpointBehavior.ApplyDispatchBehavior(ServiceEndpoint serviceEndpoint, EndpointDispatcher endpointDispatcher);
+        void System.ServiceModel.Description.IEndpointBehavior.Validate(ServiceEndpoint serviceEndpoint);
+    }
+    public class ContractDescription {
+        public ContractDescription(string name);
+        public ContractDescription(string name, string ns);
+        public KeyedByTypeCollection<IContractBehavior> Behaviors { get; }
+        public Type CallbackContractType { get; set; }
+        public string ConfigurationName { get; set; }
+        public KeyedCollection<Type, IContractBehavior> ContractBehaviors { get; }
+        public Type ContractType { get; set; }
+        public bool HasProtectionLevel { get; }
+        public string Name { get; set; }
+        public string Namespace { get; set; }
+        public OperationDescriptionCollection Operations { get; }
+        public ProtectionLevel ProtectionLevel { get; set; }
+        public SessionMode SessionMode { get; set; }
+        public static ContractDescription GetContract(Type contractType);
+        public static ContractDescription GetContract(Type contractType, object serviceImplementation);
+        public static ContractDescription GetContract(Type contractType, Type serviceType);
+        public Collection<ContractDescription> GetInheritedContracts();
+        public bool ShouldSerializeProtectionLevel();
+    }
+    public class DataContractSerializerOperationBehavior : IOperationBehavior {
+        public DataContractSerializerOperationBehavior(OperationDescription operation);
+        public DataContractSerializerOperationBehavior(OperationDescription operation, DataContractFormatAttribute dataContractFormatAttribute);
+        public DataContractFormatAttribute DataContractFormatAttribute { get; }
+        public DataContractResolver DataContractResolver { get; set; }
+        public bool IgnoreExtensionDataObject { get; set; }
+        public int MaxItemsInObjectGraph { get; set; }
+        public virtual XmlObjectSerializer CreateSerializer(Type type, string name, string ns, IList<Type> knownTypes);
+        public virtual XmlObjectSerializer CreateSerializer(Type type, XmlDictionaryString name, XmlDictionaryString ns, IList<Type> knownTypes);
+        void System.ServiceModel.Description.IOperationBehavior.AddBindingParameters(OperationDescription description, BindingParameterCollection parameters);
+        void System.ServiceModel.Description.IOperationBehavior.ApplyClientBehavior(OperationDescription description, ClientOperation proxy);
+        void System.ServiceModel.Description.IOperationBehavior.ApplyDispatchBehavior(OperationDescription description, DispatchOperation dispatch);
+        void System.ServiceModel.Description.IOperationBehavior.Validate(OperationDescription description);
+    }
+    public class FaultDescription {
+        public FaultDescription(string action);
+        public string Action { get; }
+        public Type DetailType { get; set; }
+        public bool HasProtectionLevel { get; }
+        public string Name { get; set; }
+        public string Namespace { get; set; }
+        public ProtectionLevel ProtectionLevel { get; set; }
+        public bool ShouldSerializeProtectionLevel();
+    }
+    public class FaultDescriptionCollection : Collection<FaultDescription> {
+        public FaultDescription Find(string action);
+        public Collection<FaultDescription> FindAll(string action);
+    }
+    public interface IContractBehavior {
+        void AddBindingParameters(ContractDescription contractDescription, ServiceEndpoint endpoint, BindingParameterCollection bindingParameters);
+        void ApplyClientBehavior(ContractDescription contractDescription, ServiceEndpoint endpoint, ClientRuntime clientRuntime);
+        void ApplyDispatchBehavior(ContractDescription contractDescription, ServiceEndpoint endpoint, DispatchRuntime dispatchRuntime);
+        void Validate(ContractDescription contractDescription, ServiceEndpoint endpoint);
+    }
+    public interface IEndpointBehavior {
+        void AddBindingParameters(ServiceEndpoint endpoint, BindingParameterCollection bindingParameters);
+        void ApplyClientBehavior(ServiceEndpoint endpoint, ClientRuntime clientRuntime);
+        void ApplyDispatchBehavior(ServiceEndpoint endpoint, EndpointDispatcher endpointDispatcher);
+        void Validate(ServiceEndpoint endpoint);
+    }
+    public interface IOperationBehavior {
+        void AddBindingParameters(OperationDescription operationDescription, BindingParameterCollection bindingParameters);
+        void ApplyClientBehavior(OperationDescription operationDescription, ClientOperation clientOperation);
+        void ApplyDispatchBehavior(OperationDescription operationDescription, DispatchOperation dispatchOperation);
+        void Validate(OperationDescription operationDescription);
+    }
+    public enum ListenUriMode {
+        Explicit = 0,
+        Unique = 1,
+    }
+    public class MessageBodyDescription {
+        public MessageBodyDescription();
+        public MessagePartDescriptionCollection Parts { get; }
+        public MessagePartDescription ReturnValue { get; set; }
+        public string WrapperName { get; set; }
+        public string WrapperNamespace { get; set; }
+    }
+    public class MessageDescription {
+        public MessageDescription(string action, MessageDirection direction);
+        public string Action { get; }
+        public MessageBodyDescription Body { get; }
+        public MessageDirection Direction { get; }
+        public bool HasProtectionLevel { get; }
+        public MessageHeaderDescriptionCollection Headers { get; }
+        public Type MessageType { get; set; }
+        public MessagePropertyDescriptionCollection Properties { get; }
+        public ProtectionLevel ProtectionLevel { get; set; }
+        public bool ShouldSerializeProtectionLevel();
+    }
+    public class MessageDescriptionCollection : Collection<MessageDescription> {
+        public MessageDescription Find(string action);
+        public Collection<MessageDescription> FindAll(string action);
+    }
+    public enum MessageDirection {
+        Input = 0,
+        Output = 1,
+    }
+    public class MessageHeaderDescription : MessagePartDescription {
+        public MessageHeaderDescription(string name, string ns);
+        public string Actor { get; set; }
+        public bool MustUnderstand { get; set; }
+        public bool Relay { get; set; }
+        public bool TypedHeader { get; set; }
+    }
+    public class MessageHeaderDescriptionCollection : KeyedCollection<XmlQualifiedName, MessageHeaderDescription> {
+        protected override XmlQualifiedName GetKeyForItem(MessageHeaderDescription item);
+    }
+    public class MessagePartDescription {
+        public MessagePartDescription(string name, string ns);
+        public bool HasProtectionLevel { get; }
+        public int Index { get; set; }
+        public MemberInfo MemberInfo { get; set; }
+        public bool Multiple { get; set; }
+        public string Name { get; }
+        public string Namespace { get; }
+        public ProtectionLevel ProtectionLevel { get; set; }
+        public Type Type { get; set; }
+    }
+    public class MessagePartDescriptionCollection : KeyedCollection<XmlQualifiedName, MessagePartDescription> {
+        protected override XmlQualifiedName GetKeyForItem(MessagePartDescription item);
+    }
+    public class MessagePropertyDescription : MessagePartDescription {
+        public MessagePropertyDescription(string name);
+    }
+    public class MessagePropertyDescriptionCollection : KeyedCollection<string, MessagePropertyDescription> {
+        protected override string GetKeyForItem(MessagePropertyDescription item);
+    }
+    public class MetadataConversionError {
+        public MetadataConversionError(string message);
+        public MetadataConversionError(string message, bool isWarning);
+        public bool IsWarning { get; }
+        public string Message { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+    }
+    public class MetadataLocation {
+        public MetadataLocation();
+        public MetadataLocation(string location);
+        public string Location { get; set; }
+    }
+    public class OperationDescription {
+        public OperationDescription(string name, ContractDescription declaringContract);
+        public MethodInfo BeginMethod { get; set; }
+        public KeyedByTypeCollection<IOperationBehavior> Behaviors { get; }
+        public ContractDescription DeclaringContract { get; set; }
+        public MethodInfo EndMethod { get; set; }
+        public FaultDescriptionCollection Faults { get; }
+        public bool IsInitiating { get; set; }
+        public bool IsOneWay { get; }
+        public Collection<Type> KnownTypes { get; }
+        public MessageDescriptionCollection Messages { get; }
+        public string Name { get; }
+        public KeyedCollection<Type, IOperationBehavior> OperationBehaviors { get; }
+        public MethodInfo SyncMethod { get; set; }
+        public MethodInfo TaskMethod { get; set; }
+    }
+    public class OperationDescriptionCollection : Collection<OperationDescription> {
+        public OperationDescription Find(string name);
+        public Collection<OperationDescription> FindAll(string name);
+        protected override void InsertItem(int index, OperationDescription item);
+        protected override void SetItem(int index, OperationDescription item);
+    }
+    public sealed class PolicyVersion {
+        public static PolicyVersion Default { get; }
+        public string Namespace { get; }
+        public static PolicyVersion Policy12 { get; }
+        public static PolicyVersion Policy15 { get; }
+        public override string ToString();
+    }
+    public enum PrincipalPermissionMode {
+        Always = 4,
+        Custom = 3,
+        None = 0,
+        UseAspNetRoles = 2,
+        UseWindowsGroups = 1,
+    }
+    public class ServiceEndpoint {
+        public ServiceEndpoint(ContractDescription contract);
+        public ServiceEndpoint(ContractDescription contract, Binding binding, EndpointAddress address);
+        public EndpointAddress Address { get; set; }
+        public KeyedByTypeCollection<IEndpointBehavior> Behaviors { get; }
+        public Binding Binding { get; set; }
+        public ContractDescription Contract { get; set; }
+        public KeyedCollection<Type, IEndpointBehavior> EndpointBehaviors { get; }
+        public bool IsSystemEndpoint { get; set; }
+        public Uri ListenUri { get; set; }
+        public ListenUriMode ListenUriMode { get; set; }
+        public string Name { get; set; }
+    }
+    public class ServiceEndpointCollection : Collection<ServiceEndpoint> {
+        public ServiceEndpoint Find(Type contractType);
+        public ServiceEndpoint Find(Type contractType, XmlQualifiedName bindingName);
+        public ServiceEndpoint Find(Uri address);
+        public ServiceEndpoint Find(XmlQualifiedName contractName);
+        public ServiceEndpoint Find(XmlQualifiedName contractName, XmlQualifiedName bindingName);
+        public Collection<ServiceEndpoint> FindAll(Type contractType);
+        public Collection<ServiceEndpoint> FindAll(XmlQualifiedName contractName);
+        protected override void InsertItem(int index, ServiceEndpoint item);
+        protected override void SetItem(int index, ServiceEndpoint item);
+    }
+    public class XmlSerializerOperationBehavior : IOperationBehavior {
+        public XmlSerializerOperationBehavior(OperationDescription operation);
+        public XmlSerializerOperationBehavior(OperationDescription operation, XmlSerializerFormatAttribute attribute);
+        public XmlSerializerFormatAttribute XmlSerializerFormatAttribute { get; }
+        void System.ServiceModel.Description.IOperationBehavior.AddBindingParameters(OperationDescription description, BindingParameterCollection parameters);
+        void System.ServiceModel.Description.IOperationBehavior.ApplyClientBehavior(OperationDescription description, ClientOperation proxy);
+        void System.ServiceModel.Description.IOperationBehavior.ApplyDispatchBehavior(OperationDescription description, DispatchOperation dispatch);
+        void System.ServiceModel.Description.IOperationBehavior.Validate(OperationDescription description);
+    }
+}
```

