# System.ServiceModel.Security.Tokens

``` diff
+namespace System.ServiceModel.Security.Tokens {
+    public class ClaimTypeRequirement {
+        public ClaimTypeRequirement(string claimType);
+        public ClaimTypeRequirement(string claimType, bool isOptional);
+        public string ClaimType { get; }
+        public bool IsOptional { get; }
+    }
+    public sealed class InitiatorServiceModelSecurityTokenRequirement : ServiceModelSecurityTokenRequirement {
+        public InitiatorServiceModelSecurityTokenRequirement();
+        public EndpointAddress TargetAddress { get; set; }
+        public Uri Via { get; set; }
+        public override string ToString();
+    }
+    public interface ISecurityContextSecurityTokenCache {
+        void AddContext(SecurityContextSecurityToken token);
+        void ClearContexts();
+        Collection<SecurityContextSecurityToken> GetAllContexts(UniqueId contextId);
+        SecurityContextSecurityToken GetContext(UniqueId contextId, UniqueId generation);
+        void RemoveAllContexts(UniqueId contextId);
+        void RemoveContext(UniqueId contextId, UniqueId generation);
+        bool TryAddContext(SecurityContextSecurityToken token);
+        void UpdateContextCachingTime(SecurityContextSecurityToken context, DateTime expirationTime);
+    }
+    public sealed class RecipientServiceModelSecurityTokenRequirement : ServiceModelSecurityTokenRequirement {
+        public RecipientServiceModelSecurityTokenRequirement();
+        public Uri ListenUri { get; set; }
+        public override string ToString();
+    }
+    public class SecureConversationSecurityTokenParameters : SecurityTokenParameters {
+        public SecureConversationSecurityTokenParameters();
+        public SecureConversationSecurityTokenParameters(SecurityBindingElement bootstrapSecurityBindingElement);
+        protected SecureConversationSecurityTokenParameters(SecureConversationSecurityTokenParameters other);
+        public SecurityBindingElement BootstrapSecurityBindingElement { get; set; }
+        protected internal override bool HasAsymmetricKey { get; }
+        protected internal override bool SupportsClientAuthentication { get; }
+        protected internal override bool SupportsClientWindowsIdentity { get; }
+        protected internal override bool SupportsServerAuthentication { get; }
+        protected override SecurityTokenParameters CloneCore();
+        public override string ToString();
+    }
+    public class SecurityContextSecurityToken : SecurityToken, IDisposable, TimeBoundedCache.IExpirableItem {
+        public SecurityContextSecurityToken(UniqueId contextId, byte[] key, DateTime validFrom, DateTime validTo);
+        public SecurityContextSecurityToken(UniqueId contextId, string id, byte[] key, DateTime validFrom, DateTime validTo);
+        public SecurityContextSecurityToken(UniqueId contextId, string id, byte[] key, DateTime validFrom, DateTime validTo, ReadOnlyCollection<IAuthorizationPolicy> authorizationPolicies);
+        public SecurityContextSecurityToken(UniqueId contextId, string id, byte[] key, DateTime validFrom, DateTime validTo, UniqueId keyGeneration, DateTime keyEffectiveTime, DateTime keyExpirationTime, ReadOnlyCollection<IAuthorizationPolicy> authorizationPolicies);
+        public ReadOnlyCollection<IAuthorizationPolicy> AuthorizationPolicies { get; internal set; }
+        public SecurityMessageProperty BootstrapMessageProperty { get; set; }
+        public UniqueId ContextId { get; }
+        public override string Id { get; }
+        public bool IsCookieMode { get; }
+        public DateTime KeyEffectiveTime { get; }
+        public DateTime KeyExpirationTime { get; }
+        public UniqueId KeyGeneration { get; }
+        public override ReadOnlyCollection<SecurityKey> SecurityKeys { get; }
+        public override DateTime ValidFrom { get; }
+        public override DateTime ValidTo { get; }
+        public static SecurityContextSecurityToken CreateCookieSecurityContextToken(UniqueId contextId, string id, byte[] key, DateTime validFrom, DateTime validTo, ReadOnlyCollection<IAuthorizationPolicy> authorizationPolicies, SecurityStateEncoder securityStateEncoder);
+        public static SecurityContextSecurityToken CreateCookieSecurityContextToken(UniqueId contextId, string id, byte[] key, DateTime validFrom, DateTime validTo, UniqueId keyGeneration, DateTime keyEffectiveTime, DateTime keyExpirationTime, ReadOnlyCollection<IAuthorizationPolicy> authorizationPolicies, SecurityStateEncoder securityStateEncoder);
+        public void Dispose();
+        public override string ToString();
+    }
+    public enum SecurityTokenInclusionMode {
+        AlwaysToInitiator = 3,
+        AlwaysToRecipient = 0,
+        Never = 1,
+        Once = 2,
+    }
+    public abstract class SecurityTokenParameters {
+        protected SecurityTokenParameters();
+        protected SecurityTokenParameters(SecurityTokenParameters other);
+        protected internal abstract bool HasAsymmetricKey { get; }
+        public bool RequireDerivedKeys { get; set; }
+        protected internal abstract bool SupportsClientAuthentication { get; }
+        protected internal abstract bool SupportsClientWindowsIdentity { get; }
+        protected internal abstract bool SupportsServerAuthentication { get; }
+        public SecurityTokenParameters Clone();
+        protected abstract SecurityTokenParameters CloneCore();
+        public override string ToString();
+    }
+    public enum SecurityTokenReferenceStyle {
+        External = 1,
+        Internal = 0,
+    }
+    public abstract class ServiceModelSecurityTokenRequirement : SecurityTokenRequirement {
+        protected const string Namespace = "http://schemas.microsoft.com/ws/2006/05/servicemodel/securitytokenrequirement";
+        protected ServiceModelSecurityTokenRequirement();
+        public static string AuditLogLocationProperty { get; }
+        public static string ChannelParametersCollectionProperty { get; }
+        public static string DuplexClientLocalAddressProperty { get; }
+        public static string EndpointFilterTableProperty { get; }
+        public static string ExtendedProtectionPolicy { get; }
+        public static string HttpAuthenticationSchemeProperty { get; }
+        public bool IsInitiator { get; }
+        public static string IsInitiatorProperty { get; }
+        public static string IsOutOfBandTokenProperty { get; }
+        public static string IssuedSecurityTokenParametersProperty { get; }
+        public EndpointAddress IssuerAddress { get; set; }
+        public static string IssuerAddressProperty { get; }
+        public Binding IssuerBinding { get; set; }
+        public static string IssuerBindingContextProperty { get; }
+        public static string IssuerBindingProperty { get; }
+        public static string ListenUriProperty { get; }
+        public static string MessageAuthenticationAuditLevelProperty { get; }
+        public static string MessageDirectionProperty { get; }
+        public SecurityTokenVersion MessageSecurityVersion { get; set; }
+        public static string MessageSecurityVersionProperty { get; }
+        public static string PreferSslCertificateAuthenticatorProperty { get; }
+        public static string PrivacyNoticeUriProperty { get; }
+        public static string PrivacyNoticeVersionProperty { get; }
+        public SecurityBindingElement SecureConversationSecurityBindingElement { get; set; }
+        public static string SecureConversationSecurityBindingElementProperty { get; }
+        public SecurityAlgorithmSuite SecurityAlgorithmSuite { get; set; }
+        public static string SecurityAlgorithmSuiteProperty { get; }
+        public SecurityBindingElement SecurityBindingElement { get; set; }
+        public static string SecurityBindingElementProperty { get; }
+        public static string SupportingTokenAttachmentModeProperty { get; }
+        public static string SupportSecurityContextCancellationProperty { get; }
+        public static string SuppressAuditFailureProperty { get; }
+        public static string TargetAddressProperty { get; }
+        public string TransportScheme { get; set; }
+        public static string TransportSchemeProperty { get; }
+        public static string ViaProperty { get; }
+    }
+    public static class ServiceModelSecurityTokenTypes {
+        public static string AnonymousSslnego { get; }
+        public static string MutualSslnego { get; }
+        public static string SecureConversation { get; }
+        public static string SecurityContext { get; }
+        public static string Spnego { get; }
+        public static string SspiCredential { get; }
+    }
+    public class SspiSecurityToken : SecurityToken {
+        public SspiSecurityToken(NetworkCredential networkCredential, bool extractGroupsForWindowsAccounts, bool allowUnauthenticatedCallers);
+        public SspiSecurityToken(TokenImpersonationLevel impersonationLevel, bool allowNtlm, NetworkCredential networkCredential);
+        public bool AllowNtlm { get; }
+        public bool AllowUnauthenticatedCallers { get; }
+        public bool ExtractGroupsForWindowsAccounts { get; }
+        public override string Id { get; }
+        public TokenImpersonationLevel ImpersonationLevel { get; }
+        public NetworkCredential NetworkCredential { get; }
+        public override ReadOnlyCollection<SecurityKey> SecurityKeys { get; }
+        public override DateTime ValidFrom { get; }
+        public override DateTime ValidTo { get; }
+    }
+    public class SupportingTokenParameters {
+        public SupportingTokenParameters();
+        public Collection<SecurityTokenParameters> Endorsing { get; }
+        public Collection<SecurityTokenParameters> Signed { get; }
+        public Collection<SecurityTokenParameters> SignedEncrypted { get; }
+        public Collection<SecurityTokenParameters> SignedEndorsing { get; }
+        public SupportingTokenParameters Clone();
+        protected virtual SupportingTokenParameters CloneCore();
+        public void SetKeyDerivation(bool requireDerivedKeys);
+        public override string ToString();
+    }
+    public class UserNameSecurityTokenParameters : SecurityTokenParameters {
+        public UserNameSecurityTokenParameters();
+        protected UserNameSecurityTokenParameters(UserNameSecurityTokenParameters other);
+        protected internal override bool HasAsymmetricKey { get; }
+        protected internal override bool SupportsClientAuthentication { get; }
+        protected internal override bool SupportsClientWindowsIdentity { get; }
+        protected internal override bool SupportsServerAuthentication { get; }
+        protected override SecurityTokenParameters CloneCore();
+    }
+    public enum X509KeyIdentifierClauseType {
+        Any = 0,
+        IssuerSerial = 2,
+        RawDataKeyIdentifier = 4,
+        SubjectKeyIdentifier = 3,
+        Thumbprint = 1,
+    }
+}
```

