# System.Xml.Linq

``` diff
+namespace System.Xml.Linq {
+    public static class Extensions {
+        public static IEnumerable<XElement> Ancestors<T>(this IEnumerable<T> source) where T : XNode;
+        public static IEnumerable<XElement> Ancestors<T>(this IEnumerable<T> source, XName name) where T : XNode;
+        public static IEnumerable<XElement> AncestorsAndSelf(this IEnumerable<XElement> source);
+        public static IEnumerable<XElement> AncestorsAndSelf(this IEnumerable<XElement> source, XName name);
+        public static IEnumerable<XAttribute> Attributes(this IEnumerable<XElement> source);
+        public static IEnumerable<XAttribute> Attributes(this IEnumerable<XElement> source, XName name);
+        public static IEnumerable<XNode> DescendantNodes<T>(this IEnumerable<T> source) where T : XContainer;
+        public static IEnumerable<XNode> DescendantNodesAndSelf(this IEnumerable<XElement> source);
+        public static IEnumerable<XElement> Descendants<T>(this IEnumerable<T> source) where T : XContainer;
+        public static IEnumerable<XElement> Descendants<T>(this IEnumerable<T> source, XName name) where T : XContainer;
+        public static IEnumerable<XElement> DescendantsAndSelf(this IEnumerable<XElement> source);
+        public static IEnumerable<XElement> DescendantsAndSelf(this IEnumerable<XElement> source, XName name);
+        public static IEnumerable<XElement> Elements<T>(this IEnumerable<T> source) where T : XContainer;
+        public static IEnumerable<XElement> Elements<T>(this IEnumerable<T> source, XName name) where T : XContainer;
+        public static IEnumerable<T> InDocumentOrder<T>(this IEnumerable<T> source) where T : XNode;
+        public static IEnumerable<XNode> Nodes<T>(this IEnumerable<T> source) where T : XContainer;
+        public static void Remove(this IEnumerable<XAttribute> source);
+        public static void Remove<T>(this IEnumerable<T> source) where T : XNode;
+    }
+    public enum LoadOptions {
+        None = 0,
+        PreserveWhitespace = 1,
+        SetBaseUri = 2,
+        SetLineInfo = 4,
+    }
+    public enum ReaderOptions {
+        None = 0,
+        OmitDuplicateNamespaces = 1,
+    }
+    public enum SaveOptions {
+        DisableFormatting = 1,
+        None = 0,
+        OmitDuplicateNamespaces = 2,
+    }
+    public class XAttribute : XObject {
+        public XAttribute(XAttribute other);
+        public XAttribute(XName name, object value);
+        public static IEnumerable<XAttribute> EmptySequence { get; }
+        public bool IsNamespaceDeclaration { get; }
+        public XName Name { get; }
+        public XAttribute NextAttribute { get; }
+        public override XmlNodeType NodeType { get; }
+        public XAttribute PreviousAttribute { get; }
+        public string Value { get; set; }
+        public static explicit operator bool (XAttribute attribute);
+        public static explicit operator DateTime (XAttribute attribute);
+        public static explicit operator DateTimeOffset (XAttribute attribute);
+        public static explicit operator Decimal (XAttribute attribute);
+        public static explicit operator double (XAttribute attribute);
+        public static explicit operator Guid (XAttribute attribute);
+        public static explicit operator int (XAttribute attribute);
+        public static explicit operator long (XAttribute attribute);
+        public static explicit operator Nullable<bool> (XAttribute attribute);
+        public static explicit operator Nullable<DateTime> (XAttribute attribute);
+        public static explicit operator Nullable<DateTimeOffset> (XAttribute attribute);
+        public static explicit operator Nullable<Decimal> (XAttribute attribute);
+        public static explicit operator Nullable<double> (XAttribute attribute);
+        public static explicit operator Nullable<Guid> (XAttribute attribute);
+        public static explicit operator Nullable<int> (XAttribute attribute);
+        public static explicit operator Nullable<long> (XAttribute attribute);
+        public static explicit operator Nullable<float> (XAttribute attribute);
+        public static explicit operator Nullable<TimeSpan> (XAttribute attribute);
+        public static explicit operator Nullable<uint> (XAttribute attribute);
+        public static explicit operator Nullable<ulong> (XAttribute attribute);
+        public static explicit operator float (XAttribute attribute);
+        public static explicit operator string (XAttribute attribute);
+        public static explicit operator TimeSpan (XAttribute attribute);
+        public static explicit operator uint (XAttribute attribute);
+        public static explicit operator ulong (XAttribute attribute);
+        public void Remove();
+        public void SetValue(object value);
+        public override string ToString();
+    }
+    public class XCData : XText {
+        public XCData(string value);
+        public XCData(XCData other);
+        public override XmlNodeType NodeType { get; }
+        public override void WriteTo(XmlWriter writer);
+    }
+    public class XComment : XNode {
+        public XComment(string value);
+        public XComment(XComment other);
+        public override XmlNodeType NodeType { get; }
+        public string Value { get; set; }
+        public override void WriteTo(XmlWriter writer);
+    }
+    public abstract class XContainer : XNode {
+        public XNode FirstNode { get; }
+        public XNode LastNode { get; }
+        public void Add(object content);
+        public void Add(params object[] content);
+        public void AddFirst(object content);
+        public void AddFirst(params object[] content);
+        public XmlWriter CreateWriter();
+        public IEnumerable<XNode> DescendantNodes();
+        public IEnumerable<XElement> Descendants();
+        public IEnumerable<XElement> Descendants(XName name);
+        public XElement Element(XName name);
+        public IEnumerable<XElement> Elements();
+        public IEnumerable<XElement> Elements(XName name);
+        public IEnumerable<XNode> Nodes();
+        public void RemoveNodes();
+        public void ReplaceNodes(object content);
+        public void ReplaceNodes(params object[] content);
+    }
+    public class XDeclaration {
+        public XDeclaration(string version, string encoding, string standalone);
+        public XDeclaration(XDeclaration other);
+        public string Encoding { get; set; }
+        public string Standalone { get; set; }
+        public string Version { get; set; }
+        public override string ToString();
+    }
+    public class XDocument : XContainer {
+        public XDocument();
+        public XDocument(params object[] content);
+        public XDocument(XDeclaration declaration, params object[] content);
+        public XDocument(XDocument other);
+        public XDeclaration Declaration { get; set; }
+        public XDocumentType DocumentType { get; }
+        public override XmlNodeType NodeType { get; }
+        public XElement Root { get; }
+        public static XDocument Load(Stream stream);
+        public static XDocument Load(Stream stream, LoadOptions options);
+        public static XDocument Load(TextReader textReader);
+        public static XDocument Load(TextReader textReader, LoadOptions options);
+        public static XDocument Load(string uri);
+        public static XDocument Load(string uri, LoadOptions options);
+        public static XDocument Load(XmlReader reader);
+        public static XDocument Load(XmlReader reader, LoadOptions options);
+        public static XDocument Parse(string text);
+        public static XDocument Parse(string text, LoadOptions options);
+        public void Save(Stream stream);
+        public void Save(Stream stream, SaveOptions options);
+        public void Save(TextWriter textWriter);
+        public void Save(TextWriter textWriter, SaveOptions options);
+        public void Save(XmlWriter writer);
+        public override void WriteTo(XmlWriter writer);
+    }
+    public class XDocumentType : XNode {
+        public XDocumentType(string name, string publicId, string systemId, string internalSubset);
+        public XDocumentType(XDocumentType other);
+        public string InternalSubset { get; set; }
+        public string Name { get; set; }
+        public override XmlNodeType NodeType { get; }
+        public string PublicId { get; set; }
+        public string SystemId { get; set; }
+        public override void WriteTo(XmlWriter writer);
+    }
+    public class XElement : XContainer, IXmlSerializable {
+        public XElement(XElement other);
+        public XElement(XName name);
+        public XElement(XName name, object content);
+        public XElement(XName name, params object[] content);
+        public XElement(XStreamingElement other);
+        public static IEnumerable<XElement> EmptySequence { get; }
+        public XAttribute FirstAttribute { get; }
+        public bool HasAttributes { get; }
+        public bool HasElements { get; }
+        public bool IsEmpty { get; }
+        public XAttribute LastAttribute { get; }
+        public XName Name { get; set; }
+        public override XmlNodeType NodeType { get; }
+        public string Value { get; set; }
+        public IEnumerable<XElement> AncestorsAndSelf();
+        public IEnumerable<XElement> AncestorsAndSelf(XName name);
+        public XAttribute Attribute(XName name);
+        public IEnumerable<XAttribute> Attributes();
+        public IEnumerable<XAttribute> Attributes(XName name);
+        public IEnumerable<XNode> DescendantNodesAndSelf();
+        public IEnumerable<XElement> DescendantsAndSelf();
+        public IEnumerable<XElement> DescendantsAndSelf(XName name);
+        public XNamespace GetDefaultNamespace();
+        public XNamespace GetNamespaceOfPrefix(string prefix);
+        public string GetPrefixOfNamespace(XNamespace ns);
+        public static XElement Load(Stream stream);
+        public static XElement Load(Stream stream, LoadOptions options);
+        public static XElement Load(TextReader textReader);
+        public static XElement Load(TextReader textReader, LoadOptions options);
+        public static XElement Load(string uri);
+        public static XElement Load(string uri, LoadOptions options);
+        public static XElement Load(XmlReader reader);
+        public static XElement Load(XmlReader reader, LoadOptions options);
+        public static explicit operator bool (XElement element);
+        public static explicit operator DateTime (XElement element);
+        public static explicit operator DateTimeOffset (XElement element);
+        public static explicit operator Decimal (XElement element);
+        public static explicit operator double (XElement element);
+        public static explicit operator Guid (XElement element);
+        public static explicit operator int (XElement element);
+        public static explicit operator long (XElement element);
+        public static explicit operator Nullable<bool> (XElement element);
+        public static explicit operator Nullable<DateTime> (XElement element);
+        public static explicit operator Nullable<DateTimeOffset> (XElement element);
+        public static explicit operator Nullable<Decimal> (XElement element);
+        public static explicit operator Nullable<double> (XElement element);
+        public static explicit operator Nullable<Guid> (XElement element);
+        public static explicit operator Nullable<int> (XElement element);
+        public static explicit operator Nullable<long> (XElement element);
+        public static explicit operator Nullable<float> (XElement element);
+        public static explicit operator Nullable<TimeSpan> (XElement element);
+        public static explicit operator Nullable<uint> (XElement element);
+        public static explicit operator Nullable<ulong> (XElement element);
+        public static explicit operator float (XElement element);
+        public static explicit operator string (XElement element);
+        public static explicit operator TimeSpan (XElement element);
+        public static explicit operator uint (XElement element);
+        public static explicit operator ulong (XElement element);
+        public static XElement Parse(string text);
+        public static XElement Parse(string text, LoadOptions options);
+        public void RemoveAll();
+        public void RemoveAttributes();
+        public void ReplaceAll(object content);
+        public void ReplaceAll(params object[] content);
+        public void ReplaceAttributes(object content);
+        public void ReplaceAttributes(params object[] content);
+        public void Save(Stream stream);
+        public void Save(Stream stream, SaveOptions options);
+        public void Save(TextWriter textWriter);
+        public void Save(TextWriter textWriter, SaveOptions options);
+        public void Save(XmlWriter writer);
+        public void SetAttributeValue(XName name, object value);
+        public void SetElementValue(XName name, object value);
+        public void SetValue(object value);
+        XmlSchema System.Xml.Serialization.IXmlSerializable.GetSchema();
+        void System.Xml.Serialization.IXmlSerializable.ReadXml(XmlReader reader);
+        void System.Xml.Serialization.IXmlSerializable.WriteXml(XmlWriter writer);
+        public override void WriteTo(XmlWriter writer);
+    }
+    public sealed class XName : IEquatable<XName> {
+        public string LocalName { get; }
+        public XNamespace Namespace { get; }
+        public string NamespaceName { get; }
+        public override bool Equals(object obj);
+        public static XName Get(string expandedName);
+        public static XName Get(string localName, string namespaceName);
+        public override int GetHashCode();
+        public static bool operator ==(XName left, XName right);
+        public static implicit operator XName (string expandedName);
+        public static bool operator !=(XName left, XName right);
+        bool System.IEquatable<System.Xml.Linq.XName>.Equals(XName other);
+        public override string ToString();
+    }
+    public sealed class XNamespace {
+        public string NamespaceName { get; }
+        public static XNamespace None { get; }
+        public static XNamespace Xml { get; }
+        public static XNamespace Xmlns { get; }
+        public override bool Equals(object obj);
+        public static XNamespace Get(string namespaceName);
+        public override int GetHashCode();
+        public XName GetName(string localName);
+        public static XName operator +(XNamespace ns, string localName);
+        public static bool operator ==(XNamespace left, XNamespace right);
+        public static implicit operator XNamespace (string namespaceName);
+        public static bool operator !=(XNamespace left, XNamespace right);
+        public override string ToString();
+    }
+    public abstract class XNode : XObject {
+        public static XNodeDocumentOrderComparer DocumentOrderComparer { get; }
+        public static XNodeEqualityComparer EqualityComparer { get; }
+        public XNode NextNode { get; }
+        public XNode PreviousNode { get; }
+        public void AddAfterSelf(object content);
+        public void AddAfterSelf(params object[] content);
+        public void AddBeforeSelf(object content);
+        public void AddBeforeSelf(params object[] content);
+        public IEnumerable<XElement> Ancestors();
+        public IEnumerable<XElement> Ancestors(XName name);
+        public static int CompareDocumentOrder(XNode n1, XNode n2);
+        public XmlReader CreateReader();
+        public XmlReader CreateReader(ReaderOptions readerOptions);
+        public static bool DeepEquals(XNode n1, XNode n2);
+        public IEnumerable<XElement> ElementsAfterSelf();
+        public IEnumerable<XElement> ElementsAfterSelf(XName name);
+        public IEnumerable<XElement> ElementsBeforeSelf();
+        public IEnumerable<XElement> ElementsBeforeSelf(XName name);
+        public bool IsAfter(XNode node);
+        public bool IsBefore(XNode node);
+        public IEnumerable<XNode> NodesAfterSelf();
+        public IEnumerable<XNode> NodesBeforeSelf();
+        public static XNode ReadFrom(XmlReader reader);
+        public void Remove();
+        public void ReplaceWith(object content);
+        public void ReplaceWith(params object[] content);
+        public override string ToString();
+        public string ToString(SaveOptions options);
+        public abstract void WriteTo(XmlWriter writer);
+    }
+    public sealed class XNodeDocumentOrderComparer : IComparer, IComparer<XNode> {
+        public XNodeDocumentOrderComparer();
+        public int Compare(XNode x, XNode y);
+        int System.Collections.IComparer.Compare(object x, object y);
+    }
+    public sealed class XNodeEqualityComparer : IEqualityComparer, IEqualityComparer<XNode> {
+        public XNodeEqualityComparer();
+        public bool Equals(XNode x, XNode y);
+        public int GetHashCode(XNode obj);
+        bool System.Collections.IEqualityComparer.Equals(object x, object y);
+        int System.Collections.IEqualityComparer.GetHashCode(object obj);
+    }
+    public abstract class XObject : IXmlLineInfo {
+        public string BaseUri { get; }
+        public XDocument Document { get; }
+        public abstract XmlNodeType NodeType { get; }
+        public XElement Parent { get; }
+        int System.Xml.IXmlLineInfo.LineNumber { get; }
+        int System.Xml.IXmlLineInfo.LinePosition { get; }
+        public event EventHandler<XObjectChangeEventArgs> Changed;
+        public event EventHandler<XObjectChangeEventArgs> Changing;
+        public void AddAnnotation(object annotation);
+        public object Annotation(Type type);
+        public T Annotation<T>() where T : class;
+        public IEnumerable<object> Annotations(Type type);
+        public IEnumerable<T> Annotations<T>() where T : class;
+        public void RemoveAnnotations(Type type);
+        public void RemoveAnnotations<T>() where T : class;
+        bool System.Xml.IXmlLineInfo.HasLineInfo();
+    }
+    public enum XObjectChange {
+        Add = 0,
+        Name = 2,
+        Remove = 1,
+        Value = 3,
+    }
+    public class XObjectChangeEventArgs : EventArgs {
+        public static readonly XObjectChangeEventArgs Add;
+        public static readonly XObjectChangeEventArgs Name;
+        public static readonly XObjectChangeEventArgs Remove;
+        public static readonly XObjectChangeEventArgs Value;
+        public XObjectChangeEventArgs(XObjectChange objectChange);
+        public XObjectChange ObjectChange { get; }
+    }
+    public class XProcessingInstruction : XNode {
+        public XProcessingInstruction(string target, string data);
+        public XProcessingInstruction(XProcessingInstruction other);
+        public string Data { get; set; }
+        public override XmlNodeType NodeType { get; }
+        public string Target { get; set; }
+        public override void WriteTo(XmlWriter writer);
+    }
+    public class XStreamingElement {
+        public XStreamingElement(XName name);
+        public XStreamingElement(XName name, object content);
+        public XStreamingElement(XName name, params object[] content);
+        public XName Name { get; set; }
+        public void Add(object content);
+        public void Add(params object[] content);
+        public void Save(Stream stream);
+        public void Save(Stream stream, SaveOptions options);
+        public void Save(TextWriter textWriter);
+        public void Save(TextWriter textWriter, SaveOptions options);
+        public void Save(XmlWriter writer);
+        public override string ToString();
+        public string ToString(SaveOptions options);
+        public void WriteTo(XmlWriter writer);
+    }
+    public class XText : XNode {
+        public XText(string value);
+        public XText(XText other);
+        public override XmlNodeType NodeType { get; }
+        public string Value { get; set; }
+        public override void WriteTo(XmlWriter writer);
+    }
+}
```

