# .NET Core 1.0.15

.NET Core 1.0.15 comprises:

* .NET Core Runtime 1.0.15
* .NET Core SDK 1.1.13

See the [Release Notes](1.0.15.md) for details about what is included in this update.

|           | SDK Installer<sup>1</sup>                                   | SDK Binaries<sup>1</sup>                            | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-dev-win-x86.exe] \| [x64][dotnet-dev-win-x64.exe] | [x86][dotnet-dev-win-x86.zip] \| [x64][dotnet-dev-win-x64.zip] | [x86][dotnet-win-x86.exe] \| [x64][dotnet-win-x64.exe] | [x86][dotnet-win-x86.zip] \| [x64][dotnet-win-x64.zip] | [Hosting Bundle][DotNetCore-WindowsHosting.exe]<sup>2</sup> |
| macOS     | [x64][dotnet-dev-osx-x64.pkg]  | [x64][dotnet-dev-osx-x64.tar.gz]     | [x64][dotnet-osx-x64.pkg] | [x64][dotnet-osx-x64.tar.gz] | - |
| CentOS 7  | - | [x64][dotnet-dev-centos-x64.tar.gz] | - | [x64][dotnet-centos-x64.tar.gz]  | - |
| RHEL 7    | -                                                | [x64][dotnet-dev-rhel-x64.tar.gz]                    | -                                                        | [x64][dotnet-rhel-x64.tar.gz] | - |
| Ubuntu 14.04 | [See installations steps below](#installing-net-core-on-linux)   | [x64][dotnet-dev-ubuntu-x64.tar.gz] | - | [x64][dotnet-ubuntu-x64.tar.gz] | - |
| Ubuntu 16.04 | [See installations steps below](#installing-net-core-on-linux)   | [x64][dotnet-dev-ubuntu.16.04-x64.tar.gz] | - | [x64][dotnet-ubuntu.16.04-x64.tar.gz]  | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |
| Symbols   | -                                                | -                                        | [Runtime][coreclr-symbols.zip] \| [Shared Framework][corefx-symbols.zip] \| [Setup][core-setup-symbols.zip] | - | - |

1. Includes the .NET Core and ASP.NET Core runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

## Docker

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://devblogs.microsoft.com/dotnet/staying-up-to-date-with-net-container-images/).

## Installing .NET Core on Linux

Before installing .NET, you will need to register the Microsoft key, register the product repository, and install required dependencies. This only needs to be done once per machine. Refer to [Setting up Linux for .NET Core][linux-setup] for the requirements.

### Develop applications
To develop applications using the .NET Core SDK, run the following command. The .NET Core runtime and ASP.NET Core runtime are included.

In your command prompt, run the following commands:

```bash
# Ubuntu 14.04, 16,04
sudo apt-get install apt-transport-https
sudo apt-get update
sudo apt-get install dotnet-dev-1.1.13
```

### Run applications

If you only need to run existing applications, run the following command.

```bash
# Ubuntu 14.04, 16,04
sudo apt-get install dotnet-sharedframework-microsoft.netcore.app-1.0.15
```

## Installation from a binary archive

Installing from the packages detailed above is recommended or you can install from binary archive, if that better suits your needs. When using binary archives to install, the contents must be extracted to a user location such as `$HOME/dotnet`, a symbolic link created for `dotnet` and a few dependencies installed. Dependency requirements can be seen in the [Linux System Prerequisites](https://github.com/dotnet/core/blob/main/Documentation/linux-prereqs.md) document.

```bash
mkdir -p $HOME/dotnet && tar zxf dotnet.tar.gz -C $HOME/dotnet
export PATH=$PATH:$HOME/dotnet
```
[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/1.0/1.0.15.md

[dotnet-centos-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/160b5882-cc9f-4887-b641-b2049d0a1844/74e559657e6ca8f92319164506f8ad64/dotnet-centos-x64.1.0.15.tar.gz
[dotnet-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/171b6b96-9368-40f2-87a6-77a7a0f422e3/f706ac99ee323d1061611d4e84df742d/dotnet-osx-x64.1.0.15.pkg
[dotnet-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/97c4c0e5-fcf2-4b16-8409-b944f9fb47a7/30aaa5ce7fa2cd1d3eb7b1f87895b200/dotnet-osx-x64.1.0.15.tar.gz
[dotnet-rhel-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fd56a619-0349-41e4-8d51-8fdfc6737a18/a390a0f2ffd98974392787f10ab9f9c7/dotnet-rhel-x64.1.0.15.tar.gz
[dotnet-ubuntu-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2b72f114-4d62-4c48-a1b6-d835279265f7/cfc11b1fb5662150f6dfa39fc9942e2c/dotnet-ubuntu-x64.1.0.15.tar.gz
[dotnet-ubuntu.16.04-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/be4f3d33-e183-4c26-829f-72bb7621745e/3e0d958b595208d92f69910d83b8710e/dotnet-ubuntu.16.04-x64.1.0.15.tar.gz
[dotnet-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/bdddf6f5-6e40-419e-aa05-8f79fce98858/29d3462dfc5afd2b45296592f23fe65d/dotnet-win-x64.1.0.15.exe
[dotnet-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/0effb9d1-04e9-4854-bc84-fa84c20a4976/94047b6bc44454541048e84c5ed7da78/dotnet-win-x64.1.0.15.zip
[dotnet-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/933b73dc-4359-4233-9f81-73ad3a4d5054/79e1fb2b760c7610f17f915440e307cd/dotnet-win-x86.1.0.15.exe
[dotnet-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/75313578-d46c-4628-8583-af6f6ac273d7/a6d24992ba1c8bf56f96b733ccc08e0e/dotnet-win-x86.1.0.15.zip
[DotNetCore-WindowsHosting.exe]: https://download.visualstudio.microsoft.com/download/pr/b3978c43-8056-41f9-b567-4c8a450c71d7/d8f94aab409f0ae6f9d2a6519fe14343/dotnetcore.1.0.15_1.1.12-windowshosting.exe
[dotnet-dev-centos-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/532c2427-2819-4863-a4da-c427ccf0415b/9ca4fc6036483c28e86cfad26e4227c7/dotnet-dev-centos-x64.1.1.13.tar.gz
[dotnet-dev-fedora.27-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9d07c97e-0989-46f3-a557-1cc86c814a03/1a4a31641b1520700d60f171ff16abc0/dotnet-dev-fedora.27-x64.1.1.13.tar.gz
[dotnet-dev-fedora.28-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ff843544-d156-4436-acaa-0d25dbc9a391/846e9fcc4a2766cfff326463d6876e39/dotnet-dev-fedora.28-x64.1.1.13.tar.gz
[dotnet-dev-opensuse.42.3-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/207d2220-d884-4f47-a224-2fdf9bf887d1/d730f96e2f935890b280c22fd404c293/dotnet-dev-opensuse.42.3-x64.1.1.13.tar.gz
[dotnet-dev-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/822ea2bc-dc92-4308-b58f-24ce45300801/7c7bf7cb2c5f3749ef274bd411453910/dotnet-dev-osx-x64.1.1.13.pkg
[dotnet-dev-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d26e01f0-4335-4052-8b2b-a4ea87a7e0b4/2cdd5205a866b9f29c3761f99aa62025/dotnet-dev-osx-x64.1.1.13.tar.gz
[dotnet-dev-rhel-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6298829d-d18f-4571-8a5c-ba3e3b27741a/4ed6bc25bf8695446906d3f3759077ce/dotnet-dev-rhel-x64.1.1.13.tar.gz
[dotnet-dev-ubuntu-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4db77bc5-51be-4f3a-91c8-89107bd32d63/4ee3a040237910e4602dff38233e3586/dotnet-dev-ubuntu-x64.1.1.13.tar.gz
[dotnet-dev-ubuntu.16.04-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c1cc8138-c8d3-484e-b6d2-68a04169e8bc/2668526977ab8c06b06245ad1ecf7023/dotnet-dev-ubuntu.16.04-x64.1.1.13.tar.gz
[dotnet-dev-ubuntu.18.04-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/db940206-0e42-4015-984a-747a03a5fda3/587de9530f389160405851d794a23abc/dotnet-dev-ubuntu.18.04-x64.1.1.13.tar.gz
[dotnet-dev-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/b7107956-109a-4d0f-9c86-4d2ced882873/64c75af38565ed172f26c6127844ef34/dotnet-dev-win-x64.1.1.13.exe
[dotnet-dev-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/ae7bb680-ae5b-4845-ac96-15853610424c/823bb8b6e18f9d5ca5988d1c2ed062b3/dotnet-dev-win-x64.1.1.13.zip
[dotnet-dev-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/51ac7bf7-73c5-4898-bf31-a5856c41e76c/8a709db9717c1c393532595e440cfb41/dotnet-dev-win-x86.1.1.13.exe
[dotnet-dev-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/736ce425-d440-479b-9c9b-32e63e9c8920/e7d6d105281237b641351b57e7f8216a/dotnet-dev-win-x86.1.1.13.zip
[core-setup-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/04de3bc1-f47a-44fd-a169-9fad4800a953/b450e3b38fbbbbd81baf90bc4cce1653/core-setup-1.0.15-symbols.zip
[coreclr-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/b9586cd9-3158-4451-948c-1ab7388eacc4/5ce90f836e672be5afe27544c767ee48/coreclr-1.0.15-symbols.zip
[corefx-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/4e2a655f-b467-4c7b-8357-81efba877c99/3c9175fff6edf9d6e6c0334bcd42fee2/corefx-1.0.15-symbols.zip

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/1.0.15-runtime-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/1.1.13-sdk-sha.txt

[linux-install]: https://dotnet.microsoft.com/download/dotnet/1.0
[linux-setup]: https://github.com/dotnet/core/blob/main/Documentation/linux-setup.md
[dotnet-blog]: https://devblogs.microsoft.com/dotnet/2019/03/12/net-core-march-2019/
