# .NET Core 1.0.16

.NET Core 1.0.16 comprises:

* .NET Core Runtime 1.0.16
* .NET Core SDK 1.1.14

See the [Release Notes](1.0.16.md) for details about what is included in this update.

|           | SDK Installer<sup>1</sup>                                   | SDK Binaries<sup>1</sup>                            | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-dev-win-x86.exe] \| [x64][dotnet-dev-win-x64.exe] | [x86][dotnet-dev-win-x86.zip] \| [x64][dotnet-dev-win-x64.zip] | [x86][dotnet-win-x86.exe] \| [x64][dotnet-win-x64.exe] | [x86][dotnet-win-x86.zip] \| [x64][dotnet-win-x64.zip] | [Hosting Bundle][DotNetCore-WindowsHosting.exe]<sup>2</sup> |
| macOS     | [x64][dotnet-dev-osx-x64.pkg]  | [x64][dotnet-dev-osx-x64.tar.gz]     | [x64][dotnet-osx-x64.pkg] | [x64][dotnet-osx-x64.tar.gz] | - |
| CentOS 7  | - | [x64][dotnet-dev-centos-x64.tar.gz] | - | [x64][dotnet-centos-x64.tar.gz]  | - |
| RHEL 7    | -                                                | [x64][dotnet-dev-rhel-x64.tar.gz]                    | -                                                        | [x64][dotnet-rhel-x64.tar.gz] | - |
| Ubuntu 14.04 | [See installations steps below](#installing-net-core-on-linux)   | [x64][dotnet-dev-ubuntu-x64.tar.gz] | - | [x64][dotnet-ubuntu-x64.tar.gz] | - |
| Ubuntu 16.04 | [See installations steps below](#installing-net-core-on-linux)   | [x64][dotnet-dev-ubuntu.16.04-x64.tar.gz] | - | [x64][dotnet-ubuntu.16.04-x64.tar.gz]  | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |
| Symbols   | -                                                | -                                        | [Runtime][coreclr-symbols.zip] \| [Shared Framework][corefx-symbols.zip] \| [Setup][core-setup-symbols.zip] | - | - |

1. Includes the .NET Core and ASP.NET Core runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

## Docker

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://devblogs.microsoft.com/dotnet/staying-up-to-date-with-net-container-images/).

## Installing .NET Core on Linux

Before installing .NET, you will need to register the Microsoft key, register the product repository, and install required dependencies. This only needs to be done once per machine. Refer to [Setting up Linux for .NET Core][linux-setup] for the requirements.

### Develop applications
To develop applications using the .NET Core SDK, run the following command. The .NET Core runtime and ASP.NET Core runtime are included.

In your command prompt, run the following commands:

```bash
# Ubuntu 14.04, 16,04
sudo apt-get install apt-transport-https
sudo apt-get update
sudo apt-get install dotnet-dev-1.1.13
```

### Run applications

If you only need to run existing applications, run the following command.

```bash
# Ubuntu 14.04, 16,04
sudo apt-get install dotnet-sharedframework-microsoft.netcore.app-1.0.16
```

## Installation from a binary archive

Installing from the packages detailed above is recommended or you can install from binary archive, if that better suits your needs. When using binary archives to install, the contents must be extracted to a user location such as `$HOME/dotnet`, a symbolic link created for `dotnet` and a few dependencies installed. Dependency requirements can be seen in the [Linux System Prerequisites](https://github.com/dotnet/core/blob/main/Documentation/linux-prereqs.md) document.

```bash
mkdir -p $HOME/dotnet && tar zxf dotnet.tar.gz -C $HOME/dotnet
export PATH=$PATH:$HOME/dotnet
```
[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/1.0/1.0.16/1.0.16.md

[dotnet-centos-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b15f877f-1299-466b-805c-439c4b208229/6b0ebc8e907cd732744974e4f1f0b04f/dotnet-centos-x64.1.0.16.tar.gz
[dotnet-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/10f564b1-0578-4de0-9ed8-7890c60ccfb2/8dc054cf37402b2af50b11b1b9014130/dotnet-osx-x64.1.0.16.pkg
[dotnet-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5b37cce1-c0d9-4e91-9dc5-0058fbeb98e8/b675c1cf1b93eb646a6973e15ebe41e9/dotnet-osx-x64.1.0.16.tar.gz
[dotnet-rhel-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/25418bdb-42c9-4f7c-b0a5-737b09a93ffe/185240f5a2295d7a69af7aa7f931f3e7/dotnet-rhel-x64.1.0.16.tar.gz
[dotnet-ubuntu-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c335a4c7-d629-4b2d-b9c9-00b7d9912c42/856d1c1b365fd59874a93ee3683b655b/dotnet-ubuntu-x64.1.0.16.tar.gz
[dotnet-ubuntu.16.04-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2601c5ef-3949-4152-bd73-af595e088df5/91a88561ef94c1ef70d59ed112ac76f0/dotnet-ubuntu.16.04-x64.1.0.16.tar.gz
[dotnet-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/4d174497-74c3-4bf1-afe9-59c5a3810a4a/0a99d860da08e596727027510a68f250/dotnet-win-x64.1.0.16.exe
[dotnet-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/9b27f9be-50fb-4c69-b9be-cc6002bd1d1e/33c6eab6f3c08a7952c6adbd4cf75089/dotnet-win-x64.1.0.16.zip
[dotnet-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/64daed07-014f-4d3c-b3e7-637b004c86f3/3d0e71a686e7880bee84ee28bbf452c2/dotnet-win-x86.1.0.16.exe
[dotnet-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/9fc3e710-ce64-4523-8b50-5c4b01a8008e/06901323b3f87be43fd00f2d61f84729/dotnet-win-x86.1.0.16.zip
[DotNetCore-WindowsHosting.exe]: https://download.visualstudio.microsoft.com/download/pr/aa5a90a5-4fc3-4198-8bcf-881c6d7e500d/c0d3855628d650f67ad1131c2e43fa9f/dotnetcore.1.0.16_1.1.13-windowshosting.exe
[dotnet-dev-centos-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0abec983-ea91-4189-bec3-99cb6da412ce/ad2e817eb7ebb2b47dc5483e8037931d/dotnet-dev-centos-x64.1.1.14.tar.gz
[dotnet-dev-debian.9-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f2eacd39-7f1c-4512-bc99-255dbaf26683/8f4a5154db485d8748a074107deab39d/dotnet-dev-debian.9-x64.1.1.14.tar.gz
[dotnet-dev-fedora.27-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0e65a2ca-d7b6-498c-bb01-504037b3b9cf/f41356541937914c4f3dc620d62b9bd4/dotnet-dev-fedora.27-x64.1.1.14.tar.gz
[dotnet-dev-fedora.28-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/24288e79-b3ea-4f4a-aaf5-5c65bb83a0b7/19aa43e5b17be0b294ac0dbda1498d3e/dotnet-dev-fedora.28-x64.1.1.14.tar.gz
[dotnet-dev-opensuse.42.3-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cc69435f-1655-4bed-9ecf-ef5c0f422cd6/ff1919d3767e1b32f286265600ecbcc2/dotnet-dev-opensuse.42.3-x64.1.1.14.tar.gz
[dotnet-dev-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/110b99a1-956d-447b-a8b8-1ea3c5db4e91/fae4867498119342a328117f19437efb/dotnet-dev-osx-x64.1.1.14.pkg
[dotnet-dev-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d3dc46de-b060-4a4c-801b-3b33ee62485f/cd18f54d5259563a92c98bb0dc410176/dotnet-dev-osx-x64.1.1.14.tar.gz
[dotnet-dev-rhel-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/77cbb3f7-ca39-4884-944a-ba2dbe6bc7cc/cef42f3ed25e940c1b55d4a8f83f9a8f/dotnet-dev-rhel-x64.1.1.14.tar.gz
[dotnet-dev-ubuntu-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/98ae53a6-e2dd-496c-825a-bef389b5191f/1bf26c976962a2f8b3979d878d0f7a19/dotnet-dev-ubuntu-x64.1.1.14.tar.gz
[dotnet-dev-ubuntu.16.04-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7e1128cb-20b4-4ebd-b41c-c87ca7541ce6/e70c038f504107bdc90edc2811b819f6/dotnet-dev-ubuntu.16.04-x64.1.1.14.tar.gz
[dotnet-dev-ubuntu.18.04-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c942428a-f106-4e41-8493-f702a34562f4/ae165761acbf05d2e12419cb1d0424df/dotnet-dev-ubuntu.18.04-x64.1.1.14.tar.gz
[dotnet-dev-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/f53f5275-d721-4303-9bf3-e06c49687a96/9eb3d4e75dbf437d44291a61fe3c3443/dotnet-dev-win-x64.1.1.14.exe
[dotnet-dev-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/7493cfb3-dd7d-4d98-a114-c3d37a9bd322/976094b325aa4f9d180f443a945b1fcb/dotnet-dev-win-x64.1.1.14.zip
[dotnet-dev-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/f915581d-6116-4473-ba8f-8093e047c9de/4e2d74169c4419d3a80bc4edfdb5248b/dotnet-dev-win-x86.1.1.14.exe
[dotnet-dev-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/9f00da2a-a885-4ea0-b1e1-2b15c49fce2b/d7a3a37c85b290470fc5f6b6a98e1510/dotnet-dev-win-x86.1.1.14.zip
[core-setup-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/de24857a-e53c-403b-891d-66ab513496e9/dc7a06c174966c71ab93c2595fa84890/core-setup-1.0.16-symbols.zip
[coreclr-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/d01ea2b6-2b9a-42d8-9eb9-4659e6849d53/d832ab4eb94a6c2f596c44d4c1e78a6d/coreclr-1.0.16-symbols.zip
[corefx-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/79a3d837-f7dd-467f-a745-338ba0eaf5da/5e22bd1609af3e37f59ccd41d324260c/corefx-1.0.16-symbols.zip

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/1.0.16-runtime-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/1.1.14-sdk-sha.txt

[linux-install]: https://dotnet.microsoft.com/download/dotnet/1.0
[linux-setup]: https://github.com/dotnet/core/blob/main/Documentation/linux-setup.md
[dotnet-blog]: https://devblogs.microsoft.com/dotnet/net-core-may-2019/
