## Implicit metapackage package reference in the .NET Core SDK - Visual Studio 2017 RC3
While working with the previous versions of the .NET Core tooling (both project.json and csproj-based tools), you  probably have become acquainted with the concept of the "metapackage". It is a dependency/package reference (for example, `Microsoft.NETCore.App` or `NetStandard.Library`) that you add to your project in addition to the target framework (for example, `netcoreapp1.0` or `netstandard1.6`).

During the previous months, we've received a lot of feedback that having two data points in the project file is confusing, especially for the upgrade scenario. For example, if you wanted to upgrade from `netcoreapp1.0` to `netcoreapp1.1`, you had to change the target framework **as well** as change the version of the metapackage. This led many users to errors and weird behaviors.

As part of the RC3 release of the [.NET Core SDK](https://github.com/dotnet/sdk), we've moved to the model where the SDK implies a certain version of the `Microsoft.NETCore.App` and `NetStandard.Library` metapackages based on the framework you're targeting. This change makes targeting easier. The intent is for developers to target .NET Core or .NET Standard using just the targeted framework. The package is, in this context, a pure implementation detail that the developer doesn't have to worry about.

### Behavior description
The metapackage included is tied to the target framework. That means that for `netcoreapp1.0` a proper version of the `Microsoft.NETCore.App` metapackage is referenced. Same goes for `netcoreapp1.1` target framework as well as `netstandard1.x` target frameworks.

As far as the rest of the behavior is concerned, the tools will work as expected and most of the gestures will remain the same (for example, `dotnet restore`).

### Migrating a project
If you have an existing reference to the metapackage in your project.json, the migration (both in `dotnet migrate` as well as Visual Studio 2017) will include that reference in your new csproj project. This will cause the tools to issue the following warning when you try to build your project:

> A PackageReference for [metapackage ID] was included in your project. This package is implicitly referenced by the .NET SDK and you do not typically need to reference it from your project. For more information, see https://aka.ms/sdkimplicitrefs.

This warning simply means that you probably want to remove that package reference from your project file. If you do keep it, the specified version of the metapackage will be used.

## Recommendations
With this new feature, you might be wondering when you should specify a version of the metapackage in the project and when not. Here is the overall guidance:

* For new projects, you should use the template and not add an explicit reference to any metapackage.
* For existing projects, you should remove the reference.
* If you need a specific version of the runtime, you should use the `<RuntimeFrameworkVersion>` property in your project (for example, `1.0.4`) instead of referencing the metapackage.
    * This might happen if you are using [self-contained deployments](https://learn.microsoft.com/dotnet/articles/core/preview3/deploying/#self-contained-deployments-scd) and you need a specific patch version of 1.0.0 LTS runtime, for example.
* If you need a specific version of the `NetStandard.Library` metapackage, you can use the `<NetStandardImplicitPackageVersion>` property and set the version you need.
