# .NET Core October 2018 Update - October 09, 2018

.NET Core 1.1.10 is available for download and usage in your environment.

* [Download .NET Core](https://github.com/dotnet/core/blob/main/release-notes/download-archives/1.1.10-download.md)

## Blog Round up

* [.NET Core](https://devblogs.microsoft.com/dotnet/net-core-october-2018-update-net-core-1-0-and-1-1/)

The .NET Core SDK 1.1.11 includes .NET Core 1.1.10 Runtime so downloading the runtime packages separately is not needed when installing the SDK. After installing the .NET Core SDK 1.1.11, running `dotnet --version` will show that you're running version `1.1.11` of the .NET Core tools.

Your feedback is important and appreciated. We've created an issue at [dotnet/core #1987](https://github.com/dotnet/core/issues/1987) for your questions and comments.

## Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Look for the updated images for .NET Core 1.1.10 and .NET Core SDK 1.1.11 and read ["Staying up-to-date with .NET Container Images"](https://devblogs.microsoft.com/dotnet/staying-up-to-date-with-net-container-images/) for details and insights into using the .NET Core images.

## Azure AppServices

* Deployment of .NET Core 1.1.10 to Azure App Services has begun. It will be available in limited regions today and expected worldwide by the end of the week.

## .NET Core Lifecycle News

See [.NET Core Supported OS Lifecycle Policy](https://github.com/dotnet/core/blob/main/os-lifecycle-policy.md) to learn about Windows, macOS and Linux versions that are supported for each .NET Core release.

As .NET Core 2.1 has become LTS (announced in [August 2018 blog post](https://devblogs.microsoft.com/dotnet/net-core-august-2018-update/)), 1.0 and 1.1 have entered their maintenance phase and will only get critical security fixes going forward till their end of support on June 27, 2019.

## Notable Changes in 1.1.10

### Microsoft Security Advisory CVE-2018-8292: .NET Core Information Disclosure Vulnerability

[CVE-2018-8292: .NET Core Security Feature Bypass Vulnerability](https://github.com/dotnet/announcements/issues/88)

#### Executive summary

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET Core. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

Microsoft is aware of a security feature bypass vulnerability that exists when .NET Core when HTTP authentication information is inadvertently exposed in an outbound request that encounters an HTTP redirect. An attacker who successfully exploited this vulnerability could use the information to further compromise the web application.

The update addresses the vulnerability by correcting how .NET Core applications handles HTTP redirects.

### Package and Binary updates

| Package name | Vulnerable versions | Secure versions |
| :--- | :--- | :--- |
System.Net.Http| 2.0.20126.16343, 2.0.20505, 2.0.20710, 4.0.0, 4.1.0, 4.1.1, 4.1.2, 4.3.0, 4.3.1, 4.3.2, 4.3.3 |  4.3.4 or later
