# .NET Core 1.1.13

.NET Core 1.1.13 comprises:

* .NET Core Runtime 1.1.13
* .NET Core SDK 1.1.14

See the [Release Notes](1.1.13.md) for details about what is included in this update.

|           | SDK Installer<sup>1</sup>                                   | SDK Binaries<sup>1</sup>                            | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-dev-win-x86.exe] \| [x64][dotnet-dev-win-x64.exe] | [x86][dotnet-dev-win-x86.zip] \| [x64][dotnet-dev-win-x64.zip] | [x86][dotnet-win-x86.exe] \| [x64][dotnet-win-x64.exe] | [x86][dotnet-win-x86.zip] \| [x64][dotnet-win-x64.zip] | [Hosting Bundle][DotNetCore-WindowsHosting.exe]<sup>1</sup> |
| macOS     | [x64][dotnet-dev-osx-x64.pkg]  | [x64][dotnet-dev-osx-x64.tar.gz]     | [x64][dotnet-osx-x64.pkg] | [x64][dotnet-osx-x64.tar.gz] | - |
| CentOS 7  | - | [x64][dotnet-dev-centos-x64.tar.gz] | - | [x64][dotnet-centos-x64.tar.gz]  | - |
| Debian 9  | - | [x64][dotnet-dev-debian.9-x64.tar.gz] | - | [x64][dotnet-debian.9-x64.tar.gz]  | - |
| Fedora 27   | -                                                | [x64][dotnet-dev-fedora.27-x64.tar.gz] | -                                                        | [x64][dotnet-fedora.27-x64.tar.gz] | - |
| Fedora 28   | -                                                | [x64][dotnet-dev-fedora.28-x64.tar.gz] | -                                                        | [x64][dotnet-fedora.28-x64.tar.gz] | - |
| RHEL 7    | -                                                | [x64][dotnet-dev-rhel-x64.tar.gz]                    | -                                                        | [x64][dotnet-rhel-x64.tar.gz] | - |
| Ubuntu 14.04 | [See installations steps below](#installing-net-core-on-linux)   | [x64][dotnet-dev-ubuntu-x64.tar.gz]       | - | [x64][dotnet-ubuntu-x64.tar.gz] | - |
| Ubuntu 16.04 | [See installations steps below](#installing-net-core-on-linux)   | [x64][dotnet-dev-ubuntu.16.04-x64.tar.gz] | - | [x64][dotnet-ubuntu.16.04-x64.tar.gz] | - |
| Ubuntu 18.04 | [See installations steps below](#installing-net-core-on-linux)   | [x64][dotnet-dev-ubuntu.18.04-x64.tar.gz] | - | [x64][dotnet-ubuntu.18.04-x64.tar.gz] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |
| Symbols   | -                                                | -                                        | [Runtime][coreclr-symbols.zip] \| [Setup][core-setup-symbols.zip] | - | - |

1. Includes the .NET Core and ASP.NET Core runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

## Docker

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://devblogs.microsoft.com/dotnet/staying-up-to-date-with-net-container-images/).

## Installing .NET Core on Linux

Before installing .NET, you will need to register the Microsoft key, register the product repository, and install required dependencies. This only needs to be done once per machine. Refer to [Setting up Linux for .NET Core][linux-setup] for the requirements.

### Develop applications
To develop applications using the .NET Core SDK, run the following command. The .NET Core runtime and ASP.NET Core runtime are included.

In your command prompt, run the following commands:

```bash
# Ubuntu 14.04, 16,04 and 18.04
sudo apt-get install apt-transport-https
sudo apt-get update
sudo apt-get install dotnet-dev-1.1.14
```

### Run applications

If you only need to run existing applications, run the following command.

```bash
# Ubuntu 14.04, 16,04 and 18.04
sudo apt-get install dotnet-sharedframework-microsoft.netcore.app-1.1.13
```

## Installation from a binary archive

Installing from the packages detailed above is recommended or you can install from binary archive, if that better suits your needs. When using binary archives to install, the contents must be extracted to a user location such as `$HOME/dotnet`, a symbolic link created for `dotnet` and a few dependencies installed. Dependency requirements can be seen in the [Linux System Prerequisites](https://github.com/dotnet/core/blob/main/Documentation/linux-prereqs.md) document.

```bash
mkdir -p $HOME/dotnet && tar zxf dotnet.tar.gz -C $HOME/dotnet
export PATH=$PATH:$HOME/dotnet
```
[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/1.1/1.1.13/1.1.13.md

[dotnet-centos-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/19659750-f708-4f35-99e8-f37e83755f95/971d83ccd6f1bb96b7da341bb4e1e2e4/dotnet-centos-x64.1.1.13.tar.gz
[dotnet-debian.9-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/70099599-b7e6-425f-a00c-005590a3a880/2bf8884be051ec30b6225116887d3d8e/dotnet-debian.9-x64.1.1.13.tar.gz
[dotnet-fedora.27-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c48c9f51-4b5a-4a4a-bddd-c7a2549d8e2b/da693d3e832c0ef57018f3410adabaf2/dotnet-fedora.27-x64.1.1.13.tar.gz
[dotnet-fedora.28-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6345bc4b-d87a-4ffc-9749-1ef07808f76f/1fbdbd841d3a2d037a16a98a7c3351c1/dotnet-fedora.28-x64.1.1.13.tar.gz
[dotnet-opensuse.42.3-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/754976aa-181f-4b55-a7a9-8c48f3803687/bc6faf7b6270ae144cae036c03f1a111/dotnet-opensuse.42.3-x64.1.1.13.tar.gz
[dotnet-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/92a60e11-3b6d-4f9a-8376-7b6fab54a012/34ce04e256f2ae841ccd1f8b326b28bc/dotnet-osx-x64.1.1.13.pkg
[dotnet-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/257e0bd3-1086-423e-a187-8f7af6c65c78/8671c374a6c15c3612000fd6f0e42d7d/dotnet-osx-x64.1.1.13.tar.gz
[dotnet-rhel-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fc6ca7db-0ce1-4ce7-a1bf-66bf8a146b74/9db69bb5c92ded72ab2addac9c349aee/dotnet-rhel-x64.1.1.13.tar.gz
[dotnet-ubuntu-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ffe26268-2873-4aef-abf7-839e7d2f91c3/4c912f5be5ca440f707c747eb09c5c22/dotnet-ubuntu-x64.1.1.13.tar.gz
[dotnet-ubuntu.16.04-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/14b65ed5-f508-49c4-b429-1b22085895cf/a6820dabd3a0303135fe11217405bfd1/dotnet-ubuntu.16.04-x64.1.1.13.tar.gz
[dotnet-ubuntu.18.04-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d3bbce9c-a15e-4224-a271-064546459e53/694a1c880d7140c80215acb5dceab3db/dotnet-ubuntu.18.04-x64.1.1.13.tar.gz
[dotnet-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/affdbed0-b12e-4a90-8f77-da5ffae1339d/41abcb0dd99d5ae1024da35025799ca2/dotnet-win-x64.1.1.13.exe
[dotnet-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/1fc10265-86fb-467c-a46c-15ed3587271b/b68e14a46ae8d329ea703e1119af4926/dotnet-win-x64.1.1.13.zip
[dotnet-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/7ac71f41-85ed-4fa7-8f19-bf9fa8b18a17/1608d6b4a416c262877da67426300d05/dotnet-win-x86.1.1.13.exe
[dotnet-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/d7218148-04e6-4b75-92b1-5be0f1ed0e2f/39032c7ac1d45f7b531c83d491507bbf/dotnet-win-x86.1.1.13.zip
[DotNetCore-WindowsHosting.exe]: https://download.visualstudio.microsoft.com/download/pr/85188c51-c71f-442e-ae3a-f46449564959/690b9e12e7da159576f67afd986b873d/dotnetcore.1.0.16_1.1.13-windowshosting.exe
[dotnet-dev-centos-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1c984eff-52f0-455d-9af5-43c920428dd8/adf34b44adb99a42adbff95220f7adee/dotnet-dev-centos-x64.1.1.14.tar.gz
[dotnet-dev-debian.9-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6b5715fa-547a-419b-86bd-d41b834237bd/b80f01c6f7a777230a6f3d7fa5208210/dotnet-dev-debian.9-x64.1.1.14.tar.gz
[dotnet-dev-fedora.27-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0d9c2c12-7a5b-45b8-8423-c2a185fb9a98/2c6b2bf2df974169e8ed2bf8ab854eef/dotnet-dev-fedora.27-x64.1.1.14.tar.gz
[dotnet-dev-fedora.28-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c8639cf5-1431-4524-912d-9e8f5c3f5422/ebaccb07ada0f6f5c2db97b05760efe4/dotnet-dev-fedora.28-x64.1.1.14.tar.gz
[dotnet-dev-opensuse.42.3-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/908eb263-3bcb-49f1-968b-fefa9f05cca7/49730839cd5062b18075ea9ddfc4a7d4/dotnet-dev-opensuse.42.3-x64.1.1.14.tar.gz
[dotnet-dev-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/1b45ebe7-5d64-4a65-9ba8-8485e41e8e24/bda91af921a3bed26dfae873b0ad942b/dotnet-dev-osx-x64.1.1.14.pkg
[dotnet-dev-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/44a0d965-5635-41a6-9125-9fdd43892581/9d526c91b9e6f413157d1b21aef9396d/dotnet-dev-osx-x64.1.1.14.tar.gz
[dotnet-dev-rhel-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/567838b3-55eb-4e76-8df7-81ebeb76d47a/e7e1869fc2431516f1f03fae1e546807/dotnet-dev-rhel-x64.1.1.14.tar.gz
[dotnet-dev-ubuntu-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/75a5d1ff-c9ba-425d-9b94-6f3e7c4da968/39903076672cf8dc7a4da715450b274e/dotnet-dev-ubuntu-x64.1.1.14.tar.gz
[dotnet-dev-ubuntu.16.04-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3aaaa9ad-577b-4127-bee8-3a25d447ac17/9259d8dbfef4dc85d65d0d08261ffacd/dotnet-dev-ubuntu.16.04-x64.1.1.14.tar.gz
[dotnet-dev-ubuntu.18.04-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2a2d1b85-9c49-4229-b47e-54dd58f9b3c2/c215ffdb98373689e4ae9655146ae85e/dotnet-dev-ubuntu.18.04-x64.1.1.14.tar.gz
[dotnet-dev-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/c6b9a396-5e7a-4b91-86f6-f9e8df3bf1dd/6d61addfd6069e404981bede03f8f4f9/dotnet-dev-win-x64.1.1.14.exe
[dotnet-dev-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/c9419fcf-5756-454d-9a45-8b02c4afa2b3/b0f0621717365e7ecc68de9c51f6e69c/dotnet-dev-win-x64.1.1.14.zip
[dotnet-dev-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/df239bf3-1069-47d1-af43-5c25e6d40ffc/72a4f265fc89cd471a65777b9df12f57/dotnet-dev-win-x86.1.1.14.exe
[dotnet-dev-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/c5963b69-fd61-4bd0-b50a-2a1d618d1026/3133130512fe281d04023189ed7da2c9/dotnet-dev-win-x86.1.1.14.zip
[core-setup-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/2ac118c3-8888-49c4-bba3-e3da160fd5f3/d4c01ebc88ce57151f06ac67d0039d5c/core-setup-1.1.13-symbols.zip
[coreclr-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/2dcbc7c0-4539-492e-b2eb-536dae166004/f7be22b57599e0a4b6a90bd5acd83e4a/coreclr-1.1.13-symbols.zip
[corefx-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/dc222d9f-c2d9-4f41-86eb-0fb8b108a12e/6e9061639a322d4a4e650504d115ef19/corefx-1.1.13-symbols.zip

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/1.1.13-runtime-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/1.1.14-sdk-sha.txt

[linux-install]: https://dotnet.microsoft.com/download/dotnet/1.1
[linux-setup]: https://github.com/dotnet/core/blob/main/Documentation/linux-setup.md

[dotnet-blog]: https://devblogs.microsoft.com/dotnet/net-core-may-2019/
