# .NET Core April 2018 Update - April 17, 2018

Microsoft is releasing updates for .NET Core and ASP.NET Core. Issues addressed by this update are summarized in the [fixes](#notable-fixes-and-commits) section below.

.NET Core 1.1.8 and SDK 1.1.9 are available for download and usage in your environment.

* [Getting Started](https://dotnet.microsoft.com/download)
* [Downloads](https://github.com/dotnet/core/blob/main/release-notes/download-archives/1.1.8-download.md)

The .NET Core SDK 1.1.9 includes .NET Core 1.1.8 Runtime so downloading the runtime packages separately is not needed when installing the SDK. After installing the .NET Core SDK 1.1.9, the following command will show that you're running version `1.1.9` of the tools.

`dotnet --version`

Your feedback is important and appreciated. We've created an issue at [dotnet/core #1452](https://github.com/dotnet/core/issues/1452) for your questions and comments.

## Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Look for the 1.1.8 images.

## Azure AppServices

Deployment of this update to Azure AppServices is in process. Because AppServices is a high availability service, the deployment is carefully staged across regions over a period of time. Deployment will begin in the West US 2 and North Central US regions with remaining regions following over a few days.

## Known Issues

### Using Linux package managers to update `dotnet-host.x86_64` breaks .NET Core

**Issue:** Running the package manager `update` command on Linux systems where .NET Core has been previously installed may offer an update for `dotnet-host.x86_64`. If the update is allowed to proceed, .NET Core could be in a broken state as only the dotnet host is updated.

**Resolution:** To install the update, either the Runtime or SDK must be explicitly installed. e.g. `sudo apt-get install dotnet-sharedframework-microsoft.netcore.app-1.1.8`, if you only need the runtime or `sudo apt-get dotnet-dev-1.1.9`, to install both the SDK and Runtime.

We are working to improve our Linux packages to enable correct package manager update behavior. This work is being tracked in the following issues:

* [dotnet/core-setup/issues/3556](https://github.com/dotnet/core-setup/issues/3556)
* [dotnet/cli/issues/8209](https://github.com/dotnet/cli/issues/8209)

## Package and Binary updates

The following packages and binaries are updated by the April 2018 update:

* System.Console
* libcoreclr.so
* libdbgshim.so
* libmscordac.so
* libjit.so
* crossgen
* ilasm
* ildasm

## Notable Fixes and Commits

### CoreFX

[`[4859394]`](https://github.com/dotnet/corefx/pull/27632/commits/4859394b7e7cbae1bc7257926fbe1cdb1769085a) : Adding support for ncurses 6.1 TERM format on System.Console.

### CoreCLR

[`[18e410f]`](https://github.com/dotnet/coreclr/pull/16576/commits/18e410ffaa72a2bc390421478a65c6ddd9e19edd) : Fix detection of YMM regs presence
