# Commits to .NET Core 2.0

This is a somewhat curated list of commits across the entire .NET Core 2.0 development cycle where we have removed uninteresting entries.

* [CLI](#cli)
* [CoreCLR](#coreclr)
* [CoreFX](#corefx)
* [WCF](#wcf)

## CLI

* [`[94cadf3]`](https://github.com/dotnet/cli/commit/94cadf3) Update templates to 1.0.0-beta2-20170803-303
* [`[ffcbbbc]`](https://github.com/dotnet/cli/commit/ffcbbbc) Fix ubuntu and mac no permission error
* [`[6e7a9d9]`](https://github.com/dotnet/cli/commit/6e7a9d9) Updating installation documentation; clarification & typos - deleting superfluous installation doc.
* [`[8ffdcf1]`](https://github.com/dotnet/cli/commit/8ffdcf1) Remove Microsoft from VS 2015 .NET Standard support MSI title
* [`[dbfeadd]`](https://github.com/dotnet/cli/commit/dbfeadd) Updating installation documentation; re: installation scripts.
* [`[260e73f]`](https://github.com/dotnet/cli/commit/260e73f) Update branding for VS 2015 .NET Standard build support
* [`[be54917]`](https://github.com/dotnet/cli/commit/be54917) ingest store without timestamp (#7317)
* [`[3f21ed0]`](https://github.com/dotnet/cli/commit/3f21ed0) Trivial change to start a VSO build run.
* [`[09cfa32]`](https://github.com/dotnet/cli/commit/09cfa32) Absorb update to MSTest version
* [`[20a7ab0]`](https://github.com/dotnet/cli/commit/20a7ab0) Add the missing /
* [`[081f208]`](https://github.com/dotnet/cli/commit/081f208) Add telemetry data points for .NET Core 2.0
* [`[676fe41]`](https://github.com/dotnet/cli/commit/676fe41) Updating the installer to make data collection statement more obvious.
* [`[d61f701]`](https://github.com/dotnet/cli/commit/d61f701) Mis-named badge.
* [`[1fefaa7]`](https://github.com/dotnet/cli/commit/1fefaa7) More adjustments for the build-badge table.
* [`[2af8750]`](https://github.com/dotnet/cli/commit/2af8750) Adjusting the build-badge table.
* [`[f08bdbd]`](https://github.com/dotnet/cli/commit/f08bdbd) Remove template test workaround because it's no longer needed
* [`[5af7786]`](https://github.com/dotnet/cli/commit/5af7786) Update SPA templates to 1.0.417
* [`[9e04dcf]`](https://github.com/dotnet/cli/commit/9e04dcf) Updating the native installers to use a fully qualified path to dotnet.dll and execute it with dotnet exec, so that the first run experience to populate the offline cache will trigger for the SDK being installed, instead of for the latest one in the box.
* [`[9294718]`](https://github.com/dotnet/cli/commit/9294718) Update Roslyn and F# satellites
* [`[0f32699]`](https://github.com/dotnet/cli/commit/0f32699) Removing the 'OpenSUSE13.2' leg from the Jenkins groovy file.
* [`[aa3b1b6]`](https://github.com/dotnet/cli/commit/aa3b1b6) refactor to remove duplication
* [`[c859035]`](https://github.com/dotnet/cli/commit/c859035) Add block thread constructor
* [`[6541a16]`](https://github.com/dotnet/cli/commit/6541a16) Changing the FirstNoticeSentinel used by the internal-reportinstallsuccess command.
* [`[6d0950d]`](https://github.com/dotnet/cli/commit/6d0950d) Removing the OpenSUSE 13.2 build. from the readme.
* [`[d467663]`](https://github.com/dotnet/cli/commit/d467663) Removing the OpenSUSE 13.2 build.
* [`[015af46]`](https://github.com/dotnet/cli/commit/015af46) Fixing a test that fails due to a race condition, because the .dotnet folder might not have been created yet.
* [`[15a318f]`](https://github.com/dotnet/cli/commit/15a318f) Getting the value of 'GitHubPassword' dierctly from a property instead of harvesting from an environmental variable.
* [`[d4a9de3]`](https://github.com/dotnet/cli/commit/d4a9de3) LOC CHECKIN | cli-release/2.0.0 | 20170726
* [`[20f0dac]`](https://github.com/dotnet/cli/commit/20f0dac) Making a change that will cause the first run notice to always show up in the first run of the CLI, even when it is installed by native installers.
* [`[f4d774b]`](https://github.com/dotnet/cli/commit/f4d774b) Switch to picking up the no-timestamp runtime store and package cache
* [`[d3d70af]`](https://github.com/dotnet/cli/commit/d3d70af) Updating the build definition URLs.
* [`[d40d128]`](https://github.com/dotnet/cli/commit/d40d128) Updating NuGet to 4.3.0-rtm-4324
* [`[9ff5da4]`](https://github.com/dotnet/cli/commit/9ff5da4) Update Roslyn to 2.3.2-beta1-61921-05 in 2.0.0
* [`[24eccf1]`](https://github.com/dotnet/cli/commit/24eccf1) Update Roslyn to 2.3.1-beta1-61919-01 in 1.1.0
* [`[81b9379]`](https://github.com/dotnet/cli/commit/81b9379) Insert NuGet Build 4.3.0-rtm-4324 into cli
* [`[2848037]`](https://github.com/dotnet/cli/commit/2848037) Update to Coherence 26424
* [`[1de47f5]`](https://github.com/dotnet/cli/commit/1de47f5) Producing a nupkg for Microsoft.NET.MSBuildResolver. Note that this package contains only the Resolver dll. The hostfxr dll will still have to be acquired separately.
* [`[ab5130d]`](https://github.com/dotnet/cli/commit/ab5130d) Revert "Updating SDK to 2.0.0-preview3-20170721-1"
* [`[08d6a06]`](https://github.com/dotnet/cli/commit/08d6a06) Update to coherence 26412
* [`[6da75e0]`](https://github.com/dotnet/cli/commit/6da75e0) Insert NuGet Build 4.3.0-rtm-4315 into cli
* [`[fcf44af]`](https://github.com/dotnet/cli/commit/fcf44af) Update the SDK to 1.1.0-alpha-20170719-3
* [`[68f1e6a]`](https://github.com/dotnet/cli/commit/68f1e6a) Changing the 'coherent' badge value.
* [`[28c51d2]`](https://github.com/dotnet/cli/commit/28c51d2) Localize first-run "Expanding" and "Decompressing"
* [`[3685317]`](https://github.com/dotnet/cli/commit/3685317) Fix VSLANG handling typo
* [`[85573db]`](https://github.com/dotnet/cli/commit/85573db) Respond to PR feedback: use method names not comments
* [`[8fe8095]`](https://github.com/dotnet/cli/commit/8fe8095) Update to Coherence 26380
* [`[aed35f4]`](https://github.com/dotnet/cli/commit/aed35f4) Update SPA templates to 1.0.0-preview-000409
* [`[a1c423c]`](https://github.com/dotnet/cli/commit/a1c423c) Honor UI language override in test runs
* [`[60e2637]`](https://github.com/dotnet/cli/commit/60e2637) Allow CLI UI language to be overridden by an environment variable
* [`[6e49d10]`](https://github.com/dotnet/cli/commit/6e49d10) Update NuGet to 4.3.0-rtm-4294
* [`[79ff758]`](https://github.com/dotnet/cli/commit/79ff758) Use docker image for opensuse 13.2 from runtime
* [`[7eb8260]`](https://github.com/dotnet/cli/commit/7eb8260) Update the .NET Framework Support package
* [`[689148b]`](https://github.com/dotnet/cli/commit/689148b) update nuget to 4.3.0-rtm-4294
* [`[97f527d]`](https://github.com/dotnet/cli/commit/97f527d) If "ReleaseSuffix" is already set, honor that value.
* [`[762709d]`](https://github.com/dotnet/cli/commit/762709d) updating the template engine version also
* [`[48285ba]`](https://github.com/dotnet/cli/commit/48285ba) Update to Coherence 26318 - templating build 287
* [`[0f0d87a]`](https://github.com/dotnet/cli/commit/0f0d87a) Trivial changes to the readme.md
* [`[633ec51]`](https://github.com/dotnet/cli/commit/633ec51) LOC CHECKIN | cli-release/2.0.0 | 20170714
* [`[f762870]`](https://github.com/dotnet/cli/commit/f762870) use dotnet/templating build 286 (#7155)
* [`[9f4ef46]`](https://github.com/dotnet/cli/commit/9f4ef46) Updated NuGet to 4.3.0-preview4-4273
* [`[5e5cd87]`](https://github.com/dotnet/cli/commit/5e5cd87) Rename to AspNetCoreRuntimePackageTimestamp
* [`[d24c861]`](https://github.com/dotnet/cli/commit/d24c861) Updating NuGet version to 4.3.0-preview4-4273
* [`[21aa774]`](https://github.com/dotnet/cli/commit/21aa774) dotnet-sdk rpm package consume store by dependency
* [`[b9c5e2e]`](https://github.com/dotnet/cli/commit/b9c5e2e) dotnet-sdk DEB package consume store by dependency
* [`[dcce9ce]`](https://github.com/dotnet/cli/commit/dcce9ce) Rename aspnet core store relate prop
* [`[780427a]`](https://github.com/dotnet/cli/commit/780427a) Update SPA templates package to 1.0.0-preview-000403
* [`[4d0e8b5]`](https://github.com/dotnet/cli/commit/4d0e8b5) MSBuildSdkResolver: resolve symlink for 'dotnet' binary
* [`[88c14cb]`](https://github.com/dotnet/cli/commit/88c14cb) Update to Coherence 26239
* [`[9162230]`](https://github.com/dotnet/cli/commit/9162230) sync windows installer change to rpm and deb
* [`[1147b6c]`](https://github.com/dotnet/cli/commit/1147b6c) Sync with windows installer experience for mac
* [`[5378b07]`](https://github.com/dotnet/cli/commit/5378b07) Updating the VSO build IDs.
* [`[ea467db]`](https://github.com/dotnet/cli/commit/ea467db) Update test to pass --no-restore to templates
* [`[5aec446]`](https://github.com/dotnet/cli/commit/5aec446) Update to SetupCrossgen 277 - Coherence 26182
* [`[9a1e39f]`](https://github.com/dotnet/cli/commit/9a1e39f) Fix wrong number of parameters passed to test when doing the merge.
* [`[d9cfe33]`](https://github.com/dotnet/cli/commit/d9cfe33) Linux portable should not try to publish to the Debian repo.
* [`[3b180f4]`](https://github.com/dotnet/cli/commit/3b180f4) Enable VB dotnet new  test cases
* [`[062f248]`](https://github.com/dotnet/cli/commit/062f248) Undo change to include Template Engine loc as it seems to be causing the build to fail while trying to copy the pt-br resource assembly
* [`[e316bd0]`](https://github.com/dotnet/cli/commit/e316bd0) Update to SetupCrossgen 270 - Coherence 26151
* [`[e8cb581]`](https://github.com/dotnet/cli/commit/e8cb581) Fix fedora.23 dockerfile
* [`[8fff365]`](https://github.com/dotnet/cli/commit/8fff365) Updating the ReadMe: "rel-1.0.1" to "rel-1.1.0"
* [`[e408719]`](https://github.com/dotnet/cli/commit/e408719) Updating the Readme.md; adding references to 'coherent' builds.
* [`[191e3e3]`](https://github.com/dotnet/cli/commit/191e3e3) Installer Success Reporting for Windows
* [`[27a2fdc]`](https://github.com/dotnet/cli/commit/27a2fdc) Update SPA templates further to 1.0.0-preview-000358
* [`[c7c7f20]`](https://github.com/dotnet/cli/commit/c7c7f20) Update SPA templates to 1.0.0-preview-000357
* [`[cde3a8b]`](https://github.com/dotnet/cli/commit/cde3a8b) MIT License *NIX Builds.
* [`[2770013]`](https://github.com/dotnet/cli/commit/2770013) Updating the downlevel msi to embed the cab file in the msi itself.
* [`[1256bd0]`](https://github.com/dotnet/cli/commit/1256bd0) Changing the name of the cab file generated by the two msis. Before they were stomping on each other.
* [`[9ba1bc1]`](https://github.com/dotnet/cli/commit/9ba1bc1) Update to SetupCrossgen 256 - Coherence 26096
* [`[087f183]`](https://github.com/dotnet/cli/commit/087f183) The 'Coherent' property needs to be available for 'FinishBuild' and 'PublishArtifacts' targets.
* [`[9c2c9b7]`](https://github.com/dotnet/cli/commit/9c2c9b7) Update Roslyn to 2.3.0-beta4-61830-03
* [`[cb9290e]`](https://github.com/dotnet/cli/commit/cb9290e) Update Roslyn to 2.3.0-beta4-61830-03
* [`[2b15cb4]`](https://github.com/dotnet/cli/commit/2b15cb4) Adding a Minimum VS Defined SDK version to the resolver. If it set to 1.0.4 if the minimum SDK version file is not found.
* [`[a6a7c11]`](https://github.com/dotnet/cli/commit/a6a7c11) Update to SetupCrossgen 249 - Coherence 26071
* [`[c819188]`](https://github.com/dotnet/cli/commit/c819188) Update F# to latest
* [`[557dd8d]`](https://github.com/dotnet/cli/commit/557dd8d) Update to SetupCrossgen 229 - Coherence 26027
* [`[dd137f6]`](https://github.com/dotnet/cli/commit/dd137f6) Revert "Pinning the SDK version to: "2.0.0-preview3-006628""
* [`[bf496a9]`](https://github.com/dotnet/cli/commit/bf496a9) Update bages to aligan with linux buid definition
* [`[0dd17b6]`](https://github.com/dotnet/cli/commit/0dd17b6) Pinning the SDK version to: "2.0.0-preview3-006628"
* [`[207a7e4]`](https://github.com/dotnet/cli/commit/207a7e4) update nuget to 4.3.0-preview4-4258
* [`[f0f66df]`](https://github.com/dotnet/cli/commit/f0f66df) Add indication for first time experience (#7044)
* [`[e9be9fd]`](https://github.com/dotnet/cli/commit/e9be9fd) Installation block does not work
* [`[3ec572f]`](https://github.com/dotnet/cli/commit/3ec572f) Fixing help text for version, info and diagnostics and also removing runtime options that are only available for dotnet exec.
* [`[502c082]`](https://github.com/dotnet/cli/commit/502c082) Publishing a 'coherent' badge.
* [`[3d9bcf4]`](https://github.com/dotnet/cli/commit/3d9bcf4) Copy Paste error
* [`[47ef990]`](https://github.com/dotnet/cli/commit/47ef990) chmod .sh files
* [`[759ac54]`](https://github.com/dotnet/cli/commit/759ac54) update to NuGet 4.3.0-preview4-4258
* [`[4454c4e]`](https://github.com/dotnet/cli/commit/4454c4e) Update the SDK to 1.1.0-alpha-20170630-2
* [`[fa852d3]`](https://github.com/dotnet/cli/commit/fa852d3) Updating the WebSdk version to 2.0.0-rel-20170629-588
* [`[859058b]`](https://github.com/dotnet/cli/commit/859058b) Changing to use File.OpenRead. This is required because when access readonly files, you must pass FileAccess.Read, otherwise, we get a UnauthorizedFileAccess exception.
* [`[0dd4f12]`](https://github.com/dotnet/cli/commit/0dd4f12) Update Template Engine and templates for 1.x
* [`[c920b3c]`](https://github.com/dotnet/cli/commit/c920b3c) Fixing a missing variable in the downlevel installer.
* [`[59bbc57]`](https://github.com/dotnet/cli/commit/59bbc57) Fix test failures in local build due to environment variable filter
* [`[508ad89]`](https://github.com/dotnet/cli/commit/508ad89) Enable VB for dotnet cli 1.1
* [`[d8087d3]`](https://github.com/dotnet/cli/commit/d8087d3) Update engine and templates, update to SetupCrossgen 224 - Coherence 25975
* [`[a396550]`](https://github.com/dotnet/cli/commit/a396550) Adding a installer for Downlevel (Dev14) to install .NET Framework props and targets to enable it to reference netstandard 2.0.
* [`[db7ebc9]`](https://github.com/dotnet/cli/commit/db7ebc9) Add F# to dotnet cli 1..1.0
* [`[29db52a]`](https://github.com/dotnet/cli/commit/29db52a) Update test platform to 15.3.0-preview-20170628-02
* [`[9b77dc5]`](https://github.com/dotnet/cli/commit/9b77dc5) Redirect parser to localized validation messages
* [`[a115df9]`](https://github.com/dotnet/cli/commit/a115df9) Adjust help message test expectations to match new parser
* [`[34d0900]`](https://github.com/dotnet/cli/commit/34d0900) Use latest command line parser
* [`[6fc24fc]`](https://github.com/dotnet/cli/commit/6fc24fc) Updating the runtime to pick up the satellite assembly host fix.
* [`[8dc9ff1]`](https://github.com/dotnet/cli/commit/8dc9ff1) Fixing some merges from release/2.0.0-preview2.
* [`[cd984f5]`](https://github.com/dotnet/cli/commit/cd984f5) Create the Dotnet User Profile folder when running the first experience, if the folder does not exist, if will fail the first run because it will fail to create the first notice sentinel.
* [`[14977b7]`](https://github.com/dotnet/cli/commit/14977b7) Add F# and Roslyn satellites
* [`[162d620]`](https://github.com/dotnet/cli/commit/162d620) Fix tests expecting unlocalized messages from dotnet/sdk
* [`[37f531b]`](https://github.com/dotnet/cli/commit/37f531b) Handling an exception that happens when dotnet run is invoked with a file that is not a valid project file. We catch that exception and re-throw it as a GracefulException.
* [`[6119a29]`](https://github.com/dotnet/cli/commit/6119a29) Reenable UpdateVersionsRepo
* [`[126ec29]`](https://github.com/dotnet/cli/commit/126ec29) Generating a layout folder with the satellite assemblies only which we use to generate a language pack tarball/zip. Initially, I wanted a IncludeOnlyFilter, but couldn't quite get that to work on tar, just passing the filter in the command line didn't work because the shell does not do recursive globbing. So, I opted for the layout folder.
* [`[f4d884a]`](https://github.com/dotnet/cli/commit/f4d884a) Add dummy eula for Windows installer
* [`[ff9b883]`](https://github.com/dotnet/cli/commit/ff9b883) Update Mac installer
* [`[6ef4086]`](https://github.com/dotnet/cli/commit/6ef4086) Update SPA templates version to 1.0.0-preview-000321
* [`[78309e5]`](https://github.com/dotnet/cli/commit/78309e5) Fix dotnet/sdk#1364
* [`[74acc40]`](https://github.com/dotnet/cli/commit/74acc40) Add msbuild satellite assemblies
* [`[6b0cd0e]`](https://github.com/dotnet/cli/commit/6b0cd0e) Make configurer unit tests pass on localized setup
* [`[a569811]`](https://github.com/dotnet/cli/commit/a569811) Add rhel and Debian download link
* [`[44d888d]`](https://github.com/dotnet/cli/commit/44d888d) Exclude satellite assemblies from archive.
* [`[235482b]`](https://github.com/dotnet/cli/commit/235482b) Fixing an issue in the RepoDirectoriesProvider where it assumed that the only directory under SDK was the SDK directories. This is no longer true now that we moved the NuGet fallback folder there.
* [`[b922d7e]`](https://github.com/dotnet/cli/commit/b922d7e) Make dotnet-remove-reference tests pass on localized setup
* [`[273dea9]`](https://github.com/dotnet/cli/commit/273dea9) Make dotnet-list-reference tests pass on localized setup
* [`[9edfb7a]`](https://github.com/dotnet/cli/commit/9edfb7a) Remove failed workaround for Microsoft.Composition warning
* [`[20e0a46]`](https://github.com/dotnet/cli/commit/20e0a46) Make dotnet-add-reference tests pass on localized setup
* [`[a356fca]`](https://github.com/dotnet/cli/commit/a356fca) Simple clean up to the store tests
* [`[0e200ac]`](https://github.com/dotnet/cli/commit/0e200ac) Updating xlf files for the Configurer.
* [`[b03f72e]`](https://github.com/dotnet/cli/commit/b03f72e) Update templates to add missing BrowserLink package
* [`[a357fd7]`](https://github.com/dotnet/cli/commit/a357fd7) Removing NuGetConfig from the first run experience and replacing the sentinel with the FirstUseNoticeSentinel when needed.
* [`[529d7ca]`](https://github.com/dotnet/cli/commit/529d7ca) Moving the expanding fallback folder to the dotnet folder hive. The folder will be expanded at sdk/NuGetFallbackFolder.
* [`[58e18a6]`](https://github.com/dotnet/cli/commit/58e18a6) Fixing CRLF issue.
* [`[47158dc]`](https://github.com/dotnet/cli/commit/47158dc) Add symreader-native myget feed
* [`[e1619b2]`](https://github.com/dotnet/cli/commit/e1619b2) Upgrade DiaSymReader.Native to 1.6.0-beta2-25304
* [`[318ec3a]`](https://github.com/dotnet/cli/commit/318ec3a) Update to SetupCrossgen 215 - Coherence 25794
* [`[69e2db5]`](https://github.com/dotnet/cli/commit/69e2db5) Updating xlf and fixing line ending problems with one file.
* [`[c2539e8]`](https://github.com/dotnet/cli/commit/c2539e8) Update templates to suppress the warning for Microsoft.Composition and AssetTargetFallback
* [`[3348fca]`](https://github.com/dotnet/cli/commit/3348fca) Add rhel and Debian download link
* [`[3de5eb9]`](https://github.com/dotnet/cli/commit/3de5eb9) Fix race in telemetry msbuild arg tests
* [`[34b44b9]`](https://github.com/dotnet/cli/commit/34b44b9) Avoid repeating the first-run message if lzma archive is missing
* [`[7ca900d]`](https://github.com/dotnet/cli/commit/7ca900d) Add explicit dependency for pakcage smoke test
* [`[ae84438]`](https://github.com/dotnet/cli/commit/ae84438) Update templates to remove the package NETStandard.Library.NETFramework
* [`[8ec9cbf]`](https://github.com/dotnet/cli/commit/8ec9cbf) Update F# compiler to latest
* [`[62c3798]`](https://github.com/dotnet/cli/commit/62c3798) Use fluent helper for line-end normalization
* [`[549292e]`](https://github.com/dotnet/cli/commit/549292e) Updating Roslyn to 2.3.0-beta3-61816-04
* [`[2a003ef]`](https://github.com/dotnet/cli/commit/2a003ef) Updating Roslyn to 2.3.0-beta3-61816-04
* [`[6f69b87]`](https://github.com/dotnet/cli/commit/6f69b87) insert new tpv2 which fixes following issue https://github.com/Microsoft/vstest/issues/632 https://github.com/Microsoft/vstest/issues/844 https://github.com/Microsoft/vstest/issues/847 https://github.com/Microsoft/vstest/issues/840 https://github.com/Microsoft/vstest/issues/843
* [`[7059826]`](https://github.com/dotnet/cli/commit/7059826) Update to SetupCrossgen 213 - Coherence 25769
* [`[07ce4a0]`](https://github.com/dotnet/cli/commit/07ce4a0) Windows installer refresh
* [`[c7070e8]`](https://github.com/dotnet/cli/commit/c7070e8) Pinning to the dotnet-install to version '2.0.0-preview2-006470'
* [`[5b17eb3]`](https://github.com/dotnet/cli/commit/5b17eb3) Updating branch/channel information.
* [`[68c71d2]`](https://github.com/dotnet/cli/commit/68c71d2) Stop produce duplicated package for VSTS build definition
* [`[825812d]`](https://github.com/dotnet/cli/commit/825812d) Update SpaTemplateVersion to 1.0.0-preview-000312
* [`[19091ef]`](https://github.com/dotnet/cli/commit/19091ef) Update to SetupCrossgen 210 - Coherence 25756
* [`[4ec13b4]`](https://github.com/dotnet/cli/commit/4ec13b4) Absorb F# and B2C template fixes
* [`[b3675ca]`](https://github.com/dotnet/cli/commit/b3675ca) The links at blob storage will change from "release/2.0.0" to "release/2.0.0-preview2"
* [`[730719f]`](https://github.com/dotnet/cli/commit/730719f) Changing two links from explicit to relative.
* [`[4798895]`](https://github.com/dotnet/cli/commit/4798895) Updating the links in the README; fixing the installation script.
* [`[a65477b]`](https://github.com/dotnet/cli/commit/a65477b) Update to SetupCrossgen 201 - Coherence 25722
* [`[30ef374]`](https://github.com/dotnet/cli/commit/30ef374) Add explicit dependency for pakcage smoke test
* [`[9f0584f]`](https://github.com/dotnet/cli/commit/9f0584f) Updating the branding for 2.0 to preview3
* [`[1a14295]`](https://github.com/dotnet/cli/commit/1a14295) Detect initial bolding for console colors
* [`[26a409c]`](https://github.com/dotnet/cli/commit/26a409c) Updating Roslyn to 2.3.0-beta3-61814-09
* [`[42c65b4]`](https://github.com/dotnet/cli/commit/42c65b4) Turn off UpdateVersionsRepo task in the build until the buildtools gets updated to a new NuGet compatible with the CLI.
* [`[af29c61]`](https://github.com/dotnet/cli/commit/af29c61) We stopped producing distribution specific assets for Linux; removing the check for existence before publishing to 'latest'.
* [`[0a4a0a0]`](https://github.com/dotnet/cli/commit/0a4a0a0) Updating the SDK. Mostly, had to change PackageTargetFallback to AssetTargetFallback.
* [`[8754fa4]`](https://github.com/dotnet/cli/commit/8754fa4) Make dotnet-sln-add.Tests pass on localized setup
* [`[5da3bfd]`](https://github.com/dotnet/cli/commit/5da3bfd) Make dotnet-sln-list.Tests pass on localized setup
* [`[0a4e05b]`](https://github.com/dotnet/cli/commit/0a4e05b) Remove unused string with ID differing only by case
* [`[50c68c4]`](https://github.com/dotnet/cli/commit/50c68c4) Make dotnet-remove-package.Tests pass on localized setup
* [`[2b74bf7]`](https://github.com/dotnet/cli/commit/2b74bf7) Make dotnet-add-package.Tests pass on localized setup
* [`[3e827fc]`](https://github.com/dotnet/cli/commit/3e827fc) Make dotnet-sln-remove.Tests pass on localized setup
* [`[5e5b4de]`](https://github.com/dotnet/cli/commit/5e5b4de) Do no pass down to implicit restore the framework option.
* [`[419562b]`](https://github.com/dotnet/cli/commit/419562b) Make dotnet-help.Tests pass on localized setup
* [`[6e0cfa7]`](https://github.com/dotnet/cli/commit/6e0cfa7) Make dotnet-msbuild.Tests pass on localized setup
* [`[38e5b71]`](https://github.com/dotnet/cli/commit/38e5b71) Make Sln.Internal.Tests pass on localized setup
* [`[c497bf4]`](https://github.com/dotnet/cli/commit/c497bf4) Write a 'latest.coherent.version' file at blob storage so users have a 'coherent' option to SDK installations.
* [`[a01ab8f]`](https://github.com/dotnet/cli/commit/a01ab8f) Fix Debian VSTS/packing failure
* [`[3419a87]`](https://github.com/dotnet/cli/commit/3419a87) Produce RPM packages
* [`[cda914a]`](https://github.com/dotnet/cli/commit/cda914a) Update SpaTemplateVersion to 1.0.0-preview-000297
* [`[b92c63c]`](https://github.com/dotnet/cli/commit/b92c63c) Fixing a conditional.
* [`[5eae1a3]`](https://github.com/dotnet/cli/commit/5eae1a3) Fixing logic; variable name.
* [`[a8a86c7]`](https://github.com/dotnet/cli/commit/a8a86c7) Updating the signing project to reflect the new location of the resolver.
* [`[d1d5743]`](https://github.com/dotnet/cli/commit/d1d5743) Another update to MSBuild. To 15.3.0-preview-000385-01.
* [`[ce8318a]`](https://github.com/dotnet/cli/commit/ce8318a) Another update to msbuild. To 15.3.0-preview-000385-01.
* [`[9e899aa]`](https://github.com/dotnet/cli/commit/9e899aa) Update to SetupCrossgen 183 - Coherence 25615
* [`[79a5799]`](https://github.com/dotnet/cli/commit/79a5799) Don't include .NET Core MS.NET.Build.Extensions tasks for .NET Framework and vice versa
* [`[9659749]`](https://github.com/dotnet/cli/commit/9659749) Update version of SDK and MS.NET.Build.Extensions, adapt to layout change
* [`[00c5872]`](https://github.com/dotnet/cli/commit/00c5872) Updating MSBuild to 15.3.0-preview-000384-01
* [`[aa712fb]`](https://github.com/dotnet/cli/commit/aa712fb) Update MSBuild to 15.3.0-preview-000384-01
* [`[00eadc6]`](https://github.com/dotnet/cli/commit/00eadc6) test pack command
* [`[cd753db]`](https://github.com/dotnet/cli/commit/cd753db) Default channel=LTS Clarify nomenclature from "alternate" to "legacy" Skip construction of legacy URL if it's flawed.
* [`[9cd4e5a]`](https://github.com/dotnet/cli/commit/9cd4e5a) Add Microsoft.NET.Build.Extensions files to package for VS insertion
* [`[56d03c1]`](https://github.com/dotnet/cli/commit/56d03c1) reenable smoke test of F# templates
* [`[bbdbbb3]`](https://github.com/dotnet/cli/commit/bbdbbb3) Update XLF
* [`[858e443]`](https://github.com/dotnet/cli/commit/858e443) Don't try to CrossGen .NET Framework support DLLs
* [`[c579092]`](https://github.com/dotnet/cli/commit/c579092) Update test platform to 15.3.0-preview-20170609-02.
* [`[253a6c5]`](https://github.com/dotnet/cli/commit/253a6c5) Turning off implicit restore when publishing the build project.
* [`[0b19d68]`](https://github.com/dotnet/cli/commit/0b19d68) Updating the vstest.console to use the same runtime that is shipping with the CLI.
* [`[0e0c31a]`](https://github.com/dotnet/cli/commit/0e0c31a) Update to template build 256 to fix Web Auth scenarios
* [`[c19ff8c]`](https://github.com/dotnet/cli/commit/c19ff8c) Add test for consuming .NET Standard 2.0 library from .NET Framework 4.6.1 project
* [`[ac8a464]`](https://github.com/dotnet/cli/commit/ac8a464) Update to SDK and MS.NET.Build.Extensions versions with latest fixes, fix RestoreDependency.proj to work when SdkLayoutDirectory isn't set
* [`[bc24634]`](https://github.com/dotnet/cli/commit/bc24634) Add comment clarifying why net* folders from Microsoft.NET.Build.Extensions package are excluded
* [`[a35d294]`](https://github.com/dotnet/cli/commit/a35d294) Fix for win and mac
* [`[3f606e5]`](https://github.com/dotnet/cli/commit/3f606e5) Update SpaTemplateVersion to 1.0.0-preview-000286
* [`[ea6f18a]`](https://github.com/dotnet/cli/commit/ea6f18a) Update to SetupCrossgen 168 - Coherence 25571
* [`[c896186]`](https://github.com/dotnet/cli/commit/c896186) Changing the parser description for commands that have implicit restore.
* [`[dfc03e7]`](https://github.com/dotnet/cli/commit/dfc03e7) Build localized satellite assemblies
* [`[987d4c0]`](https://github.com/dotnet/cli/commit/987d4c0) Make deb package has linux-x64 content
* [`[3231295]`](https://github.com/dotnet/cli/commit/3231295) Fixing a bug in the restore option where specifying verbosity through /v was not entirely honored.
* [`[dd76fec]`](https://github.com/dotnet/cli/commit/dd76fec) Implicit restore for build, pack, publish, run and test.
* [`[3fcad73]`](https://github.com/dotnet/cli/commit/3fcad73) Updating the 1.1.0 branding to preview1, from rc4, which we inherited from 1.0 when we branched. And updating the SDK version.
* [`[3a61ba1]`](https://github.com/dotnet/cli/commit/3a61ba1) Add Microsoft.NET.Build.Extensions and corresponding DLLs in CLI layout
* [`[14028c9]`](https://github.com/dotnet/cli/commit/14028c9) Update xlf files
* [`[433f5e8]`](https://github.com/dotnet/cli/commit/433f5e8) Add props and targets to text=auto
* [`[1f85f5d]`](https://github.com/dotnet/cli/commit/1f85f5d) Updating the version of the migration library
* [`[8b18eb2]`](https://github.com/dotnet/cli/commit/8b18eb2) MSBuild 15.3.378
* [`[947271f]`](https://github.com/dotnet/cli/commit/947271f) MSBuild 15.3.378
* [`[d1e7e3d]`](https://github.com/dotnet/cli/commit/d1e7e3d) Add force restore option
* [`[ce61070]`](https://github.com/dotnet/cli/commit/ce61070) Updates to install scripts to consume the renaming packages at blob storage. Unpinning the CLI build from a specific version.
* [`[132f70c]`](https://github.com/dotnet/cli/commit/132f70c) Convert LocalizableStrings.cs to resx
* [`[a08ebb9]`](https://github.com/dotnet/cli/commit/a08ebb9) Generate equivalent of resx .Designer.cs in build
* [`[da15436]`](https://github.com/dotnet/cli/commit/da15436) Update to SetupCrossgen 158 - Coherence 25487
* [`[5a1c401]`](https://github.com/dotnet/cli/commit/5a1c401) Moving the pinned version of the SDK  for installation forward from "2.0.0-preview2-006341" to "2.0.0-preview2-006349"
* [`[eb3beef]`](https://github.com/dotnet/cli/commit/eb3beef) Updates to DEB packaging and publishing.
* [`[7e0747e]`](https://github.com/dotnet/cli/commit/7e0747e) Bundle SPA templates package
* [`[78a0b75]`](https://github.com/dotnet/cli/commit/78a0b75) Renaming "dotnet-dev" to "dotnet-sdk" for DEB targets.
* [`[1bf7752]`](https://github.com/dotnet/cli/commit/1bf7752) Renaming "dotnet-dev" to "dotnet-sdk"; therefore: renaming "dotnet-sdk" to "dotnet-sdk -internal". Pinning the install scripts to a unrenamed version so the build will not break on the 'latest'. Note: This is part 1 of a 2 part change
* [`[123b3d2]`](https://github.com/dotnet/cli/commit/123b3d2) Minor template fixes
* [`[808ff7c]`](https://github.com/dotnet/cli/commit/808ff7c) Add restore force option
* [`[093c8ec]`](https://github.com/dotnet/cli/commit/093c8ec) Update to SetupCrossgen 142 - Coherence 25368, add support for timestamped stores for the MSI
* [`[7079f04]`](https://github.com/dotnet/cli/commit/7079f04) Revert "Temporarily change the runtime deb pkg name to unblock the integration."
* [`[c45dd3b]`](https://github.com/dotnet/cli/commit/c45dd3b) Fix dotnet store tests for new error message.
* [`[f6d040a]`](https://github.com/dotnet/cli/commit/f6d040a) Updating the SDK to one built with the same NuGet
* [`[682eb7a]`](https://github.com/dotnet/cli/commit/682eb7a) chmod RunFsc.sh on unix
* [`[ae12864]`](https://github.com/dotnet/cli/commit/ae12864) Updated NuGet version for VS15.3 preview3
* [`[5d85223]`](https://github.com/dotnet/cli/commit/5d85223) Updated NuGet version for VS 15.3 preview3 release
* [`[2cfad18]`](https://github.com/dotnet/cli/commit/2cfad18) This updates the F# compiler to the latest nuget published build.
* [`[641bbd7]`](https://github.com/dotnet/cli/commit/641bbd7) Consolidating the Linux tar.gz's
* [`[17ea7b2]`](https://github.com/dotnet/cli/commit/17ea7b2) The README links at <https://github.com/dotnet/cli/tree/release/2.0.0#installers-and-binaries> need to be updated
* [`[1d1f848]`](https://github.com/dotnet/cli/commit/1d1f848) Remove redundant error handling from project provider, add a better message for deserialization exceptions
* [`[052caa5]`](https://github.com/dotnet/cli/commit/052caa5) Add missing using directive
* [`[68f2d17]`](https://github.com/dotnet/cli/commit/68f2d17) Only catch JsonException in the method that dispatches to the appropriate handlers
* [`[21cb95f]`](https://github.com/dotnet/cli/commit/21cb95f) Shorten names a bit more, make project names match folder names
* [`[e6527bf]`](https://github.com/dotnet/cli/commit/e6527bf) Shorten test project names
* [`[bcb12a6]`](https://github.com/dotnet/cli/commit/bcb12a6) Fix flow from the refactoring
* [`[85870a7]`](https://github.com/dotnet/cli/commit/85870a7) Remove NuGet.Configs, add inversion of the launch profile flag, move profile application logic to its own method
* [`[fc84286]`](https://github.com/dotnet/cli/commit/fc84286) Make errors more specific, add support for setting the launch URL for ASP.NET apps
* [`[7ebbef4]`](https://github.com/dotnet/cli/commit/7ebbef4) Add missed launch settings, fix NuGet.configs, remove unused packages
* [`[265da20]`](https://github.com/dotnet/cli/commit/265da20) Ad tests, fix issue where profile not found isn't an error
* [`[2e100f7]`](https://github.com/dotnet/cli/commit/2e100f7) Initial add of launchSettings.json support
* [`[c28b454]`](https://github.com/dotnet/cli/commit/c28b454) Update to SetupCrossgen 134 - Coherence 25332
* [`[4de4ee2]`](https://github.com/dotnet/cli/commit/4de4ee2) Fix dotnet-deb-tool path.
* [`[4992b63]`](https://github.com/dotnet/cli/commit/4992b63) Update dotnet-deb-tool to 2.0.0-preview2-25331-01
* [`[55953f0]`](https://github.com/dotnet/cli/commit/55953f0) Shorten names a bit more, make project names match folder names
* [`[ddde45f]`](https://github.com/dotnet/cli/commit/ddde45f) Shorten test project names
* [`[20de033]`](https://github.com/dotnet/cli/commit/20de033) Re-enable telemetry for new
* [`[eab48e1]`](https://github.com/dotnet/cli/commit/eab48e1) Unpin stage0.
* [`[87ecdca]`](https://github.com/dotnet/cli/commit/87ecdca) Fix flow from the refactoring
* [`[74bcc19]`](https://github.com/dotnet/cli/commit/74bcc19) Remove NuGet.Configs, add inversion of the launch profile flag, move profile application logic to its own method
* [`[452e642]`](https://github.com/dotnet/cli/commit/452e642) Make errors more specific, add support for setting the launch URL for ASP.NET apps
* [`[59218f4]`](https://github.com/dotnet/cli/commit/59218f4) Add missed launch settings, fix NuGet.configs, remove unused packages
* [`[0ba2e1f]`](https://github.com/dotnet/cli/commit/0ba2e1f) Initial add of launchSettings.json support
* [`[c27b89d]`](https://github.com/dotnet/cli/commit/c27b89d) Changing verbose to verbosity in the help options to match what we actually use.
* [`[a53424c]`](https://github.com/dotnet/cli/commit/a53424c) Fixing an OSx break: "osname: unbound variable"
* [`[b479bd9]`](https://github.com/dotnet/cli/commit/b479bd9) LOC CHECKIN | cli-master | 20170529
* [`[bca5317]`](https://github.com/dotnet/cli/commit/bca5317) Update to SetupCrossgen 128 - Coherence 25179
* [`[b48b7d2]`](https://github.com/dotnet/cli/commit/b48b7d2) .NET Core 2+ Naming and Versioning New file name structure for the runtime and the CLI per: https://github.com/dotnet/designs/issues/2
* [`[7c8bf26]`](https://github.com/dotnet/cli/commit/7c8bf26) Allow resolution of SDKs without minimum msbuild version file
* [`[76cf6d4]`](https://github.com/dotnet/cli/commit/76cf6d4) .NET Core 2+ Naming and Versioning New file name structure for the runtime and the CLI per: <https://github.com/dotnet/designs/issues/2> 1. Branding changes 2. renaming of assets
* [`[8b07dfa]`](https://github.com/dotnet/cli/commit/8b07dfa) Adding the runtime identifier option to dotnet clean.
* [`[9a669ab]`](https://github.com/dotnet/cli/commit/9a669ab) Updating the Sdk to one that includes the error surfacing work.
* [`[db68d45]`](https://github.com/dotnet/cli/commit/db68d45) Pinning the MSBuild Minimum version to 15.3.0.
* [`[1a11756]`](https://github.com/dotnet/cli/commit/1a11756) Addressing code review comments by comparing the versions differently and by changing the name of SDK to .NET Core SDK.
* [`[75eac0c]`](https://github.com/dotnet/cli/commit/75eac0c) Moving version validation to only when a SDK is not overriden. Also adding a validation for the minimum MSBuild version.
* [`[61c217c]`](https://github.com/dotnet/cli/commit/61c217c) Fix shared framework deb package name in response to https://github.com/dotnet/core-setup/pull/2461
* [`[e5c3791]`](https://github.com/dotnet/cli/commit/e5c3791) Update the runtime installer and archive file names in response to https://github.com/dotnet/core-setup/pull/2461
* [`[9083e0b]`](https://github.com/dotnet/cli/commit/9083e0b) Update documenet for enabled apt-get feeds
* [`[86609a2]`](https://github.com/dotnet/cli/commit/86609a2) Updating the links and badges for release/2.0.0
* [`[cfe06a9]`](https://github.com/dotnet/cli/commit/cfe06a9) Update NuGet to 4.3.0-preview1-4081 and SDK to corresponding 1.1.0 based version
* [`[e8b799f]`](https://github.com/dotnet/cli/commit/e8b799f) Fixing the channel for release/2.0.0.
* [`[4b05281]`](https://github.com/dotnet/cli/commit/4b05281) Updating MSBuild to 15.3.0-preview-000246-05 to match VS.
* [`[79a817b]`](https://github.com/dotnet/cli/commit/79a817b) Fixing windows build and addressing code review comments.
* [`[5b3cd63]`](https://github.com/dotnet/cli/commit/5b3cd63) Changing the resolver so that it will search for dotnet in the PATH instead of hard coded program files.
* [`[d3373d9]`](https://github.com/dotnet/cli/commit/d3373d9) Removing unused parameters.; ".StartsWith" method for strings is not always present.
* [`[3539fb2]`](https://github.com/dotnet/cli/commit/3539fb2) Disabling net461 tests for the resolver.
* [`[229518b]`](https://github.com/dotnet/cli/commit/229518b) Default channel in the install scripts;  dotnet-install.ps1 and dotnet-install.sh = “release/1.0.0”
* [`[1ded4f1]`](https://github.com/dotnet/cli/commit/1ded4f1) Forcing 'curl' to return an usable exitcode.
* [`[6222e66]`](https://github.com/dotnet/cli/commit/6222e66) Changes per code review - stronger download failure logic.
* [`[1fe96fd]`](https://github.com/dotnet/cli/commit/1fe96fd) Changes per additional manual testing on ubuntu-x64
* [`[37267bf]`](https://github.com/dotnet/cli/commit/37267bf) Addressing code review comments and trying to fix the windows break.
* [`[82629fa]`](https://github.com/dotnet/cli/commit/82629fa) Updating the websdk version to 2.0.0-rel-20170518-512
* [`[3db157a]`](https://github.com/dotnet/cli/commit/3db157a) First draft changes for install script for the SDK and Runtime.
* [`[a3dbfa4]`](https://github.com/dotnet/cli/commit/a3dbfa4) Revert "Disabling the VB tests in non-windows platforms while MSBuild fixes a bug that we need for cross-plat."
* [`[822b290]`](https://github.com/dotnet/cli/commit/822b290) Updating the global.json creation to use the IFile interface and adding a unit test to cover it.
* [`[f67a72d]`](https://github.com/dotnet/cli/commit/f67a72d) Making restore use a config file so that it does not use fallback folders that may exist in the machine.
* [`[628743a]`](https://github.com/dotnet/cli/commit/628743a) fix command names
* [`[cf9967b]`](https://github.com/dotnet/cli/commit/cf9967b) Add fsc to distribution (#6508)
* [`[a4213f7]`](https://github.com/dotnet/cli/commit/a4213f7) Adding more tests for the min version check in the resolver.
* [`[f61d1ff]`](https://github.com/dotnet/cli/commit/f61d1ff) Adding a check for the min version in the CLI Resolver.
* [`[fd95373]`](https://github.com/dotnet/cli/commit/fd95373) Dropping a global.json when running the first run experience with a version that matches the version of the CLI being used in the command that triggered the first run.
* [`[fca4162]`](https://github.com/dotnet/cli/commit/fca4162) Run xlf converter
* [`[d019c19]`](https://github.com/dotnet/cli/commit/d019c19) Minor text fixes
* [`[4701bcb]`](https://github.com/dotnet/cli/commit/4701bcb) Produce Debian 8 native package (#6604)
* [`[fb1f98b]`](https://github.com/dotnet/cli/commit/fb1f98b) Rollback changes to NuGet feeds for the packages
* [`[15abd51]`](https://github.com/dotnet/cli/commit/15abd51) Rollback update to package versions
* [`[c02df73]`](https://github.com/dotnet/cli/commit/c02df73) Updating the websdk version for 1.0
* [`[88b2e06]`](https://github.com/dotnet/cli/commit/88b2e06) Merged host and SDK help
* [`[b44bce5]`](https://github.com/dotnet/cli/commit/b44bce5) Fix dotnet store options
* [`[357fd3d]`](https://github.com/dotnet/cli/commit/357fd3d) Fixing restore so that it respects the verbosity param. The problem was that ConsoleLoggerParameters was overwritting whatever was coming through the command line.
* [`[cfd72bc]`](https://github.com/dotnet/cli/commit/cfd72bc) Slight improvement to the not runnable message.
* [`[a4c3e69]`](https://github.com/dotnet/cli/commit/a4c3e69) Disabling the VB tests in non-windows platforms while MSBuild fixes a bug that we need for cross-plat.
* [`[9952f2f]`](https://github.com/dotnet/cli/commit/9952f2f) Addressing code review comments by using Streams instead of ing the contents into a string.
* [`[2c24c62]`](https://github.com/dotnet/cli/commit/2c24c62) Trying to fix the opensuse42 test failure, where we tried to invoke a tool that target 1.0.4 where the 1.0 runtime is not available.
* [`[38fc887]`](https://github.com/dotnet/cli/commit/38fc887) Enabling VB in the CLI.
* [`[439c4e6]`](https://github.com/dotnet/cli/commit/439c4e6) Improve Json perf by using JObject.Load.
* [`[f270ecd]`](https://github.com/dotnet/cli/commit/f270ecd) Pinning the stage0 to the last build out of rel/1.0.1 and adding a project to download 1.0 dependencies for test assets.
* [`[f583f21]`](https://github.com/dotnet/cli/commit/f583f21) Fixing the core-setup archive and installer paths for the new Runtime publish layout.
* [`[790ae69]`](https://github.com/dotnet/cli/commit/790ae69) Change the CLI moniker to Microsoft .NET Core 2.0.0 Preview 1 SDK
* [`[3036349]`](https://github.com/dotnet/cli/commit/3036349) Change to Installation completed successfully. Welcome to .NET Core!
* [`[d35f732]`](https://github.com/dotnet/cli/commit/d35f732) Add CROSS check
* [`[8326a60]`](https://github.com/dotnet/cli/commit/8326a60) Move 2 files to use lower ver msbuild
* [`[89ae1ab]`](https://github.com/dotnet/cli/commit/89ae1ab) Read rid from build prop
* [`[80b293d]`](https://github.com/dotnet/cli/commit/80b293d) Correct parsing of 'Format Version' header in sln files
* [`[3aa59d9]`](https://github.com/dotnet/cli/commit/3aa59d9) Remove CoreCLRRid property
* [`[05b0b64]`](https://github.com/dotnet/cli/commit/05b0b64) Pass nologo to MSBuild in 'add package' command
* [`[3a5c75b]`](https://github.com/dotnet/cli/commit/3a5c75b) Replacing the commandline parser in dotnet-dependency-tool-invoker with the CliCommandLineParser.
* [`[737b68b]`](https://github.com/dotnet/cli/commit/737b68b) Fixing the imports for signing.
* [`[74028a5]`](https://github.com/dotnet/cli/commit/74028a5) change to Installation Completed Successfully
* [`[f82fa91]`](https://github.com/dotnet/cli/commit/f82fa91) Fix update-dependencies by slimming it way down.
* [`[0900a13]`](https://github.com/dotnet/cli/commit/0900a13) Add xmlns to the Project node of the signing.dependencies project so that it can be used with the msbuild in vso.
* [`[dd01dbf]`](https://github.com/dotnet/cli/commit/dd01dbf) Bringing down MicroBuild.Core props and targets separately from build_tools.
* [`[477f0f4]`](https://github.com/dotnet/cli/commit/477f0f4) Fixes a few inconsistencies in the display for the dotnet restore -help command.
* [`[23aae1b]`](https://github.com/dotnet/cli/commit/23aae1b) Updating the debian references in the landing page
* [`[497d048]`](https://github.com/dotnet/cli/commit/497d048) Support corporate proxy servers
* [`[359a9d2]`](https://github.com/dotnet/cli/commit/359a9d2) Updating the backwards compatible runtime to 1.1.2.
* [`[af453e3]`](https://github.com/dotnet/cli/commit/af453e3) Updating the SDK to one that carries updated versions of the implicit 1.0 versions.
* [`[eb7b759]`](https://github.com/dotnet/cli/commit/eb7b759) Remove newtonsoft.json dependency from TestAssets/DesktopTestProjects/AutoAddDesktopReferencesDuringMigrate/project.json
* [`[6df51ce]`](https://github.com/dotnet/cli/commit/6df51ce) Fix CLI's reference to core-setup's installer files to use $(RID) instead of a moniker.
* [`[ad76052]`](https://github.com/dotnet/cli/commit/ad76052) Changing the order of the help text for dotnet publish so that it matches the order from dotnet build as well.

## CoreCLR

* [`[2615377]`](https://github.com/dotnet/coreclr/commit/2615377) Fix package download path.
* [`[3623aab]`](https://github.com/dotnet/coreclr/commit/3623aab) Update trusted RHEL build Dockertag to support LTO (#12406)
* [`[9cba5cf]`](https://github.com/dotnet/coreclr/commit/9cba5cf) Align Linux TP benchmarks with Windows TP benchmarks
* [`[de57a23]`](https://github.com/dotnet/coreclr/commit/de57a23) Update BuildTools.
* [`[86d5c8a]`](https://github.com/dotnet/coreclr/commit/86d5c8a) Fix for a bug in fgMorphRecognizeBoxNullable.
* [`[a7e35b7]`](https://github.com/dotnet/coreclr/commit/a7e35b7) Disable some GC tests
* [`[6be620e]`](https://github.com/dotnet/coreclr/commit/6be620e) Update permissions
* [`[5f7f9ba]`](https://github.com/dotnet/coreclr/commit/5f7f9ba) Explicitly download correct version of CoreDisTools package
* [`[039a3da]`](https://github.com/dotnet/coreclr/commit/039a3da) Add Windows/ARM RIDs to test_{dependencies_runtime}.csproj.
* [`[9fe3d4a]`](https://github.com/dotnet/coreclr/commit/9fe3d4a) Fix TestNugetRuntimeId.
* [`[f466f28]`](https://github.com/dotnet/coreclr/commit/f466f28) Adding reason why culture field is introduced
* [`[f028f7d]`](https://github.com/dotnet/coreclr/commit/f028f7d) Fixing CompareInfo AssemblyMode.Full serialization
* [`[17fcac4]`](https://github.com/dotnet/coreclr/commit/17fcac4) Port to release/2.0.0: Fix chained hardware exception handling on Unix (#12344) (#12350)
* [`[8044d4f]`](https://github.com/dotnet/coreclr/commit/8044d4f) LoadFromResolve event handler should return null and not propagate exceptions (#12328)
* [`[11f5937]`](https://github.com/dotnet/coreclr/commit/11f5937) Fix CompareInfo.Version on Windows (#12338)
* [`[55c1d4e]`](https://github.com/dotnet/coreclr/commit/55c1d4e) Release/2.0.0 Desktop <--> Core serialization support (#12300)
* [`[bf0d1b3]`](https://github.com/dotnet/coreclr/commit/bf0d1b3) Add `cmakeargs -DFEATURE_GDBJIT=TRUE -PortableBuild=false` option in Tizen CI build (#12265)
* [`[a0975b8]`](https://github.com/dotnet/coreclr/commit/a0975b8) Update PGO counts and port infrastructure fixes for Preview3 (#12260)
* [`[5f696b0]`](https://github.com/dotnet/coreclr/commit/5f696b0) Fix regression in third party ParameterInfo serialization. (#12038)
* [`[9e96692]`](https://github.com/dotnet/coreclr/commit/9e96692) Fix fast tail call lowering bug.
* [`[59be047]`](https://github.com/dotnet/coreclr/commit/59be047) Fix fast tail call lowering bug.
* [`[b13592b]`](https://github.com/dotnet/coreclr/commit/b13592b) Move release/2.0.0 to preview3
* [`[a474890]`](https://github.com/dotnet/coreclr/commit/a474890) Pull Performance Run Dependencies from Release/2.0.0 (#12180)
* [`[9679ded]`](https://github.com/dotnet/coreclr/commit/9679ded) Fix portable build sos plugin problems. (#12130)
* [`[fdd4e91]`](https://github.com/dotnet/coreclr/commit/fdd4e91) Enable Linux Performance Runs (#12115)
* [`[959daa7]`](https://github.com/dotnet/coreclr/commit/959daa7) Test current packages in CoreCLR official builds
* [`[36e9e6f]`](https://github.com/dotnet/coreclr/commit/36e9e6f) Port commit 128aabe from master: isable tail call stress in GH_11689 if ZapDisable is enabled.
* [`[96f2027]`](https://github.com/dotnet/coreclr/commit/96f2027) Fix optdata restore functionality (port #11935) (#12044)
* [`[33ceeb7]`](https://github.com/dotnet/coreclr/commit/33ceeb7) Ensure that platform is considered for LongPlatformName instead of PackagePlatform (#12042)
* [`[aa9c795]`](https://github.com/dotnet/coreclr/commit/aa9c795) Fix FieldDesc::GetExactFieldType when FieldDesc doesn't exactly represent the owner type (#11975)
* [`[a493839]`](https://github.com/dotnet/coreclr/commit/a493839) Merge serialization changes to 2.0.0 (#12020)
* [`[acf47ad]`](https://github.com/dotnet/coreclr/commit/acf47ad) Disable inheritance of several common file descriptors
* [`[0ad3d0d]`](https://github.com/dotnet/coreclr/commit/0ad3d0d) Use FD_CLOEXEC instead of equivalent 1 in InternalCreatePipe
* [`[7c1c0c5]`](https://github.com/dotnet/coreclr/commit/7c1c0c5) Remove GCX_PREEMP call when allocating a buffer. (#12017)
* [`[8023311]`](https://github.com/dotnet/coreclr/commit/8023311) Port: Default to portable build in dev and official builds (#12019)
* [`[e79937b]`](https://github.com/dotnet/coreclr/commit/e79937b) Update CoreClr, CoreFx to preview2-25330-02, preview2-25331-01, respectively (#11996)
* [`[8de2708]`](https://github.com/dotnet/coreclr/commit/8de2708) Remove Debian.8-Armel from Identity package (#11984)
* [`[d658744]`](https://github.com/dotnet/coreclr/commit/d658744) Update CoreClr, CoreFx to preview2-25330-01, preview2-25330-01, respectively (#11806)
* [`[edb28a1]`](https://github.com/dotnet/coreclr/commit/edb28a1) Move rundown to the same code-site where we do ETW rundown before EEShutdown is marked as started. (#11938)
* [`[016f7cc]`](https://github.com/dotnet/coreclr/commit/016f7cc) Implement Activity ID / Related Activity ID for EventSources Writing to EventPipe (#11916)
* [`[007fa10]`](https://github.com/dotnet/coreclr/commit/007fa10) Indicate if thread time events are in managed or native code. (#11892) (#11898)
* [`[9d7b484]`](https://github.com/dotnet/coreclr/commit/9d7b484) Port e1bc678 from master: Never enregister type-punned regStruct lclVars.
* [`[78fedeb]`](https://github.com/dotnet/coreclr/commit/78fedeb) Fix off-by-one error
* [`[1e9a45e]`](https://github.com/dotnet/coreclr/commit/1e9a45e) Don't hoist IConHandle statics above cctors
* [`[1b2a008]`](https://github.com/dotnet/coreclr/commit/1b2a008) Delete special handling of IJW RVA fields at NGen time (#11818) (#11859)
* [`[6e0d6de]`](https://github.com/dotnet/coreclr/commit/6e0d6de) Return early if EventPipeBuffer is empty. (#11802)
* [`[76e9413]`](https://github.com/dotnet/coreclr/commit/76e9413) Update Unix SafeHandle to throw NotFound correctly (#11757)
* [`[d6c98ff]`](https://github.com/dotnet/coreclr/commit/d6c98ff) Bump the version of the xUnit-Performance package (#11793) (#11813)
* [`[06cf9ff]`](https://github.com/dotnet/coreclr/commit/06cf9ff) The createdump utility needs RPATH (#11688) (#11787)
* [`[f8c67c3]`](https://github.com/dotnet/coreclr/commit/f8c67c3) Fix ReadMemory error reading DSO link_map name. (#11788)
* [`[146ce98]`](https://github.com/dotnet/coreclr/commit/146ce98) Port a018c48 from master: fix legality checks in SetRegOptionalForBinOp.
* [`[da63b11]`](https://github.com/dotnet/coreclr/commit/da63b11) Remove a couple mistaken calls to popd.
* [`[2cbdb89]`](https://github.com/dotnet/coreclr/commit/2cbdb89) Remove explicit passing of ConfigurationGroup=Release from pipebuild
* [`[7b6e591]`](https://github.com/dotnet/coreclr/commit/7b6e591) Clean up 2.0.0 buildtools PR
* [`[e3910d1]`](https://github.com/dotnet/coreclr/commit/e3910d1) Port d520bc1 from master: Do not reverse operands for user-call intrinsics.
* [`[6ae7eb0]`](https://github.com/dotnet/coreclr/commit/6ae7eb0) Update CoreFX, CoreCLR to preview2-25322-03, preview2-25322-01 respectively
* [`[a4e5808]`](https://github.com/dotnet/coreclr/commit/a4e5808) Configure auto-update to use upstream 2.0.0 builds
* [`[945b4de]`](https://github.com/dotnet/coreclr/commit/945b4de) gdbjit symbols exported (#11738)
* [`[cf64892]`](https://github.com/dotnet/coreclr/commit/cf64892) Port #11730 to release/2.0.0 (#11744)
* [`[8ab4fb4]`](https://github.com/dotnet/coreclr/commit/8ab4fb4) set SkipBranchAndVersionOverrides=true for the symbol publish definition
* [`[7a76e9b]`](https://github.com/dotnet/coreclr/commit/7a76e9b) Set StrongName=None for System.Private.CoreLib
* [`[e5d1eba]`](https://github.com/dotnet/coreclr/commit/e5d1eba) Update signing for coreclr repo
* [`[f1975a4]`](https://github.com/dotnet/coreclr/commit/f1975a4) Remove build warnings from 2.0.0 buildtools update (#11731)
* [`[b230709]`](https://github.com/dotnet/coreclr/commit/b230709) Fix performance runs (#11727)
* [`[5316416]`](https://github.com/dotnet/coreclr/commit/5316416) Fix & Re-enable JIT CheckProjects test
* [`[33dffc6]`](https://github.com/dotnet/coreclr/commit/33dffc6) Fix and Re-enable failing Loader tests
* [`[b43745b]`](https://github.com/dotnet/coreclr/commit/b43745b) Set BuildInfo branch to master until we get a new build out of release/2.0.0 branch
* [`[a2656ca]`](https://github.com/dotnet/coreclr/commit/a2656ca) Revert "Make Perf Tests by Comment only"
* [`[960d32e]`](https://github.com/dotnet/coreclr/commit/960d32e) Make Perf Tests by Comment only
* [`[40b87c9]`](https://github.com/dotnet/coreclr/commit/40b87c9) Allow provider deletion to be deferred until after tracing is stopped. (#11651)
* [`[798387e]`](https://github.com/dotnet/coreclr/commit/798387e) Update Coreclr to 2.0.0 buildtools
* [`[fcca93a]`](https://github.com/dotnet/coreclr/commit/fcca93a) Add LinkBench to BenchView
* [`[1c6f494]`](https://github.com/dotnet/coreclr/commit/1c6f494) Updated the JIT/Performance/CodeQuality/Math/Functions single-precision tests to have the correct expected results.
* [`[b8bee85]`](https://github.com/dotnet/coreclr/commit/b8bee85) JIT/Performance/CodeQuality/Math/Functions tests to use the appropriate precision when printing failure messages.
* [`[1b7b588]`](https://github.com/dotnet/coreclr/commit/1b7b588) Updating the JIT/Performance/CodeQuality/Math/Functions tests to target netcoreapp1.1 instead of netstandard1.4
* [`[4807b9f]`](https://github.com/dotnet/coreclr/commit/4807b9f) Adding perf tests for the single precision math functions in System.MathF.
* [`[b96c7b9]`](https://github.com/dotnet/coreclr/commit/b96c7b9) Update Corelib to use SetThreadErrorMode (#11625)
* [`[2fbc698]`](https://github.com/dotnet/coreclr/commit/2fbc698) [x86/Linux] Remove GetFrameFromRedirectedStubStackFrame stub (#11638)
* [`[c3d04c6]`](https://github.com/dotnet/coreclr/commit/c3d04c6) Fix EventSource tests.
* [`[094d830]`](https://github.com/dotnet/coreclr/commit/094d830) Move PopSEHRecords into excepx86.cpp (#11626)
* [`[a44d2a1]`](https://github.com/dotnet/coreclr/commit/a44d2a1) Merge pull request dotnet/corert#3622 from dotnet/nmirror
* [`[f2688a6]`](https://github.com/dotnet/coreclr/commit/f2688a6) Remove an unnecessary binary file
* [`[81baf0a]`](https://github.com/dotnet/coreclr/commit/81baf0a) Use full move for byte registers stores in jumps. (#11570)
* [`[a7fae64]`](https://github.com/dotnet/coreclr/commit/a7fae64) Write EventSource events with metadata to EventPipe (#11577)
* [`[37168ae]`](https://github.com/dotnet/coreclr/commit/37168ae) Fix issue #11574. (#11579)
* [`[272b650]`](https://github.com/dotnet/coreclr/commit/272b650) Update License Info (#11617)
* [`[b8b0b12]`](https://github.com/dotnet/coreclr/commit/b8b0b12) Throw PNSE in ThreadPoolBoundHandle.BindHandle on Unixes (#11613)
* [`[38ae7da]`](https://github.com/dotnet/coreclr/commit/38ae7da) Remove unused code from excepx86.cpp (#11602)
* [`[1cf39a4]`](https://github.com/dotnet/coreclr/commit/1cf39a4) Allow coniguration of sampling rate. (#11595)
* [`[f11f3d7]`](https://github.com/dotnet/coreclr/commit/f11f3d7) EventPipe: Prepend variable length field sizes (#11600)
* [`[c4db3ea]`](https://github.com/dotnet/coreclr/commit/c4db3ea) Fix minidump hang under shipping lldb 3.9.1 (#11591)
* [`[e029e54]`](https://github.com/dotnet/coreclr/commit/e029e54) Disable ETW calls on UNIX.
* [`[e44d854]`](https://github.com/dotnet/coreclr/commit/e44d854) Fix String.IndexOf with empty string input (#11587)
* [`[49dce08]`](https://github.com/dotnet/coreclr/commit/49dce08) Enable Symbolic Rundown for EventPipe (#11582)
* [`[3d97892]`](https://github.com/dotnet/coreclr/commit/3d97892) Revert "Merge changes from TFS"
* [`[27faf8b]`](https://github.com/dotnet/coreclr/commit/27faf8b) Put the serialization marker under its own IFDEF. (#11568)
* [`[c8f77de]`](https://github.com/dotnet/coreclr/commit/c8f77de) Don't allow specification of needStack to EventPipeProvider when creating an event. (#11571)
* [`[97beb51]`](https://github.com/dotnet/coreclr/commit/97beb51) Only call EventActivityIdControl ETW function on Windows. (#11549)
* [`[0c4845c]`](https://github.com/dotnet/coreclr/commit/0c4845c) Delete non-shared version and switch over to shared version.
* [`[7bb7921]`](https://github.com/dotnet/coreclr/commit/7bb7921) Merge pull request dotnet/corert#3601 from dotnet/nmirror
* [`[fca97d0]`](https://github.com/dotnet/coreclr/commit/fca97d0) EventPipe Circular Buffer Support and Ability to Start/Stop Tracing (#11507)
* [`[1c28080]`](https://github.com/dotnet/coreclr/commit/1c28080) Re-morph lclVar nodes after simplifying (ind (addr (lclVar))). (#11531)
* [`[6fb6d4f]`](https://github.com/dotnet/coreclr/commit/6fb6d4f) Update CoreFx to preview2-25311-04 (#11532)
* [`[906f60c]`](https://github.com/dotnet/coreclr/commit/906f60c) Removes unneeded Serializable attributes from enums and delegates. They can be serialized without attributes and this will remove noise from future serialization changes. (#11535)
* [`[e236ed5]`](https://github.com/dotnet/coreclr/commit/e236ed5) [RyuJIT/ARM32] Fix GT_NEG decomposition (#11495)
* [`[4be9be9]`](https://github.com/dotnet/coreclr/commit/4be9be9) [RyuJIT/ARM32] Implement for GT_STORE_OBJ (#10721)
* [`[3ccf725]`](https://github.com/dotnet/coreclr/commit/3ccf725) [RyuJIT/ARM32] Fix assertion in 'unreached' when using emitIns_R_L (#11486)
* [`[06e4145]`](https://github.com/dotnet/coreclr/commit/06e4145) LinkBench: Report reduction as a ratio.
* [`[9004fee]`](https://github.com/dotnet/coreclr/commit/9004fee) Windows Arm64 - Build/Run tests in CI
* [`[0d5d0b4]`](https://github.com/dotnet/coreclr/commit/0d5d0b4) Handle ADC in x86 unwindLazyState (#11527)
* [`[11dea52]`](https://github.com/dotnet/coreclr/commit/11dea52) Add back private BadImageFormatException constructor called by the VM (#11523)
* [`[e52d80f]`](https://github.com/dotnet/coreclr/commit/e52d80f) Fix AssemblyName version (#11505)
* [`[78b23c3]`](https://github.com/dotnet/coreclr/commit/78b23c3) [Arm64] Fixup stlr instrs
* [`[56cca16]`](https://github.com/dotnet/coreclr/commit/56cca16) [Arm64] Add emitter support for ldar/stlr
* [`[1679f65]`](https://github.com/dotnet/coreclr/commit/1679f65) [Arm64] Fix instGen_Set_Reg_To_Imm per review
* [`[4061667]`](https://github.com/dotnet/coreclr/commit/4061667) This change has the following improvements to LinkBench
* [`[a595f4e]`](https://github.com/dotnet/coreclr/commit/a595f4e) Remove eventpipe stuff left from prev commit
* [`[2c4c50a]`](https://github.com/dotnet/coreclr/commit/2c4c50a) add prebuilt file
* [`[095c7fe]`](https://github.com/dotnet/coreclr/commit/095c7fe) Remove EventPipeProfiler due to time constraints
* [`[0dcdd0d]`](https://github.com/dotnet/coreclr/commit/0dcdd0d) Allow multiple SetData calls on AppDomain (#11496)
* [`[3770733]`](https://github.com/dotnet/coreclr/commit/3770733) Re-Factor EventSource to Support Writing to EventPipe (#11435)
* [`[c9f469e]`](https://github.com/dotnet/coreclr/commit/c9f469e) Add version.txt to the coreclr transport package (#11497)
* [`[cdd7d58]`](https://github.com/dotnet/coreclr/commit/cdd7d58) [ARM/Linux] Enable build with FEATURE_DBGIPC=0 (#11254)
* [`[84e39c3]`](https://github.com/dotnet/coreclr/commit/84e39c3) [Arm64] Revise GTF_IND_VOLATILE per comments
* [`[b124740]`](https://github.com/dotnet/coreclr/commit/b124740) Fix clang version detection in src/pal/tools/gen-buildsys-clang.sh (#11398)
* [`[c78891a]`](https://github.com/dotnet/coreclr/commit/c78891a) Update the License to MIT for coreclr repo (#11482)
* [`[1746828]`](https://github.com/dotnet/coreclr/commit/1746828) Allow users to enable automatic NI bind fallback via command-line (#11485)
* [`[1413d46]`](https://github.com/dotnet/coreclr/commit/1413d46) Update CoreFx to preview2-25310-01 (#11483)
* [`[c50b6ae]`](https://github.com/dotnet/coreclr/commit/c50b6ae) Fix lldbplugin to properly build with lldb 3.9. (#11480)
* [`[b1e4097]`](https://github.com/dotnet/coreclr/commit/b1e4097) [x86, R2R] Exclude DevDiv_278523 because it fails in R2R
* [`[cda2141]`](https://github.com/dotnet/coreclr/commit/cda2141) delete tabs from the exclude list
* [`[673f56a]`](https://github.com/dotnet/coreclr/commit/673f56a) Stop hoisting statics above cctors
* [`[5d16da3]`](https://github.com/dotnet/coreclr/commit/5d16da3) [Arm64] Support GTF_IND_VOLATILE
* [`[033b592]`](https://github.com/dotnet/coreclr/commit/033b592) Return DevDiv_255294 test to the exclude list for x86
* [`[c8a3780]`](https://github.com/dotnet/coreclr/commit/c8a3780) Fix static analysis issues (#11466)
* [`[1ce30c0]`](https://github.com/dotnet/coreclr/commit/1ce30c0) Stop loading crossgen-ed binaries at preferred address on Unix (#11467)
* [`[4f6fe87]`](https://github.com/dotnet/coreclr/commit/4f6fe87) Fix issue #11446. (#11455)
* [`[8e73ec9]`](https://github.com/dotnet/coreclr/commit/8e73ec9) [Arm64] Use movn in instGen_Set_Reg_To_Imm
* [`[3437a82]`](https://github.com/dotnet/coreclr/commit/3437a82) Enable build on old Linux (#11414)
* [`[02b8f50]`](https://github.com/dotnet/coreclr/commit/02b8f50) Add an event pipe that pipes to the profiler apis
* [`[eac27ca]`](https://github.com/dotnet/coreclr/commit/eac27ca) Avoid throwing in the globalization managed callbacks (#11454)
* [`[0c4a490]`](https://github.com/dotnet/coreclr/commit/0c4a490) FailFast stderr logging with stacktrace (#11397)
* [`[3440877]`](https://github.com/dotnet/coreclr/commit/3440877) [Arm64] For arm64 jobs build pri1 tests by default
* [`[e623a2b]`](https://github.com/dotnet/coreclr/commit/e623a2b) Add assembly level attribute on CoreLib (#11449)
* [`[9ad3212]`](https://github.com/dotnet/coreclr/commit/9ad3212) Launch perf process with high priority
* [`[94eb128]`](https://github.com/dotnet/coreclr/commit/94eb128) Add the "createdump" to the linux runtime package. (#11441)
* [`[673242e]`](https://github.com/dotnet/coreclr/commit/673242e) Fix issue #11447.
* [`[8514226]`](https://github.com/dotnet/coreclr/commit/8514226) Make CoreCLR work properly under PaX's RANDMMAP (#11382)
* [`[93bdf19]`](https://github.com/dotnet/coreclr/commit/93bdf19) Update doc with review feedback.
* [`[adfd185]`](https://github.com/dotnet/coreclr/commit/adfd185) Add define for FEATURE_SIMD
* [`[bc1bc9c]`](https://github.com/dotnet/coreclr/commit/bc1bc9c) Use profile information to differentiate files
* [`[637c9db]`](https://github.com/dotnet/coreclr/commit/637c9db) [Arm64] Revise per comments
* [`[16ca06c]`](https://github.com/dotnet/coreclr/commit/16ca06c) [Arm64] Add emitIns_R_R_S_S
* [`[494f00c]`](https://github.com/dotnet/coreclr/commit/494f00c) [Arm64] Add emitIns_S_S_R_R
* [`[4a9af73]`](https://github.com/dotnet/coreclr/commit/4a9af73) Minor typo corrected (#11444)
* [`[2f15c84]`](https://github.com/dotnet/coreclr/commit/2f15c84) Change xcopy to copy
* [`[fa0ee73]`](https://github.com/dotnet/coreclr/commit/fa0ee73) Fix copy error in perf script
* [`[487cb23]`](https://github.com/dotnet/coreclr/commit/487cb23) Make Debugger class static (#11439)
* [`[72ac464]`](https://github.com/dotnet/coreclr/commit/72ac464) Log Events to EventPipe on Linux (#11433)
* [`[3ababc2]`](https://github.com/dotnet/coreclr/commit/3ababc2) Delete dead code (#11431)
* [`[278837e]`](https://github.com/dotnet/coreclr/commit/278837e) Delete moved file
* [`[c853b03]`](https://github.com/dotnet/coreclr/commit/c853b03) Delete moved files and fix build breaks
* [`[7babb04]`](https://github.com/dotnet/coreclr/commit/7babb04) Move more files to shared CoreLib partition (#11429)
* [`[bb70a71]`](https://github.com/dotnet/coreclr/commit/bb70a71) Remove ArrayList (#11426)
* [`[1e14842]`](https://github.com/dotnet/coreclr/commit/1e14842) Fix typo in perf.groovy
* [`[060dc1d]`](https://github.com/dotnet/coreclr/commit/060dc1d) [Arm64/Unix] Enable FEATURE_USE_SOFTWARE_WRITE_WATCH_FOR_GC_HEAP (#11375)
* [`[30a0932]`](https://github.com/dotnet/coreclr/commit/30a0932) Add a GC Reliability Framework job to the CI (#11280)

## CoreFX

* [`[6b2afa9]`](https://github.com/dotnet/corefx/commit/6b2afa9) SQLString adding missing typeforward to correctly serializable blobs between netfx and core
* [`[d1e38e7]`](https://github.com/dotnet/corefx/commit/d1e38e7) [WIP] BinaryFormatter - Reenable sanity check (#21507)
* [`[a9c422b]`](https://github.com/dotnet/corefx/commit/a9c422b) Disable for nano (#21529)
* [`[b3bc3e8]`](https://github.com/dotnet/corefx/commit/b3bc3e8) Fix temp keychain lifetime with macOS CopyWithPrivateKey
* [`[55b8e3b]`](https://github.com/dotnet/corefx/commit/55b8e3b) Update CoreFx, Standard to preview3-25423-02, preview3-25423-01, respectively (#21453)
* [`[14413e7]`](https://github.com/dotnet/corefx/commit/14413e7) Adding test to check if OnDeserialized doesn't throw if serialization… (#21357
* [`[4362253]`](https://github.com/dotnet/corefx/commit/4362253) Allow Json.NET deserialization of ObservableCollection (#21322)
* [`[3375d53]`](https://github.com/dotnet/corefx/commit/3375d53) Fixing SizeF, CookieContainer, CookieCollection serialization between Core <--> Desktop and adding full binary mode tests (#21223)
* [`[026dbca]`](https://github.com/dotnet/corefx/commit/026dbca) Return Linux NetworkInterface speed as bits per second, not megabits.
* [`[c6c7908]`](https://github.com/dotnet/corefx/commit/c6c7908) Changing binplace configurations so the default only contains TargetGroup and OSGroup
* [`[97c62af]`](https://github.com/dotnet/corefx/commit/97c62af) Make VerifyWithRevocation skip if the Online chain can't build (#21269)
* [`[66c71fb]`](https://github.com/dotnet/corefx/commit/66c71fb) Disabling binary serialization fuzzying test (#21185) (#21189)
* [`[a258079]`](https://github.com/dotnet/corefx/commit/a258079) Merge in clr
* [`[71f1263]`](https://github.com/dotnet/corefx/commit/71f1263) Add more serialization test cases and fix SqlGuid (#21137)
* [`[c22a81a]`](https://github.com/dotnet/corefx/commit/c22a81a) Enabling CookieContainer serialization by exposing PathList type and adding a type forward
* [`[6e8c70d]`](https://github.com/dotnet/corefx/commit/6e8c70d) Addressing previous serialization PR feedback from danmosemsft (#20807)
* [`[cd70c2e]`](https://github.com/dotnet/corefx/commit/cd70c2e) Fixing mscorlib shim generation with older build tools
* [`[4707b8d]`](https://github.com/dotnet/corefx/commit/4707b8d) Delete ThreadAbortException from CoreFX (#20659)
* [`[35a450c]`](https://github.com/dotnet/corefx/commit/35a450c) Reverting dependencies.props changes
* [`[297ee64]`](https://github.com/dotnet/corefx/commit/297ee64) Reenabling disabled tests
* [`[bf2f35f]`](https://github.com/dotnet/corefx/commit/bf2f35f) Fix PlatformDetection.GetFrameworkVersion()
* [`[81d852c]`](https://github.com/dotnet/corefx/commit/81d852c) Cross Serialization Cleanup (#21067)
* [`[a405d4d]`](https://github.com/dotnet/corefx/commit/a405d4d) Cross framework serialization finish up (#20870)
* [`[1fea2b2]`](https://github.com/dotnet/corefx/commit/1fea2b2) Remove [Serializable] from VB types (#21046)
* [`[69625e3]`](https://github.com/dotnet/corefx/commit/69625e3) Building manual System facade for serialization support (#20988)
* [`[af64b49]`](https://github.com/dotnet/corefx/commit/af64b49) Using mscorlib shim as default resolving assembly for BinaryFormatter serialization instead of System.Private.Corelib (#20879)
* [`[4c4a7b4]`](https://github.com/dotnet/corefx/commit/4c4a7b4) Bring SerializationFieldInfo back to BinaryFormatter in corefx (#20938)
* [`[4531792]`](https://github.com/dotnet/corefx/commit/4531792) More AOT serialization fixes (#20800)
* [`[4a0f511]`](https://github.com/dotnet/corefx/commit/4a0f511) Manually build mscorlib shim to allow for internal type forwards & Adding TypeForwardFrom to serialiazable types (#20697)
* [`[acb4fbd]`](https://github.com/dotnet/corefx/commit/acb4fbd) ObservableCollection: Avoid SimpleMonitor allocation (#20643)
* [`[8611674]`](https://github.com/dotnet/corefx/commit/8611674) [2.0 Port] Fixing NativeOverlapped lifetime issue (#21100)
* [`[bebdad3]`](https://github.com/dotnet/corefx/commit/bebdad3) Add `-PortableBuild=false` option in Tizen CI build
* [`[e1c437b]`](https://github.com/dotnet/corefx/commit/e1c437b) Port commit 2b13699 to enable new distros for Core 2.0 (#21009)
* [`[c0448a8]`](https://github.com/dotnet/corefx/commit/c0448a8) Check actual set time for test (#20820)
* [`[8dbc04c]`](https://github.com/dotnet/corefx/commit/8dbc04c) Fill out FileSystemInfo state when enumerating (#20716)
* [`[dbd63bb]`](https://github.com/dotnet/corefx/commit/dbd63bb) Handle escaping in Unix file enumeration (#20784)
* [`[3a1531d]`](https://github.com/dotnet/corefx/commit/3a1531d) Move to preview3 prerelease label (#20950)
* [`[3801271]`](https://github.com/dotnet/corefx/commit/3801271) Use correct charset when unpacking port names (#20668)
* [`[c5590f4]`](https://github.com/dotnet/corefx/commit/c5590f4) Enable Linux Performance Runs (#20756)
* [`[4bd63d9]`](https://github.com/dotnet/corefx/commit/4bd63d9) Disable large memory Span::Clear test on Linux (for 2.0) (#20736)
* [`[60052f4]`](https://github.com/dotnet/corefx/commit/60052f4) 2 new exceptions
* [`[7783f2f]`](https://github.com/dotnet/corefx/commit/7783f2f) Mark Activity and it's properties as Serializable
* [`[0d1a7e8]`](https://github.com/dotnet/corefx/commit/0d1a7e8) Fix debian9 failure (#20218)
* [`[4dc0237]`](https://github.com/dotnet/corefx/commit/4dc0237) update CoreCLR dependency
* [`[857d94b]`](https://github.com/dotnet/corefx/commit/857d94b) Reenable TimeZoneINfo test (#20581)
* [`[813718e]`](https://github.com/dotnet/corefx/commit/813718e) remove random newline in the middle baseline blob
* [`[62acd6c]`](https://github.com/dotnet/corefx/commit/62acd6c) normalize line endings in xslt tests (#20517)
* [`[53968d8]`](https://github.com/dotnet/corefx/commit/53968d8) Merge pull request #20247 from ViktorHofer/SerializationTests
* [`[131c702]`](https://github.com/dotnet/corefx/commit/131c702) Merge pull request #20501 from ViktorHofer/LazySerializationTests
* [`[9d286cc]`](https://github.com/dotnet/corefx/commit/9d286cc) Throw PlatformNotSupportedExceptions from IDeserializationCallback on types that are no longer serializable. (#20384)
* [`[e35726d]`](https://github.com/dotnet/corefx/commit/e35726d) More serialization test fixes (#20377)
* [`[b6f9533]`](https://github.com/dotnet/corefx/commit/b6f9533) Numerics serialization (#20222)
* [`[89ec132]`](https://github.com/dotnet/corefx/commit/89ec132) ISerializable cleanup (#20220)
* [`[55896e9]`](https://github.com/dotnet/corefx/commit/55896e9) Prep tests for CoreCLR/CoreRT [Serializable] cleanup (#20035)
* [`[42c2ca3]`](https://github.com/dotnet/corefx/commit/42c2ca3) Set PFX temporary keychains to have a lock policy of never.
* [`[dfabe12]`](https://github.com/dotnet/corefx/commit/dfabe12) Port changes from master to kill msbuild.exe, dotnet.exe, and vbcscompiler.exe if running when trying to delete existing repo directory.
* [`[465ad7b]`](https://github.com/dotnet/corefx/commit/465ad7b) Fix inheritance of console dup'd file descriptors
* [`[19f09c7]`](https://github.com/dotnet/corefx/commit/19f09c7) Fix HttpClient on Unix handling of 0-len content with chunked upload
* [`[d2b832e]`](https://github.com/dotnet/corefx/commit/d2b832e) Update to newer host package that supports portable RIDs
* [`[9d6e6fc]`](https://github.com/dotnet/corefx/commit/9d6e6fc) Add platform reporting parameter to OSX Debug definition
* [`[6b71732]`](https://github.com/dotnet/corefx/commit/6b71732) Fix linux official build definitions
* [`[91ea076]`](https://github.com/dotnet/corefx/commit/91ea076) Fix quoting around TestProduct option
* [`[d02b080]`](https://github.com/dotnet/corefx/commit/d02b080) Make portable builds the default and remove non-portable official builds
* [`[f6861d1]`](https://github.com/dotnet/corefx/commit/f6861d1) Use RuntimeOS instead of OSGroup for defaulting PackageRID
* [`[8b1a14d]`](https://github.com/dotnet/corefx/commit/8b1a14d) Remove non-portable RIDs from netcoreapp package
* [`[f411f3c]`](https://github.com/dotnet/corefx/commit/f411f3c) fix handling of client Close before writing entire Content-Length
* [`[696b8d5]`](https://github.com/dotnet/corefx/commit/696b8d5) Fix incorrect length in File.WriteAllTextAsync (#20460)
* [`[8851f84]`](https://github.com/dotnet/corefx/commit/8851f84) Fix some more netfx compat test failures and add some tests
* [`[ee20d94]`](https://github.com/dotnet/corefx/commit/ee20d94) Fix argument validation for WebHeaderCollection.Add
* [`[bd334c7]`](https://github.com/dotnet/corefx/commit/bd334c7) Add ForceManagedImplementation switch to .csproj
* [`[7c0ac25]`](https://github.com/dotnet/corefx/commit/7c0ac25) Fix Windows HttpListener bugs, and add/enable more tests
* [`[f07757a]`](https://github.com/dotnet/corefx/commit/f07757a) Fixing initialization issue for IOCP handle. (#20374)
* [`[17ce587]`](https://github.com/dotnet/corefx/commit/17ce587) Stop disposing previous managed HttpListener connection on accept failure
* [`[153de68]`](https://github.com/dotnet/corefx/commit/153de68) fix HttpListener chunked encoding handling
* [`[d0c1b6a]`](https://github.com/dotnet/corefx/commit/d0c1b6a) Add tests for a HttpListenerRequest.ContentLength64 porting bug
* [`[8bcf1ce]`](https://github.com/dotnet/corefx/commit/8bcf1ce) Fix some of System.Net.HttpListener test failures on ILC
* [`[d3486ec]`](https://github.com/dotnet/corefx/commit/d3486ec) Add one more ActiveIssue for failing HttpListener test
* [`[59e8ce3]`](https://github.com/dotnet/corefx/commit/59e8ce3) Fix cookie handling in managed implementation
* [`[fdfb105]`](https://github.com/dotnet/corefx/commit/fdfb105) Fix Basic auth validation in managed HttpListener
* [`[04f3fdf]`](https://github.com/dotnet/corefx/commit/04f3fdf) Fix handling of protocol versions between 1.1 and 2.0
* [`[fa0e4d0]`](https://github.com/dotnet/corefx/commit/fa0e4d0) Fix handling of large Content-Lengths in managed HttpListener
* [`[5f90b2d]`](https://github.com/dotnet/corefx/commit/5f90b2d) Fix hangs when auth scheme is NTLM/Negotiate
* [`[7c98399]`](https://github.com/dotnet/corefx/commit/7c98399) Fix UnsafeConnectionNtlmAuthentication on Unix
* [`[d5189f9]`](https://github.com/dotnet/corefx/commit/d5189f9) Fix RequestTraceIdentifier in managed implementation
* [`[5bee3c9]`](https://github.com/dotnet/corefx/commit/5bee3c9) Fix TransportContext.GetChanelBinding in managed implementation
* [`[d3fd2bb]`](https://github.com/dotnet/corefx/commit/d3fd2bb) Fix exception handling with AuthenticationSchemeDelegateSelector
* [`[bd02f0e]`](https://github.com/dotnet/corefx/commit/bd02f0e) Fix handling of invalid requests and GetContext
* [`[de52373]`](https://github.com/dotnet/corefx/commit/de52373) Fix "not found" handling
* [`[7b5c31e]`](https://github.com/dotnet/corefx/commit/7b5c31e) Fix handling of RedirectLocation header
* [`[2215ccb]`](https://github.com/dotnet/corefx/commit/2215ccb) Fix handling of HttpListenerResponse.ProtocolVersion
* [`[4d487b4]`](https://github.com/dotnet/corefx/commit/4d487b4) Fix Helpers.IsNotWindowsImplementation
* [`[c53c6c5]`](https://github.com/dotnet/corefx/commit/c53c6c5) Add tests for invalid requests sent from the client to the http listneer (#20233)
* [`[94b0a33]`](https://github.com/dotnet/corefx/commit/94b0a33) Update tests for recent fixes to WebHeaderCollection
* [`[adbdaf4]`](https://github.com/dotnet/corefx/commit/adbdaf4) Fix product bug causing Httplistener test failures
* [`[209b441]`](https://github.com/dotnet/corefx/commit/209b441) Add some HttpListener authentication tests (#20102)
* [`[28f8b9b]`](https://github.com/dotnet/corefx/commit/28f8b9b) Fix ContentLength64, SendChunk, and KeepAlive in managed HttpListener
* [`[d372670]`](https://github.com/dotnet/corefx/commit/d372670) Fix some HttpListener tests for netfx
* [`[bfc485e]`](https://github.com/dotnet/corefx/commit/bfc485e) Fix Windows porting bugs and baseline managed test failures
* [`[bcf59ad]`](https://github.com/dotnet/corefx/commit/bcf59ad) Add HttpListenerResponse cookies and headers tests
* [`[ae27d22]`](https://github.com/dotnet/corefx/commit/ae27d22) Use WebHeaderEncoding to encode status description text
* [`[25d27b6]`](https://github.com/dotnet/corefx/commit/25d27b6) Fix disposal handling in HttpListenerResponse.Close
* [`[b003c58]`](https://github.com/dotnet/corefx/commit/b003c58) Consolidate OutputStream implementation
* [`[a3db731]`](https://github.com/dotnet/corefx/commit/a3db731) Fix managed RedirectLocation implementation
* [`[9f31883]`](https://github.com/dotnet/corefx/commit/9f31883) Fix managed StatusDescription implementation
* [`[68f26a4]`](https://github.com/dotnet/corefx/commit/68f26a4) Fix managed implementation of KeepAlive
* [`[e3aa9ab]`](https://github.com/dotnet/corefx/commit/e3aa9ab) Fix managed implementation handling of ContentType
* [`[56ac38a]`](https://github.com/dotnet/corefx/commit/56ac38a) Fix broken GetClientResponse test helper
* [`[50af5c2]`](https://github.com/dotnet/corefx/commit/50af5c2) Add HttpListenerResponse tests (#19880)
* [`[98c66a5]`](https://github.com/dotnet/corefx/commit/98c66a5) Validate Sec-WebSocket-Key header in managed HttpListener
* [`[1760734]`](https://github.com/dotnet/corefx/commit/1760734) Fix HttpListener Read_LargeLength tests
* [`[4f81ce7]`](https://github.com/dotnet/corefx/commit/4f81ce7) Validate IAsyncResult used with managed HttpListener BeginRead/Write
* [`[8e0a589]`](https://github.com/dotnet/corefx/commit/8e0a589) Validate IAsyncResult passed to managed HttpListener.EndGetContext
* [`[e3362a1]`](https://github.com/dotnet/corefx/commit/e3362a1) Fix '+' host name handling in HttpListener on Unix
* [`[a10473f]`](https://github.com/dotnet/corefx/commit/a10473f) Fix HttpListenerFactory Dispose after failure
* [`[a4fe5cc]`](https://github.com/dotnet/corefx/commit/a4fe5cc) Re-enable failing httplistener tests on osx. (#19955)
* [`[2a7c685]`](https://github.com/dotnet/corefx/commit/2a7c685) Cleanup tests by allowing HttpListenerFactory to have a custom (empty) path
* [`[6087666]`](https://github.com/dotnet/corefx/commit/6087666) Fix no exception thrown listening to an already registered prefix
* [`[9a20b64]`](https://github.com/dotnet/corefx/commit/9a20b64) Revert fix no exception thrown listening to an already registered host/port …
* [`[2231575]`](https://github.com/dotnet/corefx/commit/2231575) Fix NetEventSource IDs
* [`[8c48c01]`](https://github.com/dotnet/corefx/commit/8c48c01) AppCompat: converting two HWR properties to no-op.
* [`[e9e309c]`](https://github.com/dotnet/corefx/commit/e9e309c) Added cleanup for cached async state in SqlCommand's EndExecute methods before they throw exceptions. Without this cleanup, a subsequent command execution will fail since it will appear as though other async commands are still pending. (#20339) (#20373)
* [`[6063a136]`](https://github.com/dotnet/corefx/commit/6063a136) Remove NuGet metadata
* [`[b56d2e5]`](https://github.com/dotnet/corefx/commit/b56d2e5) Fix missing quote in trimming item
* [`[8ff2c57]`](https://github.com/dotnet/corefx/commit/8ff2c57) Finally kill (#20319)
* [`[d0dbe31]`](https://github.com/dotnet/corefx/commit/d0dbe31) Fix for a null reference when starting up an EventSource.
* [`[f0f1598]`](https://github.com/dotnet/corefx/commit/f0f1598) Support Two-Key Triple DES (#20275) (#20320)
* [`[4c89f6c]`](https://github.com/dotnet/corefx/commit/4c89f6c) Add ShellEx support for Windows & fix issues (#20216) (#20273)
* [`[43d0990]`](https://github.com/dotnet/corefx/commit/43d0990) Mark NETStandard.Library.NETFramework as trimmable
* [`[25c3843]`](https://github.com/dotnet/corefx/commit/25c3843) Fix Parallel.For* to consistently throw exception upon cancellation (#20259) (#20266)
* [`[843e4e2]`](https://github.com/dotnet/corefx/commit/843e4e2) Update VS configurations and ProjectGUID's for 4 new ref projects.
* [`[de732d3]`](https://github.com/dotnet/corefx/commit/de732d3) Fix System.Reflection.Metadata.Tests configuration.
* [`[19ff8cf]`](https://github.com/dotnet/corefx/commit/19ff8cf) Fix Immutable test configuration.
* [`[19ea17a]`](https://github.com/dotnet/corefx/commit/19ea17a) Add a "GenerateReferenceAssembly" target and generate four assemblies.
* [`[7d69f67]`](https://github.com/dotnet/corefx/commit/7d69f67) Increasing mutex time, ensuring the mutex is released. Fixing parallel test exec. script.
* [`[b64c8b7]`](https://github.com/dotnet/corefx/commit/b64c8b7) Don't run ImplicitlyExpandNETStandardFacades if disabled
* [`[c95f049]`](https://github.com/dotnet/corefx/commit/c95f049) Move reference expansion to a target and handle simple name conflicts
* [`[e93155f]`](https://github.com/dotnet/corefx/commit/e93155f) Fix off-by-one error in NetEventSource.WriteEvent
* [`[e01cd64]`](https://github.com/dotnet/corefx/commit/e01cd64) Porting PR 19884 SqlConnection doesn't override DbProviderFactory property (#20198)
* [`[09d0809]`](https://github.com/dotnet/corefx/commit/09d0809) Associate #19965 with existing test (#20111)
* [`[10a6570]`](https://github.com/dotnet/corefx/commit/10a6570) Fix handling of root on Unix in directory error handling (#20049)
* [`[d32da03]`](https://github.com/dotnet/corefx/commit/d32da03) Fix Unix missing file state (#19959)
* [`[31291f3]`](https://github.com/dotnet/corefx/commit/31291f3) Fix potential release of invalid GCHandle in PinnedObject.Release (#20006)
* [`[71fadcd]`](https://github.com/dotnet/corefx/commit/71fadcd) Add win-arm and win-arm64 to RID graph.
* [`[b01c282]`](https://github.com/dotnet/corefx/commit/b01c282) Add more tracing to HttpClient on Unix
* [`[ecc6266]`](https://github.com/dotnet/corefx/commit/ecc6266) Merge pull request #20105 from danmosemsft/bug.servicecontroller (#20120)
* [`[a4429f5]`](https://github.com/dotnet/corefx/commit/a4429f5) Sudo fix (#20080) (#20119)
* [`[6406a1d]`](https://github.com/dotnet/corefx/commit/6406a1d) Update CoreClr to preview2-25323-01
* [`[07e7e24]`](https://github.com/dotnet/corefx/commit/07e7e24) Set the correct key for WindowsBase shim
* [`[6c51991]`](https://github.com/dotnet/corefx/commit/6c51991) Add additional DataTable functionality to SqlClient to match Framework implementation (#20022) (#20124)
* [`[05137b9]`](https://github.com/dotnet/corefx/commit/05137b9) Throw exception on enlisting SqlConnection in transaction (#19968) (#20116)
* [`[911b778]`](https://github.com/dotnet/corefx/commit/911b778) Add more compat shim assemblies
* [`[a32a841]`](https://github.com/dotnet/corefx/commit/a32a841) Port disabling 3 Nano tests to 2.0 (#20082)
* [`[89f0479]`](https://github.com/dotnet/corefx/commit/89f0479) Proactively fix other potential use-after-free .Handle errors
* [`[8f86fed]`](https://github.com/dotnet/corefx/commit/8f86fed) Fix "invalid handle" failure in X509Cert's copy ctor on macOS
* [`[23bbbac]`](https://github.com/dotnet/corefx/commit/23bbbac) Fix RevocationMode and RevocationFlag errors on macOS
* [`[44c1ce7]`](https://github.com/dotnet/corefx/commit/44c1ce7) Porting Sqlconnection.GetSchema (PR #19937) (#20004)
* [`[7af8b28]`](https://github.com/dotnet/corefx/commit/7af8b28) Remove Build.Clean from definitions to skip VSTS cleanup. We have a PowerShell script in the repo to do this cleanup and it is more robust.
* [`[67602cd]`](https://github.com/dotnet/corefx/commit/67602cd) Update configurations
* [`[d8ff2b9]`](https://github.com/dotnet/corefx/commit/d8ff2b9) Remove RID-specific desktop builds
* [`[6d204a6]`](https://github.com/dotnet/corefx/commit/6d204a6) Fix Process.Start() on Unix platforms to not leak file descriptors of redirection pipes to child processes
* [`[6dde19a]`](https://github.com/dotnet/corefx/commit/6dde19a) Adding DataTable support in SqlParameter (#19905) (#19961)
* [`[8e4a58a]`](https://github.com/dotnet/corefx/commit/8e4a58a) Make all X509Store.Open exceptions be CryptographicException. (#19844)
* [`[0d625a7]`](https://github.com/dotnet/corefx/commit/0d625a7) Fix Windows X509Certificate2.ToString(true) for ephemeral private keys
* [`[aa1ae33]`](https://github.com/dotnet/corefx/commit/aa1ae33) Remove unused resource string
* [`[4be4b45]`](https://github.com/dotnet/corefx/commit/4be4b45) Special-case DangerousAcceptAnyServerCertificateValidator on Unix
* [`[bb1a7d3]`](https://github.com/dotnet/corefx/commit/bb1a7d3) Add DangerousAcceptAnyServerCertificateValidator property to HttpClientHandler
* [`[044debf]`](https://github.com/dotnet/corefx/commit/044debf) Decrease number of socket instances in SocketPerformance_MultipleSocketClientAsync_LocalHostServerAsync
* [`[986ffdb]`](https://github.com/dotnet/corefx/commit/986ffdb) Use RemoteEchoServer in DiagnosticSource HttpHandlerDiagnosticListenerTests (#19863)
* [`[40f4ddd]`](https://github.com/dotnet/corefx/commit/40f4ddd) Adding GetSchemaTable() on SqlDataReader (#19864)
* [`[463cb50]`](https://github.com/dotnet/corefx/commit/463cb50) Update ProjectNTfs, ProjectNTfsTestILC to beta-25317-00, beta-25317-00, respectively (#19869)
* [`[7463c0b]`](https://github.com/dotnet/corefx/commit/7463c0b) Update xunit extensions to include ActiveIssueAttribute functionality
* [`[b9b3060]`](https://github.com/dotnet/corefx/commit/b9b3060) Fix SendAsync_ExpectedDiagnosticSourceActivityLogging test (#19796)
* [`[e6512ad]`](https://github.com/dotnet/corefx/commit/e6512ad) Fix Xml.Linq test failures on ILC (#19860)
* [`[5f0251d]`](https://github.com/dotnet/corefx/commit/5f0251d) Fix deadlock in SslStream_SameCertUsedForClientAndServer_Ok test on single core
* [`[8a197f8]`](https://github.com/dotnet/corefx/commit/8a197f8) System.Runtime .NET Native fixes and leftover PR feedback (#19856)
* [`[1d45b1a]`](https://github.com/dotnet/corefx/commit/1d45b1a) Add IDataReader interface to SqlDataReader to match Framework implementation (#19851)
* [`[2055ca7]`](https://github.com/dotnet/corefx/commit/2055ca7) Fix 60 failures in System.Text.Encoding.Tests on ILC (#19847)
* [`[5a778be]`](https://github.com/dotnet/corefx/commit/5a778be) Fix the issues in extension method. (#19846)
* [`[d2a2d7c]`](https://github.com/dotnet/corefx/commit/d2a2d7c) Enable some threading overlapped tests on Unix (#19782)
* [`[699887f]`](https://github.com/dotnet/corefx/commit/699887f) Fixed uap/uapaot tests in System.Runtime (#19819)
* [`[6dd451f]`](https://github.com/dotnet/corefx/commit/6dd451f) Scale back [Serializable] CoreFX types (#19742)
* [`[b0900bb]`](https://github.com/dotnet/corefx/commit/b0900bb) Change XmlDownloadManager back to use WebRequest (#19812)
* [`[6c7f3ac]`](https://github.com/dotnet/corefx/commit/6c7f3ac) Remove IsoStorage lock from UAP and enable tests (#19840)
* [`[1686a8e]`](https://github.com/dotnet/corefx/commit/1686a8e) Replace MANAGED_SNI flag in SQL tests with a reflection-based check of UseManagedSNI (#19807)
* [`[e474192]`](https://github.com/dotnet/corefx/commit/e474192) Fix failures in System.Reflection.TypeExtensions.CoreCLR (#19841)
* [`[3ccdcb1]`](https://github.com/dotnet/corefx/commit/3ccdcb1) Add LongRunning option to managed SNI async reads (#19739)
* [`[977d3eb]`](https://github.com/dotnet/corefx/commit/977d3eb) Fix several code generator issues. (#19737)
* [`[1856017]`](https://github.com/dotnet/corefx/commit/1856017) Disable SslStream_SameCertUsedForClientAndServer_Ok test failing on Win7
* [`[63953c3]`](https://github.com/dotnet/corefx/commit/63953c3) Fix Unix FileVersionInfo handling of name
* [`[298f1a2]`](https://github.com/dotnet/corefx/commit/298f1a2) Add tests for HttpListenerContext.AcceptWebSocketAsync and fix the managed implementation (#19761)
* [`[ac3d3ba]`](https://github.com/dotnet/corefx/commit/ac3d3ba) Change CoreFX to use SetThreadErrorMode (#19801)
* [`[36137ca]`](https://github.com/dotnet/corefx/commit/36137ca) Consolidate common state checking in HttpListenerResponse (#19770)
* [`[7601889]`](https://github.com/dotnet/corefx/commit/7601889) Update ActiveIssue issue number
* [`[dbe48df]`](https://github.com/dotnet/corefx/commit/dbe48df) Disable UseCallback_BadCertificate_ExpectedPolicyErrors test on Windows
* [`[a4af8e0]`](https://github.com/dotnet/corefx/commit/a4af8e0) Fix failures in System.Dynamic.Runtime.Tests
* [`[6fc97cf]`](https://github.com/dotnet/corefx/commit/6fc97cf) Deactivating System.IO.FileSystem.AccessControl tests on uap/uapaot (#19750)
* [`[f4332ab]`](https://github.com/dotnet/corefx/commit/f4332ab) Change DefaultResolver in XmlReaderSettings to XmlUrlResolver (#19803)
* [`[bfe3363]`](https://github.com/dotnet/corefx/commit/bfe3363) Make HttpListenerResponse.ContentEncoding a Nop in the managed implementation to match Windows (#19766)
* [`[64fba21]`](https://github.com/dotnet/corefx/commit/64fba21) Fix 180 uap/uapaot tests in System.IO.MemoryMappedFiles.Tests (#19760)
* [`[8daf250]`](https://github.com/dotnet/corefx/commit/8daf250) Update reasons for RemoteInvoke
* [`[81bd3d3]`](https://github.com/dotnet/corefx/commit/81bd3d3) Check for duplicate types in framework packages
* [`[fe784bc]`](https://github.com/dotnet/corefx/commit/fe784bc) Fix all failures in System.CodeDom.Tests on ILC.
* [`[5685c8b]`](https://github.com/dotnet/corefx/commit/5685c8b) Workaround Issue Related to DateTimeOffsetAdapter. (#19665)
* [`[72b1fcb]`](https://github.com/dotnet/corefx/commit/72b1fcb) Fix yet more random test failures on ILC (#19778)
* [`[a6882f9]`](https://github.com/dotnet/corefx/commit/a6882f9) Fix SendAsync on Unix with multiple buffers
* [`[5fa821e]`](https://github.com/dotnet/corefx/commit/5fa821e) Add test for large sends with multiple buffers
* [`[fab6ae5]`](https://github.com/dotnet/corefx/commit/fab6ae5) Update the License info (#19779)
* [`[f86236c]`](https://github.com/dotnet/corefx/commit/f86236c) Fix DCS_ResolveNameReturnsEmptyNamespace. (#19631)
* [`[55e85fa]`](https://github.com/dotnet/corefx/commit/55e85fa) Revert "Remove some assemblies from some OS shared frameworks"
* [`[1c9342b]`](https://github.com/dotnet/corefx/commit/1c9342b) Add Test Case for String.Index with Empty String (#19776)
* [`[be34919]`](https://github.com/dotnet/corefx/commit/be34919) Make sure source isn't included in NETStandard.Library.NETFramework
* [`[901af62]`](https://github.com/dotnet/corefx/commit/901af62) Fix several GetClientCertificate tests for the managed implementation of HttpListener (#19757)
* [`[69963dc]`](https://github.com/dotnet/corefx/commit/69963dc) Re-enable AssemblyNameTests.Version test and fix merge conflicts
* [`[f9dc783]`](https://github.com/dotnet/corefx/commit/f9dc783) Update AssemblyName.FullName tests
* [`[32310bb]`](https://github.com/dotnet/corefx/commit/32310bb) Fix a bunch of random test failures on ILC (#19758)
* [`[cf3c7d5]`](https://github.com/dotnet/corefx/commit/cf3c7d5) Enable most corefx tests for Bash on Windows
* [`[5caaee1]`](https://github.com/dotnet/corefx/commit/5caaee1) Fixing uap/uapaot test issues in System.IO.Compression.ZipFile (#19751)
* [`[8006221]`](https://github.com/dotnet/corefx/commit/8006221) Documentation: Test paradigm used in Core (#19747)
* [`[e9deae2]`](https://github.com/dotnet/corefx/commit/e9deae2) Changed few driveinfo tests for uap/uapaot appcontainer (#19752)
* [`[a0c61a3]`](https://github.com/dotnet/corefx/commit/a0c61a3) Cleanup uncecessary interop calls to get known headers
* [`[eb4ea83]`](https://github.com/dotnet/corefx/commit/eb4ea83) Use Windows implementation of HttpListenerRequest.KeepAlive in managed
* [`[bec691c]`](https://github.com/dotnet/corefx/commit/bec691c) Fix hang in HttpListener test
* [`[16f4937]`](https://github.com/dotnet/corefx/commit/16f4937) Fixed CurrentCulture static property assignment causing side effects in other tests (#19740)
* [`[977712e]`](https://github.com/dotnet/corefx/commit/977712e) Fix incorrect exception thrown in HttpResponseStream.Write for a closed connection (#19219)
* [`[a6cfa45]`](https://github.com/dotnet/corefx/commit/a6cfa45) Hide obsolete platform IDs from Editor
* [`[ea514e2]`](https://github.com/dotnet/corefx/commit/ea514e2) Fix using Directory to move files (#19716)
* [`[e217a43]`](https://github.com/dotnet/corefx/commit/e217a43) Rename connection validation function, since it no longer returns a boolean
* [`[b58a7da]`](https://github.com/dotnet/corefx/commit/b58a7da) Add assert failure messages to TcpDefaultForAzureTest, and merge its redundant OS-specific tests
* [`[ca38da9]`](https://github.com/dotnet/corefx/commit/ca38da9) Match desktop behavior GetRequestStream/BeginGetRequestStream throws on invalid verb
* [`[dd6672d]`](https://github.com/dotnet/corefx/commit/dd6672d) Adding tests
* [`[2cc6211]`](https://github.com/dotnet/corefx/commit/2cc6211) Make SqlParameter implement IDbDataParameter
* [`[5048d13]`](https://github.com/dotnet/corefx/commit/5048d13) Fix Pipes tests to workaround desktop SafeHandle finalization bug
* [`[6585f9c]`](https://github.com/dotnet/corefx/commit/6585f9c) Retry failed calls to open SecTrust enumerators.
* [`[826e35d]`](https://github.com/dotnet/corefx/commit/826e35d) Skip failing test to unblock CI.
* [`[f30d8d4]`](https://github.com/dotnet/corefx/commit/f30d8d4) Increased code coverage for System.Net.Security to 66.6% (#19664)
* [`[b6397ab]`](https://github.com/dotnet/corefx/commit/b6397ab) Reenable RequestStream tests and address HttpWebRequest PR feedback (#19613)
* [`[44e227e]`](https://github.com/dotnet/corefx/commit/44e227e) Add canonicalization test (#19693)
* [`[9c3fcc7]`](https://github.com/dotnet/corefx/commit/9c3fcc7) Remove duplicate resource
* [`[88f562c]`](https://github.com/dotnet/corefx/commit/88f562c) SqlClientFactory: Override CreateDataAdapter (#19682)
* [`[99a8875]`](https://github.com/dotnet/corefx/commit/99a8875) Use CDN for dotnetcli blobs
* [`[1c7e85e]`](https://github.com/dotnet/corefx/commit/1c7e85e) Fixed DCS_EnumerableCollection. (#19684)
* [`[418a59d]`](https://github.com/dotnet/corefx/commit/418a59d) Update the SNI subscription as well as the SNI package to signed packages (#19687)
* [`[a994f65]`](https://github.com/dotnet/corefx/commit/a994f65) Fix all failures in Security.Cryptography.Encoding.Tests on ILC
* [`[6df88e4]`](https://github.com/dotnet/corefx/commit/6df88e4) Fix System.Configuration.ConfigurationManager desktop ref
* [`[67412b4]`](https://github.com/dotnet/corefx/commit/67412b4) Changes to support ARM-requeue for UAPAOT testing
* [`[7fc586b]`](https://github.com/dotnet/corefx/commit/7fc586b) Fix a failure in System.Reflection.DispatchProxy.Tests on ILC
* [`[52c426f]`](https://github.com/dotnet/corefx/commit/52c426f) Re-enable tests on Fedora/Rhel/Centos.
* [`[3b4daa2]`](https://github.com/dotnet/corefx/commit/3b4daa2) Fix all System.Text.RegularExpressions.Tests failures on ILC
* [`[4456c12]`](https://github.com/dotnet/corefx/commit/4456c12) Fix all System.Text.Encodings.Web.Tests failures on ILC
* [`[c29e297]`](https://github.com/dotnet/corefx/commit/c29e297) System.Data.Common.Tests down to 1 failure on ILC
* [`[534c3a1]`](https://github.com/dotnet/corefx/commit/534c3a1) Fix all System.ComponentObject.TypeConverter.Test failures on ILC
* [`[3e378b2]`](https://github.com/dotnet/corefx/commit/3e378b2) Updated Docs.
* [`[f4a8241]`](https://github.com/dotnet/corefx/commit/f4a8241) Add test for BadImageFormatException thrown by AssemblyName.GetAssemblyName
* [`[1bb768c]`](https://github.com/dotnet/corefx/commit/1bb768c) Fix 79 System.Data.Common.Test failures on ILC
* [`[3f50597]`](https://github.com/dotnet/corefx/commit/3f50597) Support KnownTypeAttribute.MethodName on UWP. (#19617)
* [`[099269b]`](https://github.com/dotnet/corefx/commit/099269b) Further harden the VerifyDecryptKeyExchange tests
* [`[41c2e84]`](https://github.com/dotnet/corefx/commit/41c2e84) Allow Deprecated and non-deprecated HTTP events simultaneously.
* [`[f37fb0d]`](https://github.com/dotnet/corefx/commit/f37fb0d) Add test for AppDomain.SetData with the same key multiple times
* [`[e432fb6]`](https://github.com/dotnet/corefx/commit/e432fb6) Manually add the attribute for projects that don't reference S.R.InteropServices but have DllImports.
* [`[e27f72b]`](https://github.com/dotnet/corefx/commit/e27f72b) Use read to get the redirected output from process. (#19632)
* [`[4c0d3a5]`](https://github.com/dotnet/corefx/commit/4c0d3a5) Make VerifyDecryptKeyExchange give more context on failure. (#19628)
* [`[884557a]`](https://github.com/dotnet/corefx/commit/884557a) Rewrite SendFile_APM test (#19603)
* [`[9875494]`](https://github.com/dotnet/corefx/commit/9875494) Add new api tests only to netcoreapp.
* [`[2fa470f]`](https://github.com/dotnet/corefx/commit/2fa470f) Disable package harvesting for the vertical build packages
* [`[4725b94]`](https://github.com/dotnet/corefx/commit/4725b94) Add Microsoft.NETCore.Targets package to the vertical build
* [`[d441d43]`](https://github.com/dotnet/corefx/commit/d441d43) Change EncryptPassword to ObfuscatePassword to reflect the functionality (#19616)
* [`[7f885e4]`](https://github.com/dotnet/corefx/commit/7f885e4) Add Microsoft.NETCore.Platforms to the vertical build
* [`[023ecc9]`](https://github.com/dotnet/corefx/commit/023ecc9) Fixing OID EKU validation.
* [`[3365ac6]`](https://github.com/dotnet/corefx/commit/3365ac6) Fix rd.xml for Serialization Reflection Only Mode. (#19556)
* [`[de7ae0e]`](https://github.com/dotnet/corefx/commit/de7ae0e) adding SqlParameter constructor (#19544)
* [`[2f19b38]`](https://github.com/dotnet/corefx/commit/2f19b38) Disable SendAsync_ReadFromSlowStreamingServer_PartialDataReturned test on netfx
* [`[83479a7]`](https://github.com/dotnet/corefx/commit/83479a7) System.Security.Permissions.Tests at 0 failures on ILC.
* [`[964fc30]`](https://github.com/dotnet/corefx/commit/964fc30) Fix another 4 System.Net.Mail.Functional.Tests failures on ILC (#19608)
* [`[6985104]`](https://github.com/dotnet/corefx/commit/6985104) Fix duplicated XDocumentExtensions
* [`[2e4e5ce]`](https://github.com/dotnet/corefx/commit/2e4e5ce) System.Xml.Xsl.XslTransformApi.Tests at 0 failues on ILC.
* [`[756781e]`](https://github.com/dotnet/corefx/commit/756781e) Fix 40 or so System.Net.Mail.Functional.Tests failures on ILC (#19602)
* [`[5c32540]`](https://github.com/dotnet/corefx/commit/5c32540) Create done marker directory (#19538)
* [`[880e6b6]`](https://github.com/dotnet/corefx/commit/880e6b6) Add perf tests for Random.cs. (#19561)
* [`[1da37f2]`](https://github.com/dotnet/corefx/commit/1da37f2) Fix SynchronizationContextTests.WaitTest on desktop
* [`[9e04bbf]`](https://github.com/dotnet/corefx/commit/9e04bbf) Fix slashes
* [`[327fabf]`](https://github.com/dotnet/corefx/commit/327fabf) Port the Html Encoder fix from VSO branch (#19572)
* [`[e520b6d]`](https://github.com/dotnet/corefx/commit/e520b6d) System.Transactions.Local.Tests now at 0 failures on ILC.
* [`[040153b]`](https://github.com/dotnet/corefx/commit/040153b) Revert "Use Tizen dotnet-core myget in Tizen CI"
* [`[bec96bf]`](https://github.com/dotnet/corefx/commit/bec96bf) HttpWebRequest tests hardened & RequestStream tests disabled on Desktop (#19584)
* [`[e4977eb]`](https://github.com/dotnet/corefx/commit/e4977eb) Fix remaining TODOs for SocketTaskExtensions tests
* [`[f103b80]`](https://github.com/dotnet/corefx/commit/f103b80) System.Security.Cryptography.Xml.Tests now at 0 failures on ILC. (#19567)
* [`[e5d86da]`](https://github.com/dotnet/corefx/commit/e5d86da) Fix duplicated types in Unix build of System.Threading.Overlapped
* [`[0c6f4df]`](https://github.com/dotnet/corefx/commit/0c6f4df) Use Tizen dotnet-core myget in Tizen CI
* [`[a2e59ee]`](https://github.com/dotnet/corefx/commit/a2e59ee) Use Tizen dotnet-core myget in Tizen CI
* [`[00b2a85]`](https://github.com/dotnet/corefx/commit/00b2a85) Add nice messages for assemblies with autogenerated PNSE (#19506)
* [`[bf005fb]`](https://github.com/dotnet/corefx/commit/bf005fb) Let First/FirstOrDefault combinatorial accept exception.
* [`[b92843e]`](https://github.com/dotnet/corefx/commit/b92843e) Don't manually define UriSection on NetFX (#19574)
* [`[2f096d4]`](https://github.com/dotnet/corefx/commit/2f096d4) Remove unneeded Serializable attributes (#19577)
* [`[629d238]`](https://github.com/dotnet/corefx/commit/629d238) Fix failing HttpListener tests
* [`[c4c6713]`](https://github.com/dotnet/corefx/commit/c4c6713) Create a document describing x-plat crypto (#19536)
* [`[f55ba6a]`](https://github.com/dotnet/corefx/commit/f55ba6a) Add desktop innerloop badges (#19569)
* [`[7575bee]`](https://github.com/dotnet/corefx/commit/7575bee) Fix XmlSerializer timespan tests for any full framework version (#19564)
* [`[cea2df0]`](https://github.com/dotnet/corefx/commit/cea2df0) Exclude UAP from packages in rel/2.0.0
* [`[573ac31]`](https://github.com/dotnet/corefx/commit/573ac31) Enable test run on CI for Desktop (#19488)
* [`[1ff8e57]`](https://github.com/dotnet/corefx/commit/1ff8e57) Update the packaging license link to MIT (#19559)
* [`[fed476a]`](https://github.com/dotnet/corefx/commit/fed476a) Letting perfproc errors pass silently (#19495)
* [`[536956f]`](https://github.com/dotnet/corefx/commit/536956f) Enable System.Net.Requests.Tests to run in parallel again (#19525)
* [`[f79a893]`](https://github.com/dotnet/corefx/commit/f79a893) Moving CompileDeepTree_NoStackOverflowFast to the outer loop
* [`[82bda9a]`](https://github.com/dotnet/corefx/commit/82bda9a) Reference official targeting pack for 4.7 (version 1.0.1)
* [`[bf5ffea]`](https://github.com/dotnet/corefx/commit/bf5ffea) Disabling xunit AppDomain in System.Configuration.ConfigurationManager in favor of consistent BaseDirectory path behavior (#19546)
* [`[20fa122]`](https://github.com/dotnet/corefx/commit/20fa122) Make TransportType internal in Sockets assembly
* [`[4f655d7]`](https://github.com/dotnet/corefx/commit/4f655d7) Make SocketType internal in all but Sockets assembly
* [`[ba7b4b0]`](https://github.com/dotnet/corefx/commit/ba7b4b0) Update the build tools version (#19541)
* [`[3ad4aca]`](https://github.com/dotnet/corefx/commit/3ad4aca) Fix System.Net.Primitives tests
* [`[ab27004]`](https://github.com/dotnet/corefx/commit/ab27004) Fix HttpListener cookies with variants
* [`[c5e5a50]`](https://github.com/dotnet/corefx/commit/c5e5a50) Fix CookieExceptions thrown for invalid cookies in HttpListenerRequest.Cookies
* [`[46e88c2]`](https://github.com/dotnet/corefx/commit/46e88c2) Move CookieComparer to common
* [`[eff4582]`](https://github.com/dotnet/corefx/commit/eff4582) Temporary hack: comment out IsQuoted assignments
* [`[1eb6878]`](https://github.com/dotnet/corefx/commit/1eb6878) Fix uses of InternalSetName in CookieParser
* [`[9abc09d]`](https://github.com/dotnet/corefx/commit/9abc09d) Move internal cookie fields to common
* [`[db952e0]`](https://github.com/dotnet/corefx/commit/db952e0) Move CookieParser to Common
* [`[8ee19f5]`](https://github.com/dotnet/corefx/commit/8ee19f5) check if SHA2 SignatureDescription algorithm is available on netfx
* [`[cfadea9]`](https://github.com/dotnet/corefx/commit/cfadea9) Remove workaround for duplicate types in ConfigManager
* [`[97cd360]`](https://github.com/dotnet/corefx/commit/97cd360) Fix duplicate types in ports on desktop
* [`[142932a]`](https://github.com/dotnet/corefx/commit/142932a) Allow TransportType conflict between Permissions and Sockets
* [`[f1421a9]`](https://github.com/dotnet/corefx/commit/f1421a9) Allow DBNull conflict with data.common & corelib
* [`[15d74f5]`](https://github.com/dotnet/corefx/commit/15d74f5) Treat ValueTuple inbox on netstandard2.0 in nupkg
* [`[d99e172]`](https://github.com/dotnet/corefx/commit/d99e172) Fix duplicate types in System.Numerics.Vectors on net46
* [`[83a0773]`](https://github.com/dotnet/corefx/commit/83a0773) Fix cycle in Cng package
* [`[6b2a3fe]`](https://github.com/dotnet/corefx/commit/6b2a3fe) Add test targets to validate packages
* [`[051442c]`](https://github.com/dotnet/corefx/commit/051442c) Use latest dotnet CLI for package testing
* [`[f135adb]`](https://github.com/dotnet/corefx/commit/f135adb) Cleaning up dead code in System.Net.Mail
* [`[f02a5de]`](https://github.com/dotnet/corefx/commit/f02a5de) Remove uapredist as it is not needed any longer
* [`[21ca4d7]`](https://github.com/dotnet/corefx/commit/21ca4d7) Handle the PNSE when opening LocalMachine\My store on Linux (#19533)
* [`[5a61d97]`](https://github.com/dotnet/corefx/commit/5a61d97) Rename SupportsDecryptValue to SupportsNewRsaTypes
* [`[1031905]`](https://github.com/dotnet/corefx/commit/1031905) Increase code coverage of WebRequest, Authorization, AuthorizationManager (#19498)
* [`[2133fc4]`](https://github.com/dotnet/corefx/commit/2133fc4) use ConditionalFact instead of SkipOnTargetFramework
* [`[0660313]`](https://github.com/dotnet/corefx/commit/0660313) Fix RsaDecryptAfterExport
* [`[2b1eb13]`](https://github.com/dotnet/corefx/commit/2b1eb13) Fix more CoreFx tests on ILC (#19531)
* [`[31d9873]`](https://github.com/dotnet/corefx/commit/31d9873) Cleaning up dead code in System.Net.Mail
* [`[041672f]`](https://github.com/dotnet/corefx/commit/041672f) Fix sharing violations caused by FileShare.Inherited
* [`[3331cda]`](https://github.com/dotnet/corefx/commit/3331cda) Improve logging in FileShareOpen test
* [`[7a48e11]`](https://github.com/dotnet/corefx/commit/7a48e11) Add HttpListenerPrefixCollection tests and align managed implementation with Windows (#19217)
* [`[b98860c]`](https://github.com/dotnet/corefx/commit/b98860c) Perf improvements to StreamWriter with perf tests
* [`[b804a09]`](https://github.com/dotnet/corefx/commit/b804a09) Nano adjustment of console encoding (#19519)
* [`[c6eb858]`](https://github.com/dotnet/corefx/commit/c6eb858) Add windows 7
* [`[236c0b9]`](https://github.com/dotnet/corefx/commit/236c0b9) Update CoreFx to preview2-25309-01 (#19510)
* [`[3f800b2]`](https://github.com/dotnet/corefx/commit/3f800b2) Fix System.IO.Compression test (#19509)
* [`[0218670]`](https://github.com/dotnet/corefx/commit/0218670) Fix S.Security.Cryptography desktop tests (#19505)
* [`[b59f629]`](https://github.com/dotnet/corefx/commit/b59f629) Mono-specific HttpListener additions. (#19490)
* [`[236933a]`](https://github.com/dotnet/corefx/commit/236933a) test behavior change caused by removing CAS related ctor (#19494)
* [`[fe7f6e3]`](https://github.com/dotnet/corefx/commit/fe7f6e3) Add Path.cs performance tests. (#19367)
* [`[0c6dc1d]`](https://github.com/dotnet/corefx/commit/0c6dc1d) Block opening the Disallowed X509Store on Linux (#19503)
* [`[3cec4b3]`](https://github.com/dotnet/corefx/commit/3cec4b3) Fix remaining IO tests (#19343)
* [`[7fb7439]`](https://github.com/dotnet/corefx/commit/7fb7439) Check for openssl version before setting cert callback.
* [`[71b7e49]`](https://github.com/dotnet/corefx/commit/71b7e49) Replace test shared framework with the runtime packages
* [`[c2a5cbf]`](https://github.com/dotnet/corefx/commit/c2a5cbf) Caching EqualityComparer\<T>.Default instances in ValueTuple (#19332)
* [`[35735e2]`](https://github.com/dotnet/corefx/commit/35735e2) Include Cryptography.Cng 462OrNewer tests only when targetgroup is net462, net47 or netcoreapp (#19390)
* [`[2f86292]`](https://github.com/dotnet/corefx/commit/2f86292) Normalize Temp path for Nano (#19486)
* [`[af3106d]`](https://github.com/dotnet/corefx/commit/af3106d) Cleaning dead code in System.Net.Mail
* [`[394c0bf]`](https://github.com/dotnet/corefx/commit/394c0bf) Disable SignedXmlHasCertificateVerifiableSignature on <= net4.6.1
* [`[64aa8d1]`](https://github.com/dotnet/corefx/commit/64aa8d1) Update buildtools version (#19485)
* [`[fd1bd24]`](https://github.com/dotnet/corefx/commit/fd1bd24) Fix UMS 32bit PositionPointer test.
* [`[2f8ba83]`](https://github.com/dotnet/corefx/commit/2f8ba83) Fix LazyTests.Ctor_ExceptionRecovery test
* [`[c4f87f2]`](https://github.com/dotnet/corefx/commit/c4f87f2) Update crypto x509 certs to openssl change.
* [`[0f59071]`](https://github.com/dotnet/corefx/commit/0f59071) Check openssl version before setting ssl options.
* [`[4959005]`](https://github.com/dotnet/corefx/commit/4959005) Fix Mono bug #52508 in HttpListener when doing multiple Https request.
* [`[ec07f80]`](https://github.com/dotnet/corefx/commit/ec07f80) Auto update Microsoft.NETCore.App package version
* [`[8c16d26]`](https://github.com/dotnet/corefx/commit/8c16d26) Avoid file collisions with temporary test files
* [`[0bc18f6]`](https://github.com/dotnet/corefx/commit/0bc18f6) CoreFX on ILC tests burndown
* [`[adf6473]`](https://github.com/dotnet/corefx/commit/adf6473) Fix EnumConverter porting bug around ArrayList (#19475)
* [`[5f93c42]`](https://github.com/dotnet/corefx/commit/5f93c42) Fix FindByValidThumbprint_RootCert when an invalid root is found.
* [`[8127614]`](https://github.com/dotnet/corefx/commit/8127614) Fix serialization roundtrip line number test on desktop (#19473)
* [`[7f866f9]`](https://github.com/dotnet/corefx/commit/7f866f9) Fix Windows_NT release badge with correct job name
* [`[2e10fdc]`](https://github.com/dotnet/corefx/commit/2e10fdc) Fix compile assembly on netfx for crypto-xml (#19422)
* [`[a1b5c98]`](https://github.com/dotnet/corefx/commit/a1b5c98) Re-enable System.Dynamic.Runtime test
* [`[a2214fb]`](https://github.com/dotnet/corefx/commit/a2214fb) Improve polling window logic in ProcessWaitState on Unix
* [`[36f6ec1]`](https://github.com/dotnet/corefx/commit/36f6ec1) Update ProjectNTfs, ProjectNTfsTestILC to beta-25308-00, beta-25308-00, respectively
* [`[8c7bcf4]`](https://github.com/dotnet/corefx/commit/8c7bcf4) Fix several System.Net.Requests param name diffs in tests
* [`[f82fa52]`](https://github.com/dotnet/corefx/commit/f82fa52) Changed ref depending on TargetGroup for EventListener.OnEventWritten
* [`[0b71a3f]`](https://github.com/dotnet/corefx/commit/0b71a3f) Enabled tests for netcoreapp
* [`[f075d0f]`](https://github.com/dotnet/corefx/commit/f075d0f) Expose String.GetHashCode(StringComparison) with tests (#19443)
* [`[9e2256d]`](https://github.com/dotnet/corefx/commit/9e2256d) HttpWebRequest PNSE/NotImplemented members implemented & code coverage increased (#19118)
* [`[cf507e7]`](https://github.com/dotnet/corefx/commit/cf507e7) Fix LoadFrom_EmptyAssemblyFile_ThrowsArgumentException test
* [`[e7e77c0]`](https://github.com/dotnet/corefx/commit/e7e77c0) Fix Path tests for throwing on empty/whitespace inputs
* [`[29a0689]`](https://github.com/dotnet/corefx/commit/29a0689) UMS test update.
* [`[b6ced69]`](https://github.com/dotnet/corefx/commit/b6ced69) Add tests for UMS PositionPointer overflowing
* [`[fe03662]`](https://github.com/dotnet/corefx/commit/fe03662) Fix svc test for nano (#19434)
* [`[5b78935]`](https://github.com/dotnet/corefx/commit/5b78935) Enable 8.3 path test for Nano (#19429)
* [`[02483ee]`](https://github.com/dotnet/corefx/commit/02483ee) Increasing test certificate loader mutex timeout.
* [`[8fae5ae]`](https://github.com/dotnet/corefx/commit/8fae5ae) Enable Canonicalization on NetCore (#19378)
* [`[cbf0f73]`](https://github.com/dotnet/corefx/commit/cbf0f73) Add Tests covering WCF Soap Scenario. (#19258)
* [`[fbc4a1a]`](https://github.com/dotnet/corefx/commit/fbc4a1a) Fix spurious EventSource test failures due to framework sources
* [`[113a7d5]`](https://github.com/dotnet/corefx/commit/113a7d5) Ignore lack of CURLMOPT_MAX_HOST_CONNECTIONS in CurlHandler
* [`[e91a95d]`](https://github.com/dotnet/corefx/commit/e91a95d) Improvements on ReflectionXmlSerializationWriter. (#19027)
* [`[2c368e8]`](https://github.com/dotnet/corefx/commit/2c368e8) Add exception diagnostics to WinHttp

## WCF

* [`[62f7b58]`](https://github.com/dotnet/wcf/commit/62f7b58) Revert "Revert "Move to preview3 prerelease label.""
* [`[8ba4265]`](https://github.com/dotnet/wcf/commit/8ba4265) Revert "Move to preview3 prerelease label."
* [`[6470dd3]`](https://github.com/dotnet/wcf/commit/6470dd3) Fixing PackageBaseline dependency for 2.0.0 release.
* [`[fe9cff0]`](https://github.com/dotnet/wcf/commit/fe9cff0) Enable auto update of dependencies for release/2.0.0
* [`[92af71d]`](https://github.com/dotnet/wcf/commit/92af71d) Move to preview3 prerelease label.
* [`[55b16db]`](https://github.com/dotnet/wcf/commit/55b16db) Update the release 2.0.0 branch to reference WCF pkgs built in same branch.
* [`[57875d9]`](https://github.com/dotnet/wcf/commit/57875d9) Updating NetStandard version for 2.0.0 release.
* [`[7aeabf8]`](https://github.com/dotnet/wcf/commit/7aeabf8) Updating Microsoft.NETCore.App version to final Preview2 version.
* [`[54329f0]`](https://github.com/dotnet/wcf/commit/54329f0) Remove serializable attribute and throw PNSE.
* [`[9ccd6bd]`](https://github.com/dotnet/wcf/commit/9ccd6bd) Disable PeerTrust certificate validation on OSX
* [`[2856c49]`](https://github.com/dotnet/wcf/commit/2856c49) Remove unnecessary content from the common project.json.
* [`[f9866ab]`](https://github.com/dotnet/wcf/commit/f9866ab) Enable test after Peer trust fix in CoreFx (for Release 2.0).
* [`[233c6d2]`](https://github.com/dotnet/wcf/commit/233c6d2) Only increment the build version of Microsoft.NETCore.App.
* [`[fa6d6f6]`](https://github.com/dotnet/wcf/commit/fa6d6f6) Enable and fix tests that were affected by CoreFx breaking changes to CRL.
* [`[c15a2fa]`](https://github.com/dotnet/wcf/commit/c15a2fa) Update baseline version of CoreFx packages for ns 1.3.
* [`[9c0a66b]`](https://github.com/dotnet/wcf/commit/9c0a66b) Fix assembly to package version mapping.
* [`[95d4028]`](https://github.com/dotnet/wcf/commit/95d4028) Adding support for these two latest versions of OSX and Fedora.
* [`[6e87f5a]`](https://github.com/dotnet/wcf/commit/6e87f5a) Add Serializable attribute to WCF Exception classes.
* [`[43ee715]`](https://github.com/dotnet/wcf/commit/43ee715) Fix for #1694 (#1904)
* [`[df9b615]`](https://github.com/dotnet/wcf/commit/df9b615) Fixes for supporting 461 and reving S.SM.Duplex assembly minor version
* [`[37b15e3]`](https://github.com/dotnet/wcf/commit/37b15e3) Including Security and Duplex for net461 support.
* [`[37021cd]`](https://github.com/dotnet/wcf/commit/37021cd) Adding support for net 4.6.1
* [`[7873693]`](https://github.com/dotnet/wcf/commit/7873693) Enable Test EchoComositeType_XmlSerializerFormat_Soap (#1905)
* [`[04a4868]`](https://github.com/dotnet/wcf/commit/04a4868) Adding proxy support to HTTP
* [`[84da668]`](https://github.com/dotnet/wcf/commit/84da668) Update the License Url for packages
* [`[8d9bfd8]`](https://github.com/dotnet/wcf/commit/8d9bfd8) Fix 1574 and enable tests \* Use X509Certificate2 copy constructor as it becomes available in 2.0. \* Enable those TCP tests require service certificate. They pass by using the X509Certificate2 copy constructor.
* [`[c975ecc]`](https://github.com/dotnet/wcf/commit/c975ecc) Fixing #1402 (#1898)
* [`[f8bea43]`](https://github.com/dotnet/wcf/commit/f8bea43) Update docs of package versions for 2.0 Preview 1 release
* [`[9ad2325]`](https://github.com/dotnet/wcf/commit/9ad2325) Updating WCF dependencies on CoreFx and NetStandard to 25309-01
