# .NET Core 2.0.0 Known Issues

This document lists known issues for *.NET Core 2.0.0* and *.NET Core SDK 2.0.0* which may be encountered during usage.

## Ubuntu - Uninstall Preview releases before attempting to install .NET Core 2.0.0

Reported in [dotnet/core/issues/717](https://github.com/dotnet/core/issues/717) If you have .NET Core Preview 1 installed, it will need to be removed before attempting to install Preview 2. This can be done by running the following command.

`sudo apt remove dotnet-dev-2.0.0-preview1-005977` for Preview 1

or

`sudo apt remove dotnet-dev-2.0.0-preview2-006497` for Preview 2.

## Installing from rpm on SUSE/OpenSUSE

When installing the SDK, SUSE and OpenSUSE may report that nothing provides libcurl. libcurl should already be installed on supported versions of both distros. Run zypper search libcurl to confirm. The error will present 2 'solutions'. Choose 'Solution 2' to continue installing .NET Core.

## Docker restore failure when running from /

Dotnet restore fails when a project has been created at the linux root without having specified a name for the project.

If you do dotnet new {template name} at the linux root and do not specify a name for the project (using the -n or --name parameters), the project will be created without a name (resulting in a project called ".csproj" or a similar name for F# or VB). This creates a couple of notable - the project file will be "hidden" and dotnet restore will fail (as projects are required to have a non-empty name).

## Install requirements changed when installing from tar.gz

Changes in the .NET Core CLI first run behavior need to be executed in locations which the user has change permissions. For this reason, guidance for installing from binary archive on Linux and Mac has changed from /opt/dotnet to $HOME/dotnet and the dotnet directory must be created with user permissions rather than as sudo.

If the user does not have permissions to the dotnet directory when attempting to run a dotnet command for the first time a number of permissions errors will result.

```bash
mkdir -p $HOME/dotnet && tar zxf dotnet.tar.gz -C $HOME/dotnet
export PATH=$PATH:$HOME/dotnet
```

The above command will place `$HOME/dotnet` on the path only for the terminal session in which it was run. You can edit your shell profile to permanently place `$HOME/dotnet` on the path. There are a number of different shells available for Linux and each has a different profile. For example:

* Bash Shell: $HOME/.bash_profile, $HOME/.bashrc
* Korn Shell: $HOME/.kshrc or .profile
* Z Shell: $HOME/.zshrc or .zprofile

Edit the appropriate source file for you shell and either add `:$HOME/dotnet` to the end of the exiting PATH statement or, if no PATH statement is included, add a new line with `export PATH=$PATH:$HOME/dotnet`.

More info: [dotnet/docs/issues/2790](https://github.com/dotnet/docs/issues/2790) and [dotnet/cli/issues/7203](https://github.com/dotnet/cli/issues/7203)

## NuGet restore may treat disabled package sources as enabled in some cases

**Issue:**
The following restore command-line techniques treat disabled packages sources as enabled. NuGet#5704

```
msbuild /t:restore
dotnet restore (either with dotnet.exe that ships with VS, or the one that comes with NetCore SDK 2.0.0)
```

**Workaround:**
Use Visual Studio (2017 15.3 or later) or NuGet.exe (v4.3.0 or later)
Delete your disabled source and continue to use msbuild or dotnet.exe.
For your solution, you could use "Clear" in NuGet.config and then define the sources necessary for that solution.

## RHEL and the Runtime Package Store

Runtime Package Store is not available by default on Red Hat Enterprise Linux.

Description and work arounds in <https://github.com/dotnet/designs/issues/10>
Other details in <https://github.com/aspnet/Coherence-Signed/issues/428> and <https://github.com/aspnet/MetaPackages/issues/149>

## Orphaned fallback folder in the user directory from Preview installation

The NuGetFallback folder location was changed after Preview 2. Previously it could be found in the user directory and it has moved to the SDK directory. Projects created using a .NET Core Preview release may still reference this previous location in the nuget.config and should be deleted.

More info: [dotnet/cli/issues/7416](https://github.com/dotnet/cli/issues/7416)

## Minimum NETCore.App requirements for .NET Core  CLI

Because the .NET Core CLI itself is a .NET Core application, it has minimum version requirements for NETCore.App.

* .NET CLI 1.0 -> NETCore.App 1.0.5
* .NET CLI 2.0 -> NETCore.App 1.1.2

## Visual Studio for the Mac

[Visual Studio for the Mac](https://www.visualstudio.com/vs/visual-studio-mac/) 7.1 (build 1297) was recently released and supports .NET Core 2.0.

## NETStandard 2.0 and the .NET Framework

When referencing a NETStandard2.0 library from a .NETFramework application you must add a reference to the NETStandard.Library.NETFramework package to the .NETFramework project.

## .NET Core 2.0 and Visual Studio 2017 15.3

[Known issues in Visual Studio](https://github.com/aspnet/Tooling/blob/master/known-issues-vs2017.md)

## Preview issues which have been resolved

### Running 1.0 first run experience after installing 2.0 CLI

[https://github.com/dotnet/cli/issues/6550](https://github.com/dotnet/cli/issues/6550)

This fails because the 1.0 first run shells out two dotnet commands to do dotnet new and dotnet restore. Because this is a simple shell out, the 2.0 CLI ends up being picked up to execute the commands. However, in the 1.0 CLI, we invoke dotnet new passing –f netcoreapp1.0 and netcoreapp1.1 and the 2.0 CLI no longer carries these templates, which causes the command and the whole first run to fail.

#### Workarounds

* Run dotnet 1.0 first run experience before installing the 2.0 CLI by simply invoking 'dotnet new' in the command line after installing VS.
* Uninstalling the 2.0 CLI and then running 'dotnet new'.
* Putting a global.json pointing t 1.0 CLI in the root of the drive where you are executing the 1.0 command to trigger first run. Remember to remove it after the first run has been executed.
* Do nothing, in which case the first run will continue to run for 1.0 CLI and restore will hit the web.

### VB and .NET Core

There are a few issues with using VB and .NET Core to be aware of.

#### System.Data namespace contains no types warning

[https://github.com/dotnet/sdk/pull/1188](https://github.com/dotnet/sdk/pull/1188)

Creating a console\class library will build successfully but with a warning that System.Data namespace contains no types.

##### Workaround

Adding `<NoWarn>$(NoWarn),40057</NoWarn>` to the project will suppress the warning.

#### Packing a VB Library does not work

[https://github.com/NuGet/Home/issues/4886](https://github.com/NuGet/Home/issues/4886)

##### Workaround

Adding `<PackProjectInputFile>$(MSBuildProjectFile)</PackProjectInputFile>` to your `.vbproj` file and then invoking the Pack command will produce a package.

#### Unit Test Templates Do Not Exist

Unit test templates don’t exist in Preview 1 because test discovery fails for VB projects. This issue is under investigation and there is no workaround at this time.

#### Visual Studio Code

If you want to try .NET Core 2.0 with Visual Studio Code, you will need to use an updated C# Extension.

1. If you haven't already, install [Visual Studio Code](https://code.visualstudio.com).
1. Download the VSIX for the [latest C# Extension](https://github.com/OmniSharp/omnisharp-vscode/releases/download/v1.12.1/csharp-1.12.1.vsix).

If you try out the C# for VS Code bits and find any issues, please file them at [OmniSharp/omnisharp-vscode](https://github.com/OmniSharp/omnisharp-vscode/issues).
