# Release Notes

## .NET Core 2.0.0 Preview 1 released 5/10/2017

.NET Core 2.0.0 Preview 1 and SDK 2.0.0 Preview 1 are available for download and testing. These can be found on [.NET Core Preview 1](https://dotnet.microsoft.com/download/dotnet) or the [Preview 1 download page](https://github.com/dotnet/core/blob/main/release-notes/download-archives/2.0.0-preview1-download.md).

The .NET Core SDK 2.0.0-Preview 1 includes .NET Core 2.0.0-Preview 1 runtime so downloading the runtime packages separately is not needed when installing the SDK.

You can see details for other areas of the release in the [.NET Blog](https://devblogs.microsoft.com/dotnet/) and have a look at [.NET Core 2.0.0 Preview 1 Known Issues](2.0.0-preview1-known-issues.md) document as there are a few things to be aware of before installing.

We've created [dotnet/core #640](https://github.com/dotnet/core/issues/640) for your questions and comments.

## .NET Core 2.0.0 Preview 1 Highlights

### .Net Standard 2.0 support is built into .NET Core 2.0.0

You can visit the following locations to learn more about .NET Standard.

* [Introducing .NET Standard](https://devblogs.microsoft.com/dotnet/introducing-net-standard/)
* [Channel 9 Discussion](https://channel9.msdn.com/Shows/On-NET/Immo-Landwerth-Net-Standard)
* [.NET Standard 2.0 API list](https://github.com/dotnet/standard/blob/release/3.0/docs/versions/netstandard2.0.md)

### Linux Binaries

The 'generic' Linux binary archives are new for the 2.0 release. This package contains binaries which are compatible with [Linux distros and versions supported by .NET Core](https://github.com/dotnet/core/blob/main/roadmap.md). This will also enable you to experiment with Distros not present on the supported list but are libc compatible.

### OpenSSL is no longer needed on OSX

We have made changes to the crypto libraries to take advantage of services available natively in macOS.

### Runtime Package Store

The runtime package store enables creating a precompiled cache of common libraries which can be centrally provisioned and not deployed to every application reducing deployment size and time.

### Separate Host Executables

Portable and Standalone applications now use separate host executables. This enables developers building Standalone applications to sign the host executable with their publisher signature.

### And even more

* Portable binary archives for all platforms
* Support for Linux Arm builds
* Windows Arm32 and Arm64 builds

## .NET Core 2.0.0-Preview1 Symbol Packages

Symbol packages for .NET Core 2.0.0-Preview 1 are available for download from the following locations.

* [CoreCLR](https://go.microsoft.com/fwlink/?LinkID=848978)
* [CoreFX](https://go.microsoft.com/fwlink/?LinkID=848983)

### Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. See the new image names below.

#### Runtime

* 2.0.0-Preview1-runtime
* 2.0.0-Preview1-runtime-nanoserver

#### SDK

* 2.0.0-Preview1-sdk
* 2.0.0-Preview1-sdk-nanoserver

### WCF

* Please see the [WCF release page](https://github.com/dotnet/wcf/releases/tag/v2.0.0-preview1) for details on fixes from the WCF team.

### ASP.NET Core

* Please see the [ASP.NET Core release page](https://github.com/aspnet/home/releases/2.0.0-preview1) for details on fixes from ASP.NET Core, MVC, Entity Framework Core and others.
