# .NET Core 2.0 November Update - November 14, 2017

.NET Core 2.0.3 and SDK 2.0.3 are available for download and usage in your environment.

* [Announcement](https://devblogs.microsoft.com/dotnet/net-core-november-2017-update/)
* [Getting Started](https://dotnet.microsoft.com/download)
* [Downloads](https://github.com/dotnet/core/blob/main/release-notes/download-archives/2.0.3.md)

The .NET Core SDK 2.0.3 includes .NET Core 2.0.3 Runtime so downloading the runtime packages separately is not needed when installing the SDK. After installing the .NET Core SDK 2.0.3, the following command will show that you're running version `2.0.3` of the tools.

`dotnet --version`

Your feedback is important and appreciated. We've created [dotnet/core #1082](https://github.com/dotnet/core/issues/1082) for your questions and comments.

## Azure AppServices

Deployment of .NET Core 2.0 support on Azure AppServices is in process. Because AppServices is a high availability service, the deployment is carefully staged across regions over a period of time. Deployment will begin in the West US 2 and North Central US regions with remaining regions following over few days.

## .NET Core 2.0 Highlights

### Security Advisories

Microsoft is releasing security advisories for .NET Core and ASP.NET Core. Details can be found in corresponding announcements in the [.NET Core](https://github.com/dotnet/announcements/issues?q=is%3Aopen+is%3Aissue+label%3ASecurity) and [ASP.NET Core](https://github.com/aspnet/announcements/issues?q=is%3Aopen+is%3Aissue+label%3ASecurity) repos.

#### CVE-2017-8585 Malformed Certificate can cause Denial of Service

Microsoft is aware of a security vulnerability in .NET Core 1.0, 1.1 and 2.0 where a malformed certificate or other ASN.1 formatted data could lead to a denial of service via an infinite loop on Linux and macOS.

System administrators are advised to update their .NET Core runtimes to versions 1.0.8, 1.1.5 and 2.0.1. Developers are advised to update their .NET Core SDK to version 2.0.3 or 1.1.5.

#### CVE-2017-11879: Open Redirect can cause Elevation Of Privilege

Microsoft is aware of a security vulnerability in ASP.NET Core 2.0 where an Open Redirect exists, leading to Elevation Of Privilege.

#### CVE-2017-11770: Denial Of Service Vulnerability

Microsoft is aware of a security vulnerability in ASP.NET Core 1.0, 1.1 and 2.0 where the application is hosted through Windows Http.Sys where a malformed request can lead to a Denial Of Service.

### RHEL 6 support

[Runtime tarballs](https://download.microsoft.com/download/5/C/1/5C190037-632B-443D-842D-39085F02E1E8/dotnet-runtime-2.0.3-rhel.6-x64.tar.gz) are now available for use on Red Hat Enterprise Linux 6.

### Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Look for the 2.0.3 images.

## ASP.NET Core

Please see the [ASP.NET Core release notes](https://github.com/aspnet/Home/releases/tag/2.0.3) and [ASP.NET Core](https://devblogs.microsoft.com/dotnet/announcing-asp-net-core-2-0/) for highlights on work from ASP.NET Core, MVC, Entity Framework Core and others.

## Fixes in the November 2017 Update

## CLI

* [`[8a60d17]`](https://github.com/dotnet/cli/commit/8a60d17) Update F# compiler to match VS
* [`[6ef8af7]`](https://github.com/dotnet/cli/commit/6ef8af7) update fsharp compiler for preview release
* [`[4a2d3fa]`](https://github.com/dotnet/cli/commit/4a2d3fa) Fix up roslyn satellite assembly handling to match new insertion mechanism
* [`[6ccff28]`](https://github.com/dotnet/cli/commit/6ccff28) Update F# compiler
* [`[fb67e25]`](https://github.com/dotnet/cli/commit/fb67e25) MSBuild 15.5.110

## CoreCLR

* [`[2a5b736]`](https://github.com/dotnet/coreclr/commit/2a5b736) Workaround GetSystemTimePreciseAsFileTime inaccuracies (#14283) (#14319)
* [`[ccfa884]`](https://github.com/dotnet/coreclr/commit/ccfa884) Change base of literals in k-nucleotide-9
* [`[6f1b778]`](https://github.com/dotnet/coreclr/commit/6f1b778) Port to 2.0.0 - Fix ARM32 secure delegate bug
* [`[1504504]`](https://github.com/dotnet/coreclr/commit/1504504) Add SkipCreateWindowsPdbsFromPortablePdbs=true (#13925)
* [`[76accdf]`](https://github.com/dotnet/coreclr/commit/76accdf) Merge pull request #13845 from ViktorHofer/DBNull-Serialization
* [`[8f5f8dc]`](https://github.com/dotnet/coreclr/commit/8f5f8dc) Change FinalizerThreadCreate location to after profiler is initialized (#13663)
* [`[c9af4b3]`](https://github.com/dotnet/coreclr/commit/c9af4b3) Complete and fix cgroup cpu and memory limiting
* [`[0108cb0]`](https://github.com/dotnet/coreclr/commit/0108cb0) Delete superfluous check in funceval.cpp
* [`[01cd728]`](https://github.com/dotnet/coreclr/commit/01cd728) Remove EOL openSuSE 42.1 (#13692)
* [`[a308bfc]`](https://github.com/dotnet/coreclr/commit/a308bfc) Remove FreeBSD 10.1 (#13636)
* [`[0caee95]`](https://github.com/dotnet/coreclr/commit/0caee95) Don't multiply YieldProcessor count by proc count (#13556)
* [`[0ee7d4a]`](https://github.com/dotnet/coreclr/commit/0ee7d4a) Parameterize RIDs for package restore
* [`[3512bb3]`](https://github.com/dotnet/coreclr/commit/3512bb3) Restore missing native *.ni.pdb file from the Microsoft.NETCore.Runtime.CoreCLR (#12677)
* [`[b6abc16]`](https://github.com/dotnet/coreclr/commit/b6abc16) Fixed issue #13282: dbgshim fails with E_ACCESSDENIED on Windows.
* [`[b2c377b]`](https://github.com/dotnet/coreclr/commit/b2c377b) JIT: Fix value type box optimization
* [`[0803236]`](https://github.com/dotnet/coreclr/commit/0803236) Don't map P-DEP SIMD12 local vars to SIMD16 on x64
* [`[d99bf2d]`](https://github.com/dotnet/coreclr/commit/d99bf2d) Removed the legacy JIT32 assert regarding 4-byte alignment inArenaAllocator::allocateMemory Immediately after this assert we roundUp to an pointer size allocation amount.
* [`[86d8a0c]`](https://github.com/dotnet/coreclr/commit/86d8a0c) Port "git clone" fixes to release 2.0.0 (#13467)
* [`[207515e]`](https://github.com/dotnet/coreclr/commit/207515e) Don't call AssemblyResolve event for CoreLib resources (#12999) (#13003)
* [`[94d4aa4]`](https://github.com/dotnet/coreclr/commit/94d4aa4) don't use r2r images when the profiler requests that ngen images are disabled (#13349)
* [`[4c1bc91]`](https://github.com/dotnet/coreclr/commit/4c1bc91) Fix non-portable parameters in build-packages.sh script
* [`[3b9ce14]`](https://github.com/dotnet/coreclr/commit/3b9ce14) Add RH6 rid detections to build-packages.sh script
* [`[e7e64c8]`](https://github.com/dotnet/coreclr/commit/e7e64c8) Remove setting of LD_LIBRARY_PATH because we want to set it in docker image
* [`[384f815]`](https://github.com/dotnet/coreclr/commit/384f815) Correct the values of "Rid" and "TestContainerSuffix" of newly added entries.
* [`[c5e25ee]`](https://github.com/dotnet/coreclr/commit/c5e25ee) Add JitMinOpts throughput jobs
* [`[214d82d]`](https://github.com/dotnet/coreclr/commit/214d82d) Support COMPlus_JITMinOpts for crossgen
* [`[860e13d]`](https://github.com/dotnet/coreclr/commit/860e13d) Port of https://github.com/dotnet/coreclr/pull/13034 to release 2.0.0 -- Remove Ubuntu 16.10 as it's EOL (#13041)

## CoreFX

* [`[fedf648]`](https://github.com/dotnet/corefx/commit/fedf648) Fix ECDsa ExportParameters segfault
* [`[90b1641]`](https://github.com/dotnet/corefx/commit/90b1641) Fixed races in EventCounters.  Preped to add Dispose() method
* [`[653cb2f]`](https://github.com/dotnet/corefx/commit/653cb2f) Load the assembly from the same location as the type assembly (#22558) (#24128)
* [`[5105363]`](https://github.com/dotnet/corefx/commit/5105363) Add copyright header from Mono
* [`[b48403d]`](https://github.com/dotnet/corefx/commit/b48403d) Fix return value of partially successful Socket.Send (#24005)
* [`[f78432f]`](https://github.com/dotnet/corefx/commit/f78432f) release/2.0.0 - Make DBNull serializable and adding tests (#23961)
* [`[e297c0e]`](https://github.com/dotnet/corefx/commit/e297c0e) Address build error due to updates since 2.0
* [`[939e4a6]`](https://github.com/dotnet/corefx/commit/939e4a6) Only truncate to IOV_MAX for stream sockets (#23826)
* [`[fc29a3f]`](https://github.com/dotnet/corefx/commit/fc29a3f) Porting #23591 to release 2.0 branch.
* [`[6d38f59]`](https://github.com/dotnet/corefx/commit/6d38f59) Fix LargeArrayBuilder.CopyTo returning incorrect end-of-copy position (#23865)
* [`[fd5a525]`](https://github.com/dotnet/corefx/commit/fd5a525) WebRequest.DefaultWebProxy: Set doesn't work without a previous Get (#22798)
* [`[741cd3c]`](https://github.com/dotnet/corefx/commit/741cd3c) backport of REGEX_DEFAULT_MATCH_TIMEOUT (#23666)
* [`[bbfdddf]`](https://github.com/dotnet/corefx/commit/bbfdddf) Truncate sendmsg/recvmsg to IOV_MAX (#23781)
* [`[ec98bfd]`](https://github.com/dotnet/corefx/commit/ec98bfd) Fix handling of last number in IPv6 address
* [`[7868e54]`](https://github.com/dotnet/corefx/commit/7868e54) Add IPAddress parsing cases for components being too long
* [`[daae3e5]`](https://github.com/dotnet/corefx/commit/daae3e5) Fix output buffer assumptions in CSP symmetric transforms.
* [`[6febde9]`](https://github.com/dotnet/corefx/commit/6febde9) Handle EAGAIN in Console.Write (#23539)
* [`[fbdc453]`](https://github.com/dotnet/corefx/commit/fbdc453) Remove reference assemblies from NetFx netstandard support package
* [`[fe0e443]`](https://github.com/dotnet/corefx/commit/fe0e443) Remove EOL openSuSE 42.1 (#23683)
* [`[4df5884]`](https://github.com/dotnet/corefx/commit/4df5884) Eliminate OpenSuSE 13.2 (EOL) (#23623)
* [`[7592450]`](https://github.com/dotnet/corefx/commit/7592450) Harden DerSequenceReader against unsupported data.
* [`[9108063]`](https://github.com/dotnet/corefx/commit/9108063) Fix bug in MS.CSharp handling non-generic classes nested in generic (#22117)
* [`[d76ab29]`](https://github.com/dotnet/corefx/commit/d76ab29) Make 4.4.1 SqlClient harvest the 4.3.1 SqlClient package for its netstandard1.3 bits, since 4.3.0 SqlClient has a connection leak. (#23412)
* [`[725fc01]`](https://github.com/dotnet/corefx/commit/725fc01) Migrate corefx release/2.0.0 branch to git clone from VSO instead of unstable github (#23410)
* [`[8d7ff69]`](https://github.com/dotnet/corefx/commit/8d7ff69) Removed SNIMarsManager, and modified TdsParserStateObjectManaged so that it manages its own SNIMarsConnection if MARS is enabled. This prevents SNIMarsConnections from accumulating forever in a static SNIMarsManager singleton. (#22709) (#23357)
* [`[204cdd7]`](https://github.com/dotnet/corefx/commit/204cdd7) Enable RHEL6 in release/2.0.0 (#23084)
* [`[e1c7278]`](https://github.com/dotnet/corefx/commit/e1c7278) Remove Ubuntu 16.10 from test execution: OS was EOL'ed on 7/19/2017
