# .NET Core March 2018 Update - March 13, 2018

Microsoft is releasing security advisories for .NET Core and ASP.NET Core. Issues addressed by this update are summarized in the [fixes](#notable-fixes-and-commits) section below. Details can be found in corresponding announcements in the [.NET Core](https://github.com/dotnet/announcements/issues?q=is%3Aopen+is%3Aissue+label%3ASecurity) and [ASP.NET Core](https://github.com/aspnet/announcements/issues?q=is%3Aopen+is%3Aissue+label%3ASecurity) repos.

.NET Core 2.0.6 and SDK 2.1.101 are available for download and usage in your environment.

* [Getting Started](https://dotnet.microsoft.com/download)
* [Downloads](https://github.com/dotnet/core/blob/main/release-notes/download-archives/2.0.6-download.md)

The .NET Core SDK 2.1.101 includes .NET Core 2.0.6 Runtime so downloading the runtime packages separately is not needed when installing the SDK. After installing the .NET Core SDK 2.1.101, the following command will show that you're running version `2.1.101` of the tools.

`dotnet --version`

Your feedback is important and appreciated. We've created an issue at [dotnet/core #1341](https://github.com/dotnet/core/issues/1341) for your questions and comments.

## Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Look for the 2.0.6 images.

## Azure AppServices

Deployment of this update to Azure AppServices is in process. Because AppServices is a high availability service, the deployment is carefully staged across regions over a period of time. Deployment will begin in the West US 2 and North Central US regions with remaining regions following over a few days.

## Known Issues

### Windows Server Hosting bundle (`DotNetCore.2.0.6-WindowsHosting.exe`) does not contain the updated AspNetCore RuntimePackageStore

**Issue** `DotNetCore.2.0.6-WindowsHosting.exe` incorrectly contains the 2.0.5 AspNetCore RuntimePackageStore rather than 2.0.6.

**Resolution:** If you have already installed the broken installer, download and run the [new installer](https://go.microsoft.com/fwlink/?linkid=869674). You can verify the correct version is installed by checking this:

Open the Control Panel and navigate to “Uninstall a program”, or on Windows 10 open Windows settings and navigate to “Apps”.
Find the entry for `Microsoft .NET Core 2.0.6 – Windows Server Hosting`. This entry should show that version `2.0.40314.10011` is installed.

### Using Linux package managers to update `dotnet-host.x86_64` breaks .NET Core

**Issue:** Running the package manager `update` command on Linux systems where .NET Core has been previously installed may offer an update for `dotnet-host.x86_64`. If the update is allowed to proceed, .NET Core could be in a broken state as only the dotnet host is updated.

**Resolution:** To install the update, either the Runtime or SDK must be explicitly installed. e.g. `sudo [apt-get, yum, dnf, zypper] install dotnet-runtime-2.0.6`, if you only need the runtime or `sudo [apt-get, yum, dnf, zypper] dotnet-sdk-2.1.101`, to install both the SDK and Runtime.

We are working to improve our Linux packages to enable correct package manager update behavior. This work is being tracked in the following issues:

* [dotnet/core-setup/issues/3556](https://github.com/dotnet/core-setup/issues/3556)
* [dotnet/cli/issues/8209](https://github.com/dotnet/cli/issues/8209)

## Package and Binary updates

The following packages and binaries are updated by the March 2018 update:

* System.Private.Corelib
* Microsoft.NETCore.Runtime.CoreCLR
* Microsoft.NETCore.Jit

## Notable Fixes and Commits

### CVE-2018-0875 - Hash Collision can cause Denial of Service

Microsoft is aware of a security vulnerability in the public versions of .NET Core where a malicious file or web request could cause a denial of service (DoS) attack. See the following announcement for details.

[CVE-2018-0875](https://github.com/dotnet/announcements/issues/62)

### Commits

#### CoreFX

* [`[7ff205b]`](https://github.com/dotnet/corefx/commit/7ff205b) Fix for SqlConnection failure when having multiple concurrent users (#26247)
* [`[4d66ecf]`](https://github.com/dotnet/corefx/commit/4d66ecf) Performance issue fix for manged sni (#26244)
* [`[25b6570]`](https://github.com/dotnet/corefx/commit/25b6570) Fix XmlSerializer packaging break (#25799)
* [`[7751d09]`](https://github.com/dotnet/corefx/commit/7751d09) Enable ECDH cipher suites as preferred cipher for key agreement.
* [`[804c756]`](https://github.com/dotnet/corefx/commit/804c756) Ensure HttpListener request buffer is aligned as required by the host processor (#25763)
* [`[97ce4b6]`](https://github.com/dotnet/corefx/commit/97ce4b6) Revert "Minor change to avoid an allocation in Uri" (#25643)
* [`[0933a23]`](https://github.com/dotnet/corefx/commit/0933a23) Port 2 fixes for NamedPipeClientStream (#26118)
* [`[dcdf47c]`](https://github.com/dotnet/corefx/commit/dcdf47c) fix sgen if/else issue (#25562)
* [`[e2f8be3]`](https://github.com/dotnet/corefx/commit/e2f8be3) Support Reference Assemblies in SGEN. (#24491)
* [`[0a129de]`](https://github.com/dotnet/corefx/commit/0a129de) Ignore the type if it contains any property that only have private setter. (#24611)
* [`[3e437ec]`](https://github.com/dotnet/corefx/commit/3e437ec) Make the public class be internal in sgen. (#24345)
* [`[cac0f6a]`](https://github.com/dotnet/corefx/commit/cac0f6a) Add more parameters support in SGEN. (#24322)
* [`[8d2753e]`](https://github.com/dotnet/corefx/commit/8d2753e) Remove the line that will copy the generated serializer to the pack. (#24199)
* [`[0e29bf8]`](https://github.com/dotnet/corefx/commit/0e29bf8) Add the target to copy the serializer to publish folder. (#24096)
* [`[e82739f]`](https://github.com/dotnet/corefx/commit/e82739f) Add warning by default in SGEN (#24054)
* [`[31a21dd]`](https://github.com/dotnet/corefx/commit/31a21dd) Add help method for SGEN. (#23966)
* [`[c2704a6]`](https://github.com/dotnet/corefx/commit/c2704a6) Add /casesensitive parameter so the command works on linux when the path contains capital letter (#23947)
* [`[d980557]`](https://github.com/dotnet/corefx/commit/d980557) Allow copy-local ReferenceFromRuntime
* [`[d675870]`](https://github.com/dotnet/corefx/commit/d675870) Improve Sgen package for better customer experience (#23348)
* [`[97076d8]`](https://github.com/dotnet/corefx/commit/97076d8) Fix the sgen issue when use NaN as the default value.  (#23366)
* [`[0a73abd]`](https://github.com/dotnet/corefx/commit/0a73abd) WarningsAsErrors and DisabledWarnings are not boolean. (#23335)
* [`[fe96f3b]`](https://github.com/dotnet/corefx/commit/fe96f3b) Use stream as the input of GenerateSerializer method (#19862)

#### CoreCLR

* [`[381e6b1]`](https://github.com/dotnet/coreclr/commit/381e6b1) Fix SIGSEGV in EventPipe on Shutdown (#14123) (#15765)
* [`[b5c6996]`](https://github.com/dotnet/coreclr/commit/b5c6996) Port COMException fix from master (#15735)
* [`[4efa38d]`](https://github.com/dotnet/coreclr/commit/4efa38d) Make EventArgs base class serializable (#15541) (#15686)
* [`[7621d45]`](https://github.com/dotnet/coreclr/commit/7621d45) Fix source/line info on Windows for Windows PDBs. (#14696) (#15255)
* [`[872b9d9]`](https://github.com/dotnet/coreclr/commit/872b9d9) JIT: port fix to defer removing statements during opt CSE to release/2.0.0 (#15360)
* [`[216aa4a]`](https://github.com/dotnet/coreclr/commit/216aa4a) Fix sos/dac long named dlls (#15583)
