# .NET Core April 2018 Update - April 17, 2018

Microsoft is releasing updates for .NET Core and ASP.NET Core. Issues addressed by this update are summarized in the [fixes](#notable-fixes-and-commits) section below.

.NET Core 2.0.7 and SDK 2.1.105 are available for download and usage in your environment.

* [Getting Started](https://dotnet.microsoft.com/download)
* [Downloads](https://github.com/dotnet/core/blob/main/release-notes/download-archives/2.0.7-download.md)

The .NET Core SDK 2.1.105 includes .NET Core 2.0.7 Runtime so downloading the runtime packages separately is not needed when installing the SDK. After installing the .NET Core SDK 2.1.105, the following command will show that you're running version `2.1.105` of the tools.

`dotnet --version`

Your feedback is important and appreciated. We've created an issue at [dotnet/core #1452](https://github.com/dotnet/core/issues/1452) for your questions and comments.

## Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Look for the 2.0.7 images.

## Azure AppServices

Deployment of this update to Azure AppServices is in process. Because AppServices is a high availability service, the deployment is carefully staged across regions over a period of time. Deployment will begin in the West US 2 and North Central US regions with remaining regions following over a few days.

## Known Issues

### Windows Server Hosting bundle (`DotNetCore.2.0.7-WindowsHosting.exe`) does not contain the updated AspNetCore RuntimePackageStore

**Issue** `DotNetCore.2.0.7-WindowsHosting.exe` incorrectly contains the 2.0.5 AspNetCore RuntimePackageStore rather than 2.0.7.

**Resolution:** If you have already installed the broken installer, download and run the [new installer](https://go.microsoft.com/fwlink/?linkid=869674). You can verify the correct version is installed by checking this:

Open the Control Panel and navigate to “Uninstall a program”, or on Windows 10 open Windows settings and navigate to “Apps”.
Find the entry for `Microsoft .NET Core 2.0.7 – Windows Server Hosting`. This entry should show that version `2.0.40314.10011` is installed.

### Using Linux package managers to update `dotnet-host.x86_64` breaks .NET Core

**Issue:** Running the package manager `update` command on Linux systems where .NET Core has been previously installed may offer an update for `dotnet-host.x86_64`. If the update is allowed to proceed, .NET Core could be in a broken state as only the dotnet host is updated.

**Resolution:** To install the update, either the Runtime or SDK must be explicitly installed. e.g. `sudo [apt-get, yum, dnf, zypper] install dotnet-runtime-2.0.7`, if you only need the runtime or `sudo [apt-get, yum, dnf, zypper] dotnet-sdk-2.1.105`, to install both the SDK and Runtime.

We are working to improve our Linux packages to enable correct package manager update behavior. This work is being tracked in the following issues:

* [dotnet/core-setup/issues/3556](https://github.com/dotnet/core-setup/issues/3556)
* [dotnet/cli/issues/8209](https://github.com/dotnet/cli/issues/8209)

## Package and Binary updates

The following packages and binaries are updated by the April 2018 update:

* System.Console
* System.Private.Corelib
* Microsoft.NETCore.Runtime.CoreCLR
* libcoreclr.so
* libdbgshim.so
* libmscordac.so
* libjit.so
* crossgen
* ilasm
* ildasm

## Notable Fixes and Commits

### CoreFX

* [`[522373a]`](https://github.com/dotnet/corefx/pull/27614/commits/522373a4bf70f6ec69f41a2681394f4167341364) : Adding support for ncurses 6.1 TERM format on System.Console.

### CoreCLR

* [`[45c57cc]`](https://github.com/dotnet/coreclr/pull/16577/commits/45c57cc0daf228856ae48d60ff25c76a6ce83983) : Fix detection of YMM regs presence
* [`[802ca8c]`](https://github.com/dotnet/coreclr/pull/16756/commits/802ca8cfa424838003c2a61a5d17f78fcabe042b) : Remove flock *usage from InternalCreateFile in PAL
* [`[d40ce91]`](https://github.com/dotnet/coreclr/pull/16152/commits/d40ce91ca58387b62456fb137aa829d8c3ceed6c) : Fix SIGSEGV in EventPipe on Shutdown
* [`[06a1cd1]`](https://github.com/dotnet/coreclr/pull/15444/commits/06a1cd1223df9dfc190fd74603dbb9119636f554) : Fix uaf in DestroyThread function
