# Commits to .NET Core 2.1

This is a somewhat curated list of commits across the entire .NET Core 2.1 development cycle. Working on automation to scrub out the uninteresting listings but there is still a bit of noise. Will be working to make that process better in future releases.

* [CLI](#cli)
* [CoreCLR](#coreclr)
* [CoreFX](#corefx)
* [WCF](#wcf)

## CLI

* [`[1aae04f]`](https://github.com/dotnet/cli/commit/1aae04f) Accept DropSuffix as a boolean
* [`[1feaa03]`](https://github.com/dotnet/cli/commit/1feaa03) Fix incorrect default VSTest verbosity level.
* [`[6b1b89a]`](https://github.com/dotnet/cli/commit/6b1b89a) Using ~ versions for dependencies of deb packages, so that we do the right thing when comparing release/pre-release package versions.
* [`[e9d0b15]`](https://github.com/dotnet/cli/commit/e9d0b15) Fixing deb native installer tests by installing packages using the package name instead of the file name.
* [`[e7cf325]`](https://github.com/dotnet/cli/commit/e7cf325) Using Major.Minor.Patch versions for rpm packages dependencies.
* [`[a3879f8]`](https://github.com/dotnet/cli/commit/a3879f8) Updating the deb package of the SDK to specify a version range for the runtime and asp.net dependencies.
* [`[4de0043]`](https://github.com/dotnet/cli/commit/4de0043) Updating the RPM dependency version of asp.net core to the full version, when it gets written to the metadata file.
* [`[e60d0a7]`](https://github.com/dotnet/cli/commit/e60d0a7) Making the CLI package name be only major.minor version and updating the version of the runtime packages that we depend on.
* [`[0f0f70c]`](https://github.com/dotnet/cli/commit/0f0f70c) Fix adding tools directory to PATH for native installers.
* [`[488711b]`](https://github.com/dotnet/cli/commit/488711b) Removing the word please from the ASP.NET first run message. We are not supposed to use it.
* [`[8c2160b]`](https://github.com/dotnet/cli/commit/8c2160b) Removing some patches for source build.
* [`[0f44059]`](https://github.com/dotnet/cli/commit/0f44059) Allow ExternalRestoreSources in offline build
* [`[46d4b71]`](https://github.com/dotnet/cli/commit/46d4b71) Add additional tools to help text
* [`[c382932]`](https://github.com/dotnet/cli/commit/c382932) Fix #if to match .csproj constant
* [`[57d065e]`](https://github.com/dotnet/cli/commit/57d065e) Correct dotnet list description (#9174)
* [`[d681933]`](https://github.com/dotnet/cli/commit/d681933) Rename --source-feed to --add-source (#9164)
* [`[ba68037]`](https://github.com/dotnet/cli/commit/ba68037) Do not disable bundled aspnet templates
* [`[b0c5fdd]`](https://github.com/dotnet/cli/commit/b0c5fdd) Add a property to disable bundling ASP.NET Core tools, templates, and runtimes
* [`[47a65f2]`](https://github.com/dotnet/cli/commit/47a65f2) LOC CHECKIN | dotnet/cli release/2.1.3xx | 20180427
* [`[b2b3947]`](https://github.com/dotnet/cli/commit/b2b3947) Fix Razor server shutdown on Windows.
* [`[7ff4f27]`](https://github.com/dotnet/cli/commit/7ff4f27) Update readme: alpine-\<ver>-targz to musl-targz
* [`[7b635e7]`](https://github.com/dotnet/cli/commit/7b635e7) Use cp -u on linux-musl
* [`[535cac7]`](https://github.com/dotnet/cli/commit/535cac7) Explicitly note whether the package version props is being overridden It's difficult to tell today whether the package version props is correctly passed and used in some scenarios.  Make it more explicit.
* [`[b959791]`](https://github.com/dotnet/cli/commit/b959791) Fix --source-feed option for tool install and update commands.
* [`[2479376]`](https://github.com/dotnet/cli/commit/2479376) Fix a release/2.1.3xx baseline error: error NU1605: Detected package downgrade: Microsoft.NETCore.App from 2.1.0-rc1-26423-06 to 2.1.0-rc1-26420-08
* [`[74ee6b6]`](https://github.com/dotnet/cli/commit/74ee6b6) Download 'linux-musl-x64' shared framework assets when building 'linux-musl-x64'
* [`[4dc5eb7]`](https://github.com/dotnet/cli/commit/4dc5eb7) Do not sign the CLI NuPkgs - they do not ship.
* [`[6d353a5]`](https://github.com/dotnet/cli/commit/6d353a5) Mark both NuPkgs as "NonShipping=true"
* [`[1e30cf3]`](https://github.com/dotnet/cli/commit/1e30cf3) Add temporary feed to boot-strap linux-musl build
* [`[4a59d83]`](https://github.com/dotnet/cli/commit/4a59d83) Update the readme to the new build definition
* [`[65d5730]`](https://github.com/dotnet/cli/commit/65d5730) Replace alpine with linux-musl builds
* [`[1ade191]`](https://github.com/dotnet/cli/commit/1ade191) Implement Razor server discovery by pid file.
* [`[34060d3]`](https://github.com/dotnet/cli/commit/34060d3) pick up nuget loc (#9090)
* [`[3f1ab37]`](https://github.com/dotnet/cli/commit/3f1ab37) Rename buildserver command.
* [`[7d37548]`](https://github.com/dotnet/cli/commit/7d37548) Sign the 'nupkg' files; CLI:release/2.1.3xx (#9086)
* [`[854feef]`](https://github.com/dotnet/cli/commit/854feef) Give a different error to guide use to install via global tools (#9070)
* [`[617551d]`](https://github.com/dotnet/cli/commit/617551d) Update latest patch versions of .NET Core runtime
* [`[fd66168]`](https://github.com/dotnet/cli/commit/fd66168) Error message has instruction to help investigate from NuGet error message
* [`[b0610b9]`](https://github.com/dotnet/cli/commit/b0610b9) Add doc link for both dotnet-tool and dotnet-buildserver
* [`[6851961]`](https://github.com/dotnet/cli/commit/6851961) Better help text on `dotnet tool`
* [`[da0ac9a]`](https://github.com/dotnet/cli/commit/da0ac9a) Add back 'nuget-build' feed for: NuGet.Versioning 4.7.0-rtm.5081
* [`[7f2554c]`](https://github.com/dotnet/cli/commit/7f2554c) Slight re-ordering...
* [`[3d7ff40]`](https://github.com/dotnet/cli/commit/3d7ff40) Add back 'Roslyn' feed for: Microsoft.NETCore.Compilers 2.8.0-beta4-62811-05
* [`[ea90e58]`](https://github.com/dotnet/cli/commit/ea90e58) Trim back the 'unnecessary' nuget feeds.
* [`[07a15f9]`](https://github.com/dotnet/cli/commit/07a15f9) Terminate the 'StartsWith' string in the badge existence check. (#9049)
* [`[996eb6c]`](https://github.com/dotnet/cli/commit/996eb6c) Dotnet install-script updates (#9033)
* [`[18dd810]`](https://github.com/dotnet/cli/commit/18dd810) Removing the explicit dependency on System.Diagnostics.Process from Cli.Utils. Use the assembly from netstandard.
* [`[82a85aa]`](https://github.com/dotnet/cli/commit/82a85aa) Updating the dev-certs message displayed in the first run experience.
* [`[5cdfca4]`](https://github.com/dotnet/cli/commit/5cdfca4) LOC CHECKIN | dotnet/cli master | 20180409
* [`[2f01bb4]`](https://github.com/dotnet/cli/commit/2f01bb4) Add TryGetMostFitRuntimeIdentifier (#8997)
* [`[cbd6434]`](https://github.com/dotnet/cli/commit/cbd6434) Adapt to no config file Apphost shim
* [`[8fa1c82]`](https://github.com/dotnet/cli/commit/8fa1c82) Align dotnetcli with VS2017.4 compiler
* [`[9706863]`](https://github.com/dotnet/cli/commit/9706863) Disabling msbuild node reuse for CLI full build.
* [`[b6174af]`](https://github.com/dotnet/cli/commit/b6174af) Implement `dotnet publish --no-build`
* [`[ed35c63]`](https://github.com/dotnet/cli/commit/ed35c63) [Arm64] Enable arm64 cli builds
* [`[674f64c]`](https://github.com/dotnet/cli/commit/674f64c) Insert Testplatform 15.7 RTM package in dotnet SDK
* [`[1909074]`](https://github.com/dotnet/cli/commit/1909074) Fix failure to add tools path on restricted Windows environments.
* [`[0181c67]`](https://github.com/dotnet/cli/commit/0181c67) Fix validation of tool-path option for tool list and uninstall commands.
* [`[d3f69e2]`](https://github.com/dotnet/cli/commit/d3f69e2) Skip bundled dotnet tools (#8977)
* [`[ef389bb]`](https://github.com/dotnet/cli/commit/ef389bb) Add null check for Environment.GetEnvironmentVariable (#8970)
* [`[de81fbe]`](https://github.com/dotnet/cli/commit/de81fbe) Removing the explicit dependency on System.Diagnostics.Process from Cli.Utils. Use the assembly from netstandard.
* [`[b1fca8c]`](https://github.com/dotnet/cli/commit/b1fca8c) Replacing the short form version of implicit msbuild parameters with longform ones.
* [`[1028950]`](https://github.com/dotnet/cli/commit/1028950) Replacing all implicit msbuild parameters from using a forward slash to using a dash.
* [`[7c37c9a]`](https://github.com/dotnet/cli/commit/7c37c9a) Changing the /m /v:m default parameters to msbuild to -m and -v:m to avoid confusing that with files on unix machines.
* [`[e70f071]`](https://github.com/dotnet/cli/commit/e70f071) Apphost shim (#8893)
* [`[208704e]`](https://github.com/dotnet/cli/commit/208704e) Modifying testAsset.props so that when loading DependencyVersions.props, we also load OrchestratedPackageVersions.props if it exists. This fixes cases where a single project ended up being restored and built with different versions of Microsoft.NetCore.App in ProdCon.
* [`[370243a]`](https://github.com/dotnet/cli/commit/370243a) Adding a work around for publishing self-contained apps to RIDs that are not available for Microsoft.NETCore.App 2.0.0.
* [`[c20f79e]`](https://github.com/dotnet/cli/commit/c20f79e) Reverse the order in which old runtime stores are listed
* [`[3488a84]`](https://github.com/dotnet/cli/commit/3488a84) Implement `buildserver shutdown` command.
* [`[ed8c0ac]`](https://github.com/dotnet/cli/commit/ed8c0ac) Improve error message when inable to generate deps.json for project tool
* [`[6e8355b]`](https://github.com/dotnet/cli/commit/6e8355b) Show arguments passed to MSBuild in verbose log when generating deps.json for DotNetCliToolReference
* [`[a974268]`](https://github.com/dotnet/cli/commit/a974268) Infer test packages path in tests if TEST_PACKAGES environment variable isn't set
* [`[9b68d55]`](https://github.com/dotnet/cli/commit/9b68d55) Moving the opensuse 43.2 docker file to the right folder.
* [`[8b1b153]`](https://github.com/dotnet/cli/commit/8b1b153) Add latest patch versions to BundledVersions.props, and tests to make sure that they are up to date
* [`[40cbb71]`](https://github.com/dotnet/cli/commit/40cbb71) Add a note on older version of pandoc
* [`[f807388]`](https://github.com/dotnet/cli/commit/f807388) Fix example in readme
* [`[ee24d81]`](https://github.com/dotnet/cli/commit/ee24d81) Add readme for tool and make script generic
* [`[d3a78f7]`](https://github.com/dotnet/cli/commit/d3a78f7) Add msbuild myget.org feed
* [`[2e9c0b7]`](https://github.com/dotnet/cli/commit/2e9c0b7) Add CLI docs build tools
* [`[b75de82]`](https://github.com/dotnet/cli/commit/b75de82) Reset loc to new
* [`[f949fb8]`](https://github.com/dotnet/cli/commit/f949fb8) Show version guide only when restore fails
* [`[f4b52ed]`](https://github.com/dotnet/cli/commit/f4b52ed) Fix CLI updating
* [`[67dafc9]`](https://github.com/dotnet/cli/commit/67dafc9) Updating latest links to release/2.1.3xx
* [`[c4f42d3]`](https://github.com/dotnet/cli/commit/c4f42d3) Adding a step to shutdown the vbcscompiler after test execution.
* [`[1043231]`](https://github.com/dotnet/cli/commit/1043231) Fix wrong instruction (#8922)
* [`[3e575f7]`](https://github.com/dotnet/cli/commit/3e575f7) Prevent default item globbing when evaluating run properties.
* [`[b250271]`](https://github.com/dotnet/cli/commit/b250271) Removing the dependency on the project.json CLI from the windows build scripts as well.
* [`[094a7b2]`](https://github.com/dotnet/cli/commit/094a7b2) Adding Fedora 27, OpenSuse 43.2 and Ubuntu 18.04 to the groovy file to enable these legs in CI.
* [`[04b3ff3]`](https://github.com/dotnet/cli/commit/04b3ff3) add xliff scenario
* [`[9b5a41f]`](https://github.com/dotnet/cli/commit/9b5a41f) updated xliff files
* [`[4856383]`](https://github.com/dotnet/cli/commit/4856383) Fix an 'unbound variable' warning.
* [`[6600612]`](https://github.com/dotnet/cli/commit/6600612) Adding new docker files for opensuse.42.3, ubuntu.18.04 and fedora.27 and removing the project.json CLI from the build. It was not being used anymore.
* [`[c551b88]`](https://github.com/dotnet/cli/commit/c551b88) added in use info to the --version option
* [`[01c1187]`](https://github.com/dotnet/cli/commit/01c1187) Better error message to guide user when there is only preview version in the feed (#8905)
* [`[76d4824]`](https://github.com/dotnet/cli/commit/76d4824) Add xml setting version warning (#8860)
* [`[510cff4]`](https://github.com/dotnet/cli/commit/510cff4) Enabling ubuntu.18.04,opensuse.42.3 and fedora.27 in dotnet-install script
* [`[29ac66f]`](https://github.com/dotnet/cli/commit/29ac66f) Keep stdout for test execution
* [`[d98928e]`](https://github.com/dotnet/cli/commit/d98928e) Keep stdout for test execution
* [`[efa717d]`](https://github.com/dotnet/cli/commit/efa717d) Bundle dotnet-ef
* [`[eec79d8]`](https://github.com/dotnet/cli/commit/eec79d8) Try shorter test names
* [`[e30fe29]`](https://github.com/dotnet/cli/commit/e30fe29) Fix project type GUIDs when adding projects to solution files.
* [`[39f0822]`](https://github.com/dotnet/cli/commit/39f0822) Updating InteropServices.Runtime to 4.3.0 in CLI utils and adding an explicit reference to netstandard 2.0 to TestFramework.
* [`[8d7009c]`](https://github.com/dotnet/cli/commit/8d7009c) Move some projects to netstandard2.0 (#8692)
* [`[bedf79f]`](https://github.com/dotnet/cli/commit/bedf79f) [WIP]TestPlatform 15.7 preview 3 insertion
* [`[c1fff96]`](https://github.com/dotnet/cli/commit/c1fff96) Update launch settings for ApplicationUrl handling
* [`[149bdfd]`](https://github.com/dotnet/cli/commit/149bdfd) Change command order for tools (#8862)
* [`[e4e665d]`](https://github.com/dotnet/cli/commit/e4e665d) LOC CHECKIN | cli master | 20180315
* [`[60d7161]`](https://github.com/dotnet/cli/commit/60d7161) Implement the --tool-path option for the list tool command.
* [`[4f8ac7d]`](https://github.com/dotnet/cli/commit/4f8ac7d) Ensure tool package store root is a full path.
* [`[cee0a3b]`](https://github.com/dotnet/cli/commit/cee0a3b) Better using facing string (#8809)
* [`[3ce2d4d]`](https://github.com/dotnet/cli/commit/3ce2d4d) Fix list tool command tests to be localizable.
* [`[ba8e18d]`](https://github.com/dotnet/cli/commit/ba8e18d) Fix #4139 - escape quoted strings for process start
* [`[f557859]`](https://github.com/dotnet/cli/commit/f557859) Updating NuGet to 4.6.1-rtm-5019
* [`[9cc2b7c]`](https://github.com/dotnet/cli/commit/9cc2b7c) Change --source to --source-feed and make it additional (#8833)
* [`[fe6d6fa]`](https://github.com/dotnet/cli/commit/fe6d6fa) Generate Microsoft.NETCoreSdk.BundledCliTools.props
* [`[f033eac]`](https://github.com/dotnet/cli/commit/f033eac) LOC CHECKIN | cli master | 20180315
* [`[95c0359]`](https://github.com/dotnet/cli/commit/95c0359) Implement the --tool-path option for the list tool command.
* [`[d3244e8]`](https://github.com/dotnet/cli/commit/d3244e8) Ensure tool package store root is a full path.
* [`[04ba0c9]`](https://github.com/dotnet/cli/commit/04ba0c9) Better using facing string (#8809)
* [`[470acd8]`](https://github.com/dotnet/cli/commit/470acd8) Alpine fix; plus 1 (#8821)
* [`[3f09a88]`](https://github.com/dotnet/cli/commit/3f09a88) Update tool (#8794)
* [`[30caede]`](https://github.com/dotnet/cli/commit/30caede) Fix list tool command tests to be localizable.
* [`[123df7f]`](https://github.com/dotnet/cli/commit/123df7f) Follow-up PR for Linux-arm; CLI:master (#8797)
* [`[a54f0ff]`](https://github.com/dotnet/cli/commit/a54f0ff) Enable 'arm' builds in the CLI (#8791)
* [`[c311381]`](https://github.com/dotnet/cli/commit/c311381) add nuget-build myget feed as source
* [`[dbcd830]`](https://github.com/dotnet/cli/commit/dbcd830) Creating and publishing 'symbols.nuget' to the blob feed. (#8712)
* [`[b0e57e1]`](https://github.com/dotnet/cli/commit/b0e57e1) Re-activate templating test.
* [`[02202c4]`](https://github.com/dotnet/cli/commit/02202c4) Fix #4139 - escape quoted strings for process start
* [`[3861fc1]`](https://github.com/dotnet/cli/commit/3861fc1) Convert to graceful exception (#8751)
* [`[52478e8]`](https://github.com/dotnet/cli/commit/52478e8) Stop modifying current working directory from test.
* [`[495630f]`](https://github.com/dotnet/cli/commit/495630f) when process has not env, but future will, show the instruction (#8739)
* [`[9da134c]`](https://github.com/dotnet/cli/commit/9da134c) Localizing portions of dotnet --info.
* [`[b8685be]`](https://github.com/dotnet/cli/commit/b8685be) Updating the dotnet --info message.
* [`[0598e6c]`](https://github.com/dotnet/cli/commit/0598e6c) tool-path option -- "Session tool" (#8716)
* [`[5ebbd61]`](https://github.com/dotnet/cli/commit/5ebbd61) Fix case sensitivity of tool package identifiers.
* [`[4490fd5]`](https://github.com/dotnet/cli/commit/4490fd5) Implement `list tool` command.
* [`[c7417a4]`](https://github.com/dotnet/cli/commit/c7417a4) Mirror tools package format change pass any as rid (#8695)
* [`[6072355]`](https://github.com/dotnet/cli/commit/6072355) Make the default verbosity for dotnet clean `normal`. This way we can get some meaningful output out of the command.
* [`[030b6b4]`](https://github.com/dotnet/cli/commit/030b6b4) Update 2.1 test templates to use the 15.7 preview 1 test SDK
* [`[d05a751]`](https://github.com/dotnet/cli/commit/d05a751) Update 2.0 test templates for the 15.7 test SDK
* [`[e7759ed]`](https://github.com/dotnet/cli/commit/e7759ed) Rename test to walk around test fail
* [`[4c36ae1]`](https://github.com/dotnet/cli/commit/4c36ae1) Latest versions
* [`[9c5c453]`](https://github.com/dotnet/cli/commit/9c5c453) Fixing the expected path to the generateDeps.proj file, now that the SDK moved away from the build folder.
* [`[80b4856]`](https://github.com/dotnet/cli/commit/80b4856) Edit readme
* [`[91fea0d]`](https://github.com/dotnet/cli/commit/91fea0d) ingest and publish rumtime agnostic package
* [`[3965ce7]`](https://github.com/dotnet/cli/commit/3965ce7) Updated core-setup
* [`[8a6a642]`](https://github.com/dotnet/cli/commit/8a6a642) 01
* [`[d00060d]`](https://github.com/dotnet/cli/commit/d00060d) Use core-setup version
* [`[6c0944a]`](https://github.com/dotnet/cli/commit/6c0944a) Update again
* [`[f9c40ce]`](https://github.com/dotnet/cli/commit/f9c40ce) Log Windows product type and installation type, and Linux libc version (#8688)
* [`[9ef4953]`](https://github.com/dotnet/cli/commit/9ef4953) Implement a printable table.
* [`[8f7b58d]`](https://github.com/dotnet/cli/commit/8f7b58d) Move some projects to netstandard2.0 (#8692)
* [`[78efe50]`](https://github.com/dotnet/cli/commit/78efe50) Update to the 15.6 RTM version of the test SDK in templates
* [`[2ff85cd]`](https://github.com/dotnet/cli/commit/2ff85cd) Update description of uninstall command to match install command.
* [`[c28f4a2]`](https://github.com/dotnet/cli/commit/c28f4a2) Pass any as rid (#8677)
* [`[6ea849b]`](https://github.com/dotnet/cli/commit/6ea849b) TestPlatform 15.7 preview insertion
* [`[abec8bb]`](https://github.com/dotnet/cli/commit/abec8bb) Updating the version of ASP.NET
* [`[53dcff5]`](https://github.com/dotnet/cli/commit/53dcff5) Adding a version property with the CLI version and a private preview property to BundledVersions.
* [`[49f0353]`](https://github.com/dotnet/cli/commit/49f0353) Fix loc test by using straight quotes
* [`[d383628]`](https://github.com/dotnet/cli/commit/d383628) Bundle dotnet-sql-cache and dotnet-user-secrets in the CLI
* [`[3c2c956]`](https://github.com/dotnet/cli/commit/3c2c956) LOC CHECKIN | cli master | 20180222
* [`[b8df89a]`](https://github.com/dotnet/cli/commit/b8df89a) Sign the MSBuildSdkResolver dll in standard nupkg (#8648)
* [`[9ef22b0]`](https://github.com/dotnet/cli/commit/9ef22b0) Tag non-shipping nupkg as 'NonShipping=true' in the manifest. (#8647)
* [`[78503f2]`](https://github.com/dotnet/cli/commit/78503f2) Set README.md links to master branch
* [`[aab9af7]`](https://github.com/dotnet/cli/commit/aab9af7) Implement uninstall tool command.
* [`[08f050c]`](https://github.com/dotnet/cli/commit/08f050c) bundled DotnetTool (#8606)
* [`[1aa9c3d]`](https://github.com/dotnet/cli/commit/1aa9c3d) Correct download location for nuget package archive (#8631)
* [`[e8f521c]`](https://github.com/dotnet/cli/commit/e8f521c) Stop re-targeting Roslyn to the CLI runtime. It will roll-forward to the CLI runtime (2.1.0) through minor version roll-forward if necessary.
* [`[3f2bdcf]`](https://github.com/dotnet/cli/commit/3f2bdcf) Fixing the URLs for the msbuildscript.tests to use the new asp.net runtime folder as well.
* [`[d823581]`](https://github.com/dotnet/cli/commit/d823581) Updating the lzma to use the new asp.net runtime location.
* [`[4810eff]`](https://github.com/dotnet/cli/commit/4810eff) Update ASP.NET version to 2.1.0-preview2-30106
* [`[635e749]`](https://github.com/dotnet/cli/commit/635e749) Updating links to point to 2.1.2xx builds
* [`[3e9346c]`](https://github.com/dotnet/cli/commit/3e9346c) Updating the branch info of 2.1.2xx.
* [`[dbce65d]`](https://github.com/dotnet/cli/commit/dbce65d) Fix README.md for 2.1.1xx (#8600)
* [`[e6cdfeb]`](https://github.com/dotnet/cli/commit/e6cdfeb) "ExternalRestoreSources" needs to be set in the docker container (#8602)
* [`[32eeb5d]`](https://github.com/dotnet/cli/commit/32eeb5d) Updating runtime to 2.0.6.
* [`[423c407]`](https://github.com/dotnet/cli/commit/423c407) Signing nupkg contents (Cli.Utils and MSBuildResolver) along with the rest of the compiled assemblies.
* [`[bc1fb44]`](https://github.com/dotnet/cli/commit/bc1fb44) Use satellites from roslyn package, not cli-deps-satellites
* [`[8fcbb63]`](https://github.com/dotnet/cli/commit/8fcbb63) Update to roslyn 2.7.0-beta3-62612-07 for 2.1.1xx
* [`[2a493c1]`](https://github.com/dotnet/cli/commit/2a493c1) Support TildeSlash expand (#8589)
* [`[aa90d8e]`](https://github.com/dotnet/cli/commit/aa90d8e) Port Kernel Version telemetry to preview1
* [`[82f9d6e]`](https://github.com/dotnet/cli/commit/82f9d6e) Do not create a directory with a trailing space; it cannot be deleted by conventional methods. (#8587)
* [`[43b84cf]`](https://github.com/dotnet/cli/commit/43b84cf) Adding roslyn to automatic dependency flow through maestro.
* [`[9789573]`](https://github.com/dotnet/cli/commit/9789573) Fixing update dependency by using the new APIs. We broke this when we updated the version of VersionTools.
* [`[b9e6906]`](https://github.com/dotnet/cli/commit/b9e6906) Adding a baseline with files to be excluded from sign check.
* [`[be228a4]`](https://github.com/dotnet/cli/commit/be228a4) Removing all references to a static 'aspnetpatch' Nuget.Config (#8556)
* [`[f050264]`](https://github.com/dotnet/cli/commit/f050264) Rename to BundledNETCorePlatformsPackageVersion (#8538)
* [`[b69d9bd]`](https://github.com/dotnet/cli/commit/b69d9bd) Updating the MSI Installation Note message. Also had to shift components around slightly to make it fit.
* [`[d3263aa]`](https://github.com/dotnet/cli/commit/d3263aa) Fixing recent CLI test failures around ASP.NETcore in the orchestrated build (#8553)
* [`[4ac4751]`](https://github.com/dotnet/cli/commit/4ac4751) The BuildTasksFeedTool version and the VersionTools version should be in sync to prevent incompatabilities between these two packages.
* [`[5fa558a]`](https://github.com/dotnet/cli/commit/5fa558a) Atomic install tool (#8518)
* [`[47da513]`](https://github.com/dotnet/cli/commit/47da513) Infrastructure updates: CLI:master -> release/2.1.3xx (#8541)
* [`[5ea7f68]`](https://github.com/dotnet/cli/commit/5ea7f68) Adding the VBCSCompiler to the list of signed files due to crossgen.
* [`[bc486e7]`](https://github.com/dotnet/cli/commit/bc486e7) Ensure ASP.NET Core is included in macos .pkg installer and update to 2.1.0-preview1-28226
* [`[e260e79]`](https://github.com/dotnet/cli/commit/e260e79) Fixing the recent CLI test failures around ASP.NETcore in the orchestrated build: adding a 'dotnet-corefxlab' feed. (#8536)
* [`[52c2f25]`](https://github.com/dotnet/cli/commit/52c2f25) Add Microsoft.NET.Sdk.Razor to the CLI
* [`[494c61f]`](https://github.com/dotnet/cli/commit/494c61f) Update the branch info to be correct for 2.1
* [`[f0be5cc]`](https://github.com/dotnet/cli/commit/f0be5cc) LOC CHECKIN | cli master | 20180202
* [`[7ebfdde]`](https://github.com/dotnet/cli/commit/7ebfdde) Add verbosity option to `install tool` command.
* [`[b1c7805]`](https://github.com/dotnet/cli/commit/b1c7805) [Fixes #8511] Update ASP.NET Core certificate installation message
* [`[b723352]`](https://github.com/dotnet/cli/commit/b723352) Adding roslyn to automatic dependency flow through maestro.
* [`[55eb8bb]`](https://github.com/dotnet/cli/commit/55eb8bb) replace string with FilePath (#8494)
* [`[3bf4751]`](https://github.com/dotnet/cli/commit/3bf4751) Excluding shared framework assemblies from the Roslyn folder in the SDK.
* [`[8649a5c]`](https://github.com/dotnet/cli/commit/8649a5c) Orchestrated final publish; CLI:master (#8504)
* [`[a52bd1a]`](https://github.com/dotnet/cli/commit/a52bd1a) Excluding shared framework assemblies from the Roslyn folder in the SDK.
* [`[7bee59f]`](https://github.com/dotnet/cli/commit/7bee59f) Fixing update dependency by using the new APIs. We broke this when we updated the version of VersionTools.
* [`[71f22a9]`](https://github.com/dotnet/cli/commit/71f22a9) The "${arg,,}" syntax works well on dev and Jenkins OSX machines but does not work correctly on VSO build machines [likely a lower version of bash on VSO machines]. Therefore, using 'awk' to transforming to lower case. (#8497)
* [`[3e35517]`](https://github.com/dotnet/cli/commit/3e35517) Repairing the first pass call to 'dotnet msbuild'; CLI:master (#8488)
* [`[f3b111d]`](https://github.com/dotnet/cli/commit/f3b111d) Build trigger commit.
* [`[067f98e]`](https://github.com/dotnet/cli/commit/067f98e) Updating the templates version to 1.0.0-beta3-20171117-314. We had it at an older version by mistake.
* [`[05052c0]`](https://github.com/dotnet/cli/commit/05052c0) Use rich mock to test InstallCommand (#8402)
* [`[954e2de]`](https://github.com/dotnet/cli/commit/954e2de) Fix non-fatal null exception when no extra parameters are passed.
* [`[b3c2414]`](https://github.com/dotnet/cli/commit/b3c2414) Update package reference
* [`[e5ac824]`](https://github.com/dotnet/cli/commit/e5ac824) Making a document only commit to trigger another build of the CLI.
* [`[579e847]`](https://github.com/dotnet/cli/commit/579e847) The orchestrated "PackageVersion" type variables should not be used in any of the 'proj' files of the built build tools under: "build_projects"
* [`[36c0113]`](https://github.com/dotnet/cli/commit/36c0113) Separate tool package and shim file location
* [`[7cba114]`](https://github.com/dotnet/cli/commit/7cba114) Add 2.0.5 ASP.NET store to native installers.
* [`[8cb01e2]`](https://github.com/dotnet/cli/commit/8cb01e2) LOC CHECKIN | cli - master | 20180112 (#8385)
* [`[d3e9059]`](https://github.com/dotnet/cli/commit/d3e9059) If 'OrchestratedPackageVersionsProps.props' is present, do not re-download the file every time 'Run-Build' or 'Build' is called.
* [`[9d5bd86]`](https://github.com/dotnet/cli/commit/9d5bd86) If the Nuget.config has already been generated, do not re-generate the file every time 'Run-Build' or 'Build' is called.
* [`[839eccb]`](https://github.com/dotnet/cli/commit/839eccb) MacOs HighSierra Fallback (#8437)
* [`[e752f2a]`](https://github.com/dotnet/cli/commit/e752f2a) Fix Windows servicing builds.
* [`[02a98d4]`](https://github.com/dotnet/cli/commit/02a98d4) [tools] Integrate NuGet (#8414)
* [`[c8bae2f]`](https://github.com/dotnet/cli/commit/c8bae2f) Simplify the tool_launcher to build for just one version of .NET Framework
* [`[fa47e95]`](https://github.com/dotnet/cli/commit/fa47e95) Generate a .NET Framework shim app in dotnet-install-tools on Windows instead of a batch script (#8384)
* [`[a9c4a1c]`](https://github.com/dotnet/cli/commit/a9c4a1c) Fixing the prefercliruntime asset
* [`[a64da01]`](https://github.com/dotnet/cli/commit/a64da01) Fix source option for install command.
* [`[331b58c]`](https://github.com/dotnet/cli/commit/331b58c) Should use a trailing space instead of a leading space; MSBuild thinks the '$ExtraParametersNoTargets' variable a switch instead of a string.
* [`[9641097]`](https://github.com/dotnet/cli/commit/9641097) Reintroducing: 'BlobStoragePartialRelativePath' as orchetrated build needs a prepended "assets" to the partial relative path.
* [`[5b5d69c]`](https://github.com/dotnet/cli/commit/5b5d69c) Adds Microsoft.Docker.Sdk to CLI
* [`[840acee]`](https://github.com/dotnet/cli/commit/840acee) Defend against forthcoming breaking change in SDK (#8409)
* [`[ab97a07]`](https://github.com/dotnet/cli/commit/ab97a07) Putting back 'docker' and 'stage0' parameters in the usage.
* [`[4f2ac3e]`](https://github.com/dotnet/cli/commit/4f2ac3e) Setting 'IsNotOrchestratedPublish' explictly to false; conditional clean-up.
* [`[d04e8c8]`](https://github.com/dotnet/cli/commit/d04e8c8) Don't use 'ParseBlobUrl'; use the original values.
* [`[3386db7]`](https://github.com/dotnet/cli/commit/3386db7) Create a manifest if performing an orchestrated build publish.
* [`[5b696e4]`](https://github.com/dotnet/cli/commit/5b696e4) Update help description for install command.
* [`[9dc9f4c]`](https://github.com/dotnet/cli/commit/9dc9f4c) Use "PushToBlobFeed" instead of "UploadToAzure"
* [`[2f26f10]`](https://github.com/dotnet/cli/commit/2f26f10) Fix missing package id error message for install tool command.
* [`[95a5bc7]`](https://github.com/dotnet/cli/commit/95a5bc7) Ensure that the 'SetAzureProps' target runs before 'BlobStoragePartialRelativePath' is used.
* [`[8caa7b9]`](https://github.com/dotnet/cli/commit/8caa7b9) Updating the channel to release/2.1.1xx. We can manually update release/2.0 if necessary, but LTS is always updated every time we release.
* [`[e7bd33b]`](https://github.com/dotnet/cli/commit/e7bd33b) Add "SDK" at the end of the orchestrated build blob drop point.
* [`[e8f7ddd]`](https://github.com/dotnet/cli/commit/e8f7ddd) Localization for tools work so far (#8251)
* [`[429f2fd]`](https://github.com/dotnet/cli/commit/429f2fd) Found a version of 'microsoft.dotnet.build.tasks.feed' that supports both parsing of the URL and the currrent Nupkg upload method: 2.1.0-prerelease-02312-02
* [`[fe89456]`](https://github.com/dotnet/cli/commit/fe89456) Add source option to install tool command.
* [`[6d9130d]`](https://github.com/dotnet/cli/commit/6d9130d) Simplify the 'index.json' removal.
* [`[a4afbc9]`](https://github.com/dotnet/cli/commit/a4afbc9) Updates the TestPlatform to 15.6.0-preview-20180109-01
* [`[aa458ec]`](https://github.com/dotnet/cli/commit/aa458ec) Strip off "index.json" before appending "assets"
* [`[bfb9322]`](https://github.com/dotnet/cli/commit/bfb9322) Enabling the publish of assets to 'orchestrated' blob storage.
* [`[65c88d8]`](https://github.com/dotnet/cli/commit/65c88d8) Disabling native installer tests whenever CLIBUILD_SKIP_TESTS is set to true.
* [`[b1cc035]`](https://github.com/dotnet/cli/commit/b1cc035) Variable name change.
* [`[878821a]`](https://github.com/dotnet/cli/commit/878821a) Consider case and "target" as possibilities.
* [`[2b3ade0]`](https://github.com/dotnet/cli/commit/2b3ade0) Use a multi-proc aware MSBuild logger (#8371)
* [`[12350c4]`](https://github.com/dotnet/cli/commit/12350c4) Fixing the line endings.
* [`[1ea48da]`](https://github.com/dotnet/cli/commit/1ea48da) Run-Build.sh/ps1 does not behave correctly when passing in a target.
* [`[08a369c]`](https://github.com/dotnet/cli/commit/08a369c) Prevent the ASP.NET certificate generation logic from running on the installers
* [`[7d2a4f6]`](https://github.com/dotnet/cli/commit/7d2a4f6) Backwards compat runtimes should not come from product construction sources
* [`[a2d2923]`](https://github.com/dotnet/cli/commit/a2d2923) Removing the UploadToLinuxPackageRepository task code and tests.
* [`[34ce5c5]`](https://github.com/dotnet/cli/commit/34ce5c5) Adding aspnet dev feed.
* [`[576405a]`](https://github.com/dotnet/cli/commit/576405a) Fix reference to renamed MSBuild variable
* [`[efa35bd]`](https://github.com/dotnet/cli/commit/efa35bd) Ignore failures due to incoherent dependencies on dotnet-runtime
* [`[5f77453]`](https://github.com/dotnet/cli/commit/5f77453) Removing a conditional...
* [`[ed0df1c]`](https://github.com/dotnet/cli/commit/ed0df1c) Removing extra 'LinuxDistrosNeedNativeInstaller' entries
* [`[7265105]`](https://github.com/dotnet/cli/commit/7265105) Update the README
* [`[ec3332d]`](https://github.com/dotnet/cli/commit/ec3332d) Update to 2.1.0-preview1-28031 and debian-agnostic aspnet installers
* [`[7a606a4]`](https://github.com/dotnet/cli/commit/7a606a4) Update SPA tests to skip npm-restore
* [`[0a58124]`](https://github.com/dotnet/cli/commit/0a58124) Correcting the 'RunInSandBoxAndPackage' target
* [`[14d701d]`](https://github.com/dotnet/cli/commit/14d701d) Publish the agnostic 'DEB' installer package to all three feeds.
* [`[5b33ba9]`](https://github.com/dotnet/cli/commit/5b33ba9) 'DEB' filename changes
* [`[c873c55]`](https://github.com/dotnet/cli/commit/c873c55) Produce one debian distro agnostic installer package.
* [`[95064f4]`](https://github.com/dotnet/cli/commit/95064f4) Update runtest.targets to skip file checks from azure if the filename variables are undefined
* [`[b6b53f1]`](https://github.com/dotnet/cli/commit/b6b53f1) Update dev-certs version
* [`[f700910]`](https://github.com/dotnet/cli/commit/f700910) Map solution configurations to existing project configurations on add.
* [`[8d95d05]`](https://github.com/dotnet/cli/commit/8d95d05) Uninstall the 'dotnet-host' before 'dotnet-runtime-deps'
* [`[eb25657]`](https://github.com/dotnet/cli/commit/eb25657) Fixing the install and uninstall of the 'RuntimeDepsPackage'
* [`[ed8d9c6]`](https://github.com/dotnet/cli/commit/ed8d9c6) Download the 'dotnet-runtime-deps' installer file to address the 'BuildSDKDeb' errors.
* [`[68c2b1d]`](https://github.com/dotnet/cli/commit/68c2b1d) Update 'DEB' filenames for downloads of the 'host' and 'hostfxr'.
* [`[8093340]`](https://github.com/dotnet/cli/commit/8093340) Fix tool_roslyn_satellite by making it use the new dependency version properties.
* [`[7ff9ac9]`](https://github.com/dotnet/cli/commit/7ff9ac9) LOC CHECKIN | dotnet/cli – master | 20170104 | update
* [`[01b8e02]`](https://github.com/dotnet/cli/commit/01b8e02) Add help for list-sdks and list-runtimes
* [`[b1c14cb]`](https://github.com/dotnet/cli/commit/b1c14cb) Check if tput command exists before using it
* [`[860de63]`](https://github.com/dotnet/cli/commit/860de63) Update wix version (#8313)
* [`[4f47ca1]`](https://github.com/dotnet/cli/commit/4f47ca1) Update xlf
* [`[4e51888]`](https://github.com/dotnet/cli/commit/4e51888) Check null for env (#8286)
* [`[40faaad]`](https://github.com/dotnet/cli/commit/40faaad) LOC CHECKIN | dotnet/cli – master | 20171222
* [`[f9af23f]`](https://github.com/dotnet/cli/commit/f9af23f) Adding Alpine 3.6
* [`[20cc8bd]`](https://github.com/dotnet/cli/commit/20cc8bd) Fixing the link to the developer guide (#8269)
* [`[22dcaf7]`](https://github.com/dotnet/cli/commit/22dcaf7) Fixing the path to the prefercliruntime file.
* [`[1912ce9]`](https://github.com/dotnet/cli/commit/1912ce9) Commit to trigger a rebuild of the CLI because of a build in place from the Runtime.
* [`[d833eaa]`](https://github.com/dotnet/cli/commit/d833eaa) Fix windows keep adding tools path to env:PATH (#8248)
* [`[d5c6133]`](https://github.com/dotnet/cli/commit/d5c6133) Adding the 2.0.3 asp.net store to the native installer tests.
* [`[af258af]`](https://github.com/dotnet/cli/commit/af258af) Update the support package on the CLI to fix binding redirects on 4.7.1
* [`[4d615db]`](https://github.com/dotnet/cli/commit/4d615db) Fix incorrect condition in SkipBuildingInstallers
* [`[1abd2d9]`](https://github.com/dotnet/cli/commit/1abd2d9) Enable Alpine 3.6 CLI build
* [`[dcc99d6]`](https://github.com/dotnet/cli/commit/dcc99d6) Make restore performed by run command default to nologo and quiet.
* [`[94e43af]`](https://github.com/dotnet/cli/commit/94e43af) Use explict and non-preview versions for the build DLL
* [`[b253a77]`](https://github.com/dotnet/cli/commit/b253a77) NuGet.Config is no longer present - therefore, explicitly state where to get this script's dependencies.
* [`[6313f4f]`](https://github.com/dotnet/cli/commit/6313f4f) The 15.4.8 version of the Microsoft.Build.Runtime nuget package is currupt; use the replacement 15.4.8.1
* [`[2c931b8]`](https://github.com/dotnet/cli/commit/2c931b8) Fix dotnet-install to check the right path for no-op installs when --shared-runtime is specified
* [`[ececae3]`](https://github.com/dotnet/cli/commit/ececae3) update preview of TestPlatform SDK
* [`[b06f6b1]`](https://github.com/dotnet/cli/commit/b06f6b1) The target: 'GenerateInstallersAndCopyOutOfSandBox' should be parameterized in run-build.sh.
* [`[02b1cc6]`](https://github.com/dotnet/cli/commit/02b1cc6) 'channel' parameter is superfluous if also using a 'version' parameter.
* [`[21e9e72]`](https://github.com/dotnet/cli/commit/21e9e72) The first 'dotnet msbuild ' pass should not run 2 targets: /'WriteDynamicPropsToStaticPropsFiles' and 'BuildAndPublishAllLinuxDistrosNativeInstallers'
* [`[9671ba1]`](https://github.com/dotnet/cli/commit/9671ba1) Write UTF-8 BOM for solution files.
* [`[5fb2b27]`](https://github.com/dotnet/cli/commit/5fb2b27) Correct the fix for devdiv bugs 526577 and 526578, the wrong property had been updated
* [`[3bea47e]`](https://github.com/dotnet/cli/commit/3bea47e) "${args[@]}" should be: $args Reference: Jan Vorlicek did some work to enable RedHat6 and part of that work was to change the argument passing in bash.
* [`[e9706a9]`](https://github.com/dotnet/cli/commit/e9706a9) Treat xlf as text
* [`[ad8f3da]`](https://github.com/dotnet/cli/commit/ad8f3da) ASP.NET Core HTTPS development certificate support
* [`[f5a93d5]`](https://github.com/dotnet/cli/commit/f5a93d5) Fixing the expected fx-version.
* [`[902904c]`](https://github.com/dotnet/cli/commit/902904c) Updating the msbuild version for Microsoft.Build.Runtime.
* [`[60ba27d]`](https://github.com/dotnet/cli/commit/60ba27d) Adding a separate dependency version for Microsoft.Build.Runtime.
* [`[0f8dfed]`](https://github.com/dotnet/cli/commit/0f8dfed) Fixing the reference to Microsoft.Build.Runtime from Cli.Utils.Tests. It was using the wrong package version property.
* [`[8b1c2c5]`](https://github.com/dotnet/cli/commit/8b1c2c5) One more old style version package name needed to change in redist.
* [`[d280a05]`](https://github.com/dotnet/cli/commit/d280a05) Fixing the versions of MSBuild and passing the right property to find roslyn files.
* [`[50dcb60]`](https://github.com/dotnet/cli/commit/50dcb60) Use "15.5.179" for the other Microsoft.Build.* packages
* [`[e3b78f8]`](https://github.com/dotnet/cli/commit/e3b78f8) Moving the 'MicrosoftBuildPackageVersion' forward.
* [`[d61eb5d]`](https://github.com/dotnet/cli/commit/d61eb5d) Fixing "RuntimeFrameworkVersion"
* [`[e09cbe0]`](https://github.com/dotnet/cli/commit/e09cbe0) Updating version naming convention.
* [`[73e8ea9]`](https://github.com/dotnet/cli/commit/73e8ea9) Adding a 'nuget-build' feed; fixing the feed line-up: 'dotnet-core' and 'AspNetMaster'.
* [`[55f62d9]`](https://github.com/dotnet/cli/commit/55f62d9) Add install tool command (#8132)
* [`[e0931a7]`](https://github.com/dotnet/cli/commit/e0931a7) Update xlf
* [`[80f5d9f]`](https://github.com/dotnet/cli/commit/80f5d9f) Even more package dependency re-names...
* [`[3cb1cca]`](https://github.com/dotnet/cli/commit/3cb1cca) Third pass clean-up of package names.
* [`[4d694d2]`](https://github.com/dotnet/cli/commit/4d694d2) Second pass clean-up of package names; resequencing download.
* [`[bf6b5b3]`](https://github.com/dotnet/cli/commit/bf6b5b3) Use rhel docker image with sudo built in (#8151)
* [`[1362c6c]`](https://github.com/dotnet/cli/commit/1362c6c) The access key is already resolved: 'CoreSetupBlobAccessTokenParam'
* [`[165f7c4]`](https://github.com/dotnet/cli/commit/165f7c4) The first pass will need the extra args [same as run-build.ps1].
* [`[c54911b]`](https://github.com/dotnet/cli/commit/c54911b) Dependency Uptake: download and import a package version props file.
* [`[4adabde]`](https://github.com/dotnet/cli/commit/4adabde) Accounting for MSRC builds with pre-set 'CoreSetupBlobRootUrl' and 'CoreSetupBlobAccessToke' properties.
* [`[1853e24]`](https://github.com/dotnet/cli/commit/1853e24) LOC CHECKIN | dotnet/cli-master | 20171201
* [`[50ffb6b]`](https://github.com/dotnet/cli/commit/50ffb6b) Removing installing the 2.0.0 asp.net runtime store. We don't it anymore either. In master, just the preview one should be enough.
* [`[3d39772]`](https://github.com/dotnet/cli/commit/3d39772) The URL root will include the "dotnet" container; the structure will be identical after the "dotnet" container.
* [`[d613ec5]`](https://github.com/dotnet/cli/commit/d613ec5) Making the cli-test-env shell script runnable and removing test workaround for preview runtimes. It is not needed in master.
* [`[4aea36d]`](https://github.com/dotnet/cli/commit/4aea36d) No passwords should be in the open as environmental variables.
* [`[5fb91f9]`](https://github.com/dotnet/cli/commit/5fb91f9) Use the 'PB_AssetRootUrl' and 'PB_AssetRootAccessTokenSuffix' for all asset downloads if set - "TransportFeed" should be "BlobFeed".
* [`[98e5c2c]`](https://github.com/dotnet/cli/commit/98e5c2c) Crossgen Microsoft.NET.Build.Extensions.Tasks.dll
* [`[f29acd3]`](https://github.com/dotnet/cli/commit/f29acd3) If the build is a 'DotNetBuildOffline'; do not write any feed lines.
* [`[34351d6]`](https://github.com/dotnet/cli/commit/34351d6) Ignore the NuGet.Config at the root as a source file; it is dynamically generated.
* [`[479a3f2]`](https://github.com/dotnet/cli/commit/479a3f2) Crossgen the Sdks directory.
* [`[76dc4a5]`](https://github.com/dotnet/cli/commit/76dc4a5) The modification to build.cmd did not have the desired effect.
* [`[ae5e396]`](https://github.com/dotnet/cli/commit/ae5e396) Handling the possible semi-colon(s) in the property parameters.
* [`[4f7c76b]`](https://github.com/dotnet/cli/commit/4f7c76b) Make --no-build imply --no-restore for run command.
* [`[ea85555]`](https://github.com/dotnet/cli/commit/ea85555) Add verbosity option to run command.
* [`[9a8316c]`](https://github.com/dotnet/cli/commit/9a8316c) Always append feed_credential to URIs in dotnet-install.{sh,ps1}
* [`[fd04fdd]`](https://github.com/dotnet/cli/commit/fd04fdd) Add parameter to dotnet-install to support pulling from private blob feeds
* [`[3444301]`](https://github.com/dotnet/cli/commit/3444301) Pipe ldconfig stderr to /dev/null
* [`[e7f4fb0]`](https://github.com/dotnet/cli/commit/e7f4fb0) Writing a NuGet.config as part of the preparatory steps.
* [`[40b0e0f]`](https://github.com/dotnet/cli/commit/40b0e0f) Make --no-build imply --no-restore for pack command.
* [`[de10b22]`](https://github.com/dotnet/cli/commit/de10b22) Make --no-build imply --no-restore for test command.
* [`[2714332]`](https://github.com/dotnet/cli/commit/2714332) Correct the fix for devdiv bugs 526577 and 526578, the wrong property had been updated
* [`[391d436]`](https://github.com/dotnet/cli/commit/391d436) Correct the fix for devdiv bugs 526577 and 526578, the wrong property had been updated
* [`[cc80ed4]`](https://github.com/dotnet/cli/commit/cc80ed4) Tools shim maker and env path handling (#8085)
* [`[584d3f0]`](https://github.com/dotnet/cli/commit/584d3f0) Global tools package obtain (#8035)
* [`[678cf13]`](https://github.com/dotnet/cli/commit/678cf13) Using OrdinalIgnoreCase to work around locale specific issues when trying to determine if a command line input is an argument.

## CoreCLR

* [`[486e815]`](https://github.com/dotnet/coreclr/commit/486e815) Update eol linuxes
* [`[e259e0a]`](https://github.com/dotnet/coreclr/commit/e259e0a) Fix GC reproting for by-ref-like structs (#16231)
* [`[c878a62]`](https://github.com/dotnet/coreclr/commit/c878a62) Fix publishing errors (#16252)
* [`[0713b96]`](https://github.com/dotnet/coreclr/commit/0713b96) Increase build timeout for test build (#16233)
* [`[59e3686]`](https://github.com/dotnet/coreclr/commit/59e3686) Prevent compiler optimization that could cause local var values to change in multithreaded environments, in some places (#16089) (#16093)
* [`[89f1279]`](https://github.com/dotnet/coreclr/commit/89f1279) fix pointer in ILCodeVersionNode so it uses PTR_COR_ILMETHOD instead of COR_IL_METHOD *, which was causing a crash in the DAC (#16003) (#16032)
* [`[40970bc]`](https://github.com/dotnet/coreclr/commit/40970bc) Enable tiered jitting for R2R methods (#15967) (#16040)
* [`[2f402dc]`](https://github.com/dotnet/coreclr/commit/2f402dc) Ensure signing of cross targeting components (#16009)
* [`[5b5dca3]`](https://github.com/dotnet/coreclr/commit/5b5dca3) Disable the default interface methods feature
* [`[b566f3f]`](https://github.com/dotnet/coreclr/commit/b566f3f) Never attempt Portable PDB conversion
* [`[b16e4ca]`](https://github.com/dotnet/coreclr/commit/b16e4ca) Turn off arm pr trigger
* [`[4414879]`](https://github.com/dotnet/coreclr/commit/4414879) Stop the SIMD hardware intrinsics types from undergoing crossgen.
* [`[3bd1610]`](https://github.com/dotnet/coreclr/commit/3bd1610) Rename Libraries.GlobalizationInterop to Libraries.GlobalizationNative
* [`[1ea580b]`](https://github.com/dotnet/coreclr/commit/1ea580b) Define Interop.Kernel32.MAX_PATH (#15952)
* [`[ab91124]`](https://github.com/dotnet/coreclr/commit/ab91124) Fix timezone lookup to be consistently case insensitive (#15951)
* [`[216a2d9]`](https://github.com/dotnet/coreclr/commit/216a2d9) Add optional integer offset to OwnedMemory Pin (#15946)
* [`[5c94055]`](https://github.com/dotnet/coreclr/commit/5c94055) #if defined(_TARGET_XARCH_) || defined(_TARGET_ARM64_)
* [`[a4af006]`](https://github.com/dotnet/coreclr/commit/a4af006) Break current culture initialization cycle (#15938)
* [`[79a08ff]`](https://github.com/dotnet/coreclr/commit/79a08ff) Fix desktop build
* [`[34776bf]`](https://github.com/dotnet/coreclr/commit/34776bf) Updating the VM to no longer treat the SIMD HWIntrinsic types as HFA or MultiReg structs.
* [`[13b6b8f]`](https://github.com/dotnet/coreclr/commit/13b6b8f) Add CI support for updated run-corefx-tests.py
* [`[11bca94]`](https://github.com/dotnet/coreclr/commit/11bca94) CharUnicodeInfo.GetUnicodeCategory(int codePoint) (#15911)
* [`[e435c50]`](https://github.com/dotnet/coreclr/commit/e435c50) Convert perf.groovy to use run-xunit-perf.py (#15881)
* [`[9612440]`](https://github.com/dotnet/coreclr/commit/9612440) For corefx testing, use a matching corefx repo version git hash
* [`[e83991c]`](https://github.com/dotnet/coreclr/commit/e83991c) Stop treating all calls to instance interface methods as callvirt (#15925)
* [`[643a396]`](https://github.com/dotnet/coreclr/commit/643a396) Move platform-neutral part of TimeZone to shared CoreLib partition (#15926)
* [`[e8aef19]`](https://github.com/dotnet/coreclr/commit/e8aef19) Allow implicit conversion of null arrays to empty Memory instances
* [`[54b5fd0]`](https://github.com/dotnet/coreclr/commit/54b5fd0) [Arm64] Set Instruction set flags
* [`[3abfaf7]`](https://github.com/dotnet/coreclr/commit/3abfaf7) Disable eventpipetrace test due to JIT stress failure (#15927)
* [`[37f0188]`](https://github.com/dotnet/coreclr/commit/37f0188) [Arm64] Add compare vector to zero emitters
* [`[f1c7328]`](https://github.com/dotnet/coreclr/commit/f1c7328) [armel tizen] Fixed CoreRT issue #4626 unwinding support (#15913)
* [`[9de5dcd]`](https://github.com/dotnet/coreclr/commit/9de5dcd) Removing an incorrect assert from emitInsBinary
* [`[38cf930]`](https://github.com/dotnet/coreclr/commit/38cf930) Cache Invariant CompareInfo (#15902)
* [`[734a8d7]`](https://github.com/dotnet/coreclr/commit/734a8d7) Do not throw IndexOutOfBounds when AM/PM designator is empty (#15904)
* [`[d44f3e8]`](https://github.com/dotnet/coreclr/commit/d44f3e8) Mirror changes from dotnet/corefx (#15909)
* [`[25d6ccb]`](https://github.com/dotnet/coreclr/commit/25d6ccb) Enable EventPipe and EventSource Functional Tests (#15917)
* [`[c2a35f4]`](https://github.com/dotnet/coreclr/commit/c2a35f4) Convert BulkTypeLogger Allocations From Stack to Heap (#15907)
* [`[fffd345]`](https://github.com/dotnet/coreclr/commit/fffd345) table drive Intel hardware intrinsic
* [`[8c0e8e3]`](https://github.com/dotnet/coreclr/commit/8c0e8e3) Allow COMPlus_JitHalt to display a pop-up on ARM/ARM64
* [`[ad48067]`](https://github.com/dotnet/coreclr/commit/ad48067) ARM: Fix morphing of struct passed on stack
* [`[84efbc8]`](https://github.com/dotnet/coreclr/commit/84efbc8)  Update clr-configuration-knobs.md, add new C# csi.exe based script for xplat document generation (#15858)
* [`[75385b1]`](https://github.com/dotnet/coreclr/commit/75385b1) Update perflab tests to execute in a fixed order
* [`[f9a985d]`](https://github.com/dotnet/coreclr/commit/f9a985d) Updating TYP_SIMD locals to no longer undergo struct promotion for HWIntrinsic nodes.
* [`[d9aa56f]`](https://github.com/dotnet/coreclr/commit/d9aa56f) Disabling the Math.Round, Math.Floor, and Math.Ceiling intrinsics on non-AVX machines
* [`[ff39b0f]`](https://github.com/dotnet/coreclr/commit/ff39b0f) Fixing the `LoadAlignedVector128` HWIntrinsic test to ensure that we always read from an aligned address.
* [`[5bcfde4]`](https://github.com/dotnet/coreclr/commit/5bcfde4) Add environment variable (COMPlus_EnableDiagnostics) to disable debugging and profiling. (#15878)
* [`[33ce0e2]`](https://github.com/dotnet/coreclr/commit/33ce0e2) Skip EDI boundary for async (#15781)
* [`[9133e9d]`](https://github.com/dotnet/coreclr/commit/9133e9d) Adding a DebugView for Vector64\<T>, Vector128\<T>, and Vector256\<T>
* [`[ac0e38f]`](https://github.com/dotnet/coreclr/commit/ac0e38f) Move public StreamReader/Writer to CoreLib (#15884)
* [`[0b5e9eb]`](https://github.com/dotnet/coreclr/commit/0b5e9eb) Updating emitIns_R_R_A_I to not be defined for the legacy backend.
* [`[8d84ea8]`](https://github.com/dotnet/coreclr/commit/8d84ea8) Add MDA (Managed Debugging Assistant) (#15875)
* [`[1ae6cae]`](https://github.com/dotnet/coreclr/commit/1ae6cae) Add missing config.h.in entry for HAVE_LIBINTL_H (#15887)
* [`[a433a9c]`](https://github.com/dotnet/coreclr/commit/a433a9c) Matching non-shared Decimal changes
* [`[17074b2]`](https://github.com/dotnet/coreclr/commit/17074b2) Disable GetGeneration from GCStress runs
* [`[18108e4]`](https://github.com/dotnet/coreclr/commit/18108e4) Fix non-Windows R2R testing in CI
* [`[dd65150]`](https://github.com/dotnet/coreclr/commit/dd65150) Update filetimes to nsec (#15872)
* [`[677c5c3]`](https://github.com/dotnet/coreclr/commit/677c5c3) Adding support for the SSE Load, LoadAligned, LoadHigh, LoadLow, and LoadScalar intrinsics
* [`[5ca9417]`](https://github.com/dotnet/coreclr/commit/5ca9417) Updating most of the SSE Compare intrinsics to support containment
* [`[a15aa12]`](https://github.com/dotnet/coreclr/commit/a15aa12) Updating the SSE HWIntrinsics to share code where possible.
* [`[baeed0c]`](https://github.com/dotnet/coreclr/commit/baeed0c) Adding support for the SSE MoveMask intrinsic
* [`[5ef844b]`](https://github.com/dotnet/coreclr/commit/5ef844b) Adding support for the SSE Set scalar intrinsic
* [`[887d5c4]`](https://github.com/dotnet/coreclr/commit/887d5c4) Adding support for the SSE Compare\<op>Ordered and Compare\<op>Unordered scalar intrinsics for op: eq, gt, ge, lt, le, and ne
* [`[e84b55e]`](https://github.com/dotnet/coreclr/commit/e84b55e) Adding support for the SSE ConvertTo Int32, Int32WithTruncation, Int64WithTruncation, Single, and Vector128Single scalar intrinsics
* [`[3fcdaf8]`](https://github.com/dotnet/coreclr/commit/3fcdaf8) Adding support for the SSE Reciprocal, ReciprocalSqrt, and Sqrt scalar intrinsics
* [`[eaf9aef]`](https://github.com/dotnet/coreclr/commit/eaf9aef) Adding support for the SSE compare eq, gt, ge, lt, le, ne, ord, and unord scalar intrinsics
* [`[bfc992e]`](https://github.com/dotnet/coreclr/commit/bfc992e) Adding support for the SSE Add, Divide, Max, Min, Move, Multiply, and Subtract scalar intrinsics
* [`[224b8dc]`](https://github.com/dotnet/coreclr/commit/224b8dc) Adding support for the SSE StaticCast intrinsic
* [`[94f82fb]`](https://github.com/dotnet/coreclr/commit/94f82fb) Adding support for the SSE Shuffle intrinsic
* [`[3f115ef]`](https://github.com/dotnet/coreclr/commit/3f115ef) Adding support for the SSE Set, SetAll, and SetZero intrinsics
* [`[91c7550]`](https://github.com/dotnet/coreclr/commit/91c7550) Adding support for the SSE Reciprocal, ReciprocalSqrt, and Sqrt intrinsics
* [`[402550c]`](https://github.com/dotnet/coreclr/commit/402550c) Adding support for the SSE compare eq, gt, ge, lt, le, ne, ord, and unord intrinsics
* [`[adadee1]`](https://github.com/dotnet/coreclr/commit/adadee1) Adding support for the SSE And, AndNot, Divide, Max, Min, MoveHighToLow, MoveLowToHigh, Multiply, Or, Subtract, UnpackHigh, UnpackLow, and Xor instructions.
* [`[bd56bb3]`](https://github.com/dotnet/coreclr/commit/bd56bb3) Adding the remaining SSE intrinsics to hwintrinsiclistxarch.h
* [`[c3f9770]`](https://github.com/dotnet/coreclr/commit/c3f9770) [Arm64] Add arm64-intrinsics.md (#15343)
* [`[5424bc6]`](https://github.com/dotnet/coreclr/commit/5424bc6) Fix one missing check for NULL after malloc (#15877)
* [`[4c8a732]`](https://github.com/dotnet/coreclr/commit/4c8a732) Small fix to underlying CoreCLR support for new string slicing overloads (#15876)
* [`[1b66556]`](https://github.com/dotnet/coreclr/commit/1b66556) Mark emitIns_R_A and emitIns_R_R_A to be not defined for legacy backend
* [`[795d9c0]`](https://github.com/dotnet/coreclr/commit/795d9c0) Fix mismatch between new and free in numa.cpp (#15870)
* [`[8b8b3b9]`](https://github.com/dotnet/coreclr/commit/8b8b3b9) Fix Android build (#15868)
* [`[d581801]`](https://github.com/dotnet/coreclr/commit/d581801) Delete BasicSpanTest.cs (#15860)
* [`[41ed1d7]`](https://github.com/dotnet/coreclr/commit/41ed1d7) [Arm64] Use is16Byte
* [`[7ba1bf9]`](https://github.com/dotnet/coreclr/commit/7ba1bf9) Adding SSE4.1 intrinsic support for Round, Ceiling, and Floor.
* [`[3126bd3]`](https://github.com/dotnet/coreclr/commit/3126bd3) Mark legacy ByRef-like types as ref in sources (#15846)
* [`[ed6dd1b]`](https://github.com/dotnet/coreclr/commit/ed6dd1b) Added Append(Stringbuilder,int,int) and Append(StringBuilder) overlaod apis (#15786)
* [`[9348fda]`](https://github.com/dotnet/coreclr/commit/9348fda) Do fast GC stress on some extreme tests
* [`[d1793d3]`](https://github.com/dotnet/coreclr/commit/d1793d3) updated docs: how to run against local core clr build (#15841)
* [`[b0a10f6]`](https://github.com/dotnet/coreclr/commit/b0a10f6) UMEntryThunk: store freed thunks into FIFO free list
* [`[28839fc]`](https://github.com/dotnet/coreclr/commit/28839fc) Improve UMEntryThunkCode::Poison method.
* [`[592aa82]`](https://github.com/dotnet/coreclr/commit/592aa82) Fixing the hwintrin codgen containment checks
* [`[6804e99]`](https://github.com/dotnet/coreclr/commit/6804e99) Adding asserts that values are as expected for certain containment checks
* [`[8225ec3]`](https://github.com/dotnet/coreclr/commit/8225ec3) Adding basic containment support to the x86 HWIntrinsics
* [`[5378afc]`](https://github.com/dotnet/coreclr/commit/5378afc) Convert run-xunit-perf to py script (#15568)
* [`[50dd834]`](https://github.com/dotnet/coreclr/commit/50dd834) [Local GC] Introduce standalone eventing design document (#15570)
* [`[d087b29]`](https://github.com/dotnet/coreclr/commit/d087b29) Fix GC.KeepAlive test case
* [`[ff60c21]`](https://github.com/dotnet/coreclr/commit/ff60c21) Disable NoGC test in GCStress test runs
* [`[82f2576]`](https://github.com/dotnet/coreclr/commit/82f2576) [Infrastructure/Win] Add C++ header files to Visual Studio clrjit project (#15775)
* [`[90f1918]`](https://github.com/dotnet/coreclr/commit/90f1918) movhlps categorized as dstdstsrc
* [`[c459b52]`](https://github.com/dotnet/coreclr/commit/c459b52) Allow CALLEE_IS_FORCE_INLINE precedent over CALLEE_DOES_NOT_RETURN (#14586)
* [`[d97e885]`](https://github.com/dotnet/coreclr/commit/d97e885) Keep LowLevelDictionary for CoreRT for now (#15824)
* [`[288bd46]`](https://github.com/dotnet/coreclr/commit/288bd46) Improve performance for Math.Abs (#15823)
* [`[737b41b]`](https://github.com/dotnet/coreclr/commit/737b41b) Fix non-Windows compile error
* [`[8266cbc]`](https://github.com/dotnet/coreclr/commit/8266cbc) Fix Obsolete on ReadOnlySpan Equals and GetHashCode methods (#15820)
* [`[d84eba2]`](https://github.com/dotnet/coreclr/commit/d84eba2) Fix ARM GCStress hole with byref write barrier helper
* [`[0605549]`](https://github.com/dotnet/coreclr/commit/0605549) Fix change to fgMorphBlockOperand
* [`[e275d2d]`](https://github.com/dotnet/coreclr/commit/e275d2d) Fix incremental build by preventing nonchanging writes (#15817)
* [`[da46977]`](https://github.com/dotnet/coreclr/commit/da46977) Underlying CoreCLR support for new string slicing overloads (#15811)
* [`[a63990c]`](https://github.com/dotnet/coreclr/commit/a63990c) Add privaterun properties (#15816)
* [`[8719e73]`](https://github.com/dotnet/coreclr/commit/8719e73) Move System.Globalization.CultureData to shared CoreLib partition (#15805)
* [`[dce9085]`](https://github.com/dotnet/coreclr/commit/dce9085) Port servicing fix (#15802)
* [`[2267b5d]`](https://github.com/dotnet/coreclr/commit/2267b5d) Add new CI mode for Intel HW intrinsics
* [`[a233648]`](https://github.com/dotnet/coreclr/commit/a233648) Update the document for netcoreapp2.1
* [`[4f58962]`](https://github.com/dotnet/coreclr/commit/4f58962) Update links to nightly .NET Core SDK builds (#15799)
* [`[55bb222]`](https://github.com/dotnet/coreclr/commit/55bb222) Adds StringBuilder.Equals(ReadOnlySpan\<char>) Api (#15759)
* [`[2bb0fed]`](https://github.com/dotnet/coreclr/commit/2bb0fed) fix corefx/#26230 (#15792)
* [`[064136c]`](https://github.com/dotnet/coreclr/commit/064136c) Fixing https://github.com/aspnet/JitBench/issues/80 (#15764)
* [`[da381a7]`](https://github.com/dotnet/coreclr/commit/da381a7) Fixed superpmi JIT debugging on desktop build. (#15773)
* [`[cab0db6]`](https://github.com/dotnet/coreclr/commit/cab0db6) Update Intel hardware intrinsic APIs (#15601)
* [`[a764455]`](https://github.com/dotnet/coreclr/commit/a764455) JIT: improve return types in cases with spill temps (#15766)
* [`[6d910b4]`](https://github.com/dotnet/coreclr/commit/6d910b4) Updating the x86 HWIntrinsic importer to not inline when returning gtNewMustThrowException
* [`[2c254c4]`](https://github.com/dotnet/coreclr/commit/2c254c4) Move types to shared corelib partition (#15768)
* [`[8b2cac9]`](https://github.com/dotnet/coreclr/commit/8b2cac9) Change just-in-time debugging registry keys. (#15722)
* [`[2c226c4]`](https://github.com/dotnet/coreclr/commit/2c226c4) ARM r2r fix. (#15758)
* [`[16246c9]`](https://github.com/dotnet/coreclr/commit/16246c9) JIT: fix decompose long left shift for overshift cases (#15704)
* [`[89e6408]`](https://github.com/dotnet/coreclr/commit/89e6408) Proposed fix for 15671
* [`[5f4510d]`](https://github.com/dotnet/coreclr/commit/5f4510d) Simplify and unify EnumCalendars interop (#15762)
* [`[a46475c]`](https://github.com/dotnet/coreclr/commit/a46475c) JIT: fix issue with inline observations (#15713)
* [`[3fc07ad]`](https://github.com/dotnet/coreclr/commit/3fc07ad) Fix issue where the unsigned value used for the the map select budget could underflow resulting in an unlimited budget
* [`[6c12105]`](https://github.com/dotnet/coreclr/commit/6c12105) Detect ByRefLike types using attribute (#15745)
* [`[7a78542]`](https://github.com/dotnet/coreclr/commit/7a78542) fix COMPlus_JitHalt for arm32. (#15761)
* [`[41d23b0]`](https://github.com/dotnet/coreclr/commit/41d23b0) AggregateException: Use StringBuilder.AppendFormat (#15747)
* [`[b2e86cf]`](https://github.com/dotnet/coreclr/commit/b2e86cf) Unix: Specify Ordinal comparison in TimeZoneInfo (#15739)
* [`[a24f196]`](https://github.com/dotnet/coreclr/commit/a24f196) Use string.Contains(char) instead of Contains(string) (#15740)
* [`[391be01]`](https://github.com/dotnet/coreclr/commit/391be01) Adding EnsureCapacity implementation for Dictionary (#15729)
* [`[eaeb4d3]`](https://github.com/dotnet/coreclr/commit/eaeb4d3) Updating the existing HWIntrinsic tests to also test indirect calling via reflection.
* [`[2efb857]`](https://github.com/dotnet/coreclr/commit/2efb857) Update profiling API status (#15659)
* [`[b5a755e]`](https://github.com/dotnet/coreclr/commit/b5a755e) Change monitor test (#15727)
* [`[f3796c7]`](https://github.com/dotnet/coreclr/commit/f3796c7) Fix waitone test (#15728)
* [`[a71f4bc]`](https://github.com/dotnet/coreclr/commit/a71f4bc) Updating Compiler::impIntrinsic to always expand hardware intrinsics.
* [`[e79a4d5]`](https://github.com/dotnet/coreclr/commit/e79a4d5) Reset lvIsStructField when removing promoted struct vars (#15721)
* [`[36bf447]`](https://github.com/dotnet/coreclr/commit/36bf447) Mark all CoreCLR packages as non-shipping (#15725)
* [`[44a7dc7]`](https://github.com/dotnet/coreclr/commit/44a7dc7) [Arm64] Add Vector64 HW Intrinsic support
* [`[75ff3e4]`](https://github.com/dotnet/coreclr/commit/75ff3e4) Fix link to IdnMapping.cs (#15717)
* [`[e432923]`](https://github.com/dotnet/coreclr/commit/e432923) Link to THIRD-PARTY-NOTICES is fixed (#15665)
* [`[3210b9e]`](https://github.com/dotnet/coreclr/commit/3210b9e) Check for null in ReflectionTypeLoadException Message/ToString (#15711)
* [`[76b4b48]`](https://github.com/dotnet/coreclr/commit/76b4b48) Keep OBJ on mismatched struct assignment
* [`[b11ddd3]`](https://github.com/dotnet/coreclr/commit/b11ddd3) Use the message that the ReflectionTypeLoadException exception was initialized with (#15708)
* [`[8337aa4]`](https://github.com/dotnet/coreclr/commit/8337aa4) Updating the build script to work when python is installed to a path containing a space. (#15707)
* [`[8b008aa]`](https://github.com/dotnet/coreclr/commit/8b008aa) Fix size-on-disk benchmark to handle new CLI behavior (#15689)
* [`[60f74b3]`](https://github.com/dotnet/coreclr/commit/60f74b3) Spill the eval stack when storing to a pinned local.
* [`[247d60d]`](https://github.com/dotnet/coreclr/commit/247d60d) Pass manifest details to PushToBlobFeed (#15705)
* [`[3632bcd]`](https://github.com/dotnet/coreclr/commit/3632bcd) Normalize lsra.h line endings
* [`[4d26be5]`](https://github.com/dotnet/coreclr/commit/4d26be5) Print Inner Exceptions in ReflectionTypeLoadException ToString (#15688)
* [`[d70e11b]`](https://github.com/dotnet/coreclr/commit/d70e11b) [Arm64] getBaseTypeAndSizeOfSIMDType
* [`[097e686]`](https://github.com/dotnet/coreclr/commit/097e686) Use Span to drop byte[1] allocations (#15680)
* [`[6c30ff4]`](https://github.com/dotnet/coreclr/commit/6c30ff4) Fix description of FeatureSIMD
* [`[f968319]`](https://github.com/dotnet/coreclr/commit/f968319) Disable jitdiff jobs
* [`[c1bbdae]`](https://github.com/dotnet/coreclr/commit/c1bbdae) Retry: Enable EventPipe across Unix and Windows (#15611)
* [`[a736381]`](https://github.com/dotnet/coreclr/commit/a736381) Give a proper VN to GT_BOX (#15666)
* [`[0bb37fd]`](https://github.com/dotnet/coreclr/commit/0bb37fd) Encoding: Don't alloc for zero length array (#13794)
* [`[d265eba]`](https://github.com/dotnet/coreclr/commit/d265eba) Return StringBuilder back to cache when not making any replacements (#15677)
* [`[64ea348]`](https://github.com/dotnet/coreclr/commit/64ea348) Replace a few for loops with foreach to avoid loop cloning (#15668)
* [`[61f1e4d]`](https://github.com/dotnet/coreclr/commit/61f1e4d) Make HandleRef fields private
* [`[31e22b2]`](https://github.com/dotnet/coreclr/commit/31e22b2) Recognize STA\MTA Attribute For Main Function (#15652)
* [`[6a12b30]`](https://github.com/dotnet/coreclr/commit/6a12b30) Fix desktop build warnings
* [`[122acaa]`](https://github.com/dotnet/coreclr/commit/122acaa) Extending FormatException's message with datetime/format (#15635)
* [`[6f410d2]`](https://github.com/dotnet/coreclr/commit/6f410d2) Link to the File Header Example for C# was broken. (#15655)
* [`[2900d76]`](https://github.com/dotnet/coreclr/commit/2900d76) Updated CreateMethodDesc to pass along the `IsJitIntrinsic` flag for generic methods. (#15653)
* [`[ccf53b9]`](https://github.com/dotnet/coreclr/commit/ccf53b9) Updated links to ABI conventions (#15651)
* [`[e560084]`](https://github.com/dotnet/coreclr/commit/e560084) Update the version of the xUnit Performance Api (#15620)
* [`[fc89ab8]`](https://github.com/dotnet/coreclr/commit/fc89ab8) Adding basic containment analysis support for hardware intrinsics.
* [`[f8153ea]`](https://github.com/dotnet/coreclr/commit/f8153ea) Resolve race in ShimProxyCallback::AddRef (#15643)
* [`[adbfd2c]`](https://github.com/dotnet/coreclr/commit/adbfd2c) [Arm64] Disable HW Intrinsic NGEN (#15603)
* [`[013eb56]`](https://github.com/dotnet/coreclr/commit/013eb56) Fix manual GC_PROTECTs around StackTraceArray (#15621)
* [`[d7d457f]`](https://github.com/dotnet/coreclr/commit/d7d457f) Small changes around stack levels. (#15616)
* [`[f1c2c62]`](https://github.com/dotnet/coreclr/commit/f1c2c62) Make views recursive
* [`[c127fa7]`](https://github.com/dotnet/coreclr/commit/c127fa7) Organizing the tests/src/JIT/HardwareIntrinsics/X86 folder by ISA to make it more manageable. (#15617)
* [`[1f4957e]`](https://github.com/dotnet/coreclr/commit/1f4957e) Try Views class
* [`[222be51]`](https://github.com/dotnet/coreclr/commit/222be51) Mark view variables static
* [`[8f9d5e0]`](https://github.com/dotnet/coreclr/commit/8f9d5e0) mark call->fgArgInfo with hasStackArgs for arm32 split args (#15615)
* [`[99bc7b0]`](https://github.com/dotnet/coreclr/commit/99bc7b0) Add more Views to Jenkins UI
* [`[845da03]`](https://github.com/dotnet/coreclr/commit/845da03) icushim: try using the build-time libicu version (#15562)
* [`[f5b7a3f]`](https://github.com/dotnet/coreclr/commit/f5b7a3f) Increase build only job timeouts
* [`[b4a5bea]`](https://github.com/dotnet/coreclr/commit/b4a5bea) Add an hour to test job timeouts to account for their slowness
* [`[7524d72]`](https://github.com/dotnet/coreclr/commit/7524d72) Enable EventPipe across Unix and Windows (#14772)
* [`[990ecc7]`](https://github.com/dotnet/coreclr/commit/990ecc7) LSRA: Replace operandToLocationInfoMap with a list
* [`[0c01aa4]`](https://github.com/dotnet/coreclr/commit/0c01aa4) fix template method that nobody calls. (#15584)
* [`[ea7e7df]`](https://github.com/dotnet/coreclr/commit/ea7e7df) Block diamondshape and sharedgenerics tests on #15591 (#15593)
* [`[69c4170]`](https://github.com/dotnet/coreclr/commit/69c4170) Fix the dump of LIR flags
* [`[95c6e74]`](https://github.com/dotnet/coreclr/commit/95c6e74) Add COMPlus_EnableIncompleteISAClass and streamline IsSupported
* [`[7a87eb2]`](https://github.com/dotnet/coreclr/commit/7a87eb2) Fix per-test timeout
* [`[90753bb]`](https://github.com/dotnet/coreclr/commit/90753bb) Move x86 intrinsic tests into X86 folder
* [`[e69300f]`](https://github.com/dotnet/coreclr/commit/e69300f) if getter is under #ifdef, then the setter should be either. (#15581)
* [`[5476baf]`](https://github.com/dotnet/coreclr/commit/5476baf) Fix sos/dac long named dlls (#15580)
* [`[f55e568]`](https://github.com/dotnet/coreclr/commit/f55e568) Fix for armel double passed as long
* [`[7a6cbd0]`](https://github.com/dotnet/coreclr/commit/7a6cbd0) Manually add arm/arm64 BenchmarksGame testing
* [`[50adfc5]`](https://github.com/dotnet/coreclr/commit/50adfc5) Enable gdbjit while NI file exist (#15501)
* [`[4157555]`](https://github.com/dotnet/coreclr/commit/4157555) Eliminate gtLsraInfo from GenTree
* [`[eadd0c2]`](https://github.com/dotnet/coreclr/commit/eadd0c2) Reduce arm/armlb/arm64 R2R test crossgen logging verbosity
* [`[cac9fcb]`](https://github.com/dotnet/coreclr/commit/cac9fcb) Disable GitHub_15291.cmd for x86
* [`[437cb18]`](https://github.com/dotnet/coreclr/commit/437cb18) Put ToolDir property back on restore command
* [`[0d6880d]`](https://github.com/dotnet/coreclr/commit/0d6880d) gtNewMustThrowException works with SIMD and struct
* [`[767f5ff]`](https://github.com/dotnet/coreclr/commit/767f5ff) Fix naming convention of hardware intrinsic APIs (#15471)
* [`[21cfdb6]`](https://github.com/dotnet/coreclr/commit/21cfdb6) Respect STA/MTAThread attributes (#15512)
* [`[8ec9bdf]`](https://github.com/dotnet/coreclr/commit/8ec9bdf) Convert uses of the Dangerous APIs to use MemoryMarshal.GetReference (#15532)
* [`[ef74ed6]`](https://github.com/dotnet/coreclr/commit/ef74ed6) Clean up clrjit from using sizeof(void*) when meant TARGET_POINTER_SIZE (#15524)
* [`[3c958f3]`](https://github.com/dotnet/coreclr/commit/3c958f3) ReadOnlySpan GetReference returns ref instead of ref readonly (#15548)
* [`[39ce8da]`](https://github.com/dotnet/coreclr/commit/39ce8da) Enable Vector256\<T> with AVX
* [`[d3057a9]`](https://github.com/dotnet/coreclr/commit/d3057a9) For arm/armlb/arm64 R2R testing, add crossgen compilation of FX assemblies
* [`[9a7d526]`](https://github.com/dotnet/coreclr/commit/9a7d526) Enabling temporarily disabled tests that call ReadOnlySpan indexer (#15546)
* [`[a6d04b8]`](https://github.com/dotnet/coreclr/commit/a6d04b8) Fix legacy JIT to adjust for https://github.com/dotnet/coreclr/pull/15456
* [`[25e40da]`](https://github.com/dotnet/coreclr/commit/25e40da) Make EventArgs base class serializable (#15541)
* [`[d39b3d1]`](https://github.com/dotnet/coreclr/commit/d39b3d1) Enable ReadyToRun testing for arm/armlb/arm64
* [`[1ec4888]`](https://github.com/dotnet/coreclr/commit/1ec4888) Change ReadOnlySpan indexer to return ref readonly (#14727)
* [`[9576b24]`](https://github.com/dotnet/coreclr/commit/9576b24) [RyuJit][Armel] Do not lose type information (#15449)
* [`[264f814]`](https://github.com/dotnet/coreclr/commit/264f814) Fixing build by casting IntPtr to nint. (#15530)
* [`[0af6081]`](https://github.com/dotnet/coreclr/commit/0af6081) Adding Unsafe API Add nuint that is used by SpanHelpers (#15527)
* [`[d04768c]`](https://github.com/dotnet/coreclr/commit/d04768c) Adding scalar hardware intrinsics for x86.
* [`[5d91c4d]`](https://github.com/dotnet/coreclr/commit/5d91c4d) Change non-exclusive Check postconditions to null checks (#15523)
* [`[d6201ca]`](https://github.com/dotnet/coreclr/commit/d6201ca) Lsra Documentation
* [`[6cc8720]`](https://github.com/dotnet/coreclr/commit/6cc8720) Enable Alpine CI (#15502)
* [`[adc5be0]`](https://github.com/dotnet/coreclr/commit/adc5be0) Add a note the linker bug has been fixed
* [`[ef2b28d]`](https://github.com/dotnet/coreclr/commit/ef2b28d) get rid of TYP_CHAR
* [`[07d8a29]`](https://github.com/dotnet/coreclr/commit/07d8a29) compare type size instead of var_types
* [`[0eeae70]`](https://github.com/dotnet/coreclr/commit/0eeae70) Adding valuenum support for acosh, asinh, atanh, and cbrt
* [`[cc1135d]`](https://github.com/dotnet/coreclr/commit/cc1135d) Updating the PAL layer to support acosh, asinh, atanh, and cbrt
* [`[ecf4dc8]`](https://github.com/dotnet/coreclr/commit/ecf4dc8) Adding support for Acosh, Asinh, Atanh, and Cbrt to Math and MathF
* [`[ec4be24]`](https://github.com/dotnet/coreclr/commit/ec4be24) Get rid of old -altjitcrossgen argument now that CI has been updated
* [`[4416b9b]`](https://github.com/dotnet/coreclr/commit/4416b9b) Adding Unsafe APIs that are used by System.Memory (#15497)
* [`[9f1dc44]`](https://github.com/dotnet/coreclr/commit/9f1dc44) [Arm64/Linux] PAL_GetJitCpuCapabilityFlags() (#15447)
* [`[00bde7e]`](https://github.com/dotnet/coreclr/commit/00bde7e) Make GenTree::AsX, gtGetOp1 and gtGetOp2 const
* [`[66658e6]`](https://github.com/dotnet/coreclr/commit/66658e6) Enable Vector128/256\<T> and Add intrinsics
* [`[e7660e3]`](https://github.com/dotnet/coreclr/commit/e7660e3) Make RyuJIT/arm32 the default arm32 JIT
* [`[47987d7]`](https://github.com/dotnet/coreclr/commit/47987d7) Ignore *.nuget.cache files. (#15496)
* [`[1e1926c]`](https://github.com/dotnet/coreclr/commit/1e1926c) Fix for issue 15412   Added an IL test case for this issue   Added the template C# simplearg.cs that was used to create the test case simplearg.il   Added extra logging around the initial call of impNormStructVal
* [`[c233112]`](https://github.com/dotnet/coreclr/commit/c233112) make coreclr buildable on FreeBSD again (#15480)
* [`[59f8f66]`](https://github.com/dotnet/coreclr/commit/59f8f66) Don't create the sampling thread if the threadtime event is disabled. (#15473)
* [`[51fcf63]`](https://github.com/dotnet/coreclr/commit/51fcf63) Disable 3 failing ARM tests on Windows
* [`[5ac4d2a]`](https://github.com/dotnet/coreclr/commit/5ac4d2a) Add SPMI for getTypeForPrimitiveNumericClass
* [`[484ba9b]`](https://github.com/dotnet/coreclr/commit/484ba9b) Update GTF_VAR_USEASG documentation
* [`[56f3aee]`](https://github.com/dotnet/coreclr/commit/56f3aee) Correct sizeToCommit rounding (#15485)
* [`[82a96af]`](https://github.com/dotnet/coreclr/commit/82a96af) Use macro _countof instead of explicit sizeof(arr) / sizeof(arr[0]) or sizeof(arr) / sizeof(*arr) in clrjit. (#15474)
* [`[da74892]`](https://github.com/dotnet/coreclr/commit/da74892) Make EventCacheKey IEquatable (#15470)
* [`[c97a6e9]`](https://github.com/dotnet/coreclr/commit/c97a6e9) Up pri-1 timeouts again
* [`[c73a95c]`](https://github.com/dotnet/coreclr/commit/c73a95c) Do not optimize flags-setting add
* [`[7ba4d83]`](https://github.com/dotnet/coreclr/commit/7ba4d83) Fix arm/arm64 localloc
* [`[c903f7b]`](https://github.com/dotnet/coreclr/commit/c903f7b) [RyuJit][x86] another forgotten case with unused flag in decomposition.
* [`[5c8827d]`](https://github.com/dotnet/coreclr/commit/5c8827d) Fix non-PR perf pipeline job (#15438)
* [`[7e84010]`](https://github.com/dotnet/coreclr/commit/7e84010) Dictionary Initalize CQ (#15461)
* [`[c8db268]`](https://github.com/dotnet/coreclr/commit/c8db268) Improve Dict.Clear CQ (#15459)
* [`[4f040c1]`](https://github.com/dotnet/coreclr/commit/4f040c1) Disable LowerCompare optimizations in minopts
* [`[f4088fe]`](https://github.com/dotnet/coreclr/commit/f4088fe) Disable finalizertest for ARM
* [`[c447874]`](https://github.com/dotnet/coreclr/commit/c447874) Add scope prefix for class vars
* [`[d636649]`](https://github.com/dotnet/coreclr/commit/d636649) Jit: fix long shift helper for overly long shift counts (#15443)
* [`[1c3336e]`](https://github.com/dotnet/coreclr/commit/1c3336e) [Arm64] SIMDIntrinsicGetItem contain mem op1
* [`[8edf4d8]`](https://github.com/dotnet/coreclr/commit/8edf4d8) Archive the obj directory for arm builds
* [`[3119731]`](https://github.com/dotnet/coreclr/commit/3119731) [Arm64] Define ISA feature flags
* [`[ddab65b]`](https://github.com/dotnet/coreclr/commit/ddab65b) Fix uaf in DestroyThread function. (#15437)
* [`[e9815bf]`](https://github.com/dotnet/coreclr/commit/e9815bf) Fix timeouts. Up timeouts for non-default (Pri-1) builds.
* [`[8931cfa]`](https://github.com/dotnet/coreclr/commit/8931cfa) Add optional integer offset to OwnedMemory Pin (#15410)
* [`[0919eb3]`](https://github.com/dotnet/coreclr/commit/0919eb3) Add GetReference and TryGetArray to MemoryMarshal (#15417)
* [`[a37369a]`](https://github.com/dotnet/coreclr/commit/a37369a) Cast lp1 to the ScanContext; lp2 is a function pointer. (#15433)
* [`[71dc688]`](https://github.com/dotnet/coreclr/commit/71dc688) Externalize exception boxing (#15418)
* [`[12ab7fc]`](https://github.com/dotnet/coreclr/commit/12ab7fc) Turn off outerloop perf and make job run periodically (#15416)
* [`[e46e4c0]`](https://github.com/dotnet/coreclr/commit/e46e4c0) Add progress output to runtest.cmd so you don't think it's hung
* [`[224ee9f]`](https://github.com/dotnet/coreclr/commit/224ee9f) Predicate overwrite of BuildVersionFile on OverwriteCoreClrPackageVersion == true
* [`[0b224da]`](https://github.com/dotnet/coreclr/commit/0b224da) Fix a variable re-definition that resulted in two git invocations per project build
* [`[dd9f303]`](https://github.com/dotnet/coreclr/commit/dd9f303) Don't change SIGINT/SIGQUIT handling when they are set to SIG_IGN (#15393)
* [`[a321506]`](https://github.com/dotnet/coreclr/commit/a321506) JIT: fix remorph assert in cast long shift optimization (#15386)
* [`[ee743a7]`](https://github.com/dotnet/coreclr/commit/ee743a7) new intrinsic type support (#15340)
* [`[688b75c]`](https://github.com/dotnet/coreclr/commit/688b75c) Null Check added to GetFullPath Function in Unix (#15399)
* [`[bea8631]`](https://github.com/dotnet/coreclr/commit/bea8631) Reduce arm/armlb/arm64 GCStress=3 and HeapVerify=1 jobs from daily to weekly
* [`[563cc60]`](https://github.com/dotnet/coreclr/commit/563cc60) Move all non-full opt, non-pgo perf legs to periodic (#15398)
* [`[e226456]`](https://github.com/dotnet/coreclr/commit/e226456) Fix GT_FIELD_LIST double passed as int
* [`[0d19b66]`](https://github.com/dotnet/coreclr/commit/0d19b66) Limit Windows ARM64 non-PR testing to certain branches
* [`[766f72e]`](https://github.com/dotnet/coreclr/commit/766f72e) Don't run ARM/ARM64 tests marked LONG_RUNNING
* [`[a9b3ca4]`](https://github.com/dotnet/coreclr/commit/a9b3ca4) Adjust BenchI/BenchF paths to account for recent file moves
* [`[5835267]`](https://github.com/dotnet/coreclr/commit/5835267) Enable arm/armlb/arm64 periodic GCStress=C jobs
* [`[2b9e70f]`](https://github.com/dotnet/coreclr/commit/2b9e70f) [Arm64] Enable SIMD (#14633)
* [`[d2a0049]`](https://github.com/dotnet/coreclr/commit/d2a0049) Block default interface constrained call test on Unix
* [`[809b8f7]`](https://github.com/dotnet/coreclr/commit/809b8f7) Put default interfaces behind a define (#15358)
* [`[7e202dc]`](https://github.com/dotnet/coreclr/commit/7e202dc) Have a Type.IsConvertible property. (#15365)
* [`[6eaf27d]`](https://github.com/dotnet/coreclr/commit/6eaf27d) Separate large perf benchmarks into their own legs (#15231)
* [`[a419201]`](https://github.com/dotnet/coreclr/commit/a419201) Exclude constrainedcall test
* [`[a2442bd]`](https://github.com/dotnet/coreclr/commit/a2442bd) Rename the method FloorLog2 to be more clear & fix spelling (#25335) (#15349)
* [`[bb36f05]`](https://github.com/dotnet/coreclr/commit/bb36f05) JIT: defer removing statements during opt CSE (#15323)
* [`[3657a8c]`](https://github.com/dotnet/coreclr/commit/3657a8c) Delete sortversioning.cpp/h (#15345)
* [`[c10b304]`](https://github.com/dotnet/coreclr/commit/c10b304) Fix NEG decomposition to mark instructions that set and use flags
* [`[1a628dc]`](https://github.com/dotnet/coreclr/commit/1a628dc) Improve throughput of String.Split(char / char[], ...) (#15322)
* [`[1a62b23]`](https://github.com/dotnet/coreclr/commit/1a62b23) Change name to perf jobs to reflect the actual OS they run on (#15314)
* [`[600902d]`](https://github.com/dotnet/coreclr/commit/600902d) JIT: handle boundary cases for casts of long shifts (#15294)
* [`[c1e44d9]`](https://github.com/dotnet/coreclr/commit/c1e44d9) Jumpstub fixes (#15296)
* [`[46650a1]`](https://github.com/dotnet/coreclr/commit/46650a1) Unmark unused fields as lvOnFrame
* [`[df04597]`](https://github.com/dotnet/coreclr/commit/df04597) delete the second definition of getMethodNameFromMetadata2
* [`[475f297]`](https://github.com/dotnet/coreclr/commit/475f297) delete the second definition of getMethodNameFromMetadata
* [`[9a25658]`](https://github.com/dotnet/coreclr/commit/9a25658) Don't add triggers for arm/armlb/arm64 non-flow jobs
* [`[e744442]`](https://github.com/dotnet/coreclr/commit/e744442) Fixed DCE of call nodes (#15192)
* [`[be9b92a]`](https://github.com/dotnet/coreclr/commit/be9b92a) Use ILAsm from buildtools, take 2 (#15300)
* [`[c26e460]`](https://github.com/dotnet/coreclr/commit/c26e460) Expose Environment.ProcessorCount via EnvironmentAugments (#15297)
* [`[7c56397]`](https://github.com/dotnet/coreclr/commit/7c56397) [Local GC] Fail fast on exceptions within a standalone GC (#15290)
* [`[3360765]`](https://github.com/dotnet/coreclr/commit/3360765) [RyuJit] Delete contained workaround.  (#15257)
* [`[970884a]`](https://github.com/dotnet/coreclr/commit/970884a) Fix GC stress C bug for arm (#15269)
* [`[276449a]`](https://github.com/dotnet/coreclr/commit/276449a) Ensure CoreCLR Package version overwrite works correctly in test build
* [`[3363a3b]`](https://github.com/dotnet/coreclr/commit/3363a3b) Allow arm/armlb/arm64 to run additional jobs
* [`[f4c87b4]`](https://github.com/dotnet/coreclr/commit/f4c87b4) [Arm64] Fix UNROLL_LIMIT logic
* [`[118218e]`](https://github.com/dotnet/coreclr/commit/118218e) [tfs-changeset: 1682429]
* [`[f78693e]`](https://github.com/dotnet/coreclr/commit/f78693e) [ARM64] Align Compiler::lvaStressLclFldCB padding
* [`[e864120]`](https://github.com/dotnet/coreclr/commit/e864120) Use ILAsm from buildtools (#15172)
* [`[f89e46c]`](https://github.com/dotnet/coreclr/commit/f89e46c) [Arm64] SIMD genMultiRegCallStoreToLocal add missing produceReg
* [`[10d1879]`](https://github.com/dotnet/coreclr/commit/10d1879) [Arm64] Use REG_IP1 for genEpilogRestoreReg*
* [`[4c218db]`](https://github.com/dotnet/coreclr/commit/4c218db) Add double/float.TryFormat
* [`[a8c8978]`](https://github.com/dotnet/coreclr/commit/a8c8978) Port ValueStringBuilder updates/fixes from corefx
* [`[45f1a4f]`](https://github.com/dotnet/coreclr/commit/45f1a4f) Move FormatDouble/Single to managed code
* [`[39e99ca]`](https://github.com/dotnet/coreclr/commit/39e99ca) JIT: fix bug with int casts of long shifts (#15236)
* [`[c059a5f]`](https://github.com/dotnet/coreclr/commit/c059a5f) Fix netci.groovy braces after Linux/x86 change
* [`[a66defa]`](https://github.com/dotnet/coreclr/commit/a66defa) Disable muldimjagary test for arm
* [`[835767a]`](https://github.com/dotnet/coreclr/commit/835767a) Download test native binaries to correct location
* [`[9304ea2]`](https://github.com/dotnet/coreclr/commit/9304ea2) Put default interface support behind a COMPlus switch (#15233)
* [`[0efe34e]`](https://github.com/dotnet/coreclr/commit/0efe34e) Switch new TryParse* and TryFormat methods to use span-based format (#15238)
* [`[c755e3b]`](https://github.com/dotnet/coreclr/commit/c755e3b) [Local GC] Move knowledge of overlapped I/O objects to the EE through four callbacks (#14982)
* [`[f737ffb]`](https://github.com/dotnet/coreclr/commit/f737ffb) Auto-update ILAsmVersion.txt (#15199)
* [`[93ddc4d]`](https://github.com/dotnet/coreclr/commit/93ddc4d) Improve Monitor scaling (#14216)
* [`[193eb5a]`](https://github.com/dotnet/coreclr/commit/193eb5a) [x86/Linux] Enable CI unittest (#14442)
* [`[b9b174d]`](https://github.com/dotnet/coreclr/commit/b9b174d) Fix Powershell error (#15217)
* [`[b3957a3]`](https://github.com/dotnet/coreclr/commit/b3957a3) Simpler code (same as in String.Manipulation.cs). (#15223)
* [`[5ae97a6]`](https://github.com/dotnet/coreclr/commit/5ae97a6) Sort the Action/Func delegates (#15222)
* [`[dd74fca]`](https://github.com/dotnet/coreclr/commit/dd74fca) Use string.Create in BitConverter.ToString(byte[]) (#15218)
* [`[db342eb6]`](https://github.com/dotnet/coreclr/commit/db342eb6) added keu value to key not found exception (#15201)
* [`[5edc093]`](https://github.com/dotnet/coreclr/commit/5edc093) Delete unused file expandarray.h (#15204)
* [`[9da7cb7]`](https://github.com/dotnet/coreclr/commit/9da7cb7) Implementation for new string.contains api (#15180)
* [`[3c0149d]`](https://github.com/dotnet/coreclr/commit/3c0149d) Fixed parameter validation for Delegate.CreateDelegate method. (#15196)
* [`[e913ca2]`](https://github.com/dotnet/coreclr/commit/e913ca2) Move TextInfo to shared CoreLib partition (#15195)
* [`[06828ca]`](https://github.com/dotnet/coreclr/commit/06828ca) Fix namespaces and ThrowHelper
* [`[a7427d8]`](https://github.com/dotnet/coreclr/commit/a7427d8) Move Nullable and string normalization to shared CoreLib partition (#15184)
* [`[edb20d1]`](https://github.com/dotnet/coreclr/commit/edb20d1) [Arm64] Allow IsContainableMemoryOp() use
* [`[4c30649]`](https://github.com/dotnet/coreclr/commit/4c30649) [Arm64] support GBDJIT debug frame (#15174)
* [`[2486b80]`](https://github.com/dotnet/coreclr/commit/2486b80) Fix arm32 stub indirect tailcall
* [`[b9159bf]`](https://github.com/dotnet/coreclr/commit/b9159bf) Disable Automatic PR Perf Jobs (#15176)
* [`[9aafd0c]`](https://github.com/dotnet/coreclr/commit/9aafd0c) StringBuilder: Use Decimal.TryFormat (#15170)
* [`[a480afb]`](https://github.com/dotnet/coreclr/commit/a480afb) Clean up `GTF_CALL_VIRT_KIND_MASK` and related usage
* [`[639f903]`](https://github.com/dotnet/coreclr/commit/639f903) [Arm64] Assign temps to GT_SIMD arguments
* [`[5b5c3e9]`](https://github.com/dotnet/coreclr/commit/5b5c3e9) [Arm64] SIMD Normalize struct arg type
* [`[b09c77a]`](https://github.com/dotnet/coreclr/commit/b09c77a) [Arm64] SIMD morph varTypeIsStruct
* [`[817907e]`](https://github.com/dotnet/coreclr/commit/817907e) [Arm64] Fix LowerVirtualStubCall reg allocation
* [`[2dd921d]`](https://github.com/dotnet/coreclr/commit/2dd921d) Stop running Windows ARM64 Debug builds (and tests) by default
* [`[8238c0a]`](https://github.com/dotnet/coreclr/commit/8238c0a) Add string to ReadOnlySpan\<char> implicit cast (#15167)
* [`[4171446]`](https://github.com/dotnet/coreclr/commit/4171446) Cosmetic fixes after move to shared partition
* [`[5b1895d]`](https://github.com/dotnet/coreclr/commit/5b1895d) Fix all powershell invocations in scripts, CI code and tests to include -NoProfile (#15164)
* [`[776690a]`](https://github.com/dotnet/coreclr/commit/776690a) Ask buildtools to also restore ILAsm (#15103)
* [`[3d09d01]`](https://github.com/dotnet/coreclr/commit/3d09d01) Fix SSE2 and SSE4.1 APIs (#15160)
* [`[d861307]`](https://github.com/dotnet/coreclr/commit/d861307) Fix unused field warnings
* [`[1361109]`](https://github.com/dotnet/coreclr/commit/1361109) [RyuJit][x86] Set unused flag when replace an unused parent with a child. (#15157)
* [`[ff440aa]`](https://github.com/dotnet/coreclr/commit/ff440aa) Move ArraySegment and a few other files to shared CoreLib partition (#15158)
* [`[63f1a0f]`](https://github.com/dotnet/coreclr/commit/63f1a0f) Add Decimal.TryFormat span-based method (#15145)
* [`[58561e4]`](https://github.com/dotnet/coreclr/commit/58561e4) format spmi source (#15144)
* [`[30d20fd]`](https://github.com/dotnet/coreclr/commit/30d20fd) Delete unused leftovers from binary serialization (#15140)
* [`[6022278]`](https://github.com/dotnet/coreclr/commit/6022278) Move SafeBuffer and a few other files to shared CoreLib partition (#15141)
* [`[7fe84b1]`](https://github.com/dotnet/coreclr/commit/7fe84b1) Move UnmanagedMemoryAccessor to shared CoreLib partition (#15137)
* [`[edde119]`](https://github.com/dotnet/coreclr/commit/edde119) Temporary fix for arm/armlb/arm64 builds: always build Pri 1 tests
* [`[c8063b1]`](https://github.com/dotnet/coreclr/commit/c8063b1) Version: Use int.TryFormat & StringBuilder.Append(int) (#15132)
* [`[b3005fe]`](https://github.com/dotnet/coreclr/commit/b3005fe) Reduce allocations in StringBuilder.AppendFormat for primitive types (#15110)
* [`[8058720]`](https://github.com/dotnet/coreclr/commit/8058720) Change quotes.
* [`[cafeb14]`](https://github.com/dotnet/coreclr/commit/cafeb14) fix the adding (#15121)
* [`[3a8a2ea]`](https://github.com/dotnet/coreclr/commit/3a8a2ea) Add a core dump example.
* [`[94b08b7]`](https://github.com/dotnet/coreclr/commit/94b08b7) Set reg conflicts on contained IND
* [`[d685894]`](https://github.com/dotnet/coreclr/commit/d685894) Fix a few of createdump bugs. (#15079)
* [`[8867f59]`](https://github.com/dotnet/coreclr/commit/8867f59) Fix debuggable GenTree (#15081)
* [`[e919c04]`](https://github.com/dotnet/coreclr/commit/e919c04) Update jitbench harness to capture steady state data
* [`[43eca89]`](https://github.com/dotnet/coreclr/commit/43eca89) Fix genPrepForEHCodegen for arm64
* [`[da79c0d]`](https://github.com/dotnet/coreclr/commit/da79c0d) [Arm64] SIMD12 genCodeForStoreLcl*
* [`[2142989]`](https://github.com/dotnet/coreclr/commit/2142989) Move MemoryStream to shared CoreLib partition (#15116)
* [`[d1fd9ee]`](https://github.com/dotnet/coreclr/commit/d1fd9ee) [Arm64] SIMD fix SIMDIntrinsicSet* op2 life
* [`[ae83cf4]`](https://github.com/dotnet/coreclr/commit/ae83cf4) Re-enable tests disabled for #14665
* [`[9dd7d6d]`](https://github.com/dotnet/coreclr/commit/9dd7d6d) Move TaskToApm to shared CoreLib partition (#15113)
* [`[6c35fd0]`](https://github.com/dotnet/coreclr/commit/6c35fd0) Allow ByRef return types in Dynamic Method (#15106)
* [`[5304962]`](https://github.com/dotnet/coreclr/commit/5304962) Delete FriendAccessAllowedAttribute and associated dead code (#15101)
* [`[b785ee1]`](https://github.com/dotnet/coreclr/commit/b785ee1) Move debugger attributes to shared partition (#15100)
* [`[afa95ac]`](https://github.com/dotnet/coreclr/commit/afa95ac) Delete SuppressUnmanagedCodeSecurity on QCalls
* [`[9c1e0e0]`](https://github.com/dotnet/coreclr/commit/9c1e0e0) Use BT in switch lowering
* [`[b9affb4]`](https://github.com/dotnet/coreclr/commit/b9affb4) Delete unnecesary SuppressUnmanagedCodeSecurity annotations (#15102)
* [`[81b2ef4]`](https://github.com/dotnet/coreclr/commit/81b2ef4) Use TryFormat in StringBuilder
* [`[eddf809]`](https://github.com/dotnet/coreclr/commit/eddf809) Add TryFormat methods to {S}Byte, {U}Int16/32/64, and Boolean
* [`[c6f266f]`](https://github.com/dotnet/coreclr/commit/c6f266f) Change FormatFixed to avoid bounds checks
* [`[01ffc03]`](https://github.com/dotnet/coreclr/commit/01ffc03) Delete unused Thread::YieldTask (#15091)
* [`[02e499e]`](https://github.com/dotnet/coreclr/commit/02e499e) Fix #15057 MemoryStream.CopyToAsync calls Write / WriteAsync with count=0 (#15070)
* [`[29c15a0]`](https://github.com/dotnet/coreclr/commit/29c15a0) Rename mscorlib to System.Private.CoreLib in documentation (#15090)
* [`[19d9bd0]`](https://github.com/dotnet/coreclr/commit/19d9bd0) Fix up ConfiguredValueTaskAwaitable signature for new compiler checks (#15092)
* [`[c1bc3ca]`](https://github.com/dotnet/coreclr/commit/c1bc3ca) Fix STRESS_LCL_FLDS for ARM
* [`[1a017d6]`](https://github.com/dotnet/coreclr/commit/1a017d6) Fix RyuJIT/arm32 GS cookie check before JMP call
* [`[c9f0f00]`](https://github.com/dotnet/coreclr/commit/c9f0f00) Fix GenTree definition for GT_BITCAST
* [`[e08d951]`](https://github.com/dotnet/coreclr/commit/e08d951) Fix RyuJIT/arm32 GT_MUL_LONG node bashing
* [`[f7a53d1]`](https://github.com/dotnet/coreclr/commit/f7a53d1) Enable FEATURE_DATATARGET4 for Unix Arm builds (#15060)
* [`[30fb27b]`](https://github.com/dotnet/coreclr/commit/30fb27b) fix for il to native mapping etw events (#15038)
* [`[b2b7d2c]`](https://github.com/dotnet/coreclr/commit/b2b7d2c) Generic hardware intrinsics throw exception for non-numeric types (#15068)
* [`[fc8bd03]`](https://github.com/dotnet/coreclr/commit/fc8bd03) Do not check stmts after the tail call candidate if the optimization has been aborted already. (#15065)
* [`[793391a]`](https://github.com/dotnet/coreclr/commit/793391a) Clean up netci.groovy (#15030)
* [`[f701b96]`](https://github.com/dotnet/coreclr/commit/f701b96) fix format (#15064)
* [`[88527bb]`](https://github.com/dotnet/coreclr/commit/88527bb) Fix 14455: _opt_relrotarg_valref test failure on amd64. (#15032)

## CoreFX

* [`[30ab651]`](https://github.com/dotnet/corefx/commit/30ab651) Fix extra space in MSBuild variable that causes BuildingAnOfficialBuildLeg to be set incorrectly. (#29640)
* [`[597397f]`](https://github.com/dotnet/corefx/commit/597397f) Fix Number.ParseNumber to not assume '\0' at the end of the span (#29611)
* [`[04ef4de]`](https://github.com/dotnet/corefx/commit/04ef4de) [2.1] Split some sxl tests to netcoreapp
* [`[d5bfb7d]`](https://github.com/dotnet/corefx/commit/d5bfb7d) Clear Configuration property when gathering stable versions
* [`[ff90ee7]`](https://github.com/dotnet/corefx/commit/ff90ee7) Quotererefernceparameter2 (#29496)
* [`[309e72a]`](https://github.com/dotnet/corefx/commit/309e72a) Fix handling of Unix directories (#29502) (#29512)
* [`[10fb312]`](https://github.com/dotnet/corefx/commit/10fb312) Exclude private framework packages from stable update
* [`[22fadde]`](https://github.com/dotnet/corefx/commit/22fadde) Add two missing ConfigureAwait(false) calls in SocketsHttpHandler (#29465) (#29470)
* [`[81fdad3]`](https://github.com/dotnet/corefx/commit/81fdad3) Adding begin/end steps to build definitions (#29198)
* [`[1cb15df]`](https://github.com/dotnet/corefx/commit/1cb15df) Port "Keep SSL error queue clean"  to 2.1 (#29438)
* [`[6906dbf]`](https://github.com/dotnet/corefx/commit/6906dbf) Port to 2.1 - Fix performance regression in Guid.NewGuid on OSX (#29457)
* [`[484f904]`](https://github.com/dotnet/corefx/commit/484f904) Fix Process.ExitCode on mac for killed processes (#29407) (#29445)
* [`[f10d99c]`](https://github.com/dotnet/corefx/commit/f10d99c) Exclude TFM netcoreapp2.2 from packaging testing
* [`[77732da]`](https://github.com/dotnet/corefx/commit/77732da) Port #29413 to release branch
* [`[2e3622e]`](https://github.com/dotnet/corefx/commit/2e3622e) Move to 2.1 RC1 CLI
* [`[1e02e72]`](https://github.com/dotnet/corefx/commit/1e02e72) Switch source build property to DotNetBuildFromSource
* [`[72086b6]`](https://github.com/dotnet/corefx/commit/72086b6) Add better portable PDB caching to System.Diagnostics.StackTrace.
* [`[c590773]`](https://github.com/dotnet/corefx/commit/c590773) Move from rc1 to rtm prerelease label
* [`[136199d]`](https://github.com/dotnet/corefx/commit/136199d) Correctly deserialize constructed octet and bit strings (#29389)
* [`[ecbece3]`](https://github.com/dotnet/corefx/commit/ecbece3) Always use DnsEndPoint in SocketHttpHandler's ConnectAsync (#29286) (#29303)
* [`[3fb2e82]`](https://github.com/dotnet/corefx/commit/3fb2e82) Fix regression in SslStream eof handling (#29344)
* [`[35e4886]`](https://github.com/dotnet/corefx/commit/35e4886) Make build input urls secret so they can be used with secure feeds. (#29225)
* [`[2533ae7]`](https://github.com/dotnet/corefx/commit/2533ae7) Preserve pinned flag in {ReadOnly}Memory\<T>.Slice (#29246) (#29252)
* [`[80ed365]`](https://github.com/dotnet/corefx/commit/80ed365) Port three CoreCLR changes missed by mirror. (#29256)
* [`[d6736ce]`](https://github.com/dotnet/corefx/commit/d6736ce) Permit version mismatches during package testing for incremented ref assms
* [`[7367c0c]`](https://github.com/dotnet/corefx/commit/7367c0c) Ensure framework assemblies have higher version than those applied to previous frameworks when API or type location changes
* [`[850a896]`](https://github.com/dotnet/corefx/commit/850a896) Lock Vectors reference assembly to 4.1.3.0 and don't OOB it on netcoreapp2.0 (#29182)
* [`[f12dd15]`](https://github.com/dotnet/corefx/commit/f12dd15) Ensure LocalCertificateSelectionCallback is still called with AuthenticateAsServerAsync (#29167) (#29233)
* [`[f443d03]`](https://github.com/dotnet/corefx/commit/f443d03) Fix TraceSource handling of GetEntryAssembly (#29228)
* [`[350f931]`](https://github.com/dotnet/corefx/commit/350f931) More SSL error queue cleaning (#29171) (#29194)
* [`[937caf1]`](https://github.com/dotnet/corefx/commit/937caf1) Add linux-musl build leg
* [`[98b3a60]`](https://github.com/dotnet/corefx/commit/98b3a60) Fix bug in ReadOnlySequence Slice(SequencePosition start, long length) for null next segment (#29205)
* [`[b162fb2]`](https://github.com/dotnet/corefx/commit/b162fb2) Attempt at winning back performance regression from additional checks in ReadOnlySequence.Slice (#29135)
* [`[0b1d600]`](https://github.com/dotnet/corefx/commit/0b1d600) Pass matching arm64 arch to build-managed step
* [`[6913829]`](https://github.com/dotnet/corefx/commit/6913829) Set prerelease label to rc1
* [`[0b9a376]`](https://github.com/dotnet/corefx/commit/0b9a376) Fix nestedRead tracking in SslStreamInternal.ReadAsyncInternal (#29130)
* [`[18cac5a]`](https://github.com/dotnet/corefx/commit/18cac5a) change sync timeout handling back to use actual sync timeouts (#29132)
* [`[2f0bb1d]`](https://github.com/dotnet/corefx/commit/2f0bb1d) Update the Slice performance tests to only measure the Slice method (#29133)
* [`[00fcaf8]`](https://github.com/dotnet/corefx/commit/00fcaf8) Delete faulty assert in SslStreamInternal (#29131)
* [`[fe481af]`](https://github.com/dotnet/corefx/commit/fe481af) dispatch sync op handling back to calling thread to avoid thread starvation
* [`[9d5f9ea]`](https://github.com/dotnet/corefx/commit/9d5f9ea) Run docker commands in a container without a local filesystem mounted volume (#29096)
* [`[27149e4]`](https://github.com/dotnet/corefx/commit/27149e4) Add basic GET SocketsHttpHandler perf tests (#29105)
* [`[1e0148b]`](https://github.com/dotnet/corefx/commit/1e0148b) Fix default style argument to Double/Single/Decimal.Parse (#29099)
* [`[0698997]`](https://github.com/dotnet/corefx/commit/0698997) SocketsHttpHandler: Add workaround for ipv6 LLA address (#28971)
* [`[d38496f]`](https://github.com/dotnet/corefx/commit/d38496f) Add basic ArrayPool cleaning tests (#29043)
* [`[41f5bfc]`](https://github.com/dotnet/corefx/commit/41f5bfc) Manual mirror of changes to Memory\<T> from coreclr (to get NETFX passing)
* [`[c58200e]`](https://github.com/dotnet/corefx/commit/c58200e) Remap EBADF in SocketErrorPal.Unix.cs to OperationAborted (#29091)
* [`[320fda3]`](https://github.com/dotnet/corefx/commit/320fda3) Fix getting shortname of file for Attachment class (#28851)
* [`[45dc12d]`](https://github.com/dotnet/corefx/commit/45dc12d) Update ProjectNTfs, ProjectNTfsTestILC to beta-26413-00, beta-26413-00, respectively (#29083)
* [`[878dfda]`](https://github.com/dotnet/corefx/commit/878dfda) Use string.IsNullOrEmpty to eliminate bounds check to first char (#17512) (#29082)
* [`[5c01da9]`](https://github.com/dotnet/corefx/commit/5c01da9) Collapse leftover AsSpan().Slice(...) into AsSpan(...) (#29078)
* [`[c8a76cf]`](https://github.com/dotnet/corefx/commit/c8a76cf) Fix wrong value in codedoc (#29053)
* [`[712d306]`](https://github.com/dotnet/corefx/commit/712d306) Optimize proxy PAC file discovery process for SocketsHttpHandler (#29050)
* [`[1b643bd]`](https://github.com/dotnet/corefx/commit/1b643bd) Mirror changes from dotnet/coreclr (#29044)
* [`[5411a5c]`](https://github.com/dotnet/corefx/commit/5411a5c) Disable SSL3 test case on RedHat 6 (#28998)
* [`[73214ff]`](https://github.com/dotnet/corefx/commit/73214ff) Fix intermittent test failure in System.Buffers (#29046)
* [`[437e882]`](https://github.com/dotnet/corefx/commit/437e882) Simplify sspicli interop marshaling (#29031)
* [`[d4894ca]`](https://github.com/dotnet/corefx/commit/d4894ca) Simple trim of ArrayPool buffers (dotnet/coreclr#17078)
* [`[e621412]`](https://github.com/dotnet/corefx/commit/e621412) Added test for logging exception details on calls to Environment.FailFast (#28644)
* [`[0bafd87]`](https://github.com/dotnet/corefx/commit/0bafd87) fix get for UseDefaultCredentials with SockerHttpHandler (#28982)
* [`[e076f6b]`](https://github.com/dotnet/corefx/commit/e076f6b) Accessing an accessible drive (#29010)
* [`[bdfc919]`](https://github.com/dotnet/corefx/commit/bdfc919) Enable package signing before final publish
* [`[5bcedee]`](https://github.com/dotnet/corefx/commit/5bcedee) Make HttpWebResponse.LastModified throw when invalid date is provided (#29006)
* [`[b703f31]`](https://github.com/dotnet/corefx/commit/b703f31) Handle User-Agent/Server writing similarly to HttpHeaders.GetHeaderString (#28994)
* [`[f4f23db]`](https://github.com/dotnet/corefx/commit/f4f23db) Regenerate System.Threading ref with latest buildtools changes (#28999)
* [`[fd9b025]`](https://github.com/dotnet/corefx/commit/fd9b025) Test Disabled for non-english CI (#28952)
* [`[af8ca4f]`](https://github.com/dotnet/corefx/commit/af8ca4f) Aggressive Inline fast-path of BuffersExtensions split methods (#28928)
* [`[124c68c]`](https://github.com/dotnet/corefx/commit/124c68c) Removing SequenceMarshal.TryGetMemoryManager for ReadOnlySequence (#28990)
* [`[158ed4d]`](https://github.com/dotnet/corefx/commit/158ed4d) Add more logging to SocketsHttpHandler (#28943)
* [`[c8fd8f7]`](https://github.com/dotnet/corefx/commit/c8fd8f7) Removing ActiveIssue for already closed issue #21000 (#28904)
* [`[50ec1e2]`](https://github.com/dotnet/corefx/commit/50ec1e2) Reenable ASin test (#28988)
* [`[e9504da]`](https://github.com/dotnet/corefx/commit/e9504da) Ensure ConnectHelper creates a Segment with a min of 2 (#28983)
* [`[bd1911e]`](https://github.com/dotnet/corefx/commit/bd1911e) Update the System.Runtime and System.Memory ref based on new buildtools (#28906)
* [`[960aae8]`](https://github.com/dotnet/corefx/commit/960aae8) Fixed autolog tests (#28939)
* [`[7979727]`](https://github.com/dotnet/corefx/commit/7979727) Fix ROM Content Test to use IMemoryOwner instead of MemoryManager (#28947)
* [`[1f665aa]`](https://github.com/dotnet/corefx/commit/1f665aa) Use non-inlineable overload for rare CompareOrdinalIgnoreCase path (#17492)
* [`[385286a]`](https://github.com/dotnet/corefx/commit/385286a) Make X509_store_add_crl throw on unexpected errors (#28966)
* [`[a2142d9]`](https://github.com/dotnet/corefx/commit/a2142d9) Silent the warning on XCode 9.3's clang (#28976)
* [`[943e316]`](https://github.com/dotnet/corefx/commit/943e316) Fixed netfx System.Data.Common.Tests fails on non English Windows (#28181)
* [`[14569ae]`](https://github.com/dotnet/corefx/commit/14569ae) Enable native build with Clang 6.0 (#28919)
* [`[728db8f]`](https://github.com/dotnet/corefx/commit/728db8f) propagate default credentials so we can pick up default ticket if available (#28964)
* [`[1dfe097]`](https://github.com/dotnet/corefx/commit/1dfe097) Fix MemoryManager ctor, add unit and perf tests, and improve performance (#28880)
* [`[14f5d53]`](https://github.com/dotnet/corefx/commit/14f5d53)  Clear SSL error queue after SSL_shutdown calls (#28949)
* [`[3ad8ce5]`](https://github.com/dotnet/corefx/commit/3ad8ce5) Change missed while mirroring (#28955)
* [`[ee3aeb3]`](https://github.com/dotnet/corefx/commit/ee3aeb3) Date changed for English and Us date writing style (#28945)
* [`[1d23691]`](https://github.com/dotnet/corefx/commit/1d23691) ReadOnlySequence.ToString() and debug view (#28857)
* [`[c4d843f]`](https://github.com/dotnet/corefx/commit/c4d843f) Clean dead code for System.Console (#28908)
* [`[753f4c1]`](https://github.com/dotnet/corefx/commit/753f4c1) Data.Common tests fixed for non english windows (#28872)
* [`[06fb488]`](https://github.com/dotnet/corefx/commit/06fb488) Add YieldAwaiter support to the async method builder delegate optimization (#17441)
* [`[36dab27]`](https://github.com/dotnet/corefx/commit/36dab27) Vectorize and use ROSpan.LastIndexOf as the workhorse for string.LastIndexOf (#17370)
* [`[33835aa]`](https://github.com/dotnet/corefx/commit/33835aa) Consolidate and optimize TextInfo.ChangeCase (dotnet/coreclr#17391)
* [`[ec067c8]`](https://github.com/dotnet/corefx/commit/ec067c8) Avoid unnecessary string allocations in IdnMapping (dotnet/coreclr#17399)
* [`[275752f]`](https://github.com/dotnet/corefx/commit/275752f) Fix regression on OpenSsl exception message (#28931)
* [`[a036d70]`](https://github.com/dotnet/corefx/commit/a036d70) Add {ReadOnly}Memory.Span tests when memory contains invalid values (#28896)
* [`[d3b7058]`](https://github.com/dotnet/corefx/commit/d3b7058) Registry Test SetValueWithEnvironmentVariable disabled (#28893)
* [`[d66a9cd]`](https://github.com/dotnet/corefx/commit/d66a9cd) Add more ValueTask perf tests (#28937)
* [`[7be5db3]`](https://github.com/dotnet/corefx/commit/7be5db3) Stop nulling out fields in SafeDeleteSslContext dispose. (#28889)
* [`[da1322d]`](https://github.com/dotnet/corefx/commit/da1322d) Fixed netfx System.Configuration.ConfigurationManager.Tests on non English Windows (#28164)
* [`[4fbd47f]`](https://github.com/dotnet/corefx/commit/4fbd47f) Update symbol uploader to 1.0.0-beta-62806-01.
* [`[37774fd]`](https://github.com/dotnet/corefx/commit/37774fd) Disable Tizen CI runs
* [`[11a5782]`](https://github.com/dotnet/corefx/commit/11a5782) Base64Encoder mini changes (#28888)
* [`[26e0f52]`](https://github.com/dotnet/corefx/commit/26e0f52) Improve CMake detection on Windows when not in PATH
* [`[72e8ae3]`](https://github.com/dotnet/corefx/commit/72e8ae3) Disable StackTrace tests to have a clean CI (#28869)
* [`[ffb1698]`](https://github.com/dotnet/corefx/commit/ffb1698) Increase window for process start time test (#28852)
* [`[a04d731]`](https://github.com/dotnet/corefx/commit/a04d731) Fix commas, demote ES-ES execution to Outerloop only
* [`[43268a1]`](https://github.com/dotnet/corefx/commit/43268a1) Optimistically add Windows.10.Amd64.ClientRS3.ES.Open as CI (will need to be optional if it's not 100% passing)
* [`[9372f2b]`](https://github.com/dotnet/corefx/commit/9372f2b) Ensure we use a unique path to package test semaphore (#28827)
* [`[61ad2cb]`](https://github.com/dotnet/corefx/commit/61ad2cb) Add regression test for Task handling of suppressed ExecutionContext flow (#28809)
* [`[368511a]`](https://github.com/dotnet/corefx/commit/368511a) Throw the same exception for data too big and data too small in RSA Decrypt
* [`[8b66ba0]`](https://github.com/dotnet/corefx/commit/8b66ba0) Handle recycled child PIDs (#27763)
* [`[b3ba359]`](https://github.com/dotnet/corefx/commit/b3ba359) Add a few IdnMapping tests (#28797)
* [`[9695cbb]`](https://github.com/dotnet/corefx/commit/9695cbb) reenable test cases disabled in 27740 (#28829)
* [`[14fbc9a]`](https://github.com/dotnet/corefx/commit/14fbc9a) Enable skipped test.
* [`[28dcece]`](https://github.com/dotnet/corefx/commit/28dcece) Re-enable PostAsync_RedirectWith307_LargePayload #23768 (#28828)
* [`[5d669ef]`](https://github.com/dotnet/corefx/commit/5d669ef) Update netfx queues to use rs3 machines with .net471 installed (#28572)
* [`[8d2f167]`](https://github.com/dotnet/corefx/commit/8d2f167) Rethrown exception call stack tests (#28059)
* [`[76be44e]`](https://github.com/dotnet/corefx/commit/76be44e) Enable a thread pool bound handle test on uap (#28824)
* [`[e752319]`](https://github.com/dotnet/corefx/commit/e752319) Update WhenAllOrAnyFailed test helper with aggregation timeout (#28811)
* [`[81e8281]`](https://github.com/dotnet/corefx/commit/81e8281) Update download link for PerfView tool (#28822)
* [`[22e88da]`](https://github.com/dotnet/corefx/commit/22e88da) Improve parsing of WinINet default proxy strings in SocketsHttpHandler  (#28671)
* [`[0a61daf]`](https://github.com/dotnet/corefx/commit/0a61daf) Disable draining test on CurlHandler (#28814)
* [`[9693747]`](https://github.com/dotnet/corefx/commit/9693747) build-native.sh fails when using 'uname -p' to determine arch. (#28762)
* [`[0b6a914]`](https://github.com/dotnet/corefx/commit/0b6a914) Prefix WWW-Authenticate header with scheme per RFC 4559 (#27755)
* [`[0c7a1de]`](https://github.com/dotnet/corefx/commit/0c7a1de) Make default SocketsHttpHandler SslProtocols include Tls11/12 on Win7/2008R2 (#28788)
* [`[4ba8b54]`](https://github.com/dotnet/corefx/commit/4ba8b54) Use cached IdnMapping instances (#28800)
* [`[2ed087e]`](https://github.com/dotnet/corefx/commit/2ed087e) Removing unused Target
* [`[e43901d]`](https://github.com/dotnet/corefx/commit/e43901d) SslStream IDN mapping host name on Windows (#28725)
* [`[d8ee1a7]`](https://github.com/dotnet/corefx/commit/d8ee1a7) Adding support for ncurses 6.1 TERM format on System.Console (#28786)
* [`[9403c51]`](https://github.com/dotnet/corefx/commit/9403c51) Existing Directory ReadOnlyVolume Disabled for alpine (#28783)
* [`[52897e9]`](https://github.com/dotnet/corefx/commit/52897e9) Fix grammar issue that made sentence ambiguous (#28785)
* [`[46c1fa7]`](https://github.com/dotnet/corefx/commit/46c1fa7) Improve throughput of Uri construction (#28776)
* [`[d5b1429]`](https://github.com/dotnet/corefx/commit/d5b1429) Fix allocated Encoding memory initialization (#28720)
* [`[4d6521c]`](https://github.com/dotnet/corefx/commit/4d6521c) Stop artificially rooting SocketAsyncEventArgs (#28767)
* [`[bcc792b]`](https://github.com/dotnet/corefx/commit/bcc792b) Pin PlatformAbstraction version to last stable
* [`[0eefc03]`](https://github.com/dotnet/corefx/commit/0eefc03) Pin PlatformAbstraction version to last stable
* [`[586cffc]`](https://github.com/dotnet/corefx/commit/586cffc) Fix ProxyExplicitlyProvided_DefaultCredentials_Ignored test (#28770)
* [`[0ce0f2a]`](https://github.com/dotnet/corefx/commit/0ce0f2a) Add char.ToLower/Upper perf tests (#28765)
* [`[2c1b406]`](https://github.com/dotnet/corefx/commit/2c1b406) In NamedArgumentTests - wrap Console.SetOut in a helper function that will override the console before test and reset it after test. Fixes #28667
* [`[fac2bf7]`](https://github.com/dotnet/corefx/commit/fac2bf7) Add new Debian.9.Amd64 queue.  Debian's Azure versioning is unusual, so this queue represents "newest available".
* [`[bd8c8ed]`](https://github.com/dotnet/corefx/commit/bd8c8ed) Switch threading perf tests to use constant instead of Benchmark.InnerIteration (#28728)
* [`[c9d1ec1]`](https://github.com/dotnet/corefx/commit/c9d1ec1) add proxy bypass list processing for windows (#28210)
* [`[25c5878]`](https://github.com/dotnet/corefx/commit/25c5878) Use a non-contigous Dictionary for tests (#28643)
* [`[aca5753]`](https://github.com/dotnet/corefx/commit/aca5753) Slight grammar improvement to coding-style.md (#28723)
* [`[24889e2]`](https://github.com/dotnet/corefx/commit/24889e2) Fix ipv6 address format in Host header (#28578)
* [`[5f574a5]`](https://github.com/dotnet/corefx/commit/5f574a5) Fix the message for Cryptography_InvalidPadding
* [`[d67ea51]`](https://github.com/dotnet/corefx/commit/d67ea51) ArrayMemoryPoolBuffer should only implement IMemoryOwner\<T> (#28690)
* [`[b01e361]`](https://github.com/dotnet/corefx/commit/b01e361) Increase iteration counts in threading perf tests (#28712)
* [`[660dc94]`](https://github.com/dotnet/corefx/commit/660dc94) if server sends invalid challenge, don't continue processing (#28704)
* [`[b96c29a]`](https://github.com/dotnet/corefx/commit/b96c29a) Fix intermittent crashes on FileSystemEnumeration on Unix (#28692)
* [`[d73eb91]`](https://github.com/dotnet/corefx/commit/d73eb91) Fix thread constructor test on newer kernels (#28613)
* [`[a9a5ca9]`](https://github.com/dotnet/corefx/commit/a9a5ca9) Fix Dictionary CopyTo regression (dotnet/coreclr#17300)
* [`[66c9cdc]`](https://github.com/dotnet/corefx/commit/66c9cdc) Update issue-guide.md (#28685)
* [`[ec5fb41]`](https://github.com/dotnet/corefx/commit/ec5fb41) Avoid unnecessarily propagating ExecutionContext in SocketAsyncEngine (#28676)
* [`[fe0edc4]`](https://github.com/dotnet/corefx/commit/fe0edc4) Marking tests affected by 27740 in XmlSchemaValidatorApi as active issue (#28679)
* [`[83c87a0]`](https://github.com/dotnet/corefx/commit/83c87a0) Make AsSpan(this string) ForceInline to be on par with AsSpan(this T[]) (#17368)
* [`[031e40a]`](https://github.com/dotnet/corefx/commit/031e40a) Disable frequently failing GetAsync_SupportedSSLVersion_Succeeds test
* [`[3cc6fda]`](https://github.com/dotnet/corefx/commit/3cc6fda) Stop blocking explicit opt-in to Ssl2/3 in SslStream and HttpClient (#28639)
* [`[e49a617]`](https://github.com/dotnet/corefx/commit/e49a617) React to X509Chain changes in macOS 10.13.4 (#28673)
* [`[2a7568d]`](https://github.com/dotnet/corefx/commit/2a7568d) Emit less junk from Process test (#28669)
* [`[79b3c40]`](https://github.com/dotnet/corefx/commit/79b3c40) Enable optional tools in no-test build definition
* [`[00bcad0]`](https://github.com/dotnet/corefx/commit/00bcad0) SslStream mutates state of options (#28666)
* [`[6f38488]`](https://github.com/dotnet/corefx/commit/6f38488) FontFamily.Equals in Linux use .Name instead of NativeFamily pointer which is not a singleton (#28650)
* [`[a9ecb8e]`](https://github.com/dotnet/corefx/commit/a9ecb8e) Removing System.Runtime.Caching/src/MatchingRefApiCompatBaseline.txt (#28665)
* [`[f592e88]`](https://github.com/dotnet/corefx/commit/f592e88) Split OwnedMemory into MemoryManager and IMemoryOwner (#28640)
* [`[3664968]`](https://github.com/dotnet/corefx/commit/3664968) Fix race condition on read ahead task in SocketsHttpHandler (#28637)
* [`[9919aa9]`](https://github.com/dotnet/corefx/commit/9919aa9) Enable optional tools in no-test build definition
* [`[2d4a49d]`](https://github.com/dotnet/corefx/commit/2d4a49d) Fixing two additional package tests (#28654)
* [`[3f376c3]`](https://github.com/dotnet/corefx/commit/3f376c3) Fix 1DES and RC2 CryptoServiceProvider CreateTransform tests on Unix
* [`[78357cf]`](https://github.com/dotnet/corefx/commit/78357cf) Make TripleDESCryptoServiceProvider CreateTransform behave like netfx
* [`[2d39212]`](https://github.com/dotnet/corefx/commit/2d39212) Add server-side SNI support (#28278)
* [`[f6ff5c2]`](https://github.com/dotnet/corefx/commit/f6ff5c2) Making types listed in #27980 internal (#28636)
* [`[74126ca]`](https://github.com/dotnet/corefx/commit/74126ca) Fix Microsoft.VisualBasic Ref API surface issues (#28531)
* [`[73e8a1f]`](https://github.com/dotnet/corefx/commit/73e8a1f) Using random string for temp files (#28589)
* [`[94fe402]`](https://github.com/dotnet/corefx/commit/94fe402) Fix ConnectionTimeoutTestWithThread test (#28618)
* [`[7cd1637]`](https://github.com/dotnet/corefx/commit/7cd1637) Fix MatchingRefApiCompat issues (#28369)
* [`[82518b9]`](https://github.com/dotnet/corefx/commit/82518b9) Do not resume reader on 0-byte FlushAsync (#28550)
* [`[3d6e00c]`](https://github.com/dotnet/corefx/commit/3d6e00c) Fix MatchingRefApiCompat issues in Serialization libraries (#28552)
* [`[1ad8ed9]`](https://github.com/dotnet/corefx/commit/1ad8ed9) Use ROSpan.IndexOf as the workhorse for string.IndexOf (#17284) (#28635)
* [`[d1d5135]`](https://github.com/dotnet/corefx/commit/d1d5135) Make AuthenticationException message less platform-specific (#28645)
* [`[06aa6f0]`](https://github.com/dotnet/corefx/commit/06aa6f0) Reduce buffering in ManagedWebSocket.ReceiveAsync (#28577)
* [`[458ee02]`](https://github.com/dotnet/corefx/commit/458ee02) Update dogfood instructions with current SDK version (#28601)
* [`[81ba628]`](https://github.com/dotnet/corefx/commit/81ba628) Support musl-libc based linux RIDs (#28560)
* [`[da8c62d]`](https://github.com/dotnet/corefx/commit/da8c62d) Pool SocketAsyncEventArgs used to establish connections
* [`[fdfc497]`](https://github.com/dotnet/corefx/commit/fdfc497) Split ConcurrentQueue\<T>.Segment into its own file
* [`[b4301aa]`](https://github.com/dotnet/corefx/commit/b4301aa) Dispose connections immediately when returned to a pool with zero timeouts
* [`[48719a0]`](https://github.com/dotnet/corefx/commit/48719a0) Avoid creating cleaning timer if no connections will ever be added to pool
* [`[f52fa89]`](https://github.com/dotnet/corefx/commit/f52fa89) Dict cache default comparer for object types (dotnet/coreclr#17285)
* [`[1bc72c1]`](https://github.com/dotnet/corefx/commit/1bc72c1) StringBuilder.Equals: value to span (dotnet/coreclr#17311)
* [`[5ffc9b3]`](https://github.com/dotnet/corefx/commit/5ffc9b3) Re-enable GetTaskSchedulersForDebugger test (#28564)
* [`[5830df2]`](https://github.com/dotnet/corefx/commit/5830df2) Using System.ComponentModel.Composition vs. System.Composition to get exports (#28483)
* [`[620d014]`](https://github.com/dotnet/corefx/commit/620d014) Make it clear that the default proxy cannot by set via environment variable on Windows (#28610)
* [`[2d420dd]`](https://github.com/dotnet/corefx/commit/2d420dd) Disable OOBing for Vectors on NCA2.1 and UAP6+
* [`[fd7048c]`](https://github.com/dotnet/corefx/commit/fd7048c) Fix missing System.Memory dependency from Registry
* [`[f78d8f5]`](https://github.com/dotnet/corefx/commit/f78d8f5) MS.NETCore.Targets should not be tested on 1.x as it drops all runtime-dependencies
* [`[e449875]`](https://github.com/dotnet/corefx/commit/e449875) Permit cycles in netstandard when testing OOB packages
* [`[1c6f2fa]`](https://github.com/dotnet/corefx/commit/1c6f2fa) Enable package testing of latest NETCoreApp2.1
* [`[96ca402]`](https://github.com/dotnet/corefx/commit/96ca402) Ensure we run on private CLI/SDK and not a newer machine wide one
* [`[ab8633a]`](https://github.com/dotnet/corefx/commit/ab8633a) Exclude CoreFx.Private.TestUtilities from testing
* [`[a74bc9b]`](https://github.com/dotnet/corefx/commit/a74bc9b) Ensure we test runtime closure
* [`[1d0b451]`](https://github.com/dotnet/corefx/commit/1d0b451) Fix System.Security.Permissions facade.
* [`[fd04b17]`](https://github.com/dotnet/corefx/commit/fd04b17) Permit type overlap between System.Memory and S.P.Corelib on netcoreapp2.0
* [`[2219e55]`](https://github.com/dotnet/corefx/commit/2219e55) Account for source-build in our package build filtering
* [`[b50c15c]`](https://github.com/dotnet/corefx/commit/b50c15c) Fix compat pack publish script to work if we build corefx on debug or release mode (#28608)
* [`[dad4b72]`](https://github.com/dotnet/corefx/commit/dad4b72) Nit changes in API diff between .NET Core 2.0 and .NET Core 2.1 (#17288)
* [`[f519454]`](https://github.com/dotnet/corefx/commit/f519454) Produce Windows PDBs when building for netfx and in a Windows OS (#28562)
* [`[a4c601d]`](https://github.com/dotnet/corefx/commit/a4c601d) Sgen parameter conversion change: replace colon with space in arguments (#28439)
* [`[2d7b6dc]`](https://github.com/dotnet/corefx/commit/2d7b6dc) Reenable SetHdevmode_IntPtr_Success test (#28598)
* [`[0257e6c]`](https://github.com/dotnet/corefx/commit/0257e6c) Enable digest test runs on CurlHandler. (#28571)
* [`[15a2915]`](https://github.com/dotnet/corefx/commit/15a2915) Add .NET 4.5 functionality and API to WindowsIdentity (#28526)
* [`[4203d94]`](https://github.com/dotnet/corefx/commit/4203d94) Account for source-build in our package build filtering
* [`[ab92eab]`](https://github.com/dotnet/corefx/commit/ab92eab) More api work (#28581)
* [`[fe63206]`](https://github.com/dotnet/corefx/commit/fe63206) enable tcp keep-alive on curl handler (#28588)
* [`[45fb8a6]`](https://github.com/dotnet/corefx/commit/45fb8a6) Disable Selectedsites test by default (#28599)
* [`[5f26635]`](https://github.com/dotnet/corefx/commit/5f26635) Add workarounds to package testing for issue 28551
* [`[f0279bf]`](https://github.com/dotnet/corefx/commit/f0279bf) NETStandard project now support desktop shims with dangling refs
* [`[ab5b5c0]`](https://github.com/dotnet/corefx/commit/ab5b5c0) Workaround NuGet restore bug in package tests
* [`[2c0a662]`](https://github.com/dotnet/corefx/commit/2c0a662) Prevent CMake 2.8 tests failing for unused variable (causing millisec to be dropped from stat calls) (#28573)
* [`[76e8479]`](https://github.com/dotnet/corefx/commit/76e8479) Improve Quaternion test failure messages (#28582)
* [`[5c55a8c]`](https://github.com/dotnet/corefx/commit/5c55a8c) Update ProjectNTfs, ProjectNTfsTestILC to beta-26329-00, beta-26329-00, respectively (#28586)
* [`[50d4e1c]`](https://github.com/dotnet/corefx/commit/50d4e1c) CurlHandler is deadlocking like WinHttpHandler (#28587)
* [`[21947fb]`](https://github.com/dotnet/corefx/commit/21947fb) Add WebSocket test for zero-byte receives (#28579)
* [`[9685e1d]`](https://github.com/dotnet/corefx/commit/9685e1d) Leverage existing string API tests to improve coverage of span-based APIs (#28347)
* [`[bb5c468]`](https://github.com/dotnet/corefx/commit/bb5c468) Mirror changes from dotnet/coreclr (#28534)
* [`[1cbcc78]`](https://github.com/dotnet/corefx/commit/1cbcc78) Set property in validation csproj (#28567)
* [`[22d053f]`](https://github.com/dotnet/corefx/commit/22d053f) Delete workaround for ComImport types on Unix (#28518)
* [`[b6b5982]`](https://github.com/dotnet/corefx/commit/b6b5982) Reuse HashHelpers for BinaryFormatter objectholder hashes (#25509)
* [`[4a42618]`](https://github.com/dotnet/corefx/commit/4a42618) Nit changes in API diff between .NET Core 2.0 and .NET Core 2.1 (#28540)
* [`[1d107ad]`](https://github.com/dotnet/corefx/commit/1d107ad) enable test (#28481)
* [`[56f02f3]`](https://github.com/dotnet/corefx/commit/56f02f3) Fixed  System.IO.FileSystem.AccessControl.Tests fails on non-English Windows (#28405)
* [`[b4cd6d1]`](https://github.com/dotnet/corefx/commit/b4cd6d1) Sync init-tools scripts with what is in source-build
* [`[35903bc]`](https://github.com/dotnet/corefx/commit/35903bc) Sync init-tools scripts with what is in source-build
* [`[f14366b]`](https://github.com/dotnet/corefx/commit/f14366b) Fix compat pack dependencies to be live pre-release and harvest System.Buffers ref to previously shipped version (#28428)
* [`[906f2d1]`](https://github.com/dotnet/corefx/commit/906f2d1) Archive generated performance files for future investigations. (#28477)
* [`[3a52c8a]`](https://github.com/dotnet/corefx/commit/3a52c8a) Fix calling FlushAsync with cancelled token (#28519)
* [`[8427f74]`](https://github.com/dotnet/corefx/commit/8427f74) Fixing naming inconsistency between System.Runtime and System.Memory refs. (#28529)
* [`[f32d349]`](https://github.com/dotnet/corefx/commit/f32d349) Fix branch distance calculation
* [`[4982068]`](https://github.com/dotnet/corefx/commit/4982068) Fix stack overflow exception due to XmlDictionaryReader.Close override (#28408)
* [`[dadbb55]`](https://github.com/dotnet/corefx/commit/dadbb55) Fix regression in StreamWriter.Write perf for small inputs (#17251)
* [`[305bebc]`](https://github.com/dotnet/corefx/commit/305bebc) Change Linux buffer size test to force small value. (#28512)
* [`[49daa89]`](https://github.com/dotnet/corefx/commit/49daa89) Add area-System.Threading.Tasks
* [`[00547db]`](https://github.com/dotnet/corefx/commit/00547db) Add references parameter for sgen. (#27425)
* [`[d5ecebe]`](https://github.com/dotnet/corefx/commit/d5ecebe) improve handling of proxy environmental variables (#28088)
* [`[6c70627]`](https://github.com/dotnet/corefx/commit/6c70627) Update OptimizationDataVersion
* [`[79de1fa]`](https://github.com/dotnet/corefx/commit/79de1fa) Fixed netfx System.DirectoryServices.AccountManagement.Tests fails on non-English Windows (#28318)
* [`[b458c89]`](https://github.com/dotnet/corefx/commit/b458c89) Ignore errors from SetPipeSz in AnonymousPipeServerStream on Unix (#28506)
* [`[04de4be]`](https://github.com/dotnet/corefx/commit/04de4be) Move String.Comparison.cs to shared CoreLib partition (#17247)
* [`[382a48f]`](https://github.com/dotnet/corefx/commit/382a48f) Delete MemoryExtensions.AsBytes (dotnet/coreclr#17245)
* [`[c05fdca]`](https://github.com/dotnet/corefx/commit/c05fdca) Add new file to the portable System.Memory
* [`[c857093]`](https://github.com/dotnet/corefx/commit/c857093) Vectorized SequenceCompareTo for Span\<char> (dotnet/coreclr#17237)
* [`[a96dd02]`](https://github.com/dotnet/corefx/commit/a96dd02) Improve Regex cache speed when cache is large (#27278)
* [`[48a6ca8]`](https://github.com/dotnet/corefx/commit/48a6ca8) Fixed netfs System.Xml.Xsl.XslCompiledTransformApi.Tests fails on non-English Windows (#28357)
* [`[248494c]`](https://github.com/dotnet/corefx/commit/248494c) Fixed netfx System.Net.Mail.Functional.Tests fails on non-English Windows (#28373)
* [`[c46fd93]`](https://github.com/dotnet/corefx/commit/c46fd93) New chunk should be equal/larger than the one it replaces (#17219)
* [`[958e07a]`](https://github.com/dotnet/corefx/commit/958e07a) Increasing AllowedWindow time, Fixes #28479 (#28490)
* [`[29f0ce5]`](https://github.com/dotnet/corefx/commit/29f0ce5) Enable partially implemented Intel HW intrinsics ISAs - CoreFX part
* [`[2242e10]`](https://github.com/dotnet/corefx/commit/2242e10) Add Regex perf test based on RegexRedux from benchmark game (#28487)
* [`[56c0ffa]`](https://github.com/dotnet/corefx/commit/56c0ffa) Support PositiveInfinity and NegativeInfinity as default value in sgen  (#27734)
* [`[94079a7]`](https://github.com/dotnet/corefx/commit/94079a7) Add a test to prevent regression when XmlUriResolver uses Uri.LocalPath (#28475)
* [`[e17fe35]`](https://github.com/dotnet/corefx/commit/e17fe35) Add logging to sporadically failing ExecutionContext flow test (#28484)
* [`[be48e96]`](https://github.com/dotnet/corefx/commit/be48e96) Break hangs on HashSet when a loop is formed on entries due to a concurrent operation (#28225)
* [`[d823138]`](https://github.com/dotnet/corefx/commit/d823138) Fix SQL Server version-related failures in manual SqlCredentialTest. (#28434)
* [`[6face34]`](https://github.com/dotnet/corefx/commit/6face34) Don't crash from RemoteInvoke if remote test fails (#28476)
* [`[8797ecb]`](https://github.com/dotnet/corefx/commit/8797ecb) Allow the Package properties stream to be caller-opened after modification
* [`[c16a231]`](https://github.com/dotnet/corefx/commit/c16a231) Simplify regression test to not use compiled xslt (#28440)
* [`[1a44ece]`](https://github.com/dotnet/corefx/commit/1a44ece) Fixed netfx System.Xml.Linq.xNodeBuilder.Tests fails on non English Windows (#28183)
* [`[8924709]`](https://github.com/dotnet/corefx/commit/8924709) Add readonly to s_gzipHeaderValue and s_deflateHeaderValue (#28469)
* [`[668b87c]`](https://github.com/dotnet/corefx/commit/668b87c) Call CancellationTokenRegistration.Unregister in AsyncInfoToTaskBridge to avoid leaking memory when the CancellationTokenSource is reused. (#28471)
* [`[008c119]`](https://github.com/dotnet/corefx/commit/008c119) Update uses of AsBytes to use MemoryMarshal.AsBytes (#28460)
* [`[6ca628d]`](https://github.com/dotnet/corefx/commit/6ca628d) Vectorize Span.IndexOf for T = char, similar to T = byte. (#28464)
* [`[451172d]`](https://github.com/dotnet/corefx/commit/451172d) Fix Path.GetTempFileName on Windows (dotnet/coreclr#17148)
* [`[d425aaf]`](https://github.com/dotnet/corefx/commit/d425aaf) Fixes StringBuilder unbounded size growth in Clear() when we use a mix of Append and Insert (#16926)
* [`[8b70122]`](https://github.com/dotnet/corefx/commit/8b70122) Fix CompareTo/Equals when dealing with Empty Span or Span wrapping a null string (#17115)
* [`[0a99919]`](https://github.com/dotnet/corefx/commit/0a99919) Fix some monitor tests, add one for lock wait paths (#28442)
* [`[8f47bfc]`](https://github.com/dotnet/corefx/commit/8f47bfc) Delete InternalsVisibleTo that are no longer needed (#28444)
* [`[320d57a]`](https://github.com/dotnet/corefx/commit/320d57a) Fixing test on uap by adding ExitCode to RemoteInvokeHandle (#28413)
* [`[57608f6]`](https://github.com/dotnet/corefx/commit/57608f6) Make HashAlgorithm.Create(string) and friends work on .NET Core (#28385)
* [`[61fdee4]`](https://github.com/dotnet/corefx/commit/61fdee4) Rename new Stream.Read/Write{Async} Span/Memory arguments to buffer (#28429)
* [`[68f0e3b]`](https://github.com/dotnet/corefx/commit/68f0e3b) Console: make Return key generate CR (#28362)
* [`[a673a11]`](https://github.com/dotnet/corefx/commit/a673a11) Rename new Stream.Read/Write{Async} Span/Memory source/Destination arguments to buffer (#17141)
* [`[6d9d9d2]`](https://github.com/dotnet/corefx/commit/6d9d9d2) Fix missing port number in HttpRequestMessage constructed by HttpWebRequest (#28375)
* [`[4a549f7]`](https://github.com/dotnet/corefx/commit/4a549f7) Disable some failing/hanging HTTP tests (#28425)
* [`[051f53b]`](https://github.com/dotnet/corefx/commit/051f53b) Update sgen usage and --parameters (#27332)
* [`[5608a9f]`](https://github.com/dotnet/corefx/commit/5608a9f) CurrentUserOnly should allow multiple servers on Windows (#28374)
* [`[8130620]`](https://github.com/dotnet/corefx/commit/8130620) Fix SRM nuspec
* [`[544f3c2]`](https://github.com/dotnet/corefx/commit/544f3c2) Fixed netfx System.IO.FileSystem.Tests fails on non-English Windows (#28313)
* [`[a89fa1b]`](https://github.com/dotnet/corefx/commit/a89fa1b) Update Unsafe configuratations
* [`[c239771]`](https://github.com/dotnet/corefx/commit/c239771) Disabling test on alpine (#28401)
* [`[6b94407]`](https://github.com/dotnet/corefx/commit/6b94407) Rename new Stream.Read/Write{Async} Span/Memory source/Destination arguments to buffer (#28397)
* [`[d754854]`](https://github.com/dotnet/corefx/commit/d754854) Update ProjectNTfs, ProjectNTfsTestILC to beta-26323-00, beta-26323-00, respectively (#28399)
* [`[3767d30]`](https://github.com/dotnet/corefx/commit/3767d30) Mirror changes from dotnet/coreclr (#28384)
* [`[9a72ba2]`](https://github.com/dotnet/corefx/commit/9a72ba2) Fixing MatchingRefApiCompat issues with Sys.Configuration.ConfigurationManager (#28394)
* [`[29b20ca]`](https://github.com/dotnet/corefx/commit/29b20ca) Normalize project configurations (#28396)
* [`[1d2c96e]`](https://github.com/dotnet/corefx/commit/1d2c96e) Fixed netfx System.ComponentModel.TypeConverter.Tests-InvariantCulture on non English Windows (#28168)
* [`[ee528ac]`](https://github.com/dotnet/corefx/commit/ee528ac) Fixed netfx System.Text.Encoding.Tests fails on non-English Windows (#28349)
* [`[77bf407]`](https://github.com/dotnet/corefx/commit/77bf407) Fix File.ReadAllBytes{Async} for virtual file system files (#28388)
* [`[53b6cc9]`](https://github.com/dotnet/corefx/commit/53b6cc9) Fixed netfx System.Runtime.Tests fails on non-English Windows (#28391)
* [`[f3768a7]`](https://github.com/dotnet/corefx/commit/f3768a7) Fixed netfx System.Runtime.Serialization.Formatters.Tests fails on non-English Windows (#28386)
* [`[4e3476b]`](https://github.com/dotnet/corefx/commit/4e3476b) Fixed netfx System.Net.WebSockets.Client.Tests fails on non-English Windows (#28380)
* [`[c0deeb3]`](https://github.com/dotnet/corefx/commit/c0deeb3) Fixed netfx System.Security.Cryptography.Xml.Tests fails on non-English Windows (#28316)
* [`[1b588ca]`](https://github.com/dotnet/corefx/commit/1b588ca)  CurlHandler: set ssl options to match X509 machine store certificates (#28312)
* [`[68b57e5]`](https://github.com/dotnet/corefx/commit/68b57e5) Process.StartTime on Linux - make it deterministic & compatible (#28193)
* [`[41c8ba2]`](https://github.com/dotnet/corefx/commit/41c8ba2) Sync PerformanceCounterLib (#26475)
* [`[3e5bf71]`](https://github.com/dotnet/corefx/commit/3e5bf71) Fixed netfx System.Threading.Tasks.Tests fails on non-English Windows (#28351)
* [`[c8fa64f]`](https://github.com/dotnet/corefx/commit/c8fa64f) wrap Read in loop as it can return less bytes than asked for (#28368)
* [`[1f93d2a]`](https://github.com/dotnet/corefx/commit/1f93d2a) Ensure SocketsHttpHandler throws TaskCanceledExceptions instead of OperationCanceledExceptions (#28075)
* [`[b2a1199]`](https://github.com/dotnet/corefx/commit/b2a1199) Improve HTTP proxy tests (#28048)
* [`[909b355]`](https://github.com/dotnet/corefx/commit/909b355) Simplify interop on Windows CreateProcess path (#28372)
* [`[09d84b7]`](https://github.com/dotnet/corefx/commit/09d84b7) Suppress NETStandard.Library package collapsing
* [`[32079aa]`](https://github.com/dotnet/corefx/commit/32079aa) Add Assembly.LoadFrom() fallback in AssemblyCatalog
* [`[ce4ebdf]`](https://github.com/dotnet/corefx/commit/ce4ebdf) Fix WinHttpHandler error handling (#28367)
* [`[08fd68b]`](https://github.com/dotnet/corefx/commit/08fd68b) Fix WebSockets receiving messages in chunks does not detect correct message size (#28325)
* [`[2f0716d]`](https://github.com/dotnet/corefx/commit/2f0716d) Fix ParseRoundTripTime() breaks on some cultures (#28229)
* [`[1201e72]`](https://github.com/dotnet/corefx/commit/1201e72) Lookup interface index when IN_PKTINFO isn't available (#27692)
* [`[69ba7ef]`](https://github.com/dotnet/corefx/commit/69ba7ef) Re-enable hostname resolution test on Linux, but skip under certain conditions (#28324)
* [`[be673b9]`](https://github.com/dotnet/corefx/commit/be673b9) Prevent leak through of failed export (#28273)
* [`[bd5c43d]`](https://github.com/dotnet/corefx/commit/bd5c43d) Adding UAP RS3 configurations for System.Buffers, System.Memory and System.Reflection.DispatchProxy (#28340)
* [`[04b86e3]`](https://github.com/dotnet/corefx/commit/04b86e3) Fix skipping last segment logic in ROS.TryGet (#28266)
* [`[cad1465]`](https://github.com/dotnet/corefx/commit/cad1465) Make ClientWebSocket always use CONNECT tunneling through a proxy (#28150)
* [`[fb1177a]`](https://github.com/dotnet/corefx/commit/fb1177a) Fix assert race condition in CurlResponseMessage (#28332)
* [`[9e8d443]`](https://github.com/dotnet/corefx/commit/9e8d443) Improve support for URIs without hosts (#28235)
* [`[bb39988]`](https://github.com/dotnet/corefx/commit/bb39988) Fixed netfx System.CodeDom.Tests on non English Windows (#28165)
* [`[619dbe6]`](https://github.com/dotnet/corefx/commit/619dbe6) Fixed netfx System.Runtime.Extensions.Tests fails on non-English Windows (#28361)
* [`[5f4e97d]`](https://github.com/dotnet/corefx/commit/5f4e97d) Enable System.Reflection.Pointer tests on UapAot (#28327)
* [`[2e1c372]`](https://github.com/dotnet/corefx/commit/2e1c372) Don't skip blocks passed end and simplify the Seek implementation. (#28294)
* [`[3a59545]`](https://github.com/dotnet/corefx/commit/3a59545) Disable Millisec test on Linux (#28345)
* [`[f11ce88]`](https://github.com/dotnet/corefx/commit/f11ce88) Use aot friendly interop in System.Diagnostics.Process (#28329)
* [`[cd3dada]`](https://github.com/dotnet/corefx/commit/cd3dada) Re-enable unaccounted disabled tests on UapAot (#28331)
* [`[ac69852]`](https://github.com/dotnet/corefx/commit/ac69852) Restore ProjectN package consistency check (#28217)
* [`[ddbe9b1]`](https://github.com/dotnet/corefx/commit/ddbe9b1) Fix MemorExtensions.Portable Equals to use the correct argument name (#28339)
* [`[a8cfc6a]`](https://github.com/dotnet/corefx/commit/a8cfc6a) Optimize the string-like Span APIs for OrdinalIgnoreCase (portable Span) (#28239)
* [`[c723a9f]`](https://github.com/dotnet/corefx/commit/c723a9f) Fix SRM nuspec
* [`[2169709]`](https://github.com/dotnet/corefx/commit/2169709) [Arm64/Ubuntu] Rework official build flow to support bootstrapping (#28289)
* [`[2241a45]`](https://github.com/dotnet/corefx/commit/2241a45) Don't run LargeArray test on 32 bit platforms. (#28237)
* [`[6c3710a]`](https://github.com/dotnet/corefx/commit/6c3710a) Persist the expected output and generate data more systematically (#28197)
* [`[3540d12]`](https://github.com/dotnet/corefx/commit/3540d12) Change directory in AgentTools tasks
* [`[2aea874]`](https://github.com/dotnet/corefx/commit/2aea874) Change directory in AgentTools tasks
* [`[f0e6737]`](https://github.com/dotnet/corefx/commit/f0e6737) Change directory in AgentTools tasks
* [`[10f0a43]`](https://github.com/dotnet/corefx/commit/10f0a43) Change directory in AgentTools tasks
* [`[ec49c39]`](https://github.com/dotnet/corefx/commit/ec49c39) [Arm64] Switch to new pipelines.groovy CI (#28280)
* [`[538744d]`](https://github.com/dotnet/corefx/commit/538744d) Make WindowsPrincipalIsInRoleNeg pass when a domain client is offline
* [`[3c5ecc1]`](https://github.com/dotnet/corefx/commit/3c5ecc1) Fixed netfx System.Diagnostics.StackTrace.Tests fails on non English Windows. (#28291)
* [`[c97df33]`](https://github.com/dotnet/corefx/commit/c97df33) Fixed netfx System.Drawing.Common.Tests fials on non-English Windows (#28307)
* [`[a60d4b0]`](https://github.com/dotnet/corefx/commit/a60d4b0) Fix up static field names in Console (#28300)
* [`[ab65f5e]`](https://github.com/dotnet/corefx/commit/ab65f5e) Fixed netfx System.Linq.Tests fails (#28295)
* [`[e1730db]`](https://github.com/dotnet/corefx/commit/e1730db) Avoid allocating when SuppressFlow'ing in default ExecutionContext (#17081)
* [`[29d5555]`](https://github.com/dotnet/corefx/commit/29d5555) Fix Console.CancelKeyPress deadlock (#28286)
* [`[2977973]`](https://github.com/dotnet/corefx/commit/2977973) Update ProjectNTfs, ProjectNTfsTestILC to beta-26321-00, beta-26321-00, respectively (#28293)
* [`[0b8e4c6]`](https://github.com/dotnet/corefx/commit/0b8e4c6) API consistency for System.Memory APIs (argument names) (#28160)
* [`[a31762f]`](https://github.com/dotnet/corefx/commit/a31762f) WIP: Enable TimesIncludeMillisecondPart on selected filesystems only (#28242)
* [`[fcfb556]`](https://github.com/dotnet/corefx/commit/fcfb556) Use FileSystemName in FileSystemWatcher (#28220)
* [`[97ccece]`](https://github.com/dotnet/corefx/commit/97ccece) Fix UTF32Encoding BOM being emitted by XmlWriter when ByteOrderMark set to false (#28194)
* [`[67444c3]`](https://github.com/dotnet/corefx/commit/67444c3) User Data Source to construct SPN when Dns lookup fails (#28264)
* [`[d747c95]`](https://github.com/dotnet/corefx/commit/d747c95) Updating Buildtools so that we use Compiler server on non-Windows (#28272)
* [`[cefb0e8]`](https://github.com/dotnet/corefx/commit/cefb0e8) [Arm64] Stop running Ubuntu16.04 arm64 Debug Build on PR (#28276)
* [`[58662c6]`](https://github.com/dotnet/corefx/commit/58662c6) Port System.Memory performance improvements to Convert.TryFromBase64Chars (#17033)
* [`[2637c6e]`](https://github.com/dotnet/corefx/commit/2637c6e) Improve Integrated Auth Failure message with SQL Server (#28232)
* [`[ba0bd1b]`](https://github.com/dotnet/corefx/commit/ba0bd1b) Update DirectoryServices owners
* [`[704e28b]`](https://github.com/dotnet/corefx/commit/704e28b) Fix dictionary access in SqlUDTStorage (#28248)
* [`[a4956d9]`](https://github.com/dotnet/corefx/commit/a4956d9) fallback to IPv4 if AF is not specified and OS does not support IPv6 (#27558)
* [`[df471af]`](https://github.com/dotnet/corefx/commit/df471af) Fix wrong target type in UInt16Converter (#28253)
* [`[39adb1a]`](https://github.com/dotnet/corefx/commit/39adb1a) [Arm64] Fix CI tar path
* [`[7b137a3]`](https://github.com/dotnet/corefx/commit/7b137a3) Fix Globalization tests on Alpine (#28233)
* [`[264118f]`](https://github.com/dotnet/corefx/commit/264118f) Attempt to fix Ubuntu arm64 legs (#28245)
* [`[dc722e9]`](https://github.com/dotnet/corefx/commit/dc722e9) Move CompareInfo.* to shared CoreLib partition (dotnet/coreclr#17062)
* [`[8bc0c32]`](https://github.com/dotnet/corefx/commit/8bc0c32) Switch back to more performant and portable Marvin implementation
* [`[dce2a4d]`](https://github.com/dotnet/corefx/commit/dce2a4d) Use managed marvin hashing for IgnoreCase comparison (dotnet/coreclr#16945)
* [`[422dd24]`](https://github.com/dotnet/corefx/commit/422dd24) [Arm64/Linux] Enable CI & official builds (#27656)
* [`[9dc5aad]`](https://github.com/dotnet/corefx/commit/9dc5aad) Enable OdbcConnection.GetSchema  (#28175)
* [`[ca07fd9]`](https://github.com/dotnet/corefx/commit/ca07fd9) Fix sporadically failing PreAuthenticate test on WinHttpHandler (#28226)
* [`[9ae8e66]`](https://github.com/dotnet/corefx/commit/9ae8e66) Fix sporadic WinHttpHandler failures with cookie tests (#28213)
* [`[c769ad5]`](https://github.com/dotnet/corefx/commit/c769ad5) Share common props file for manual shims
* [`[c008bb5]`](https://github.com/dotnet/corefx/commit/c008bb5) Expose ClientWebSocketOptions.RemoteCertificateValidationCallback (#28141)
* [`[743d481]`](https://github.com/dotnet/corefx/commit/743d481) Fix area owners for System.Data (no SqlClient) (#28224)
* [`[acfbbee]`](https://github.com/dotnet/corefx/commit/acfbbee) Update symbol uploader to 1.0.0-beta-62715-04.
* [`[1ce89ad]`](https://github.com/dotnet/corefx/commit/1ce89ad) Fix major System.Memory performance regression on .NET Framework x86 (#28179)
* [`[7d4b78f]`](https://github.com/dotnet/corefx/commit/7d4b78f) Updates unsafe String constructors to be consistent when handling null value (#17002)
* [`[2b6109b]`](https://github.com/dotnet/corefx/commit/2b6109b) Prevent concurrent use corruption from causing infinite loops (#16991)
* [`[3e610c2]`](https://github.com/dotnet/corefx/commit/3e610c2) Restore EOF check in UDS test (#28196)
* [`[dc7de2e]`](https://github.com/dotnet/corefx/commit/dc7de2e) Bug fix: Force properties reload (#28167)
* [`[089a889]`](https://github.com/dotnet/corefx/commit/089a889) Re-enable SocketsHttpHandler proxy test (#28186)
* [`[251d65c]`](https://github.com/dotnet/corefx/commit/251d65c) Synchronize access to dictionary in MetadataReaderTests (#28185)
* [`[969541f]`](https://github.com/dotnet/corefx/commit/969541f) more love from BenchmarkDotNet to CoreFX (#27164)
* [`[1d9e08e]`](https://github.com/dotnet/corefx/commit/1d9e08e) update instructions for Ubuntu 18.
* [`[b5c1cee]`](https://github.com/dotnet/corefx/commit/b5c1cee) Improve inling in ImmutableArray\<T>.Builder (#28177)
* [`[dd4519d]`](https://github.com/dotnet/corefx/commit/dd4519d) RefApiCompat for isolatedStorage (#28120)
* [`[1020ce2]`](https://github.com/dotnet/corefx/commit/1020ce2) Fix EventSource Test Failures in CoreFX (dotnet/coreclr#16999)
* [`[be517f0]`](https://github.com/dotnet/corefx/commit/be517f0) Fixed netfx System.Diagnostics.TraceSource.Tests on non English Windows (#28154)
* [`[ccc6d32]`](https://github.com/dotnet/corefx/commit/ccc6d32) Fixed netfx System.ComponentModel.DataAnnotations.Tests.ValidatorTests.TryValidateObject_RequiredNull_Error on non English Windows (#28148)
* [`[f684142]`](https://github.com/dotnet/corefx/commit/f684142) Fixed System.DirectoryServices.Tests fails on non English Windows (#28166)
* [`[c4d9e0c]`](https://github.com/dotnet/corefx/commit/c4d9e0c) Use Win32Marshal from CoreLib shared code (#28161)
* [`[ba09b2d]`](https://github.com/dotnet/corefx/commit/ba09b2d) Put the path on IOException strings when possible (dotnet/coreclr#16998)
* [`[d30641c]`](https://github.com/dotnet/corefx/commit/d30641c) fixwarningmessage (#28101)
* [`[e6d8bfd]`](https://github.com/dotnet/corefx/commit/e6d8bfd) Fixing disabled ProcessExit_Called test masked by #27426 (#27793)
* [`[58f959f]`](https://github.com/dotnet/corefx/commit/58f959f) Fix Ctor_NullGraphics_ThrowsArgumentNullException for netfx (#28147)
* [`[54eb3bf]`](https://github.com/dotnet/corefx/commit/54eb3bf) Avoid recvmsg system call when 0-byte receive completes async (#28098)
* [`[5f5ff6d]`](https://github.com/dotnet/corefx/commit/5f5ff6d) Change csharp_indent_labels from flush_left to one_less_than_current (#28121)
* [`[a985f20]`](https://github.com/dotnet/corefx/commit/a985f20) Move master to preview3
* [`[814ac7b]`](https://github.com/dotnet/corefx/commit/814ac7b) [Arm64] Add Base HW Intrinsics
* [`[6afc1e8]`](https://github.com/dotnet/corefx/commit/6afc1e8) Fix GetTempPath (dotnet/coreclr#16921)
* [`[b737079]`](https://github.com/dotnet/corefx/commit/b737079) Add EventSource TraceLogging Support for EventPipe (dotnet/coreclr#16861)
* [`[4ea280e]`](https://github.com/dotnet/corefx/commit/4ea280e) Check for name surrogates when deleting reparse points (#28124)
* [`[e2c62e0]`](https://github.com/dotnet/corefx/commit/e2c62e0) LongFileTime.ToDateTimeOffset perf (#28129)
* [`[6d031a0]`](https://github.com/dotnet/corefx/commit/6d031a0) Check available credentials when choosing authentication scheme (#28105)
* [`[4e7b366]`](https://github.com/dotnet/corefx/commit/4e7b366) Fix WebException to handle SocketsHttpHandler generated errors (#28108)
* [`[25bfc4a]`](https://github.com/dotnet/corefx/commit/25bfc4a) Move corefx test util project under src directory
* [`[6cc11f5]`](https://github.com/dotnet/corefx/commit/6cc11f5) Use vectorized T=byte implementations to optimize all MemoryExtensions APIs for T != byte (#28080)
* [`[6cbe8a6]`](https://github.com/dotnet/corefx/commit/6cbe8a6) Avoid allocator allocations in StorePal.LinkFromCertificateCollection
* [`[d35bab8]`](https://github.com/dotnet/corefx/commit/d35bab8) Avoid mutating SslClientAuthenticationOptions in SslState
* [`[2a1d941]`](https://github.com/dotnet/corefx/commit/2a1d941) Avoid boxing allocation from PtrToStructure in UnmanagedCertificateContext
* [`[36cf2bb]`](https://github.com/dotnet/corefx/commit/36cf2bb) Make StreamSizes a struct rather than class
* [`[6aea829]`](https://github.com/dotnet/corefx/commit/6aea829) Avoid exceptions when a connection in the pool is Disposed
* [`[a196adb]`](https://github.com/dotnet/corefx/commit/a196adb) Dial SocketsHttpHandler scavenge time based on idle timeout
* [`[db2f033]`](https://github.com/dotnet/corefx/commit/db2f033) Avoid allocating ExceptionDispatchInfo and ObjectDisposedException when disposing SslStream
* [`[98227f1]`](https://github.com/dotnet/corefx/commit/98227f1) Avoid StringBuffer allocation in Interop.Kernel32.GetMessage
* [`[6204b9f]`](https://github.com/dotnet/corefx/commit/6204b9f) Avoid allocating auth scheme substring in AuthenticationHeaderValue
* [`[23165ce]`](https://github.com/dotnet/corefx/commit/23165ce) Skip large arrays test on full framework (#28126)
* [`[e45295b]`](https://github.com/dotnet/corefx/commit/e45295b) Add GetHashCode test for invariant mode (#28037)
* [`[4cdbe10]`](https://github.com/dotnet/corefx/commit/4cdbe10) ArgumentList added to Process.StartInfo (#27191)
* [`[d2a8404]`](https://github.com/dotnet/corefx/commit/d2a8404) Move task to beginning and end of definition
* [`[e9fb978]`](https://github.com/dotnet/corefx/commit/e9fb978) enable test (#28106)
* [`[27739b6]`](https://github.com/dotnet/corefx/commit/27739b6) Add TaskCanceledException ctor that takes CancellationToken (#16939)
* [`[f932251]`](https://github.com/dotnet/corefx/commit/f932251) Enable task extensions
* [`[050bc33]`](https://github.com/dotnet/corefx/commit/050bc33) Windows interop fixes for System.Runtime.Extensions (#28089)
* [`[b506a14]`](https://github.com/dotnet/corefx/commit/b506a14) Add tilde path tests (#27998)
* [`[a89e7ad]`](https://github.com/dotnet/corefx/commit/a89e7ad) Fixing NonBreakingSpace test on OSX using FSAssert (#28094)
* [`[86f5fb2]`](https://github.com/dotnet/corefx/commit/86f5fb2) Add SqlCredential dependent APIs (#27645)
* [`[e75c019]`](https://github.com/dotnet/corefx/commit/e75c019) Add SuppressMetaPackage to break circular dependency during package restore (#28042)
* [`[fbb328b]`](https://github.com/dotnet/corefx/commit/fbb328b) replace issue number (#28036)
* [`[e3036d2]`](https://github.com/dotnet/corefx/commit/e3036d2) Porting ServiceController SecurityPermissions (#28039)
* [`[79021b6]`](https://github.com/dotnet/corefx/commit/79021b6) Normalize the too-big-to-decrypt message across RSA implementations
* [`[e2ed932]`](https://github.com/dotnet/corefx/commit/e2ed932) Fix SocketsHttpHandler.PreAuthenticate behavior (#28047)
* [`[9baa407]`](https://github.com/dotnet/corefx/commit/9baa407) Fix System.Drawing Reverse ApiCompat issues (#28023)
* [`[2bff491]`](https://github.com/dotnet/corefx/commit/2bff491) Port SequentialEqual() optimizations to ReadOnlySpan overloads (#28073)
* [`[2de3a3c]`](https://github.com/dotnet/corefx/commit/2de3a3c) Keep marshalled delegate alive while it is used (#28092)
* [`[d379aba]`](https://github.com/dotnet/corefx/commit/d379aba) Avoid allocating long[] in Uri's ParseNonCanonical (#28086)
* [`[9ed3c2d]`](https://github.com/dotnet/corefx/commit/9ed3c2d) Avoid lots of small allocations when parsing Uri with IP address (#28084)
* [`[92c204f]`](https://github.com/dotnet/corefx/commit/92c204f) Fixed common tests
* [`[20f097b]`](https://github.com/dotnet/corefx/commit/20f097b) DIfferent Directory Separator for linux (dotnet/coreclr#16936)
* [`[1df4a48]`](https://github.com/dotnet/corefx/commit/1df4a48) Porting ServiceProcessDescription attribute (#28029)
* [`[c7d3b57]`](https://github.com/dotnet/corefx/commit/c7d3b57) Use ReflectionBasedSerializer for all serializers if any of mappings are soap mappings (#27803)
* [`[1de2b37]`](https://github.com/dotnet/corefx/commit/1de2b37) SNIPacket memory allocation perf improvement (revised) (#27758)
* [`[b70128c]`](https://github.com/dotnet/corefx/commit/b70128c) Add experts to tag for tizen issues
* [`[535fd1e]`](https://github.com/dotnet/corefx/commit/535fd1e) Use Intermediate path for GenerateReferenceSource
* [`[2b850f6]`](https://github.com/dotnet/corefx/commit/2b850f6) Make SocketsHttpHandler default Handler (#27821)
* [`[696e088]`](https://github.com/dotnet/corefx/commit/696e088) System.Diagnostics.EventLog.Tests fails 2 tests in non-English Windows (#28028)
* [`[c65a220]`](https://github.com/dotnet/corefx/commit/c65a220) Fix incorrect bounds check in ArrayMemoryPoolBuffer.Pin (#28032)
* [`[52da166]`](https://github.com/dotnet/corefx/commit/52da166) Fix GetHashCode with invariant mode
* [`[8fd7c72]`](https://github.com/dotnet/corefx/commit/8fd7c72) Update the System.Memory package description and common types listed. (#28026)
* [`[65f736e]`](https://github.com/dotnet/corefx/commit/65f736e) Updated an error message (#28017)
* [`[8bca91b]`](https://github.com/dotnet/corefx/commit/8bca91b) Setting element bugfix (#27879)
* [`[6813af0]`](https://github.com/dotnet/corefx/commit/6813af0) Add Xamarin placeholders for System.Memory package
* [`[9cde05f]`](https://github.com/dotnet/corefx/commit/9cde05f) Expose SocketsHttpHandler.ResponseDrainTimeout (#28011)
* [`[6e3a414]`](https://github.com/dotnet/corefx/commit/6e3a414) Change behavior of SocketsHttpHandler for redirects (#28008)
* [`[6cd1708]`](https://github.com/dotnet/corefx/commit/6cd1708) Give WebSocket server time to close connection (#27993)
* [`[d4853e2]`](https://github.com/dotnet/corefx/commit/d4853e2) Use shared SocketsHttpHandler for some ClientWebSocket options (#27994)
* [`[69cbcb3]`](https://github.com/dotnet/corefx/commit/69cbcb3) Fix short path expansion (dotnet/coreclr#16901)
* [`[bf36018]`](https://github.com/dotnet/corefx/commit/bf36018) Fix unbounded stackalloc in System.IO.FileSystem (#28004)
* [`[ec612bc]`](https://github.com/dotnet/corefx/commit/ec612bc) Publish symbols using Microsoft.SymbolUploader.Build.Task package
* [`[c911d7a]`](https://github.com/dotnet/corefx/commit/c911d7a) Use a cached canceled task in ValueTask (#27967)
* [`[adf2984]`](https://github.com/dotnet/corefx/commit/adf2984) Fix shim APICompat checks to fail build
* [`[fd20bc3]`](https://github.com/dotnet/corefx/commit/fd20bc3) Add a test to validate sensitivity on OSX (#27959)
* [`[7b9be0b]`](https://github.com/dotnet/corefx/commit/7b9be0b) Optimize MemoryExtensions SequenceEqual for more T's (#27859)
* [`[431475b]`](https://github.com/dotnet/corefx/commit/431475b) Change CurlHandler to only request HTTP/2 over TLS (#27934)
* [`[036608d]`](https://github.com/dotnet/corefx/commit/036608d) fix NTLM auth and add some manually enabled tests (#27958)
* [`[f1f3b3f]`](https://github.com/dotnet/corefx/commit/f1f3b3f) Re-enable OSX in CI (#27956)
* [`[b4dfbad]`](https://github.com/dotnet/corefx/commit/b4dfbad) More FileSystem tests (#27955)
* [`[de1878e]`](https://github.com/dotnet/corefx/commit/de1878e) Add more alternate data stream tests (#27945)
* [`[f35784e]`](https://github.com/dotnet/corefx/commit/f35784e) Start adding alternate data stream tests (#27931)
* [`[1126fc2]`](https://github.com/dotnet/corefx/commit/1126fc2) Re-enable several task awaiting tests (#27940)
* [`[5da9268]`](https://github.com/dotnet/corefx/commit/5da9268) RemoteInvoke added to SetTempEnv  tests(#27921)
* [`[29eabe2]`](https://github.com/dotnet/corefx/commit/29eabe2) Revise init-tools.sh to support bootstrapping
* [`[c872363]`](https://github.com/dotnet/corefx/commit/c872363) Fix lldb-3.9-dev package name
* [`[0e70b43]`](https://github.com/dotnet/corefx/commit/0e70b43) Test changes for System.IO.FileSystem (#27923)
* [`[1b9cf74]`](https://github.com/dotnet/corefx/commit/1b9cf74) Add back method needed by CoreRT
* [`[4345903]`](https://github.com/dotnet/corefx/commit/4345903) Perf fix for month-day parsing ambiguity (dotnet/coreclr#16782)
* [`[6b55700]`](https://github.com/dotnet/corefx/commit/6b55700) Avoid delegate invocation in AwaitableSocketAsyncEventArgs (#27918)
* [`[21d3c04]`](https://github.com/dotnet/corefx/commit/21d3c04) Move MutableDecimal from System.Memory to Common (#27917)
* [`[737a0ef]`](https://github.com/dotnet/corefx/commit/737a0ef) Reduce ExecutionContext.Run calls with SocketAsyncEventArgs (#27916)
* [`[69953f6]`](https://github.com/dotnet/corefx/commit/69953f6) Updates for ILLink integration.
* [`[9e64647]`](https://github.com/dotnet/corefx/commit/9e64647) Update Crypto.Xml to match ref
* [`[f48d483]`](https://github.com/dotnet/corefx/commit/f48d483) Make DiagnosticsSource ref assembly consistent
* [`[ed06384]`](https://github.com/dotnet/corefx/commit/ed06384) Reference CodePages ref to match the implementation
* [`[8842923]`](https://github.com/dotnet/corefx/commit/8842923) Consolidate matching ref generated baseline files
* [`[ddb31b5]`](https://github.com/dotnet/corefx/commit/ddb31b5) Baseline all reverse apicompat issues
* [`[07db6cd]`](https://github.com/dotnet/corefx/commit/07db6cd) Use ValueStringBuilder instead of StringBuilderCache
* [`[db924ef]`](https://github.com/dotnet/corefx/commit/db924ef) Delete AsReadOnly* APIs that are no longer part of the public surface (#16799)
* [`[35ff77a]`](https://github.com/dotnet/corefx/commit/35ff77a) Update System.Memory package description to be complete (#27888)
* [`[d21fa56]`](https://github.com/dotnet/corefx/commit/d21fa56) Optimize string-like portable Span APIs for Ordinal and OrdinalIgnoreCase (#27905)
* [`[5cc8f36]`](https://github.com/dotnet/corefx/commit/5cc8f36) Conditionally execute IntegratedAuthenticationTest (#27857)
* [`[3760763]`](https://github.com/dotnet/corefx/commit/3760763) Skip TvpTest.TestMain due to issue 27858 (#27860)
* [`[2670c39]`](https://github.com/dotnet/corefx/commit/2670c39) Use ArrayPool for temporary buffers in S.S.C.Primitives (#27843)
* [`[f7b7c50]`](https://github.com/dotnet/corefx/commit/f7b7c50) Ensure SendAsync token source is disposed when handler throws (#27894)
* [`[b6419f5]`](https://github.com/dotnet/corefx/commit/b6419f5) Allow Socket.GetOrAllocateThreadPoolBoundHandle to fully inline (#27895)
* [`[850c1d7]`](https://github.com/dotnet/corefx/commit/850c1d7) Eat exceptions from SocketsHttpHandler's readahead task (#27898)
* [`[649ddbc]`](https://github.com/dotnet/corefx/commit/649ddbc) Dispose of the SocketsHttpHandler used in WebSocketHandle.Managed (#27900)
* [`[70e85dc]`](https://github.com/dotnet/corefx/commit/70e85dc) Use empty string instead of null for default value (#27902)
* [`[82c6f63]`](https://github.com/dotnet/corefx/commit/82c6f63) Issue #24343 Vector Ctor using Span
* [`[e1f3048]`](https://github.com/dotnet/corefx/commit/e1f3048) Activity for HttpClient calls not stopped if inner handler does not use async/await (PR 2) (#27775)
* [`[1077635]`](https://github.com/dotnet/corefx/commit/1077635) Add back reference to corelib files so they are visible in Visual Studio. (#27883)
* [`[6b84cc4]`](https://github.com/dotnet/corefx/commit/6b84cc4) fix logic to check for Proxy-support header
* [`[35e8862]`](https://github.com/dotnet/corefx/commit/35e8862) Fix Compile error
* [`[524561f]`](https://github.com/dotnet/corefx/commit/524561f) Fix race condition on Unix pooling canceled Socket operations (#27866)
* [`[59c2fab]`](https://github.com/dotnet/corefx/commit/59c2fab) fix SocketsHttpHandler to ignore invalid Set-Cookie (#27865)
* [`[bce4515]`](https://github.com/dotnet/corefx/commit/bce4515) Service Base Tests Corrected (#27630)
* [`[671b10b]`](https://github.com/dotnet/corefx/commit/671b10b) Update UAP System.Private.CoreLib to unblock UAP builds (#27805)
* [`[2a16087]`](https://github.com/dotnet/corefx/commit/2a16087) Fix inlining of IAsyncStateMachineBox (dotnet/coreclr#16830)
* [`[9edb125]`](https://github.com/dotnet/corefx/commit/9edb125) Make member visibility first accross corlib (dotnet/coreclr#16836)
* [`[8ad2b10]`](https://github.com/dotnet/corefx/commit/8ad2b10) Collapse AsSpan().Slice(...) into .AsSpan(...) (#27867)
* [`[3fc3900]`](https://github.com/dotnet/corefx/commit/3fc3900) Add API that allows the emitter to indicate presence of localloc (#27589)
* [`[7be44d2]`](https://github.com/dotnet/corefx/commit/7be44d2) Updating the package index for UAP and updating buildtools (#27787)
* [`[b437972]`](https://github.com/dotnet/corefx/commit/b437972) Avoid timing issue in IOControl_SIOCATMARK tests (#27838)
* [`[60b3376]`](https://github.com/dotnet/corefx/commit/60b3376) Do not rely on $HOME since it can be too long, use /tmp (#27853)
* [`[8ce7e62]`](https://github.com/dotnet/corefx/commit/8ce7e62) Update SLNs and projects to be in sync with configurations
* [`[ce285a7]`](https://github.com/dotnet/corefx/commit/ce285a7) Move String to shared corelib partition (dotnet/coreclr#16749)
* [`[361e7fe]`](https://github.com/dotnet/corefx/commit/361e7fe) Fix inconsistent AVX/AVX intrinsic names
* [`[14198aa]`](https://github.com/dotnet/corefx/commit/14198aa) Delete duplicate socket perf test (#27851)
* [`[0f49234]`](https://github.com/dotnet/corefx/commit/0f49234) Add new resource string
* [`[94f82da]`](https://github.com/dotnet/corefx/commit/94f82da) CoreFX #24343 Vector Ctor using Span (dotnet/coreclr#16733)
* [`[da62b6a]`](https://github.com/dotnet/corefx/commit/da62b6a) Keep memory a MetadataReader created from provider/PEReader accesses alive until the provider/PEReader is released (#27759)
* [`[b03464e]`](https://github.com/dotnet/corefx/commit/b03464e) Named pipe in Unix respects absolute path (#27826)
* [`[122cad4]`](https://github.com/dotnet/corefx/commit/122cad4) Add missing IInternalConfigHost method (#27832)
* [`[7480f25]`](https://github.com/dotnet/corefx/commit/7480f25) Don't look at base classes for interfaces in Microsoft.CSharp (#27533)
* [`[303f204]`](https://github.com/dotnet/corefx/commit/303f204) Close file in XmlSchemaSet tests in attempt to fix intermittent test failure (#27825)
* [`[59f6987]`](https://github.com/dotnet/corefx/commit/59f6987) WhiteSpace and PrefixParent subdirectory names throw exception (#27810)
* [`[61aaf07]`](https://github.com/dotnet/corefx/commit/61aaf07) Test for enumerateDirectories NonBreaking space (#27762)
* [`[a51680e]`](https://github.com/dotnet/corefx/commit/a51680e) Renable some TLS callback tests with SocketsHttpHandler (#27828)
* [`[11b49e4]`](https://github.com/dotnet/corefx/commit/11b49e4) Fix the unhandled exception and test validation in manual tests (#27781)
* [`[cc4abca]`](https://github.com/dotnet/corefx/commit/cc4abca) Dial back `\\?\` insertion (#27827)
* [`[98a173b]`](https://github.com/dotnet/corefx/commit/98a173b) Update socket perf tests to use new overloads (#27830)
* [`[2be66d4]`](https://github.com/dotnet/corefx/commit/2be66d4) Make UnboundedChannel.ReadAsync check for cancellation first (#27822)
* [`[41a2120]`](https://github.com/dotnet/corefx/commit/41a2120) Support trimmed paths in FileInfo (#27809)
* [`[2660a46]`](https://github.com/dotnet/corefx/commit/2660a46) Disable hanging Proxy_UseSecureProxyTunnel_Success test on netfx (#27815)
* [`[f31d24f]`](https://github.com/dotnet/corefx/commit/f31d24f) Disable assembly locking tests on Unix
* [`[bb0f07e]`](https://github.com/dotnet/corefx/commit/bb0f07e) Delete TODO from ByteArrayHelpers (#27806)
* [`[1e5d3a3]`](https://github.com/dotnet/corefx/commit/1e5d3a3) Fixed misnamed token
* [`[850e2f3]`](https://github.com/dotnet/corefx/commit/850e2f3) Use generic WeakReference and avoid casting in Regex (#27791)
* [`[c263482]`](https://github.com/dotnet/corefx/commit/c263482) Fix race condition in SystemEvents (#27790)
* [`[e9d0a64]`](https://github.com/dotnet/corefx/commit/e9d0a64) Fix NullReferenceException when using client certs with ClientWebSocket (#27777)
* [`[68cfdde]`](https://github.com/dotnet/corefx/commit/68cfdde) Add async overloads to SslOverTdsStream (#27743)
* [`[fb3b7da]`](https://github.com/dotnet/corefx/commit/fb3b7da) Fix synchronization in Channel's AsyncOperation (#27780)
* [`[c37e3e5]`](https://github.com/dotnet/corefx/commit/c37e3e5) Fix System.Threading.Tasks.Extensions packaging for 2.1 (#27760)
* [`[f7bec37]`](https://github.com/dotnet/corefx/commit/f7bec37) Fix/Update System.Diagnostics.Tests.ProcessTests/ProcessStart_UseShellExecuteTrue_OpenMissingFile_Throw (#27557)
* [`[2696973]`](https://github.com/dotnet/corefx/commit/2696973) Add option to bin place just netcoreapp package refs
* [`[d0cb451]`](https://github.com/dotnet/corefx/commit/d0cb451) Fix SocketsNetHttpHandler TLS client cert handling (#27753)
* [`[e276abe]`](https://github.com/dotnet/corefx/commit/e276abe) Disable TimerElapsedSignaled test (#27772)
* [`[ec511de]`](https://github.com/dotnet/corefx/commit/ec511de) Fixing System.Diagnostics.Tests.ProcessTests failures on Unix (#27670)
* [`[4ca662c]`](https://github.com/dotnet/corefx/commit/4ca662c) Add response drain max time to SocketsHttpHandler (#27708)
* [`[9ce9033]`](https://github.com/dotnet/corefx/commit/9ce9033) Fix semantics of ArrayMemoryPool (#27615)
* [`[ca69645]`](https://github.com/dotnet/corefx/commit/ca69645) Fix potential buffer overrun in ClearWithReferences
* [`[40eea04]`](https://github.com/dotnet/corefx/commit/40eea04) Fix whitespace
* [`[b729933]`](https://github.com/dotnet/corefx/commit/b729933) Use InnerIterationCount for perf tests
* [`[6a876d0]`](https://github.com/dotnet/corefx/commit/6a876d0) Fix whitespace
* [`[4e3a6d0]`](https://github.com/dotnet/corefx/commit/4e3a6d0) Improve performance of Span.Clear for referential T
* [`[074a911]`](https://github.com/dotnet/corefx/commit/074a911) [Arm64] Add crypto intrinsics
* [`[4d03a1e]`](https://github.com/dotnet/corefx/commit/4d03a1e) Add option to bin place just netcoreapp package refs
* [`[c2db574]`](https://github.com/dotnet/corefx/commit/c2db574) fix some conditional test logic to ensure we're not disabling SocketsHttpHandler tests
* [`[dc355e9]`](https://github.com/dotnet/corefx/commit/dc355e9) Add folded response header support to SocketsHttpHandler (#27727)
* [`[f5e9b75]`](https://github.com/dotnet/corefx/commit/f5e9b75) Fix order of native overlapped freeing in SocketAsyncEventArgs on Windows (#27728)
* [`[5dafdf9]`](https://github.com/dotnet/corefx/commit/5dafdf9) Fix `ManagementDateTimeConverter.ToDateTime` bug of using `TimeZone` class (#27683)
* [`[9dd3d2a]`](https://github.com/dotnet/corefx/commit/9dd3d2a) Disable OSX from innerloop temporarily (#27736)
* [`[5c49c76]`](https://github.com/dotnet/corefx/commit/5c49c76) change caching of Host header value to include port when necessary
* [`[f9dfb61]`](https://github.com/dotnet/corefx/commit/f9dfb61) Fix Utf8ParserFormatter test culture settings dependency (#27729)
* [`[4b7c4f9]`](https://github.com/dotnet/corefx/commit/4b7c4f9) Scrub error messages for missing arguments(throw new) (#16753)
* [`[01e315c]`](https://github.com/dotnet/corefx/commit/01e315c) Add ESRPSigning as conditional for queue time.
* [`[43d0701]`](https://github.com/dotnet/corefx/commit/43d0701) Fix encoding methods for Span.Empty (dotnet/coreclr#16748)
* [`[bf3b8e7]`](https://github.com/dotnet/corefx/commit/bf3b8e7) Added argument name to the exception (#27699)
* [`[01ee1e9]`](https://github.com/dotnet/corefx/commit/01ee1e9) Improve SqlDataRecord test coverage (#27424)
* [`[2ee63c6]`](https://github.com/dotnet/corefx/commit/2ee63c6) System.IO.FileSystem.AccessControl.Tests fails some tests on non english windows (#27628)
* [`[52b6280]`](https://github.com/dotnet/corefx/commit/52b6280) Improve performance of SystemNative_GetNonCryptographicallySecureRandomBytes (#27601)
* [`[eec1af0]`](https://github.com/dotnet/corefx/commit/eec1af0) Delete stale TryFormat and {Try}Parse overloads (dotnet/coreclr#16746)
* [`[7d24a28]`](https://github.com/dotnet/corefx/commit/7d24a28) Fix Adar month name in Hebrew calendar (dotnet/coreclr#16697)
* [`[ff94587]`](https://github.com/dotnet/corefx/commit/ff94587) Add back argument check for TypeForwardedFromAttribute (#16680)
* [`[e24cb55]`](https://github.com/dotnet/corefx/commit/e24cb55) Mark MemoryMarshal.Cast methods for aggressive inlining (#16654)
* [`[59268ec]`](https://github.com/dotnet/corefx/commit/59268ec) Add Thread.GetCurrentProcessorId() API (dotnet/coreclr#16650)
* [`[d08838a]`](https://github.com/dotnet/corefx/commit/d08838a) More ValueTask goodness for System.IO.Pipelines (#27701)
* [`[9b4e9dc]`](https://github.com/dotnet/corefx/commit/9b4e9dc) Add an ETW test to ensure that Write\<T> calls with embedded NULLs don't break decoding of the rest of the file. (#27635)
* [`[9591b84]`](https://github.com/dotnet/corefx/commit/9591b84) System.Net.Security.Tests fails 3 tests in non-English Windows (#27650)
* [`[3d23b14]`](https://github.com/dotnet/corefx/commit/3d23b14) System.Xml.RW.XmlWriterApi.Tests fails 196 tests on non english locale (#27687)
* [`[228bfe6]`](https://github.com/dotnet/corefx/commit/228bfe6) Clear executable bit on several .cs files
* [`[5276f30]`](https://github.com/dotnet/corefx/commit/5276f30) Small changes to pipelines (#27704)
* [`[058bd91]`](https://github.com/dotnet/corefx/commit/058bd91) Update TraceLogging to use NULL-terminated strings instead of counted strings (#16672)
* [`[e799d23]`](https://github.com/dotnet/corefx/commit/e799d23) Fix MemoryDebugView and override Memory.ToString similar to Span (#16732)
* [`[ac65c0f]`](https://github.com/dotnet/corefx/commit/ac65c0f) Use the default supported nuget versions. (#27622)
* [`[8958ef9]`](https://github.com/dotnet/corefx/commit/8958ef9) ValueTask adoption in System.IO.Pipelines (#27651)
* [`[8e842fa]`](https://github.com/dotnet/corefx/commit/8e842fa) Adding "Running a single test on the command line"
* [`[8710caa]`](https://github.com/dotnet/corefx/commit/8710caa) Fix ReadOnlySequence First (#27691)
* [`[d907a94]`](https://github.com/dotnet/corefx/commit/d907a94) Add DateTime ParseExact test with `Allow White` styles (#27678)
* [`[6c5a243]`](https://github.com/dotnet/corefx/commit/6c5a243) Support added for  2.0 and 2.1 blobs (#27399)
* [`[924dce0]`](https://github.com/dotnet/corefx/commit/924dce0) Implement the new SyndicationFeed object model api's
* [`[ae1fa01]`](https://github.com/dotnet/corefx/commit/ae1fa01) Changed Collection Properties.
* [`[9d5cdf2]`](https://github.com/dotnet/corefx/commit/9d5cdf2) Add setter for collection property.
* [`[a8388b1]`](https://github.com/dotnet/corefx/commit/a8388b1) Renamed tests.
* [`[a08ab45]`](https://github.com/dotnet/corefx/commit/a08ab45) Added support for more optional elements.
* [`[dca3394]`](https://github.com/dotnet/corefx/commit/dca3394) Minor fixes.
* [`[b288a36]`](https://github.com/dotnet/corefx/commit/b288a36) Syndication Support Documentation Element.
* [`[281ef75]`](https://github.com/dotnet/corefx/commit/281ef75) Work around MCG bug around `ref char` marshalling (dotnet/corert#5481)
* [`[15f0dbe]`](https://github.com/dotnet/corefx/commit/15f0dbe) Fixing GetFullPath (dotnet/coreclr#16670)
* [`[0463e34]`](https://github.com/dotnet/corefx/commit/0463e34) Vectorize String.IndexOf(char) and String.LastIndexOf(char) (#16392)
* [`[76b6432]`](https://github.com/dotnet/corefx/commit/76b6432) Changes from api review
* [`[1875757]`](https://github.com/dotnet/corefx/commit/1875757) Modify Syndicaiton Custom Parser APIs.
* [`[59fa3c8]`](https://github.com/dotnet/corefx/commit/59fa3c8) Fix break in ProcessTestBase.Uap.cs (#27671)
* [`[f1ba98d]`](https://github.com/dotnet/corefx/commit/f1ba98d) Delete unnecesary workarounds (#27663)
* [`[421ce7b]`](https://github.com/dotnet/corefx/commit/421ce7b) Support UnixDomainSocketEndPoint on Windows (#27631)
* [`[f5f9bda]`](https://github.com/dotnet/corefx/commit/f5f9bda) Fix netstandard build references to UnsafeTask
* [`[e12a5ec]`](https://github.com/dotnet/corefx/commit/e12a5ec) 1-base Dictionary buckets to reduce initalization
* [`[926183e]`](https://github.com/dotnet/corefx/commit/926183e) Use EqualityComparer\<TKey>.Default Intrinsic
* [`[5cad7a5]`](https://github.com/dotnet/corefx/commit/5cad7a5) Improve Dictionary TryInsert CQ
* [`[c340cd3]`](https://github.com/dotnet/corefx/commit/c340cd3) Improve Dictionary FindEntry CQ
* [`[02b5689]`](https://github.com/dotnet/corefx/commit/02b5689) Change several ValueTask properties to methods (dotnet/coreclr#16691)
* [`[c645f7c]`](https://github.com/dotnet/corefx/commit/c645f7c) Fix NamedPipe tests failing in Windows 7 and Nano (#27661)
* [`[4ecc7f7]`](https://github.com/dotnet/corefx/commit/4ecc7f7) [Arm64] Add initial Simd HW intrinsics
* [`[07fbff4]`](https://github.com/dotnet/corefx/commit/07fbff4) Use SIGCHLD to trigger Process waitpid check (#26291)
* [`[3fca26c]`](https://github.com/dotnet/corefx/commit/3fca26c) Disable UAP tests in CI
* [`[ebe1468]`](https://github.com/dotnet/corefx/commit/ebe1468) Disable uapaot builds on several projects
* [`[6d1671b]`](https://github.com/dotnet/corefx/commit/6d1671b) Expose and roll out ValueTask extensibility
* [`[a32de71]`](https://github.com/dotnet/corefx/commit/a32de71) Fix System.IO.Pipelines reference assembly (#27644)
* [`[f971d9b]`](https://github.com/dotnet/corefx/commit/f971d9b) Correct ToBoolean_String_ReturnsExpected test data for non english culture. (#27624)
* [`[9ff60da]`](https://github.com/dotnet/corefx/commit/9ff60da) Add GetPosition overload to ReadOnlySequence (#27633)
* [`[c9cdfba]`](https://github.com/dotnet/corefx/commit/c9cdfba) Re-enable UAP builds (#27531)
* [`[19c9c9f]`](https://github.com/dotnet/corefx/commit/19c9c9f) Don't test KillTimer with invalid timers
* [`[12715c4]`](https://github.com/dotnet/corefx/commit/12715c4) Fix Japanese Era calendar tests (#27617)
* [`[4fcf6cf]`](https://github.com/dotnet/corefx/commit/4fcf6cf) Add support for queuing a stable package build
* [`[7e5f966]`](https://github.com/dotnet/corefx/commit/7e5f966) System.Runtime.Intrinsics for .NET Core 2.1
* [`[e69e026]`](https://github.com/dotnet/corefx/commit/e69e026) Adding support for ncurses 6.1 TERM format on System.Console (#27109)
* [`[3a36159]`](https://github.com/dotnet/corefx/commit/3a36159) disable proxy test for WinHttpHandler on Win7
* [`[97a5264]`](https://github.com/dotnet/corefx/commit/97a5264) Default to global thread pool queuing (#27600)
* [`[18ea494]`](https://github.com/dotnet/corefx/commit/18ea494) Fix OOM in regex for large regex quantifier (#26543)
* [`[3e5f1c2]`](https://github.com/dotnet/corefx/commit/3e5f1c2) Improve MemoryMarshal.Cast (dotnet/coreclr#16659)
* [`[a2cb15c]`](https://github.com/dotnet/corefx/commit/a2cb15c) Add the array/arraysegment->Span/Memory overloads to MemoryExtensions (#27584)
* [`[8034664]`](https://github.com/dotnet/corefx/commit/8034664) Adjust System.Threading.Tasks.Extensions for IValueTaskSource
* [`[7520e80]`](https://github.com/dotnet/corefx/commit/7520e80) RegexPrefix struct, RegexFCD buffer to ValueListBuilder & ArrayPool (#27314)
* [`[183606a]`](https://github.com/dotnet/corefx/commit/183606a) IOControl_SIOCATMARK_Success test improvements (#27583)
* [`[7b55ce9]`](https://github.com/dotnet/corefx/commit/7b55ce9) Edits to fix conflicts in generated Vector.cs file (dotnet/coreclr#16666)
* [`[f5aa41c]`](https://github.com/dotnet/corefx/commit/f5aa41c) Fix calling convention gap in ILGenerator.EmitCalli (#27429)
* [`[e57157a]`](https://github.com/dotnet/corefx/commit/e57157a) Expose Thread.GetCurrentProcessorId() (#27541)
* [`[09b4ad8]`](https://github.com/dotnet/corefx/commit/09b4ad8) Stop FileSystem WriteAsync test from writing too much data to disk (#27387)
* [`[0c4fe29]`](https://github.com/dotnet/corefx/commit/0c4fe29) Logging for TimesIncludeMillisecondPart test and reenable for Linux (#27559)
* [`[e6b1cb2]`](https://github.com/dotnet/corefx/commit/e6b1cb2) Recognize 'I' for idle in /proc/pid/stat (#27579)
* [`[af04c55]`](https://github.com/dotnet/corefx/commit/af04c55) Add the array/arraysegment->Span/Memory overloads to CoreCLR. (#16658)
* [`[c1b12f2]`](https://github.com/dotnet/corefx/commit/c1b12f2) LargeArrayBuilder\<T> optimization of Add and AddRange (#26496)
* [`[39418b1]`](https://github.com/dotnet/corefx/commit/39418b1) ReadOnlySequence Performance Improvements (#27499)
* [`[fbe2ff1]`](https://github.com/dotnet/corefx/commit/fbe2ff1) Scrub error messages for missing arguments(throw new) (#27553)
* [`[7020ee1]`](https://github.com/dotnet/corefx/commit/7020ee1) Skip CommandCancelTests [MultiThreadedCancel_NonAsync & MultiThreadedCancel_Async] on Unix (#27576)
* [`[7c5d4bd]`](https://github.com/dotnet/corefx/commit/7c5d4bd) Add Path.Join() methods. (dotnet/coreclr#16561)
* [`[4d06437]`](https://github.com/dotnet/corefx/commit/4d06437) Bug in GetFullPath(basePath, Path) (dotnet/coreclr#16598)
* [`[5798761]`](https://github.com/dotnet/corefx/commit/5798761) Fix GetPathRoot issues (#27572)
* [`[9ca2480]`](https://github.com/dotnet/corefx/commit/9ca2480) Update broken link in remote test execution docs
* [`[d27d0d9]`](https://github.com/dotnet/corefx/commit/d27d0d9) Fix failing outerloop tests in System.Runtime.Extensions (#27415)
* [`[abfadff]`](https://github.com/dotnet/corefx/commit/abfadff) fix NetEventSource.Security.cs build issue
* [`[594a7f2]`](https://github.com/dotnet/corefx/commit/594a7f2) Update WebSocket status when the underlying connection is closed (#27556)
* [`[271326f]`](https://github.com/dotnet/corefx/commit/271326f) fix netfx test build
* [`[0a092a2]`](https://github.com/dotnet/corefx/commit/0a092a2) Expose Path.Join and tests (#27522)
* [`[e2f96c8]`](https://github.com/dotnet/corefx/commit/e2f96c8) update arguments passed to NTAuthentication constructor
* [`[0288644]`](https://github.com/dotnet/corefx/commit/0288644) fix trace conflict issue
* [`[98ef3cf]`](https://github.com/dotnet/corefx/commit/98ef3cf) fix linux build
* [`[d2a2221]`](https://github.com/dotnet/corefx/commit/d2a2221) Fix a bug in TranslateWin32Expression (#27539)
* [`[8858752]`](https://github.com/dotnet/corefx/commit/8858752) Set "esrpSigning": "true" on all Windows signing definitions.
* [`[8fec161]`](https://github.com/dotnet/corefx/commit/8fec161) Make Decrypt_512_NoData_FixedValue pass on netfx
* [`[303922a]`](https://github.com/dotnet/corefx/commit/303922a) Disable failing System.IO tests
* [`[3980e74]`](https://github.com/dotnet/corefx/commit/3980e74) Change new ThreadPool.QueueUserWorkItem overload to be generic
* [`[5d209e6]`](https://github.com/dotnet/corefx/commit/5d209e6) add ntlm auth and proxy auth for tunnel, and rework auth handling generally
* [`[a3c2df2]`](https://github.com/dotnet/corefx/commit/a3c2df2) Fix issue 26965 transaction scope crash (#27523)
* [`[fdabc62]`](https://github.com/dotnet/corefx/commit/fdabc62) Add ROSpan Equals/CompareTo/IndexOf/Contains string-like APIs with StringComparison (#27319)
* [`[28e3939]`](https://github.com/dotnet/corefx/commit/28e3939) Volatile and readonly in Reference helper classes in Regex
* [`[febb0de]`](https://github.com/dotnet/corefx/commit/febb0de) Use Span in Capture and avoid intermidiate string allocation
* [`[da830d1]`](https://github.com/dotnet/corefx/commit/da830d1) Limit access modifers throughout the Regex codebase
* [`[e3228df]`](https://github.com/dotnet/corefx/commit/e3228df) Avoid discard in Group
* [`[d530905]`](https://github.com/dotnet/corefx/commit/d530905) Inline EqualityComparer and avoid local in CaptureCollection
* [`[e3d6fea]`](https://github.com/dotnet/corefx/commit/e3d6fea) Move Regex Shared/Exclusive Reference to own file
* [`[f117967]`](https://github.com/dotnet/corefx/commit/f117967) Split Regex code into subfiles
* [`[35f6aea]`](https://github.com/dotnet/corefx/commit/35f6aea) Rename Regex files to match class name & sort Includes in csproj
* [`[a0f35ad]`](https://github.com/dotnet/corefx/commit/a0f35ad) Move Regex helper files to System.Collections dir
* [`[c0cf481]`](https://github.com/dotnet/corefx/commit/c0cf481) disable Expect: 100-continue test on WinHttpHandler (#27538)
* [`[900f9aa]`](https://github.com/dotnet/corefx/commit/900f9aa) Expose SocketsHttpHandler.MaxResponseDrainSize
* [`[cbc68e0]`](https://github.com/dotnet/corefx/commit/cbc68e0) Added NaN and -NaN comparison.
* [`[73ea816]`](https://github.com/dotnet/corefx/commit/73ea816) Event pipe guid in metadata (#16316), fixes #16105
* [`[865f086]`](https://github.com/dotnet/corefx/commit/865f086) Add ROSpan ToLower and ToUpper string-like APIs with CultureInfo (#27193)
* [`[59aeab3]`](https://github.com/dotnet/corefx/commit/59aeab3) Enable RSA-OAEP(SHA-2) and RSA-PSS on Unix systems
* [`[05e3ec4]`](https://github.com/dotnet/corefx/commit/05e3ec4) disable drain test variation for CurlHandler
* [`[4fa2f51]`](https://github.com/dotnet/corefx/commit/4fa2f51) Don't assert on Nano in case SystemEvent window cannot be created.
* [`[4a49208]`](https://github.com/dotnet/corefx/commit/4a49208) Skip SystemEvents tests on Nano
* [`[54a55fd]`](https://github.com/dotnet/corefx/commit/54a55fd) ReadOnlySequence efficiency+inlines+string (#27455)
* [`[ab6b810]`](https://github.com/dotnet/corefx/commit/ab6b810) Use user-scope chains when doing Find with validOnly=true
* [`[992a960]`](https://github.com/dotnet/corefx/commit/992a960) Add MemoryExtensions to CoreLib along with necessary SpanHelpers (#16521)
* [`[ecf00da]`](https://github.com/dotnet/corefx/commit/ecf00da) Fix race condition in SystemEvents tests
* [`[fc1a878]`](https://github.com/dotnet/corefx/commit/fc1a878) Fix double free in SystemEvents tests
* [`[9b784b0]`](https://github.com/dotnet/corefx/commit/9b784b0) Update ILLink to version 0.1.4-preview-1421602
* [`[caabd20]`](https://github.com/dotnet/corefx/commit/caabd20) Make the new tests take netfx differences into account
* [`[cc7242e]`](https://github.com/dotnet/corefx/commit/cc7242e) Disable servicebase tests (#27501)
* [`[eb80d13]`](https://github.com/dotnet/corefx/commit/eb80d13) Add MaxResponseDrainSize, and fix a few draining bugs (#27476)
* [`[bfc490d]`](https://github.com/dotnet/corefx/commit/bfc490d) Fix ascii range check (dotnet/coreclr#16535)
* [`[4603d5c]`](https://github.com/dotnet/corefx/commit/4603d5c) Modify algorithm not supported tests to expect CryptographicException
* [`[faab40d]`](https://github.com/dotnet/corefx/commit/faab40d) Port tests from dev/cms_unix to master
* [`[5c7137c]`](https://github.com/dotnet/corefx/commit/5c7137c) NamedPipe: CurrentUserOnly, quick fixes for Unix (#27463)
* [`[edbe783]`](https://github.com/dotnet/corefx/commit/edbe783) Catch the FileNotFoundException when to get the obsolete attribute for type. (#27389)
* [`[19c4800]`](https://github.com/dotnet/corefx/commit/19c4800) Add SystemEvents to Microsoft.Windows.Compatibility
* [`[e6bbe92]`](https://github.com/dotnet/corefx/commit/e6bbe92) Make SystemEvents target netcoreapp instead of netstandard
* [`[9b90e45]`](https://github.com/dotnet/corefx/commit/9b90e45) Make SystemColorTracker static
* [`[24f53c7]`](https://github.com/dotnet/corefx/commit/24f53c7) Make SystemEvents tests more patient
* [`[ef53631]`](https://github.com/dotnet/corefx/commit/ef53631) Adjust PInvokes to match style guidelines
* [`[c56fdf1]`](https://github.com/dotnet/corefx/commit/c56fdf1) Fix SystemEvents tracking in System.Drawing.Common
* [`[a02e2f2]`](https://github.com/dotnet/corefx/commit/a02e2f2) Add SystemEvents package
* [`[01b383e]`](https://github.com/dotnet/corefx/commit/01b383e) Port SystemEvents (Windows)
* [`[3148e0e]`](https://github.com/dotnet/corefx/commit/3148e0e) Add projects for SystemEvents
* [`[c31f276]`](https://github.com/dotnet/corefx/commit/c31f276) Format source code
* [`[3bab2ce]`](https://github.com/dotnet/corefx/commit/3bab2ce) Adding initial SystemEvents code from desktop
* [`[d9e55a9]`](https://github.com/dotnet/corefx/commit/d9e55a9) Windows PDB Checksum spec (#27421)
* [`[bbfc885]`](https://github.com/dotnet/corefx/commit/bbfc885) Update Performance Test Execution Instructions (#27475)
* [`[1faf626]`](https://github.com/dotnet/corefx/commit/1faf626) Fixed NaN's GetHashCode and Equals invariant issue. (dotnet/coreclr#16551)
* [`[e7ebd7f]`](https://github.com/dotnet/corefx/commit/e7ebd7f) Fix path issues (dotnet/coreclr#16554)
* [`[18b4f89]`](https://github.com/dotnet/corefx/commit/18b4f89) Delete TODO against issue that has been fixed (#27454)
* [`[aca4676]`](https://github.com/dotnet/corefx/commit/aca4676) TryGet for ReadOnlysequence (#27229)
* [`[cb00bee]`](https://github.com/dotnet/corefx/commit/cb00bee) SNIPacket performance improvement (#27187)
* [`[c163350]`](https://github.com/dotnet/corefx/commit/c163350) Allow Schema queue to be detected from the database schema instead of hardcoding the username (#27142)
* [`[ac46f56]`](https://github.com/dotnet/corefx/commit/ac46f56) Use SCH_USE_STRONG_CRYPTO with SystemDefaults (#27382)
* [`[5524eea]`](https://github.com/dotnet/corefx/commit/5524eea) Fix PauseAndContinue failure? (#27444)
* [`[eb39a50]`](https://github.com/dotnet/corefx/commit/eb39a50) Path tests overhaul (#27449)
* [`[58af9ad]`](https://github.com/dotnet/corefx/commit/58af9ad) Port ECDiffieHellman to .NET Core
* [`[f5f7e0c]`](https://github.com/dotnet/corefx/commit/f5f7e0c) Return empty array if length is zero (dotnet/coreclr#16529)
* [`[5d28bfb]`](https://github.com/dotnet/corefx/commit/5d28bfb) Enable WaitHandle.SignalAndWait tests on Unix (#27118)
* [`[cc8db63]`](https://github.com/dotnet/corefx/commit/cc8db63) add issue number
* [`[933ad99]`](https://github.com/dotnet/corefx/commit/933ad99) Address more stacktrace print issues (dotnet/coreclr#16525)
* [`[8447acf]`](https://github.com/dotnet/corefx/commit/8447acf) Add CU\My to the search path for resolving cert chains on Linux
* [`[1885cf8]`](https://github.com/dotnet/corefx/commit/1885cf8) Re-enable initlocals clearing in System.Net.Sockets on Unix (#27411)
* [`[78fc0f0]`](https://github.com/dotnet/corefx/commit/78fc0f0) Update debugging with VS code instructions (#27384)
* [`[c69e6e7]`](https://github.com/dotnet/corefx/commit/c69e6e7) Split up cookie headers that are added via HttpListenerResponse.WebHeaders.Add (#27383)
* [`[42b4772]`](https://github.com/dotnet/corefx/commit/42b4772) Fix ManagedWebSocket cancellation race condition (#27407)
* [`[517238c]`](https://github.com/dotnet/corefx/commit/517238c) be more liberal on what exception type to get on handshake failure (#27352)
* [`[2d05b2f]`](https://github.com/dotnet/corefx/commit/2d05b2f) fix race in SSL cancellation logic and move to ConnectHelper (#27397)
* [`[603c69d8]`](https://github.com/dotnet/corefx/commit/603c69d8) Increase timeout in Expect100ContinueTimeout_SetAfterUse_Throws test
* [`[c37edea]`](https://github.com/dotnet/corefx/commit/c37edea) Disable RemoteInvoke finalizer that's wreaking havoc on CI (#27404)
* [`[b510441]`](https://github.com/dotnet/corefx/commit/b510441) AsReadOnlySpan -> AsSpan rename
* [`[a46c863]`](https://github.com/dotnet/corefx/commit/a46c863) Dial back aggressive checks in Path (dotnet/coreclr#16447)
* [`[6956c87]`](https://github.com/dotnet/corefx/commit/6956c87) Enable ETW EventSource Tests (#27331)
* [`[173d9e6]`](https://github.com/dotnet/corefx/commit/173d9e6) Enable clearing initlocals when running dotnet msbuild. (#27345)
* [`[064a638]`](https://github.com/dotnet/corefx/commit/064a638) Add TryGetOwnedMemory tests and ref (#27288)
* [`[1e3faea]`](https://github.com/dotnet/corefx/commit/1e3faea) Add ReadOnlySpan string-like Equals/CompareTo/IndexOf/Contains API with globalization support (#16467)
* [`[4749c43]`](https://github.com/dotnet/corefx/commit/4749c43) Exclude System.ComponentModel.Composition from netcoreapp2.0
* [`[fb0cbae]`](https://github.com/dotnet/corefx/commit/fb0cbae) Make File.Move copy when the file system doesn't support link (#27371)
* [`[fb17ad8]`](https://github.com/dotnet/corefx/commit/fb17ad8) Fix Socket Async connect issue on Linux (#27173)
* [`[18b6bef]`](https://github.com/dotnet/corefx/commit/18b6bef) Exclude System.ComponentModel.Composition from NS restore
* [`[254649f]`](https://github.com/dotnet/corefx/commit/254649f) Add _netfx placeholder configuration for ref also
* [`[ee0ad7d]`](https://github.com/dotnet/corefx/commit/ee0ad7d) Type forward Lazy<T, M> for all configurations
* [`[6cc77de]`](https://github.com/dotnet/corefx/commit/6cc77de) System.ComponentModel.Composition should use ECMA
* [`[b66086f]`](https://github.com/dotnet/corefx/commit/b66086f) Add CoreLib helpers for MemoryExtensions.AsSpan/AsMemory(T[], int) (#16505)
* [`[11a9368]`](https://github.com/dotnet/corefx/commit/11a9368) add shutdown call to try to make redirect test more reliable
* [`[fecb772]`](https://github.com/dotnet/corefx/commit/fecb772) Disable SocketsHttpHandler's concurrent content sends (#27341)
* [`[9a0200d]`](https://github.com/dotnet/corefx/commit/9a0200d) Disable Dispose assert while we fix it (#27376)
* [`[a273be6]`](https://github.com/dotnet/corefx/commit/a273be6) Fix fragment handling in HttpClient (#27360)
* [`[3de3cd7]`](https://github.com/dotnet/corefx/commit/3de3cd7) Fix NullReferenceException on exception cascade when CEK doesn't decrypt
* [`[ff7e3b2]`](https://github.com/dotnet/corefx/commit/ff7e3b2) Disable DriveInfoWindowsTests.Ctor_InvalidPath_ThrowsArgumentException test
* [`[487060b]`](https://github.com/dotnet/corefx/commit/487060b) Fix impl of ReadOnlySpan ToLower/ToUpper for Unix. (dotnet/coreclr#16496)
* [`[3f779db]`](https://github.com/dotnet/corefx/commit/3f779db) Basic coverage for RuntimeHelpers.PrepareMethod (#27117)
* [`[19b3eff]`](https://github.com/dotnet/corefx/commit/19b3eff) Ignore ping6 failures on macOS 10.12 (#27349)
* [`[29cd6a0]`](https://github.com/dotnet/corefx/commit/29cd6a0) Expose PipeOptions.CurrentUserOnly and add implementation when flag is passed (#26395)
* [`[51bdece]`](https://github.com/dotnet/corefx/commit/51bdece) Ported System.Data.SqlCredential Class  (#27311)
* [`[62878f3]`](https://github.com/dotnet/corefx/commit/62878f3) Make final API review changes to file enumeration (#27318)
* [`[ad34249]`](https://github.com/dotnet/corefx/commit/ad34249) Fix Span Debugger Display String to correctly show the string contents (#27338)
* [`[42d5370]`](https://github.com/dotnet/corefx/commit/42d5370) Add ROSpan StartsWith and EndsWith string-like APIs with StringComparison (#26880)
* [`[546c639]`](https://github.com/dotnet/corefx/commit/546c639) Removing unnecessary lines in pkgproj
* [`[30a00d0]`](https://github.com/dotnet/corefx/commit/30a00d0) Testing GetHashCode works properly when using string with embedded null (#27296)
* [`[541be97]`](https://github.com/dotnet/corefx/commit/541be97) adding a _netfx configuration to src and tests projects
* [`[2b805ce]`](https://github.com/dotnet/corefx/commit/2b805ce) Moved extensions.cs to shared folder in coreclr (dotnet/coreclr#16459)
* [`[3584bdb]`](https://github.com/dotnet/corefx/commit/3584bdb) rework content length logic to drain buffer before doing length check
* [`[5b51318]`](https://github.com/dotnet/corefx/commit/5b51318) Make EnvelopedCms work for Linux and macOS
* [`[90b2a99]`](https://github.com/dotnet/corefx/commit/90b2a99) Skip portable PDB conversion
* [`[9b552ad]`](https://github.com/dotnet/corefx/commit/9b552ad) Improve thread name and start tests (#27287)
* [`[b70df9f]`](https://github.com/dotnet/corefx/commit/b70df9f) Make SqlDataRecord GetData implementation ref dll compatible (#27137)
* [`[54b46bd]`](https://github.com/dotnet/corefx/commit/54b46bd) Adding missing typeforward for Lazy<T,TMetadata> to System.ComponentModel.Composition
* [`[3538128]`](https://github.com/dotnet/corefx/commit/3538128) Rename string-slicing extension methods (#27328)
* [`[a87573a]`](https://github.com/dotnet/corefx/commit/a87573a) Serialization of DataColumn Type Corrected (#27286)
* [`[01326e6]`](https://github.com/dotnet/corefx/commit/01326e6) Fix TryGetOwnedMemory xml docs
* [`[6626bcc]`](https://github.com/dotnet/corefx/commit/6626bcc) Add TryGetOwnedMemory (dotnet/coreclr#16455)
* [`[3abd27d]`](https://github.com/dotnet/corefx/commit/3abd27d) add response stream drain
* [`[fdeedd7]`](https://github.com/dotnet/corefx/commit/fdeedd7) Updated contract, exposed SqlMetaData ctors (#27298)
* [`[71275ae]`](https://github.com/dotnet/corefx/commit/71275ae) make sure socket is blocking after accept() on macOS and BSD (#27213)
* [`[7a0f6ca]`](https://github.com/dotnet/corefx/commit/7a0f6ca) Support System.Runtime.Caching on Linux (#26354)
* [`[fe796bb]`](https://github.com/dotnet/corefx/commit/fe796bb) Increase the package version for Microsoft.Diagnostics.Tracing.EventSource.Redist to 2.0.1. (#27284)
* [`[3b2d395]`](https://github.com/dotnet/corefx/commit/3b2d395) Expose SocketsHttpHandler.ConnectTimeout/Expect100ContinueTimeout (#27292)
* [`[e8a1771]`](https://github.com/dotnet/corefx/commit/e8a1771) split auth and redirect handling back into two separate handlers
* [`[d4534e7]`](https://github.com/dotnet/corefx/commit/d4534e7) Support for RFC 3161 cryptographic timestamps with RFC 5816 additions
* [`[1fd7d79]`](https://github.com/dotnet/corefx/commit/1fd7d79) Log when an insecure Https -> Http redirect is blocked (#27077)
* [`[7c3caab]`](https://github.com/dotnet/corefx/commit/7c3caab) Increase timeout on ConnectTimeout_TimesOutSSLAuth_Throws test (#27294)
* [`[df7eaef]`](https://github.com/dotnet/corefx/commit/df7eaef) use TestHelper.AllowAllCertificates for validation callback to pass test netfx
* [`[3e68d79]`](https://github.com/dotnet/corefx/commit/3e68d79) Propagate exceptions from ServiceBase.OnStart (#26530)
* [`[9ea2589]`](https://github.com/dotnet/corefx/commit/9ea2589) In ImmutableArray.ToDictionary, presize Dictionary (#27280)
* [`[6ab836d]`](https://github.com/dotnet/corefx/commit/6ab836d) Try finalizer on RemoteInvokeHandle (#27087)
* [`[df9b10e]`](https://github.com/dotnet/corefx/commit/df9b10e) Mark Microsoft.Diagnostics.Tracing.EventSource.Redist Package as Stable with Version 2.0 (#27219)
* [`[e45523d]`](https://github.com/dotnet/corefx/commit/e45523d) Replace ValueStringBuilder.set_Length with indexer (#27274)
* [`[5a57de7]`](https://github.com/dotnet/corefx/commit/5a57de7) SocketsHttpHandler: Don't reuse connection with extraneous received data (#27265)
* [`[2fe35d9]`](https://github.com/dotnet/corefx/commit/2fe35d9) Disabling CanRecurseFromRoot test, again (#27276)
* [`[597f44c]`](https://github.com/dotnet/corefx/commit/597f44c) Handle errors getting state in Unix (#27239)
* [`[59b2bfd]`](https://github.com/dotnet/corefx/commit/59b2bfd) Update root dir enum test (#27254)
* [`[336bc18]`](https://github.com/dotnet/corefx/commit/336bc18) Disable CanRecurseFromRoot test (#27252)
* [`[01fa16f]`](https://github.com/dotnet/corefx/commit/01fa16f) Implement SocketsHttpHandler's Expect100ContinueTimeout and ConnectTimeout (#27242)
* [`[e5db8de]`](https://github.com/dotnet/corefx/commit/e5db8de) Delete workaround for #16197 (dotnet/coreclr#16433)
* [`[b9c5530]`](https://github.com/dotnet/corefx/commit/b9c5530) Do not clear service name before deleting it by name (#27225)
* [`[f0c299f]`](https://github.com/dotnet/corefx/commit/f0c299f) update  GetNextIPAddress signature
* [`[5b4ce20]`](https://github.com/dotnet/corefx/commit/5b4ce20) Fix enumerating the root directory. (#27223)
* [`[c360ba2]`](https://github.com/dotnet/corefx/commit/c360ba2) Normalize names of span inputs in crypto API
* [`[cac1f05]`](https://github.com/dotnet/corefx/commit/cac1f05) Add SslStream test to validate options aren't mutated (#27203)
* [`[d3a69ff]`](https://github.com/dotnet/corefx/commit/d3a69ff) Enable SendReceive_VaryingLengthBuffers_Success on Windows run (#27181)
* [`[bb4f065]`](https://github.com/dotnet/corefx/commit/bb4f065) Add Ubuntu 18.04 to CI test runs
* [`[15b56c2]`](https://github.com/dotnet/corefx/commit/15b56c2) rebase with current master. update based on PR feedabck
* [`[a4dc9e3]`](https://github.com/dotnet/corefx/commit/a4dc9e3) use HttpStatusCode.OK instead of cast to (int)200
* [`[62988ad]`](https://github.com/dotnet/corefx/commit/62988ad) initial connect support
* [`[93e5684]`](https://github.com/dotnet/corefx/commit/93e5684) rebase with current master. update based on PR feedabck
* [`[1c974c9]`](https://github.com/dotnet/corefx/commit/1c974c9) Enable overriding of OpenSSL version (#27208)
* [`[522550b]`](https://github.com/dotnet/corefx/commit/522550b) Replace EOL Linux OSes in CI with new ones
* [`[d87258f]`](https://github.com/dotnet/corefx/commit/d87258f) Fix some compression tests
* [`[c5868ab]`](https://github.com/dotnet/corefx/commit/c5868ab) Add RH / Centos 7.4 skus
* [`[a28a2cd]`](https://github.com/dotnet/corefx/commit/a28a2cd) Use NtCreateFile on Win32 (#27195)
* [`[e282c38]`](https://github.com/dotnet/corefx/commit/e282c38) Fix encryption policy error message missing argument (#27205)
* [`[bdba43d]`](https://github.com/dotnet/corefx/commit/bdba43d) Use stackalloc for longer SystemDirectory paths (#27204)
* [`[ef8ed75]`](https://github.com/dotnet/corefx/commit/ef8ed75) Cross compile Pipelines and retarget ref to netstandard1.1 (#27166)
* [`[e153e40]`](https://github.com/dotnet/corefx/commit/e153e40) Fix AuthenticateAsServerAsync argument name in ref (#27201)
* [`[8566f4e]`](https://github.com/dotnet/corefx/commit/8566f4e) clean
* [`[c28fbce]`](https://github.com/dotnet/corefx/commit/c28fbce) Modify StreamContent to use default CopyToAsync buffer size when no size is provided (#27176)
* [`[af8e08a]`](https://github.com/dotnet/corefx/commit/af8e08a) Add ReadOnlySpan string-like ToLower/ToUpper API with globalization support (#16379) (#27197)
* [`[7c4602e]`](https://github.com/dotnet/corefx/commit/7c4602e) Enforce ILLink AssemblyPath order (#27188)
* [`[49b7116]`](https://github.com/dotnet/corefx/commit/49b7116) Add msbuild.binlog to .gitignore (#27183)
* [`[1840df1]`](https://github.com/dotnet/corefx/commit/1840df1) Log libc version in our "OS info logging test" (#27143)
* [`[0049098]`](https://github.com/dotnet/corefx/commit/0049098) Set build moniker to product build ID in prodcon (#27189)
* [`[3ac69e8]`](https://github.com/dotnet/corefx/commit/3ac69e8) Change RootDirectory properties to span (#27134)
* [`[db8d626]`](https://github.com/dotnet/corefx/commit/db8d626) use HttpStatusCode.OK instead of cast to (int)200
* [`[6865bc8]`](https://github.com/dotnet/corefx/commit/6865bc8) initial connect support
* [`[9e0151b]`](https://github.com/dotnet/corefx/commit/9e0151b) Fix regression & enable ClearInitLocals in System.Text.RegularExpressions (#27146)
* [`[f0e6d50]`](https://github.com/dotnet/corefx/commit/f0e6d50) StringComparer Create(culture, CompareOptions) overload (#16334)
* [`[c8d23b4]`](https://github.com/dotnet/corefx/commit/c8d23b4) Streamline SocketHttpHandler's ParseStatusLine validation (#27163)
* [`[a646557]`](https://github.com/dotnet/corefx/commit/a646557) Disable dependencies without new 2.1 builds
* [`[b7d1ae9]`](https://github.com/dotnet/corefx/commit/b7d1ae9) Make many helpers, factories and tables static in Microsoft.CSharp (#27044)
* [`[28799e8]`](https://github.com/dotnet/corefx/commit/28799e8) Fix race condition in PostAsyncExpect100Continue_RetryOnConnectionClosed_Success test (#27148)
* [`[5615f53]`](https://github.com/dotnet/corefx/commit/5615f53) Initialized a  bool variable to fix warning (#26947)
* [`[8e6222a]`](https://github.com/dotnet/corefx/commit/8e6222a) Current directory code duplicates Environment (#27153)
* [`[d00eb7e]`](https://github.com/dotnet/corefx/commit/d00eb7e) disable two tests on ubuntu 18 while investigating root casue (#27144)
* [`[16f26ba]`](https://github.com/dotnet/corefx/commit/16f26ba) Cleaning out dead code (#27150)
* [`[5b09f73]`](https://github.com/dotnet/corefx/commit/5b09f73) Fixing fa-IR negative currency format for test GetCurrencyNegativePatterns (#27139)
* [`[fe548ac]`](https://github.com/dotnet/corefx/commit/fe548ac) Fixing fa-IR negative currency format for test GetCurrencyNegativePatterns (#27138)
* [`[d84a288]`](https://github.com/dotnet/corefx/commit/d84a288) add code to establish proxy tunnel for SSL
* [`[39ed24e]`](https://github.com/dotnet/corefx/commit/39ed24e) reorganize pool manager logic and rework HttpConnectionKey to support ssl proxy tunneling
* [`[2fcc2f8]`](https://github.com/dotnet/corefx/commit/2fcc2f8) Adding Argument name to the Exception (dotnet/coreclr#16372)
* [`[6f06dcc]`](https://github.com/dotnet/corefx/commit/6f06dcc) Disable a SignalAndWait test so that relevant change in CoreCLR can be brought into CoreFX (#27131)
* [`[11182e0]`](https://github.com/dotnet/corefx/commit/11182e0) Add some pattern transformation tests (#27133)
* [`[1eb5ddf]`](https://github.com/dotnet/corefx/commit/1eb5ddf) reduce regex op code time (#26877)
* [`[6b099e7]`](https://github.com/dotnet/corefx/commit/6b099e7) Add support for PDB Checksum debug directory entry (#26976)
* [`[823e019]`](https://github.com/dotnet/corefx/commit/823e019) Fix the fired asset in CompareInfo.IndexOf (dotnet/coreclr#16373) (#27128)
* [`[3872baf]`](https://github.com/dotnet/corefx/commit/3872baf) Add FixedTimeEquals and other crypto helper routines as public API
* [`[e6b5f11]`](https://github.com/dotnet/corefx/commit/e6b5f11) Add ReadOnlySpan string-like StartsWith and EndsWith API with globalization support (#16223) (#27115)
* [`[ad52ae1]`](https://github.com/dotnet/corefx/commit/ad52ae1) Fix and Enable Most ETW EventSource Tests (#27107)
* [`[3fb58a1]`](https://github.com/dotnet/corefx/commit/3fb58a1) Fix registry path for ETW argument lookup. (dotnet/coreclr#16347)
* [`[8606fed]`](https://github.com/dotnet/corefx/commit/8606fed) Move Windows builds to DotNetCore-Build (Server 2016 + VS 2017 only) build agents.
* [`[6943fc7]`](https://github.com/dotnet/corefx/commit/6943fc7) add response generation overloads
* [`[f7a852f]`](https://github.com/dotnet/corefx/commit/f7a852f) Change HTTP default request version to HTTP/2 (#27079)
* [`[2e2b497]`](https://github.com/dotnet/corefx/commit/2e2b497) Fixing test CurrencyNegativePattern_Get() on newly added distro Ubuntu18.04 (#27073)
* [`[53be85c]`](https://github.com/dotnet/corefx/commit/53be85c) Enable SocketsHttpHandler cancellation support (#27029)
* [`[200bae7]`](https://github.com/dotnet/corefx/commit/200bae7) Fixing pkgproj
* [`[bca11a0]`](https://github.com/dotnet/corefx/commit/bca11a0) Fix Process Start tests in outerloop on Unix.
* [`[bb0d129]`](https://github.com/dotnet/corefx/commit/bb0d129) NetCoreapp
* [`[82be16b]`](https://github.com/dotnet/corefx/commit/82be16b) IDuplexPipe
* [`[792c5cd]`](https://github.com/dotnet/corefx/commit/792c5cd) T
* [`[8c9a215]`](https://github.com/dotnet/corefx/commit/8c9a215) clean GetHostByAddr unix
* [`[24b84fa]`](https://github.com/dotnet/corefx/commit/24b84fa) clean GetHostByAddr unix
* [`[ffa5db3]`](https://github.com/dotnet/corefx/commit/ffa5db3) Fix SocketsHttpHandler connection pool accounting for dropped connections (#27068)
* [`[0f0713f]`](https://github.com/dotnet/corefx/commit/0f0713f) clean GetHostByAddr Windows
* [`[f0a032e]`](https://github.com/dotnet/corefx/commit/f0a032e) Clear initlocals in a bunch of assemblies (#26993)
* [`[a7c62d7]`](https://github.com/dotnet/corefx/commit/a7c62d7) nit
* [`[e6c97f4]`](https://github.com/dotnet/corefx/commit/e6c97f4) update DNS.cs
* [`[7425455]`](https://github.com/dotnet/corefx/commit/7425455) Workstation Id should be returned correctly (#27076)
* [`[73d8163]`](https://github.com/dotnet/corefx/commit/73d8163) Update ProjectNTfs, ProjectNTfsTestILC to beta-26213-00, beta-26213-00, respectively (#27083)
* [`[5cbac95]`](https://github.com/dotnet/corefx/commit/5cbac95) Lower the default stack buffer size for calling getpwXXX_r methods.
* [`[de9c1b3]`](https://github.com/dotnet/corefx/commit/de9c1b3) Update Sgen version to 2.0 and assembly version to 2.0 in 2.1 release branch (#26908)
* [`[c9100ff]`](https://github.com/dotnet/corefx/commit/c9100ff) Switch from using SafeHandle for Unix enumeration (#27052)
* [`[efcb7c2]`](https://github.com/dotnet/corefx/commit/efcb7c2) Use DateTime.ToFileTimeUtc to generate serializable DateTime for TraceLogging events. (#16317) (#27072)
* [`[2d44625]`](https://github.com/dotnet/corefx/commit/2d44625) Project changeS
* [`[4b4440b]`](https://github.com/dotnet/corefx/commit/4b4440b) Disable drawing test for distro Ubuntu18.04 (#27036)
* [`[7e6396b]`](https://github.com/dotnet/corefx/commit/7e6396b) Clear Authorization Headers on Redirect (#26864)
* [`[20d9824]`](https://github.com/dotnet/corefx/commit/20d9824) Fix the throwing exception from ChannelReader.ReadAsync (#27070)
* [`[6c9b629]`](https://github.com/dotnet/corefx/commit/6c9b629) Fix HttpClientMiniStress.UnreadResponseMessage_Collectible test (#27061)
* [`[a07b356]`](https://github.com/dotnet/corefx/commit/a07b356) Update rename of ManagedHandler to SocketsHttpHandler
* [`[911d4af]`](https://github.com/dotnet/corefx/commit/911d4af) Cache SslClientAuthenticationOptions on SocketsHttpHandler pool
* [`[015cf5d]`](https://github.com/dotnet/corefx/commit/015cf5d) Allow RangeAttribute use to request InvariantCulture conversions. (#25918)
* [`[36a15af]`](https://github.com/dotnet/corefx/commit/36a15af) acutal -> actual (#27050)
* [`[d3ff31e]`](https://github.com/dotnet/corefx/commit/d3ff31e) Modified Dns.GetHostAddressesAsync to be truly async (#26850)
* [`[c20262c]`](https://github.com/dotnet/corefx/commit/c20262c) consolidate cookie tests
* [`[bf5a318]`](https://github.com/dotnet/corefx/commit/bf5a318) Add SocketsHttpHandler check for TransferEncodingChunked w/o Content (#27040)
* [`[a127f01]`](https://github.com/dotnet/corefx/commit/a127f01) Fix more new T[0] to be Array.Empty\<T>() (#27042)
* [`[7f19e76]`](https://github.com/dotnet/corefx/commit/7f19e76) Fix some license headers across the repo (#27039)
* [`[4ff3c79]`](https://github.com/dotnet/corefx/commit/4ff3c79) Mark {Configured}ValueTaskAwaiter as readonly in contracts (#27030)
* [`[8fdf896]`](https://github.com/dotnet/corefx/commit/8fdf896) Fixing test CurrencyNegativePattern_Get() on newly added distro Ubuntu18.04 (#27035)
* [`[08bcfb4]`](https://github.com/dotnet/corefx/commit/08bcfb4) clasname -> classname (#27025)
* [`[5349873]`](https://github.com/dotnet/corefx/commit/5349873) Fix *Info classes for Unix when opened on root (#27024)
* [`[57ba13c]`](https://github.com/dotnet/corefx/commit/57ba13c) Add Hebrew Months test (#26915)
* [`[430de8f]`](https://github.com/dotnet/corefx/commit/430de8f) Fix Unix enumeration (#27019)
* [`[290e2f7]`](https://github.com/dotnet/corefx/commit/290e2f7) Add back TraceFormat.Normal to avoid additional newlines from being added
* [`[c501f83]`](https://github.com/dotnet/corefx/commit/c501f83) exclude errorSource from call to Environment.FailFast on Unix
* [`[58fd943]`](https://github.com/dotnet/corefx/commit/58fd943) dependancy -> dependency (dotnet/corert#5350)
* [`[8cc3ffb]`](https://github.com/dotnet/corefx/commit/8cc3ffb) Restrict the Long Running option to MARS (#27010)
* [`[7406c4c]`](https://github.com/dotnet/corefx/commit/7406c4c) Trying to collect info about ping test failures in macOS 10.12 (#26997)
* [`[54c80d8]`](https://github.com/dotnet/corefx/commit/54c80d8) Update intellisense file drop based on 2-2-2018 doc build (#27005)
* [`[4bfb838]`](https://github.com/dotnet/corefx/commit/4bfb838) Fix T[]->ArraySegment cast to return default for null (#16301)
* [`[468db63]`](https://github.com/dotnet/corefx/commit/468db63) minimal support for ManagedHandler proxy configuration on Windows  (#26878)
* [`[4acf7f9]`](https://github.com/dotnet/corefx/commit/4acf7f9) Cover
* [`[a72988c]`](https://github.com/dotnet/corefx/commit/a72988c) Increasing OSX build timeout while we investigate the Performance hit (#27002)
* [`[c3a898a]`](https://github.com/dotnet/corefx/commit/c3a898a) Resources
* [`[30f0b63]`](https://github.com/dotnet/corefx/commit/30f0b63) conditionsed -> conditioned (#26998)
* [`[59f5f60]`](https://github.com/dotnet/corefx/commit/59f5f60) Fixing a regression introduced by the previous test fix. (#26970)
* [`[ef0aca5]`](https://github.com/dotnet/corefx/commit/ef0aca5) Make Unix filename conversion lazy (#26978)
* [`[6730463]`](https://github.com/dotnet/corefx/commit/6730463) Disable Http status line test cases on CurlHandler (#26982)
* [`[5875a4d]`](https://github.com/dotnet/corefx/commit/5875a4d) Add Ubuntu 18 to supported Linuxes
* [`[ce0de73]`](https://github.com/dotnet/corefx/commit/ce0de73) Restore Channels ReadAsync implementation (#26934)
* [`[03414aa]`](https://github.com/dotnet/corefx/commit/03414aa) Fix ProcessStartInfo tests on CentOS in Debug (#26945)
* [`[5cec1f3]`](https://github.com/dotnet/corefx/commit/5cec1f3) Return canceled task from WaitToReadAsync even if data available (#26974)
* [`[f6f5188]`](https://github.com/dotnet/corefx/commit/f6f5188) Fix WebSocketProtocol test that never worked on netfx
* [`[8cb4d13]`](https://github.com/dotnet/corefx/commit/8cb4d13) Add more SocketsHttpHandler tests
* [`[852d40e]`](https://github.com/dotnet/corefx/commit/852d40e) Expose SocketsHttpHandler
* [`[d374be8]`](https://github.com/dotnet/corefx/commit/d374be8) PDB Checksum Debug Directory Record Specification (#26912)
* [`[0441e32]`](https://github.com/dotnet/corefx/commit/0441e32) Explictly initialize EventData.Reserved for System.Private.CoreLib. (#16283)
* [`[ccc21d0]`](https://github.com/dotnet/corefx/commit/ccc21d0) Provide GetSchema override for DbConnectionClosed (#26951)
* [`[f3e7e18]`](https://github.com/dotnet/corefx/commit/f3e7e18) Ensure EventData structs in EventSource implementations are zero'd (#26968)
* [`[dee5c34]`](https://github.com/dotnet/corefx/commit/dee5c34) Compiles
* [`[5641f76]`](https://github.com/dotnet/corefx/commit/5641f76) Extra semicolons left at the end of Combine function taking 4 paths. (#16284)
* [`[8cd6cf7]`](https://github.com/dotnet/corefx/commit/8cd6cf7) Adding some math tests to ensure additional values outside the input domain are tested. (#26955)
* [`[c64171e]`](https://github.com/dotnet/corefx/commit/c64171e) Reduce Unix enumeration allocations (#26942)
* [`[426e1c7]`](https://github.com/dotnet/corefx/commit/426e1c7) Enable HttpProtocolTest status line test cases (#26798)
* [`[5114e42]`](https://github.com/dotnet/corefx/commit/5114e42) Treat Crypto.Cng as inbox on Xamarin profiles.
* [`[b8327d3]`](https://github.com/dotnet/corefx/commit/b8327d3) fix source file reference
* [`[a4ab230]`](https://github.com/dotnet/corefx/commit/a4ab230) PropertyDescriptor - MemberDescriptor.Attributes (iteration 2)  (#26756)
* [`[ac72f91]`](https://github.com/dotnet/corefx/commit/ac72f91) Improve OSX build instructions (#26874)
* [`[6645300]`](https://github.com/dotnet/corefx/commit/6645300) Throwing IO Related exception only on FileStream.Dispose(disposing:true) (#16250)
* [`[9ecd669]`](https://github.com/dotnet/corefx/commit/9ecd669) Agruments -> Arguments (dotnet/coreclr#16273)
* [`[4bb1dc2]`](https://github.com/dotnet/corefx/commit/4bb1dc2) clean win code
* [`[5573f26]`](https://github.com/dotnet/corefx/commit/5573f26) Add System.IO.Pipelines
* [`[b606181]`](https://github.com/dotnet/corefx/commit/b606181) Re-Enable disabled DNS tests on OSX (#26949)
* [`[011eeca]`](https://github.com/dotnet/corefx/commit/011eeca) Initialize stack allocated data structures. (dotnet/coreclr#16259) (#26943)
* [`[ee7d459]`](https://github.com/dotnet/corefx/commit/ee7d459) Switch ManagedHandler to use SslClientAuthenticationOptions (#26870)
* [`[ee63fe7]`](https://github.com/dotnet/corefx/commit/ee63fe7) Removing the Sse2.LoadScalarVector128 overloads that are invalid.
* [`[a73c8f9]`](https://github.com/dotnet/corefx/commit/a73c8f9) Make content in response have length matching content-length (#26932)
* [`[b6b7eb0]`](https://github.com/dotnet/corefx/commit/b6b7eb0) Implement MaxResponseHeadersLength on ManagedHandler (#26906)
* [`[2aee413]`](https://github.com/dotnet/corefx/commit/2aee413) Adding the Acosh, Asinh, Atanh, and Cbrt functions to System.Math and System.MathF
* [`[3c24c32]`](https://github.com/dotnet/corefx/commit/3c24c32) [Unix] Passing extra CMake args (#26792)
* [`[e2cd5a8]`](https://github.com/dotnet/corefx/commit/e2cd5a8) Fix accessing trimmed paths (#26918)
* [`[301708f]`](https://github.com/dotnet/corefx/commit/301708f) Adding TrimExcess API to Dictionary and providing tests (#26239)
* [`[800974a]`](https://github.com/dotnet/corefx/commit/800974a) Fix duplicated refnames (#26929)
* [`[b021f14]`](https://github.com/dotnet/corefx/commit/b021f14) Fix duplicated refnames (#26930)
* [`[a9e01da]`](https://github.com/dotnet/corefx/commit/a9e01da) Fix ServicePointManager.ProxyAddressIfNecessary to ignore "system" proxy failures (#26925)
* [`[1a5cdbe]`](https://github.com/dotnet/corefx/commit/1a5cdbe) Add Connection{Idle}Timeouts to ManagedHandler (#26839)
* [`[e03cc8f]`](https://github.com/dotnet/corefx/commit/e03cc8f) Update ProjectNTfs, ProjectNTfsTestILC to beta-26207-00, beta-26207-00, respectively (#26923)
* [`[1d57ba9]`](https://github.com/dotnet/corefx/commit/1d57ba9) Fix Hebrew calendar month names list (dotnet/coreclr#16247)
* [`[5df800a]`](https://github.com/dotnet/corefx/commit/5df800a) Implementation of GetFullPath(string path, string basePath) (#15579)
* [`[e35507a]`](https://github.com/dotnet/corefx/commit/e35507a) Add ReadOnlySequence API (#26694)
* [`[7af4af9]`](https://github.com/dotnet/corefx/commit/7af4af9) Update Sgen version to 2.0 and assembly version to 2.0. (#26905)
* [`[b166d49]`](https://github.com/dotnet/corefx/commit/b166d49) Hardening sliding expiration cache test (#26883)
* [`[2b90844]`](https://github.com/dotnet/corefx/commit/2b90844) Delete dead or redundant code (#26890)
* [`[cbdc181]`](https://github.com/dotnet/corefx/commit/cbdc181) Move String.Manipulation.cs to shared (dotnet/coreclr#16226)
* [`[44abe08]`](https://github.com/dotnet/corefx/commit/44abe08) Update ProjectNTfs, ProjectNTfsTestILC to beta-26206-00, beta-26206-00, respectively (#26884)
* [`[cd26075]`](https://github.com/dotnet/corefx/commit/cd26075) Proper check for OpenSSL version in System.Net.Http.Tests (#26873)
* [`[08dad51]`](https://github.com/dotnet/corefx/commit/08dad51) Add the ability to specify case matching behavior for GetFiles (#26876)
* [`[ae551db]`](https://github.com/dotnet/corefx/commit/ae551db) Update for in, readonly struct, ref struct (#26841)
* [`[8c947b7]`](https://github.com/dotnet/corefx/commit/8c947b7) Add temporary logging to help us trace down root cause for dotnet/coreclr#16063 (#26866)
* [`[36ba1e4]`](https://github.com/dotnet/corefx/commit/36ba1e4) Changing Span/Memory to return default on null instead of throwing. (#16186)
* [`[60cc27e]`](https://github.com/dotnet/corefx/commit/60cc27e) Port compat pack fixes to 2.1 (#26697)
* [`[80ef82c]`](https://github.com/dotnet/corefx/commit/80ef82c) Regex perf test (#26827)
* [`[ef79caf]`](https://github.com/dotnet/corefx/commit/ef79caf) Disable UAP official builds (#26871)
* [`[0995ed1]`](https://github.com/dotnet/corefx/commit/0995ed1) Disable some System.Net.WebHeaderCollection tests on Mono. (#26862)
* [`[5102db6]`](https://github.com/dotnet/corefx/commit/5102db6) Fix some S.Drawing.Common licence headers (#26863)
* [`[66ada72]`](https://github.com/dotnet/corefx/commit/66ada72) File enumeration extensibility (#26806)
* [`[4adbec4]`](https://github.com/dotnet/corefx/commit/4adbec4) Added a factory to FileStreamCompletionSource (dotnet/coreclr#16190)
* [`[0ff2a6f]`](https://github.com/dotnet/corefx/commit/0ff2a6f) Use stackalloc in string.Split (dotnet/coreclr#15435)
* [`[2ef483f]`](https://github.com/dotnet/corefx/commit/2ef483f) Add System.Security.Permissions netfx facade and mark some APIs as obsolet to match desktop (#26758)
* [`[4565226]`](https://github.com/dotnet/corefx/commit/4565226) Disable some System.Net.Requests tests on Mono. (#26858)
* [`[5bc8074]`](https://github.com/dotnet/corefx/commit/5bc8074) Add stress test to System.Threading.Channels (#26655)
* [`[3d2f149]`](https://github.com/dotnet/corefx/commit/3d2f149) clean up encoding handling
* [`[3aeb84f]`](https://github.com/dotnet/corefx/commit/3aeb84f) Update Desktop support links
* [`[8c3ac09]`](https://github.com/dotnet/corefx/commit/8c3ac09) Disable Http test for 26770 (#26854)
* [`[80e220f]`](https://github.com/dotnet/corefx/commit/80e220f) Fix regex scanner for `\c[` (#26828)
* [`[4fd8620]`](https://github.com/dotnet/corefx/commit/4fd8620) Reduce test run time to help avoid timeouts in CI for outerloop tests (#26751)
* [`[e9be24d]`](https://github.com/dotnet/corefx/commit/e9be24d) Disable Net.Http tests failing in Fedora.27 (#26835)
* [`[928d525]`](https://github.com/dotnet/corefx/commit/928d525) Change the semantics of Span ToString to return the contents for T=char (#26726)
* [`[af18a5f]`](https://github.com/dotnet/corefx/commit/af18a5f) TypeDefinition.IsNested Property (#25963)
* [`[3cd61ad]`](https://github.com/dotnet/corefx/commit/3cd61ad) Fix IndexOutOfRange for invalid grouping construct (#26829)
* [`[2202b4f]`](https://github.com/dotnet/corefx/commit/2202b4f) Disable UAP configurations in all configurations build
* [`[cd48d86]`](https://github.com/dotnet/corefx/commit/cd48d86) Changing Span to return default on null instead of throwing.
* [`[c98a153]`](https://github.com/dotnet/corefx/commit/c98a153) Update System.Diagnostic.Debug whitebox test to match CoreCLR changes
* [`[3ad966f]`](https://github.com/dotnet/corefx/commit/3ad966f) Use Vector\<T> from System.Private.CoreLib.
* [`[d4d1f4a]`](https://github.com/dotnet/corefx/commit/d4d1f4a) Codecoverage corefx\src\System.Reflection.Metadata\src\System\Reflection\Metadata\MetadataReader.cs  (#26321)
* [`[1678ac2]`](https://github.com/dotnet/corefx/commit/1678ac2) Update performance-tests.md
* [`[24a580c]`](https://github.com/dotnet/corefx/commit/24a580c) Fix failfast stacktrace (dotnet/coreclr#15895)
* [`[120dce4]`](https://github.com/dotnet/corefx/commit/120dce4) Disable UAP legs per #26802 (#26822)
* [`[8ec2cf2]`](https://github.com/dotnet/corefx/commit/8ec2cf2) Disable ExpectContinue in ManagedHandler when using version 1.0 (#26774)
* [`[3d38415]`](https://github.com/dotnet/corefx/commit/3d38415) Enable Stress mode environment variable (#26808)
* [`[a4e3009]`](https://github.com/dotnet/corefx/commit/a4e3009) Use Temp tables in tests (#26805)
* [`[3952fdd]`](https://github.com/dotnet/corefx/commit/3952fdd) Fix issues with test tables in SqlClient tests (#26809)
* [`[47c4317]`](https://github.com/dotnet/corefx/commit/47c4317) Dictionary exposes internal type comparer (dotnet/coreclr#16151)
* [`[ea356c0]`](https://github.com/dotnet/corefx/commit/ea356c0) Add Debug Views to the Channel (#26795)
* [`[0e67638]`](https://github.com/dotnet/corefx/commit/0e67638) Update TVPTest error comparisons to use error codes instead of full exception messages. Exception messages can be slightly different between different versions of SQL Server. (#26800)
* [`[4f36d83]`](https://github.com/dotnet/corefx/commit/4f36d83) Fixing invalid setting in .editorconfig (#26767)
* [`[3d39568]`](https://github.com/dotnet/corefx/commit/3d39568) Updated contract and exposed GetSchema and GetSchemaTable methods (#26762)
* [`[e7de7f7]`](https://github.com/dotnet/corefx/commit/e7de7f7) Adding EnsureCapacity API to HashSet (#26777)
* [`[a68803c]`](https://github.com/dotnet/corefx/commit/a68803c) Span factoring (#26667)
* [`[c727d12]`](https://github.com/dotnet/corefx/commit/c727d12) get connection from pool to send digest auth response (#26733)
* [`[524f01c]`](https://github.com/dotnet/corefx/commit/524f01c) Disable failing DNS tests on macOS (#26790)
* [`[63c75d0]`](https://github.com/dotnet/corefx/commit/63c75d0) Update environment variable used for Http.StressEnabled
* [`[7ff6231]`](https://github.com/dotnet/corefx/commit/7ff6231) ajdust -> adjust (dotnet/corert#5327)
* [`[6f8a600]`](https://github.com/dotnet/corefx/commit/6f8a600) Clean up ManagedHandler sending of request content (#26759)
* [`[85c943f]`](https://github.com/dotnet/corefx/commit/85c943f) support LF line endings and trailer headers
* [`[473a4cf]`](https://github.com/dotnet/corefx/commit/473a4cf) Fix ManagedHandler env var / AppContext handling (#26763)
* [`[7aa6d90]`](https://github.com/dotnet/corefx/commit/7aa6d90) Mirror changes from dotnet/coreclr (#26771)
* [`[166f2ba]`](https://github.com/dotnet/corefx/commit/166f2ba) Disable SetDelegate_ConnectionSucceeds on Linux (#26773)
* [`[bb738a0]`](https://github.com/dotnet/corefx/commit/bb738a0) Move ManagedHandler version/chunking validation earlier (#26766)
* [`[2b4664a]`](https://github.com/dotnet/corefx/commit/2b4664a) Use TryFormat with spans in a few more places in ManagedHandler (#26755)
* [`[64634c7]`](https://github.com/dotnet/corefx/commit/64634c7) BigInteger based random testing of Decimal (part 2) (#26338)
* [`[7b6abc2]`](https://github.com/dotnet/corefx/commit/7b6abc2) Use ValueTask shared from corelib (#26636)
* [`[9bf574e]`](https://github.com/dotnet/corefx/commit/9bf574e) Only search for member types in Microsoft.CSharp member lookup. (#26633)
* [`[033851f]`](https://github.com/dotnet/corefx/commit/033851f) Disable Brotli perf tests (#26746)
* [`[0bc7246]`](https://github.com/dotnet/corefx/commit/0bc7246) Disable failing NameResolutionPalTests (#26747)
* [`[04f0b1e]`](https://github.com/dotnet/corefx/commit/04f0b1e) Make SslStreamInternal to free resources with SslStream dispose. (#26666)
* [`[7c4d35b]`](https://github.com/dotnet/corefx/commit/7c4d35b) intecept -> intercept (#26742)
* [`[6000379]`](https://github.com/dotnet/corefx/commit/6000379) NetworkChange should capture AsyncLocals (but not to Timer) (#26073)
* [`[504781c]`](https://github.com/dotnet/corefx/commit/504781c) Update HttpStatusCode enum (#26727)
* [`[a9ceaaf]`](https://github.com/dotnet/corefx/commit/a9ceaaf) Span overload added for path apis (dotnet/coreclr#15608)
* [`[9002768]`](https://github.com/dotnet/corefx/commit/9002768) Updating the x86 HWIntrinsic ref assembly
* [`[c1f7bb9]`](https://github.com/dotnet/corefx/commit/c1f7bb9) Fix spacing in WebClient tests .csproj
* [`[3c4115d]`](https://github.com/dotnet/corefx/commit/3c4115d) WebClient progress monitoring uses ContentLength header (#26462)
* [`[6f5d255]`](https://github.com/dotnet/corefx/commit/6f5d255) fix dribble tests when client disconnects on bad request (#26730)
* [`[454220d]`](https://github.com/dotnet/corefx/commit/454220d) add proxy configuration based on environment variables on Unix  (#26341)
* [`[62a3d89]`](https://github.com/dotnet/corefx/commit/62a3d89) Separate basic auth test cases for HttpClientHandler (#26713)
* [`[efdbbe6]`](https://github.com/dotnet/corefx/commit/efdbbe6) Utf8Parsing - the remaining 'N' format overloads (#26683)
* [`[8ae3df0]`](https://github.com/dotnet/corefx/commit/8ae3df0) Fix BoundedChannel.DequeueItemAndPostProcess to respect _doneWriting (#26707)
* [`[623af48]`](https://github.com/dotnet/corefx/commit/623af48) Add ValueTask perf tests (#26706)
* [`[64976bf]`](https://github.com/dotnet/corefx/commit/64976bf) implement connection retry logic and related changes
* [`[363599c]`](https://github.com/dotnet/corefx/commit/363599c) Building non-Windows builds using the CLI's MSBuild (#26686)
* [`[9885497]`](https://github.com/dotnet/corefx/commit/9885497) Replace JitIntrinsicAttribute with IntrinsicAttribute (#26700)
* [`[072b288]`](https://github.com/dotnet/corefx/commit/072b288) Reduce Execution Context Save+Restore (dotnet/coreclr#15629)
* [`[54d3e65]`](https://github.com/dotnet/corefx/commit/54d3e65) Activity shouldn't capture AsyncLocals into its Timer (#26071)
* [`[9e1b334]`](https://github.com/dotnet/corefx/commit/9e1b334) Add new MediaTypeNames (#26701)
* [`[42dcfe5]`](https://github.com/dotnet/corefx/commit/42dcfe5) Replacing Lock with Volatile.Read for SecureString Length (#16112)
* [`[530fb9e]`](https://github.com/dotnet/corefx/commit/530fb9e) Follow up changes For serviceBase (#26695)
* [`[035305b]`](https://github.com/dotnet/corefx/commit/035305b) Make AsnSerializer resiliant to ILC reflection rules
* [`[da8a105]`](https://github.com/dotnet/corefx/commit/da8a105) Fixed ReadAsync blocking issue (#26595)
* [`[4852538]`](https://github.com/dotnet/corefx/commit/4852538) Don't capture AsyncLocals into ODBC Global Timers (#26066)
* [`[ec353e2]`](https://github.com/dotnet/corefx/commit/ec353e2) Missing guid from two interop types (#26688)
* [`[2148656]`](https://github.com/dotnet/corefx/commit/2148656) Add System.IO.Pipelines
* [`[66629c5]`](https://github.com/dotnet/corefx/commit/66629c5) Replace TryCopyTo with CopyTo (dotnet/coreclr#16078)
* [`[873d4ee]`](https://github.com/dotnet/corefx/commit/873d4ee) Add System.Threading.Channels
* [`[5494ff2]`](https://github.com/dotnet/corefx/commit/5494ff2) Update servicemodel dependencies to latest stable version (#26281)
* [`[6aa7ebd]`](https://github.com/dotnet/corefx/commit/6aa7ebd) Move Vector\<T> to the shared CoreLib partition. (#26656)
* [`[3b69635]`](https://github.com/dotnet/corefx/commit/3b69635) Make redirect test case really 'redirect' (#26674)
* [`[179cf08]`](https://github.com/dotnet/corefx/commit/179cf08) Http protocol dribble tests taking two long (#26680)
* [`[451824f]`](https://github.com/dotnet/corefx/commit/451824f) Add netfx placeholder configuration to System.Data.DataSetExtensions (#26576)
* [`[c78d3d4]`](https://github.com/dotnet/corefx/commit/c78d3d4) ServiceBase And ServiceController Tests using NamedPipes (#26524)
* [`[bcc2940]`](https://github.com/dotnet/corefx/commit/bcc2940) Don't capture AsyncLocals into EventCounter timer (#26075)
* [`[4a57e80]`](https://github.com/dotnet/corefx/commit/4a57e80) Use ToArray based debuggerview for portable span (#26661)
* [`[34709c5]`](https://github.com/dotnet/corefx/commit/34709c5) Make Linux and macOS throw the same exception on unknown hash algorithms (#26648)
* [`[093126c]`](https://github.com/dotnet/corefx/commit/093126c) Don't capture AsyncLocals into SQL global timers (#26065)
* [`[36ae610]`](https://github.com/dotnet/corefx/commit/36ae610) Stack\<T> optimization of (Try)Peek, (Try)Pop and Push (#26086)
* [`[fc7cd1b]`](https://github.com/dotnet/corefx/commit/fc7cd1b) Queue\<T> optimization of (Try)Dequeue (#26087)
* [`[7320c34]`](https://github.com/dotnet/corefx/commit/7320c34) Move TimeZoneInfo.Unix.cs to shared CoreLib partition (#16057)
* [`[6920435]`](https://github.com/dotnet/corefx/commit/6920435) EnsureCapacty(0) should return zero as capacity for a non initialized Dictionary rather than doing initialization. (#16076)
* [`[5b5eacf]`](https://github.com/dotnet/corefx/commit/5b5eacf) Add try-finally statements around AbortTransaction calls in SqlBulkCopy, so that parser locks always get released. (#26649)
* [`[7590642]`](https://github.com/dotnet/corefx/commit/7590642) Make ProtectedData function on empty input
* [`[4f8c637]`](https://github.com/dotnet/corefx/commit/4f8c637) Fix regression in Microsoft.CSharp on accessing accessors or operators (#26620)
* [`[b91b6c6]`](https://github.com/dotnet/corefx/commit/b91b6c6) fix CurlHandler test for 2.0 response
* [`[b3ad6ab]`](https://github.com/dotnet/corefx/commit/b3ad6ab) Replace TryCopyTo with CopyTo (#26641)
* [`[dfd9d76]`](https://github.com/dotnet/corefx/commit/dfd9d76) Disable the DiagnosticTest on Framework  (#26645)
* [`[3d1ebc1]`](https://github.com/dotnet/corefx/commit/3d1ebc1) Use corelib-shared ValueStringBuilder
* [`[7528d61]`](https://github.com/dotnet/corefx/commit/7528d61) Use EventSource guid ctor for ArrayPoolEventSource (dotnet/coreclr#16054)
* [`[97af4b4]`](https://github.com/dotnet/corefx/commit/97af4b4) Fix various issues with System.Json.JsonValue.Save (#26502)
* [`[3f3e8ec]`](https://github.com/dotnet/corefx/commit/3f3e8ec) Utf8Parsing for Int32 'N' format (#26635)
* [`[4464cce]`](https://github.com/dotnet/corefx/commit/4464cce) Support Process.Start as a different user on Unix. (#26431)
* [`[36664b1]`](https://github.com/dotnet/corefx/commit/36664b1) Fix IO error handling for adding certs to X509Store on Linux
* [`[a623ebc]`](https://github.com/dotnet/corefx/commit/a623ebc) make opaque parameter optional
* [`[ab0e5a0]`](https://github.com/dotnet/corefx/commit/ab0e5a0) Make sure HttpListenerContext will not deallocate twice (#26596)
* [`[dda4e4e]`](https://github.com/dotnet/corefx/commit/dda4e4e) Optimize Span.Copy and Span.TryCopyTo (dotnet/coreclr#15947)
* [`[3b2666a]`](https://github.com/dotnet/corefx/commit/3b2666a) Avoid cast of Microsoft.CSharp's binder types. (#26565)
* [`[2cdb8eb]`](https://github.com/dotnet/corefx/commit/2cdb8eb) Adding the `Vector64\<T>` type to the S.R.Intrinsics assembly
* [`[e274885]`](https://github.com/dotnet/corefx/commit/e274885) Enable some HttpProtocolTests test cases and skip them on .NET Core Windows run (#26573)
* [`[92df694]`](https://github.com/dotnet/corefx/commit/92df694)  String-like Span extension methods - Trim / IsWhiteSpace (#26560)
* [`[b8a15a7]`](https://github.com/dotnet/corefx/commit/b8a15a7) Fix some Channel issues (#26570)
* [`[d22340e]`](https://github.com/dotnet/corefx/commit/d22340e) Regression test for AM/PMDesignator handling (#26436)
* [`[5d5f341]`](https://github.com/dotnet/corefx/commit/5d5f341) Reflection-block some types in CoreLib (dotnet/corert#5286)
* [`[b743570]`](https://github.com/dotnet/corefx/commit/b743570) Add netfx placeholder configurations for inbox projects and enable netfx tests (#26559)
* [`[7676967]`](https://github.com/dotnet/corefx/commit/7676967) Add SqlCommand Begin and EndExecuteXmlReader functions (#26252)
* [`[c8c29ba]`](https://github.com/dotnet/corefx/commit/c8c29ba) Undo early test commit
* [`[d1fbaaf]`](https://github.com/dotnet/corefx/commit/d1fbaaf) Commit to test mirroring
* [`[956aefe]`](https://github.com/dotnet/corefx/commit/956aefe) Command line tokenization reconciling (#25857)
* [`[e99d46a]`](https://github.com/dotnet/corefx/commit/e99d46a) Disable the default interface methods feature
* [`[83f35ef]`](https://github.com/dotnet/corefx/commit/83f35ef) Add Unsafe.IsAddressGreaterThan and IsAddressLessThan
* [`[2836df3]`](https://github.com/dotnet/corefx/commit/2836df3) Enable HttpProtocolTests test cases on .NET Core (#26525)
* [`[a654ff0]`](https://github.com/dotnet/corefx/commit/a654ff0) Add Unsafe.IsAddressGreaterThan / IsAddressLessThan (dotnet/coreclr#15988)
* [`[696bc03]`](https://github.com/dotnet/corefx/commit/696bc03) Port the DirectoryService test fix from master branch
* [`[3f03814]`](https://github.com/dotnet/corefx/commit/3f03814) Fix ThrowObjectDisposedException_MemoryDisposed arguments
* [`[71545fb]`](https://github.com/dotnet/corefx/commit/71545fb) Rename Libraries.GlobalizationInterop to Libraries.GlobalizationNative
* [`[fbe7fbe]`](https://github.com/dotnet/corefx/commit/fbe7fbe) Define Interop.Kernel32.MAX_PATH (dotnet/coreclr#15952)
* [`[a7ec5fb]`](https://github.com/dotnet/corefx/commit/a7ec5fb) Fix timezone lookup to be consistently case insensitive (#15951)
* [`[c96e1f8]`](https://github.com/dotnet/corefx/commit/c96e1f8) Fix Failed DirectoryServices Test (#26549)
* [`[6bfbf57]`](https://github.com/dotnet/corefx/commit/6bfbf57) Add missing RIDs for all supported OSes (#26439)
* [`[19aa9ff]`](https://github.com/dotnet/corefx/commit/19aa9ff) Disable 307 LargePayload again (#26547)
* [`[efcea2c]`](https://github.com/dotnet/corefx/commit/efcea2c) Split MemoryMarshal.Portable.cs
* [`[5b1af42]`](https://github.com/dotnet/corefx/commit/5b1af42) Fixing spacing in S.Memory and S.Runtime refs (#26521)
* [`[0f22f46]`](https://github.com/dotnet/corefx/commit/0f22f46) move managed handler test class to ManagedHandlerTest.cs
* [`[bc64832]`](https://github.com/dotnet/corefx/commit/bc64832) disable IDNA tests on full framework
* [`[b17ac0e]`](https://github.com/dotnet/corefx/commit/b17ac0e) Move TimeZoneInfo.Win32.cs to shared CoreLib partition (#15953)
* [`[3bd9262]`](https://github.com/dotnet/corefx/commit/3bd9262) Rename Pin offset to byteOffset and clean up Retain test (#26518)
* [`[dd268c8]`](https://github.com/dotnet/corefx/commit/dd268c8) Move DiagnosticSourceStartStop to Outerloop until flakiness resolved (#26516)
* [`[c7f2e35]`](https://github.com/dotnet/corefx/commit/c7f2e35) Fix StringWriterTests (#26510)
* [`[c955510]`](https://github.com/dotnet/corefx/commit/c955510) Expose CharUnicodeInfo.GetUnicodeCategory(int) (#26430)
* [`[26e1613]`](https://github.com/dotnet/corefx/commit/26e1613) Increase AsyncLocal testing (#26500)
* [`[3102a87]`](https://github.com/dotnet/corefx/commit/3102a87) Support op_Exponent and op_Exponentiation in S.L.Expressions (#26413)
* [`[36eb70c]`](https://github.com/dotnet/corefx/commit/36eb70c) fix IDNA host name handling in proxy case, and add some IDNA tests
* [`[3b5eb94]`](https://github.com/dotnet/corefx/commit/3b5eb94) make dribble test slightly more useful
* [`[c512fae]`](https://github.com/dotnet/corefx/commit/c512fae) fix issue that was causing duplicate test execution
* [`[d266d5b]`](https://github.com/dotnet/corefx/commit/d266d5b) Move from preview1 to preview2 in master branches
* [`[984bf08]`](https://github.com/dotnet/corefx/commit/984bf08) Add DisableWarning parameter in the csc. (#25805)
* [`[fcd0e4f]`](https://github.com/dotnet/corefx/commit/fcd0e4f) replace $* with "$@" to properly preserve spaces in argumnents (#26404)
* [`[5111a66]`](https://github.com/dotnet/corefx/commit/5111a66) don't check for http/2.0 in response, since we will never see it
* [`[0628dda]`](https://github.com/dotnet/corefx/commit/0628dda) Fix System.Net.NetworkInformation.NetworkChange deadlock (#26259)
* [`[1a08ebe]`](https://github.com/dotnet/corefx/commit/1a08ebe) Add optional integer offset to OwnedMemory Pin (dotnet/coreclr#15946)
* [`[4e6c3c6]`](https://github.com/dotnet/corefx/commit/4e6c3c6) Delete FileSystem abstraction (#26473)
* [`[d24bf92]`](https://github.com/dotnet/corefx/commit/d24bf92) CharUnicodeInfo.GetUnicodeCategory(int codePoint) (dotnet/coreclr#15911)
* [`[ed786cf]`](https://github.com/dotnet/corefx/commit/ed786cf) Update issue-guide.md
* [`[8fb86c6]`](https://github.com/dotnet/corefx/commit/8fb86c6) Update issue-guide.md
* [`[83774e3]`](https://github.com/dotnet/corefx/commit/83774e3) Move platform-neutral part of TimeZone to shared CoreLib partition (#15926)
* [`[9f858d0]`](https://github.com/dotnet/corefx/commit/9f858d0) Enable ClientAndServer_OneOrBothUseDefault_Ok test (#26463)
* [`[ac70074]`](https://github.com/dotnet/corefx/commit/ac70074) Add MemoryExtensions Reverse API to get parity with array (#26381)
* [`[a4c639f]`](https://github.com/dotnet/corefx/commit/a4c639f) Fix spacing in System.Runtime ref to be consistent.
* [`[91a8331]`](https://github.com/dotnet/corefx/commit/91a8331) Put the code to get serializerPath into try/catch to catch any exception. (#26304)
* [`[b265a0f]`](https://github.com/dotnet/corefx/commit/b265a0f) No local repro for #23768, re-enabling test (#26399)
* [`[23d8f0c]`](https://github.com/dotnet/corefx/commit/23d8f0c) Make XSL tests log unexpected output (#26445)
* [`[aad3226]`](https://github.com/dotnet/corefx/commit/aad3226) Delete unused WinRT multiplexing file system (#26450)
* [`[e0e2401]`](https://github.com/dotnet/corefx/commit/e0e2401) Add string slicing extension methods. (#26427)
* [`[9ac1e71]`](https://github.com/dotnet/corefx/commit/9ac1e71) Minor Brotli fixes
* [`[f345a22]`](https://github.com/dotnet/corefx/commit/f345a22) Test: ignore specific WinHttpException on old Windows versions (#26428)
* [`[e03a84a]`](https://github.com/dotnet/corefx/commit/e03a84a) Update issue-guide.md
* [`[95882ec]`](https://github.com/dotnet/corefx/commit/95882ec) Add ability to enable ManagedHandler via runtime config (#26403)
* [`[aa808b7]`](https://github.com/dotnet/corefx/commit/aa808b7) Have S.L.Expressions accept conversions it incorrectly rejects. (#25768)
* [`[ce3fe5d]`](https://github.com/dotnet/corefx/commit/ce3fe5d) Fixing X509Certificate2Collection.Export on Unix with multiple certs and private key
* [`[61ce193]`](https://github.com/dotnet/corefx/commit/61ce193) Cache Invariant CompareInfo (dotnet/coreclr#15902)
* [`[62ba485]`](https://github.com/dotnet/corefx/commit/62ba485) Implement non-trailing named arguments in Microsoft.CSharp (#25819)
* [`[c3d264f]`](https://github.com/dotnet/corefx/commit/c3d264f) Do not throw IndexOutOfBounds when AM/PM designator is empty (#15904)
* [`[3542bcf]`](https://github.com/dotnet/corefx/commit/3542bcf) Fix bug with SslStream Read behavior.
* [`[70f41f9]`](https://github.com/dotnet/corefx/commit/70f41f9) Use ManagedWebSocket implementation everywhere except uap.
* [`[0af4e15]`](https://github.com/dotnet/corefx/commit/0af4e15) Make AsnWriter IDisposable
* [`[7882fbe]`](https://github.com/dotnet/corefx/commit/7882fbe) Don't capture AsyncLocals into MemoryCache timer (#26077)
* [`[eee5e5f]`](https://github.com/dotnet/corefx/commit/eee5e5f) Fix MulticasInterface SocketOption to work with IPv6 on Linux (#25544)
* [`[36d4c2c]`](https://github.com/dotnet/corefx/commit/36d4c2c) Implement private protected in Microsoft.CSharp (#25523)
* [`[9340e12]`](https://github.com/dotnet/corefx/commit/9340e12) Consolidate System.Memory code to shared folder (#26393)
* [`[b9b1045]`](https://github.com/dotnet/corefx/commit/b9b1045) Fix WebHeaderCollection mangles well-formed Set-Cookie headers containing expires attribute (#26143)
* [`[c8593a6]`](https://github.com/dotnet/corefx/commit/c8593a6) Disable Millisec test for all Unix (#26384)
* [`[5ea2021]`](https://github.com/dotnet/corefx/commit/5ea2021) Use Debug.Assert
* [`[9791680]`](https://github.com/dotnet/corefx/commit/9791680) Add System.Net.WebSocket.Protocol initial commit.
* [`[7a98b8e]`](https://github.com/dotnet/corefx/commit/7a98b8e) Upgrading the UAP TFM to vNext (#26371)
* [`[07e68c4]`](https://github.com/dotnet/corefx/commit/07e68c4) Adding threshold to the printed message
* [`[67d240e]`](https://github.com/dotnet/corefx/commit/67d240e) Expose RuntimeFeature.PortablePdb (#26387)
* [`[708e453]`](https://github.com/dotnet/corefx/commit/708e453) Move public StreamReader/Writer to CoreLib (dotnet/coreclr#15884)
* [`[903f52c]`](https://github.com/dotnet/corefx/commit/903f52c) Improve Span/ReadOnlySpan test coverage (#26342)
* [`[3625e3f]`](https://github.com/dotnet/corefx/commit/3625e3f) Update filetimes to nsec (dotnet/coreclr#15872)
* [`[789b735]`](https://github.com/dotnet/corefx/commit/789b735) Fix Microsoft.Diagnostics.Tracing.EventSource.Redist Mirroring (#26376)
* [`[f0f7921]`](https://github.com/dotnet/corefx/commit/f0f7921) Small fix to underlying CoreCLR support for new string slicing overloads (#15876)
* [`[2152449]`](https://github.com/dotnet/corefx/commit/2152449) Added Append(Stringbuilder,int,int) and Append(StringBuilder) overlaod apis (#15786)
* [`[cf191eb]`](https://github.com/dotnet/corefx/commit/cf191eb) SqlConnection timeout test is ported (#26306)
* [`[fe00858]`](https://github.com/dotnet/corefx/commit/fe00858) Add delegate flag to fix permissions when querying linked SQL Servers (#26270)
* [`[da8f8f8]`](https://github.com/dotnet/corefx/commit/da8f8f8) Keep LowLevelDictionary for CoreRT for now (dotnet/coreclr#15824)
* [`[4c2b189]`](https://github.com/dotnet/corefx/commit/4c2b189) Improve performance for Math.Abs (dotnet/coreclr#15823)
* [`[44938fa]`](https://github.com/dotnet/corefx/commit/44938fa) Fix Obsolete on ReadOnlySpan Equals and GetHashCode methods (#15820)
* [`[9020ae6]`](https://github.com/dotnet/corefx/commit/9020ae6) Underlying CoreCLR support for new string slicing overloads (#15811)
* [`[8a9979b]`](https://github.com/dotnet/corefx/commit/8a9979b) Move System.Globalization.CultureData to shared CoreLib partition (#15805)
* [`[5cfd3b5]`](https://github.com/dotnet/corefx/commit/5cfd3b5) Adds StringBuilder.Equals(ReadOnlySpan\<char>) Api (dotnet/coreclr#15759)
* [`[735b29c]`](https://github.com/dotnet/corefx/commit/735b29c) Move types to shared corelib partition (dotnet/coreclr#15768)
* [`[197679e]`](https://github.com/dotnet/corefx/commit/197679e) Simplify and unify EnumCalendars interop (dotnet/coreclr#15762)
* [`[5471a4b]`](https://github.com/dotnet/corefx/commit/5471a4b) AggregateException: Use StringBuilder.AppendFormat (dotnet/coreclr#15747)
* [`[4417591]`](https://github.com/dotnet/corefx/commit/4417591) Use string.Contains(char) instead of Contains(string) (#15740)
* [`[6fa7fad]`](https://github.com/dotnet/corefx/commit/6fa7fad) Adding EnsureCapacity implementation for Dictionary (dotnet/coreclr#15729)
* [`[df27e41]`](https://github.com/dotnet/corefx/commit/df27e41) Check for null in ReflectionTypeLoadException Message/ToString (#15711)
* [`[343de60]`](https://github.com/dotnet/corefx/commit/343de60) Use the message that the ReflectionTypeLoadException exception was initialized with (#15708)
* [`[8099491]`](https://github.com/dotnet/corefx/commit/8099491) Print Inner Exceptions in ReflectionTypeLoadException ToString (#15688)
* [`[0e80182]`](https://github.com/dotnet/corefx/commit/0e80182) Use Span to drop byte[1] allocations (dotnet/coreclr#15680)
* [`[06712a8]`](https://github.com/dotnet/corefx/commit/06712a8) Encoding: Don't alloc for zero length array (dotnet/coreclr#13794)
* [`[75d61f4]`](https://github.com/dotnet/corefx/commit/75d61f4) Make HandleRef fields private
* [`[6bc81fc]`](https://github.com/dotnet/corefx/commit/6bc81fc) Extending FormatException's message with datetime/format (#15635)
* [`[4fd0754]`](https://github.com/dotnet/corefx/commit/4fd0754) Convert uses of the Dangerous APIs to use MemoryMarshal.GetReference (#15532)
* [`[4b1aef1]`](https://github.com/dotnet/corefx/commit/4b1aef1) ReadOnlySpan GetReference returns ref instead of ref readonly (#15548)
* [`[fbe6cc5]`](https://github.com/dotnet/corefx/commit/fbe6cc5) Make EventArgs base class serializable (dotnet/coreclr#15541)
* [`[8b6e8c9]`](https://github.com/dotnet/corefx/commit/8b6e8c9) Change ReadOnlySpan indexer to return ref readonly (dotnet/coreclr#14727)
* [`[2135a62]`](https://github.com/dotnet/corefx/commit/2135a62) Fixing build by casting IntPtr to nint. (dotnet/coreclr#15530)
* [`[a9155cf]`](https://github.com/dotnet/corefx/commit/a9155cf) Adding Unsafe API Add nuint that is used by SpanHelpers (#15527)
* [`[bfdea3a]`](https://github.com/dotnet/corefx/commit/bfdea3a) Adding Unsafe APIs that are used by System.Memory (dotnet/coreclr#15497)
* [`[b3b328c]`](https://github.com/dotnet/corefx/commit/b3b328c) Dictionary Initalize CQ (dotnet/coreclr#15461)
* [`[b96d6ea]`](https://github.com/dotnet/corefx/commit/b96d6ea) Improve Dict.Clear CQ (dotnet/coreclr#15459)
* [`[14acef4]`](https://github.com/dotnet/corefx/commit/14acef4) Add scope prefix for class vars
* [`[f4a9b19]`](https://github.com/dotnet/corefx/commit/f4a9b19) Add optional integer offset to OwnedMemory Pin (dotnet/coreclr#15410)
* [`[279567b]`](https://github.com/dotnet/corefx/commit/279567b) Add GetReference and TryGetArray to MemoryMarshal (dotnet/coreclr#15417)
* [`[0f77d19]`](https://github.com/dotnet/corefx/commit/0f77d19) new intrinsic type support (dotnet/coreclr#15340)
* [`[e9e141d]`](https://github.com/dotnet/corefx/commit/e9e141d) Null Check added to GetFullPath Function in Unix (dotnet/coreclr#15399)
* [`[9a344f0]`](https://github.com/dotnet/corefx/commit/9a344f0) Have a Type.IsConvertible property. (dotnet/coreclr#15365)
* [`[a236b96]`](https://github.com/dotnet/corefx/commit/a236b96) Improve throughput of String.Split(char / char[], ...) (#15322)
* [`[95957e5]`](https://github.com/dotnet/corefx/commit/95957e5) Switch new TryParse* and TryFormat methods to use span-based format (#15238)
* [`[9cfba2f]`](https://github.com/dotnet/corefx/commit/9cfba2f) Sort the Action/Func delegates (dotnet/coreclr#15222)
* [`[d57f564]`](https://github.com/dotnet/corefx/commit/d57f564) Use string.Create in BitConverter.ToString(byte[]) (dotnet/coreclr#15218)
* [`[7bd51ca]`](https://github.com/dotnet/corefx/commit/7bd51ca) added keu value to key not found exception (dotnet/coreclr#15201)
* [`[205dbef]`](https://github.com/dotnet/corefx/commit/205dbef) Implementation for new string.contains api (dotnet/coreclr#15180)
* [`[8497ffe]`](https://github.com/dotnet/corefx/commit/8497ffe) Move TextInfo to shared CoreLib partition (dotnet/coreclr#15195)
* [`[55185c5]`](https://github.com/dotnet/corefx/commit/55185c5) Fix namespaces and ThrowHelper
* [`[5df0c65]`](https://github.com/dotnet/corefx/commit/5df0c65) Move Nullable and string normalization to shared CoreLib partition (#15184)
* [`[75cc630]`](https://github.com/dotnet/corefx/commit/75cc630) StringBuilder: Use Decimal.TryFormat (dotnet/coreclr#15170)
* [`[c752add]`](https://github.com/dotnet/corefx/commit/c752add) Cosmetic fixes after move to shared partition
* [`[7f41810]`](https://github.com/dotnet/corefx/commit/7f41810) Fix unused field warnings
* [`[199fd24]`](https://github.com/dotnet/corefx/commit/199fd24) Move ArraySegment and a few other files to shared CoreLib partition (#15158)
* [`[3ff0d8c]`](https://github.com/dotnet/corefx/commit/3ff0d8c) Add Decimal.TryFormat span-based method (dotnet/coreclr#15145)
* [`[389d7ba]`](https://github.com/dotnet/corefx/commit/389d7ba) Delete unused leftovers from binary serialization (dotnet/coreclr#15140)
* [`[72e1a1a]`](https://github.com/dotnet/corefx/commit/72e1a1a) Move SafeBuffer and a few other files to shared CoreLib partition (#15141)
* [`[1848bbd]`](https://github.com/dotnet/corefx/commit/1848bbd) Move UnmanagedMemoryAccessor to shared CoreLib partition (#15137)
* [`[a8724a2]`](https://github.com/dotnet/corefx/commit/a8724a2) Version: Use int.TryFormat & StringBuilder.Append(int) (#15132)
* [`[258e971]`](https://github.com/dotnet/corefx/commit/258e971) Reduce allocations in StringBuilder.AppendFormat for primitive types (#15110)
* [`[70766ff]`](https://github.com/dotnet/corefx/commit/70766ff) Move MemoryStream to shared CoreLib partition (dotnet/coreclr#15116)
* [`[af15a20]`](https://github.com/dotnet/corefx/commit/af15a20) Move TaskToApm to shared CoreLib partition (dotnet/coreclr#15113)
* [`[7508f81]`](https://github.com/dotnet/corefx/commit/7508f81) Delete FriendAccessAllowedAttribute and associated dead code (#15101)
* [`[36deef2]`](https://github.com/dotnet/corefx/commit/36deef2) Move debugger attributes to shared partition (dotnet/coreclr#15100)
* [`[23ee864]`](https://github.com/dotnet/corefx/commit/23ee864) Fix up ConfiguredValueTaskAwaitable signature for new compiler checks (#15092)
* [`[3866bb6]`](https://github.com/dotnet/corefx/commit/3866bb6) HashCode based on xxHash32 (dotnet/coreclr#14863)
* [`[a5c36aa]`](https://github.com/dotnet/corefx/commit/a5c36aa) Adding null check for implicit cast from array/arraysegment to Span (#15044)
* [`[657fd9d]`](https://github.com/dotnet/corefx/commit/657fd9d) Add object null checks in Memory\<T> APIs to support default (#14816)
* [`[f3e3d7b]`](https://github.com/dotnet/corefx/commit/f3e3d7b) Fix CppCodeGen break with latest XCode (dotnet/corert#4926)
* [`[d87694a]`](https://github.com/dotnet/corefx/commit/d87694a) Adding Memory CopyTo APIs (dotnet/coreclr#15010)
* [`[493e074]`](https://github.com/dotnet/corefx/commit/493e074) Added UnixEpoch to DateTime and DateTimeOffset. (dotnet/coreclr#14648)
* [`[460a59d]`](https://github.com/dotnet/corefx/commit/460a59d) Add foreach support to Span\<T> and ReadOnlySpan\<T> (dotnet/coreclr#14922)
* [`[4184f4e]`](https://github.com/dotnet/corefx/commit/4184f4e) Adding placeholder Span debugger proxy (dotnet/coreclr#14749)
* [`[49d3f0c]`](https://github.com/dotnet/corefx/commit/49d3f0c) Add missing license header (dotnet/coreclr#14936)
* [`[ae753cb]`](https://github.com/dotnet/corefx/commit/ae753cb) Temporarily add back old TryParse signatures (dotnet/coreclr#14893)
* [`[7848223]`](https://github.com/dotnet/corefx/commit/7848223) Fix TryParse overloads using optional arguments (dotnet/coreclr#14877)
* [`[056bca8]`](https://github.com/dotnet/corefx/commit/056bca8) Mark applicable structs as readonly (dotnet/coreclr#14789)
* [`[b4fb319]`](https://github.com/dotnet/corefx/commit/b4fb319) Move Dictionary to shared CoreLib partition (dotnet/coreclr#14795)
* [`[6c8e133]`](https://github.com/dotnet/corefx/commit/6c8e133) Change leading bracked to char as well
* [`[c51b829]`](https://github.com/dotnet/corefx/commit/c51b829) Move System.Tuple to shared CoreLib partition (dotnet/coreclr#14762)
* [`[53b4d9e]`](https://github.com/dotnet/corefx/commit/53b4d9e) Update code in AwaitUnsafeOnCompleted to use interface matching
* [`[f236670]`](https://github.com/dotnet/corefx/commit/f236670) Fix for issue EventSource MultiEnable bug (dotnet/coreclr#14729)
* [`[d187e30]`](https://github.com/dotnet/corefx/commit/d187e30) Make EventSourcException serializable in corert scenarios (#14716)
* [`[f28cc64]`](https://github.com/dotnet/corefx/commit/f28cc64) Port EventSource Nuget Package Changes (dotnet/coreclr#14669)
* [`[f5cb4dd]`](https://github.com/dotnet/corefx/commit/f5cb4dd) Marking Memory struct as readonly, fixing corefx#23809 (#14684)
* [`[4aee110]`](https://github.com/dotnet/corefx/commit/4aee110) Search/replace _DEBUG => DEBUG
* [`[acbe9f5]`](https://github.com/dotnet/corefx/commit/acbe9f5) Search/replace Debug.Assert(false, => Debug.Fail(
* [`[34875ae]`](https://github.com/dotnet/corefx/commit/34875ae) Hide post exception stack frames (dotnet/coreclr#14652)
* [`[a26ce25]`](https://github.com/dotnet/corefx/commit/a26ce25) Rename MemoryHandle PinnedPointer to Pointer and add property HasPointer. (#14604)
* [`[ecc439e]`](https://github.com/dotnet/corefx/commit/ecc439e) Fix BinaryWriter/Reader span parameter names (dotnet/coreclr#14577)
* [`[1411fa1]`](https://github.com/dotnet/corefx/commit/1411fa1) Delete contract annotations (dotnet/corert#4722) (dotnet/coreclr#14507)
* [`[5c6d86e]`](https://github.com/dotnet/corefx/commit/5c6d86e) Add CompareInfo.Invariant.cs to shared corelib partition
* [`[29439fe]`](https://github.com/dotnet/corefx/commit/29439fe) Move CompareInfo.cs to shared corelib partition (dotnet/coreclr#14407)
* [`[ebf916f]`](https://github.com/dotnet/corefx/commit/ebf916f) Fix new deadlock possibility in ReaderWriterLockSlim from a recent change (#14337)
* [`[6cd4651]`](https://github.com/dotnet/corefx/commit/6cd4651) Move String.Searching.cs to shared CoreLib partition (dotnet/corert#4673)
* [`[df9dce8]`](https://github.com/dotnet/corefx/commit/df9dce8) Optimize Memory\<T> to ReadOnlyMemory\<T> cast (dotnet/coreclr#14309)
* [`[64c04e2]`](https://github.com/dotnet/corefx/commit/64c04e2) Enable CLR Thread Pool via a MSBuild flag (default enabled on Unix)
* [`[be089bc]`](https://github.com/dotnet/corefx/commit/be089bc) Fixing Retain to return MemoryHandle with correct PinnedPointer (#14248)
* [`[55a68df]`](https://github.com/dotnet/corefx/commit/55a68df) Adding {RO}Memory\<T> debugger view (dotnet/coreclr#14130)
* [`[16326cf]`](https://github.com/dotnet/corefx/commit/16326cf) Fix modf and fmod casing for consistency
* [`[735af56]`](https://github.com/dotnet/corefx/commit/735af56) Replace Contract.Assumes and Contract.Assert with Debug.Assert/Debug.Fail (#14136)
* [`[e76bba5]`](https://github.com/dotnet/corefx/commit/e76bba5) Moving parts of `System.Math` and `System.MathF` to be shared with CoreRT. (#14119)
* [`[71d2a0e]`](https://github.com/dotnet/corefx/commit/71d2a0e) FileStream should not truncate files when opening fails. Fixes dotnet/corefx#24081 (#14043)
* [`[60364f0]`](https://github.com/dotnet/corefx/commit/60364f0) Avoid throwing in the globalization managed callbacks (#11454)
* [`[71494ae]`](https://github.com/dotnet/corefx/commit/71494ae) Move more files to shared CoreLib partition (dotnet/coreclr#11429)
* [`[cf38f28]`](https://github.com/dotnet/corefx/commit/cf38f28) Switch over to shared Interop.Globalization.cs on Windows (#3528)
* [`[8f12234]`](https://github.com/dotnet/corefx/commit/8f12234) Path.GetDirectoryName() throw exception when path is empty or has only white spaces (#11403)
* [`[4ede0d2]`](https://github.com/dotnet/corefx/commit/4ede0d2) Move UnmanagedMemoryStream and related types to shared CoreLib partition (#11409)
* [`[125c608]`](https://github.com/dotnet/corefx/commit/125c608) System.IO.Path.GetPathRoot string.Empty or whitespace character string should throw ArgumentException (#11387)
* [`[545a91b]`](https://github.com/dotnet/corefx/commit/545a91b) Adding System\Runtime\CompilerServices\IsByRefLikeAttribute type (#11369)
* [`[ff220e9]`](https://github.com/dotnet/corefx/commit/ff220e9) Implement Type.IsTypeDefinition property on CoreCLR (dotnet/coreclr#11355)
* [`[2d434fa]`](https://github.com/dotnet/corefx/commit/2d434fa) Enable Marshal.SecureStringToBSTR and Marshal.ZeroFreeBSTR on Unix (#11234)
* [`[aaf99f8]`](https://github.com/dotnet/corefx/commit/aaf99f8) Move a few more files to shared CoreLib partition
* [`[1ae42a8]`](https://github.com/dotnet/corefx/commit/1ae42a8) Rename internal field of primitive type structs and make it private (#11312)
* [`[c5e56cd]`](https://github.com/dotnet/corefx/commit/c5e56cd) Move DllNotFoundException, EntryPointNotFoundException to CoreLib (#3415)
* [`[bc56d4f]`](https://github.com/dotnet/corefx/commit/bc56d4f) Mark CharEnumerator as [Serializable] (dotnet/coreclr#11124)
* [`[5bc67c4]`](https://github.com/dotnet/corefx/commit/5bc67c4) Update StringBuilder.AppendJoin to approved API (dotnet/coreclr#11059)
* [`[3c613b8]`](https://github.com/dotnet/corefx/commit/3c613b8) Rename attribute to IsReadOnlyAttribute (dotnet/coreclr#11026)
* [`[5fd1c97]`](https://github.com/dotnet/corefx/commit/5fd1c97) Add Span and ReadOnlySpan from CoreCLR
* [`[4cf57a7]`](https://github.com/dotnet/corefx/commit/4cf57a7) Move Span/ReadOnlySpan to shared CoreLib partition (dotnet/coreclr#10988)
* [`[b6e9c9e]`](https://github.com/dotnet/corefx/commit/b6e9c9e) Delete moved files
* [`[db4bbbf]`](https://github.com/dotnet/corefx/commit/db4bbbf) Move files to shared CoreLib partition (dotnet/coreclr#10885)
* [`[cd56cdd]`](https://github.com/dotnet/corefx/commit/cd56cdd) Move a few more types from CoreFX to CoreLib (dotnet/coreclr#10893)
* [`[e5bfbc6]`](https://github.com/dotnet/corefx/commit/e5bfbc6) Add back UnmanagedType.LPUTF8Str (dotnet/coreclr#10859)
* [`[af0f5ff]`](https://github.com/dotnet/corefx/commit/af0f5ff) CoreLib Build System portability updates (dotnet/coreclr#10839)
* [`[75d5bff]`](https://github.com/dotnet/corefx/commit/75d5bff) Add empty System.Runtime.CompilerServices.RuntimeFeature.IsSupported() API (#10779)
* [`[9997c2b]`](https://github.com/dotnet/corefx/commit/9997c2b) Get rid of "#if FEATURE_RANDOMIZED_STRING_HASHING" in shared partition. (#10851)
* [`[f7df8b4]`](https://github.com/dotnet/corefx/commit/f7df8b4) Move files to shared CoreLib partition (dotnet/coreclr#10837)
* [`[f9faf5b]`](https://github.com/dotnet/corefx/commit/f9faf5b) Move files to shared CoreLib partition (dotnet/coreclr#10830)
* [`[b5582af]`](https://github.com/dotnet/corefx/commit/b5582af) Find & replace Exception.SetErrorCode with Exception.HResult setter (#10810)
* [`[dd85ad6]`](https://github.com/dotnet/corefx/commit/dd85ad6) Add System.Runtime.CompilerServices.ReadOnlyAttribute (#10777)
* [`[abda906]`](https://github.com/dotnet/corefx/commit/abda906) Strip out unused reg code. (dotnet/coreclr#10741)
* [`[521cc84]`](https://github.com/dotnet/corefx/commit/521cc84) Move public ThreadAbortException back to CoreLib (dotnet/coreclr#10801)
* [`[86c8e9a]`](https://github.com/dotnet/corefx/commit/86c8e9a) Fix registry name enumeration (dotnet/coreclr#10711)
* [`[1f2d615]`](https://github.com/dotnet/corefx/commit/1f2d615) Move identical Globalization files to shared partition
* [`[dfb202f]`](https://github.com/dotnet/corefx/commit/dfb202f) Move identical files to shared partition
* [`[43076ee]`](https://github.com/dotnet/corefx/commit/43076ee) Move identical Interop files to shared partition
* [`[049a799]`](https://github.com/dotnet/corefx/commit/049a799) NS2.0 Inject more missing types into CoreRT by sharing them. (#10613)
* [`[4bbf3fa]`](https://github.com/dotnet/corefx/commit/4bbf3fa) Add shared directory README (dotnet/coreclr#10535)
* [`[5702711]`](https://github.com/dotnet/corefx/commit/5702711) Move Pointer.cs to the shared partition. (dotnet/coreclr#10499)
* [`[9c2687f]`](https://github.com/dotnet/corefx/commit/9c2687f) Move DateTime to shared partition (dotnet/coreclr#10460)
* [`[3f48178]`](https://github.com/dotnet/corefx/commit/3f48178) Fixed m_ prefixes in a few files from shared partition (#10473)
* [`[5b1b639]`](https://github.com/dotnet/corefx/commit/5b1b639) Sort entries in shared project (dotnet/coreclr#10465)
* [`[9b837f1]`](https://github.com/dotnet/corefx/commit/9b837f1) Add PNSE messages (dotnet/coreclr#10440)
* [`[bb797ab]`](https://github.com/dotnet/corefx/commit/bb797ab) Move StringBuilder to shared partition (dotnet/coreclr#10357)
* [`[c24d4b7]`](https://github.com/dotnet/corefx/commit/c24d4b7) Migrate the Reflection serialization holders to the shared partition. (#10429)
* [`[d2a3012]`](https://github.com/dotnet/corefx/commit/d2a3012) Move IReflect.cs to shared partition. (dotnet/coreclr#10415)
* [`[6b1a317]`](https://github.com/dotnet/corefx/commit/6b1a317) Move Type.IsSerializable and Type.DefaultBinder to shared file. (#10395)
* [`[a3a3a9a]`](https://github.com/dotnet/corefx/commit/a3a3a9a) Move DefaultBinder.cs to the shared partition. (dotnet/coreclr#10355)
* [`[d998a4a]`](https://github.com/dotnet/corefx/commit/d998a4a) Switch coreclr corelib to use resx (dotnet/coreclr#10372)
* [`[8337cc7]`](https://github.com/dotnet/corefx/commit/8337cc7) Switch coreclr corelib to use resx (dotnet/coreclr#10268)
* [`[10fa64a]`](https://github.com/dotnet/corefx/commit/10fa64a) System.IO.Path.IsPathRooted does not check if valid drive letter on Windows (#10323)
* [`[bcddcbc]`](https://github.com/dotnet/corefx/commit/bcddcbc) Move ParameterInfo.cs and Assembly.cs to shared partition. (#10270)
* [`[2dca355]`](https://github.com/dotnet/corefx/commit/2dca355) FileStream.Unix: open with CLOEXEC unless FileShare.Inheritable set (#10251)
* [`[c6e4737]`](https://github.com/dotnet/corefx/commit/c6e4737) Move the MemberInfo-derived Info classes to the shared partition. (#10236)
* [`[536a1c1]`](https://github.com/dotnet/corefx/commit/536a1c1) Fix Convert.FromBase64CharArray with empty array (dotnet/coreclr#10224)
* [`[4b67bf4]`](https://github.com/dotnet/corefx/commit/4b67bf4) Migrate MethodBase.cs over to the shared partition. (dotnet/coreclr#10202)
* [`[3a72414]`](https://github.com/dotnet/corefx/commit/3a72414) Move System.Convert code to shared partition (dotnet/coreclr#10178)
* [`[47c7608]`](https://github.com/dotnet/corefx/commit/47c7608) Replace MemberInfo.cs with the CoreRt version and move to shared partition. (#10167)
* [`[65d1eac]`](https://github.com/dotnet/corefx/commit/65d1eac) Move more types into the shared partition. (dotnet/coreclr#10068)
* [`[6197fdf]`](https://github.com/dotnet/corefx/commit/6197fdf) Move System.Security attributes to shared partition. (dotnet/coreclr#10036)
* [`[8e68f72]`](https://github.com/dotnet/corefx/commit/8e68f72) Move two sharable classes into the shared partition. (dotnet/coreclr#10009)
* [`[08407ae]`](https://github.com/dotnet/corefx/commit/08407ae) Add shared changes from corert (dotnet/coreclr#10010)
* [`[4a2d941]`](https://github.com/dotnet/corefx/commit/4a2d941) Move System.Lazy to shared CoreLib partition (dotnet/coreclr#9955)
* [`[40afae6]`](https://github.com/dotnet/corefx/commit/40afae6) Clean up Normalization code (dotnet/coreclr#9941)
* [`[71075d7]`](https://github.com/dotnet/corefx/commit/71075d7) Move files that are identical with CoreRT under mscorlib\shared (#9861)
* [`[ffd5c35]`](https://github.com/dotnet/corefx/commit/ffd5c35) Move Used interop sources into shared folder (dotnet/coreclr#9840)
* [`[878e480]`](https://github.com/dotnet/corefx/commit/878e480) Move S.Buffers and S.IO sources shared with corert into shared folder (#9778)
* [`[b601897]`](https://github.com/dotnet/corefx/commit/b601897) Add arm64 build for uapaot
* [`[ef03e59]`](https://github.com/dotnet/corefx/commit/ef03e59) Corrected DataTable deserialization to use invariant culture for schema properties (#26298)
* [`[04e2be2]`](https://github.com/dotnet/corefx/commit/04e2be2) Disable Msec test on macOS (#26350)
* [`[d75610e]`](https://github.com/dotnet/corefx/commit/d75610e) Add nanosecond granularity to Unix filesystem time reads (#26176)
* [`[6671bee]`](https://github.com/dotnet/corefx/commit/6671bee) Add regression test for GetHashCode of default handles (#26202)
* [`[8f3fbd7]`](https://github.com/dotnet/corefx/commit/8f3fbd7) Disabled eventlog tests on nano server (#26339)
* [`[a801103]`](https://github.com/dotnet/corefx/commit/a801103) IPAddress: Use BinaryPrimitives.ReverseEndianness (#26329)
* [`[ff29190]`](https://github.com/dotnet/corefx/commit/ff29190) Fix SkipWhile tests that are accidentally duplicates (#26318)
* [`[12e6bb4]`](https://github.com/dotnet/corefx/commit/12e6bb4) Improve performance of ReverseEndianness
* [`[f401784]`](https://github.com/dotnet/corefx/commit/f401784) Writes to Service's Eventlog when it is run. (#26260)
* [`[ad8b5c7]`](https://github.com/dotnet/corefx/commit/ad8b5c7) Update System.Memory ref based on the netstandard implementation
* [`[4ba7514]`](https://github.com/dotnet/corefx/commit/4ba7514) Normalize System.Memory ref
* [`[a8d34fe]`](https://github.com/dotnet/corefx/commit/a8d34fe) Re-apply Changes in #25562 on if/else fix. (#26285)
* [`[2e97d43]`](https://github.com/dotnet/corefx/commit/2e97d43) Update references assemblies to include private fields for structs
* [`[ca691ae]`](https://github.com/dotnet/corefx/commit/ca691ae) Rename System.Runtime.Intrinsics.X86 to System.Runtime.Intrinsics.
* [`[6ef9545]`](https://github.com/dotnet/corefx/commit/6ef9545) Teach the tool to understand ByReference\<T> contains a reference
* [`[1cdbd6b]`](https://github.com/dotnet/corefx/commit/1cdbd6b) Cleaner implementation of #25798
* [`[7e39129]`](https://github.com/dotnet/corefx/commit/7e39129) Update System.Runtime ref primitive types to contain field of same type
* [`[cc4cc40]`](https://github.com/dotnet/corefx/commit/cc4cc40) Fill some test gaps in S.L.Expression's LambdaCompiler (#25909)
* [`[a3b2e9b]`](https://github.com/dotnet/corefx/commit/a3b2e9b) Add Brotli source
* [`[1bc1fa8]`](https://github.com/dotnet/corefx/commit/1bc1fa8) Add packaging and build files for Brotli
* [`[49033c0]`](https://github.com/dotnet/corefx/commit/49033c0) Add Brotli to existing native Compression builds
* [`[4514f6a]`](https://github.com/dotnet/corefx/commit/4514f6a) Add support for Arm64 PE files to System.Reflection.Metadata (#26243)
* [`[c58e40f]`](https://github.com/dotnet/corefx/commit/c58e40f) Fix ReadOnlySpan obsolete message to reference ReadOnlySpan instead of Span
* [`[9288c49]`](https://github.com/dotnet/corefx/commit/9288c49) Update struct private field types to not count unsafe pointers as object
* [`[14bf878]`](https://github.com/dotnet/corefx/commit/14bf878) Update benchmark sample code
* [`[8271f8d]`](https://github.com/dotnet/corefx/commit/8271f8d) Fixing timing issue in 26258 (#26262)
* [`[a2d4a32]`](https://github.com/dotnet/corefx/commit/a2d4a32) Refresh System.Runtime ref from System.Private.CoreLib in Coreclr
* [`[7931769]`](https://github.com/dotnet/corefx/commit/7931769) Add Span SequenceCompareTo extension method (#26232)
* [`[3e55c1c]`](https://github.com/dotnet/corefx/commit/3e55c1c) Update documentation for netcoreapp2.1
* [`[0f03d11]`](https://github.com/dotnet/corefx/commit/0f03d11) Dispose of process streams if they are not referenced by the user. (#26204)
* [`[697e2b9]`](https://github.com/dotnet/corefx/commit/697e2b9) Harden hashing in Xml NameTable (#26241)
* [`[b542758]`](https://github.com/dotnet/corefx/commit/b542758) Fix for SqlConnection failure when having multiple concurrent users (#26200)
* [`[295af99]`](https://github.com/dotnet/corefx/commit/295af99) Fix Outloop Directory Services Tests (#26227)
* [`[b032565]`](https://github.com/dotnet/corefx/commit/b032565) Move XmlSerializer CodeGen from SGen to S.P.Xml (#26169)
* [`[d576779]`](https://github.com/dotnet/corefx/commit/d576779) Update Reflection area owners
* [`[f8f075b]`](https://github.com/dotnet/corefx/commit/f8f075b) Port Google Brotli C sources
* [`[683ab4e]`](https://github.com/dotnet/corefx/commit/683ab4e) Fix ServiceController tests (#26208)
* [`[c745236]`](https://github.com/dotnet/corefx/commit/c745236) Use AllowRenegotiation with default true.
* [`[baf4a44]`](https://github.com/dotnet/corefx/commit/baf4a44) Pass manifest details to PushToBlobFeed (#26192)
* [`[9828cc1]`](https://github.com/dotnet/corefx/commit/9828cc1) Follow up on #25738 (#26196)
* [`[808390e]`](https://github.com/dotnet/corefx/commit/808390e) Change assert to inrange test.
* [`[8a65cff]`](https://github.com/dotnet/corefx/commit/8a65cff) Rename AllowRenegotiation to DisableRenegotiation.
* [`[5e3e743]`](https://github.com/dotnet/corefx/commit/5e3e743) Adding exception for the write, removing the assignment of retVal
* [`[42bdcb7]`](https://github.com/dotnet/corefx/commit/42bdcb7) Implementing ItemRef API Proposal (C# 7.2 constructs to S.C.I) (#25738)
* [`[783a141]`](https://github.com/dotnet/corefx/commit/783a141) Implement AllowRenegotiation.
* [`[8530d62]`](https://github.com/dotnet/corefx/commit/8530d62) Make assert condition more generic.
* [`[c2334ed]`](https://github.com/dotnet/corefx/commit/c2334ed) Fix uapaot build issues for System.Runtime
* [`[a822fbf]`](https://github.com/dotnet/corefx/commit/a822fbf) ConfiguredValueTaskAwaiter and ValueTaskAwaiter cannot be readonly in ref
* [`[b113b13]`](https://github.com/dotnet/corefx/commit/b113b13) Normalize System.Runtime ref file with latest genapi output
* [`[e116b94]`](https://github.com/dotnet/corefx/commit/e116b94) Fix readonly/ref ApiCompat issues found with new compat rules
* [`[7c6e8f4]`](https://github.com/dotnet/corefx/commit/7c6e8f4) Fix ReflectionTypeLoadExceptionTests (#26166)
* [`[9c66dd0]`](https://github.com/dotnet/corefx/commit/9c66dd0) Fix uwp build error.
* [`[7360e0a]`](https://github.com/dotnet/corefx/commit/7360e0a) Update xUnit Performance Api version to latest (#26140)
* [`[e2303e9]`](https://github.com/dotnet/corefx/commit/e2303e9) Update byref of custom S.L.Expressions convert method in interpreter (#25836)
* [`[cfcef49]`](https://github.com/dotnet/corefx/commit/cfcef49) Microsoft.CSharp: Set temporary unchecked context correctly. (#25825)
* [`[eb2025d]`](https://github.com/dotnet/corefx/commit/eb2025d) Add an empty dependency group for net45 to DataFlow package
* [`[8361a8a]`](https://github.com/dotnet/corefx/commit/8361a8a) Fix bug to make FinishRead behave as before.
* [`[8e4a84a]`](https://github.com/dotnet/corefx/commit/8e4a84a) add finally
* [`[a1d4a7a]`](https://github.com/dotnet/corefx/commit/a1d4a7a) Add ReflectionTypeLoadException tests
* [`[c7f8ac7]`](https://github.com/dotnet/corefx/commit/c7f8ac7) Add ReflectionTypeLoadException tests
* [`[a50e974]`](https://github.com/dotnet/corefx/commit/a50e974) "Don't directly throw Exception" System.Threading.Tasks.Dataflow (#26052)
* [`[4350f2d]`](https://github.com/dotnet/corefx/commit/4350f2d) Enable BeginExecuteNonQuery functions in .NET Core (#26016)
* [`[5e9bd3a]`](https://github.com/dotnet/corefx/commit/5e9bd3a) Fix rounding edge-case behavior in Uf8Parser.ParseDecimal (#26151)
* [`[e7f53c5]`](https://github.com/dotnet/corefx/commit/e7f53c5) WMI: PNSE requesting .NET Fx update if native dll too old (#26137)
* [`[4edf390]`](https://github.com/dotnet/corefx/commit/4edf390) Add default PB_AssetRootUrl for isolated builds (#26141)
* [`[4794098]`](https://github.com/dotnet/corefx/commit/4794098) Make TestService log deletion robust (#26136)
* [`[69016a8]`](https://github.com/dotnet/corefx/commit/69016a8) Make init-tools.sh work against a mounted Windows drive (#25882)
* [`[085e8d0]`](https://github.com/dotnet/corefx/commit/085e8d0) reenable ssl tests
* [`[9be6ebd]`](https://github.com/dotnet/corefx/commit/9be6ebd) Don't use FileStream in FileVersionInfo test for temp .dll (#26134)
* [`[f90aa66]`](https://github.com/dotnet/corefx/commit/f90aa66) Process info standard input encoding (#25990)
* [`[3d2ca8c]`](https://github.com/dotnet/corefx/commit/3d2ca8c) Don't change SIGINT/SIGQUIT handling when they are set to SIG_IGN (#25753)
* [`[d425f86]`](https://github.com/dotnet/corefx/commit/d425f86) Don't capture AsyncLocals into HttpConnectionPools timer (#26068)
* [`[d7dd6a4]`](https://github.com/dotnet/corefx/commit/d7dd6a4) Throw ArgumentException for non-absolute path in GetVersionInfo (#25978)
* [`[7c8830d]`](https://github.com/dotnet/corefx/commit/7c8830d) Fix Base64Stream encodes the last byte twice and corrupts data (#26119)
* [`[df4c8f0]`](https://github.com/dotnet/corefx/commit/df4c8f0) Add cert thumprint methods which accept a HashAlgorithmName
* [`[ca9de5b]`](https://github.com/dotnet/corefx/commit/ca9de5b) Show example to set invariant globalization in xml (#26110)
* [`[a098770]`](https://github.com/dotnet/corefx/commit/a098770) "Don't directly throw Exception" System.IO.FileSystem.AccessControl (#25696)
* [`[328fdcc]`](https://github.com/dotnet/corefx/commit/328fdcc) Increase code coverage for System.Net.Security (#26044)
* [`[6863fc4]`](https://github.com/dotnet/corefx/commit/6863fc4) Move index check inside update operation
* [`[dff5efc]`](https://github.com/dotnet/corefx/commit/dff5efc) Made tests only apply to netcoreapp
* [`[e548aec]`](https://github.com/dotnet/corefx/commit/e548aec) lldb install link
* [`[fc20e50]`](https://github.com/dotnet/corefx/commit/fc20e50) Show how to find libsosplugin.so
* [`[0a131dd]`](https://github.com/dotnet/corefx/commit/0a131dd) Change PlatformDetection.GetFrameworkVersion() to use registry key value instead of minor build number (#26094)
* [`[270be00]`](https://github.com/dotnet/corefx/commit/270be00) "Don't directly throw Exception" System.Private.Xml (#25975)
* [`[a011ef1]`](https://github.com/dotnet/corefx/commit/a011ef1) Updating the System.Runtime.Intrinsics.X86 ref assembly to always use `throw null;`
* [`[6e80c3a]`](https://github.com/dotnet/corefx/commit/6e80c3a) Adding scalar hardware intrinsics for x86
* [`[48e7c5d]`](https://github.com/dotnet/corefx/commit/48e7c5d) Make Span IndexOfAny a generic method with special case for byte (#25895)
* [`[68ad802]`](https://github.com/dotnet/corefx/commit/68ad802) Add missing install statement (#26090)
* [`[6ff22ab]`](https://github.com/dotnet/corefx/commit/6ff22ab) reenable operation cache
* [`[0101324]`](https://github.com/dotnet/corefx/commit/0101324) "Don't directly throw Exception" System.ComponentModel.TypeConverter (#26050)
* [`[baa9ed4]`](https://github.com/dotnet/corefx/commit/baa9ed4) Fix invalid JSON (#26088)
* [`[3dc80d2]`](https://github.com/dotnet/corefx/commit/3dc80d2) Fix wrong resource string used for Content-Length < 0 exception (#26080)
* [`[531023d]`](https://github.com/dotnet/corefx/commit/531023d) Updating the Odbc setup instructions (#26062)
* [`[6cb23ac]`](https://github.com/dotnet/corefx/commit/6cb23ac) Ignore placeholder build configurations in build all configurations targets (#25831)
* [`[d67255e]`](https://github.com/dotnet/corefx/commit/d67255e) Added functional tests.
* [`[e5da05d]`](https://github.com/dotnet/corefx/commit/e5da05d) Add license headers. (#26009)
* [`[17350bf]`](https://github.com/dotnet/corefx/commit/17350bf) Updated reference folder
* [`[8f527bf]`](https://github.com/dotnet/corefx/commit/8f527bf) Added native support for the HTTP PATCH verb.
* [`[38f613f]`](https://github.com/dotnet/corefx/commit/38f613f) Allow bidirectional control characters in System.Uri (#26022)
* [`[ec22edc]`](https://github.com/dotnet/corefx/commit/ec22edc) Share as much Bitmap code with Windows as possible (#25922)
* [`[40cbd56]`](https://github.com/dotnet/corefx/commit/40cbd56) Convert uses of the Dangerous APIs to use MemoryMarshal.GetReference (#25936)
* [`[e29f0dc]`](https://github.com/dotnet/corefx/commit/e29f0dc) Fix Set-Cookie header parsing in CookieContainer (#26005)
* [`[4d2e6f6]`](https://github.com/dotnet/corefx/commit/4d2e6f6) enable tests again after infrastructure was fixed (#25999)
* [`[61c968d]`](https://github.com/dotnet/corefx/commit/61c968d) Ensure System.Uri consistently uses the correct RFC 3986 reserved character set (#26006)
* [`[fc5ebeb]`](https://github.com/dotnet/corefx/commit/fc5ebeb) "Don't directly throw Exception" System.Security.AccessControl
* [`[eb110c9]`](https://github.com/dotnet/corefx/commit/eb110c9) Make test asynchronous.
* [`[c35b132]`](https://github.com/dotnet/corefx/commit/c35b132) Make ArgumentException to blame correct parameter for invalid input (#26000)
* [`[c02a6f7]`](https://github.com/dotnet/corefx/commit/c02a6f7) Ensure System.Uri normalizes Unicode hosts when "file://" scheme is present (#25993)
* [`[7fb6893]`](https://github.com/dotnet/corefx/commit/7fb6893) disable MulticastInterface_Set_AnyInterface_Succeeds temporarily while investigating failures on Fedora 25, Redhat 7.2 and 7.3 (#25976)
* [`[dfbd27b]`](https://github.com/dotnet/corefx/commit/dfbd27b) Make GeneralizedTime correctly read down to the tick
* [`[075cec7]`](https://github.com/dotnet/corefx/commit/075cec7) Bring SignedCms to CoreFx
* [`[b548a89]`](https://github.com/dotnet/corefx/commit/b548a89) Enable ECDH cipher suites as preferred cipher for key agreement.
* [`[edacccb]`](https://github.com/dotnet/corefx/commit/edacccb) Ensure build of netcoreapp vertical of CoreFx can be done without past packages (#25921)
* [`[3a98968]`](https://github.com/dotnet/corefx/commit/3a98968) Have Microsoft.CSharp pick correct default for optional MarshalAs(UnmanagedType.IDispatch) (#25508)
* [`[016659c]`](https://github.com/dotnet/corefx/commit/016659c) SpanHelpers IndexOfAny-methods use sentinel-value (#25970)
* [`[f471be9]`](https://github.com/dotnet/corefx/commit/f471be9) Fix method names of hardware intrinsic APIs
* [`[2083b09]`](https://github.com/dotnet/corefx/commit/2083b09) Add RuntimeFeature.DefaultImplementationsOfInterfaces (#25943)
* [`[79d708b]`](https://github.com/dotnet/corefx/commit/79d708b) Reference Unsafe APIs from CoreLib in System.Memory (#25929)
* [`[b29814c]`](https://github.com/dotnet/corefx/commit/b29814c) General code clean up of System.Memory (#25958)
* [`[eece401]`](https://github.com/dotnet/corefx/commit/eece401) Update ILLink version.
* [`[272b278]`](https://github.com/dotnet/corefx/commit/272b278) Making Win32Exception.ToString() method contain NativeErrorCode (#25216)
* [`[413079c]`](https://github.com/dotnet/corefx/commit/413079c) Adding database setup instructions on different platforms (#25952)
* [`[4c588b8]`](https://github.com/dotnet/corefx/commit/4c588b8) Porting remaining System.ComponentModel.Composition tests (#25849)
* [`[161729a]`](https://github.com/dotnet/corefx/commit/161729a) replace grabled character with white space (#25935)
* [`[d921819]`](https://github.com/dotnet/corefx/commit/d921819) Stop Microsoft.CSharp getting confused by varargs overloads to callable members (#25504)
* [`[1d53e3c]`](https://github.com/dotnet/corefx/commit/1d53e3c) Fix casing variations in SQL files (#25927)
* [`[8cbc0eb]`](https://github.com/dotnet/corefx/commit/8cbc0eb) Freeze the assembly version for System.Threading.Tasks.Extensions
* [`[5b07e3b]`](https://github.com/dotnet/corefx/commit/5b07e3b) Add {RO}Span GetReference and ROMemory TryGetArray to MemoryMarshal (#25789)
* [`[c82b749]`](https://github.com/dotnet/corefx/commit/c82b749) Set OuterLoop category for http tests
* [`[b34c439]`](https://github.com/dotnet/corefx/commit/b34c439) Send notification about HTTP response without content (netfx)
* [`[7c03c54]`](https://github.com/dotnet/corefx/commit/7c03c54) Correctly handle coalesce linq expressions that widen the rhs operand (#25501)
* [`[e3ec0b2]`](https://github.com/dotnet/corefx/commit/e3ec0b2) Update cng and openssl packages to pin netstandard assembly versions
* [`[07dae3c]`](https://github.com/dotnet/corefx/commit/07dae3c) fix RemoteExecutorTestBase.Process.cs (#25915)
* [`[163cfff]`](https://github.com/dotnet/corefx/commit/163cfff) Create a serializer and deserializer for ASN.1 data
* [`[0555aa9]`](https://github.com/dotnet/corefx/commit/0555aa9) Fix GZip perf test location (#25907)
* [`[d37b86e]`](https://github.com/dotnet/corefx/commit/d37b86e) Use generic test handling for remote server failures.
* [`[a57e7ca]`](https://github.com/dotnet/corefx/commit/a57e7ca) PEBuilder.Sign: Calculate checksum after writing the signature (#25871)
* [`[bbe425e]`](https://github.com/dotnet/corefx/commit/bbe425e) Temporarily removing leftover use of ReadOnlySpan indexer. (#25908)
* [`[cc8b1f5]`](https://github.com/dotnet/corefx/commit/cc8b1f5) Add NS1.3 support to Channels (#25697)
* [`[f900762]`](https://github.com/dotnet/corefx/commit/f900762) Try/Catch added to stopping service controller (#25865)
* [`[11c205b]`](https://github.com/dotnet/corefx/commit/11c205b) Add [CLSCompliant(false)] to Crc32
* [`[2aa6a76]`](https://github.com/dotnet/corefx/commit/2aa6a76) Add Crc32 to ref
* [`[b4b79c7]`](https://github.com/dotnet/corefx/commit/b4b79c7) Add Crc32 to ZipArchiveEntry
* [`[7dd8fa0]`](https://github.com/dotnet/corefx/commit/7dd8fa0) Updated the error message for missing dia sdk in build.cmd. Closes #25856 (#25859)
* [`[bd88e51]`](https://github.com/dotnet/corefx/commit/bd88e51) HashCode based on xxHash32 (#25013)
* [`[6309980]`](https://github.com/dotnet/corefx/commit/6309980) Enable autoupdate of dotnet host package version (#25889)
* [`[c20881a]`](https://github.com/dotnet/corefx/commit/c20881a)  Adding Span LastIndexOfAny APIs and tests (#25848)
* [`[3d9854f]`](https://github.com/dotnet/corefx/commit/3d9854f) Consolidate common Compression tests and apply fixes (#25780)
* [`[ddd3f8a]`](https://github.com/dotnet/corefx/commit/ddd3f8a) NamedPipeClient connect throws TimeoutException when appropriate  (#25877)
* [`[62d5964]`](https://github.com/dotnet/corefx/commit/62d5964)  XmlReader.Read shouldn't throw AggregateException  (#25681)
* [`[a5cc306]`](https://github.com/dotnet/corefx/commit/a5cc306) Sync Interop.GetCwd with coreclr
* [`[bd4859e]`](https://github.com/dotnet/corefx/commit/bd4859e) Use asset root for symbols restore (#25845)
* [`[d37a568]`](https://github.com/dotnet/corefx/commit/d37a568) Linux: Fix NetworkAddressChange NullReferenceException on AddressChange when no Availability subscribers
* [`[67a5965]`](https://github.com/dotnet/corefx/commit/67a5965) fix MiddleIndex perf tests
* [`[dc60908]`](https://github.com/dotnet/corefx/commit/dc60908) fix string perf test
* [`[f8057cc]`](https://github.com/dotnet/corefx/commit/f8057cc) Temporarily removing use of ReadOnlySpan indexer. (#25881)
* [`[c73ba13]`](https://github.com/dotnet/corefx/commit/c73ba13) Reenable automatic Alpine leg in CI (#25868)
* [`[52a064c]`](https://github.com/dotnet/corefx/commit/52a064c) Disable Process BasePriority test on WSL (#25869)
* [`[10afb4f]`](https://github.com/dotnet/corefx/commit/10afb4f) Add System.Data.DataSetExtensions and update ServiceModel version in compat pack (#25853)
* [`[fc7e983]`](https://github.com/dotnet/corefx/commit/fc7e983) "Don't directly throw Exception" System.Drawing (#25791)
* [`[0b1be8a]`](https://github.com/dotnet/corefx/commit/0b1be8a) Fix Alpine CI build last issue (#25864)
* [`[1e95551]`](https://github.com/dotnet/corefx/commit/1e95551) Re-enable additional tests on WSL (#25807)
* [`[770f701]`](https://github.com/dotnet/corefx/commit/770f701) Reenable Alpine optional CI (#25840)
* [`[77d599c]`](https://github.com/dotnet/corefx/commit/77d599c) fix [System.Diagnostics.Process]::GetProcesses(computer) (#25784)
* [`[a761cd8]`](https://github.com/dotnet/corefx/commit/a761cd8) Fix Alpine Linux dotnet host restore for tests (#25790)
* [`[0b3ccec]`](https://github.com/dotnet/corefx/commit/0b3ccec) use InnerCount
* [`[cedb211]`](https://github.com/dotnet/corefx/commit/cedb211) use InnerCount
* [`[2a3028c]`](https://github.com/dotnet/corefx/commit/2a3028c) Fix ArgumentNullException in case of IValidatableObject returns null  (#25693)
* [`[075df17]`](https://github.com/dotnet/corefx/commit/075df17) "Don't directly throw Exception" System.Runtime.Serialization.Json (#25796)
* [`[cd3bcb8]`](https://github.com/dotnet/corefx/commit/cd3bcb8) Fix Alpine CI step 2 (#25813)
* [`[ef02f28]`](https://github.com/dotnet/corefx/commit/ef02f28) Changed to just clearing rather than throwing the error
* [`[ee9830f]`](https://github.com/dotnet/corefx/commit/ee9830f) fix remaining review issues.
* [`[955bc4b]`](https://github.com/dotnet/corefx/commit/955bc4b) add basic perf tests.
* [`[cf9a693]`](https://github.com/dotnet/corefx/commit/cf9a693) Hotfix for the Alpine CI issue (#25806)
* [`[ec6014e]`](https://github.com/dotnet/corefx/commit/ec6014e) Create a Memory/Span-based ASN.1 reader and writer (#25296)
* [`[47679e4]`](https://github.com/dotnet/corefx/commit/47679e4) Adding compiler services using directive to use Unsafe.
* [`[a647411]`](https://github.com/dotnet/corefx/commit/a647411) Re-enable DriveInfo test on Windows Subsystem for Linux
* [`[25db335]`](https://github.com/dotnet/corefx/commit/25db335) Disable alpine leg from running by default
* [`[7f79ada]`](https://github.com/dotnet/corefx/commit/7f79ada) Fix XmlSerializer packaging break (#25799)
* [`[90f3525]`](https://github.com/dotnet/corefx/commit/90f3525) simplify max length no overflow test
* [`[6d75e2a]`](https://github.com/dotnet/corefx/commit/6d75e2a) add null throw tests
* [`[55bd035]`](https://github.com/dotnet/corefx/commit/55bd035) UnixNetworkInterface: when no physical address, use PhysicalAddress.None and ensure index is set
* [`[21b48fd]`](https://github.com/dotnet/corefx/commit/21b48fd) Add bounds checks for offset in classes that impl OwnedMemory
* [`[362ebe7]`](https://github.com/dotnet/corefx/commit/362ebe7) Update Sgen Version to 1.1.0 (#25769)
* [`[9a831eb]`](https://github.com/dotnet/corefx/commit/9a831eb)  Replace S.L.Expression's CanCache with the use of Type.IsCollectible (#25736)
* [`[1e3b969]`](https://github.com/dotnet/corefx/commit/1e3b969) make generic params 'in'
* [`[42c5dec]`](https://github.com/dotnet/corefx/commit/42c5dec) compute median without subtract
* [`[c68312e]`](https://github.com/dotnet/corefx/commit/c68312e) add icomparable overload tests.
* [`[6d57c82]`](https://github.com/dotnet/corefx/commit/6d57c82) Enable Alpine Linux CI (#25778)
* [`[3d0ac20]`](https://github.com/dotnet/corefx/commit/3d0ac20) Fix string test, add double tests.
* [`[8b4a8ba]`](https://github.com/dotnet/corefx/commit/8b4a8ba) Add initial implementation.
* [`[28a593f]`](https://github.com/dotnet/corefx/commit/28a593f) Including pre-release versions of VS for builds (#25689)
* [`[9351823]`](https://github.com/dotnet/corefx/commit/9351823) Add optional offset to Pin in System.Runtime ref.
* [`[d7399a5]`](https://github.com/dotnet/corefx/commit/d7399a5) Change Pin to take an optional integer offset.
* [`[33ec299]`](https://github.com/dotnet/corefx/commit/33ec299) Include Code of Conduct in GitHub-recognised manner. (#25751)
* [`[749194e]`](https://github.com/dotnet/corefx/commit/749194e) Convert managed implementation of Marvin hashing to ReadOnlySpan (#25735)
* [`[cf10104]`](https://github.com/dotnet/corefx/commit/cf10104) Add stable version for SGEN
* [`[939ffe6]`](https://github.com/dotnet/corefx/commit/939ffe6) Use Mono workaround to parse internal relationships in packages (#25275)
* [`[1520d0b]`](https://github.com/dotnet/corefx/commit/1520d0b) Update unix-instructions.md (#25724)
* [`[70f9e94]`](https://github.com/dotnet/corefx/commit/70f9e94) Fix tool initialization detection
* [`[a6c01b0]`](https://github.com/dotnet/corefx/commit/a6c01b0) Exposed RuntimeWrappedException constructor. (#25716)
* [`[190132d]`](https://github.com/dotnet/corefx/commit/190132d) Concurrent Dictionary for BinaryFormatters (#25590)
* [`[1242b99]`](https://github.com/dotnet/corefx/commit/1242b99) Make the target works for exe. (#25567)
* [`[c867915]`](https://github.com/dotnet/corefx/commit/c867915) fix sgen if/else issue (#25562)
* [`[1922cb2]`](https://github.com/dotnet/corefx/commit/1922cb2) Added test for Delegate.CreateDelegate method (#25528)
* [`[5084139]`](https://github.com/dotnet/corefx/commit/5084139) Add several more shutdown calls to sockets tests (#25713)
* [`[23a4ba9]`](https://github.com/dotnet/corefx/commit/23a4ba9) Pull out the SerializeAndDeseriaze method into common (#25703)
* [`[4b11480]`](https://github.com/dotnet/corefx/commit/4b11480) Expose Stream.CopyToAsync overload without buffer size
* [`[1c79f9a]`](https://github.com/dotnet/corefx/commit/1c79f9a) Make ExcludeFromCodeCoverageAttribute applicable to assemblies. (#25414)
* [`[17be4bc]`](https://github.com/dotnet/corefx/commit/17be4bc) Environment.ProcessorCount: use runtime implementation via EnvironmentAugments (#25630)
* [`[7caa955]`](https://github.com/dotnet/corefx/commit/7caa955) Implementation of DbProviderFactories.  (#25410)
* [`[dbfa1eb]`](https://github.com/dotnet/corefx/commit/dbfa1eb) Add missing Shutdown calls in HTTP loopback servers (#25694)
* [`[a1e5d5c]`](https://github.com/dotnet/corefx/commit/a1e5d5c) Optimize UTF-8 Int64/UInt64 Formatter for x86 (#25626)
* [`[ea9549c]`](https://github.com/dotnet/corefx/commit/ea9549c) Disable IOControl_SIOCATMARK_Success test on other platforms
* [`[9a563e1]`](https://github.com/dotnet/corefx/commit/9a563e1) Fix pal_networking.c compilation error on some platforms (#25687)
* [`[5071636]`](https://github.com/dotnet/corefx/commit/5071636) Fix BigInteger.TryFormat to use ReadOnlySpan\<char> for format (#25686)
* [`[736da1b]`](https://github.com/dotnet/corefx/commit/736da1b) Fix Alpine CURL concurrency issue (#25692)
* [`[a938b5d]`](https://github.com/dotnet/corefx/commit/a938b5d) [Docs] Build and run your .NET Core application with csc and CoreRun (#24168)
* [`[9223082]`](https://github.com/dotnet/corefx/commit/9223082) Fix Alpine Linux dependency chain (#25685)
* [`[defb6d5]`](https://github.com/dotnet/corefx/commit/defb6d5) Disable parallelization for EventLog (#25695)
* [`[436690c]`](https://github.com/dotnet/corefx/commit/436690c) Added SpanExtensions.EndsWith (#25416)
* [`[3240aab]`](https://github.com/dotnet/corefx/commit/3240aab) Add Overlaps extension method to SpanExtensions (#24980)
* [`[595502f]`](https://github.com/dotnet/corefx/commit/595502f) Added explicit conversion APIs for Span to ROSpan and Memory to ROMemory (#25370)
* [`[beefd9a]`](https://github.com/dotnet/corefx/commit/beefd9a) Add composition assembly to rd.xml to unblock reflection on exceptions (#25683)
* [`[6268d49]`](https://github.com/dotnet/corefx/commit/6268d49) Expose/test double.TryFormat and float.TryFormat (#25553)
* [`[ac3be14]`](https://github.com/dotnet/corefx/commit/ac3be14) Fix new TryFormat/Parse* overloads to work with span formats (#25538)
* [`[497afa1]`](https://github.com/dotnet/corefx/commit/497afa1) Update ProjectNTfs, ProjectNTfsTestILC to beta-26005-00, beta-26005-00, respectively (#25679)
* [`[03c7617]`](https://github.com/dotnet/corefx/commit/03c7617) SslStream - Linux Solving it all in 4 lines (and deleting 2) (#25646)
* [`[8be4bd2]`](https://github.com/dotnet/corefx/commit/8be4bd2) Add BigInteger.TryFormat (#25618)
* [`[dbabdc1]`](https://github.com/dotnet/corefx/commit/dbabdc1) Use IlAsm infra from BuildTools (#25649)
* [`[444efb2]`](https://github.com/dotnet/corefx/commit/444efb2) Disable some CLI options via env variables. (#25644)
* [`[710ce8f]`](https://github.com/dotnet/corefx/commit/710ce8f) Removing unused DuplicateX509Name function
* [`[f73b3d2]`](https://github.com/dotnet/corefx/commit/f73b3d2) Removing remnants of SSL_CTX_set_client_CA_list references
* [`[7bdd866]`](https://github.com/dotnet/corefx/commit/7bdd866) disable ProxySetViaEnvironmentVariable_DefaultProxyCredentialsUsed on windows (#25641)
* [`[ac33201]`](https://github.com/dotnet/corefx/commit/ac33201) Fix subprotocol check in WebSocketHandle.Managed (#25645)
* [`[8f8b04a]`](https://github.com/dotnet/corefx/commit/8f8b04a) Add basic Socket.IOControl implementation on Unix (#25579)
* [`[97b535f]`](https://github.com/dotnet/corefx/commit/97b535f) Finalizing layout of benchmarking.md file
* [`[1f30ed0]`](https://github.com/dotnet/corefx/commit/1f30ed0) Update header styling in benchmark.md
* [`[93e5ec3]`](https://github.com/dotnet/corefx/commit/93e5ec3) Adding missing instructions to benchmarking.md
* [`[c05f546]`](https://github.com/dotnet/corefx/commit/c05f546) Make c# samples c# style like in benchmarking.md
* [`[494160d]`](https://github.com/dotnet/corefx/commit/494160d) Fix wrong attribute in benchmark.md file
* [`[6f4c300]`](https://github.com/dotnet/corefx/commit/6f4c300) Update benchmark.md with BenchmarkDotNet 0.10.11 changes
* [`[75cc80a]`](https://github.com/dotnet/corefx/commit/75cc80a) Removing more unused methods
* [`[583a100]`](https://github.com/dotnet/corefx/commit/583a100) Removing unused function
* [`[41cb3ff]`](https://github.com/dotnet/corefx/commit/41cb3ff) Avoid filling the TRUSTED_ISSUERS entry in SSL handshake on Linux from the root stores to maintain comparability with the behavior of SslStream on Windows.
* [`[5ae17d8]`](https://github.com/dotnet/corefx/commit/5ae17d8) Add logic to skip alpn tests where unsupported.
* [`[9a2e5d8]`](https://github.com/dotnet/corefx/commit/9a2e5d8) Add static library definitions to CMakeLists for CoreRT (#25628)
* [`[357327a]`](https://github.com/dotnet/corefx/commit/357327a) Ensure HttpListener request buffer is aligned as required by the host processor (#25563)
* [`[c53b84b]`](https://github.com/dotnet/corefx/commit/c53b84b) Make Process.Start throw Win32Exception when child process doesn't exec. (#25266)
* [`[8229cb7]`](https://github.com/dotnet/corefx/commit/8229cb7) Change perf job name to reflect the actual OS used (#25622)
* [`[6126b43]`](https://github.com/dotnet/corefx/commit/6126b43) Performace issue fix for manged sni (#25621)
* [`[04a2e39]`](https://github.com/dotnet/corefx/commit/04a2e39) Move New Syndication APIs to NetCore Specific Ref (#25611)
* [`[eb0d438]`](https://github.com/dotnet/corefx/commit/eb0d438) Fast file enumeration for Windows (#25426)
* [`[991fb25]`](https://github.com/dotnet/corefx/commit/991fb25) Update api compat baselines - not building
* [`[1c38507]`](https://github.com/dotnet/corefx/commit/1c38507) Skipping tests on uap (#25606)
* [`[5aa98c1]`](https://github.com/dotnet/corefx/commit/5aa98c1) Benchmarking .NET Core 2.0/2.1 applications with BenchmarkDotNet (#25612)
* [`[48c6e49]`](https://github.com/dotnet/corefx/commit/48c6e49) Update issue-guide.md
* [`[32b587d]`](https://github.com/dotnet/corefx/commit/32b587d) UnsafeTests: force explicit layout, so tests work on 32bit and 64bit platforms (#25594)
* [`[3111dee]`](https://github.com/dotnet/corefx/commit/3111dee) Update ProjectNTfs, ProjectNTfsTestILC to beta-25930-00, beta-25930-00, respectively (#25593)
* [`[fa80bd2]`](https://github.com/dotnet/corefx/commit/fa80bd2) Improve BinaryFormatter equality check logging (#25566)
* [`[3478bae]`](https://github.com/dotnet/corefx/commit/3478bae) Simplify some casting and conversion related code in Microsoft.CSharp (#25357)
* [`[ad9c493]`](https://github.com/dotnet/corefx/commit/ad9c493) Optimize Utf-8 Integer Formatter for the default case (#25424)
* [`[d28785d]`](https://github.com/dotnet/corefx/commit/d28785d) Fix handling of unary operations on nullable enums in Microsoft.CSharp (#25209)
* [`[0f5267d]`](https://github.com/dotnet/corefx/commit/0f5267d) Allow dynamic use objects of different, identically-named, types. (#25191)
* [`[2fcc218]`](https://github.com/dotnet/corefx/commit/2fcc218) Correct identity expression results in MS.CSharp (#25484)
* [`[d4f644a]`](https://github.com/dotnet/corefx/commit/d4f644a) S.M: Add initial BinarySearch span extensions method definitions.
* [`[fed2d5f]`](https://github.com/dotnet/corefx/commit/fed2d5f) Porting first half of the System.ComponentModel.Composition tests (#25437)
* [`[d1521ea]`](https://github.com/dotnet/corefx/commit/d1521ea) Disable console title workaround for >=RS4 (#25532)
* [`[93764c0]`](https://github.com/dotnet/corefx/commit/93764c0) Improve Syndication DateTime Parsing (#25309)
* [`[7ec7367]`](https://github.com/dotnet/corefx/commit/7ec7367) Add support for Big-Endian and unsigned byte patterns to BigInteger
* [`[834049b]`](https://github.com/dotnet/corefx/commit/834049b) "Don't directly throw Exception" System.Data.SqlClient (#25542)
* [`[d2670c6]`](https://github.com/dotnet/corefx/commit/d2670c6) Quick removal of more blocking in Sockets (#25460)
* [`[7856715]`](https://github.com/dotnet/corefx/commit/7856715) Increase System.Runtime test coverage from 68.1% line 42.3% branch to 100%/100% (#25556)
* [`[5ce8eec]`](https://github.com/dotnet/corefx/commit/5ce8eec) Add a test to verify the XmlQualifiedName "duration" of TimeSpan type. (#25277)
* [`[c8d62ac]`](https://github.com/dotnet/corefx/commit/c8d62ac) readlink: don't special case too small buffer in native code (#25558)
* [`[ab082da]`](https://github.com/dotnet/corefx/commit/ab082da) enable multicast test on Fedora again (#25552)
* [`[305c2cc]`](https://github.com/dotnet/corefx/commit/305c2cc) Add URI regression test for combining absolute/relative URIs
* [`[9a81f78]`](https://github.com/dotnet/corefx/commit/9a81f78) Fix ValueStringBuilder to not leak pooled arrays when TryCopyTo fails (#25549)
* [`[4f7ab0f]`](https://github.com/dotnet/corefx/commit/4f7ab0f) readdir_r: align read buffer at dirent (#25518)
* [`[b6c1ea9]`](https://github.com/dotnet/corefx/commit/b6c1ea9) readlink: handle truncated return (#25543)
* [`[2a3b1f4]`](https://github.com/dotnet/corefx/commit/2a3b1f4) Fix new BigInteger.TryParse overloads (#25537)
* [`[bf178db]`](https://github.com/dotnet/corefx/commit/bf178db) Update ProjectNTfs, ProjectNTfsTestILC to beta-25928-00, beta-25928-00, respectively
* [`[5888b29]`](https://github.com/dotnet/corefx/commit/5888b29) Add Support for getting desktop TFM for quirk testing (#25454)
* [`[771136c]`](https://github.com/dotnet/corefx/commit/771136c) Improve InvalidDirectory error in FileSystemWatcher (#25485)
* [`[1d83d60]`](https://github.com/dotnet/corefx/commit/1d83d60) Speed up Windows ProcessManager.OpenProcess (#25478)
* [`[ad64755]`](https://github.com/dotnet/corefx/commit/ad64755) added keu value to key not found exception (dotnet/coreclr#15201)
* [`[3c80e65]`](https://github.com/dotnet/corefx/commit/3c80e65) Expose and test Decimal.TryParse (#25417)
* [`[83551fa]`](https://github.com/dotnet/corefx/commit/83551fa) Eliminate dirent memcpy when using readdir. (#25407)
* [`[7c1a84a]`](https://github.com/dotnet/corefx/commit/7c1a84a) TextReader.Read base implementation for count == 0 (#25474)
* [`[0f7b728]`](https://github.com/dotnet/corefx/commit/0f7b728) Add CLSCompliant(false) to APIs in System.Memory (#25471)
* [`[fb94fc7]`](https://github.com/dotnet/corefx/commit/fb94fc7) Simplifies ReadOnlySpan ArgumentNullException test (#25486)
* [`[1de2a4f]`](https://github.com/dotnet/corefx/commit/1de2a4f) Changed ' to # in RowFilter (#25482)
* [`[97292b1]`](https://github.com/dotnet/corefx/commit/97292b1) attributes added tp ref (#25475)
* [`[69b877b]`](https://github.com/dotnet/corefx/commit/69b877b) Expose and test string implicit cast to ReadOnlySpan\<char> (#25438)
* [`[162b5c5]`](https://github.com/dotnet/corefx/commit/162b5c5) UnixDomainSocketEndPoint: support Linux abstract socket address. (#25435)
* [`[1d033ac]`](https://github.com/dotnet/corefx/commit/1d033ac) Fix SSE2 and SSE4.1 APIs
* [`[c4fe235]`](https://github.com/dotnet/corefx/commit/c4fe235) SslApplicationProtocol: Use the copied byte array (#25444)
* [`[7e22b77]`](https://github.com/dotnet/corefx/commit/7e22b77) Temporarily disable caching of AsyncOperations
* [`[8aa3d6d]`](https://github.com/dotnet/corefx/commit/8aa3d6d) Cache AsyncOperation instances on the SocketAsyncContext on Unix
* [`[89abe20]`](https://github.com/dotnet/corefx/commit/89abe20) Simplify ReceiveMessageFromAsync signature
* [`[23fa2e8]`](https://github.com/dotnet/corefx/commit/23fa2e8) Simplify InnerStart* pattern
* [`[7ef465b]`](https://github.com/dotnet/corefx/commit/7ef465b) Fully enable Memory\<byte> in SocketAsyncEventArgs
* [`[1d95739]`](https://github.com/dotnet/corefx/commit/1d95739) Temporarily removing use of ReadOnlySpan indexer in Runtime.Extensions (#25326)
* [`[db1793c]`](https://github.com/dotnet/corefx/commit/db1793c) Add support for Unix Domain Sockets (#25246)
* [`[28fffe8]`](https://github.com/dotnet/corefx/commit/28fffe8) Packaging System.ComponentModel.Composition (#25411)
* [`[6f08f5a]`](https://github.com/dotnet/corefx/commit/6f08f5a) Disable parallelism in PerfCounter tests (#25401)
* [`[06e6a36]`](https://github.com/dotnet/corefx/commit/06e6a36) make sure crypto_Init is done before calling ssl_init (#25297)
* [`[49a62ed]`](https://github.com/dotnet/corefx/commit/49a62ed) Removing unneeded blocking from tests (#25399)
* [`[e4a35b9]`](https://github.com/dotnet/corefx/commit/e4a35b9) Fix Process StartTime offset on Linux due to device sleeping (#25312)
* [`[b28e05a]`](https://github.com/dotnet/corefx/commit/b28e05a) Defer calculation of AggregateType.GetBaseClass() in Microsoft.CSharp (#25196)
* [`[8543f07]`](https://github.com/dotnet/corefx/commit/8543f07) Update core dumps docs (#25398)
* [`[8c911fe]`](https://github.com/dotnet/corefx/commit/8c911fe) Configure build definitions but only run Release builds by default
* [`[9406156]`](https://github.com/dotnet/corefx/commit/9406156) Modify alpn failure test to use network stream.
* [`[30a0f7f]`](https://github.com/dotnet/corefx/commit/30a0f7f) Use BuildTools PackageVersionPropsUrl tooling (#25319)
* [`[4579fc6]`](https://github.com/dotnet/corefx/commit/4579fc6) Set handshake failure for alpn failure on Linux.
* [`[9588e29]`](https://github.com/dotnet/corefx/commit/9588e29) MS.CSharp some error improvements (#25342)
* [`[5b31a65]`](https://github.com/dotnet/corefx/commit/5b31a65) MS.CSharp: Stop string conversion being incorrectly considered "simple" (#25339)
* [`[59b5f20]`](https://github.com/dotnet/corefx/commit/59b5f20) Don't cache TypeParameterType in table. (#25332)
* [`[68f01b2]`](https://github.com/dotnet/corefx/commit/68f01b2) Fix two issues related to high-arity lambda expressions. (#25304)
* [`[0ebe5c7]`](https://github.com/dotnet/corefx/commit/0ebe5c7) Reduce allocations in BigInteger.ToString with hex
* [`[c0c8d5c]`](https://github.com/dotnet/corefx/commit/c0c8d5c) Add ValueStringBuilder to Common from coreclr (unchanged)
* [`[254ecc0]`](https://github.com/dotnet/corefx/commit/254ecc0) Use real AsReadOnlySpan rather than workaround
* [`[ed36542]`](https://github.com/dotnet/corefx/commit/ed36542) Avoid always using ToByteArray in FormatBigIntegerToHex
* [`[a913bc7]`](https://github.com/dotnet/corefx/commit/a913bc7) Expose and test TryFormat methods on {S}Byte, {U}Int16/32/64, Boolean (#25307)
* [`[08fc088]`](https://github.com/dotnet/corefx/commit/08fc088) pal_io.c: fix preprocessor case not yet migrated from cpp to c (#25365)
* [`[aa1fadc]`](https://github.com/dotnet/corefx/commit/aa1fadc) Disable PerformanceCounter_IncrementBy_IncrementByReadOnly test (#25358)
* [`[fc9a0b2]`](https://github.com/dotnet/corefx/commit/fc9a0b2) Missed Win32Marshal case (#25356)
* [`[e8323e2]`](https://github.com/dotnet/corefx/commit/e8323e2) Delete FriendAccessAllowedAttribute and associated dead code (#15101) (#25351)
* [`[a65054c]`](https://github.com/dotnet/corefx/commit/a65054c) Fix DataTable test to not assume non-en-GB (#25327)
* [`[c3abf82]`](https://github.com/dotnet/corefx/commit/c3abf82) Clean up CreateFile usage. (#25318)
* [`[876fe96]`](https://github.com/dotnet/corefx/commit/876fe96) Add releasenotes and projecturl in the nuget package. (#25316)
* [`[8a4934f]`](https://github.com/dotnet/corefx/commit/8a4934f) Adding null check for implicit cast from array to Span. (#25257)
* [`[ce9aecc]`](https://github.com/dotnet/corefx/commit/ce9aecc) Update `ref readonly` parameter for new compiler syntax: `in`.
* [`[35d0838]`](https://github.com/dotnet/corefx/commit/35d0838) Support loading libgdiplus from NuGet packages (#25112)
* [`[9b8e1d9]`](https://github.com/dotnet/corefx/commit/9b8e1d9) Add failure feeds file and test case for negative feed test (#25237)
* [`[a5af336]`](https://github.com/dotnet/corefx/commit/a5af336) Swap partial and static keywords since this causes compile errors with latest compiler.
* [`[98127b8]`](https://github.com/dotnet/corefx/commit/98127b8) Add null checks in Memory\<T> APIs to support default (#25009)
* [`[8145283]`](https://github.com/dotnet/corefx/commit/8145283) Enable Syndication to Read Disjoint Items (#25166)
* [`[c1872ec]`](https://github.com/dotnet/corefx/commit/c1872ec) Added UnixEpoch to DateTime and DateTimeOffset (#25235)
* [`[6a9f579]`](https://github.com/dotnet/corefx/commit/6a9f579) Start switching System.Native from C++ to C (#25032)

## WCF

* [`[af75e5a]`](https://github.com/dotnet/wcf/commit/af75e5a) Also needed dotnet/corefx#29543 to make this work.
* [`[66ab294]`](https://github.com/dotnet/wcf/commit/66ab294) Support for queuing a stable package build
* [`[0307410]`](https://github.com/dotnet/wcf/commit/0307410) Change the public key of WCF assemblies to MSFT. (#2812) (#2817)
* [`[d49f3f6]`](https://github.com/dotnet/wcf/commit/d49f3f6) Update pre-release label from rc1 to rtm.
* [`[ccf9fbf]`](https://github.com/dotnet/wcf/commit/ccf9fbf) Add the Expect 100-Continue header when using a client certificate
* [`[3d0d562]`](https://github.com/dotnet/wcf/commit/3d0d562) Change prerelease label to rc1
* [`[35b3cf3]`](https://github.com/dotnet/wcf/commit/35b3cf3) Added additional socket error codes which can result from DNS lookup failure
* [`[46b812b]`](https://github.com/dotnet/wcf/commit/46b812b) Adding support for Expect:100-Continue header and removing extra HEAD request when not using UAP
* [`[0deba3d]`](https://github.com/dotnet/wcf/commit/0deba3d) Update Standard, WCF to servicing-26406-01, preview2-26406-03, respectively
* [`[c8991a0]`](https://github.com/dotnet/wcf/commit/c8991a0) Update manual dependencies for release/2.1
* [`[3eb3710]`](https://github.com/dotnet/wcf/commit/3eb3710) Manually update several dependencies.
* [`[3e84720]`](https://github.com/dotnet/wcf/commit/3e84720) Update 2.1 to reference most recently built WCF packages from the release/2.1.0 branch.
* [`[3d3e596]`](https://github.com/dotnet/wcf/commit/3d3e596) Modify digest service to fail if wrong type of authentication is sent
* [`[a0837bc]`](https://github.com/dotnet/wcf/commit/a0837bc) Check that the authorization header is providing Digest credentials
* [`[977faf7]`](https://github.com/dotnet/wcf/commit/977faf7) Use CredentialCache which limits a credential to a particular authentication mechanism
* [`[5dc61c0]`](https://github.com/dotnet/wcf/commit/5dc61c0) Add new exception handling logic for SocketsHttpHandler differences
* [`[a5d0974]`](https://github.com/dotnet/wcf/commit/a5d0974) Update release/2.1.0 to use latest preview2 buildtools version.
* [`[dbb1273]`](https://github.com/dotnet/wcf/commit/dbb1273) Move win7 harvested binaries under runtimes/win/lib
* [`[2c90e58]`](https://github.com/dotnet/wcf/commit/2c90e58) Adding an entry for 2.0.0 for WcfPRService serial numbers
* [`[9d5de7e]`](https://github.com/dotnet/wcf/commit/9d5de7e) Port of dotnet/corefx#25644 (#2608)
* [`[39c8f91]`](https://github.com/dotnet/wcf/commit/39c8f91) Updating netci serial numbers for supported branches.
* [`[1c141d4]`](https://github.com/dotnet/wcf/commit/1c141d4) Fix support for using proxies with HTTP transport
* [`[c931e26]`](https://github.com/dotnet/wcf/commit/c931e26) KeepAliveEnabled property implementation for HttpTransportBindingElement
* [`[8d0dba2]`](https://github.com/dotnet/wcf/commit/8d0dba2) Porting CoreFx changes to enable publishing to azure feeds.
* [`[6c31c01]`](https://github.com/dotnet/wcf/commit/6c31c01) Improve validation of service certifcate by requiring Server Auth usage
* [`[ab768b2]`](https://github.com/dotnet/wcf/commit/ab768b2) Run CodeFormatter on SvcUtil (#2495)
* [`[61ad988]`](https://github.com/dotnet/wcf/commit/61ad988) Renamed SvcUtil Assembly to dotnet-svcutilcore
* [`[31b9fce]`](https://github.com/dotnet/wcf/commit/31b9fce)  Make dotnet cmd executable.
* [`[46e23d2]`](https://github.com/dotnet/wcf/commit/46e23d2) Fixed a bug with Unix assembly path.
* [`[1e21cb6]`](https://github.com/dotnet/wcf/commit/1e21cb6) Workaround for path not supported error when syncing sources. (#2448)
* [`[4f5b733]`](https://github.com/dotnet/wcf/commit/4f5b733) Release notes for update in VS 15.6 Preview 1 (#2435)
