# .NET Core 2.1 Preview 1 - February 27, 2018

.NET Core 2.1.0 Preview 1 is available for download and usage in your environment.

* [Downloads](https://dotnet.microsoft.com/download/dotnet/2.1)

## Blog Round up

* [.NET Core](https://devblogs.microsoft.com/dotnet/announcing-net-core-2-1-preview-1/)
* [ASP .NET Core](https://devblogs.microsoft.com/dotnet/asp-net-core-2-1-0-preview1-now-available/)
* [Entity Framework Core](https://devblogs.microsoft.com/dotnet/announcing-entity-framework-core-2-1-preview-1/)

The .NET Core SDK 2.1 Preview includes .NET Core 2.1 Runtime Preview so downloading the runtime packages separately is not needed when installing the SDK. After installing the .NET Core SDK 2.1 Preview, the following command will show that you're running version `2.1.300-preview1-008174` of the tools.

`dotnet --version`

Your feedback is important and appreciated. We've created an issue at [dotnet/core #1297](https://github.com/dotnet/core/issues/1297) for your questions and comments.

## Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Look for the 2.1 Preview 1 images.

## Azure AppServices

Details for running .NET Core 2.1 Preview 1 in Azure App Services can be seen in the [ASP.NET Core blog post](https://devblogs.microsoft.com/dotnet/asp-net-core-2-1-0-preview1-using-asp-net-core-previews-on-azure-app-service/).

## Notable Additions in Preview 1

**System.IO** - Path APIs no longer check invalid characters directly.

To improve performance and unblock cross platform scenarios System.IO.Path methods no longer check for validity of characters outside of the null character. Most System.IO APIs that take a path are impacted by this. Attempting to use a path that the OS/file system doesn't handle will return the system reported `IOException` when actually using the path as opposed to an ArgumentException before passing the path to the OS.

**System.IO** - Directory enumeration performance improvements

Performance of enumerating directories on Windows has been significantly improved, particularly with recursive searches.

**System.IO.Compression** - New Brotli Compression APIs

Add API to compress and decompress using the Brotli algorithm, a generic-purpose lossless compression algorithm used primarily by web browsers and servers. Operations may be completed using either the stream-based BrotliStream or the high-performance span-based BrotliEncoder/BrotliDecoder classes.

**System.Security** - New SignedCms APIs

`System.Security.Cryptography.Pkcs.SignedCms` is now available in the `System.Security.Cryptography.Pkcs` package.  The .NET Core implementation is available to all .NET Core platforms and has parity with the class from .NET Framework.

**System.Security** - New X509Certificate.GetCertHash overload for SHA-2

New overloads for `X509Certificate.GetCertHash` and `X509Certificate.GetCertHashString` accept a hash algorithm identifier to enable callers to get certificate thumbprint values using algorithms other than SHA-1.

**System.Security** - New Span-based cryptography APIs

Span-based API is available for hashing, HMAC, (cryptographic) random number generation, asymmetric signature generation, asymmetric signature processing, and RSA encryption.

**System.Security** - Rfc2898DeriveBytes performance improvements

By switching to Span-based computations the computations of `Rfc2898DeriveBytes` (PBKDF2) have sped up about 15% compared to prior releases.  Users who have benchmarked an iteration count for an amount of server time can now increase their iteration count accordingly.

**System.Memory** - New APIs for efficient low-allocation access to memory

The component contains primitives and libraries that can be used to optimize memory usage. The primitives, `Span<T>`, `ReadOnlySpan<T>`, `Memory<T>`, and `ReadOnlyMemory<T>` are types for efficient representation of managed, stack, and native memory segments.  `ReadOnlySequence<T>` represents a sequence of such segments. The rest of the component are reusable APIs operating on these primitives. For example, the `Utf8Parser` class can be used to parse UTF-8 encoded text stored in a memory segment. Similarly, Utf8Formatter can be used to format UTF-8 text into a memory segment. It also contains `BinaryPrimitive` APIs which let you read and write blittable types into and from `Span<byte>` with support for endian-ness.

### Global Tools

Global tools let you install a tool from a NuGet feed into your local path. This makes in available in a similar manner to npm -g.

**dotnet --list-sdks**

`dotnet --list-sdks` provides a list of .NET Core SDKs installed on the machine

Many .NET Core SDKs may be installed on a given machine. The new `--list-sdks` switch lists installed SDKs along with the base path where they are installed. This new switch is present in the .NET Core host, which has a single copy on the machine. Thus, this switch works once the preview is installed, regardless of global.json or if the preview is uninstalled.

**dotnet --list-runtimes**

`dotnet --list-runtimes` provides a list of .NET Core Runtimes installed on the machine

Many .NET Core Runtimes may be installed on a given machine. The new `--list-runtimes` switch lists installed runtimes along with the base path where they are installed. This new switch is present in the .NET Core host, which has a single copy on the machine. Thus, this switch works once the preview is installed, regardless of global.json or if the preview is uninstalled.
