# .NET Core 2.1 - May 30, 2018

.NET Core 2.1.0 is available for download and usage in your environment. Have a look at the [Known Issues](2.1.0-known-issues.md) document as there are a few things to be aware of before installing. A [changelist](2.1.0-commit.md) for the entire 2.1 development cycle is also available. This does not include ASP.NET Core or Entity Framework Core.

* [Download .NET Core](https://dotnet.microsoft.com/download)

## Blog Round up

* [.NET Core](https://devblogs.microsoft.com/dotnet/announcing-net-core-2-1/)
* [ASP .NET Core](https://devblogs.microsoft.com/dotnet/asp-net-core-2-1-0-now-available/)
* [Entity Framework Core](https://devblogs.microsoft.com/dotnet/announcing-entity-framework-core-2-1/)

The .NET Core SDK 2.1 includes .NET Core 2.1 Runtime so downloading the runtime packages separately is not needed when installing the SDK. After installing the .NET Core SDK 2.1, running `dotnet --version` will show that you're running version `2.1.300` of the .NET Core tools.

`dotnet --info` has been greatly enhanced in .NET Core 2.1 and now provides detailed information on installed .NET Core components.

Your feedback is important and appreciated. We've created an issue at [dotnet/core #1614](https://github.com/dotnet/core/issues/1614) for your questions and comments.

## Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Look for the 2.1 images.

## Azure AppServices

* Deployment of .NET Core 2.1.0 to Azure App Services has begun. It will be available in limited regions today and expected worldwide by the end of the week.

## Notable Changes in 2.1

### Linux installer changes and distro version updates

#### Installer changes

The .NET Core installers now support package manager updates (eg `apt-get update`) functionality.

#### Supported version changes

* **In with the new** - .NET Core 2.1 is available for Ubuntu 18.04 and Fedora 28.
* **Out with the 'old'** - Fedora 26 moves to end-of-life on 5/30/2018 and will be removed from the list of .NET Core supported operating systems.

#### Snap support

We have been working on bringing .NET Core to Snap and are ready to hear what you think. Snaps, along with a few other technologies, are an emerging application installation and sandboxing technology which we think is pretty intriguing. The Snap install works well on Debian-based systems and other distros such as Fedora are having challenges that we're working to run down. The following steps can be used if you would like to give this a try.

* Visit [Snapcraft.io](https://snapcraft.io/) for guidance on preparing your system to use Snaps.
* As with our other installers, the Runtime and SDK are available depending on your needs.
  * `sudo snap install dotnet-sdk --candidate --classic`
  * `sudo snap install dotnet-runtime-21 --candidate`

Watch for future posts delving into what Snaps are about. In the meantime, we would love to hear your feedback.

### .NET Core Tools

`dotnet tool` supports the following commands:

* `dotnet tool install` — installs a tool
* `dotnet tool update` — uninstalls and reinstalls a tool, effectively updating it
* `dotnet tool uninstall` — uninstalls a tool
* `dotnet tool list` — lists currently installed tools
* `--tool-path` — specifies a specific location to (un)install and list tools, per invocation
* `--global` or `-g` -- specifies that a tool command should be in the global scope. No other scopes are currently supported.

### `dotnet build` process control

You can manually terminate the build server processes via the following command:

```console
dotnet build-server shutdown
```

You can prevent worker processes from being created with the following syntax:

```console
dotnet build -nodeReuse:false
```

### Networking Performance

You can use one of the following mechanisms to configure a process to use the older [HttpClientHandler](https://learn.microsoft.com/dotnet/api/system.net.http.httpclienthandler):

From code, use the AppContext class:

```csharp
AppContext.SetSwitch("System.Net.Http.UseSocketsHttpHandler", false);
```

The AppContext switch can also be set by config file.

The same can be achieved via the environment variable `DOTNET_SYSTEM_NET_HTTP_USESOCKETSHTTPHANDLER`. To opt out, set the value to either `false` or `0`.

On Windows, you can choose to use `WinHttpHandler` or `SocketsHttpHandler` on a call-by-call basis. To do that, instantiate one of those types and then pass it to [HttpClient](https://learn.microsoft.com/dotnet/api/system.net.http.httpclient.-ctor) when you instantiate it.

On Linux and macOS, you can only configure `HttpClient` on a process-basis. On Linux, you need to deploy [libcurl](https://curl.haxx.se/libcurl/) yourself if you want to use the old `HttpClient` implementation. If you have .NET Core 2.0 working on your machine, then libcurl is already installed.

### API changes

See all changes from 2.0 in the [detailed API diff](./api-diff/2.0-vs-2.1.md) to help determine if any will impact existing projects built on .NET Core 2.0.
