# Commits to .NET Core 2.1.1

This is a somewhat curated list of commits across the entire .NET Core 2.1.1 development cycle. Working on automation to scrub out the uninteresting listings but there is still a bit of noise. Will be working to make that process better in future releases.

* [CLI](#cli)
* [CoreCLR](#coreclr)
* [CoreFX](#corefx)
* [WCF](#wcf)
* [ASP](#asp)

## CLI

* [`[4050c6374]`](https://github.com/dotnet/cli/commit/4050c6374) The "pack" command under 'buildCrossTargeting' for 'Microsoft.DotNet.MSBuildSdkResolver' now throws a "NU5104" warning/error because the SDK stage0 was changed to "2.1.300" [change was intended].
* [`[ea539c7f6]`](https://github.com/dotnet/cli/commit/ea539c7f6) Add retry when Directory.Move (#9313)

## CoreCLR

* [`[13ea3c2c8e]`](https://github.com/dotnet/coreclr/commit/13ea3c2c8e) Fix alternate stack for Alpine docker on SELinux (#17936) (#17975)
* [`[88db627a97]`](https://github.com/dotnet/coreclr/commit/88db627a97) Update g_highest_address and g_lowest_address in StompWriteBarrier(WriteBarrierOp::StompResize) on ARM (#18107)
* [`[0ea5fc4456]`](https://github.com/dotnet/coreclr/commit/0ea5fc4456) Use sysconf(_SC_NPROCESSORS_CONF) instead of sysconf(_SC_NPROCESSORS_ONLN) in PAL and GC on ARM and ARM64

## CoreFX

* [`[3700c5b793]`](https://github.com/dotnet/corefx/commit/3700c5b793) Update to a xUnit Performance Api that has a bigger Etw buffer size. … (#30328)
* [`[6b38470265]`](https://github.com/dotnet/corefx/commit/6b38470265) Use \_SC_NPROCESSORS_CONF instead of \_SC_NPROCESSORS_ONLN in Unix_ProcessorCountTest on ARM/ARM64 (#30132)
* [`[fe653a068c]`](https://github.com/dotnet/corefx/commit/fe653a068c) check SwitchingProtocol before ContentLength (#29948) (#29993)
* [`[f11f3e1fcf]`](https://github.com/dotnet/corefx/commit/f11f3e1fcf) Fix handling of cursor position when other ESC sequences already in stdin (#29897) (#29923)
* [`[77a4a19622]`](https://github.com/dotnet/corefx/commit/77a4a19622) [release/2.1] Port nano test fixes (#29995)
* [`[7ce9270ac7]`](https://github.com/dotnet/corefx/commit/7ce9270ac7) Fix Sockets hang caused by concurrent Socket disposal (#29786) (#29846)
* [`[ed23f5391f]`](https://github.com/dotnet/corefx/commit/ed23f5391f) Fix terminfo number reading with 32-bit integers (#29655) (#29765)
* [`[1c34018f14]`](https://github.com/dotnet/corefx/commit/1c34018f14) Fix getting attributes for sharing violation files (#29790) (#29832)
* [`[bc71849976]`](https://github.com/dotnet/corefx/commit/bc71849976) [release/2.1] Fix deadlock when waiting for process exit in Console.CancelKeyPress (#29749)
* [`[adc1c4d0d5]`](https://github.com/dotnet/corefx/commit/adc1c4d0d5) Fix WebSocket split UTF8 read #29834 (#29840) (#29853)

## WCF

* [`[0a99dd88]`](https://github.com/dotnet/wcf/commit/0a99dd88) Add net461 as a supported framework for S.SM.Security.
* [`[45855085]`](https://github.com/dotnet/wcf/commit/45855085) Generate ThisAssembly.cs, update the version and links for svcutil.xmlserializer (#2893)
* [`[68457365]`](https://github.com/dotnet/wcf/commit/68457365) Target svcutil.xmlserializer app at dotnetcore. (#2855)

## ASP

### Entity Framework

* [`[5bf9cc37]`](https://github.com/aspnet/EntityFrameworkCore/commit/5bf9cc370699f86e3609c183b3b23bfe2e3b1b23) Adds recursion guards to analyzer. [(#12054)](https://github.com/aspnet/EntityFrameworkCore/issues/12054)
* [`[ef61273e]`](https://github.com/aspnet/EntityFrameworkCore/pull/12164/commits/ef61273ed948a2be8f0a081dc57b16ad3bc2de03) Allow overriding query types found by convention. [(#12119)](https://github.com/aspnet/EntityFrameworkCore/issues/12119)
* [`[1d447bdb]`](https://github.com/aspnet/EntityFrameworkCore/commit/1d447bdb0a550c52a04dcbd2cbc1200faa837686) SqlServer RevEng: Use concat operators instead of function[(#11932)](https://github.com/aspnet/EntityFrameworkCore/issues/11932)

### Kestrel

* [`[c6f1dbf3]`](https://github.com/aspnet/KestrelHttpServer/pull/2578/commits/c6f1dbf37840dfb7d0e46ec4907c87a7b27e60ea) Fix Json perf regression in Socket Transport [(#2578)](https://github.com/aspnet/KestrelHttpServer/issues/2578)
* [`[448ece73]`](https://github.com/aspnet/KestrelHttpServer/pull/2622/commits/448ece73cc670a75faec18eaf9d4cc3403a22222) Add Memory<byte> overloads to HttpUpgradeStream
* [`[28a7dbf6]`](https://github.com/aspnet/KestrelHttpServer/pull/2618/commits/28a7dbf6f13ff9611d6cb23fdeb227776823f714) Use correct TaskCompletionSource ctor
* [`[4d276baa]`](https://github.com/aspnet/KestrelHttpServer/pull/2614/commits/4d276baa6f5dcef8215ff3042c73f62ac09a806c) Lower severity of AuthenticationException logs from SslStream handshake
* [`[340eaf68]`](https://github.com/aspnet/KestrelHttpServer/pull/2623/commits/340eaf6831ce906145ad9f839185481e5cdea329) Provide clearer exception message for breaking change

### MVC

* [`[2d636696]`](https://github.com/aspnet/Mvc/commit/2d63669695379d7da9c92653c24c8c626df02dad) ApiBehaviorApplicationModelProvider overwrites existing BindingInfo in entirety when inferring binding sources [(#7609)](https://github.com/aspnet/Mvc/issues/7609)
* [`[624a5ed5]`](https://github.com/aspnet/Mvc/commit/624a5ed522e8e32a97fb1ba61e25d2302a5abfed) XmlSerializerOutputFormatter throws InvalidCastException on async method [(#7782)](https://github.com/aspnet/Mvc/issues/7782)

### SignalR

* [`[5d37d312]`](https://github.com/aspnet/SignalR/commit/5d37d312e043c73a5f6d1db2c1e57a1c1280fb46) Add Content-Type header in HttpClient.ts [(#2412)](https://github.com/aspnet/SignalR/issues/2412)
* [`[c976d0aa]`](https://github.com/aspnet/SignalR/commit/c976d0aa6ed4c77574aa49a46a178008a0cb1636) Gracefully handle disposing while writing [(#2341)](https://github.com/aspnet/SignalR/issues/2341)
* [`[3fa10f92]`](https://github.com/aspnet/SignalR/commit/3fa10f92adf8be2c3c390ed78251143f82c0745c) Fix losing UTC DateTimeKind on ISO8601 UTC values [(#2339)](https://github.com/aspnet/SignalR/issues/2339)
* [`[0452f460]`](https://github.com/aspnet/SignalR/commit/0452f460c65b7de2806f12bea44c615b229534f5) Fix not reading to end of argument JSON on binding error [(#2336)](https://github.com/aspnet/SignalR/issues/2336)
* [`[adc1c4d0]`](https://github.com/dotnet/corefx/commit/adc1c4d0d5d7886d63b3372559cb2f5cf942ffd9) Fix WebSocket split UTF8 read [(#2349)](https://github.com/aspnet/SignalR/issues/2349)

### Templating

* [`[9e17d93a]`](https://github.com/aspnet/templating/commit/9e17d93acf4cc9eebc12560ff55e6027b2c5ba87) Remove obsolete reference in Angular template home. [(#470)](https://github.com/aspnet/templating/issues/470)
* [`[c6b50011]`](https://github.com/aspnet/templating/commit/c6b5001149fb39e2d030f564385ebd05b5de6f2d) Remove reference to Microsoft.AspNetCore.Mvc.Razor.ViewCompilation from desktop templates [(#531)](https://github.com/aspnet/templating/issues/531)
* [`[74883b2c]`](https://github.com/aspnet/templating/commit/74883b2cf035ae0a05d99cc125ce352eade66d40) Windows authentication is not applied on launchSettings.json [(#528)](https://github.com/aspnet/templating/issues/528)
* [`[a5fb8a3d]`](https://github.com/aspnet/templating/pull/543/commits/a5fb8a3d3cb582ca4fadf71098a3b1bc16ed5a18) Fix the jquery.min.js file in RazorPages web application [(#525)](https://github.com/aspnet/templating/issues/525)

### Other

* [`[cdbcfb7a]`](https://github.com/aspnet/Razor/commit/cdbcfb7a05db42f33c27aff0dcffa76735db13e7) Fixup references to versions in vsix [(#2363)](https://github.com/aspnet/Razor/issues/2363)
* [`[9e595f7b]`](https://github.com/aspnet/websdk/commit/9e595f7b78ff0b0bee35ad47d7af417adee8b7b7) Update implicit versioning logic for patches [(#344)](https://github.com/aspnet/websdk/issues/344)
