# .NET Core 2.1.1 Known Issues

This document lists known issues for **.NET Core 2.1.1** which may be encountered during usage.

## Offline restore is broken in .NET Core SDK 2.1.301 ([aspnet/1220](https://github.com/aspnet/Universe/issues/1220))

### Workaround

There are 2 workarounds to resolve this situation

1. Perform an online restore to obtain Microsoft.NETCore.App 2.1.0 from nuget.org before attempting to work offline.
2. Set `RuntimeFrameworkVersion` to 2.1.1. This will prevent nuget from trying to go online, and will allow the app to build and run locally but deployment to a machine that doesn’t have 2.1.1 runtime installed will fail.

## Installing on SLES 12 SP3 reports `krb5-mini` dependency is missing ([core-setup/4262](https://github.com/dotnet/core-setup/issues/4262))

``` bash
> sudo zypper install dotnet-sdk-2.1
Refreshing service 'cloud_update'.
Loading repository data...
Reading installed packages...
Resolving package dependencies...
 
Problem: nothing provides krb5-mini needed by dotnet-runtime-deps-2.1-2.1.1-1.x86_64
Solution 1: do not install dotnet-sdk-2.1-2.1.301-1.x86_64
Solution 2: break dotnet-runtime-deps-2.1-2.1.1-1.x86_64 by ignoring some of its dependencies
 
Choose from above solutions by number or cancel [1/2/c] (c):
```

krb5 is generally installed by default. This can be confirmed with the following.

``` bash
> zypper search krb5
Loading repository data...
Reading installed packages...
 
S  | Name            | Summary                                        | Type
---+-----------------+------------------------------------------------+--------
i  | krb5            | MIT Kerberos5 Implementation--Libraries        | package
i+ | krb5-client     | MIT Kerberos5 implementation - client programs | package
i  | libndr-krb5pac0 | NDR marshallers for the KRB5 PAC formats       | package
```

If it is not installed, run `zypper install krb5-client`, then install dotnet core. When presented with the missing dependency prompt, choose 'Solution 2' to continue with the installation.

## Previous known issues fixed in this release

[[Fixed]](https://github.com/dotnet/coreclr/pull/17975) - [coreclr/17931](https://github.com/dotnet/coreclr/issues/17931) and [dotnet-docker/561](https://github.com/dotnet/dotnet-docker/issues/561)

Using Alpine docker image from system w/ SELinux execheap enforcement triggers segfault.

This issue will be fixed in the first update for 2.1.

[[Fixed]](https://github.com/dotnet/cli/pull/9313) - [cli/9289](https://github.com/dotnet/cli/issues/9289)

Using `dotnet install` or `dotnet uninstall` to manage Global Tools sometimes results in an `access denied` error. This occurs because another process, like an indexer, has not released a handle on the Global Tools files.

### Workaround

**Global Tools created with .NET Core SDK 2.1.300 Preview 1 are not compatible with later versions.**

Also: Ensure that global.json does not pin to .NET Core SDK 2.1.300 Preview 1 on either for a  directory where you are developing global tools or a directory from which you are installing global tools.

*Workaround* - Manually remove these tools.
